 
#include "mbed.h"
#include "Gen.h"
#include <LCD43PCT.h>
        
// 4D Systems uLCD-43PTC DEFAULT BAUD RATE: 9600bps
//It shoud be used like this : LCD43PCT lcd(p13,p14,p15); for serial communication with LCD43PCT
LCD43PCT::LCD43PCT(PinName TXPin, PinName RXPin, PinName resetPin): _serialLCD43PCT(TXPin,RXPin), _resetPin(resetPin){    
    init();
}

/********** high level commands, for the user! */
void LCD43PCT::init(){         //configure the mbed for LCD43PCT board    
    _serialLCD43PCT.baud(9600);
    _resetPin=1;               //set the pin to 3.3v to avoid reset 
}
 
void LCD43PCT::reset(){        //Reset the LCD43PCT board
    _resetPin=0;               //set the pin to GND to reset 
    wait_ms(1);
    _resetPin=1;               //set the pin to 3.3v to end reset
    wait_ms(1000);    
}

unsigned char LCD43PCT::start(){           //Init the LCD43PCT
  _serialLCD43PCT.putc('U');  
  wait_ms(1000);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::erase(){          //Erase the LCD43PCT screen
  _serialLCD43PCT.putc('E');  
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::sleep(unsigned char mode){       //Send LCD43PCT to sleep mode
  _serialLCD43PCT.putc('Z'); 
  _serialLCD43PCT.putc(mode);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::orientation(unsigned char side){       //Change display orientation
  _serialLCD43PCT.putc('O'); 
  _serialLCD43PCT.putc(side);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::bright(unsigned char val){       //Change display brightness
  _serialLCD43PCT.putc('V'); 
  _serialLCD43PCT.putc(val); 
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::baudChange(unsigned long val){       //Change baud rate of arduino and LCD43PCT board
  unsigned char aux;
 
  switch(val){
    case 9600:
      aux=6;
    break;
    case 19200:
      aux=8;
    break;
    case 57600:
      aux=122;
    break;
    case 115200:
      aux=13;
    break;
    case 256000:
      aux=15;
    break;    
    case 38400:
      aux=10;
    break;
    case 56000:
      aux=11;
    break;
    case 128000:
      aux=14;
    break;
    default:
      return '\x15';
  } 
  _serialLCD43PCT.putc('\x51');  // SetBaud(rate)
  _serialLCD43PCT.putc(aux);  
  aux=_serialLCD43PCT.getc();
  if(aux=='\x06'){
    wait_ms(150);
    _serialLCD43PCT.baud(val);
    wait_ms(200);
    return aux-'\x06';
  }else{
    return aux-'\x06';
  }
}

unsigned char LCD43PCT::digitalOut(unsigned char number, unsigned char val ){       //Set Digital out pins to a logic value
  _serialLCD43PCT.putc('y'); 
  _serialLCD43PCT.putc(number);
  _serialLCD43PCT.putc(val); 
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::setScreenBackground(int colour){       //Change the default screen background colour for erase function
  _serialLCD43PCT.putc('B'); 
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);  
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::setTextBackground(int colour){       //Set the default text background colour for letters and strings
  _serialLCD43PCT.putc('K'); 
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);  
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::ReadPixel(int x1, int y1, char buffer[]){ //Read the internal memory of the LCD43PCT, This command returns 16bit pixels (2 bytes)
  
  _serialLCD43PCT.putc('M'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);

  //receive the pixels
  buffer[0]=_serialLCD43PCT.getc(); //Red,Green
  buffer[1]=_serialLCD43PCT.getc(); //Green,Blue
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::putPixel(int x, int y, int colour){       //Draw a pixel on the screen
  _serialLCD43PCT.putc('P'); 
  _serialLCD43PCT.putc(x>>8); 
  _serialLCD43PCT.putc(x);
  _serialLCD43PCT.putc(y>>8);
  _serialLCD43PCT.putc(y);
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::drawLine(int x1, int y1, int x2, int y2, int colour){       //Draw a line on the screen
  _serialLCD43PCT.putc('L'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc(x2>>8); 
  _serialLCD43PCT.putc(x2);
  _serialLCD43PCT.putc(y2>>8);
  _serialLCD43PCT.putc(y2);  
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::drawRectangle(int x1, int y1, int x2, int y2, int colour, unsigned char fill){       //Draw a rectangle on the screen
  _serialLCD43PCT.putc('p');  
  _serialLCD43PCT.putc(fill);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set pensize command fail

  _serialLCD43PCT.putc('r'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc(x2>>8); 
  _serialLCD43PCT.putc(x2);
  _serialLCD43PCT.putc(y2>>8);
  _serialLCD43PCT.putc(y2);  
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colour, unsigned char fill){       //Draw a triangle on the screen
  _serialLCD43PCT.putc('p');  
  _serialLCD43PCT.putc(fill);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set pensize command fail

  _serialLCD43PCT.putc('G'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc(x2>>8); 
  _serialLCD43PCT.putc(x2);
  _serialLCD43PCT.putc(y2>>8);
  _serialLCD43PCT.putc(y2);  
  _serialLCD43PCT.putc(x3>>8); 
  _serialLCD43PCT.putc(x3);
  _serialLCD43PCT.putc(y3>>8);
  _serialLCD43PCT.putc(y3);    
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::drawCircle(int x, int y, int radius, int colour, unsigned char fill){       //Draw a circle on the screen
  _serialLCD43PCT.putc('p');  
  _serialLCD43PCT.putc(fill);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set pensize command fail

  _serialLCD43PCT.putc('C'); 
  _serialLCD43PCT.putc(x>>8); 
  _serialLCD43PCT.putc(x);
  _serialLCD43PCT.putc(y>>8);
  _serialLCD43PCT.putc(y);
  _serialLCD43PCT.putc(radius>>8);
  _serialLCD43PCT.putc(radius);
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::putLetter(int x, int y, int colour, unsigned char font, unsigned char fill, unsigned char letter){       //Draw a letter on the screen
  _serialLCD43PCT.putc('O');  
  _serialLCD43PCT.putc(fill);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set pensize command fail

  _serialLCD43PCT.putc('F');  
  _serialLCD43PCT.putc(font);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set font size command fail

  _serialLCD43PCT.putc('t'); 
  _serialLCD43PCT.putc(letter);  
  _serialLCD43PCT.putc(x>>8); 
  _serialLCD43PCT.putc(x);
  _serialLCD43PCT.putc(y>>8);
  _serialLCD43PCT.putc(y);
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  _serialLCD43PCT.putc(1); // x size
  _serialLCD43PCT.putc(1); //y size
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::string(int x1, int y1, int x2, int y2, int colour, unsigned char font, unsigned char fill, char text[]){       //Draw a string on the screen
  int counter=0;
  _serialLCD43PCT.putc('O');  
  _serialLCD43PCT.putc(fill);   
  if (_serialLCD43PCT.getc() - '\x06') return 1; //set pensize command fail

  _serialLCD43PCT.putc('S'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc(font);   
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  _serialLCD43PCT.putc(1); //x size
  _serialLCD43PCT.putc(1); //y size
  while(1){
    _serialLCD43PCT.putc(text[counter]);
    if(text[counter]==0x00){
      break;
    }    
    counter++;
  } 
  return _serialLCD43PCT.getc() - '\x06';
}

unsigned char LCD43PCT::stringSD(int x1, int y1, int x2, int y2, int colour, unsigned char font, unsigned char fill, int BS, int BR, char name[]){       //Draw a String from a text file contained on the micro SD card on the screen
  unsigned char counter=0;
  
  _serialLCD43PCT.putc('S'); 
  _serialLCD43PCT.putc('S'); //from SD
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc(x2>>8); 
  _serialLCD43PCT.putc(x2);
  _serialLCD43PCT.putc(y2>>8);
  _serialLCD43PCT.putc(y2);  
  _serialLCD43PCT.putc(colour>>8);
  _serialLCD43PCT.putc(colour);
  _serialLCD43PCT.putc(font); 
  _serialLCD43PCT.putc(fill); 
  _serialLCD43PCT.putc(BS>>8);
  _serialLCD43PCT.putc(BS);  
  _serialLCD43PCT.putc(BR>>8);
  _serialLCD43PCT.putc(BR);  
  while(1){
    _serialLCD43PCT.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialLCD43PCT.getc();
}

unsigned char LCD43PCT::icon(int x1, int y1, int x2, int y2, char icon[]){            //Send and image or icon pixel by pixel to LCD43PCT, 16bit(2 bytes) each pixel RGB565
  unsigned int i,j,k=0; 
  
  _serialLCD43PCT.putc('I'); 
  _serialLCD43PCT.putc(x1>>8); 
  _serialLCD43PCT.putc(x1);
  _serialLCD43PCT.putc(y1>>8);
  _serialLCD43PCT.putc(y1);
  _serialLCD43PCT.putc((x2-x1)>>8); 
  _serialLCD43PCT.putc(x2-x1);
  _serialLCD43PCT.putc((y2-y1)>>8);
  _serialLCD43PCT.putc(y2-y1);
  _serialLCD43PCT.putc('\x10'); //colour mode 16 bit
  
  //Send icon buffer pixel by pixel
  for(j=0;j<=(y2-y1);j++){
    for(i=0;i<=(x2-x1);i++){
        _serialLCD43PCT.putc(icon[k]);
        k++;
    }
  } 
  return _serialLCD43PCT.getc() - '\x06';  
}

unsigned char LCD43PCT::imageSD(int x, int y, char name[]){        //Draw an Image contained on the micro SD card on the screen, top left corner coordinates
  unsigned char counter=0;
  
  _serialLCD43PCT.putc('I'); 
  _serialLCD43PCT.putc('S'); //from SD
  _serialLCD43PCT.putc(x>>8); 
  _serialLCD43PCT.putc(x);
  _serialLCD43PCT.putc(y>>8);
  _serialLCD43PCT.putc(y);
  while(1){
    _serialLCD43PCT.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialLCD43PCT.getc();
}

unsigned char LCD43PCT::touchScreen(int buffer[]){          //Ask for a touch on the screen, if return=1, touch coordinates are stored on the buffer[]
  
  _serialLCD43PCT.putc('Y'); // display control function
  _serialLCD43PCT.putc('\x05'); // enable Touch
  _serialLCD43PCT.putc('\x00');
//  sr.printf("touch  ");
  buffer[0]=_serialLCD43PCT.getc();
//  sr.printf("%02X  ",buffer[0]);
  

  _serialLCD43PCT.putc('o');
  _serialLCD43PCT.putc('\x04');
  buffer[0]=_serialLCD43PCT.getc();
  buffer[0]=buffer[0]<<8;
  buffer[0]|=_serialLCD43PCT.getc();
  buffer[1]=_serialLCD43PCT.getc();
  buffer[1]=buffer[1]<<8;
  buffer[1]|=_serialLCD43PCT.getc();
  if(buffer[0] !=  0){
  sr.printf("%04X  ",int(buffer[1]));
      _serialLCD43PCT.putc('o');
      _serialLCD43PCT.putc('\x05');
      buffer[0]=_serialLCD43PCT.getc();
      buffer[0]=buffer[0]<<8;
      buffer[0]|=_serialLCD43PCT.getc();
      buffer[1]=_serialLCD43PCT.getc();
      buffer[1]=buffer[1]<<8;
      buffer[1]|=_serialLCD43PCT.getc();
      sr.printf("%04X %04X  ",int(buffer[1]),int(buffer[3]));
    return 1;
  }else{
    return 0;
  }
}

unsigned char LCD43PCT::touchIcon(char buffer[]){          //Ask for a touch on the icons of the screen, if return=1, icon name is stored on the buffer[]
  
  _serialLCD43PCT.putc('G');
  buffer[0]=_serialLCD43PCT.getc();
  buffer[1]=_serialLCD43PCT.getc();
  buffer[2]=_serialLCD43PCT.getc();
  buffer[3]=_serialLCD43PCT.getc();
  _serialLCD43PCT.getc();  
  if(!(buffer[0]<0x02) & (buffer[0]!=0x4E)){
    return 1;
  }else{
    return 0;
  }
}
