
#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MMA8491Q.h"
#include "MAG3110.h"
#include "MPL3115A2.h"
#include <cstdlib>
#include <iostream>

//#define MMA8451_I2C_ADDRESS (0x1d<<1)
//#define MMA8491_I2C_ADDRESS (0x55<<1)
//#define MPL3115A2_I2C_ADDRESS (0x60<<1)
//#define MAG3110_I2C_ADDRESS (0x0E<<1)

Serial pc(USBTX, USBRX);

TSISensor tsi;
MMA8451Q acc51(PTE25, PTE24, 0x1D<<1);
MMA8491Q acc91(PTE0, PTE1, 0x55<<1);
MAG3110 mag(PTE0, PTE1, 0x0E<<1);
MPL3115A2 mpl(PTE0, PTE1, 0x60<<1);

PwmOut rled(LED_RED);
PwmOut gled(LED_GREEN);
PwmOut bled(LED_BLUE);

DigitalOut enMMA8491(PTA13);

InterruptIn intMPL3115(PTD3);
InterruptIn intMAG3110(PTD1);

DigitalIn acc91X(PTD2);
DigitalIn acc91Y(PTD0);
DigitalIn acc91Z(PTD5);


int main()
{
    using namespace std;
    
    float onTime = 1.0;
    float offTime = 0.0;
    float holdTime = 1.0;
    bool on = true;
    bool off = false;
    int magX = 0, magY = 0, magZ = 0;
    float mplAlt = .0, mplPres = .0, mplTemp = .0;
    mpl.Altimeter_Mode();
    
    while(true) {
        enMMA8491 = on;
                
        rled = onTime - abs(acc51.getAccX());
        gled = onTime - abs(acc51.getAccY());
        bled = onTime - abs(acc51.getAccZ());
        mag.getValues(&magX, &magY, &magZ);
        mplAlt = mpl.getAltimeter();
        mplTemp = mpl.getTemperature();
        
        cout << "MMA8451: " << acc51.getAccX() << "\t" << acc51.getAccY() << "\t" << acc51.getAccZ() << "\n\r" << endl;
        cout << "MMA8491: " << acc91X << "\t" << acc91Y << "\t" << acc91Z << "\n\r" << endl;
        cout << "MMA8491: " << acc91.getAccX() << "\t" << acc91.getAccY() << "\t" << acc91.getAccZ() << "\n\r" << endl;
        cout << "MAG3110: " << magX << "\t" << magY << "\t" << magZ << "\n\r" << endl;
        mpl.Barometric_Mode();
        wait(holdTime);

        enMMA8491 = off;
        
        rled = tsi.readPercentage();
        gled = tsi.readPercentage();
        bled = tsi.readPercentage();
        mplPres = mpl.getPressure();
        
        cout << "Touch: " << tsi.readPercentage() << "\n\r" << endl;
        cout << "MPL3115: " << mplAlt << "\t" << mplPres << "\t" << mplTemp << "\n\r" << endl;
        mpl.Altimeter_Mode();
        wait(holdTime);
    }
    return 0;
}
