#include "mbed.h"
#include "NokiaLCD_SWSPI.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"

TSISensor tsi;
MMA8451Q acc(PTE25, PTE24, 0x1D<<1);
MAG3110 mag(PTE25, PTE24, 0x0E<<1);
NokiaLCD_SWSPI lcd(D11, D12, D13, D9, D8, NokiaLCD_SWSPI::PCF8833);
DigitalOut led(LED2);
AnalogIn lightSensor(PTE22);
InterruptIn s1(PTC3);
InterruptIn s3(PTC12);


int main() {

    float onTime = 1.0;
    float holdTime = 1.0;
    float light = .0;
    int magX = 0, magY = 0, magZ = 0;
    
    mag.begin();

    while(1) {
        led = onTime - abs(acc.getAccX());
        mag.getValues(&magX, &magY, &magZ);

        lcd.printf("MMA8451Q: X=%3.2f Y=%3.2f Z=%3.2f", acc.getAccX(), acc.getAccY(), acc.getAccZ());
        lcd.printf("MAG3110: %4.0f", mag.getHeading()); 
        wait(holdTime);

        led = tsi.readPercentage();
        light = lightSensor;

        lcd.printf("Touch: %3.2f", tsi.readPercentage());
        lcd.printf("LightSensor: %3.2f", light);
        wait(holdTime);
    }
}
