#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include <cstdlib>
#include <iostream>
#include <cstring>

Serial pc(USBTX, USBRX);

TSISensor tsi;
MMA8451Q acc(PTE25, PTE24, 0x1D<<1);
MAG3110 mag(PTE25, PTE24, 0x0E<<1);
SLCD lcd;

PwmOut rled(PTE29);
PwmOut gled(PTD5);
AnalogIn lightSensor(PTE22);
InterruptIn s1(PTC3);
InterruptIn s3(PTC12);


int main()
{
    using namespace std;

    float onTime = 1.0;
 //   float offTime = 0.0;
    float holdTime = 1.0;
    int magX = 0, magY = 0, magZ = 0;
    char lcdMessage[40];

    while(1) {

        rled = onTime - abs(acc.getAccX());
        gled = onTime - abs(acc.getAccY());
        mag.getValues(&magX, &magY, &magZ);

        cout << "MMA8451: " << acc.getAccX() << "\t" << acc.getAccY() << "\t" << acc.getAccZ() << "\n\r" << endl;
        cout << "MAG3110: " << magX << "\t" << magY << "\t" << magZ << "\n\r" << endl;
        cout << "MAG3110: " << mag.getHeading() << "\n\r" << endl;
        //lcd.All_Segments(1);
        sprintf(lcdMessage, "%4.0f", mag.getHeading());
        lcd.printf(lcdMessage);
        wait(holdTime);

        rled = tsi.readPercentage();
        gled = tsi.readPercentage();

        cout << "Touch: " << tsi.readPercentage() << "\n\r" << endl;
        cout << "SW1: " << s1 << "\n\r" << endl;
        cout << "SW3: " << s3 << "\n\r" << endl;
        cout << "Light Sensor: " << lightSensor << "\n\r" << endl;
        //lcd.All_Segments(0);
        lcd.printf(lcdMessage);
        wait(holdTime);
    }
}
