//Code Designed to display run-time variables from a Megasquirt Fuel Injection controller.
//This is the base code to load variables and print to DigoleSerialDisp and write them to a file.  File format is .FRD for import into EFI Analytics tuner Studio

#include "mbed.h"
//#include "TextDigoleSerialDisp.h"
#include "SDFileSystem.h"
#include "SerialBuffered.h"
//#include "LIS302.h"


//SD Card pin assignment
SDFileSystem sd(p11, p12, p13, p14, "sd");//DI, D0, SCK, CS

AnalogIn SDenable(p20);//define SD card switch
DigitalOut myled1(LED1);//define LED
Serial loggerSerial(USBTX, USBRX);
Timer t;

LocalFileSystem local("local");



//Serial usb(USBTX, USBRX); //define USB connection pins
SerialBuffered megasquirt(120, p28, p27);  // that 128 is the size of the read buffer it will make for you

Serial DigoleSerialDisp(p9, p10);//UART DigoleSerialDisp(PinName TX, PinName RX);

DigitalOut usb_activity(LED1); //define USB activity
DigitalOut megasquirt_activity(LED2); //define Megasquirt activity
unsigned char      tmp_data[16];
unsigned char       buf[120];
int tmp;
float Time;
long float SecL; //get secoonds
long float        PW;//get pulseWidth1
long float        PW2; //get pulseWidth2
int        RPM; //get Rpm
float DutyCycle; //Injector Duty Cycle
float DutyCycle2; //Injector Bank2 Duty  Cycle
long float        SparkAdv; //get advance
float        squirt; //get squirt
float        Engine; //get squirt
float       afrtgt1; //get AFR target - Table 1
float        afrtgt2; //get AFR target - Table 2
float        wbo2_en1; //get WideBand Valid1
float        wbo2_en2; //get WideBand Valid2
long float       barometer; //get Barometer
long float        MAP; //get manifold absolute pressure MAP
long float        MAT; //get manifold absolute temperature (MAT)
long float      CLT; //get coolant temperature (CLT)
long float        TP; //get Throttle Position Sensor (TPS)
long float        vBatt; //get BAttery Voltage
long float        AFR; //get Realtime AFR for VE1
long float        AFR2; //get Realtime AFR for VE2
long float        knock; //get Knock Threshold Value
long float       Gego; //get egoCorrrection1 amount %
long float        Gego2; //get egoCorrrection2 amount %
long float       Gair; //get air correction (G_air)
long float        Gwarmup; //get Warmup Enrichment
long float        TPSacc; //get accel enrichment (ms)
long float        TPScut; //get TPS based fuel cut %
long float       Gbaro; //get baroCorrection %
long float       Gammae; //get gammaEnrich %
long float        veCurr1; //get Current VE value Table 1
long float        veCurr2; //get Current VE value Table 2
long float        IAC; //get IAC Step %
long float        ColdAdv; //get Cold Ignition Advance
long float       tpsDOT;    //get Rate of Change TPS
long float        mapDOT;  //get Rate of Change MAP
long float        Dwell; //get Ignition Dwell
long float        maf; //get MAF - Mass Air Flow
long float       fuelload; //get MAP/TPS Blend %
long float        Ethanol; //get fuel load percent alchohol
char                portstatus; //get Spare Port Status
char        knockRetard; //get Knock timing retard (deg)
long float        EAEFuelCorr; //get EAE Fuel correction
long float        egoV; //get egoV
long float        egoV2; //get egoV2
char        status1; //get Status1
char        status2; //get Status2
char        status3; //get Status3
char        status4; //get Status4
long float        looptime; //get looptime
char        status5; //get Status5
long float        tpsADC; //get tpsADC
long float        fuelload2; //get fuelload2
long float        ignload; //get ignload
long float        ignload2; //get ignload2
char        syncstatus; //get Sync-Status (0 - sync-error, 1 - syncstatus)
float        deltaT; //get deltaT
long float        wallfuel; //get wallfuel

int runtime;


unsigned char data_out;
int n;
int row;
int column;
int i;
char MSII_288Header[] = {0x46,0x52,0x44,0x00,0x00,0x00,0x00,0x01,0x4b,0x61,0xf1,0x63,0x4d,0x53,0x49,0x49,0x20,0x52,0x65,0x76,0x20,0x32,0x2e,0x38,0x38,0x30,0x30,0x30,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x51,0x00,0x70};//file header
char MSIIExtraHeader[] = {0x46,0x52,0x44,0x00,0x00,0x00,0x00,0x01,0x4b,0x6a,0xf3,0xa8,0x4d,0x53,0x32,0x45,0x78,0x74,0x72,0x61,0x20,0x52,0x65,0x6c,0x20,0x32,0x2e,0x31,0x2e,0x31,0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x51,0x00,0x91};
char parse_header[] = {0x01,0x00};//data header


/*DigoleSerialDisp 2x20 parallel code pin assignment*/
//TextDigoleSerialDisp DigoleSerialDisp(p21, p22, p23, p24, p25, p26, p30, 20, 2); // (rs, rw, e, d0, d1, d2, d3, n_column, n_rows)
//define file write
//AnalogIn file_writeenable(p20);//define SD card switch


//enter main loop
int main() {


  DigoleSerialDisp.baud(9600);//set Digole Serial Baud Rate
//    unsigned char tmp;
//    unsigned char data_in;

/////Startup Screen////////////
DigoleSerialDisp.printf("CL\r");//clear screen
//DigoleSerialDisp.init_Display();
//DigitalOut myled(LED1);
DigoleSerialDisp.printf("  DashView V2.1  ");
wait(3);
DigoleSerialDisp.printf("CL\r");//clear screen
DigoleSerialDisp.printf("SD3\r\n");//set rotation 0=0deg,1=90deg,2=180deg,3=270deg
DigoleSerialDisp.printf("TRT");//offset Line 1 in housing
DigoleSerialDisp.printf("SF3\rTT Have a great drive\r\n");
DigoleSerialDisp.printf("TRT");//next line

////////////End Startup Screen//////////
    megasquirt.baud(115200); //define MEgasquirt serial speed
    loggerSerial.baud(115200); //define USB connection speed
/*
//file header setup
    FILE *fp = fopen("/sd/datalog.csv", "a");
    //print header for MS.csv file
    fprintf(fp, "MSII Rev 2.88000, \nTime,SecL,RPM,MAP,TP,vBatt,AFR,MAT,CLT,Engine,Gego,Gair,Gwarm,Gbaro,Gammae,TPSacc,PW,DutyCycle,PW2,DutyCycle2,SparkAdv,ColdAdv,Dwell,tpsDOT,mapDOT,IAC,deltaT,Ethanol%,\n");

    fclose(fp);
*/
    t.start();

    while (1) {

//        char c = loggerSerial.getc();
        //temporary call function using keyboard - in future will trigger automatically.
//        if ((c == 'a'))
//       {
        //DigoleSerialDisp.printf(" "); //print space for data output format
        //poll serial device for data stream (a,0,6) to (request, return, confirm)
        megasquirt.putc(97);//send 97 for run parameters, 83 for board revision, 81 code for revision number
        wait(0.005);
        megasquirt.putc(0);
        wait(0.005);
        megasquirt.putc(6);
        int actuallyRead = megasquirt.readBytes( buf, 112); // where 112 is the number of bytes you are expecting


//decodeMS();

        Time = t.read();

//void decodeMS() {

//get seconds
        tmp = buf[0];
        tmp = tmp << 8;
        SecL = tmp | buf[1];
        //MSseconds = MSseconds/256;
//get pulseWidth1
        tmp = buf[2];
        tmp = tmp << 8;
        tmp = tmp | buf[3];
        PW = tmp*0.000666;


//get pulseWidth2
        tmp = buf[4];
        tmp = tmp << 8;
        tmp = tmp | buf[5];
        PW2 = tmp*0.000666;
//get Rpm
        tmp = buf[6];
        tmp = tmp << 8;
        RPM = tmp | buf[7];

//Calculate DutyCycle
        DutyCycle = (PW * (RPM / 60)) / 10;

//Calculate DutyCycle2
        DutyCycle2 = (PW2 * (RPM / 60)) / 10;


//get advance
        tmp = buf[8];
        tmp = tmp << 8;
        tmp = tmp | buf[9];
        SparkAdv = tmp/10;
//get squirt
        squirt = buf[10];
//get engine
        Engine = buf[11];
//get AFR target - Table 1
        afrtgt1 = buf[12]*10;

//get AFR target - Table 2
        afrtgt2 = buf[13]*10;
//get WideBand Valid1
        wbo2_en1 = buf[14];
//get WideBand Valid2
        wbo2_en2 = buf[15];
//get Barometer
        tmp = buf[16];
        tmp = tmp << 8;
        tmp = tmp | buf[17];
        barometer = tmp/10;

//get manifold absolute pressure MAP
        tmp = buf[18];
        tmp = tmp << 8;
        MAP = tmp | buf[19];
        MAP = MAP/10;
//get manifold absolute temperature (MAT)
        tmp = buf[20];
        tmp = tmp << 8;
        MAT = tmp | buf[21];
       MAT = MAT/10; ///for Farenheit
        MAT = 0.555*(MAT - 32); //for Celcius
//get coolant temperature (CLT)
        tmp = buf[22];
        tmp = tmp << 8;
        CLT = tmp | buf[23];
        CLT = CLT/10;
        CLT = 0.555*(CLT - 32); //for Celcius
//get Throttle Position Sensor (TPS)
        tmp = buf[24];
        tmp = tmp << 8;
        TP = tmp | buf[25];
        TP = TP / 10;
//get BAttery Voltage
        tmp = buf[26];
        tmp = tmp << 8;
        vBatt = tmp | buf[27];
        vBatt = vBatt /10,
//get Realtime AFR for VE1
                tmp = buf[28];
        tmp = tmp  << 8;
        AFR = tmp | buf[29];
        AFR = AFR /10;
//get Realtime AFR for VE2
        tmp = buf[30];
        tmp  = tmp << 8;
        AFR2 = tmp  | buf[31];
        AFR2 = AFR2 / 10;


//get Knock Threshold Value
        tmp = buf[32];
        tmp = tmp << 8;
        knock = tmp | buf[33];
        knock = knock /10;
//get egoCorrrection1 amount %
        tmp = buf[34];
        tmp  = tmp  << 8;
        Gego = tmp | buf[35];
//get egoCorrrection2 amount %
        tmp = buf[36];
        tmp = tmp << 8;
        Gego2 = tmp | buf[37];
//get air correction (G_air)
        tmp = buf[38];
        tmp  = tmp << 8;
        Gair = tmp | buf[39];
//get Warmup Enrichment
        tmp = buf[40];
        tmp = tmp << 8;
        Gwarmup = tmp | buf[41];

//get accel enrichment (ms)
        tmp = buf[42];
        tmp = tmp << 8;
        TPSacc = tmp | buf[43];
        TPSacc = TPSacc/10;
//get TPS based fuel cut %
        tmp = buf[44];
        tmp = tmp << 8;
        TPScut = tmp | buf[45];
//get baroCorrection %
        tmp = buf[46];
        tmp = tmp << 8;
        Gbaro = tmp | buf[47];
//get gammaEnrich %
        tmp = buf[48];
        tmp = tmp << 8;
        Gammae = tmp | buf[49];

//get Current VE value Table 1
        tmp = buf[50];
        tmp  = tmp << 8;
        veCurr1 = tmp | buf[51];
        veCurr1 = veCurr1/10;
//get Current VE value Table 2
        tmp = buf[52];
        tmp  = tmp  << 8;
        veCurr2 = tmp  | buf[53];
        veCurr2 = veCurr2/10;
//get IAC Step %
        tmp = buf[54];
        tmp = tmp << 8;
        IAC = tmp | buf[55];
//get Cold Ignition Advance
        tmp = buf[56];
        tmp = tmp << 8;
        ColdAdv = tmp | buf[57];
        ColdAdv = ColdAdv/10;
//get Rate of Change TPS
        tmp = buf[58];
        tmp = tmp << 8;
        tpsDOT = tmp | buf[59];
        tpsDOT = tpsDOT/10;
//get Rate of Change MAP
        tmp = buf[60];
        tmp = tmp << 8;
        mapDOT = tmp | buf[67];
//get Ignition Dwell
        tmp = buf[62];
        tmp = tmp  << 8;
        Dwell = tmp | buf[63];
        Dwell = Dwell*0.6666;
//get MAF - Mass Air Flow
        tmp = buf[64];
        tmp = tmp << 8;
        maf = tmp | buf[65];
//get MAP/TPS Blend %
        tmp = buf[66];
        tmp = tmp << 8;
        fuelload = tmp | buf[67];
        fuelload = fuelload/10;
//get fuel load percent alchohol
        tmp = buf[68];
        tmp = tmp  << 8;
        Ethanol = tmp  | buf[69];

//get Spare Port Status
        portstatus = buf[70];
//get Knock timing retard (deg)
        knockRetard = buf[71];
        knockRetard = knockRetard/10;
//get EAE Fuel correction
        tmp = buf[72];
        tmp = tmp << 8;
        EAEFuelCorr  = tmp  | buf[73];

//get egoV
        tmp = buf[74];
        tmp = tmp  << 8;
        egoV = tmp  | buf[75];
        egoV = egoV/100;
//get egoV2
        tmp = buf[76];
        tmp = tmp << 8;
        egoV2 = tmp | buf[77];
        egoV2 = egoV2/100;
//get Status1
        status1 = buf[78];
//get Status2
        status2 = buf[79];
//get Status3
        status3 = buf[80];
//get Status4
        status4 = buf[81];
//get looptime
        tmp = buf[82];
        tmp = tmp << 8;
        looptime = tmp | buf[83];
        looptime = looptime*0.6667;
//get Status5
        status5 = buf[84];
//get tpsADC
        tmp = buf[85];
        tmp = tmp << 8;
        tpsADC = tmp | buf[86];
//get fuelload2
        tmp  = buf[87];
        tmp  = tmp  << 8;
        fuelload2 = tmp | buf[88];
//get ignload
        tmp = buf[89];
        tmp = tmp << 8;
        ignload = tmp | buf[90];
        ignload = ignload/100;
//get ignload2
        tmp = buf[91];
        tmp = tmp << 8;
        ignload2 = tmp  | buf[92];
        ignload2 = ignload2/100;
//get Sync-Status (0 - sync-error, 1 - syncstatus)
        syncstatus = buf[104];

//get deltaT
        tmp = buf[106];
        tmp = tmp  << 8;
        deltaT = tmp | buf[107];
//get wallfuel
        tmp = buf[110];
        tmp = tmp << 8;
        wallfuel = tmp  | buf[111];

///Display Parameters to DigoleSerialDisp///////////  
DigoleSerialDisp.printf("SF3\r\n");
DigoleSerialDisp.printf("SD3\r\n");//set rotation 0=0deg,1=90deg,2=180deg,3=270deg
DigoleSerialDisp.printf("TRT");//offset Line 1 in housing

        //DigoleSerialDisp.locate(0,1);
        DigoleSerialDisp.printf("TT Volt=%4.1f \r\nTRT TT AFR =%4.1f\r\n TRT TT MAT= %3.0f C\r\nTRT TT CLT= %3.0f C\r\nTRT",vBatt,AFR,MAT,CLT);
        DigoleSerialDisp.printf("TRT");//next line

        //DigoleSerialDisp.locate(0,0);
        //DigoleSerialDisp.printf("TT AFR =%4.1f\r\n", AFR);
        //DigoleSerialDisp.printf("TRT");//next line



//get manifold absolute temperature (MAT)
 /*
        //DigoleSerialDisp.locate(10,1);
        DigoleSerialDisp.printf("TT MAT= %3.0f C\r\n", MAT);
        DigoleSerialDisp.printf("TRT");//next line
        
//get Clt
       // CLT = 0.5555*(CLT - 32); //for Celcius  
        //DigoleSerialDisp.locate(10,0);
        DigoleSerialDisp.printf("TT CLT= %3.0f C\r\n", CLT);
        DigoleSerialDisp.printf("TRT");//next line
 */       
        DigoleSerialDisp.printf("CL\r");//clear screen

/*
////////////////////////write to SD Card////////////////////////////////
        if (SDenable > 0.5) //switch enable
        {
            myled1 = 1;
            FILE *fp = fopen("/sd/datalog.csv", "a");
            fprintf(fp, "%8.3f, %4f, %i, %4.1f, %3f, %4.1f, %4.1f, %5.1f, %5.1f, %f, %f, %f, %f, %f, %f, %f, %f, %4.1f, %f, %4.1f, %f, %f, %f, %f, %f, %f, %f, %i, \n", Time, SecL, RPM, MAP, TP, vBatt, AFR, MAT, CLT, Engine, Gego, Gair, Gwarmup, Gbaro, Gammae, TPSacc, PW, DutyCycle,  PW2, DutyCycle2, SparkAdv, ColdAdv, Dwell, tpsDOT, mapDOT, IAC, deltaT, Ethanol);
            fclose(fp);
        } else {
            myled1 = 0;
        }
*/
    }
}

//exit main loop
