/* draft mbed TextLCD 
 * (c) 2007/8, sford
 */
 
#ifndef MBED_TEXTLCD_H
#define MBED_TEXTLCD_H

#include "Stream.h"
#include "DigitalOut.h"
#include "BusOut.h"

namespace mbed {

class TextLCD : public Stream {

public:

    TextLCD(PinName rs, PinName rw,PinName e, PinName d0, PinName d1, PinName d2, PinName d3, int columns, int rows);
    void rows(int rows);
    void columns(int columns);
            
    virtual void locate(int row, int column);
    virtual void cls();    
    virtual void reset();
//    virtual void init_Display();
 
        
protected:

    void clock();
    void writeData(int data);
    void writeCommand(int command);
    void writeByte(int value);
    void writeNibble(int value);
    virtual int _putc(int c);        
    virtual int _getc();
    virtual void newline();
             
            
    int _rows;
    int _columns;
    int _row;
    int _column;    
    DigitalOut _rw, _rs, _e;
    BusOut _d;

};

}

#endif
