#include "mbed.h"
#include "CameraOV528.h"
#include "FATFileSystem.h"
#include "SDBlockDevice.h"
#include <stdio.h>

CameraOV528 camera(D1, D0); // DX, RX
SDBlockDevice bd(PTE3, PTE1, PTE2, PTE4); // MOSI, MISO, SCLK, CS
FATFileSystem fs("fs");
DigitalOut led(LED_GREEN);
DigitalIn btn(SW2);
int picture_count;

int format_fs() {
    int error = 0;
    printf("Welcome to the filesystem example.\r\n"
           "Formatting a FAT, RAM-backed filesystem. ");
    error = FATFileSystem::format(&bd);
    if (error)
      printf("Failure. %d\r\n", error);
    else
      printf("done.\r\n");
    return error;
}

int mount_fs() {
    printf("Mounting the filesystem on \"/fs\". ");
    int error = fs.mount(&bd);
    if (error)
      printf("Failure. %d\r\n", error);
    else
      printf("done.\r\n");
    return error;
}

void init_fs() {
    if (mount_fs()) {
        format_fs();
        mount_fs();
    }
}

void blink() {
    led = !led;
}

void take_and_store_photo() {
    blink();

    if(camera.take_picture() == 0) {
        printf("Picture taken.\r\n");

        uint32_t size = camera.get_picture_size();
        uint8_t* data_buff = (uint8_t*)malloc(size);
        uint32_t bytes_read = camera.read_picture_data(data_buff, size);
        char filename[30];
        sprintf(filename, "/fs/img%d.jpg", picture_count++);

        printf("Opening a new file, %s.\r\n", filename);

        FILE* fd = fopen(filename, "wb");
        fwrite(data_buff, sizeof(uint8_t), bytes_read, fd);
        fclose(fd);

        printf("Picture saved.\r\n\n");

        free(data_buff);
    }
    else {
        printf("Failed to take photo.\r\n\n");
    }
}

int main() {
    picture_count = 0;
    init_fs();
    camera.powerup();
    while (true) {
      if (!btn.read()) {
        take_and_store_photo();
      }
    }
}
