#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "ShiftBrite.h"
#include "SDFileSystem.h"
#include "wave_player.h"

Mutex mutex;    //handles writing to the LCD
Mutex mutex2;   //used for color changing
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;
DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);
//uLCD_4DGL uLCD(p28,p27,p29); //(p27, p28, p30);    //tx, rx, rst
uLCD_4DGL uLCD(p28, p27, p30); 
ShiftBrite myBrite(p15,p16,spi); //latch, enable, spi
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);      //must be p18
RawSerial BT(p9, p10);  //bluetooth pinout
int red = 200;
int blue = 0;
int green = 0;
FILE *wave_file = NULL;        //global bc its gotta be changed by Main while running in child thread
unsigned int redHex = 0xFF0000;
unsigned int grnHex = 0x00FF00;
unsigned int bluHex = 0x0000FF;


wave_player waver(&DACout);

void LCD_thread1() {
    while(1){    
        mutex.lock();
        uLCD.filled_circle(64, 64, 12, 0xFF0000);
        mutex.unlock();
        wait(.5);
        mutex.lock();
        uLCD.filled_circle(64, 64, 12, bluHex);
        mutex.unlock();
        wait(.5);
    }     
}
void LCD_thread2() {    //update a timer on the display every 100ms
    uLCD.cls();
    //float time = 0.0;
    int count =0;
    while(1) {
        Thread::wait(60);
        //time = time + 0.25;
        mutex.lock();
        uLCD.locate(0,0);
        count++;
        uLCD.printf("Counting! %i \n", count);
        mutex.unlock();
    }
}
void LED_thread() {
    //flash red & blue for police siren
    while(1){
        mutex2.lock();
        //myBrite.Write(red,green,blue);
        myBrite.Write(150, green, 0);
        mutex2.unlock();
        wait(.5);
        mutex2.lock();
        myBrite.Write(0,green,150);
        //myBrite.Write(blue,green,red);  // change LEDs so Red=OFF, Blue=ON
        mutex2.unlock();
        wait(.5); 
    }
} 
/*
void BT_thread() {
    // use mutex to lock getc(), printf(), scanf()
    // don't unlock until you've checked that it's readable() 
    char bnum=0;
    while(1) {
        mutex.lock();
        if (BT.getc()=='!') {
            if (BT.getc()=='B') { //button data
                bnum = BT.getc(); //button number
                if (bnum == '1') {
                    green = 250;  
                }
                if (bnum == '2') {
                    
                }
                if (bnum == '3') {
                    green = 250;  
                }
                if (bnum == '4') {
                    green = 0;
                }
                //if ((bnum>='1')&&(bnum<='4')) //is a number button 1..4
                //    myled[bnum-'1']=blue.getc()-'0'; //turn on/off that num LED
            }
        }
        mutex.unlock();
    }  
}*/
void sound_thread(){
    //FILE *wave_file;
    wave_file=fopen("/sd/Police_Siren.wav","r");    
    if (wave_file == NULL){
           led1=led2=led3=led4 = 1;
    }
    waver.play(wave_file);
    fclose(wave_file);  
}
int main() {
    thread1.start(LED_thread);  //police lights work
    thread2.start(LCD_thread1);
    thread3.start(LCD_thread2);
    thread4.start(sound_thread);
    // use mutex to lock getc(), printf(), scanf()
    // don't unlock until you've checked that it's readable() 
    
    char bnum=0;
    //
    while(1) {
        //mutex.lock();
        led3=0;
        led4=1;
        if (BT.getc()=='!') {
            //mutex.lock();
            if (BT.getc()=='B') { //button data
                bnum = BT.getc(); //button number
                mutex.unlock();
                if (bnum == '1') {  //turn Green LED on
                    green = 250; 
                    led1 = 1;
                    led2=led3=led4=0;
                }
                if (bnum == '2') { // revert to normal operation
                    green = 0;
                    bluHex = 0x0000FF;
                    led1=led3=led4=0;
                    led2=1;
                }
                if (bnum == '3') {  // change sound file playing  
                    led2=led1=led4=0;
                    led3=1;
                    if ( wave_file != NULL) {
                        led2=1;                     // debug
                        //fclose(wave_file);        //stop police siren from playing
                        thread4.terminate();
                        led2=0;
                    }
                    FILE *wave_file2;
                    wave_file2=fopen("/sd/banker_calling.wav","r");
                    if (wave_file2 == NULL){
                        led1=led2=0;
                        led3=led4=1;
                    }
                    waver.play(wave_file2);
                    fclose(wave_file2);     
                    thread4.start(sound_thread);    
                    //wave_file=fopen("/sd/Police_Siren.wav","r");
                    //waver.play(wave_file); 
                }
                if (bnum == '4') {  // change LCD colors
                    bluHex = 0x00FF00;  //change the lights to flash red/grn
                    led2=led3=led1=0;
                    led4=1;
                }
            }
            //mutex.unlock();
            led4=0;
            led3=1;
        }
        //mutex.unlock();
    } 

}