#include "mbed.h"

DigitalOut led1(PC_13);
DigitalOut led2(PC_14);
DigitalOut led3(PC_15);

DigitalOut io31(PB_0);
DigitalOut io32(PB_1);
DigitalOut io33(PB_2);
DigitalOut io34(PB_10);

DigitalOut io51(PA_7);
DigitalOut io52(PA_6);
DigitalOut io53(PA_5);
DigitalOut io54(PA_4);

DigitalOut SMOSI(PB_15);
DigitalOut SMISO(PB_14);
DigitalOut SCS(PB_12);
DigitalOut SCK(PB_13);
DigitalOut SRST(PB_11);


void led_test();
void spi_test();
void io_test();



#define DLYF 0.05
#define DLYLed 0.2
#define DLYIO 0.05

int main() {
    while(1) {
        led_test();
        io_test();
        spi_test();
   
        wait(1.0);
    }
}



void led_test() {
    for(int loopy = 0; loopy <= 5; loopy ++ ) {
        led1 = 1;
        wait(DLYLed);
        led1 = 0;
        led2 = 1;
        wait(DLYLed);
        led2 = 0;
        led3 = 1;
        wait(DLYLed);
        led3 = 0;
        wait(DLYLed);        
    }
}

void io_test() {
    for(int loopy = 0 ; loopy <= 10; loopy ++ ) {
        io31 = 1;
        io51 = 1;
        wait(DLYIO);
        io31 = 0;
        io32 = 1;
        io51 = 0;
        io52 = 1;
        wait(DLYIO);
        io32 = 0;
        io33 = 1;
        io52 = 0;
        io53 = 1;
        wait(DLYIO);
        io33 = 0;
        io34 = 1;
        io53 = 0;
        io54 = 1;
        wait(DLYIO);
        io34 = 0;
        io54 = 0;
        wait(DLYIO);    
    }
}


void spi_test() {
    for(int loopy = 0 ; loopy <= 10; loopy ++ ) {
        SMOSI = 1;
        wait(DLYIO);
        SMOSI = 0;
        SMISO = 1;
        wait(DLYIO);
        SMISO = 0;
        SRST = 1;
        wait(DLYIO);
        SRST = 0;
        SCS = 1;
        wait(DLYIO);
        SCS = 0;
        SCK = 1;
        wait(DLYIO);    
        SCK = 0;
        wait(DLYIO);
    }
}


