#include "mbed.h"
#include "nmea.h"
#include "SDFileSystem.h"
#include "SPI.h"
#include "temp_sensor.h"

#define NUM_PIXELS 2048
#define BUF_SIZE 1024

// TODO make a new file (name=timestamp) each time we start recording data
#define OUTPUT_FILE "/sd/data.csv"

// pinout for spectrometer

// Mosi (#8) -> PTD2
// Miso (#7) -> PTD3
// Sclk (#9) -> PTD1

// Pixel_rdy (#6) -> PTA1
// Fifo_cs (#3) -> PTB23
// Trigger (#13) -> PTA2

// spi_cs (#10) -> PTC2

SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk

DigitalOut spi_cs(PTC2);

DigitalIn pixel_rdy(PTA1);
DigitalOut fifo_cs(PTB23);
DigitalOut trigger(PTA2);

// Blinking red LED
DigitalOut led(LED_RED);

// GPS connection (through arduino)
Serial duino(PTC4, PTC3);

// USB serial to PC
Serial pc(USBTX, USBRX);

/**************************************************
 **          SD FILE SYSTEM                       **
 **************************************************/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
FILE *fpData;

void read_pixels()
{
    int data[NUM_PIXELS];
    for (int i = 0; i < NUM_PIXELS; i++) {

        while (!pixel_rdy);

        fifo_cs = 0;
        data[i] = spi.write(0x00); // write a dummy byte just to read the data
        fifo_cs = 1;

    }

    // write to file and pc
    fpData = fopen(OUTPUT_FILE, "a");
    for (int i = 0; i < NUM_PIXELS; i++) {
        pc.printf(",%d", data[i]);
        fprintf(fpData, ",%d", data[i]);
    }
    pc.printf("\r\n");
    fprintf(fpData, "\r\n");
    fclose(fpData);
}

void gps_read() {
    char buffer[BUF_SIZE];
    
    get_nmea(&duino, buffer, BUF_SIZE);

    struct NMEA_data nmea = parse_line(buffer);

    // determine whether there's a lock
    char lock_str[BUF_SIZE];
    if ( nmea.lock_flag == 'A' )
        sprintf(lock_str, "Has lock");
    else
        sprintf(lock_str, "No lock");

    // assemble data into summary string
    char status_str[BUF_SIZE];
    sprintf(status_str, "%02d:%02d:%02d,%d/%d/%d,%dd %lf' %c %dd %lf' %c,%s",
            nmea.hours, nmea.minutes, nmea.seconds,
            nmea.month, nmea.day, nmea.year,
            nmea.latitude, nmea.latitude_minutes, nmea.latitude_direction,
            nmea.longitude, nmea.longitude_minutes, nmea.longitude_direction, lock_str);

    // print to pc, sd card
    pc.printf("%s", status_str);

    fpData = fopen(OUTPUT_FILE, "a");
    fprintf(fpData, "%s", status_str);
    fclose(fpData);
}

int main()
{
    pc.baud(115200); // make sure to set computer TERA Term or whatever to 115200 baud!!!
    duino.baud(9600);
    pc.printf("Initializing ...\r\n");

    fifo_cs = 1;
    trigger = 0;
    wait(0.5f);
    
    init_temp_sensor(); // TODO: stop execution & send error message if can't init temp sensor (or other things)


    while (true) {

        led = !led;

        gps_read();
        
        check_temp();
        // Display result
        pc.printf(",%s", TempCelsiusDisplay);
        fpData = fopen(OUTPUT_FILE, "a");
        fprintf(fpData, ",%s", TempCelsiusDisplay);
        fclose(fpData);

        // Trigger an acquisition from spectrometer
        trigger = 1;
        wait_ms(1);
        trigger = 0;
        read_pixels();

        wait(0.5f);
    }
}