#include "mbed.h"
#include "Parallax_X-Band.h"

Serial pc(USBTX, USBRX);
Timer t;

xband myxband(PD_10, PD_11);

int main(){
    //Habilitamos un temporizador para saber el instante de la alarma
    t.start();    
    
    // Habilita el sensor
    myxband.enable(true);
    
    // Variable a calcular la velocidad de estado.
    float velocity;
    
    //Establecemos el umbral
    float umbral = 1.0;
    
    //Establecemos una variable que indica comienzo pues
    //No podemos comparar la velocidad actual con la antigua
    //Si no hay valor antiguo alguno
    bool comienzo = true;

    while(1) {        
        
        //Se comprueba si hay un nuevo valor de velocidad
        while (myxband.velocityack() == true) {
            
            if(comienzo){
                velocity = myxband;
                comienzo = false;
            }
            else{
                //Se comprueba la velocidad actual frente a la antigua. 
                //Si supera cierto umbral se considera alerta
                
                if( myxband - velocity > umbral)
                    pc.printf("ALERTA: Se detecta intruso en el instante %f\n",t.read());
                                    
                velocity = myxband;
            }

        }
    }
}