#include "mbed.h"

//#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
Instructions for use: connect the mbed to a parallel port using these connexions.
use a terminal program to connect via USB to the mbed side. */

/* This is for testing since it uses the serial port at 9600 bauds to connect to a PC */

/*
  8255          Parallel    Pin     Bit
  PC7   /OBF    ->  /ACK        10      6
  PC6   /ACK    <-  /SLCTIN     17      3
  PC5   IBF     ->  BUSY        11      7
  PC4   /STB    <-  /STB        1       0

15 nError       -> p9       not used
13 Select       -> p10      not used
12 PE           -> p11      not used
11 Busy         -> p12      MISO
10 nAck         -> p13      not used

 1 nStrobe      -> p14      MOSI
14 nAutoFeed    -> p15      SCLK
16 nInit        -> p16      not used
17 nSelectIn    -> p17      not used
*/

DigitalOut MISO(p12);
DigitalIn MOSI(p14);
InterruptIn SCLK(p15);

/*
CE0 p30  p0.4
CE1 p29  p0.5
CE2 p8   p0.6
CE3 p7   p0.7
CE4 p6   p0.8
CE5 p5   p0.9
CE6 p28  p0.10
CE7 p27  p0.11
*/
BusInOut PtrData(p30,p29,p8,p7,p6,p5,p28,p27);

#define __DOUTBUFSIZE 256
#define __DINBUFSIZE 256
char __outstr[__DOUTBUFSIZE];
char __instr[__DINBUFSIZE];

Serial pc(USBTX, USBRX); // tx, rx

unsigned char rx_data, tx_data;

bool msb_first = true;
bool edge_falling = false; // false: CPOL = 0, CPHA = 0; true: CPOL = 1, CPHA = 1
bool byte_ready;
int bit_count;

void shift_bit(void)
{
    if (msb_first)
    {
        rx_data = (rx_data << 1) | MOSI;
        MISO = (tx_data & 0x80) >> 7;
        tx_data <<= 1;
    }
    else
    {
        rx_data = (rx_data >> 1) | (MOSI << 7);
        MISO = tx_data & 1;
        tx_data >>= 1;
    }
    bit_count++;
    if (bit_count == 8)
    {
        byte_ready = true;
        bit_count = 0;
    }
}

void sclk_fall(void)
{
    if (edge_falling && (PtrData == 0xfe))
    {
        shift_bit();
    }
}

void sclk_rise(void)
{
   if (!edge_falling && (PtrData == 0xfe))
   {
        shift_bit();
   }
}

int main()
{
unsigned char key;
bool configure_end = false;

    PtrData.input();

    /* 9600 baud serial port */
    pc.printf("SPI tester on mbed\r\n\n");
    
    MISO = 0;
    SCLK.fall(&sclk_fall);
    SCLK.rise(&sclk_rise);
    SCLK.mode(PullUp);
    SCLK.enable_irq();
    
    byte_ready = false;
    bit_count = 0;
    
    pc.printf("Actual configuration\r\n\n");
    pc.printf("MSB first\r\n");
    pc.printf("Rising edge clock\r\n\n");

    pc.printf("Configure\r\n\n");
    pc.printf("M: MSB first\r\n");
    pc.printf("L: LSB first\r\n");
    pc.printf("F: Falling edge clock\r\n");
    pc.printf("R: Rising edge clock\r\n");
    pc.printf("G: Go\r\n\n");

    do
    {
        key = pc.getc();    
    
        switch (key)
        {
            case 'M':
            case 'm':
                msb_first = true;
                pc.printf("MSB first\r\n");
                break;

            case 'L':
            case 'l':
                msb_first = false;
                pc.printf("LSB first\r\n");
                break;
                
            case 'F':
            case 'f':
                edge_falling = true;
                pc.printf("Falling edge clock\r\n");
                break;

            case 'R':
            case 'r':
                edge_falling = true;
                pc.printf("Rising edge clock\r\n");
                break;
                
            case 'G':
            case 'g':
                configure_end = true;
                break;
                
            default:
            ;                        
        }
    } while (!configure_end);
    
    pc.printf("Configure end, begin test\r\n\n");

    while(1)
    {
        if (pc.readable())
        {
            tx_data = pc.getc();
        }
        else
        {
            if (byte_ready)
            {
                pc.putc(rx_data);
                byte_ready = false;
            }
        }  
    }
}
