#include "mbed.h"

//#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PAR_NEGOTIATE_EXTENSIBILITY_LINK        0x80
#define PAR_NEGOTIATE_REQ_EPP_MODE              0x40
#define PAR_NEGOTIATE_REQ_ECP_MODE              0x10
#define PAR_NEGOTIATE_REQ_ECP_RLE_MODE          0x30
#define PAR_NEGOTIATE_REQ_DEV_ID_NIBBLE_MODE    0x04
#define PAR_NEGOTIATE_REQ_DEV_ID_BYTE_MODE      0x05
#define PAR_NEGOTIATE_REQ_DEV_ID_ECP_MODE       0x14
#define PAR_NEGOTIATE_REQ_DEV_ID_ECP_RLE_MODE   0x34
#define PAR_NEGOTIATE_NIBBLE_MODE               0x00
#define PAR_NEGOTIATE_BYTE_MODE                 0x01

/*
Instructions for use: connect the mbed to a parallel port using these connexions.
use a terminal program to connect via USB to the mbed side.

This program uses CR to rewrite over the status previously printed. Setup the terminal
program so that CR = CR without line feed.

15 nError       -> p9
13 Select       -> p10
12 PE           -> p11
11 Busy         -> p12
10 nAck         -> p13

 1 nStrobe      -> p14
14 nAutoFeed    -> p15
16 nInit        -> p16
17 nSelectIn    -> p17
*/

DigitalOut nError(p9);
DigitalOut Select(p10);
DigitalOut PaperOut(p11);
DigitalOut Busy(p12);
DigitalOut nAck(p13);

DigitalIn nStrobe(p14);
DigitalIn nAutoFeed(p15);
DigitalIn nInit(p16);
DigitalIn nSelectIn(p17);

/*
D0 p30  p0.4
D1 p29  p0.5
D2 p8   p0.6
D3 p7   p0.7
D4 p6   p0.8
D5 p5   p0.9
D6 p28  p0.10
D7 p27  p0.11
*/
BusInOut PtrData(p30,p29,p8,p7,p6,p5,p28,p27);

#define __DOUTBUFSIZE 256
#define __DINBUFSIZE 256
char __outstr[__DOUTBUFSIZE];
char __instr[__DINBUFSIZE];

Serial pc(USBTX, USBRX); // tx, rx

int main() {

char key;
bool PortIsInput = false;

    PtrData.input();

    pc.printf("Parallel port tester on mbed\r\n\n");
    pc.printf("Press keys 0-7,G,H,J,K and L to toggle output bits (inputs on PC)\r\n");
    pc.printf("Press keys I and O to toggle data direction for bits 0-7\r\n");
    pc.printf(" (be sure your PC and mbed don't output at the same time)\r\n\n");
    pc.printf("PINS 9-2     1    14    16    17     ------ 15    13    12    11    10\r\n");
    pc.printf("DATA 7-0   /STB  /AF  /INIT  /SEL_IN ------/ERR   SEL   PO    BUSY  /ACK\r\n");
    pc.printf("Keys                                 ------  G     H     J     K     L\r\n");
             //  XX         B     B     B     B     ------  B     B     B     B     B
    while(1) {
        pc.printf("  %02X         %c     %c     %c     %c             %c     %c     %c     %c     %c \r",
            PtrData & 0xff,
            '0'| nStrobe,
            '0'| nAutoFeed,
            '0'| nInit,
            '0'| nSelectIn,            
            '0'| nError,
            '0'| Select,
            '0'| PaperOut,
            '0'| Busy,
            '0'| nAck                                                
            );

        if (pc.readable())
        {
            key = pc.getc();
            switch(key)
            {
                case 'I':
                    PtrData.input();
                    PortIsInput = true;
                    break;
                case 'O':
                    PtrData.output();
                    PortIsInput = false;
                    break;
                case '0':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x01;
                    break;
                case '1':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x02;
                    break;
                case '2':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x04;
                    break;
                case '3':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x08;
                    break;
                case '4':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x10;
                    break;
                case '5':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x20;
                    break;
                case '6':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x40;
                    break;
                case '7':
                    if (!PortIsInput)
                    PtrData = PtrData ^ 0x80;
                    break;
                case 'G':
                    nError = !nError;
                    break;
                case 'H':
                    Select = !Select;
                    break;
                case 'J':
                    PaperOut = !PaperOut;
                    break;
                case 'K':
                    Busy = !Busy;
                    break;
                case 'L':
                    nAck = !nAck;
                    break;
                default:
                    ; 
            }
        }
    }
}
