/* Implement the SPI slave 8-bit in hardware */
#include "mbed.h"

//#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <SPISlave.h>

/*
Instructions for use: connect the mbed to a parallel port using these connexions.
use a terminal program to connect via USB to the mbed side. */

/* This is for testing since it uses the serial port at 9600 bauds to connect to a PC */

/*
Doesn't use the Mbed-parallel port PCB

  SPI          Parallel    Pin     Bit
  MISO  p6      ->  BUSY        11      7
  SCK   p7      <-  /AutoFeed   14
  /SS   p8      <-> D0          2
  MOSI  p5      <-  /STB        1       0
*/

Serial pc(USBTX, USBRX); // tx, rx

unsigned char rx_data, tx_data;

SPISlave device(p5, p6, p7, p8); // mosi, miso, sclk, ssel

int main()
{
    char key;
    int i = 0;
    
    /* 9600 baud serial port */
    pc.printf("SPI slave test on mbed\r\n\n");
    
    pc.printf("Configure\r\n\n");
    pc.printf("Mode: 0-3\r\n\n");

    key = pc.getc();    

    switch (key)
    {
        case '0':
        case '1':
        case '2':
        case '3':
            i = key & 0x03;
            break;

        default:
        ;                        
    }
    
    pc.printf("Configure end, mode: %d, begin test\r\n\n",i);
    device.format(8,i);
    device.frequency(8000000); //8MHz    
    
    i = 0;
    device.reply(0);              // Prime SPI with first reply
    
    while(1) {
        if(device.receive()) {
            int v = device.read();   // Read byte from master
            device.reply(v);         // Make this the next reply
        }
    }
}
