#include "mbed.h"
#include "lib_crc.h"

Serial pc(USBTX, USBRX); // tx, rx

char TestString[] = "123456789";

int main() {
    pc.printf("Test CRC on mbed NXP LPC1768\r\n\n");

    pc.printf("\nTest CRC8 algorithms\r\n\n");

    pc.printf("Test ITU:       %02X\r\n",calculate_crc8_itu(TestString, 9));
    pc.printf("Test ATM:       %02X\r\n",calculate_crc8_atm(TestString, 9));
    pc.printf("Test CCITT:     %02X\r\n",calculate_crc8_ccitt(TestString, 9));
    pc.printf("Test Maxim:     %02X\r\n",calculate_crc8_maxim(TestString, 9));
    pc.printf("Test CRC8:      %02X\r\n",calculate_crc8(TestString, 9));
    pc.printf("Test Icode:     %02X\r\n",calculate_crc8_icode(TestString, 9));
    pc.printf("Test J1850:     %02X\r\n",calculate_crc8_j1850(TestString, 9));
    pc.printf("Test WCDMA:     %02X\r\n",calculate_crc8_wcdma(TestString, 9));
    pc.printf("Test ROHC:      %02X\r\n",calculate_crc8_rohc(TestString, 9));
    pc.printf("Test DARC:      %02X\r\n",calculate_crc8_darc(TestString, 9));

    pc.printf("\nTest CRC16 algorithms\r\n\n");

    pc.printf("Test Buypass:   %04X\r\n",calculate_crc16_Buypass(TestString, 9));
    pc.printf("Test DDS 110:   %04X\r\n",calculate_crc16_DDS_110(TestString, 9));
    pc.printf("Test EN 13757:  %04X\r\n",calculate_crc16_EN_13757(TestString, 9));
    pc.printf("Test Teledisk:  %04X\r\n",calculate_crc16_Teledisk(TestString, 9));
    pc.printf("Test CRC16:     %04X\r\n",calculate_crc16(TestString, 9));
    pc.printf("Test Modbus:    %04X\r\n",calculate_crc16_Modbus(TestString, 9));
    pc.printf("Test Maxim:     %04X\r\n",calculate_crc16_Maxim(TestString, 9));
    pc.printf("Test USB:       %04X\r\n",calculate_crc16_USB(TestString, 9));
    pc.printf("Test T10 DIF:   %04X\r\n",calculate_crc16_T10_DIF(TestString, 9));
    pc.printf("Test Dect X:    %04X\r\n",calculate_crc16_Dect_X(TestString, 9));
    pc.printf("Test Dect R:    %04X\r\n",calculate_crc16_Dect_R(TestString, 9));
    pc.printf("Test Sick:      %04X\r\n",calculate_crc16_sick(TestString, 9));
    pc.printf("Test DNP:       %04X\r\n",calculate_crc16_DNP(TestString, 9));
    pc.printf("Test XModem:    %04X\r\n",calculate_crc16_Ccitt_Xmodem(TestString, 9));
    pc.printf("Test FFFF:      %04X\r\n",calculate_crc16_Ccitt_FFFF(TestString, 9));
    pc.printf("Test 1D0F:      %04X\r\n",calculate_crc16_Ccitt_1D0F(TestString, 9));
    pc.printf("Test Genibus:   %04X\r\n",calculate_crc16_Genibus(TestString, 9));
    pc.printf("Test Kermit:    %04X\r\n",calculate_crc16_Kermit(TestString, 9));
    pc.printf("Test X25:       %04X\r\n",calculate_crc16_X25(TestString, 9));
    pc.printf("Test MCRF4XX:   %04X\r\n",calculate_crc16_MCRF4XX(TestString, 9));
    pc.printf("Test Riello:    %04X\r\n",calculate_crc16_Riello(TestString, 9));
    pc.printf("Test Fletcher:  %04X\r\n",calculate_chk16_Fletcher(TestString, 9));

    pc.printf("\nTest CRC24-64 algorithms\r\n\n");

    pc.printf("Test Flexray A: %06X\r\n",calculate_crc24_flexray_a(TestString, 9) & 0x00ffffff);
    pc.printf("Test Flexray B: %06X\r\n",calculate_crc24_flexray_b(TestString, 9) & 0x00ffffff);
    pc.printf("Test R64:       %06X\r\n\n",calculate_crc24_r64(TestString, 9) & 0x00ffffff);
    pc.printf("Test CRC32:     %08X\r\n",calculate_crc32(TestString, 9));
    pc.printf("Test JamCRC:    %08X\r\n",calculate_crc32_jamcrc(TestString, 9));
    pc.printf("Test CRC32 C:   %08X\r\n",calculate_crc32_c(TestString, 9));
    pc.printf("Test CRC32 D:   %08X\r\n",calculate_crc32_d(TestString, 9));
    pc.printf("Test BZIP2:     %08X\r\n",calculate_crc32_bzip2(TestString, 9));
    pc.printf("Test MPEG2:     %08X\r\n",calculate_crc32_mpeg2(TestString, 9));
    pc.printf("Test Posix:     %08X\r\n",calculate_crc32_posix(TestString, 9));
    pc.printf("Test CRC32 K:   %08X\r\n",calculate_crc32_k(TestString, 9));
    pc.printf("Test CRC32 Q:   %08X\r\n",calculate_crc32_q(TestString, 9));
    pc.printf("Test Xfer:      %08X\r\n\n",calculate_crc32_xfer(TestString, 9));
    pc.printf("Test GSM:       %llX\r\n\n",calculate_crc40_gsm(TestString, 9) & 0x000000ffffffffffULL);
    pc.printf("Test CRC64:     %llX\r\n",calculate_crc64(TestString, 9));
    pc.printf("Test CRC64 1B:  %llX\r\n",calculate_crc64_1b(TestString, 9));
    pc.printf("Test WE:        %llX\r\n",calculate_crc64_we(TestString, 9));
    pc.printf("Test Jones:     %llX\r\n",calculate_crc64_jones(TestString, 9));
}

