#include "mbed.h"

//#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
Instructions for use: connect the mbed to a parallel port using these connexions.
use a terminal program to connect via USB to the mbed side. */

/* This is for testing since it uses the serial port at 9600 bauds to connect to a PC */

#define PAR_INVERT_OBF_SIGNAL

#define PAR_8255_SEND_MASK      0x80
#define PAR_8255_RECV_MASK      0x40

/*
  8255          Parallel    Pin     Bit
  PC7   /OBF    ->  /ACK        10      6
  PC6   /ACK    <-  /SLCTIN     17      3
  PC5   IBF     ->  BUSY        11      7
  PC4   /STB    <-  /STB        1       0

15 nError       -> p9       not used
13 Select       -> p10      not used
12 PE           -> p11      not used
11 Busy         -> p12      IBF
10 nAck         -> p13      /OBF

 1 nStrobe      -> p14      /STB
14 nAutoFeed    -> p15      not used
16 nInit        -> p16      not used
17 nSelectIn    -> p17      /ACK
*/

DigitalOut IBF(p12); // IBF
DigitalOut nOBF(p13); // /OBF

InterruptIn nSTB(p14);
InterruptIn nACK(p17);

/*
D0 p30  p0.4
D1 p29  p0.5
D2 p8   p0.6
D3 p7   p0.7
D4 p6   p0.8
D5 p5   p0.9
D6 p28  p0.10
D7 p27  p0.11
*/
BusInOut PtrData(p30,p29,p8,p7,p6,p5,p28,p27);

#define __DOUTBUFSIZE 256
#define __DINBUFSIZE 256
char __outstr[__DOUTBUFSIZE];
char __instr[__DINBUFSIZE];

Serial pc(USBTX, USBRX); // tx, rx

unsigned char rx_data;

// Peripheral should check that there is no output pending from the 8255 to the peripheral before writing to the 8255

// When /STB is falling
void perif2mbed(void)
{
    // read byte from peripheral
    rx_data = PtrData;
    IBF = 1;
}

// When /ACK is rising
void mbed2perif(void)
{
    nOBF = 1;
    PtrData.input();
}

void write_byte(unsigned char out)
{
    // wait for /OBF = 1 and no read cycle in progress for politeness
    while ((nOBF == 0) || (IBF == 1));

    PtrData = out;
    PtrData.output();
    nOBF = 0;
}

unsigned char read_byte(void)
{
    while (IBF == 0);
    IBF = 0;
    return rx_data;
}

int main()
{
    PtrData.input();

    /* 9600 baud serial port */
    pc.printf("8255 emulator on mbed\r\n\n");
    
    IBF = 0;
    nOBF = 1;
    nSTB.fall(&perif2mbed);
    nACK.rise(&mbed2perif);

    PtrData.input();

    while(1)
    {
        // bytes from peripherals to 8255
        if (IBF == 1)
        {
            IBF = 0;
            pc.putc(rx_data);
        }
        else
        {
            if (pc.readable())
            {
                write_byte(pc.getc());
            }
        }  
    }
}
