#include "mbed.h"
#include "MPU6050.h"
#include "ble/BLE.h"


DigitalOut myled(LED1);

MPU6050 ark(I2C_SDA0, I2C_SCL0);

BLE   ble;

uint8_t AdvData[] =   {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff};
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

void periodicCallback(void)
{
}

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)    // Mod
{
    ble.startAdvertising();
}

void timeoutCallback(const Gap::TimeoutSource_t source)
{
    ble.startAdvertising();
}

int main()
{
        ble.init();

    while(1) {
        //reading Temprature
        float temp = ark.getTemp();
       // int tempData = floor(temp);
       // AdvData[1] = tempData;

        //reading Gyrometer readings
        float gyro[3];
        ark.getGyro(gyro);

        
        float* inputAddress = &gyro[0];
        float* inputAddress2 = &gyro[1];
        float* inputAddress3 = &gyro[2];
       // float* inputAddress = &input;
        long int* ptr = (long int*)inputAddress;
        long int* ptr2 = (long int*)inputAddress2;
        long int* ptr3 = (long int*)inputAddress3;

       // uint32_t typeCastedx = (uint32_t)x;
        //int gyroData1 = floor(gyro[0]*1000);
        AdvData[0] = *ptr >> 24;
        AdvData[1] = *ptr >> 16;
        AdvData[2] = *ptr >> 8;
        AdvData[3] = *ptr;
        
        AdvData[4] = *ptr2 >> 24;
        AdvData[5] = *ptr2 >> 16;
        AdvData[6] = *ptr2 >> 8;
        AdvData[7] = *ptr2;

        AdvData[8] = *ptr3 >> 24;
        AdvData[9] = *ptr3 >> 16;
        AdvData[10] = *ptr3 >> 8;
        AdvData[11] = *ptr3;
      //  int gyroData2 = floor(gyro[1]*1000);
      //  uint8_t gyroData2 = gyro[1];
      //  AdvData[2] = gyroData2;
      //  int gyroData3 = floor(gyro[2]*1000);
       // uint8_t gyroData3 = gyro[2];
       // AdvData[3] = gyroData3;

        //reading Acclerometer readings
        float acce[3];
        ark.getAccelero(acce);
        int acceData1 = floor(acce[0]*1000);
      //  AdvData[5] = acceData1;
        int acceData2 = floor(acce[1]*1000);
      //  AdvData[6] = acceData2;
        int acceData3 = floor(acce[2]*1000);
       // AdvData[7] = acceData3;
        
        wait(0.1); 

    ble.setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
   ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, AdvData, sizeof(AdvData));
   ble.startAdvertising();

    
        /* SpinWait for initialization to complete. This is necessary because the
         * BLE object is used in the main loop below. */
        while (ble.hasInitialized()  == false) {
            /* spin loop */
        }


    }

}