#include "mbed.h"
#include "F746_GUI.hpp"

//RESOLUTION 480x272

LCD_DISCO_F746NG lcd;   //Affichage LCD
TS_DISCO_F746NG ts; //Touch Screen

DigitalOut myled(LED1);

I2C i2c(D14, D15); //Liaison I2C

const int addr = 0x27;

Button button1(15, 110, 80, 40, "Celsius");
Button button2(15, 160, 80, 40, "Kelvin");
Button button3(15,210, 80, 40, "Fahrenheit");
Button button4(260,125, 200, 50, "Connaitre taux d'humidite");
Button cache1(100,110, 140, 40, "");
Button cache2(100,160, 140, 40, "");
Button cache3(100,210, 140, 40, "");
Button cache4(245,180, 230, 90, "");

int main() 
{        
    float valeur_celsius=0.00;
    double valeur_kelvin;
    float valeur_fara;
    float valeur_hum;
  
    char valeur[4];
    
    char buffer[50];
    char buffer2[50];
    char buffer3[50];
    char buffer4[50];
       
    lcd.Init();
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font20);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"CAPTEUR HIH6030-021-001", CENTER_MODE);
    lcd.SetFont(&Font12);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"Julien PALLY LPRO SESAM", CENTER_MODE);
    lcd.DrawLine(240, 65, 240, 260); 
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(25, LINE(3), (uint8_t *)"Temperature", LEFT_MODE);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(290, LINE(3), (uint8_t *)"Humidite", LEFT_MODE); 
     
    while(1) 
    {                   
/////////////////////////////////////////////////////    PARTIE I2C    //////////////////////////////////////////////////////////////////         
         
        
        i2c.write(addr<<1,0,0);      
        i2c.read(addr<<1, valeur, 4);

        float lecture_hum = (valeur[0]<< 8) + valeur[1];
        float humidite = lecture_hum / 163382 * 100;    
              
        float lecture_temp = (valeur[2] << 6) + (valeur[3] >> 2);
        float temperature = lecture_temp / 16382 * 165 - 40;      
     
/////////////////////////////////////////////////////   AFFICHAGE DES BOUTONS    //////////////////////////////////////////////////////////////////      
        
        button1.Draw(LCD_COLOR_GRAY, LCD_COLOR_WHITE); //Dessin des boutons
        button2.Draw(LCD_COLOR_GRAY, LCD_COLOR_WHITE); 
        button3.Draw(LCD_COLOR_GRAY, LCD_COLOR_WHITE);
        button4.Draw(LCD_COLOR_GRAY, LCD_COLOR_WHITE); 
          
       
///////////////////////////////////////////////////// PARTIE TRAITEMENT /////////////////////////////////////////////////////////////////////       
       
       
       
       wait_ms(100);
       
       valeur_celsius = temperature;          
       valeur_kelvin = temperature + 273.15;       
       valeur_fara = temperature * 1.8 + 32; 
       valeur_hum = humidite; 
       
          
       if (valeur_celsius >= 999){valeur_celsius = 999;}   
       if (valeur_kelvin >= 999){valeur_kelvin = 999;}
       if (valeur_fara >= 999){valeur_fara = 999;}
       if (valeur_hum >= 999){valeur_hum = 999;} 
                          
       sprintf(buffer, "%.2f", valeur_celsius);
       sprintf(buffer2, "%.2f", valeur_kelvin);
       sprintf(buffer3, "%.2f", valeur_fara);
       sprintf(buffer4, "%.2f", valeur_hum);
      
       if(button1.IsOnButton()) //si on touche le bouton Celsius
        {       
           cache2.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);  
           cache3.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);
           cache4.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);
          
        
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font24);
            lcd.DisplayStringAt(100, LINE(5), (uint8_t *)buffer, LEFT_MODE); 
            lcd.DisplayStringAt(210, LINE(5), (uint8_t *)"C" , LEFT_MODE);
        }
           
       if(button2.IsOnButton()) //si on touche le bouton Kelvin
        {
           cache1.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);  
           cache3.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);
           cache4.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);
           
        
           lcd.SetBackColor(LCD_COLOR_WHITE);
           lcd.SetTextColor(LCD_COLOR_BLACK);
           lcd.SetFont(&Font24);
           lcd.DisplayStringAt(100, LINE(7), (uint8_t *)buffer2, LEFT_MODE);
           lcd.DisplayStringAt(210, LINE(7), (uint8_t *)"K", LEFT_MODE);  
        }
     
        
         if(button3.IsOnButton()) //si on touche le bouton Fahrenheit
        {
           cache1.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);  
           cache2.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE); 
           cache4.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE); 
    
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font24);
            lcd.DisplayStringAt(100, LINE(9), (uint8_t *)buffer3, LEFT_MODE);
            lcd.DisplayStringAt(210, LINE(9), (uint8_t *)"F", LEFT_MODE);
        }
       
       
         if(button4.Touched()) //si on touche le bouton de l'Humidité
       
        {
            cache1.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);  
            cache2.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);  
            cache3.Draw(LCD_COLOR_WHITE, LCD_COLOR_WHITE);
           
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font24);         
            lcd.DisplayStringAt(295, LINE(10), (uint8_t *)buffer4, LEFT_MODE);
            lcd.DisplayStringAt(410, LINE(10), (uint8_t *)"%", LEFT_MODE); 
            
            
            if(valeur_hum < 40)
           {
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font20); 
            lcd.DisplayStringAt(250, LINE(10), (uint8_t *)"Humidite Faible", LEFT_MODE);
           }
           
           else if((valeur_hum > 40) && (valeur_hum < 70))
           {
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font20); 
            lcd.DisplayStringAt(250, LINE(10), (uint8_t *)"Humidite Moyenne", LEFT_MODE);
           }
           
           else if(valeur_hum > 70)
           {
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font20); 
            lcd.DisplayStringAt(250, LINE(10), (uint8_t *)"Humidite Elevee", LEFT_MODE);
           }              
        }
       
               
    }
}