#include "mbed.h"
#include "I2cLCD.h"
#include "QEI.h"
#define ROTATE_PER_REVOLUTIONS  24

DigitalOut DATA(dp9);
DigitalOut W_CLK(dp17);
DigitalOut FQ_UD(dp11);
DigitalOut RESET(dp26);
DigitalOut LED(dp14);
DigitalOut PTT_OUT(dp18);
DigitalIn  PTT_ON(dp1);
DigitalOut  RL1(dp13);       //BFO,AUDIO
DigitalOut  RL2(dp15);       //AGC
DigitalIn  BAND_SW(dp10);
DigitalIn  JOG_3(dp25);      //FREQ STEP
DigitalIn  RIT_SW(dp16);      //RIT
DigitalIn  jmh(dp24);
DigitalIn  MODE_IN(dp6);
//DigitalIn  test(dp15);

double FQX;
double FQD;
double FQDD;

// double FQD_18 = 1810000;
// double FQD_19 = 1907500;
double FQD_351 = 3500000;
double FQD_352 = 3599000;
double FQD_353 = 3680000;
double FQD_381 = 3702000;
double FQD_382 = 3745000;
double FQD_383 = 3791000;
double FQD_4 = 4630000;
double FQD_7 = 7000000;
double FQD_10 = 10100000;
//double FQD_14 = 522000;
double FQD_JMH = 3620600;
double FQD_JMH1 = 7793100;
double FQD_VOK1 = 6070000;
double FQD_VOK2 = 9650000;
double FQD_KCBS = 6400000;
double FQD_NSB1 = 6055000;
double FQD_NSB2 = 6115000;
double FQD_NSB3 = 9595000;
double FQD_NSB4 = 9760000;
double FQD_NSB5 = 3925000;
double FQD_NSB6 = 3945000;
double FQD_CRI  = 7325000;
double FQD_NHK  = 9750000;
double FQD_14  = 14000000;
double FQD_181 = 18068000;
double FQD_M = 0;
double FQD_MM = 0;
double FQD_jmh = 0;

double FQ;

// double FQ_18 =    43191352;
// double FQ_19 =    45517913;
double FQ_351 =   83517187;
double FQ_352 =   85879508;
double FQ_353 =   87812323;
double FQ_381 =   88337282;
double FQ_382 =   89363339;
double FQ_383 =   90460995;
double FQ_4 =    110481248;
double FQ_7 =    167034290;
double FQ_10 =   241006742;
//double FQ_14 =   12455974;
double FQ_JMH =   86397023;
double FQ_JMH1 = 185963684;
double FQ_VOK1 = 144846025;
double FQ_VOK2 = 230274159;
double FQ_KCBS = 152720685;
double FQ_NSB1 = 144488086;
double FQ_NSB2 = 145919842;
double FQ_NSB3 = 228961619;
double FQ_NSB4 = 232898947;
double FQ_NSB5 = 93660807;
double FQ_NSB6 = 94138060;
double FQ_CRI  = 174793597;
double FQ_NHK  = 232660321;
double FQ_14   = 334078686;
double FQ_181  = 431152407;
double FQ_M = 0;
double FQ_MM =0;
double FQ_jmh = 0;

double f1 = 7000000;
double f2 = 7200000;
double f1_CW = 7000000;
double f2_CW = 7045000;
double f1_M = 0;
double f2_M = 0;
double f1_MM = 0;
double f2_MM = 0;
double f1_CW_M = 0;
double f2_CW_M = 0;
double f1_CW_MM = 0;
double f2_CW_MM = 0;
double f1_jmh = 0;
double f2_jmh = 0;
double f1_CW_jmh = 0;
double f2_CW_jmh = 0;
int BAND_jmh;
int mem;
int mem_jmh;
int BAND;
int BAND_M;
int BAND_MM;
double IF;
double STEPD;
double STEP = 2.3863380645591;
int ritd = 0;
float wt = 0.1;
const int a=1;
int s;
int fbuf1;
int fbuf2;
int fbuf3;
int fbuf4;
int fbuf5;
int fbuf6;
int mode = 0;
int riton = 0;
int sig;
int CW_MODE = 0;
int CW_MODE_M;
double CW_OFFSET;
float del = 0.1;
int CW_IN = 0;;

void DDS(void);
void DDS_U(void);
void DDS_D(void);
void DDS_T(void);
void GET_LCD_DATA(void);
void STEPS(void);
void QSY(void);
void STEPSS(void);
void PTT_OFF(void);
void RIT(void);
// void MEMIN(void);
// void MEMOUT(void);
void JMH(void);
void JOZ(void);
void CW1(void);
void CW2(void);
void MODEX(void);
void MODEY(void);

I2cLCD lcd(dp5, dp27);
QEI wheel(dp2, dp28, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
//QEI wheel(dp2, dp28, NC, ROTATE_PER_REVOLUTIONS);

int main() {

    STEPD = 10;
    BAND = 7;
    FQD = FQD_7;
    FQ = FQ_7;
    
    RL1 = 1;
    RL2 = 0;
    lcd.locate(3,1);
    lcd.printf("SSB");

//    IF        = 10857171;//IF 455KHz
    CW_OFFSET = 22167;//CW OFSET 1KHz
    IF = 255259586;// IF 10.7MHz   
    LED = 0;
    s = 1;    
    
    RESET=0;
    RESET=1;
    wait_us(100);
    RESET=0;
    DATA=0;
    FQ_UD=0;
    W_CLK=0;
    
    W_CLK=1;
    wait_us(100);
    W_CLK=0;
    FQ_UD=1;
    wait_us(100);
    FQ_UD=0;
    wait_us(100);
    FQDD = FQD;
    GET_LCD_DATA();

    FQX = FQ + IF;    
    DDS(); 
    DDS();
    lcd.locate(9,0);
    lcd.printf("0MHz");
    lcd.locate(12,1);
    lcd.printf("1KHz");
    lcd.locate(14,0);
    lcd.printf("RX");
            
    fbuf2 = 0;
    
    while(1) {
        if (PTT_ON  == 0) {DDS_T();}
        if (BAND_SW == 0) {QSY();}
        if (JOG_3   == 1) {STEPS();}
        fbuf1 = wheel.getPulses();
        if (RIT_SW  == 1) {RIT();}
        if (fbuf1 > fbuf2) {DDS_U();}
        if (fbuf1 < fbuf2) {DDS_D();}
        fbuf2 = fbuf1;
        if (jmh == 1) {JOZ();}
//        if (memin == 0) {MEMIN();}
//        if (memout== 0) {MEMOUT();}
//        if (CW_MODE == 0 & CW_IN == 1 ) {CW1();}
//        if (CW_MODE == 1 & CW_IN == 0 ) {CW2();}
        if (MODE_IN == 1 ) {MODEX();}
    }
}

void DDS(void) {

    unsigned long int DDS_DATA;  
    unsigned long int BIT_DATA;

    int i = 0;

    DDS_DATA = FQX;
    
    for (i=0; i<32; i++) {
        BIT_DATA = DDS_DATA & 1;
        if(BIT_DATA==1) {
            DATA = 1;
        } else {
            DATA = 0;
        }
        W_CLK = 1;
        DDS_DATA = DDS_DATA >> 1;
        wait_us(10);
        W_CLK = 0;
        wait_us(10);
    } 
    
    DDS_DATA = a;
    
    for (i=0; i<8; i++) {
        BIT_DATA = DDS_DATA & 1;
        if(BIT_DATA==1) {
            DATA = 1;
        } else {
            DATA = 0;
        }
        W_CLK = 1;
        DDS_DATA = DDS_DATA >> 1;
        wait_us(10);
        W_CLK = 0;
        wait_us(10);
    }
    FQ_UD = 1;
    wait_us(10);
    FQ_UD = 0;
    wait_us(10);
}

void DDS_U(void) {
    
    if (riton==1) {
        if (ritd < 99) {
            ritd++;
            if ( CW_IN == 1 ) {
                FQX = FQ + STEP * ritd * 100 + IF + CW_OFFSET;
            }else{
                FQX = FQ + STEP * ritd * 100 + IF;
            }
            DDS();
            lcd.locate( 7,1 );
            lcd.printf("%d0 ",ritd);
        }
    } else { 
    
        if (s==0) {
            if ((FQD + STEPD) <= f2) {
                FQD = FQD + STEPD;
                FQ = FQ + STEP * 100; 
            }    
        }else{
            if ((FQD + STEPD * 100) <= f2) {
                FQD = FQD + STEPD * 100;
                FQ = FQ + STEP * 10000;
            }
        }
    
    FQDD = FQD;        
    GET_LCD_DATA();
    
    if ( CW_IN == 1 ) {
        FQX = FQ + IF + CW_OFFSET;
        }else{
        FQX = FQ + IF;
    }

    DDS();
    }
}

void DDS_D(void) {
    
    if (riton==1) {
        if (ritd > -99) {
            ritd--;
            if ( CW_IN == 1 ) {
                FQX = FQ + STEP * ritd * 100 + IF + CW_OFFSET;
            }else{
                FQX = FQ + STEP * ritd * 100 + IF;
            }
            DDS();
            lcd.locate( 7,1 );
            lcd.printf("%d0 ",ritd);
        }
    } else {    
        if (s==0) {
            if ((FQD - STEPD) >= f1) {
                FQD = FQD - STEPD;
                FQ = FQ - STEP * 100;
            }
        }else{
            if ((FQD - STEPD * 100) >= f1) {
                FQD = FQD - STEPD * 100;
                FQ = FQ - STEP * 10000;
            }
        }
    FQDD = FQD;
    GET_LCD_DATA();

    if ( CW_IN == 1 ) {
        FQX = FQ + IF + CW_OFFSET;
        }else{
        FQX = FQ + IF;
    }
    DDS();
    }
}
    
void DDS_T(void) {
      
    if (FQD > f1 && FQD < f2) {
        GET_LCD_DATA();
        lcd.locate( 14, 0 );
        lcd.printf( "TX" );

        FQX = FQ;
        DDS();
        LED = 1;
        PTT_OUT = 1;
        while( PTT_ON == 0) {}
        PTT_OUT = 0;
        LED = 0;
        FQX = FQ + IF;
        DDS();
    }else{
        LED=1;
        wait(0.2);
        LED=0;
        wait(0.2);
    }
    GET_LCD_DATA();
    lcd.locate( 14,0 );
    lcd.printf( "RX" );     
}

void GET_LCD_DATA(void) {

    char f[9];
    
    sprintf(f,"%8.5lf",FQDD / 1000000);    
    lcd.locate( 0,0 );
    lcd.printf( "%c%c%c%c%c%c",f[0],f[1],f[2],f[3],f[4],f[5] );
    lcd.printf( ".%c%c%",f[6],f[7] );

    if (FQDD >= f1_CW && FQDD < f2_CW) {
        lcd.locate( 0,1 );
        lcd.printf("CW");
    }else{
        if(FQDD >= f2_CW && FQDD < f2 ) {
            lcd.locate( 0,1 );
            lcd.printf("Ph");
    }else{
        lcd.locate( 0,1 );
        lcd.printf("no");
        }
    }
}

void STEPS( void ) {

    if (s==1) {
        s = 0;
        lcd.locate(12,1);
        lcd.printf("10");
    }else{
        s = 1;
        lcd.locate(12,1);
        lcd.printf("1K");
    }
    wait(0.3);

}

void QSY(void) {
       
     switch ( BAND ) {
     case 7:
        BAND = 10;
        FQD_7 = FQD;
        FQD = FQD_10;
        FQ_7 = FQ;
        FQ = FQ_10;
        f1 = 10100000;
        f2 = 10150000;
        f1_CW = 10100000;
        f2_CW = 10150000;
        break;

        
    case 10:
        BAND = 14;
        FQD_10 = FQD;
        FQD = FQD_14;
        FQ_10 = FQ;
        FQ = FQ_14;
        f1 =   14000000;
        f2 =   14350000;
        f1_CW =14000000;
        f2_CW =14100000;
        break;
/////////////
    case 14:
        BAND = 351;
        FQD_14 = FQD;
        FQD = FQD_351;
        FQ_14 = FQ;
        FQ = FQ_351;
        f1 =   3500000;
        f2 =   3575000;
        f1_CW =3500000;
        f2_CW =3535000;
        break;
/////////////        
    case 351:
        BAND = 352;
        FQD_351 = FQD;
        FQD = FQD_352;
        FQ_351 = FQ;
        FQ = FQ_352;
        f1 = 3599000;
        f2 = 3612000;
        f1_CW = 3599000;
        f2_CW = 3599000;
        break;

    case 352:  
        BAND = 353;
        FQD_352 = FQD;
        FQD = FQD_353;
        FQ_352 = FQ;
        FQ = FQ_353;
        f1 = 3680000;
        f2 = 3687000;
        f1_CW = 3680000;
        f2_CW = 3680000;
        break;
        
    case 353:
        BAND = 381;
        FQD_353 = FQD;
        FQD = FQD_381;
        FQ_353 = FQ;
        FQ = FQ_381;
        f1 = 3702000;
        f2 = 3716000;
        f1_CW = 3702000;
        f2_CW = 3702000;
        break;

    case 381:
        BAND = 382;
        FQD_381 = FQD;
        FQD = FQD_382;
        FQ_381 = FQ;
        FQ = FQ_382;
        f1 = 3745000;
        f2 = 3770000;
        f1_CW = 3745000;
        f2_CW = 3745000;
        break;

    case 382:
        BAND = 383;
        FQD_382 = FQD;
        FQD = FQD_383;
        FQ_382 = FQ;
        FQ = FQ_383;
        f1 = 3791000;
        f2 = 3805000;
        f1_CW = 3791000;
        f2_CW = 3791000;
        break;

    case 383:
        BAND = 4;
        FQD_383 = FQD;
        FQD = FQD_4;
        FQ_383 = FQ;
        FQ = FQ_4;
        f1 = 4629999;
        f2 = 4630001;
        f1_CW = 4630000;
        f2_CW = 4630001;
        break;


    case 4:
        BAND = 7;
        FQD_4 = FQD;
        FQD = FQD_7;
        FQ_4 = FQ;
        FQ = FQ_7;
        f1 = 7000000;
        f2 = 7200000;
        f1_CW = 7000000;
        f2_CW = 7045000;
        break;        


    default:
        BAND = 7;
        FQD = FQD_7;
        FQ = FQ_7;
        break;
    }
    FQDD = FQD;
    GET_LCD_DATA();
    FQX = FQ + IF;
    DDS();
    wait(0.3);
}

void STEPSS( void ) {
    if (s==0) {
        lcd.locate(13,1);
        lcd.printf("0");
    }else{
        lcd.locate(13,1);
        lcd.printf("K");
    }    
}

void PTT_OFF(void) {
    PTT_OUT = 0;
    LED = 0;
    FQX = FQ + IF;
    DDS();
    GET_LCD_DATA();
    lcd.locate( 14,0 );
    lcd.printf( "RX" );  
}

void RIT(void) {
    
    if ( riton == 0) {
        riton = 1;
        lcd.locate(3,1);
        lcd.printf("RIT:");
        lcd.locate( 7,1 );
        lcd.printf("%d0 ",ritd);
        
    if ( CW_IN == 1 ) {
        FQX = FQ + STEP * ritd * 100+ IF + CW_OFFSET;
        }else{
        FQX = FQ + STEP * ritd * 100+ IF;
    }
        
        DDS();
    } else {
        riton = 0;
        lcd.locate(3,1);
        lcd.printf("        ");
        MODEY();
    if ( CW_IN == 1 ) {
        FQX = FQ + STEP + IF + CW_OFFSET;
        }else{
        FQX = FQ + STEP + IF;
    }
        DDS();
    }
    wait(0.2);
}


//void MEMIN(void) {
//    if(mem == 0 ) {
//        BAND_M = BAND;
//        FQD_M = FQD;
//        FQ_M  = FQ;
//        f1_M = f1;
//        f2_M = f2;
//        f1_CW_M = f1_CW;
//        f2_CW_M = f2_CW;
//        mem = 1;
//        CW_MODE_M = CW_MODE;
//        lcd.locate(11,1);
//        lcd.printf("M");
//    }else{
//        mem = 0;
//        lcd.locate(11,1);
//        lcd.printf(" ");
//    }
//    wait(0.3);        
//}

//void MEMOUT(void) {
//    if (mem == 1) {
//        BAND_MM = BAND;
//        FQD_MM = FQD;
//        FQ_MM  = FQ;
//        f1_MM = f1;
//        f2_MM = f2;
//        f1_CW_M = f1_CW;
//        f2_CW_M = f2_CW;
//        FQD = FQD_M;
//        FQ  = FQ_M;
//        f1  = f1_M;
//        f2  = f2_M;
//        f1_CW = f1_CW_M;
//        f2_CW = f2_CW_M;
//        FQDD = FQD;
//        GET_LCD_DATA();
//        if (CW_MODE_M == 1) {
//            FQX = FQ + IF + CW_OFFSET;
//        }else{
//            FQX = FQ + IF;
//        }
//        DDS();
//        mem = 0;
//        lcd.locate(11,1);
//        lcd.printf(" ");
//    } else {
//        BAND = BAND_MM;
 //       FQD = FQD_MM;
 //       FQ  = FQ_MM;
//        f1  = f1_MM;
//        f2  = f2_MM;
//        f1_CW = f1_CW_M;
//        f2_CW = f2_CW_M;
//        FQDD = FQD;
//        GET_LCD_DATA();
//        if (CW_MODE_M == 1) {
//            FQX = FQ + IF + CW_OFFSET;
//        }else{
//            FQX = FQ + IF;
//        }
//        FQX = FQ + IF;
//        DDS();
//    }        
//    wait(0.1);
//}    

void JMH(void) {

    if (mem_jmh == 0) {
    FQD = FQD_JMH;
    FQ  = FQ_JMH;
    f1  = FQD_JMH;
    f2  = FQD_JMH;
    f1_CW = FQD_JMH;
    f2_CW = FQD_JMH;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();        
    DDS();
    lcd.locate(7,1);
    lcd.printf("JMH ");
        
    }else{
    if (mem_jmh == 1) {
    FQD = FQD_JMH1;
    FQ  = FQ_JMH1;
    f1  = FQD_JMH1;
    f2  = FQD_JMH1;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();
    lcd.locate(7,1);
    lcd.printf("JMH ");

    }else{
    if (mem_jmh == 2) {
    FQD = FQD_VOK1;
    FQ  = FQ_VOK1;
    f1  = FQD_VOK1;
    f2  = FQD_VOK1;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();      
    lcd.locate(7,1);
    lcd.printf("VOK ");

    }else{
    if (mem_jmh == 3) {
    FQD = FQD_VOK2;
    FQ  = FQ_VOK2;
    f1  = FQD_VOK2;
    f2  = FQD_VOK2;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();        
    lcd.locate(7,1);
    lcd.printf("VOK ");

    }else{
    if (mem_jmh == 4) {
    FQD = FQD_KCBS;
    FQ  = FQ_KCBS;
    f1  = FQD_KCBS;
    f2  = FQD_KCBS;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();        
    lcd.locate(7,1);
    lcd.printf("KCBS");


    }else{
    if (mem_jmh == 5) {
    FQD = FQD_NSB1;
    FQ  = FQ_NSB1;
    f1  = FQD_NSB1;
    f2  = FQD_NSB1;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();        
    lcd.locate(7,1);
    lcd.printf("NSB1");


    }else{
    if (mem_jmh == 6) {
    FQD = FQD_NSB2;
    FQ  = FQ_NSB2;
    f1  = FQD_NSB2;
    f2  = FQD_NSB2;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();      
    lcd.locate(7,1);
    lcd.printf("NSB2");
    
    }else{
    if (mem_jmh == 7) {
    FQD = FQD_NSB3;
    FQ  = FQ_NSB3;
    f1  = FQD_NSB3;
    f2  = FQD_NSB3;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();
//    mem_jmh = 8;        
    lcd.locate(7,1);
    lcd.printf("NSB1");

    }else{
    if (mem_jmh == 8) {
    FQD = FQD_NSB4;
    FQ  = FQ_NSB4;
    f1  = FQD_NSB4;
    f2  = FQD_NSB4;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();
//    mem_jmh = 9;        
    lcd.locate(7,1);
    lcd.printf("NSB2");

    }else{
    if (mem_jmh == 9) {
    FQD = FQD_NSB5;
    FQ  = FQ_NSB5;
    f1  = FQD_NSB5;
    f2  = FQD_NSB5;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();        
    lcd.locate(7,1);
    lcd.printf("NSB1");

    }else{
    if (mem_jmh == 10) {
    FQD = FQD_NSB6;
    FQ  = FQ_NSB6;
    f1  = FQD_NSB6;
    f2  = FQD_NSB6;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();
//    mem_jmh = 11;        
    lcd.locate(7,1);
    lcd.printf("NSB2");


    }else{
    if (mem_jmh == 11) {
    FQD = FQD_CRI;
    FQ  = FQ_CRI;
    f1  = FQD_CRI;
    f2  = FQD_CRI;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();
//    mem_jmh = 12;        
    lcd.locate(7,1);
    lcd.printf("CRI ");


    }else{
    if (mem_jmh == 12) {
    FQD = FQD_NHK;
    FQ  = FQ_NHK;
    f1  = FQD_NHK;
    f2  = FQD_NHK;
    f1_CW = FQD_JMH1;
    f2_CW = FQD_JMH1;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();       
    lcd.locate(7,1);
    lcd.printf("NHK ");    
    
    } else {
    lcd.locate(7,1);
    lcd.printf("    ");
}
}
}
}                
}
}
}
}
}
}        
}
}
}
    wait(0.2);
}

void CW1(void) {
    
    if ( riton == 1 ) {
        FQX = FQ + STEP * ritd * 100 + IF + CW_OFFSET;
    } else {
        FQX = FQ + IF + CW_OFFSET;
    }
    DDS();
    
    FQDD = FQD;        
    GET_LCD_DATA();

    CW_MODE = 1;
    DDS();
}

void CW2(void) {
    if ( riton == 1 ) {
        FQX = FQ + STEP * ritd * 100 + IF;
    } else {
        FQX = FQ + IF;
    }
    DDS();
    
    FQDD = FQD;        
    GET_LCD_DATA();

    CW_MODE = 0;
    DDS();
}

void JOZ(void) {

    BAND_jmh = BAND;
    FQD_jmh = FQD;
    FQ_jmh  = FQ;
    f1_jmh = f1;
    f2_jmh = f2;
    f1_CW_jmh = f1_CW;
    f2_CW_jmh = f2_CW;
    fbuf5 = fbuf1;
    fbuf6 = fbuf2;
    fbuf3 = 0;
    fbuf4 = 0;

    JMH();
    wait(0.5);

    while (jmh == 0) {
 
        if (MODE_IN == 1 ) {MODEX();}
 
        if (CW_MODE == 1 ) {CW1();}
        if (CW_MODE != 1 ) {CW2();}
        
        fbuf3 = wheel.getPulses();
        if (fbuf3 > fbuf4) {
            if (mem_jmh <12 ) {
                mem_jmh++;
                JMH();
            }
        }
        if (fbuf3 < fbuf4) {
            if (mem_jmh > 0) {
                mem_jmh--;
                JMH();
            }
        }
        fbuf4 = fbuf3;

    }
    
    fbuf3 = 0;
    fbuf4 = 0;
    fbuf1 = fbuf5;
    fbuf2 = fbuf6;
    BAND = BAND_jmh;
    FQD = FQD_jmh;
    FQ  = FQ_jmh;
    f1  = f1_jmh;
    f2  = f2_jmh;
    f1_CW = f1_CW_jmh;
    f2_CW = f2_CW_jmh;
    FQDD = FQD;
    FQX = FQ + IF;
    GET_LCD_DATA();
    DDS();

    lcd.locate(7,1);
    lcd.printf("    ");
    MODEY();
    wait(0.3);
}

void MODEX(void) {
    if (CW_IN == 0) {
        CW_IN++;
        RL1 = 1;
        RL2 = 1;
        CW1();
        lcd.locate(3,1);
        lcd.printf("CW ");
        wait(0.3);
    }else{
        if (CW_IN == 1) {
            CW_IN++;
            RL1 = 0;
            RL2 = 0;
            CW2();
            lcd.locate(3,1);
            lcd.printf("AM ");
            wait(0.3);
        }else{
            if (CW_IN == 2)  {
                CW_IN = 0;
                RL1= 1;
                RL2= 0;
                lcd.locate(3,1);
                lcd.printf("SSB");
                wait(0.3);
                CW2();
                CW_IN = 0;
            }
        }
    }
//    DDS_U();
}

void MODEY(void) {
    if (CW_IN == 0) {
        lcd.locate(3,1);
        lcd.printf("SSB");
    }else{
        if (CW_IN == 1) {
            lcd.locate(3,1);
            lcd.printf("CW ");
        }else{
            if (CW_IN == 2)  {
                lcd.locate(3,1);
                lcd.printf("AM ");
            }
        }
    }
//    DDS_U();
}                                