//8x2 lcd
#ifndef MBED_I2CLCD_H
#define MBED_I2CLCD_H

#include "mbed.h"

class I2cLCD : public Stream {
public:

    I2cLCD(PinName sda, PinName scl);
#if DOXYGEN_ONLY
    int putc(int c);
    int printf(const char* format, ...);
#endif
    void locate(int column, int row);
    void cls();
    int rows();
    int columns();
    void puticon(int flg);
    
protected:
    virtual int _putc(int value);
    virtual int _getc();

    int address(int column, int row);
    void character(int column, int row, int c);
    void writeCommand( int cmd );
    void writeData( int data );
    
    //DigitalOut _rs;
    I2C    _i2c;
    int _column;
    int _row;
    
    char contrast;
    int icon;
    
};

#endif