#include "mbed.h"
#include "colors.h"
#include "timers.h"

#define fbW 53
#define fbH 242

DigitalOut vSync(p29);
DigitalOut hSync(p30);

DigitalOut myled(LED1);


void vsync();
void hsync();
void setup();
void loop();
void blankFB();
void fill();

unsigned int frame = 0;
unsigned char framebuffer[fbH][fbW];

int snake_x = 5;
int snake_y = 50; 
int snake_direction = 0;
unsigned char snake_color = 1;


TIMER0_INTERRUPT_HANDLER(void)
{
    TIMER0_CLEAR_INTERRUPT(MR0_INT);
    
    myled = 1;

    vsync();
    for( int i = 0; i < fbH; i++ )
    {
        hsync();
        for( int j = 0; j < fbW; j++ )
        {
            unsigned char bp = framebuffer[ i ][ j ];
            COLOR_SET(bp);
        }
    }
    COLOR_SET(0);
    myled = 0;    
}

int main() {
    fill();
    NVIC_SetPriority(TIMER0_IRQn, 0);

    COLOR_INIT();
    TIMER0_INIT();
    TIMER0_SETPCLK(CCLK4);
    TIMER0_SETPRESCALE(96000); // 1ms = 96000 : 1
    TIMER0_SETMATCH(0, 1);
    TIMER0_SETMATCHCONTROL(0, MATCH_RESET | MATCH_INTERRUPT); // Reset and Interrupt each 100ms
    TIMER0_ENABLE_INTERRUPT();
    TIMER0_START();

    setup();
    
    while (1)
        loop();
}

void setup() {

}

void drawRectangle(int x, int y, int width, int height, unsigned char color) {
        
        if (x < 0 || y < 0)
            return; 
            
        for (int i = 0; i < height; i++) {

               for (int j = 0; j < width; j++) {
                                                                
                    framebuffer[ (y + i) % fbH ][ (x + j) % fbW ] = color;
                    
               }
        }
}


void loop() {

    if (snake_y <= 0)
        snake_y = fbH - 1;
    
    if (snake_x <= 0)
        snake_x = fbW - 1;
        
    snake_y %= fbH;
    snake_x %= fbW;
    
    if (frame % (10 + rand() % 20) == 0) {
        snake_direction++;
        snake_direction %= 4;
        
        snake_color++;
    }
    
    
    switch (snake_direction) {
        case 0:
            snake_y += 4;
            break;
        case 2:
            snake_y -= 4;
            break;
        case 1:
            snake_x += 1;
            break;
        case 3:
            snake_x -= 1;
            break;
     }

    drawRectangle(snake_x, snake_y, 1, 4, snake_color);
    wait_us(10000);
}

void draw() 
{

}


void hsync() 
{

    COLOR_SET(0);
    hSync = 1;
    wait_us(4.8);
    hSync = 0;
    wait_us(4);
}

void vsync() 
{
    vSync = 1;
    wait_us(1300);//650
    vSync = 0;
    frame++;
    
    if (frame == 65535)
        frame = 0;
}



void fill() {

    for (int i = 0; i < fbH; i++) {

        for (int j = 0; j < fbW; j++) {
            
            if ( (i / 5) % 2 == 0 ) {
            
                 if ( (j / 2) % 2 == 0 )
                    framebuffer[i][j] = 3;
                else
                    framebuffer[i][j] = 0;
            }
            else {
                if ( (j / 2) % 2 == 0 )
                    framebuffer[i][j] = 0;
                else
                    framebuffer[i][j] = 28;
            }
        }
    }

}

void blankFB() {
    for (int i = 0; i < fbH; i++) {
        for (int j = 0; j < fbW; j++) {
            framebuffer[i][j] = 0;
        }
    }

}