/*
* WiiClassicControllerReader. A program allowing the output of one or two
* Wii Classic Controllers to be read via I2C and decoded for use, using the mbed 
* microcontroller and its associated libraries.
*
* Written by Alfredo Guerrero <alfredog83@gmail.com> for the mbedGC open-source 
* game console <http://www.mbedgc.com>. Based on the original code for
* the WiiNunchuckReader written by Petras Saduikis <petras@petras.co.uk>.
*
* This file is part of WiiClassicControllerReader.
*
* WiiClassicControllerReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* WiiClassicControllerReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You can find a copy of the GNU General Public License at <http://www.gnu.org/licenses/>.
*/

#ifndef ALFREDOG83_WIICLASSICCONTROLLERREADER_H
#define ALFREDOG83_WIICLASSICCONTROLLERREADER_H

#include <mbed.h>
#include "WiiClassicControllerDefs.h"

typedef unsigned char BYTE;

class WiiClassicControllerReader
{
public:
    // constructors
    WiiClassicControllerReader(PinName sda, PinName scl);
    
    // functions
    void RequestRead();
    
    // accessors
    int getLJoyX() const { return ljoyX; }
    int getLJoyY() const { return ljoyY; }
    int getRJoyX() const { return rjoyX; }
    int getRJoyY() const { return rjoyY; }
    int getButtonX() const { return buttonX; }
    int getButtonY() const { return buttonY; }
    int getButtonA() const { return buttonA; }
    int getButtonB() const { return buttonB; }
    int getButtonLT() const { return buttonLT; }
    int getButtonRT() const { return buttonRT; }
    int getButtonLC() const { return buttonLC; }
    int getButtonRC() const { return buttonRC; }
    int getButtonZL() const { return buttonZL; }
    int getButtonZR() const { return buttonZR; }
    int getButtonSELECT() const { return buttonSELECT; }
    int getButtonHOME() const { return buttonHOME; }
    int getButtonSTART() const { return buttonSTART; }
    int getButtonDU() const { return buttonDU; }
    int getButtonDD() const { return buttonDD; }
    int getButtonDL() const { return buttonDL; }
    int getButtonDR() const { return buttonDR; }
    int getBufferSize() const { return sizeof(readBuf); }
    char* getReadBuf() { return readBuf; }
    
private:
    // classic controls states
    int ljoyX;
    int ljoyY;
    int rjoyX;
    int rjoyY;
    int buttonY;
    int buttonX;
    int buttonB;
    int buttonA;
    int buttonLT;
    int buttonRT;
    int buttonLC;
    int buttonRC;
    int buttonZL;
    int buttonZR;
    int buttonSELECT;
    int buttonHOME;
    int buttonSTART;
    int buttonDU;
    int buttonDD;
    int buttonDL;
    int buttonDR;
    
    // classic init state
    bool controllerInit;
    
    // classic I2C port
    I2C controllerPort;
    
    // read data
    char readBuf[CONTROLLER_READLEN];
    
    // functions    
    bool ControllerInit();
    bool ControllerRead();
    void ControllerDecode();
};

#endif