/*
* Copyright or &#65533; or Copr. 2010, Thomas SOETE
* 
* Author e-mail: thomas@soete.org
* Library website : http://mbed.org/users/Alkorin/libraries/SimpleLib/
* 
* This software is governed by the CeCILL license under French law and
* abiding by the rules of distribution of free software.  You can  use, 
* modify and/ or redistribute the software under the terms of the CeCILL
* license as circulated by CEA, CNRS and INRIA at the following URL
* "http://www.cecill.info". 
* 
* As a counterpart to the access to the source code and  rights to copy,
* modify and redistribute granted by the license, users are provided only
* with a limited warranty  and the software's author,  the holder of the
* economic rights,  and the successive licensors  have only  limited
* liability. 
* 
* In this respect, the user's attention is drawn to the risks associated
* with loading,  using,  modifying and/or developing or reproducing the
* software by the user in light of its specific status of free software,
* that may mean  that it is complicated to manipulate,  and  that  also
* therefore means  that it is reserved for developers  and  experienced
* professionals having in-depth computer knowledge. Users are therefore
* encouraged to load and test the software's suitability as regards their
* requirements in conditions enabling the security of their systems and/or 
* data to be ensured and,  more generally, to use and operate it in the 
* same conditions as regards security. 
* 
* The fact that you are presently reading this means that you have had
* knowledge of the CeCILL license and that you accept its terms.
*/

#ifndef __SIMPLELIB_ETHERNET_H__
#define __SIMPLELIB_ETHERNET_H__

typedef __packed struct {
    char destination[6];
    char source[6];
    uint16_t type;
} ethernet_packet;
#define asETH(x) ((ethernet_packet*)(x))

#define IPV4_TYPE 0x0800
#define ARP_TYPE  0x0806

typedef __packed struct {
    ethernet_packet eth;
    __packed struct {
        char hardware_type[2];
        char protocol_type[2];
        char hardware_size;
        char protocol_size;
        uint16_t opcode_request;
        char sender_mac[6];
        char sender_ip[4];
        char target_mac[6];
        char target_ip[4];
    } arp;
} arp_packet;
#define asARP(x) ((arp_packet*)(x))

#define ARP_REQUEST 0x0001
#define ARP_REPLY   0x0002

#endif