/*
* WiiClassicControllerReader. A program allowing the output of one or two
* Wii Classic Controllers to be read via I2C and decoded for use, using the mbed 
* microcontroller and its associated libraries.
*
* Written by Alfredo Guerrero <alfredog83@gmail.com> for the mbedGC open-source 
* game console <http://www.mbedgc.com>. Based on the original code for
* the WiiNunchuckReader written by Petras Saduikis <petras@petras.co.uk>.
*
* This file is part of WiiClassicControllerReader.
*
* WiiClassicControllerReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* WiiClassicControllerReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You can find a copy of the GNU General Public License at <http://www.gnu.org/licenses/>.
*/

#ifndef ALFREDOG83_WIICLASSICCONTROLLERDEFS_H
#define ALFREDOG83_WIICLASSICCONTROLLERDEFS_H

// I2C
#define CONTROLLER_ADDR     0xA4  // I2C library doesn't right shift the address, so provided shifted
#define CONTROLLER_REGADDR  0x40  // relevant register address
#define CONTROLLER_READLEN  0x06  // always read this many bytes back

// bitmasks for individual buttons
// LX, LY: left analog stick X, Y (0-63)
// RX, RY: right analog stick X, Y (0-31) [RX separated among bytes 0-2]
// RT, LT: right, left trigger (0-31) [LT separated among bytes 2-3]
// B{ZR,ZL,A,B,X,Y,START,HOME,SELECT}: discrete buttons
// BD{L,R,U,D}: D-pad direction buttons
// LC,RC: digital button click of LT, RT when pressed down all the way
#define MASK_LX         0x3F    // LX<5:0>
#define MASK_RX34       0xC0    // RX<4:3>
#define MASK_LY         0x3F    // LY<5:0>
#define MASK_RY         0x1F    // RY<4:0>
#define MASK_LT34       0x60    // LT<4:3>
#define MASK_RT         0x1F    // RT<4:0>
#define MASK_BDU        0x01    // DU
#define MASK_RC_DL      0x02    // DL, RC
#define MASK_BSTART_ZR  0x04    // ZR, START
#define MASK_BHOME_X    0x08    // X, HOME
#define MASK_BSELECT_A  0x10    // A, SELECT
#define MASK_LC_Y       0x20    // LC, Y, LT<0>
#define MASK_BDD_B      0x40    // B, DD, LT<1>, RX<1>
#define MASK_BDR_ZL     0x80    // ZL, DR, LT<2>, RX<0>, RX<2>

// timing
#define I2C_READ_DELAY  0.01

// I2C status
#define I2C_OK        0    // zero on success (ACK), non-zero on fail (NACK) for read or write

#endif