/*
* Copyright or  or Copr. 2010, Thomas SOETE
* 
* Author e-mail: thomas@soete.org
* Library website : http://mbed.org/users/Alkorin/libraries/SimpleLib/
* 
* This software is governed by the CeCILL license under French law and
* abiding by the rules of distribution of free software.  You can  use, 
* modify and/ or redistribute the software under the terms of the CeCILL
* license as circulated by CEA, CNRS and INRIA at the following URL
* "http://www.cecill.info". 
* 
* As a counterpart to the access to the source code and  rights to copy,
* modify and redistribute granted by the license, users are provided only
* with a limited warranty  and the software's author,  the holder of the
* economic rights,  and the successive licensors  have only  limited
* liability. 
* 
* In this respect, the user's attention is drawn to the risks associated
* with loading,  using,  modifying and/or developing or reproducing the
* software by the user in light of its specific status of free software,
* that may mean  that it is complicated to manipulate,  and  that  also
* therefore means  that it is reserved for developers  and  experienced
* professionals having in-depth computer knowledge. Users are therefore
* encouraged to load and test the software's suitability as regards their
* requirements in conditions enabling the security of their systems and/or 
* data to be ensured and,  more generally, to use and operate it in the 
* same conditions as regards security. 
* 
* The fact that you are presently reading this means that you have had
* knowledge of the CeCILL license and that you accept its terms.
*/

#ifndef __SIMPLELIB_IP_H__
#define __SIMPLELIB_IP_H__

#include "ip.h"

typedef __packed struct {
    unsigned char version:4;
    unsigned char length:4;
    unsigned char services;
    uint16_t total_length;
    uint16_t identification;
    unsigned int flags:3;
    unsigned fragment_offset:13;
    unsigned char ttl;
    unsigned char protocol;
    uint16_t header_checksum;
    unsigned char source[4];
    unsigned char destination[4];
} s_ip;

typedef __packed struct {
    ethernet_packet eth;
    s_ip ip;
} ipv4_packet;
#define asIPV4(x) ((ipv4_packet*)(x))

#define PROTO_ICMP  0x01

typedef __packed struct {
    ethernet_packet eth;
    s_ip ip;
    __packed struct {
        unsigned char type;
        unsigned char code;
        uint16_t checksum;
        uint16_t identifier;
        uint16_t sequence_number;
        unsigned char data[];
    } icmp;
} icmp_packet;
#define asICMP(x) ((icmp_packet*)(x))

#define ICMP_REQUEST 0x08
#define ICMP_REPLY   0x00

#endif