/*
* Copyright or  or Copr. 2010, Thomas SOETE
* 
*    MODIFIED BY J.P. ARMSTRONG FROM WWW.MBEDGC.COM
*
* Author e-mail: thomas@soete.org
* Library website : http://mbed.org/users/Alkorin/libraries/SimpleLib/
* 
* This software is governed by the CeCILL license under French law and
* abiding by the rules of distribution of free software.  You can  use, 
* modify and/ or redistribute the software under the terms of the CeCILL
* license as circulated by CEA, CNRS and INRIA at the following URL
* "http://www.cecill.info". 
* 
* As a counterpart to the access to the source code and  rights to copy,
* modify and redistribute granted by the license, users are provided only
* with a limited warranty  and the software's author,  the holder of the
* economic rights,  and the successive licensors  have only  limited
* liability. 
* 
* In this respect, the user's attention is drawn to the risks associated
* with loading,  using,  modifying and/or developing or reproducing the
* software by the user in light of its specific status of free software,
* that may mean  that it is complicated to manipulate,  and  that  also
* therefore means  that it is reserved for developers  and  experienced
* professionals having in-depth computer knowledge. Users are therefore
* encouraged to load and test the software's suitability as regards their
* requirements in conditions enabling the security of their systems and/or 
* data to be ensured and,  more generally, to use and operate it in the 
* same conditions as regards security. 
* 
* The fact that you are presently reading this means that you have had
* knowledge of the CeCILL license and that you accept its terms.
*/

#ifndef __SIMPLELIB_LEDS_H__
#define __SIMPLELIB_LEDS_H__

#include "mbed_globals.h"

/** Bits **/
#define COLOR_OFF 0
#define RED1 (1 << 16)
#define RED2 (1 << 23)
#define RED3 (1 << 24)
#define GRN1 (1 << 25)
#define GRN2 (1 << 9)
#define GRN3 (1 << 8)

#define BLU1 (1 << 7)
#define BLU2 (1 << 6)

#define COLOR_MASK ( RED1 | RED2 | RED3 | GRN1 | GRN2 | GRN3 | BLU1 | BLU2 )

const uint32_t COLOR_VAR_MASK[] = {
	RED1, 
	RED2, 
	RED1|RED2, 
	RED3, 
	RED1|RED3, 
	RED2|RED3, 
	RED1|RED2|RED3, 
	GRN1, 
	RED1|GRN1, 
	RED2|GRN1, 
	RED1|RED2|GRN1, 
	RED3|GRN1, 
	RED1|RED3|GRN1, 
	RED2|RED3|GRN1, 
	RED1|RED2|RED3|GRN1, 
	GRN2, 
	RED1|GRN2, 
	RED2|GRN2, 
	RED1|RED2|GRN2, 
	RED3|GRN2, 
	RED1|RED3|GRN2, 
	RED2|RED3|GRN2, 
	RED1|RED2|RED3|GRN2, 
	GRN1|GRN2, 
	RED1|GRN1|GRN2, 
	RED2|GRN1|GRN2, 
	RED1|RED2|GRN1|GRN2, 
	RED3|GRN1|GRN2, 
	RED1|RED3|GRN1|GRN2, 
	RED2|RED3|GRN1|GRN2, 
	RED1|RED2|RED3|GRN1|GRN2, 
	GRN3, 
	RED1|GRN3, 
	RED2|GRN3, 
	RED1|RED2|GRN3, 
	RED3|GRN3, 
	RED1|RED3|GRN3, 
	RED2|RED3|GRN3, 
	RED1|RED2|RED3|GRN3, 
	GRN1|GRN3, 
	RED1|GRN1|GRN3, 
	RED2|GRN1|GRN3, 
	RED1|RED2|GRN1|GRN3, 
	RED3|GRN1|GRN3, 
	RED1|RED3|GRN1|GRN3, 
	RED2|RED3|GRN1|GRN3, 
	RED1|RED2|RED3|GRN1|GRN3, 
	GRN2|GRN3, 
	RED1|GRN2|GRN3, 
	RED2|GRN2|GRN3, 
	RED1|RED2|GRN2|GRN3, 
	RED3|GRN2|GRN3, 
	RED1|RED3|GRN2|GRN3, 
	RED2|RED3|GRN2|GRN3, 
	RED1|RED2|RED3|GRN2|GRN3, 
	GRN1|GRN2|GRN3, 
	RED1|GRN1|GRN2|GRN3, 
	RED2|GRN1|GRN2|GRN3, 
	RED1|RED2|GRN1|GRN2|GRN3, 
	RED3|GRN1|GRN2|GRN3, 
	RED1|RED3|GRN1|GRN2|GRN3, 
	RED2|RED3|GRN1|GRN2|GRN3, 
	RED1|RED2|RED3|GRN1|GRN2|GRN3, 
	BLU1, 
	RED1|BLU1, 
	RED2|BLU1, 
	RED1|RED2|BLU1, 
	RED3|BLU1, 
	RED1|RED3|BLU1, 
	RED2|RED3|BLU1, 
	RED1|RED2|RED3|BLU1, 
	GRN1|BLU1, 
	RED1|GRN1|BLU1, 
	RED2|GRN1|BLU1, 
	RED1|RED2|GRN1|BLU1, 
	RED3|GRN1|BLU1, 
	RED1|RED3|GRN1|BLU1, 
	RED2|RED3|GRN1|BLU1, 
	RED1|RED2|RED3|GRN1|BLU1, 
	GRN2|BLU1, 
	RED1|GRN2|BLU1, 
	RED2|GRN2|BLU1, 
	RED1|RED2|GRN2|BLU1, 
	RED3|GRN2|BLU1, 
	RED1|RED3|GRN2|BLU1, 
	RED2|RED3|GRN2|BLU1, 
	RED1|RED2|RED3|GRN2|BLU1, 
	GRN1|GRN2|BLU1, 
	RED1|GRN1|GRN2|BLU1, 
	RED2|GRN1|GRN2|BLU1, 
	RED1|RED2|GRN1|GRN2|BLU1, 
	RED3|GRN1|GRN2|BLU1, 
	RED1|RED3|GRN1|GRN2|BLU1, 
	RED2|RED3|GRN1|GRN2|BLU1, 
	RED1|RED2|RED3|GRN1|GRN2|BLU1, 
	GRN3|BLU1, 
	RED1|GRN3|BLU1, 
	RED2|GRN3|BLU1, 
	RED1|RED2|GRN3|BLU1, 
	RED3|GRN3|BLU1, 
	RED1|RED3|GRN3|BLU1, 
	RED2|RED3|GRN3|BLU1, 
	RED1|RED2|RED3|GRN3|BLU1, 
	GRN1|GRN3|BLU1, 
	RED1|GRN1|GRN3|BLU1, 
	RED2|GRN1|GRN3|BLU1, 
	RED1|RED2|GRN1|GRN3|BLU1, 
	RED3|GRN1|GRN3|BLU1, 
	RED1|RED3|GRN1|GRN3|BLU1, 
	RED2|RED3|GRN1|GRN3|BLU1, 
	RED1|RED2|RED3|GRN1|GRN3|BLU1, 
	GRN2|GRN3|BLU1, 
	RED1|GRN2|GRN3|BLU1, 
	RED2|GRN2|GRN3|BLU1, 
	RED1|RED2|GRN2|GRN3|BLU1, 
	RED3|GRN2|GRN3|BLU1, 
	RED1|RED3|GRN2|GRN3|BLU1, 
	RED2|RED3|GRN2|GRN3|BLU1, 
	RED1|RED2|RED3|GRN2|GRN3|BLU1, 
	GRN1|GRN2|GRN3|BLU1, 
	RED1|GRN1|GRN2|GRN3|BLU1, 
	RED2|GRN1|GRN2|GRN3|BLU1, 
	RED1|RED2|GRN1|GRN2|GRN3|BLU1, 
	RED3|GRN1|GRN2|GRN3|BLU1, 
	RED1|RED3|GRN1|GRN2|GRN3|BLU1, 
	RED2|RED3|GRN1|GRN2|GRN3|BLU1, 
	RED1|RED2|RED3|GRN1|GRN2|GRN3|BLU1, 
	BLU2, 
	RED1|BLU2, 
	RED2|BLU2, 
	RED1|RED2|BLU2, 
	RED3|BLU2, 
	RED1|RED3|BLU2, 
	RED2|RED3|BLU2, 
	RED1|RED2|RED3|BLU2, 
	GRN1|BLU2, 
	RED1|GRN1|BLU2, 
	RED2|GRN1|BLU2, 
	RED1|RED2|GRN1|BLU2, 
	RED3|GRN1|BLU2, 
	RED1|RED3|GRN1|BLU2, 
	RED2|RED3|GRN1|BLU2, 
	RED1|RED2|RED3|GRN1|BLU2, 
	GRN2|BLU2, 
	RED1|GRN2|BLU2, 
	RED2|GRN2|BLU2, 
	RED1|RED2|GRN2|BLU2, 
	RED3|GRN2|BLU2, 
	RED1|RED3|GRN2|BLU2, 
	RED2|RED3|GRN2|BLU2, 
	RED1|RED2|RED3|GRN2|BLU2, 
	GRN1|GRN2|BLU2, 
	RED1|GRN1|GRN2|BLU2, 
	RED2|GRN1|GRN2|BLU2, 
	RED1|RED2|GRN1|GRN2|BLU2, 
	RED3|GRN1|GRN2|BLU2, 
	RED1|RED3|GRN1|GRN2|BLU2, 
	RED2|RED3|GRN1|GRN2|BLU2, 
	RED1|RED2|RED3|GRN1|GRN2|BLU2, 
	GRN3|BLU2, 
	RED1|GRN3|BLU2, 
	RED2|GRN3|BLU2, 
	RED1|RED2|GRN3|BLU2, 
	RED3|GRN3|BLU2, 
	RED1|RED3|GRN3|BLU2, 
	RED2|RED3|GRN3|BLU2, 
	RED1|RED2|RED3|GRN3|BLU2, 
	GRN1|GRN3|BLU2, 
	RED1|GRN1|GRN3|BLU2, 
	RED2|GRN1|GRN3|BLU2, 
	RED1|RED2|GRN1|GRN3|BLU2, 
	RED3|GRN1|GRN3|BLU2, 
	RED1|RED3|GRN1|GRN3|BLU2, 
	RED2|RED3|GRN1|GRN3|BLU2, 
	RED1|RED2|RED3|GRN1|GRN3|BLU2, 
	GRN2|GRN3|BLU2, 
	RED1|GRN2|GRN3|BLU2, 
	RED2|GRN2|GRN3|BLU2, 
	RED1|RED2|GRN2|GRN3|BLU2, 
	RED3|GRN2|GRN3|BLU2, 
	RED1|RED3|GRN2|GRN3|BLU2, 
	RED2|RED3|GRN2|GRN3|BLU2, 
	RED1|RED2|RED3|GRN2|GRN3|BLU2, 
	GRN1|GRN2|GRN3|BLU2, 
	RED1|GRN1|GRN2|GRN3|BLU2, 
	RED2|GRN1|GRN2|GRN3|BLU2, 
	RED1|RED2|GRN1|GRN2|GRN3|BLU2, 
	RED3|GRN1|GRN2|GRN3|BLU2, 
	RED1|RED3|GRN1|GRN2|GRN3|BLU2, 
	RED2|RED3|GRN1|GRN2|GRN3|BLU2, 
	RED1|RED2|RED3|GRN1|GRN2|GRN3|BLU2, 
	BLU1|BLU2, 
	RED1|BLU1|BLU2, 
	RED2|BLU1|BLU2, 
	RED1|RED2|BLU1|BLU2, 
	RED3|BLU1|BLU2, 
	RED1|RED3|BLU1|BLU2, 
	RED2|RED3|BLU1|BLU2, 
	RED1|RED2|RED3|BLU1|BLU2, 
	GRN1|BLU1|BLU2, 
	RED1|GRN1|BLU1|BLU2, 
	RED2|GRN1|BLU1|BLU2, 
	RED1|RED2|GRN1|BLU1|BLU2, 
	RED3|GRN1|BLU1|BLU2, 
	RED1|RED3|GRN1|BLU1|BLU2, 
	RED2|RED3|GRN1|BLU1|BLU2, 
	RED1|RED2|RED3|GRN1|BLU1|BLU2, 
	GRN2|BLU1|BLU2, 
	RED1|GRN2|BLU1|BLU2, 
	RED2|GRN2|BLU1|BLU2, 
	RED1|RED2|GRN2|BLU1|BLU2, 
	RED3|GRN2|BLU1|BLU2, 
	RED1|RED3|GRN2|BLU1|BLU2, 
	RED2|RED3|GRN2|BLU1|BLU2, 
	RED1|RED2|RED3|GRN2|BLU1|BLU2, 
	GRN1|GRN2|BLU1|BLU2, 
	RED1|GRN1|GRN2|BLU1|BLU2, 
	RED2|GRN1|GRN2|BLU1|BLU2, 
	RED1|RED2|GRN1|GRN2|BLU1|BLU2, 
	RED3|GRN1|GRN2|BLU1|BLU2, 
	RED1|RED3|GRN1|GRN2|BLU1|BLU2, 
	RED2|RED3|GRN1|GRN2|BLU1|BLU2, 
	RED1|RED2|RED3|GRN1|GRN2|BLU1|BLU2, 
	GRN3|BLU1|BLU2, 
	RED1|GRN3|BLU1|BLU2, 
	RED2|GRN3|BLU1|BLU2, 
	RED1|RED2|GRN3|BLU1|BLU2, 
	RED3|GRN3|BLU1|BLU2, 
	RED1|RED3|GRN3|BLU1|BLU2, 
	RED2|RED3|GRN3|BLU1|BLU2, 
	RED1|RED2|RED3|GRN3|BLU1|BLU2, 
	GRN1|GRN3|BLU1|BLU2, 
	RED1|GRN1|GRN3|BLU1|BLU2, 
	RED2|GRN1|GRN3|BLU1|BLU2, 
	RED1|RED2|GRN1|GRN3|BLU1|BLU2, 
	RED3|GRN1|GRN3|BLU1|BLU2, 
	RED1|RED3|GRN1|GRN3|BLU1|BLU2, 
	RED2|RED3|GRN1|GRN3|BLU1|BLU2, 
	RED1|RED2|RED3|GRN1|GRN3|BLU1|BLU2, 
	GRN2|GRN3|BLU1|BLU2, 
	RED1|GRN2|GRN3|BLU1|BLU2, 
	RED2|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED2|GRN2|GRN3|BLU1|BLU2, 
	RED3|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED3|GRN2|GRN3|BLU1|BLU2, 
	RED2|RED3|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED2|RED3|GRN2|GRN3|BLU1|BLU2, 
	GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED1|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED2|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED2|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED3|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED3|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED2|RED3|GRN1|GRN2|GRN3|BLU1|BLU2, 
	RED1|RED2|RED3|GRN1|GRN2|GRN3|BLU1|BLU2
};

/** Macros **/
#define COLOR_INIT()     LPC_GPIO0->FIODIR |= COLOR_MASK;

#define COLOR_SET(value) do {                                 \
                              LPC_GPIO0->FIOCLR = COLOR_MASK;     \
                              LPC_GPIO0->FIOSET = COLOR_VAR_MASK[value];     \

//                            LPC_GPIO0->FIOMASK = ~COLOR_MASK; \
//                            LPC_GPIO0->FIOPIN = COLOR_VAR_MASK[value];      \
                        } while(0)

#endif