/**
 * @file    LightResource.h
 * @brief   mbed CoAP Endpoint Light resource supporting CoAP GET and PUT
 * @author  Doug Anson, Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __UV_RESOURCE_H__
#define __UV_RESOURCE_H__


// Base class
#include "DynamicResource.h"
#include "mbed.h"


AnalogIn sensorUV(A1);

static char * uvValue = {"uv"}; //RRGGBBII

/** LightResource class
 */
class UVResource : public DynamicResource
{

public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Light resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    UVResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"UV",SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the LED
    @returns string containing the last setting
    */
    virtual string get() {
        float value = sensorUV;
        char result[8];
        sprintf(result, "%f", value);
        return(result);
    }
};

#endif // __UV_RESOURCE_H__