/**
 * @file    LightResource.h
 * @brief   mbed CoAP Endpoint Light resource supporting CoAP GET and PUT
 * @author  Doug Anson, Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __MOTION_RESOURCE_H__
#define __MOTION_RESOURCE_H__


// Base class
#include "DynamicResource.h"
#include "mbed.h"

InterruptIn sensorMotion(D2);
int motions = 0;

void irq_handler(void)
{
    motions++;
    logger.log("motion detected %d\n", motions);
}

/** LightResource class
 */
class MotionResource : public DynamicResource
{

public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Light resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    MotionResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Motion",SN_GRS_GET_ALLOWED,observable) {
        sensorMotion.rise(&irq_handler);
    }

    /**
    Get the value of the LED
    @returns string containing the last setting
    */
    virtual string get() {
        char result[4];
        sprintf(result, "%d", motions);
        motions = 0;
        return(result);
    };
};

#endif // __TEMP_RESOURCE_H__
