/* mbed library for the mbed BMI160 accelerometer
    Author: Josias Marcos Orlando
    Organization: SysClean Solutions
 */

#ifndef BMI160_H
#define BMI160_H

#include "mbed.h"

class BMI160{
    public:
        /*configureAccelerometer() setup and configure accelerometer BMI160*/  
        void configureAccelerometer(); 
        
        /*readAccelerometer() read and calculate angle with accelerometer*/
        void readAccelerometer();
       
         /**
         * getAngle() return the angle calculated with accelerometer
         * Reference is top of the LPCXpresso(headers side) poiting bottom of container
         * 
         * @return 0 when in the referential position(Closed cover)
         * @return 90 when 90 degrees from referential
         * @return 180 when 180 degrees from referential
         * @return 270 when 270 degrees from referential
         * @return -1 when error
         */
         int getAngle();
};


#endif
