#include "mbed.h"

#define MCP4725_ADDR        0xC0
#define MCP4726_CMD_WRITEDAC            (0x40)  // Writes data to the DAC
#define MCP4726_CMD_WRITEDACEEPROM      (0x60)  // Writes data to the DAC and the EEPROM (persisting the assigned value after reset)

bool mcp4725_setVoltage(I2C *i2c, uint16_t value, bool eeprom)
{   
    uint8_t i2c_read_data[3];
    i2c_read_data[0] = eeprom ? MCP4726_CMD_WRITEDACEEPROM : MCP4726_CMD_WRITEDAC;
    i2c_read_data[1] = value >> 4;
    i2c_read_data[2] = (value & 0x0F) << 4;
    return i2c->write(MCP4725_ADDR, (const char *)i2c_read_data, 3);
}
