#include "mbed.h"
#include "ina2xx.h"
#include "MyBuffer.h"
#include "string.h"
#include "mcp4725.h"
#include "PID.h"

#define BUFFER_SIZE     50
typedef enum {
    DC_LOAD_MANUAL = 0,
    DC_LOAD_AUTO_CURRENT,
    DC_LOAD_AUTO_POWER
} DCLoadMode;

Ticker ticker_v, ticker_a, ticker_w, ticker_t;

Serial serial(PTB1,PTB2);
I2C i2c(PTB4, PTB3);
MyBuffer <char>buffer;

float voltage = 0.0, current = 0.0, power = 0.0;
float volts_streaming = 0.0, amps_streaming = 0.0, watts_streaming = 0.0;
float minvolts = 0.0;
bool values_ok;
DCLoadMode mode = DC_LOAD_MANUAL;
uint8_t parse_buffer[BUFFER_SIZE+2];
uint8_t i_ptr = 0;
uint32_t timestamp = 0;
bool timestamp_mode = false;

void ticker_v_func();
void ticker_a_func();
void ticker_w_func();
void ticker_time();

void serialInt(void)
{
    while(serial.readable()) {
        buffer.put(serial.getc());
    }
}

void getVoltageCurrentPower()
{
    bool ret, ret2;
    voltage = ina226GetVoltage(&i2c, &ret);
    current = ina226GetCurrent(&i2c, &ret2);
    values_ok = ret * ret2;
    power = voltage * current;
}

void parseCmd()
{
    while(buffer.available() && i_ptr < BUFFER_SIZE) {
        parse_buffer[i_ptr] = buffer.get();
        serial.putc(parse_buffer[i_ptr++]);
        parse_buffer[i_ptr] = 0;
        char * endstr = NULL;
        endstr = strstr((char *)parse_buffer, "\r\n");
        if(endstr != NULL) {
            i_ptr = 0;
            char *pch = strstr((char *)parse_buffer,"=");
            char *pch2 = strstr((char *)parse_buffer,"?");
            int value = 0;
            if(pch != NULL) {
                if(!strncmp((char *)parse_buffer, "SV", 2)) {
                    value = atoi(pch+1);    // voltage
                    if(value <= 50) {
                        volts_streaming = 0.0;
                        ticker_v.detach();
                    } else {

                        ticker_v.detach();
                        volts_streaming = (float)value/1000.0;
                        ticker_v.attach(&ticker_v_func, volts_streaming);
                    }
                } else if(!strncmp((char *)parse_buffer, "SC", 2)) {
                    value = atoi(pch+1);    // amps
                    if(value <= 50) {
                        amps_streaming = 0.0;
                        ticker_a.detach();
                    } else {

                        ticker_a.detach();
                        amps_streaming = (float)value/1000.0;
                        ticker_a.attach(&ticker_a_func, amps_streaming);
                    }
                } else if(!strncmp((char *)parse_buffer, "SP", 2)) {
                    value = atoi(pch+1);    // watts_streaming
                    if(value <= 50) {
                        watts_streaming = 0.0;
                        ticker_w.detach();
                    } else {

                        ticker_w.detach();
                        watts_streaming = (float)value/1000.0;
                        ticker_w.attach(&ticker_w_func, watts_streaming);
                    }
                } else if(!strncmp((char *)parse_buffer, "A", 1)) {
                    value = atoi(pch+1);    // set current
                    float value_real = value;
                    value_real *= 0.1866;
                    mcp4725_setVoltage(&i2c, (int)value_real, false);
                } else if(!strncmp((char *)parse_buffer, "Tm", 2)) {
                    timestamp_mode = atoi(pch+1)?true:false;    // time
                } else if(!strncmp((char *)parse_buffer, "T", 1)) {
                    timestamp = atoi(pch+1);    // time
                } else if(!strncmp((char *)parse_buffer, "mV", 2)) {
                    minvolts = (float)(atoi(pch+1))/1000.0;    // time
                }
            } else if(pch2 != NULL) {
                if(!strncmp((char *)parse_buffer, "A?", 2)) {
                    printf("C=%d\r\n", (int)(current * 1000.0));
                } else if(!strncmp((char *)parse_buffer, "V?", 2)) {
                    printf("V=%d\r\n", (int)(voltage * 1000.0));
                } else if(!strncmp((char *)parse_buffer, "P?", 2)) {
                    printf("P=%d\r\n", (int)(power * 1000.0));
                } else if(!strncmp((char *)parse_buffer, "T?", 2)) {
                    printf("T=%d\r\n", timestamp);
                }
            } else {
                if(!strncmp((char *)parse_buffer, "help", 4)) {
                    serial.puts("Available commands:\r\nSV=<ms>\\r\\n - Set streaming voltage\r\n");
                    serial.puts("SC=<ms>\\r\\n - Set streaming current\r\n");
                    serial.puts("SP=<ms>\\r\\n - Set streaming power\r\n");
                    serial.puts("A=<mA>\\r\\n - Set discharge current\r\n");
                    serial.puts("T=<ms>\\r\\n - Set timestamp\r\n");
                    serial.puts("Tm=<ms>\\r\\n - Set timestamp mode (0: timestamp off, 1: timestamp on)\r\n");
                    serial.puts("mV=<mV>\\r\\n - Set minimum discharge voltage\r\n");
                    serial.puts("V?\\r\\n - Get voltage\r\n");
                    serial.puts("A?\\r\\n - Get discharge current\r\n");
                    serial.puts("P?\\r\\n - Get discharge power\r\n");
                    serial.puts("T?\\r\\n - Get timestamp\r\n");
                    serial.puts("help\\r\\n - help menu\r\n");
                    serial.puts("report\\r\\n - Get sensors report\r\n");
                } else if(!strncmp((char *)parse_buffer, "report", 6)) {
                    serial.puts("DC-LOAD report\r\n");

                } else {
                    serial.puts("Invalid command...\nSend <help\\r\\n> to see available commands\n");
                }
            }
        }
    }
}

int main()
{
    ticker_t.attach(&ticker_time, 0.01);
    serial.baud(115200);
    serial.puts("DC-LOAD starting...\nSend <help\\r\\n> to see available commands\n");
    serial.attach(serialInt);
    i2c.frequency(100000);
    i_ptr = 0;
    uint16_t conf = 0;
    mcp4725_setVoltage(&i2c, 0, false);
    ina226_set(&i2c, 0x00, 0x4927);
    ina226_get(&i2c, 0x00, &conf);
    if(conf != 0x4927) return 1;
    ina226_set(&i2c,0x05, 1000);
    ina226_get(&i2c, 0x05, &conf);
    if(conf != 1000) return 2;
    values_ok = false;
    mode = DC_LOAD_MANUAL;

    while(1) {
        getVoltageCurrentPower();

        parseCmd();

        if( minvolts > 1.0 && voltage < minvolts) {
            printf("Min. Voltage detected\r\n");
            mcp4725_setVoltage(&i2c, 0x0000, false);
        }
        wait(0.1);
    }
}

void ticker_v_func(void)
{
    if(timestamp_mode) {
        printf("%d:V=%d\r\n", timestamp, (int)(voltage * 1000.0));
    } else {
        printf("V=%d\r\n", (int)(voltage * 1000.0));
    }
}

void ticker_a_func(void)
{
    if(timestamp_mode) {
        printf("%d:C=%d\r\n", timestamp, (int)(current * 1000.0));
    } else {
        printf("C=%d\r\n", (int)(current * 1000.0));
    }
}

void ticker_w_func(void)
{
    if(timestamp_mode) {
        printf("%d:P=%d\r\n", timestamp, (int)(power * 1000.0));
    } else {
        printf("P=%d\r\n", (int)(power * 1000.0));
    }
}

void ticker_time(void)
{
    timestamp+=10;
}