/*
 * ina2xx.c
 *
 *  Created on: 26 de Set de 2015
 *      Author: João Sousa
 */


#include "ina2xx.h"

bool ina226_get(I2C *i2c, uint8_t ina_addr, uint16_t *value)
{
    uint8_t i2c_read_data[2];
    i2c_read_data[0] = ina_addr;
    i2c->write(INA226_ADDR, (const char *)i2c_read_data, 1);
    bool v = i2c->read(INA226_ADDR, (char *)i2c_read_data, 2);
    *value = (i2c_read_data[0] << 8) | i2c_read_data[1];
    return v;
}

bool ina226_set(I2C *i2c, uint8_t ina_addr, uint16_t value)
{
    uint8_t i2c_read_data[3];
    i2c_read_data[0] = ina_addr;
    i2c_read_data[1] = value >> 8;
    i2c_read_data[2] = value & 0xFF;
    return i2c->write(INA226_ADDR, (const char *)i2c_read_data, 3);
}


float ina226GetVoltage(I2C *i2c, bool *ret_op)
{
    int16_t conf_reg;
    bool ret = ina226_get(i2c, 0x02, (uint16_t *)&conf_reg);
    float voltage;
    if(!ret)
    {
        *ret_op = true;
        voltage = (conf_reg);
        voltage *= 0.00125;
        return voltage;
    }
    *ret_op = false;
    return 0;
}

float ina226GetShuntVoltage(I2C *i2c, bool *ret_op)
{
    int16_t conf_reg;
    bool ret = ina226_get(i2c, 0x01, (uint16_t *)&conf_reg);
    float voltage;
    if (!ret)
    {
        *ret_op = true;
        voltage = (conf_reg);
        voltage *= 0.0025;
        return voltage;
    }
    *ret_op = false;
    return 0;
}

float ina226GetCurrent(I2C *i2c, bool *ret_op)
{
    int16_t conf_reg;
    bool ret = ina226_get(i2c, 0x04, (uint16_t *)&conf_reg);
    float current;
    if(!ret)
    {
        *ret_op = true;
        current = conf_reg;
        current /= 1173.0;
        return current;
    }
    *ret_op = false;
    return 0;
}