#include "mbed.h"
#include "TextLCD.h"
#include "string.h"

#define MAXSamples 50

#define MaxInsol 1160.0
#define MaxTemp 1160.0


TextLCD lcd(PA_8, PB_10, PA_10, PB_3, PB_5, PB_4); // rs, e, d4-d7
 
AnalogIn Insol(A4);
AnalogIn Temp(A5);

Serial pc(SERIAL_TX, SERIAL_RX); 
DigitalOut myled(LED1);
float InsolR, TempR;
uint16_t InsolMap, TempMap;

char buff[40];
//uint16_t buffer[7];
int i;
uint16_t FIFOI[5],FIFOT[5];

uint32_t val;
uint32_t count;

int main() {

/*
while(1){

        sprintf(buff,"Inso:%4u  Temp:%4u",Insol.read_u16(),Temp.read_u16());
        
        pc.printf(buff);pc.printf("\n");
        wait(0.2);

    }
*/








    count=0;
    while(1) { 

        pc.printf("Count: %6u:",count++);pc.printf("  ");

        val=0;
        for(i=1;i<=MAXSamples;i++){
            val += Insol.read_u16();
            }
        val /= MAXSamples;    
        FIFOI[0] = FIFOI[1];
        FIFOI[1] = FIFOI[2];
        FIFOI[2] = FIFOI[3];
        FIFOI[3] = FIFOI[4];
        FIFOI[4] = (uint16_t)val;
        val = 0;
        for(i=0;i<=4;i++){
            val += FIFOI[i];
            }
        val /= 5;                
        InsolR = (float) val;
        
        val=0;
        for(i=1;i<=MAXSamples;i++){
            val += Temp.read_u16();
            }
        val /= MAXSamples;    
        FIFOT[0] = FIFOT[1];
        FIFOT[1] = FIFOT[2];
        FIFOT[2] = FIFOT[3];
        FIFOT[3] = FIFOT[4];
        FIFOT[4] = (uint16_t)val;
        val = 0;
        for(i=0;i<=4;i++){
            val += FIFOT[i];
            }
        val /= 5;                
        TempR = (float) val;



        InsolMap = (uint16_t)(InsolR  * MaxInsol/4095.0);
        TempMap = (uint16_t) (TempR  *MaxTemp/4095.0);

        sprintf(buff,"Inso:%4u mW/cm2",InsolMap/10);      
        pc.printf(buff);pc.printf("  ");
        
        lcd.locate(0,0);
        lcd.printf(buff);
        
        sprintf(buff,"Temp:%4u  deg C",TempMap/10);      
        pc.printf(buff);pc.printf("\n");
        
        lcd.locate(0,1);
        lcd.printf(buff);
        myled = !myled;
        wait(.2); 
    }
}
