//Started USART, LCD Interfacing
//Inerfaced SPI and tested for top and bottom boards
//Keypress and Serial communication tested

#include "mbed.h"
#include "TextLCD.h"
#include "string.h"
#include "stdio.h"

TextLCD lcd(PA_10, PB_3, PB_5, PB_4, PB_8, PA_8); // rs, e, d4-d7

Serial pc(PB_10, PB_11);//TX = PB_10 RX = PB_11 
DigitalIn upbutton(USER_BUTTON);//PC_13 = upkey 
DigitalIn downbutton(PB_9);//D14 = downkey
DigitalOut myled(PA_5);

char SerialAvailable = 0;
char buf[10];
char buffer[16];
unsigned incomingByte = 0;
unsigned pointer = 0;
unsigned char  ch00,ch01,ch02,ch03,ch04;
int RelaySelected;

SPI SPIDevice(SPI_MOSI, SPI_MISO, SPI_SCK);//mosi=PA_7, miso=PA_6, sck=PA5
DigitalOut OE(PA_9);//D8=OE
DigitalOut RCK595(PC_7);//D9=RCK595




void RelaySelectFunction( ){
unsigned uword;
    
    switch(RelaySelected){
        case 1:uword = 0x0080;lcd.locate(0,1);lcd.printf("CH1      ");break; 
        case 2:uword = 0x0040;lcd.locate(0,1);lcd.printf("CH2      ");break; 
        case 3:uword = 0x0020;lcd.locate(0,1);lcd.printf("CH3      ");break; 
        case 4:uword = 0x0010;lcd.locate(0,1);lcd.printf("CH4      ");break; 
        case 5:uword = 0x0008;lcd.locate(0,1);lcd.printf("CH5      ");break; 
        case 6:uword = 0x0004;lcd.locate(0,1);lcd.printf("CH6      ");break; 
        case 7:uword = 0x0002;lcd.locate(0,1);lcd.printf("CH7      ");break; 
        case 8:uword = 0x0001;lcd.locate(0,1);lcd.printf("CH8      ");break; 
        case 9:uword = 0x8000;lcd.locate(0,1);lcd.printf("CH9      ");break; 
        case 10:uword = 0x4000;lcd.locate(0,1);lcd.printf("CH10      ");break; 
        case 11:uword = 0x2000;lcd.locate(0,1);lcd.printf("CH11      ");break; 
        case 12:uword = 0x1000;lcd.locate(0,1);lcd.printf("CH12      ");break; 
        case 13:uword = 0x0800;lcd.locate(0,1);lcd.printf("CH13      ");break; 
        case 14:uword = 0x0400;lcd.locate(0,1);lcd.printf("CH14      ");break; 
        case 15:uword = 0x0200;lcd.locate(0,1);lcd.printf("CH15      ");break; 
        case 16:uword = 0x0100;lcd.locate(0,1);lcd.printf("CH16      ");break; 
        default: uword = 0x0000;lcd.locate(0,1);lcd.printf("No CH      ");break; 
        }
    RCK595 = 0;SPIDevice.write(uword); wait_ms(2);RCK595 = 1;
    wait_ms(200);
} 
 
void SerialCom(){


    if(pc.readable()){
        buffer[0] = buffer[1];
        buffer[1] = buffer[2];
        buffer[2] = buffer[3];
        buffer[3] = buffer[4];
        buffer[4] = buffer[5];
        buffer[5] = pc.getc();

        if((buffer[0] == 'A') && (buffer[5] == 'B')){
            SerialAvailable = 1;
        }
    }    
}

void Keypress(){
    
    if(upbutton == 0){     
        RelaySelected++;
        if(RelaySelected > 16)RelaySelected = 1;
        RelaySelectFunction();
        pc.printf("Relay:%u\n", RelaySelected);
        wait_ms(50);
    }
    if(downbutton == 0){      
        RelaySelected--; 
        if(RelaySelected < 1)RelaySelected = 16;
        RelaySelectFunction();
        pc.printf("Relay:%u\n", RelaySelected);
        wait_ms(50);
    }
}   
void SerialFunction(){
int i;
    i = buffer[2];
    switch(i){
    case 48:RelaySelected=1;break;
    case 49:RelaySelected=2;break;
    case 50:RelaySelected=3;break;
    case 51:RelaySelected=4;break;
    case 52:RelaySelected=5;break;
    case 53:RelaySelected=6;break;
    case 54:RelaySelected=7;break;
    case 55:RelaySelected=8;break;
    case 56:RelaySelected=9;break;
    case 57:RelaySelected=10;break;
    
    case 65:RelaySelected=11;break;
    case 66:RelaySelected=12;break;
    case 67:RelaySelected=13;break;
    case 68:RelaySelected=14;break;
    case 69:RelaySelected=15;break;
    case 70:RelaySelected=16;break;
    default:RelaySelected=1;break;
    }
    RelaySelectFunction();
    SerialAvailable = 0;

}
int main() { 
    
    OE = 1; // Deselect device
    RCK595 = 1; // Deselect device
    SPIDevice.format(16,3);        // Setup:  bit data, high steady state clock, 2nd edge capture
    SPIDevice.frequency(400000); //400kHz
    SPIDevice.write(0x0000);
    
    pc.printf("Analog Multiplexer\n");    
    lcd.printf("Analog Multiplexer");
    OE = 0;
    downbutton.mode(PullUp);
    lcd.locate(0,1);lcd.printf("      ");
    RelaySelected = 1;
    RelaySelectFunction();
    pc.attach(&SerialCom);
    while(1){
        Keypress();
        if(SerialAvailable==1)
            SerialFunction();
    }    
}
