#include "mbed.h"
#include "GPS.h"
#include "string.h"
#include "TextLCD.h"


TextLCD lcd(PB_3, PB_5, PB_4, PA_8, PC_7, PB_6); // rs, e, d4-d7

//Serial pc(USBTX, USBRX);
Serial pc(SERIAL_TX, SERIAL_RX);
GPS gps(PA_9, PA_10);
DigitalOut myled(LED1);
Serial GSM(PB_10, PB_11);
DigitalIn Mybutton(PC_13);
char Mybuf[100];
char buff[100];



//global variables
char comm[100];
//char num[15]="+919920355869";
char num[15]="+919820300951";
int time1;
int msg[100];
int numb[20];
int log1[20];
int dm;


int read_GSM()
{
    int i=0;
    
    while(1)
    { 
        comm[i]=GSM.getc();
        if(comm[i]==10 && comm[i-1]==13 && comm[i-2]==75 && comm[i-3]==79)
        {
            return i;
        }
        pc.putc(comm[i]);
        i++; 
    }
}

void send_sms(char* text)
{

//    GSM.printf("AT+CMGS=\"+919820300951\"\r\n");
    GSM.printf("AT+CMGS=\"+919920355869\"\r\n");

//    GSM.printf("AT+CMGS=\"%s\"\r\n",num);
    wait(1);

    GSM.printf("Latitude:%f,%c,Longitude:%f,%c\r\n", gps.latitude,gps.ns, gps.longitude, gps.ew);
    
    wait(1);

    GSM.putc(0x1A);
    wait(1);
//    dm=read_GSM();
    sprintf(buff,"Lat:%f %c",gps.latitude,gps.ns);
    lcd.locate(0,0);
    lcd.printf(buff);
    sprintf(buff,"Log:%f %c",gps.longitude, gps.ew);
    lcd.locate(0,1);
    lcd.printf(buff);

    pc.printf("SMS Send");
}

void GPS_init(){
    GSM.printf("AT+CGPSPWR=1\r");
    dm=read_GSM();
    pc.printf("GPS Power ON\n");
    GSM.printf("AT+CGPSRST=1\r");
    dm=read_GSM();
    pc.printf("GPS Cold Reset\n");
    GSM.printf("AT+CGPSIPR=9600\r");
    dm=read_GSM();
    pc.printf("GPS baud rate set\n");
}    

void GSM_init()
{  
    // check if GSM is fine
    GSM.printf("AT\r");                     
    dm=read_GSM();
    //pc.printf("%s",comm);
    //if(strcmp("OK",comm)==0)
    pc.printf("GSM Working fine\n");
    wait(1);
    
    //no echo
    GSM.printf("ATE0\r");
    dm=read_GSM();
    pc.printf("Echo Switched off\n");
    wait(1);
    
    //network reg
    GSM.printf("AT+CREG?\r");
    dm=read_GSM();
    pc.printf("Network Registered\n"); 
    wait(1);
    //Service provider
    pc.printf("\n Network Provider\n"); 
    GSM.printf("AT+CGMI\r");
    dm=read_GSM();
    wait(1);
 }
 
void sms_init()
{
    GSM.printf("AT+CMGF=1\r");
    dm=read_GSM();
    pc.printf("GSM SMS set to Text Mode\n");
    wait(0.5);
    //delete all previous messages  
    GSM.printf("AT+CMGDA=\"DEL ALL\"\r");
    //pc.printf("AT+CMGDA=\"DEL ALL\"\r");

    read_GSM();
    pc.printf("All previous messages cleared");
}
 
void retrieve_sms()
{ 
    GSM.printf("AT+CMGR=1\r");
    int i=0;
    while(1)
    {
        comm[i]=GSM.getc();
        if(comm[i]==10 && comm[i-1]==13 && comm[i-2]==75 && comm[i-3]==79)
        break;
        i++;
    }
    int len=i; 
    int j=0;
    // Get message
    for(i=len-8;i>0;i--)
    if(comm[i]==13 && comm[i+1]==10)
    break;
    pc.printf("Message retrieved is: ");
    lcd.locate(0,0);
    int k=0;
    for(j=i+2;j<=len-8;j++)
    { 
        msg[k]=comm[j];
        pc.putc(msg[k]);
        lcd.putc(msg[k]);
        k++; 
    }
    //sprintf(buff,"%d",msg);
    //lcd.printf(buff);
       
    
    //get Sender number
    pc.printf("\n Message received from: ");
    k=0;
    for(i=24;i<=36;i++)
    { 
        num[k]=comm[i];  
        pc.putc(num[k]);
        k++;
    }
    GSM.printf("AT+CMGDA=\"DEL ALL\"\r");
/*
   
    // Get Time
    pc.printf("\n Message received at: ");
    for(j=47;j<=54;j++) 
    {
        log1[k]=comm[j];
        pc.putc(log1[k]);
        k++;
    }   
*/
}
int main() {
    GPS_init();
    GSM_init();
    sms_init();
    
    while(1) {
        retrieve_sms();
        
        myled=!myled;
        if(gps.sample()){
            pc.printf("\nLatitude: %f, %c, Longitude: %f, %c\n",  gps.latitude,gps.ns, gps.longitude, gps.ew);
            if(Mybutton == 0){
                sprintf(Mybuf,"Latitude:%f, %c, Longitude:%f, %c\r\n", gps.latitude,gps.ns, gps.longitude, gps.ew);
                send_sms(Mybuf);    
            }
            
        } else {
            pc.printf("No lock!\n");
        }
    }
}
