// Programa para ejecutar un control PID que lee las constantes del controlador desde la
// manipulación de un control LG AKB73275620 por medio de un protocolo IrDA. Un sensor
// infrarrojo lee los pulsos de entrada y asigna la acción correspondiente dependiendo
// de la tecla pulsada. Para cada tecla el control manda una cadena de pulsos distinta,
// se usarán las teclas de los números del 0 al 9 para asignar fácilmente las constantes
// del controlador, una tecla de "OK" para acceder a la siguiente constante, una tecla de
// "Back" para borrar lo asignado en la constante y una tecla de "Power" para iniciar el
// ciclo de control.

// Oswaldo Andrés Giraldo Giraldo - C.C.: 1152458465
// Héctor Andrés Hoyos Ceballos - C.C.: 1039466317
// Jose Fernando Montoya Vargas - C.C.: 1039468676
// María Fernanda Villa Tamayo - C.C.: 1152457490

#include "mbed.h"
#include <Pulse1.h>
#include "stdio.h" 
#include "math.h"
#include "TextLCD.h"

//control remoto sony disparo camara
//puede convertir la trama en un entero
//para cualquier tecla

PulseInOut irda(PTD5);// En este puerto se pone el sensor infrarrojo.
Serial pc(USBTX, USBRX);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // RS, E, D4 - D7.
AnalogIn y(PTB3); // Entrada análoga.
AnalogOut u(PTE30); // Salida análoga.

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int C1=0x0E; // Sólo muestra el cursor.
int C2=0x18; // Desplaza hacia la izquierda.
int C3=0x1A; // Desplaza hacia la derecha.
int C4=0x0C; // Quita el cursor bajo.

float pid, o, ai, ad, ap, med, err;
float err_v;
int spnum = 0, kinum = 0, kpnum = 0, kdnum = 0, pos = 1, cen = 0, dec = 0, uni = 0, uninum = 0, decnum = 0, cennum = 0, tec = 0;

int header = 0; // Tiempo de cabecera pulso abajo
const int head_H = 9977; //+10% de la cabecera medida, con osciloscopio en microsegundos.
const int head_L = 8163;//-10% de la cabecera medida, con osciloscopio.
int i = 0;

const int T_alto = 1240; // Tiempo en ALTO de un 1 lógico.
const int T_bajo = 680; // Tiempo en BAJO de un 1 lógico.
const int num_bits = 32; // Número de bits al pisar una tecla.
int num[num_bits]; // Cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // Tiempo de cada dato que se lee.
int numero;
int binM[32];
int bin_max[32];
  
int main(){
    
    lcd.locate(0,1);
    lcd.printf("**Control PID**");
    wait(2);
    lcd.cls(); // Borrar Pantalla.
    lcd.writeCommand(C1); // Escribimos un comando segun el manual del modulo LCD.

    lcd.locate(8, 0);
    lcd.printf("Kp=%d", kpnum);
    lcd.locate(0, 1);
    lcd.printf("Ki=%d", kinum);
    lcd.locate(8, 1);
    lcd.printf("Kd=%d", kdnum);
    lcd.locate(0, 0);
    lcd.printf("Sp=%d", spnum);

    while(1){
        ini1: fflush( stdin );
            header = 0;
            led2 = 1;
            led1 = 1;
            header = irda.read_low_us(); // Función para leer un pulso de caida o bajo en header.
            if (header > head_L && header < head_H) goto seguir; // Verificar que este en la tolerancia +-10%
            else goto ini1;
              
        seguir:
            // Leer los datos de la trama y asignarlos a un arreglo.
            wait_us(400);// ES EL TIEMPO DE HEADER QUE NO SE Lee O EL ALTO 
            led2 = 1;
            for(i = 0; i < (num_bits - 1); ++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits), datos.
                dato = irda.read_high_us(); // Leer un bit de datos que es pulso arriba en este control.
                num[i] = dato;
                wait_us(400);   
            }
            wait(0.5); // Esperar luego de leer todo el arreglo y ponerlo en pantalla.
            pc.printf("%d",header);
            /*for(i = 0; i < (num_bits - 1); ++i){  
                pc.printf(",%d",num[i]);
            }*/
            wait(0.1); 
            pc.printf("\n\n");
            for(i = 0; i < (num_bits - 1); ++i){  
                if(num[i] > ((T_alto + T_bajo)/2)){
                    bin_max[i] = 1;
                }
                else{
                    bin_max[i] = 0;
                }
            }
            binM[0] = 1;
            for(i = 1; i < (num_bits - 1); ++i){   
                binM[i] = binM[i - 1]*2; 
            }
            numero = 0; 
            /*for(i = 0; i < (num_bits - 1); ++i){  
                pc.printf(",%d", binM[i]);
            }*/
            
            for(i = 0; i < (num_bits - 1); ++i){  
                numero = numero + (binM[i]*bin_max[i]);     
            }
            pc.printf("\n\n");
            pc.printf("Numero = %d", numero);
            pc.printf("\n\n");
            
            // Datos del control utilizado.
            
            //'1846672132' - Número 1
            //'1829960452' - Número 2
            //'1813248772' - Número 3
            //'1796537092' - Número 4
            //'1779825412' - Número 5
            //'1763113732' - Número 6
            //'1746402052' - Número 7
            //'1729690372' - Número 8
            //'1712978692' - Número 9
            //'1863383812' - Número 0
            //'994376452' - OK
            //'1462303492' - Back
            //'1997077252' - Power
            
            if (numero == 1846672132){ // Número 1
                tec = 1;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1829960452){ // Número 2
                tec = 2;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1813248772){ // Número 3
                tec = 3;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1796537092){ // Número 4
                tec = 4;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1779825412){ // Número 5
                tec = 5;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1763113732){ // Número 6
                tec = 6;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1746402052){ // Número 7
                tec = 7;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if (pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1729690372){ // Número 8
                tec = 8;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if(pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if(pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1712978692){ // Número 9
                tec = 9;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if(pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1863383812){ // Número 0
                tec = 0;
                if (cen == 0 && dec == 0 && uni == 0){
                    uninum = tec;
                    uni = 1;
                    if(pos == 1){
                        spnum = uninum;
                        lcd.locate(3, 0);
                        lcd.printf("    ");
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum;
                        lcd.locate(11, 0);
                        lcd.locate(11, 0);
                        lcd.printf("    ");
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum;
                        lcd.locate(3, 1);
                        lcd.printf("    ");
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum;
                        lcd.locate(11, 1);
                        lcd.printf("    ");
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec == 0 && uni != 0){
                    decnum = tec;
                    dec = 1;
                    if(pos == 1){
                        spnum = uninum*10 + decnum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*10 + decnum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*10 + decnum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*10 + decnum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                }
                else if (cen == 0 && dec != 0 && uni != 0){
                    cennum = tec;
                    cen = 1;
                    if(pos == 1){
                        spnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 0);
                        lcd.printf("%d", spnum);
                    }
                    else if (pos == 2){
                        kpnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 0);
                        lcd.printf("%d", kpnum);
                    }
                    else if(pos == 3){
                        kinum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(3, 1);
                        lcd.printf("%d", kinum);
                    }
                    else if(pos == 4){
                        kdnum = uninum*100 + decnum*10 + cennum;
                        lcd.locate(11, 1);
                        lcd.printf("%d", kdnum);
                    }
                    uni = 0;
                    dec = 0;
                    cen = 0;
                }        
            }
            
            if (numero == 1462303492){ // Back (Borrar el número actual).
                if(pos == 1){
                    uni = 0;
                    dec = 0;
                    cen = 0;
                    spnum = 0;
                    lcd.locate(3, 0);
                    lcd.printf("    ");
                    lcd.locate(3, 0);
                    lcd.printf("%d", spnum);
                }
                else if (pos == 2){
                    uni = 0;
                    dec = 0;
                    cen = 0;
                    kpnum = 0;
                    lcd.locate(11, 0);
                    lcd.printf("    ");
                    lcd.locate(11, 0);
                    lcd.printf("%d", kpnum);
                }
                else if(pos == 3){
                    uni = 0;
                    dec = 0;
                    cen = 0;
                    kinum = 0;
                    lcd.locate(3, 1);
                    lcd.printf("    ");
                    lcd.locate(3, 1);
                    lcd.printf("%d", kinum);
                }
                else if(pos == 4){
                    uni = 0;
                    dec = 0;
                    cen = 0;
                    kdnum = 0;
                    lcd.locate(11, 1);
                    lcd.printf("    ");
                    lcd.locate(11, 1);
                    lcd.printf("%d", kdnum);
                }
            }
            
            if (numero == 994376452){ // OK (Cambiar a la siguiente constante).
                led3 =!led3;
                uni = 0;
                dec = 0;
                cen = 0;
                if(pos == 4){
                    pos = 1;
                    lcd.locate(3, 0);
                    lcd.printf("%d", spnum);
                }
                else if (pos == 1){
                    pos++;
                    lcd.locate(11, 0);
                    lcd.printf("%d", kpnum);
                }
                else if(pos == 2){
                    pos++;
                    lcd.locate(3, 1);
                    lcd.printf("%d", kinum);
                }
                else if(pos == 3){
                    pos++;
                    lcd.locate(11, 1);
                    lcd.printf("%d", kdnum);
                }
                wait(0.25);
            }
            
            if (numero == 1997077252){ // Power (Inicializar el PID).
                break; // Sale del bucle si se pisa Power.
            }
            wait(0.1);      
    }
    
    //Transición
    lcd.writeCommand(C4); // Escribimos un comando segun el manual del modulo LCD para quitar cursor bajo.
    lcd.cls(); // Borra la pantalla.
    lcd.locate(1, 1);
    lcd.printf("DATOS GUARDADOS");
    wait(1);
    lcd.cls();
    lcd.locate(1, 1);
    lcd.printf("INICIO DEL PID");
    wait(1);
    
    // Se imprimen los parches del control.
    lcd.cls();
    lcd.printf("Er=%3.0f",err);
    lcd.locate(8,0);
    lcd.printf("Me=%3.0f",med);
    lcd.locate(0,1);
    lcd.printf("Sp=%3.0f",spnum);
    lcd.locate(8,1);
    lcd.printf("Co=%3.0f",pid);
    wait(1);

    // CICLO PRINCIPAL CONTROLADOR PID.
    lop1:  
        med = y.read()*999;
        err = (spnum-med);  // Se calcula el error.
        ap = kpnum*err*0.01f; // Se calcula la acción proporcinal.
        ai =(kinum*err*0.01f)+ai; // Cálculo de la integral del error.
        ad = kdnum*(err-err_v)*0.01f; // Cálculo de la acción derivativa.
        pid = (ap+ai+ad); // Se actualiza el valor del la acción de control.
        
        // Se verifica que pid sea positivo.
        if(pid<=0){
            pid=0;
        }
    
        // Se verifica que pid sea menor o igual la valor máximo.
        if (pid > 999){
            pid=999;
        }
       
        // Se muestran las variables en la LCD.
        lcd.locate(3,0);
        lcd.printf("    ");
        lcd.locate(3,0);
        lcd.printf("%3.0f",err);
        lcd.locate(11,0);
        lcd.printf("   ");
        lcd.locate(11,0);
        lcd.printf("%3.0f",med);
        lcd.locate(3,1);
        lcd.printf("   ");
        lcd.locate(3,1);
        lcd.printf("%d",spnum);
        lcd.locate(11,1);
        lcd.printf("   ");
        lcd.locate(11,1);
        lcd.printf("%3.0f",pid);
           
        // Normalización de la salida.
        // Se actualizan las variables.
        err_v = err;
        o = pid/999;
        u.write(o); // Se envía el valor de pid al puerto analogico de salida (D/A).
        
        // Se repite el ciclo.
        wait_ms(300);
        goto lop1;
}