// Programa para configurar 4 alarmas con el reloj DS1307 por comunicación I2C. Se configurarán los tiempos de
// encendido y apagado de cada una de las alarmas y la acción de las mismas se verá representada por el estado
// de un LED para cada una (cuando se active una alarma se deberá encender, cuando se desactive se deberá de
// apagar), por lo que las alarmas son independientes. Luego, se deberá estar comparando constantemente el 
// tiempo actual con cada una de las alarmas por a parte.

// Oswaldo Andrés Giraldo Giraldo - C.C.: 1152458465
// Héctor Andrés Hoyos Ceballos - C.C.: 1039466317
// Jose Fernando Montoya Vargas - C.C.: 1039468676
// María Fernanda Villa Tamayo - C.C.: 1152457490

#include "mbed.h"
#include "DebouncedIn.h" // Librería para los botones.
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // RS, E, D4 - D7
Rtc_Ds1307 rtc(PTE0, PTE1); // Configura el reloj.
QEI wheel (PTA13, PTD5, NC, 48); // Configura el encoder.
DebouncedIn button_enco(PTC16); // Configura el botón del encoder.

DigitalOut ALED1(PTA5);// Salida del LED de la alarma 1. 
DigitalOut ALED2(PTA4);// Salida del LED de la alarma 2. 
DigitalOut ALED3(PTA12);// Salida del LED de la alarma 3.
DigitalOut ALED4(PTD4);// Salida del LED de la alarma 4.

Serial pc(USBTX, USBRX); // TX, RX.

int C1 = 0x0C;
int m;
int Conf = 0;  // 0: Reloj, 1: Alarmas.
int Lugar = 0; // Definen el punto en el cual va el programa.
int i = 0, ala = 1, a1 = 0, a2 = 0, a3 = 0, a4 = 0, cont = 0;
int visual = 0;
int alarma = 0;  

int main(){
    Rtc_Ds1307::Time_rtc tm = {}; // Inicializa el reloj.
    Rtc_Ds1307::Time_rtc A1on = {}; // Inicializa el tiempo de encendido de la alarma 1.
    Rtc_Ds1307::Time_rtc A2on = {}; // Inicializa el tiempo de encendido de la alarma 2.
    Rtc_Ds1307::Time_rtc A3on = {}; // Inicializa el tiempo de encendido de la alarma 3.
    Rtc_Ds1307::Time_rtc A4on = {}; // Inicializa el tiempo de encendido de la alarma 4.
    Rtc_Ds1307::Time_rtc A1off = {}; // Inicializa el tiempo de apagado de la alarma 1.
    Rtc_Ds1307::Time_rtc A2off = {}; // Inicializa el tiempo de apagado de la alarma 2.
    Rtc_Ds1307::Time_rtc A3off = {}; // Inicializa el tiempo de apagado de la alarma 3. 
    Rtc_Ds1307::Time_rtc A4off = {}; // Inicializa el tiempo de apagado de la alarma 4.
    
    lcd.cls(); // Borra la pantalla.
    lcd.writeCommand(C1); // Escribimos un comando segun el manual del modulo LCD.
    lcd.locate(0,0);
    lcd.printf("** Reloj de");
    lcd.locate(0,1);
    lcd.printf("   4 alarmas **");
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("--Reloj"); // Sin flechas.
    lcd.locate(0,1);
    lcd.printf("--Alarmas");
        
    rtc.getTime(tm); // Lee el tiempo del DS1307. Leyó todo el hijuemadre reloj de un golpe, hora, min, seg y lo mete en tm

    while(1){

        // Etapa de menú.
        if (Lugar == 0){ // Varía entre reloj y alarma. Por el boton del encoder incrementa una variable que se llama lugar.
            m = wheel.getPulses();  // m son los datos del encoder.
            if(m!=0 && Conf == 0){// Si se movió el encoder y está en Reloj.
                Conf = 1;           // Lo cambia a Alarmas.
                wheel.reset();    // Si está en un estado inferior, la resetea.
                m=0;
                ala++;        
                pc.printf("%d", ala, "\n");  
            }
            
            if(m!=0 && Conf == 1){ // Si se movió el encoder y está en Alarmas.
                Conf = 0;           // Lo pone en Reloj.
                wheel.reset();    // Resetea.
                m=0;
                ala = 1;   
                pc.printf("%d", ala, "\n");          
            }
            
            if(Conf == 0){ // Si la configuración cambia pone la flechita en Reloj.
                
                lcd.locate(1,1);
                lcd.printf("-");                    
                lcd.locate(1,0);
                lcd.printf(">");
                lcd.locate(16,1);                    
                wait(0.1);
                
            }
            
             if(Conf == 1){  // Poner la flechita en Alarmas.
                lcd.locate(1,0);
                lcd.printf("-");                    
                lcd.locate(1,1); // Tira la flechita para abajo.
                lcd.printf(">");
                lcd.locate(16,1);                    
                wait(0.1);
            }
            
            if (button_enco.falling()){  // Si se pulsa botón del encoder.
                Lugar++; //aumenta lugar
                m = 0;
                pc.printf("%d", Conf, "\n");      
                pc.printf("%d", ala, "\n");
            }
        }
        
        // Etapa de llenado de variables (Reloj y Alarmas).
        else if (Lugar == 1){
            if (i == 0){                                    
                if(Conf == 0){ // Empieza a configurar el Reloj.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Configurar reloj");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m = 0;                                                      
                }
        
                if(Conf == 1 && ala == 2){ // Empieza a configurar inicialmente la alarma 1 encendido.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 1");
                    lcd.locate(0,1);
                    lcd.printf("encendido");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }   
                
                if(Conf == 1 && ala == 3){ // Configurar alarma 1 apagado.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 1");
                    lcd.locate(0,1);
                    lcd.printf("apagado");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                
                if(Conf == 1 && ala == 4){ // Configurar alarma 3 encendido.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 2");
                    lcd.locate(0,1);
                    lcd.printf("encendido");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                
                if(Conf == 1 && ala == 5){ // Configurar alarma 2 apagado.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 2");
                    lcd.locate(0,1);
                    lcd.printf("apagado");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                
                if(Conf == 1 && ala == 6){ // Configurar alarma 3 encendido.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 3");
                    lcd.locate(0,1);
                    lcd.printf("encendido");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                
                if(Conf == 1 && ala == 7){ // Configurar alarma 3 apagado.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 3");
                    lcd.locate(0,1);
                    lcd.printf("apagado");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                if(Conf == 1 && ala == 8){ // Configurar alarma 4 encendido.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 4");
                    lcd.locate(0,1);
                    lcd.printf("encendido");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
                
                if(Conf == 1 && ala == 9){ // Configurar alarma 4 apagado.
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Config. Alarma 4");
                    lcd.locate(0,1);
                    lcd.printf("apagado");
                    wait(1.5);
                    lcd.cls();
                    i++;
                    m=0;
                }
            } 
            
            if (i == 1){ // Modificar Día.
                //pc.printf("Estoy en el llenado.\n");   
                m = wheel.getPulses();  
                if (m!=0) {
                    tm.date = tm.date+m; // modifica el dia, maximo en 31 y min en 1
                    if(tm.date > 31){
                        tm.date=1;
                    }
                    if(tm.date<1){
                        tm.date=1;
                    }
                    wheel.reset();  
                    m = 0;
                }
                lcd.locate(0,0);
                lcd.printf("Dia: ");  
                lcd.locate(5,0);
                lcd.printf("%02d",tm.date);
                if (button_enco.falling()){
                    i++;
                    m=0;
                }
            }
                                  
            else if (i == 2){ // Modificar Mes.
                m = wheel.getPulses();  
                if (m!=0) {
                    tm.mon=tm.mon+m; 
                    if(tm.mon>12){
                        tm.mon=1;
                    }
                    if(tm.mon<1){
                        tm.mon=1;
                    }
                    wheel.reset();  
                    m=0;
                }
                lcd.locate(0,0);
                lcd.printf("Mes: ");
                lcd.locate(5,0);
                lcd.printf("%02d",tm.mon);
                if (button_enco.falling()){
                    i++;
                    m=0;   
                }
            }
       
            else if (i == 3){ // Modificar Año.
                m = wheel.getPulses(); 
                if (m!=0){
                    tm.year=tm.year+m;
                    if(tm.year>2032){
                        tm.year=2016;
                    }
                    if(tm.year<2000){
                        tm.year=2000;
                    }
                    wheel.reset();  
                    m=0;
                }
                lcd.locate(0,0);
                lcd.printf("Year: ");
                lcd.locate(6,0);
                lcd.printf("%02d",tm.year);
                if (button_enco.falling()){
                    i++;
                    m = 0;
                }
            }
                        
            else if (i == 4){ // Modificar Hora.
                m = wheel.getPulses();
                if (m!=0){
                    tm.hour=tm.hour + m;
                    if(tm.hour>23){
                        tm.hour=0;
                    }
                    if(tm.hour<0){
                        tm.hour=0;
                    }
                    wheel.reset();  
                    m=0;
                }
                lcd.locate(0,0);
                lcd.printf("Hora: ");
                lcd.locate(6,0);
                lcd.printf("%02d",tm.hour);
                lcd.locate(8,0);
                lcd.printf("  ");
                if (button_enco.falling()){
                    i++;
                    m = 0;
                }
            }
                            
            else if (i == 5){ // Modificar Minuto.
                m = wheel.getPulses();        
                
                if (m!=0){
                    tm.min=tm.min+m;
                    if(tm.min>59){
                        tm.min=0;
                    }
                    if(tm.min<0){
                        tm.min=0;
                    }
                    wheel.reset();  
                    m = 0;
                }
                lcd.locate(0,0);
                lcd.printf("Minuto: ");
                lcd.locate(8,0);
                lcd.printf("%02d",tm.min);
                if (button_enco.falling()){
                    i++;
                    m = 0;
                }
            }
                        
            else if (i == 6){ // Modificar Segundo.
                m = wheel.getPulses();        
                if (m!=0){
                    tm.sec=tm.sec+m;
                    if(tm.sec>59){
                        tm.sec=0;
                    }
                    if(tm.sec<0){
                        tm.sec=0;
                    }
                    wheel.reset();  
                    m = 0;
                }
                lcd.locate(0,0);
                lcd.printf("Segundo: ");
                lcd.locate(9,0);
                lcd.printf("%02d",tm.sec);
                
                if (button_enco.falling()){ // Empieza a asignar los datos del Reloj o las Alarmas.
                    if(Conf == 0){ // Asignar datos del Reloj.
                        rtc.setTime(tm, false, false);
                        pc.printf("Actualice el Reloj.\n");  
                        rtc.startClock();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Reloj");
                        lcd.locate(0,1);
                        lcd.printf("configurado");
                        wait(1.5);
                        i=0;
                        m=0;
                        Lugar = 0;
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("--Reloj");
                        lcd.locate(0,1);
                        lcd.printf("--Alarmas");      
                        ala = 0;            
                    } 
                    
                    if(Conf == 1 && ala == 2){ // Asignar datos de la Alarma 1 encendido.
                        A1on = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 1 on.\n");   
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 1 (on)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                     
                    }
                    
                    if(Conf == 1 && ala == 3){ // Asignar datos de la Alarma 1 apagado.
                        A1off = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 1 off.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 1 (off)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                      
                    }
                    
                    if(Conf == 1 && ala == 4){ // Asignar datos de la Alarma 2 encendido.
                        A2on = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 2 on.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 2 (on)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                        
                    }
                    
                    if(Conf == 1 && ala == 5){ // Asignar datos de la Alarma 2 apagado.
                        A2off = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 2 off.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 2 (off)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                         
                    }
                    
                    if(Conf == 1 && ala == 6){ // Asignar datos de la Alarma 3 encendido.
                        A3on = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 3 on.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 3 (on)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                       
                    }
                    
                    if(Conf == 1 && ala == 7){ // Asignar datos de la Alarma 3 apagado.
                        A3off = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 3 off.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 3 (off)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                  
                    }
                    
                    if(Conf == 1 && ala == 8){ // Asignar datos de la Alarma 4 encendido.
                        A4on = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 4 on.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 4 (on)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();                       
                    }
                    
                    if(Conf == 1 && ala == 9){ // Asignar datos de la Alarma 4 apagado.
                        A4off = tm; // A la alarma le pone todo eso.
                        pc.printf("Actualice Alarma 4 off.\n"); 
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Alarma 4 (off)");
                        lcd.locate(0,1);
                        lcd.printf("configurada");
                        wait(1.5);
                        i=0;
                        m=0;
                        lcd.cls();   
                        Lugar++;             
                    }
                    ala++;
                } // Cierre de if de mensaje de configuración.
            } // Cierre de if de i == 6
        } // Cierre de if de Lugar == 1
    
        // Etapa de comparación e impresión.
        else if (Lugar == 2){ // La visualización del los tiempos de las alarmas y el reloj varían si se manipula en encoder.
            rtc.getTime(tm);
            if(visual == 0){ // Imprime el Reloj.
                lcd.locate(0,0);                        
                lcd.printf("Hora:   ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",tm.hour);
                lcd.printf("%02d:",tm.min);
                lcd.printf("%02d",tm.sec); 
                lcd.locate(0,1);
                lcd.printf("%02d/",tm.mon);
                lcd.printf("%02d/",tm.date);
                lcd.printf("%02d",tm.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){
                    visual++;
                    wheel.reset();  
                    m = 0;
                }
            }
            
            if(visual == 1){ // Imprime la alarma 1 encendido.
                lcd.locate(0,0);    
                lcd.printf("A1 on:  ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A1on.hour);
                lcd.printf("%02d:",A1on.min);
                lcd.printf("%02d",A1on.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A1on.mon);
                lcd.printf("%02d/",A1on.date);
                lcd.printf("%02d",A1on.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 2){ // Imprime la alarma 1 apagado.
                lcd.locate(0,0);    
                lcd.printf("A1 off: ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A1off.hour);
                lcd.printf("%02d:",A1off.min);
                lcd.printf("%02d",A1off.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A1off.mon);
                lcd.printf("%02d/",A1off.date);
                lcd.printf("%02d",A1off.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 3){ // Imprime la alarma 2 encendido.
                lcd.locate(0,0);    
                lcd.printf("A2 on:  ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A2on.hour);
                lcd.printf("%02d:",A2on.min);
                lcd.printf("%02d",A2on.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A2on.mon);
                lcd.printf("%02d/",A2on.date);
                lcd.printf("%02d",A2on.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 4){ // Imprime la alarma 2 apagado.
                lcd.locate(0,0);    
                lcd.printf("A2 off: ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A2off.hour);
                lcd.printf("%02d:",A2off.min);
                lcd.printf("%02d",A2off.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A2off.mon);
                lcd.printf("%02d/",A2off.date);
                lcd.printf("%02d",A2off.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 5){ // Imprime la alarma 3 encendido.
                lcd.locate(0,0);    
                lcd.printf("A3 on:  ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A3on.hour);
                lcd.printf("%02d:",A3on.min);
                lcd.printf("%02d",A3on.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A3on.mon);
                lcd.printf("%02d/",A3on.date);
                lcd.printf("%02d",A3on.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 6){ // Imprime la alarma 3 apagado.
                lcd.locate(0,0);    
                lcd.printf("A3 off: ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A3off.hour);
                lcd.printf("%02d:",A3off.min);
                lcd.printf("%02d",A3off.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A3off.mon);
                lcd.printf("%02d/",A3off.date);
                lcd.printf("%02d",A3off.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 7){ // Imprime la alarma 4 encendido.
                lcd.locate(0,0);    
                lcd.printf("A4 on:  ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A4on.hour);
                lcd.printf("%02d:",A4on.min);
                lcd.printf("%02d",A4on.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A4on.mon);
                lcd.printf("%02d/",A4on.date);
                lcd.printf("%02d",A4on.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual++;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            if(visual == 8){ // Imprime la alarma 4 apagado.
                lcd.locate(0,0);    
                lcd.printf("A4 off: ");
                lcd.locate(8,0);    
                lcd.printf("%02d:",A4off.hour);
                lcd.printf("%02d:",A4off.min);
                lcd.printf("%02d",A4off.sec);
                lcd.locate(0,1);
                lcd.printf("%02d/",A4off.mon);
                lcd.printf("%02d/",A4off.date);
                lcd.printf("%02d",A4off.year);
                wait(0.1);
                m = wheel.getPulses();
                if(m!=0){                        
                    visual = 0;
                    wheel.reset();  
                    m=0;                                       
                }
            }
            
            // Compara el Reloj con la alarma 1 encendido.
            if( (tm.date==A1on.date)&&(tm.mon==A1on.mon)&&(tm.year==A1on.year)&&(tm.hour==A1on.hour)&&(tm.min==A1on.min)&&(tm.sec==A1on.sec) ){
                ALED1 = 1; // Prende el LED 1.
                a1 = 1;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 1");
                lcd.locate(0,1);                        
                lcd.printf("activada!");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
            }
            
            // Compara el Reloj con la alarma 1 apagado.
            if( (tm.date == A1off.date)&&(tm.mon == A1off.mon)&&(tm.year == A1off.year)&&(tm.hour == A1off.hour)&&(tm.min == A1off.min)&&(tm.sec == A1off.sec)&&(a1 == 1)){
                ALED1 = 0; // Apaga el LED 1.
                a1 = 0;
                //Lugar++;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 1");
                lcd.locate(0,1);                        
                lcd.printf("desactivada");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
                cont++;
            }
            
            // Compara el Reloj con la alarma 2 encendido.
            if( (tm.date == A2on.date)&&(tm.mon == A2on.mon)&&(tm.year == A2on.year)&&(tm.hour == A2on.hour)&&(tm.min == A2on.min)&&(tm.sec == A2on.sec)){
                ALED2= 2; // Prende el LED 2.
                a2 = 1;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 2");
                lcd.locate(0,1);                        
                lcd.printf("activada!");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
            }
            
            // Compara el Reloj con la alarma 2 apagado.
            if( (tm.date == A2off.date)&&(tm.mon == A2off.mon)&&(tm.year == A2off.year)&&(tm.hour == A2off.hour)&&(tm.min == A2off.min)&&(tm.sec == A2off.sec)&&(a2 == 1)){
                ALED2 = 0; // Apaga el LED 2.
                a2 = 0;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 2");
                lcd.locate(0,1);                        
                lcd.printf("desactivada");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
                cont++;
            }
            
            // Compara el Reloj con la alarma 3 encendido.
            if( (tm.date == A3on.date)&&(tm.mon == A3on.mon)&&(tm.year == A3on.year)&&(tm.hour == A3on.hour)&&(tm.min == A3on.min)&&(tm.sec == A3on.sec)){
                ALED3 = 1; // Prende el LED 3.
                a3 = 1;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 3");
                lcd.locate(0,1);                        
                lcd.printf("activada!");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
            }
            
            // Compara el Reloj con la alarma 3 apagado.
            if( (tm.date == A3off.date)&&(tm.mon == A3off.mon)&&(tm.year == A3off.year)&&(tm.hour == A3off.hour)&&(tm.min == A3off.min)&&(tm.sec == A3off.sec)&&(a3 == 1)){
                ALED3 = 0; // Apaga el LED 3.
                a3 = 0;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 3");
                lcd.locate(0,1);                        
                lcd.printf("desactivada");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
                cont++;
            }
            
            // Compara el Reloj con la alarma 4 encendido.
            if( (tm.date == A4on.date)&&(tm.mon == A4on.mon)&&(tm.year == A4on.year)&&(tm.hour == A4on.hour)&&(tm.min == A4on.min)&&(tm.sec == A4on.sec)){
                ALED4 = 1; // Prende el LED 4.
                a4 = 1;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 4");
                lcd.locate(0,1);                        
                lcd.printf("activada!");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
            }
            
            // Compara el Reloj con la alarma 4 apagado.
            if( (tm.date == A4off.date)&&(tm.mon == A4off.mon)&&(tm.year == A4off.year)&&(tm.hour == A4off.hour)&&(tm.min == A4off.min)&&(tm.sec == A4off.sec)&&(a4 == 1)){
                ALED4 = 0; // Apaga el LED 4.
                a4 = 0;
                lcd.cls();
                lcd.locate(0,0);                        
                lcd.printf("Alarma 4");
                lcd.locate(0,1);                        
                lcd.printf("desactivada");
                wait(2);
                lcd.cls();
                visual = 0;
                m = 0;
                cont++;
            }
            
            if(cont == 4){ // Cuando se cumplen todas las Alarmas se regresa al menú principal.
                Lugar = 0;
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("--Reloj"); // Sin flechitas.
                lcd.locate(0,1);
                lcd.printf("--Alarmas");
                m = 0;
            }
        }
    }             
} 