#include "mbed.h"
#include "SRF05.h" // Librería del sensor de nivel.
#include "rtos.h" // Librería de tiempo real.

// PUERTAS.
PwmOut servo1(PTB0); // Declaración del servomotor de la puerta del piso 1.
PwmOut servo2(PTB1); // Declaración del servomotor de la puerta del piso 2.
PwmOut servo3(PTB2); // Declaración del servomotor de la puerta del piso 3.
    // Ejemplo:
    /*servo1.period(0.025); 
    servo2.period(0.025);
    servo3.period(0.025);
    servo1.pulsewidth(0.00055);
    servo2.pulsewidth(0.0022);
    servo3.pulsewidth(0.0022);*/
    
// MOTOR.
PwmOut giro1(PTC1);
PwmOut giro2(PTC2);
DigitalOut enable(PTB3);
    // Ejemplo:
    // giro1.period_ms(20);
    // giro2.period_ms(20);

// PULSADORES.
/*DebouncedIn boton1(PTC11); // Botones de la parte frontal del ascensor.
DebouncedIn boton2b(PTC10);  // En este caso no se va a utilizar.
DebouncedIn boton2s(PTC6);
DebouncedIn boton3(PTC5);*/

// Botones de la parte de abajo del ascensor.
DigitalIn boton1i(PTC4); // Piso 1.
DigitalIn boton2i(PTC3); // Piso 2.
DigitalIn boton3i(PTC0); // Piso 3.
DigitalIn botonp(PTC7); // Paro de emergencia.

// SENSOR DE NIVEL.
SRF05 sensor(PTD3, PTD1); // Declaración del sensor de nivel. objeto de tipo SRF05

// LEDS.
DigitalOut led1(PTE5);
DigitalOut led2(PTE4);
DigitalOut led3(PTE3);

// VARIABLES AUXILIARES.
float med = 0; // Medida actual del sensor de nivel (distancia).
float piso1; // Valor de distancia del sensor al piso 1.
float piso2; // Valor de distancia del sensor al piso 2.
float piso3; // Valor de distancia del sensor al piso 3.

int llamada1 = 0; // Variable que indica que se llamó el ascensor desde el piso 1.
int llamada2 = 0; // Variable que indica que se llamó el ascensor desde el piso 2.
int llamada3 = 0; // Variable que indica que se llamó el ascensor desde el piso 3.
int pAbiertas = 0; // Variable que indica que las puertas se encuentran abiertas.

// HILOS Y SEMÁFOROS.
Thread t1; // Hilo del sensor.
Thread t2; // Hilo de los servomotores.
Thread t3; // Hilo del movimiento del motor.
Semaphore sem(1); // Semáforo.

void medida(){ // Función de la medida del sensor de nivel.
    while(1){
        med = sensor.read(); // Realiza la lectura de la posición actual del ascensor. SRF05
    }
}

void puertas(){ // Función de la apertura y cierre de puertas.
    while(1){
        if(med == piso1 && llamada1 == 1){
            sem.wait();
            servo1.period(0.02);
            servo1.pulsewidth(0.002); // Activar el servo 1 moviéndolo a 90°.
            pAbiertas = 1;
            Thread::wait(5000); // Esperar 5 segundos.
            servo1.period(0.02);
            servo1.pulsewidth(0.0015); // Activar el servo 1 moviéndolo a 0°.
            pAbiertas = 0;
            llamada1 = 0;
            sem.release();
        }
        if(med == piso2 && llamada2 == 1){
            sem.wait();
            servo2.period(0.02);
            servo2.pulsewidth(0.002); // Activar el servo 2 moviéndolo a 90°.
            pAbiertas = 1;
            Thread::wait(5000); // Esperar 5 segundos.
            servo2.period(0.02);
            servo2.pulsewidth(0.0015); // Activar el servo 2 moviéndolo a 0°.
            llamada2 = 0;
            sem.release();
        }
        if(med == piso3 && llamada3 == 1){
            sem.wait();
            servo3.period(0.02);
            servo3.pulsewidth(0.002); // Activar el servo 3 moviéndolo a 90° (abrir).
            pAbiertas = 1;
            Thread::wait(5000); // Esperar 5 segundos.
            servo3.period(0.02);
            servo3.pulsewidth(0.0015); // Activar el servo 3 moviéndolo a 0° (cerrar).
            pAbiertas = 0;
            llamada3 = 0;
            sem.release();
        }
    }
}

void mover(){ // Función del movimiento del ascensor.
    while(1){
        if(!boton1i && med != piso1 && med < piso1 && pAbiertas != 1){ // Pulsar el botón de piso 1.
            sem.wait();
            llamada1 = 1;
            while(med <= piso1){ // Bajar al piso 1 desde cualqueira de los demás pisos.
                giro1.period(0.02); // Activar giro1 (bajar).
                giro1.pulsewidth(0.01);
                giro2.period(0.02);
                giro2.pulsewidth(0);
                if(!botonp){ // Si se pulsa el botón de paro de emergencia se para el ascensor.
                    break;
                }
            }
            giro1.period(0.02); // Parar.
            giro1.pulsewidth(0);
            sem.release();
        }
        if(!boton2i && med != piso2 && med < piso2 && pAbiertas != 1){ // Pulsar el botón de piso 2.
            sem.wait();
            llamada2 = 1;
            while(med <= piso2){ // Bajar al piso 2 desde el tercer piso.
                giro1.period(0.02); // Activar giro1 (bajar).
                giro1.pulsewidth(0.01);
                giro2.period(0.02);
                giro2.pulsewidth(0);
                if(!botonp){ // Si se pulsa el botón de paro de emergencia se para el ascensor.
                    break;
                }
            }
            giro1.period(0.02); // Parar.
            giro1.pulsewidth(0);
            sem.release();
        }
        if(!boton2i && med != piso2 && med > piso2 && pAbiertas != 1){ // Pulsar el botón de piso 2.
            sem.wait();
            llamada2 = 1;
            while(med >= piso2){ // Subir al piso 2 desde el primer piso.
                giro1.period(0.02); // Activar giro2 (subir).
                giro1.pulsewidth(0);
                giro2.period(0.02);
                giro2.pulsewidth(0.01);
                if(!botonp){ // Si se pulsa el botón de paro de emergencia se para el ascensor.
                    break;
                }
            }
            giro2.period(0.02); // Parar.
            giro2.pulsewidth(0);
            sem.release();
        }
        if(!boton3i && med != piso2 && med > piso3 && pAbiertas != 1){ // Pulsar el botón de piso 3.
            sem.wait();
            llamada3 = 1;
            while(med >= piso3){ // Subir al piso 2 desde el primer piso.
                giro1.period(0.02); // Activar giro2 (subir).
                giro1.pulsewidth(0);
                giro2.period(0.02);
                giro2.pulsewidth(0.01);
                if(!botonp){ // Si se pulsa el botón de paro de emergencia se para el ascensor.
                    break;
                }
            }
            giro2.period(0.02); // Parar.
            giro2.pulsewidth(0);
            sem.release();
        }
        if(!boton1i && med == piso1){ // Pulsar el botón de piso 1 en el primer piso.
            sem.wait();
            llamada1 = 1;
            sem.release();
        }
        if(!boton2i && med == piso2){ // Pulsar el botón de piso 2 en el segundo piso.
            sem.wait();
            llamada2 = 1;
            sem.release();
        }
        if(!boton3i && med == piso3){ // Pulsar el botón de piso 3 en el tercer piso.
            sem.wait();
            llamada3 = 1;
            sem.release();
        }   
    }   
}

int main(){ // Función principal.
    t1.start(medida);
    t2.start(puertas);
    t3.start(mover);
    enable = 1; // Habilitar el Puente H.
}
