
#include "Music.h"
AnalogOut speaker(DAC0_OUT);
/**
* @brief Constructor (no paramateters)
*/
Music::Music()
{

}
/**
* @brief Deconstructor
*/
Music::~Music()
{
    
    

}

/**
* @brief Initialiser. Takes the sound data and initialises the buzzer
* @param const int* data @details The audio data. A array of the amplitude of 
* the waveform over time
* @param length @details Length of above sound array 
*/
void Music::init(const int* data,int length)
{
    
    _data = data;
    _length = length;
 // Has to << then 1/sample rate
 // until music played stay silent
    _index = 0;
}
/**
* @brief Plays the next sound sample. Must be called at the sample rate
*/
void Music::play_next()
{
    double duty_cycle;
    duty_cycle = _data[_index];
    //printf("%i = %f\n",_index,duty_cycle);

    if (_index < _length) {      
        speaker = duty_cycle/255;
        printf("%f\n",duty_cycle/255); 
        
        _index++;
    } else {
        _index = 0;    
    }
        
}


