/**
* @brief Struct for storing a blocks location
*/
struct Block {
    Vector2D first; /**< Coord of the top left of the block. */
    Vector2D second; /**<Coord of the bottom right of the block */
};

/**
* @brief Struct for defining moving blocks
*/
struct MovingBlockDefinition {
    int index;  /**< Index of the moving block*/
    bool extending;/**< True if to start in the extending phase. False if not.*/
    int distance; /**< Distance to extend.*/
};

/**
@brief Struct for defining levels.
@code
/////////////// EXAMPLE DEFINITION /////////////////////////
 const LevelDefinition level_1 = {
    // Define Blocks         // Array of blocks
    {                        // Blocks are defined by their top left followed
        { {5,30},{80,40} },  // by there bottom right coord. MUST be in that 
        { {5,5}, {80,10} },  // order.
        { {10,24},{20,34} },
        { {40,24},{44,26} }
    },
    // Number Of Blocks
    4,
    // Moving Blocks          // Movingblocks are defined as:
    {                         // {index,extending,distance}
        {3,true,25},          // index is the index in the block array 
    },                        // of the block which you want to move
    // Number Of Moving blocks   extending is a bool if the block starts in
    1,                        // its extending/retracting phase
    // Initial Position       // distance is the horizontal distance the block
    {32,10},                  // moves.
    // Goal
    {70,19}
};

      NOTE: MAX no. of blocks is 20 MAX no. of moving blocks is 10

//////////////////////////////////////////////////////////////
@endcode

*/
struct LevelDefinition {
    Block blocks [20]; /**< Array of blocks*/
    int number_of_blocks; /**< Number of blocks */
    MovingBlockDefinition moving_blocks [10]; /**< Array of moving block
                                                  definitions*/
    int number_of_moving_blocks ; /**< Number of moving blocks*/
    Vector2D initial_pos; /**< Initial Positon*/
    Vector2D goal; /**< Goal location*/
};

 const LevelDefinition level_1 = {
    // Define Blocks
    {
        { {5,30},{80,40} },
        { {5,5}, {80,10} }
    },
    // Number Of Blocks
    2,
    // Moving Blocks
    {

    },
    // Number Of Moving blocks
    0,
    // Initial Position
    {12,10},
    // Goal
    {75,19}
};

 const LevelDefinition level_2 = {
    // Define Blocks
    {
        { {0,40},{84,45} },
        { {5,5}, {80,10} },
        { {30,20},{40,40} }
    },
    // Number Of Blocks
    3,
    // Moving Blocks
    {
        
    },
    // Number Of Moving blocks
    0,
    // Initial Position
    {12,30},
    // Goal
    {76,29}
};

 const LevelDefinition level_3 = {
    // Define Blocks
    {
        { {0,40},{84,45} },
        { {5,5}, {70,10} },
        { {30,20},{40,40} },
        { {50,10},{60,30} },
        { {70,20},{80,40} }
    },
    // Number Of Blocks
    5,
    // Moving Blocks
    {
        
    },
    // Number Of Moving blocks
    0,
    // Initial Position
    {12,30},
    // Goal
    {72,9}
};
 const LevelDefinition level_4 = {
    // Define Blocks
    {
        { {4,8}, {60,10} },
        { {50,10},{60,30} },
        { {20,22},{50,30} },
        { {0,0}, {5,10} },
        { {5,40}, {58,50} }
        
    },
    // Number Of Blocks
    5,
    // Moving Blocks
    {
        
    },
    // Number Of Moving blocks
    0,
    // Initial Position
    {12,0},
    // Goal
    {30,11}
};
 const LevelDefinition level_5 = {
    // Define Blocks
    {
        { {30,8}, {60,10} },
        { {40 ,20 },{ 70 ,22 } },
        { {30,30}, {60,32} },
        { {0 ,40 },{ 70 ,42 } },
        
        { {70,0},{72,42} },
        { {28,0},{30,32} },
        
        {{0,14},{10,40} },
        {{0,0},{30,2}},
    },
    // Number Of Blocks
    8,
    // Moving Blocks
    {
        
    },
    // Number Of Moving blocks
    0,
    // Initial Position
    {30,0},
    // Goal
    {1,3}
};

 const LevelDefinition level_6 = {
    // Define Blocks
    {
        {{1,20},{12,48}},
        {{12,26},{22,36}},
        {{77,28},{84,48}},
    },
    // Number Of Blocks
    3,
    // Moving Blocks
    {
        {1,false,55}, //55
    },
    // Number Of Moving blocks
    1,
    // Initial Position
    {0,10},
    // Goal
    {77,17}
};


 const LevelDefinition level_7 = {
    // Define Blocks
    {
        {{1,34},{12,48}},
        {{12,38},{22,48}},
        {{32,0},{42,10}},
        {{77,30},{84,48}},
    },
    // Number Of Blocks
    4,
    // Moving Blocks
    {
        {1,true,25}, 
        {2,false,25}, 
    },
    // Number Of Moving blocks
    2,
    // Initial Position
    {0,20},
    // Goal
    {77,19}
};

 const LevelDefinition level_8 = {
    // Define Blocks
    {
        {{10,10},{64,14}},
        {{20,0},{22,14}},
        
        {{0,40},{10,44}},

        
        {{20,20},{24,48}},
        {{36,14},{40,32}},
        {{50,20},{54,48}},
        {{60,14},{64,32}},
        
        {{66,0},{84,2}},
        
    },
    // Number Of Blocks
    8,
    // Moving Blocks
    {
        {2,false,70}, 
    },
    // Number Of Moving blocks
    1,
    // Initial Position
    {10,0},
    // Goal
    {24,-1}
};

 const LevelDefinition level_9 = {
    // Define Blocks
    {
        {{0,30},{10,48}},
        {{10,44},{18,48}},
        {{24,44},{84,48}},
        {{12,10},{20,14}},
        {{2,0},{18,4}}
        

        
    },
    // Number Of Blocks
    4,
    // Moving Blocks
    {
        {4,false,30}, 
    },
    // Number Of Moving blocks
    1,
    // Initial Position
    {10,30},
    // Goal
    {84,48}
};

