#include "Sprite.h"
/**
* @brief Constructor (no paramateters)
*/

Sprite::Sprite() {}
/**
* @brief Deconstructor
*/
Sprite::~Sprite() {}
/**
* @brief Initialises the Sprite
* @param int height @details Sprite Height
* @param int width @details Sprite Width
* @param int * bitmap @details Pointer to 2D bitmap array
* @param Vector2D pos @details Initial Position
*/
void Sprite::init(int height,int width,int * bitmap,Vector2D pos)
{
    _height = height;
    _width = width;
    _bitmap = bitmap;
    _pos = pos;
}
/**
* @brief Renders the Sprite on the LCD
* @param N5110 lcd @details LCD object.
*/
void Sprite::render(N5110 &lcd)
{

    lcd.drawSprite(_pos.x,_pos.y,_height,_width, _bitmap);
};
/**
* @brief Get Sprite Position
* @returns Sprite Positon.
*/
Vector2D Sprite::get_pos()
{
    return _pos;
};
/**
* @brief Sets Sprite Position
* @param Vector2D pos @details Sprite Position.
*/
void Sprite::set_pos(Vector2D pos)
{
    _pos = pos;
};
/**
* @brief Sets Sprite Bitmap (Note: Must  be of Sprite dimensions.)
* @param int * bitmap @details Pointer to 2D array containing Sprite Bitmap.
*/
void Sprite::setBitmap(int * bitmap)
{
    _bitmap = bitmap  ;
};

