/** 
* @brief The Sound Data. Generated using Wav2Code.
* https://github.com/Sphinkie/Arditime/tree/master/tools/wav2code
*/

/**********************************************************************
* Written by WAVToCode
* Date:             Sat Apr 06 05:06:48 PM
* FileName:         8bit.C
* Interleaved:      Yes
* Signed:           No
* No. of channels:  1
* No. of samples:   120000
* Bits/Sample:      8
**********************************************************************/

#define NUM_ELEMENTS 120000

const int sound_data[NUM_ELEMENTS] = {
126, 128, 126, 130, 124, 130, 126, 138, // 0-7
164, 162, 130,  98,  82,  78,  91,  32, // 8-15
 92, 144, 196, 154, 126, 166, 224,  10, // 16-23
196, 110,  24,  80,  92, 142,  74, 114, // 24-31
222, 182, 138, 104,  80,  58, 114,  58, // 32-39
 10, 246,   6,  18,  60,  52,  44, 130, // 40-47
174, 200, 194, 200, 170, 224, 200, 132, // 48-55
168, 122,  78,  62,  68,  22,  28, 124, // 56-63
216, 254,  26,  12, 228,   6, 226, 196, // 64-71
170, 156, 134, 132,  56,  64, 120, 118, // 72-79
240, 214,  74,  18,  34, 222, 188, 188, // 80-87
218, 250,  44,  60,  26, 116, 232,  44, // 88-95
 56,  68, 242,  12,  18, 214, 194, 160, // 96-103
186, 206, 118,  28,  62,  88, 102,  96, // 104-111
102,  80, 124, 128,  76,  42,  38,  52, // 112-119
 62,  82,  34,  82, 144, 170, 180, 182, // 120-127
180, 252, 230, 128,  60,  48,  28, 242, // 128-135
 74,  90, 128, 220,   2, 204, 242,  12, // 136-143
  8,  46, 232, 152, 106,  76,  58,  52, // 144-151
 30, 120, 118,  62,  34,  12,  20,  10, // 152-159
 78,  88,  52,  48,  74,  40,  82, 160, // 160-167
150, 228,  30, 243, 247,  32,  10,  34, // 168-175
 18, 241, 189,  96,  54,  16,  27, 225, // 176-183
  0,  66, 103, 114, 127, 136, 124, 175, // 184-191
124,  87,  63,  70,  64,  92,  64,  68, // 192-199
127, 197, 252, 192, 168, 125, 186, 107, // 200-207
 43,  74, 114, 130, 168, 150,  70, 176, // 208-215
241,  22,   2, 250, 196, 214, 180, 111, // 216-223
 39,  57, 141,  46, 246, 162, 198, 254, // 224-231
 45,  67, 103, 108, 150, 198, 104, 111, // 232-239
150, 180, 197, 207, 115, 153, 237,  19, // 240-247
 22, 255,  30, 234, 209, 127,  49,   9, // 248-255
253, 252,  17,  16, 248,  82, 129, 134, // 256-263
146, 156, 143, 179, 168, 108,  85,  74, // 264-271
 84,  80, 138, 112, 114, 137, 148, 156, // 272-279
110, 110, 180, 234, 183, 172, 124, 100, // 280-287
143, 180, 148, 154, 199, 201, 194, 166, // 288-295
154, 112, 210, 191,  49, 222, 190, 189, // 296-303
219, 218, 227,  68, 113, 164, 166, 145, // 304-311
180,  20,   9, 229, 168, 128, 164, 186, // 312-319
193, 144, 192,   4, 232, 170, 142,  98, // 320-327
115, 109,  51,  21,  20,  20,  56,  70, // 328-335
 18,  73, 127, 159, 163, 170, 155, 164, // 336-343
190, 141, 100, 133, 128,  86,  84,  50, // 344-351
 52,  66, 133, 186, 218, 224, 232, 224, // 352-359
176, 171, 159, 158, 142, 145, 115,  78, // 360-367
113, 137, 130, 203, 198,  86,  74,  36, // 368-375
239, 220, 234, 254,  35,  61,  59,  96, // 376-383
127, 208, 250,  18,  10, 231, 238, 214, // 384-391
186, 175, 158, 161, 199, 110,  80, 101, // 392-399
108, 106, 103,  96,  94, 136,  90,  89, // 400-407
 48,  47,  60,  86,  74,  67, 125, 154, // 408-415
170, 170, 173, 156, 244, 193, 115,  69, // 416-423
 70,  44,  30,  82,  86, 159, 203, 240, // 424-431
186, 200, 212, 246, 246, 178, 136, 108, // 432-439
 92,  80,  78,  35, 140, 146,  93,  58, // 440-447
 45,  34,  49,  96,  65,  58,  56,  90, // 448-455
 70,  92, 126, 154, 229, 255, 215, 225, // 456-463
249, 235,  18, 215, 187, 172, 113,  72, // 464-471
 56,  36,   4,  59,  88, 113, 111, 125, // 472-479
138, 134, 134,  97,  84,  78,  85,  90, // 480-487
102,  69, 112, 147, 180, 222, 190, 150, // 488-495
144, 168,  79,  52,  82, 116, 130, 159, // 496-503
132, 102, 170, 217, 234, 226, 209, 185, // 504-511
203, 142, 101,  59,  77, 130,  89,  11, // 512-519
221,  11,  41,  68,  82, 104, 109, 158, // 520-527
163,  99,  94, 141, 159, 190, 174, 111, // 528-535
176, 225, 246, 241, 224, 226, 236, 185, // 536-543
106,  58,  36,  28,  32,  44,  25,  46, // 544-551
112, 148, 118, 135, 135, 147, 171, 134, // 552-559
105,  93,  92,  97, 106, 109, 135, 148, // 560-567
148, 147, 148, 106, 114, 181, 181, 152, // 568-575
148, 135,  99, 138, 149, 135, 171, 190, // 576-583
189, 174, 159, 136, 140, 170, 156,  69, // 584-591
 11, 241, 243,   2, 242,  35,  93, 126, // 592-599
148, 166, 130, 169, 229, 198, 191, 146, // 600-607
132, 156, 182, 157, 160, 188, 232, 215, // 608-615
163, 134, 107, 129,  85,  57,  37,  50, // 616-623
 39,  92,  76,  37, 103, 131, 154, 151, // 624-631
160, 143, 177, 157, 126,  97, 127, 135, // 632-639
112,  95,  64,  92,  88, 140, 166, 195, // 640-647
183, 217, 200, 133, 140, 142, 149, 140, // 648-655
146, 104, 112, 134, 145, 134, 182, 177, // 656-663
113,  97,  38,   8, 254,  17,  30,  67, // 664-671
 62,  82, 131, 132, 179, 210, 226, 222, // 672-679
214, 189, 178, 165, 166, 153, 155, 173, // 680-687
120, 120, 122, 120, 110, 107,  94, 116, // 688-695
121,  77,  99,  69,  55,  77,  93,  75, // 696-703
104, 142, 158, 161, 161, 156, 156, 209, // 704-711
164, 114,  84,  88,  61,  61,  79, 108, // 712-719
168, 188, 209, 176, 163, 182, 219, 188, // 720-727
152, 127, 116, 101, 104,  83,  71, 155, // 728-735
158, 114,  81,  69,  53,  85,  87,  64, // 736-743
 66,  74,  95,  99,  92, 109, 163, 210, // 744-751
222, 186, 204, 207, 223, 230, 176, 155, // 752-759
161, 125,  92,  83,  47,  55,  90, 106, // 760-767
114, 117, 118, 151, 135, 100,  90,  85, // 768-775
 93,  94, 111,  98,  96, 136, 155, 163, // 776-783
196, 182, 146, 156, 137,  75,  62,  96, // 784-791
114, 138, 139, 129, 132, 157, 193, 198, // 792-799
200, 178, 185, 173, 124, 100,  80,  95, // 800-807
130, 108,  35,  34,  56,  73,  81,  97, // 808-815
101, 122, 148, 132, 102,  88, 132, 144, // 816-823
179, 141, 127, 182, 211, 217, 214, 196, // 824-831
195, 225, 155, 104,  70,  63,  51,  66, // 832-839
 55,  53,  86, 125, 156, 112, 125, 122, // 840-847
152, 145, 118, 104, 105, 104, 112, 113, // 848-855
100, 156, 162, 153, 143, 141, 100, 129, // 856-863
162, 145, 137, 135, 137, 105, 128, 125, // 864-871
144, 173, 181, 174, 164, 149, 140, 149, // 872-879
139, 137,  88,  48,  24,  33,  23,  28, // 880-887
 78, 107, 130, 138, 156, 131, 161, 180, // 888-895
163, 165, 137, 131, 157, 164, 146, 175, // 896-903
180, 205, 198, 161, 129, 127, 121,  79, // 904-911
 65,  55,  69,  63, 104,  82,  68, 113, // 912-919
134, 145, 147, 146, 149, 169, 132, 119, // 920-927
103, 122, 138, 130,  93,  94, 114, 107, // 928-935
140, 157, 173, 169, 201, 169, 117, 122, // 936-943
135, 137, 142, 129, 110, 133, 143, 143, // 944-951
138, 164, 158, 137,  98,  52,  33,  31, // 952-959
 43,  57,  76,  69, 106, 143, 139, 157, // 960-967
187, 191, 206, 186, 159, 160, 155, 153, // 968-975
149, 148, 147, 144, 139, 133, 123, 118, // 976-983
107, 105, 123, 105,  79, 105,  86,  61, // 984-991
 90,  87,  91, 124, 145, 152, 155, 153, // 992-999
149, 162, 169, 150, 116,  98,  95,  81, // 1000-1007
 73,  87, 130, 166, 178, 188, 174, 145, // 1008-1015
176, 187, 155, 137, 124, 117, 108, 110, // 1016-1023
 80, 104, 151, 157, 121, 100,  80,  81, // 1024-1031
100,  79,  72,  76,  89,  99, 117,  86, // 1032-1039
114, 163, 195, 195, 172, 185, 189, 209, // 1040-1047
185, 155, 138, 154, 129, 109,  86,  66, // 1048-1055
 92, 106, 114, 117, 122, 116, 161, 123, // 1056-1063
 87,  90,  94,  99, 103, 113,  97, 120, // 1064-1071
142, 157, 153, 179, 172, 154, 152, 119, // 1072-1079
 81,  77, 104, 115, 139, 124, 141, 147, // 1080-1087
151, 173, 179, 177, 167, 177, 145, 116, // 1088-1095
 99,  92, 101, 126, 107,  66,  75,  81, // 1096-1103
 88,  91, 102, 104, 134, 132, 120, 108, // 1104-1111
 96, 124, 141, 160, 131, 145, 178, 195, // 1112-1119
192, 194, 177, 185, 200, 143, 107,  83, // 1120-1127
 78,  70,  79,  62,  83, 105, 131, 151, // 1128-1135
117, 116, 127, 148, 126, 113, 106, 109, // 1136-1143
106, 118, 108, 110, 160, 166, 151, 144, // 1144-1151
136, 107, 137, 142, 133, 131, 133, 135, // 1152-1159
119, 115, 122, 151, 166, 169, 162, 156, // 1160-1167
139, 143, 136, 125, 123, 102,  70,  56, // 1168-1175
 54,  40,  64,  97, 116, 130, 142, 147, // 1176-1183
144, 150, 151, 148, 153, 134, 130, 154, // 1184-1191
145, 148, 172, 173, 180, 187, 156, 133, // 1192-1199
130, 106,  83,  75,  74,  80,  84, 103, // 1200-1207
101,  92, 116, 132, 140, 143, 139, 154, // 1208-1215
147, 123, 117, 113, 116, 140, 131, 101, // 1216-1223
118, 120, 114, 134, 153, 156, 170, 176, // 1224-1231
151, 117, 117, 131, 131, 139, 120, 126, // 1232-1239
138, 143, 134, 141, 148, 151, 142,  93, // 1240-1247
 68,  53,  57,  58,  80,  81,  95, 125, // 1248-1255
148, 140, 147, 169, 174, 194, 158, 147, // 1256-1263
148, 151, 143, 148, 137, 137, 157, 144, // 1264-1271
134, 121, 120, 107, 118, 116,  99,  87, // 1272-1279
111,  99,  74,  94,  89, 112, 131, 145, // 1280-1287
145, 151, 143, 150, 154, 141, 143, 122, // 1288-1295
109, 104,  94,  78, 105, 139, 159, 165, // 1296-1303
172, 165, 141, 163, 156, 140, 131, 127, // 1304-1311
117, 117, 108,  94, 125, 144, 150, 128, // 1312-1319
109,  93,  99,  95,  80,  81,  88,  98, // 1320-1327
109, 120,  95, 127, 158, 180, 176, 164, // 1328-1335
170, 183, 187, 158, 146, 132, 145, 133, // 1336-1343
118,  91,  92, 107, 112, 115, 120, 119, // 1344-1351
123, 158, 115,  86,  94, 101, 103, 113, // 1352-1359
108, 109, 133, 142, 149, 146, 160, 163, // 1360-1367
158, 137, 115,  87,  90, 107, 121, 129, // 1368-1375
124, 150, 153, 143, 157, 166, 159, 165, // 1376-1383
159, 131, 116, 106,  98, 110, 120, 107, // 1384-1391
 98,  98,  98,  99, 105, 107, 117, 130, // 1392-1399
120, 116, 116, 104, 117, 139, 142, 135, // 1400-1407
149, 170, 177, 177, 171, 164, 169, 164, // 1408-1415
135, 109,  96,  87,  88,  85,  81, 107, // 1416-1423
117, 134, 151, 124, 111, 133, 134, 117, // 1424-1431
112, 112, 111, 115, 117, 111, 127, 157, // 1432-1439
166, 148, 146, 129, 119, 132, 127, 125, // 1440-1447
127, 129, 133, 127, 107, 130, 153, 160, // 1448-1455
156, 155, 143, 138, 138, 120, 118, 112, // 1456-1463
110,  85,  82,  70,  73,  96, 112, 122, // 1464-1471
132, 138, 141, 150, 132, 133, 140, 146, // 1472-1479
127, 134, 145, 142, 156, 162, 162, 160, // 1480-1487
172, 148, 137, 125, 102,  89,  87,  86, // 1488-1495
 90,  96, 105, 123, 108, 117, 129, 137, // 1496-1503
135, 138, 144, 129, 120, 115, 117, 116, // 1504-1511
139, 131, 119, 134, 127, 121, 136, 145, // 1512-1519
147, 160, 148, 140, 119, 116, 127, 134, // 1520-1527
133, 124, 139, 139, 142, 131, 138, 137, // 1528-1535
143, 132,  95,  81,  75,  76,  79,  92, // 1536-1543
 89, 113, 130, 146, 141, 140, 150, 166, // 1544-1551
171, 138, 141, 142, 146, 139, 144, 129, // 1552-1559
139, 159, 148, 136, 128, 120, 112, 121, // 1560-1567
106,  99,  94, 116, 108,  91,  94, 103, // 1568-1575
127, 135, 143, 141, 145, 136, 146, 136, // 1576-1583
126, 135, 128, 114, 116, 101,  92, 123, // 1584-1591
139, 151, 153, 158, 154, 143, 144, 137, // 1592-1599
134, 129, 126, 122, 122, 111, 111, 133, // 1600-1607
139, 140, 133, 112, 106, 108,  93,  87, // 1608-1615
 91,  98, 104, 117, 121, 114, 132, 152, // 1616-1623
167, 163, 152, 158, 171, 161, 144, 136, // 1624-1631
128, 134, 139, 121, 103, 113, 115, 118, // 1632-1639
117, 120, 116, 129, 143, 113,  92,  98, // 1640-1647
108, 113, 118, 111, 125, 138, 142, 142, // 1648-1655
141, 142, 158, 151, 127, 115,  96, 102, // 1656-1663
114, 126, 121, 130, 149, 152, 140, 145, // 1664-1671
150, 151, 157, 140, 125, 116, 114, 106, // 1672-1679
122, 113, 114, 119, 111, 111, 107, 109, // 1680-1687
108, 124, 122, 115, 115, 121, 112, 120, // 1688-1695
133, 136, 142, 148, 163, 163, 166, 155, // 1696-1703
159, 152, 145, 134, 114, 107, 100, 100, // 1704-1711
 90, 101, 115, 121, 131, 145, 122, 114, // 1712-1719
130, 123, 118, 113, 118, 117, 125, 116, // 1720-1727
119, 132, 147, 159, 145, 139, 126, 125, // 1728-1735
123, 123, 121, 125, 127, 136, 127, 110, // 1736-1743
133, 145, 154, 148, 147, 136, 142, 132, // 1744-1751
118, 120, 111, 116, 103,  98,  84,  93, // 1752-1759
105, 118, 122, 129, 129, 140, 147, 123, // 1760-1767
124, 129, 139, 129, 137, 136, 143, 154, // 1768-1775
156, 156, 149, 157, 146, 142, 121, 105, // 1776-1783
 95,  96,  97, 103,  99, 111, 131, 117, // 1784-1791
120, 125, 133, 131, 142, 137, 125, 120, // 1792-1799
117, 120, 122, 133, 128, 130, 137, 129, // 1800-1807
122, 132, 135, 145, 148, 136, 133, 120, // 1808-1815
115, 124, 131, 124, 128, 138, 140, 140, // 1816-1823
133, 134, 137, 140, 126, 105,  95,  90, // 1824-1831
 90,  96,  95, 101, 121, 131, 144, 143, // 1832-1839
135, 141, 160, 152, 133, 135, 139, 140, // 1840-1847
140, 136, 126, 138, 152, 147, 136, 127, // 1848-1855
116, 120, 117, 105, 100, 100, 116, 116, // 1856-1863
 99,  92, 112, 128, 136, 140, 141, 139, // 1864-1871
142, 145, 133, 125, 132, 130, 123, 123, // 1872-1879
103, 109, 127, 137, 141, 142, 143, 145, // 1880-1887
142, 131, 128, 126, 127, 125, 125, 119, // 1888-1895
118, 123, 131, 130, 130, 129, 122, 125, // 1896-1903
117, 109, 109, 111, 113, 118, 119, 123, // 1904-1911
128, 131, 135, 137, 138, 136, 143, 143, // 1912-1919
137, 132, 132, 129, 130, 131, 125, 127, // 1920-1927
127, 123, 123, 122, 121, 124, 127, 126, // 1928-1935
122, 117, 119, 121, 122, 121, 124, 128, // 1936-1943
130, 131, 131, 130, 131, 136, 132, 131, // 1944-1951
129, 124, 125, 127, 125, 125, 130, 132, // 1952-1959
133, 130, 128, 126, 128, 128, 124, 123, // 1960-1967
123, 123, 125, 124, 123, 125, 127, 129, // 1968-1975
130, 125, 124, 126, 127, 125, 126, 128, // 1976-1983
130, 130, 128, 126, 127, 130, 131, 131, // 1984-1991
131, 128, 128, 129, 126, 127, 128, 127, // 1992-1999
129, 127, 123, 124, 125, 125, 126, 128, // 2000-2007
127, 127, 126, 124, 123, 124, 124, 125, // 2008-2015
126, 126, 126, 128, 127, 129, 131, 131, // 2016-2023
132, 131, 128, 128, 128, 127, 126, 130, // 2024-2031
130, 129, 129, 128, 125, 127, 127, 125, // 2032-2039
126, 125, 124, 124, 124, 123, 125, 127, // 2040-2047
128, 128, 126, 124, 126, 128, 127, 128, // 2048-2055
130, 129, 129, 129, 126, 126, 128, 127, // 2056-2063
128, 129, 127, 127, 129, 127, 128, 129, // 2064-2071
129, 130, 128, 126, 124, 126, 124, 124, // 2072-2079
127, 128, 126, 126, 125, 124, 127, 126, // 2080-2087
125, 127, 127, 125, 126, 126, 127, 129, // 2088-2095
131, 131, 129, 128, 129, 130, 129, 129, // 2096-2103
129, 131, 129, 128, 126, 124, 125, 125, // 2104-2111
125, 125, 126, 124, 126, 126, 126, 126, // 2112-2119
129, 129, 127, 126, 124, 124, 125, 126, // 2120-2127
126, 129, 130, 130, 128, 128, 127, 127, // 2128-2135
129, 127, 128, 126, 127, 126, 127, 127, // 2136-2143
130, 131, 130, 130, 128, 127, 127, 127, // 2144-2151
126, 127, 126, 126, 124, 123, 123, 125, // 2152-2159
125, 125, 127, 127, 126, 126, 127, 128, // 2160-2167
128, 131, 129, 128, 127, 128, 127, 129, // 2168-2175
130, 130, 132, 132, 129, 127, 127, 126, // 2176-2183
125, 123, 124, 123, 123, 124, 124, 125, // 2184-2191
127, 130, 128, 129, 128, 126, 125, 126, // 2192-2199
125, 126, 127, 128, 127, 127, 129, 129, // 2200-2207
129, 129, 130, 128, 128, 127, 126, 126, // 2208-2215
127, 129, 128, 128, 128, 127, 126, 128, // 2216-2223
127, 128, 129, 127, 126, 124, 123, 122, // 2224-2231
123, 122, 123, 124, 125, 126, 127, 129, // 2232-2239
130, 132, 132, 130, 129, 128, 126, 126, // 2240-2247
127, 127, 129, 131, 131, 130, 129, 130, // 2248-2255
129, 127, 127, 125, 123, 123, 123, 122, // 2256-2263
122, 126, 127, 126, 128, 128, 127, 127, // 2264-2271
128, 128, 128, 128, 128, 126, 125, 126, // 2272-2279
126, 127, 129, 129, 129, 130, 130, 130, // 2280-2287
129, 129, 129, 126, 126, 125, 124, 123, // 2288-2295
124, 125, 127, 128, 129, 129, 127, 127, // 2296-2303
127, 124, 123, 124, 122, 122, 123, 124, // 2304-2311
125, 128, 131, 132, 131, 132, 132, 129, // 2312-2319
128, 129, 128, 128, 129, 127, 127, 127, // 2320-2327
128, 128, 127, 128, 126, 126, 125, 125, // 2328-2335
123, 122, 124, 123, 121, 123, 125, 124, // 2336-2343
127, 129, 130, 131, 132, 133, 131, 130, // 2344-2351
129, 128, 126, 127, 126, 126, 127, 128, // 2352-2359
128, 128, 130, 130, 130, 128, 128, 124, // 2360-2367
123, 123, 122, 122, 124, 126, 126, 126, // 2368-2375
126, 128, 127, 127, 128, 126, 126, 125, // 2376-2383
126, 124, 125, 127, 128, 128, 131, 130, // 2384-2391
130, 132, 134, 133, 131, 132, 129, 128, // 2392-2399
126, 125, 124, 124, 125, 124, 124, 123, // 2400-2407
127, 126, 127, 126, 125, 124, 124, 124, // 2408-2415
122, 123, 125, 127, 127, 130, 131, 132, // 2416-2423
133, 133, 132, 130, 129, 126, 127, 125, // 2424-2431
124, 125, 125, 127, 128, 127, 128, 130, // 2432-2439
128, 128, 127, 126, 125, 127, 126, 124, // 2440-2447
124, 124, 125, 126, 126, 126, 128, 127, // 2448-2455
129, 128, 128, 127, 128, 127, 124, 126, // 2456-2463
124, 127, 130, 132, 130, 131, 133, 132, // 2464-2471
131, 130, 128, 126, 126, 121, 120, 119, // 2472-2479
121, 123, 125, 124, 124, 126, 126, 128, // 2480-2487
128, 127, 127, 128, 127, 125, 127, 129, // 2488-2495
130, 132, 132, 130, 131, 130, 130, 130, // 2496-2503
128, 127, 126, 125, 123, 123, 122, 124, // 2504-2511
125, 125, 125, 128, 129, 129, 130, 129, // 2512-2519
128, 126, 126, 124, 124, 123, 122, 124, // 2520-2527
125, 126, 127, 129, 130, 130, 129, 128, // 2528-2535
127, 128, 129, 129, 130, 129, 128, 130, // 2536-2543
131, 131, 131, 131, 129, 127, 124, 123, // 2544-2551
122, 122, 121, 122, 121, 121, 121, 124, // 2552-2559
125, 128, 130, 130, 131, 131, 129, 129, // 2560-2567
131, 130, 129, 127, 127, 128, 128, 128, // 2568-2575
129, 130, 129, 129, 127, 126, 125, 126, // 2576-2583
124, 124, 124, 125, 126, 128, 128, 128, // 2584-2591
130, 129, 129, 128, 127, 128, 125, 123, // 2592-2599
122, 122, 122, 124, 126, 127, 127, 129, // 2600-2607
129, 129, 131, 132, 132, 132, 130, 127, // 2608-2615
127, 129, 129, 127, 128, 128, 127, 126, // 2616-2623
126, 125, 124, 125, 124, 121, 120, 121, // 2624-2631
122, 124, 126, 126, 129, 130, 132, 132, // 2632-2639
132, 133, 132, 131, 129, 128, 126, 126, // 2640-2647
126, 126, 125, 124, 127, 128, 127, 127, // 2648-2655
128, 127, 126, 126, 125, 125, 126, 127, // 2656-2663
127, 127, 127, 128, 127, 130, 129, 127, // 2664-2671
125, 125, 124, 122, 124, 124, 125, 126, // 2672-2679
127, 127, 129, 132, 134, 134, 134, 133, // 2680-2687
129, 130, 129, 128, 126, 125, 125, 123, // 2688-2695
123, 123, 124, 124, 127, 126, 123, 123, // 2696-2703
124, 124, 125, 125, 125, 127, 128, 130, // 2704-2711
130, 131, 133, 134, 132, 131, 129, 128, // 2712-2719
128, 126, 125, 123, 124, 125, 126, 124, // 2720-2727
127, 128, 129, 129, 128, 128, 128, 129, // 2728-2735
127, 125, 123, 125, 124, 125, 126, 127, // 2736-2743
127, 127, 127, 126, 125, 127, 127, 125, // 2744-2751
125, 125, 125, 128, 131, 131, 132, 133, // 2752-2759
132, 131, 131, 131, 130, 129, 127, 124, // 2760-2767
123, 122, 122, 122, 122, 122, 123, 123, // 2768-2775
125, 126, 126, 128, 128, 128, 127, 127, // 2776-2783
127, 128, 128, 130, 129, 130, 130, 130, // 2784-2791
131, 130, 129, 127, 126, 124, 125, 123, // 2792-2799
124, 126, 127, 127, 128, 129, 129, 131, // 2800-2807
131, 129, 126, 127, 127, 125, 124, 123, // 2808-2815
124, 125, 125, 124, 125, 126, 129, 128, // 2816-2823
126, 127, 127, 128, 128, 129, 128, 130, // 2824-2831
130, 130, 128, 130, 131, 131, 130, 128, // 2832-2839
126, 125, 125, 124, 123, 122, 121, 122, // 2840-2847
123, 123, 126, 128, 130, 131, 130, 129, // 2848-2855
129, 130, 128, 127, 127, 126, 127, 127, // 2856-2863
127, 128, 129, 129, 128, 127, 126, 125, // 2864-2871
125, 124, 125, 124, 125, 126, 128, 128, // 2872-2879
129, 130, 129, 129, 130, 128, 126, 128, // 2880-2887
126, 125, 125, 124, 123, 125, 126, 126, // 2888-2895
126, 127, 129, 129, 130, 130, 130, 129, // 2896-2903
129, 128, 127, 125, 128, 129, 129, 128, // 2904-2911
128, 128, 128, 128, 125, 125, 123, 122, // 2912-2919
121, 121, 123, 125, 127, 129, 130, 130, // 2920-2927
131, 131, 131, 129, 128, 128, 128, 126, // 2928-2935
126, 126, 127, 128, 127, 126, 126, 126, // 2936-2943
126, 126, 127, 125, 126, 126, 126, 125, // 2944-2951
125, 125, 127, 127, 128, 128, 129, 129, // 2952-2959
129, 128, 127, 127, 125, 125, 124, 124, // 2960-2967
124, 126, 127, 128, 130, 132, 132, 132, // 2968-2975
131, 129, 129, 128, 127, 127, 126, 126, // 2976-2983
125, 126, 126, 127, 126, 127, 126, 124, // 2984-2991
123, 123, 124, 124, 125, 125, 127, 128, // 2992-2999
128, 129, 130, 131, 132, 131, 131, 130, // 3000-3007
128, 128, 127, 127, 125, 125, 124, 125, // 3008-3015
124, 125, 126, 128, 128, 128, 129, 128, // 3016-3023
127, 126, 126, 125, 125, 125, 126, 127, // 3024-3031
127, 127, 127, 128, 128, 128, 127, 126, // 3032-3039
125, 125, 125, 126, 126, 128, 130, 131, // 3040-3047
131, 130, 130, 130, 130, 129, 128, 127, // 3048-3055
125, 125, 124, 125, 124, 125, 125, 124, // 3056-3063
124, 124, 125, 126, 127, 127, 126, 128, // 3064-3071
127, 127, 127, 128, 129, 130, 130, 130, // 3072-3079
130, 130, 130, 129, 128, 127, 125, 125, // 3080-3087
124, 123, 123, 124, 126, 128, 128, 129, // 3088-3095
129, 127, 128, 128, 127, 126, 126, 126, // 3096-3103
126, 126, 125, 126, 128, 129, 129, 127, // 3104-3111
127, 126, 125, 126, 126, 127, 128, 129, // 3112-3119
129, 128, 128, 129, 131, 132, 130, 130, // 3120-3127
129, 127, 127, 125, 124, 124, 125, 124, // 3128-3135
123, 123, 123, 125, 127, 128, 128, 129, // 3136-3143
130, 129, 127, 126, 127, 128, 128, 128, // 3144-3151
127, 128, 129, 130, 129, 128, 129, 127, // 3152-3159
126, 125, 122, 122, 124, 126, 127, 127, // 3160-3167
128, 130, 130, 130, 129, 128, 129, 129, // 3168-3175
127, 125, 124, 124, 125, 126, 127, 126, // 3176-3183
126, 127, 126, 125, 126, 127, 128, 129, // 3184-3191
128, 127, 126, 127, 128, 128, 129, 130, // 3192-3199
130, 130, 129, 128, 128, 126, 127, 126, // 3200-3207
123, 122, 123, 124, 124, 126, 127, 129, // 3208-3215
130, 130, 130, 128, 128, 128, 129, 127, // 3216-3223
126, 126, 128, 127, 128, 126, 127, 129, // 3224-3231
128, 127, 124, 124, 124, 125, 125, 124, // 3232-3239
126, 128, 130, 128, 128, 128, 130, 132, // 3240-3247
131, 129, 127, 127, 127, 126, 124, 125, // 3248-3255
126, 125, 125, 124, 124, 126, 129, 129, // 3256-3263
129, 129, 128, 128, 127, 127, 127, 128, // 3264-3271
130, 128, 127, 127, 129, 129, 129, 128, // 3272-3279
127, 125, 124, 124, 123, 123, 124, 126, // 3280-3287
128, 128, 128, 129, 130, 130, 130, 129, // 3288-3295
129, 128, 127, 126, 126, 124, 125, 127, // 3296-3303
127, 127, 126, 126, 127, 126, 125, 126, // 3304-3311
127, 127, 127, 127, 125, 127, 129, 130, // 3312-3319
130, 130, 129, 130, 130, 127, 126, 126, // 3320-3327
127, 125, 123, 122, 122, 124, 125, 127, // 3328-3335
127, 129, 129, 129, 129, 128, 128, 129, // 3336-3343
129, 128, 125, 125, 128, 129, 127, 128, // 3344-3351
129, 128, 128, 127, 125, 124, 125, 126, // 3352-3359
125, 125, 126, 127, 129, 129, 128, 129, // 3360-3367
129, 129, 128, 127, 126, 126, 125, 125, // 3368-3375
125, 124, 126, 126, 126, 125, 126, 126, // 3376-3383
128, 129, 129, 128, 128, 128, 127, 128, // 3384-3391
129, 129, 129, 128, 128, 128, 127, 128, // 3392-3399
129, 128, 126, 124, 123, 124, 124, 125, // 3400-3407
125, 127, 128, 128, 126, 128, 129, 129, // 3408-3415
130, 128, 127, 127, 127, 126, 126, 126, // 3416-3423
127, 127, 126, 126, 126, 127, 127, 128, // 3424-3431
127, 127, 127, 129, 127, 128, 128, 127, // 3432-3439
128, 127, 128, 127, 128, 128, 126, 126, // 3440-3447
126, 125, 126, 126, 124, 124, 124, 125, // 3448-3455
126, 128, 128, 130, 130, 129, 129, 128, // 3456-3463
129, 129, 129, 128, 127, 126, 126, 127, // 3464-3471
127, 128, 127, 127, 126, 126, 126, 126, // 3472-3479
126, 128, 126, 126, 125, 125, 127, 127, // 3480-3487
128, 128, 128, 129, 127, 127, 127, 127, // 3488-3495
127, 127, 126, 125, 126, 127, 127, 127, // 3496-3503
128, 128, 129, 128, 128, 127, 128, 128, // 3504-3511
128, 126, 126, 127, 127, 127, 127, 126, // 3512-3519
126, 126, 126, 126, 126, 126, 125, 126, // 3520-3527
126, 126, 127, 128, 129, 128, 127, 127, // 3528-3535
128, 130, 130, 129, 129, 127, 127, 127, // 3536-3543
126, 126, 126, 127, 127, 125, 125, 126, // 3544-3551
127, 127, 128, 128, 127, 126, 127, 127, // 3552-3559
127, 128, 128, 127, 127, 126, 126, 127, // 3560-3567
127, 127, 126, 127, 126, 127, 127, 127, // 3568-3575
127, 128, 127, 127, 127, 128, 128, 129, // 3576-3583
129, 128, 127, 127, 128, 127, 126, 125, // 3584-3591
125, 125, 125, 125, 125, 126, 127, 127, // 3592-3599
127, 127, 127, 127, 129, 128, 128, 127, // 3600-3607
128, 128, 128, 128, 128, 128, 129, 127, // 3608-3615
127, 127, 127, 127, 127, 125, 126, 126, // 3616-3623
126, 127, 126, 126, 127, 126, 127, 128, // 3624-3631
128, 128, 127, 127, 126, 126, 125, 125, // 3632-3639
126, 127, 126, 126, 127, 128, 128, 128, // 3640-3647
129, 128, 128, 127, 127, 127, 127, 128, // 3648-3655
128, 128, 127, 127, 127, 127, 127, 126, // 3656-3663
126, 126, 126, 124, 125, 125, 126, 127, // 3664-3671
126, 127, 127, 127, 128, 128, 128, 128, // 3672-3679
129, 129, 127, 127, 127, 127, 128, 127, // 3680-3687
127, 126, 129, 128, 127, 128, 127, 127, // 3688-3695
127, 127, 126, 125, 125, 126, 125, 126, // 3696-3703
126, 127, 127, 127, 127, 127, 127, 127, // 3704-3711
126, 126, 127, 126, 126, 126, 128, 128, // 3712-3719
129, 129, 129, 129, 130, 128, 128, 128, // 3720-3727
128, 127, 127, 125, 125, 125, 127, 127, // 3728-3735
126, 126, 126, 127, 126, 125, 125, 127, // 3736-3743
126, 128, 125, 127, 125, 129, 126, 130, // 3744-3751
127, 131, 127, 132, 126, 138, 165, 163, // 3752-3759
132,  98,  82,  78,  92,  33,  90, 146, // 3760-3767
197, 157, 127, 165, 222,  11, 195, 110, // 3768-3775
 21,  77,  90, 140,  75, 108, 220, 183, // 3776-3783
140, 104,  82,  58, 114,  61,  10, 247, // 3784-3791
  7,  19,  61,  56,  44, 131, 174, 201, // 3792-3799
196, 202, 170, 222, 201, 129, 165, 121, // 3800-3807
 75,  59,  67,  21,  25, 121, 213, 255, // 3808-3815
 28,  14, 227,   5, 227, 197, 170, 156, // 3816-3823
133, 133,  61,  63, 122, 117, 240, 219, // 3824-3831
 79,  19,  34, 224, 187, 188, 216, 248, // 3832-3839
 43,  64,  26, 114, 229,  43,  56,  69, // 3840-3847
242,  10,  19, 212, 193, 157, 181, 203, // 3848-3855
121,  26,  59,  87, 102,  97, 104,  82, // 3856-3863
125, 132,  80,  46,  39,  52,  61,  82, // 3864-3871
 37,  81, 143, 171, 181, 182, 180, 249, // 3872-3879
230, 128,  58,  45,  26, 237,  69,  88, // 3880-3887
125, 219,   3, 206, 242,  14,   6,  45, // 3888-3895
234, 153, 108,  77,  57,  51,  29, 119, // 3896-3903
121,  64,  36,  15,  22,   9,  77,  89, // 3904-3911
 54,  48,  74,  41,  77, 159, 148, 225, // 3912-3919
 30, 244, 246,  33,  10,  31,  16, 240, // 3920-3927
190,  94,  53,  14,  25, 226, 255,  67, // 3928-3935
105, 118, 132, 142, 127, 177, 127,  88, // 3936-3943
 63,  70,  63,  91,  65,  65, 125, 194, // 3944-3951
252, 191, 169, 125, 183, 107,  39,  70, // 3952-3959
110, 130, 166, 154,  70, 175, 242,  23, // 3960-3967
  4, 253, 201, 214, 183, 112,  41,  53, // 3968-3975
140,  47, 248, 164, 196, 252,  44,  68, // 3976-3983
104, 110, 151, 201, 106, 109, 147, 174, // 3984-3991
193, 205, 115, 149, 234,  18,  23, 253, // 3992-3999
 29, 235, 209, 129,  49,   6, 251, 253, // 4000-4007
 18,  19, 251,  83, 133, 138, 150, 159, // 4008-4015
144, 180, 171, 108,  84,  71,  83,  78, // 4016-4023
133, 111, 110, 136, 146, 157, 109, 108, // 4024-4031
178, 234, 183, 172, 124,  99, 142, 179, // 4032-4039
148, 153, 200, 204, 198, 168, 156, 113, // 4040-4047
208, 195,  52, 223, 189, 188, 217, 218, // 4048-4055
225,  68, 115, 167, 170, 147, 179,  17, // 4056-4063
  8, 227, 167, 124, 159, 182, 190, 141, // 4064-4071
188,   3, 234, 172, 143,  99, 114, 110, // 4072-4079
 54,  23,  21,  21,  57,  75,  22,  73, // 4080-4087
129, 162, 165, 173, 156, 164, 189, 141, // 4088-4095
 98, 129, 125,  82,  82,  49,  50,  62, // 4096-4103
130, 187, 218, 225, 232, 228, 177, 170, // 4104-4111
158, 157, 141, 145, 116,  79, 113, 139, // 4112-4119
130, 203, 203,  89,  77,  39, 239, 219, // 4120-4127
231, 254,  35,  63,  61,  98, 127, 206, // 4128-4135
249,  16,  10, 230, 235, 212, 183, 172, // 4136-4143
156, 158, 198, 112,  80, 101, 110, 108, // 4144-4151
104,  99,  97, 139,  93,  92,  52,  48, // 4152-4159
 61,  88,  75,  65, 125, 153, 171, 169, // 4160-4167
174, 155, 242, 193, 113,  67,  67,  44, // 4168-4175
 26,  80,  85, 158, 204, 242, 189, 202, // 4176-4183
212, 246, 247, 176, 136, 108,  92,  79, // 4184-4191
 79,  34, 140, 149,  97,  62,  47,  36, // 4192-4199
 48,  96,  66,  59,  56,  90,  71,  91, // 4200-4207
124, 151, 228, 254, 215, 223, 247, 232, // 4208-4215
 16, 217, 185, 172, 113,  70,  54,  36, // 4216-4223
  3,  59,  90, 116, 115, 128, 142, 138, // 4224-4231
137,  99,  85,  77,  82,  87, 102,  68, // 4232-4239
110, 146, 179, 223, 191, 152, 142, 167, // 4240-4247
 80,  50,  81, 114, 129, 158, 132, 101, // 4248-4255
169, 217, 236, 228, 210, 184, 203, 143, // 4256-4263
101,  59,  75, 130,  90,  12, 221,  10, // 4264-4271
 43,  70,  84, 106, 110, 159, 165, 100, // 4272-4279
 91, 138, 156, 188, 172, 108, 173, 224, // 4280-4287
246, 241, 224, 226, 237, 186, 106,  55, // 4288-4295
 34,  27,  32,  46,  27,  47, 113, 153, // 4296-4303
121, 137, 137, 148, 172, 134, 102,  90, // 4304-4311
 89,  95, 105, 108, 135, 148, 148, 146, // 4312-4319
147, 106, 115, 182, 182, 153, 146, 134, // 4320-4327
 97, 135, 149, 136, 171, 191, 191, 176, // 4328-4335
161, 139, 141, 171, 158,  71,  10, 239, // 4336-4343
240,   0, 242,  35,  93, 129, 150, 168, // 4344-4351
134, 168, 230, 200, 190, 145, 129, 152, // 4352-4359
177, 154, 157, 187, 233, 219, 167, 135, // 4360-4367
108, 129,  88,  58,  36,  51,  40,  89, // 4368-4375
 77,  36, 102, 133, 157, 154, 162, 145, // 4376-4383
176, 158, 127,  97, 125, 136, 110,  91, // 4384-4391
 60,  89,  88, 140, 167, 197, 188, 220, // 4392-4399
203, 133, 141, 143, 148, 139, 142, 101, // 4400-4407
108, 131, 144, 134, 181, 180, 117,  99, // 4408-4415
 39,   8, 253,  17,  27,  65,  63,  81, // 4416-4423
129, 133, 179, 213, 229, 228, 217, 191, // 4424-4431
179, 164, 162, 150, 153, 171, 120, 117, // 4432-4439
118, 118, 109, 110,  96, 118, 127,  80, // 4440-4447
100,  68,  54,  74,  91,  74, 100, 138, // 4448-4455
155, 161, 162, 159, 159, 212, 169, 117, // 4456-4463
 83,  87,  61,  60,  76, 106, 168, 189, // 4464-4471
211, 179, 166, 185, 222, 193, 154, 127, // 4472-4479
114,  98, 100,  79,  66, 151, 158, 115, // 4480-4487
 80,  69,  54,  86,  89,  66,  69,  75, // 4488-4495
 94,  97,  89, 107, 161, 210, 225, 188, // 4496-4503
205, 210, 225, 233, 179, 157, 162, 126, // 4504-4511
 90,  79,  44,  52,  89, 104, 116, 120, // 4512-4519
118, 151, 138, 102,  91,  85,  91,  92, // 4520-4527
107,  95,  92, 132, 154, 164, 197, 184, // 4528-4535
148, 158, 140,  77,  63,  94, 115, 139, // 4536-4543
139, 128, 130, 157, 194, 200, 201, 180, // 4544-4551
187, 177, 125,  99,  78,  91, 127, 107, // 4552-4559
 32,  29,  53,  72,  81,  96, 101, 125, // 4560-4567
151, 135, 104,  88, 131, 144, 179, 143, // 4568-4575
126, 181, 212, 218, 216, 197, 195, 228, // 4576-4583
159, 105,  68,  60,  49,  63,  53,  51, // 4584-4591
 83, 122, 156, 114, 125, 122, 154, 148, // 4592-4599
121, 105, 102, 100, 110, 113,  98, 153, // 4600-4607
161, 153, 144, 143, 101, 128, 164, 149, // 4608-4615
140, 135, 137, 107, 130, 126, 144, 172, // 4616-4623
181, 176, 167, 148, 138, 148, 139, 135, // 4624-4631
 87,  45,  21,  31,  22,  25,  74, 106, // 4632-4639
132, 140, 157, 132, 162, 182, 167, 168, // 4640-4647
139, 130, 158, 166, 146, 173, 179, 204, // 4648-4655
202, 163, 127, 124, 120,  80,  66,  55, // 4656-4663
 68,  62, 103,  84,  67, 111, 133, 146, // 4664-4671
147, 146, 148, 168, 132, 120, 103, 121, // 4672-4679
138, 130,  94,  92, 114, 106, 138, 157, // 4680-4687
174, 171, 200, 171, 121, 124, 136, 139, // 4688-4695
145, 133, 112, 133, 141, 141, 135, 160, // 4696-4703
155, 134,  96,  49,  32,  32,  41,  57, // 4704-4711
 78,  73, 107, 144, 138, 155, 186, 192, // 4712-4719
209, 188, 162, 161, 157, 155, 149, 148, // 4720-4727
145, 142, 137, 131, 120, 117, 105, 104, // 4728-4735
123, 107,  80, 104,  89,  64,  91,  90, // 4736-4743
 93, 125, 146, 152, 153, 150, 146, 159, // 4744-4751
167, 149, 115,  98,  98,  85,  73,  84, // 4752-4759
126, 165, 176, 182, 170, 144, 174, 188, // 4760-4767
159, 140, 128, 122, 114, 113,  82, 102, // 4768-4775
150, 158, 122,  95,  76,  78,  97,  77, // 4776-4783
 70,  76,  91, 101, 119,  90, 114, 164, // 4784-4791
196, 198, 171, 182, 186, 207, 184, 156, // 4792-4799
136, 152, 132, 110,  88,  66,  88, 103, // 4800-4807
112, 116, 120, 113, 161, 129,  92,  93, // 4808-4815
 97, 105, 110, 117,  99, 119, 139, 155, // 4816-4823
150, 173, 166, 148, 149, 119,  78,  74, // 4824-4831
102, 115, 140, 125, 139, 147, 152, 172, // 4832-4839
179, 176, 166, 179, 149, 120, 100,  92, // 4840-4847
103, 128, 110,  67,  74,  81,  88,  91, // 4848-4855
101, 102, 136, 136, 122, 109,  96, 124, // 4856-4863
145, 164, 133, 141, 174, 193, 188, 185, // 4864-4871
170, 177, 196, 142, 104,  81,  78,  73, // 4872-4879
 84,  65,  86, 109, 134, 156, 120, 116, // 4880-4887
127, 150, 130, 116, 107, 111, 108, 119, // 4888-4895
111, 109, 156, 164, 148, 139, 130, 101, // 4896-4903
132, 137, 130, 130, 131, 135, 122, 118, // 4904-4911
123, 151, 169, 172, 163, 156, 138, 140, // 4912-4919
137, 127, 123, 104,  73,  61,  60,  44, // 4920-4927
 67,  96, 118, 132, 139, 143, 140, 146, // 4928-4935
149, 146, 151, 134, 131, 154, 145, 144, // 4936-4943
166, 172, 178, 185, 151, 129, 130, 107, // 4944-4951
 84,  76,  76,  86,  90, 107, 104,  95, // 4952-4959
120, 136, 143, 144, 138, 152, 149, 122, // 4960-4967
113, 111, 116, 140, 133,  98, 115, 118, // 4968-4975
114, 132, 146, 151, 166, 173, 150, 116, // 4976-4983
115, 131, 136, 145, 123, 127, 141, 145, // 4984-4991
136, 140, 147, 149, 144,  97,  69,  53, // 4992-4999
 59,  63,  82,  83,  95, 122, 147, 141, // 5000-5007
143, 164, 169, 192, 158, 145, 144, 146, // 5008-5015
140, 148, 138, 135, 155, 142, 137, 121, // 5016-5023
117, 104, 118, 117, 104,  89, 111, 103, // 5024-5031
 81, 101,  93, 115, 135, 148, 147, 151, // 5032-5039
138, 145, 153, 141, 142, 118, 106, 103, // 5040-5047
 94,  78, 102, 134, 160, 166, 168, 161, // 5048-5055
138, 162, 156, 144, 131, 126, 120, 121, // 5056-5063
110,  94, 126, 146, 154, 130, 108,  89, // 5064-5071
 98,  97,  84,  81,  87, 100, 110, 124, // 5072-5079
 96, 124, 156, 181, 178, 162, 163, 177, // 5080-5087
184, 157, 144, 127, 141, 134, 121,  93, // 5088-5095
 91, 103, 115, 119, 121, 120, 121, 158, // 5096-5103
119,  90,  93, 102, 108, 120, 113, 111, // 5104-5111
133, 140, 152, 147, 157, 158, 155, 134, // 5112-5119
112,  82,  85, 105, 120, 131, 122, 145, // 5120-5127
150, 146, 156, 165, 157, 164, 159, 134, // 5128-5135
118, 104, 102, 115, 125, 109,  99,  98, // 5136-5143
103, 101, 104, 103, 114, 132, 120, 117, // 5144-5151
114, 104, 119, 141, 142, 136, 149, 171, // 5152-5159
180, 175, 167, 160, 167, 164, 136, 108, // 5160-5167
 96,  86,  89,  86,  79, 105, 118, 136, // 5168-5175
150, 122, 108, 133, 135, 121, 116, 112, // 5176-5183
114, 119, 120, 111, 126, 152, 165, 148, // 5184-5191
142, 123, 113, 129, 125, 123, 124, 128, // 5192-5199
135, 131, 110, 131, 152, 164, 163, 159, // 5200-5207
146, 139, 141, 124, 121, 111, 109,  89, // 5208-5215
 87,  71,  67,  89, 107, 121, 129, 133, // 5216-5223
135, 146, 130, 132, 135, 142, 131, 139, // 5224-5231
149, 141, 152, 161, 166, 162, 172, 146, // 5232-5239
137, 125, 101,  87,  83,  85,  96, 102, // 5240-5247
107, 123, 111, 122, 133, 140, 137, 141, // 5248-5255
147, 131, 119, 111, 114, 115, 139, 130, // 5256-5263
117, 130, 123, 118, 132, 140, 143, 160, // 5264-5271
149, 140, 118, 114, 126, 136, 137, 128, // 5272-5279
141, 141, 143, 132, 138, 136, 142, 133, // 5280-5287
 98,  82,  71,  74,  80,  94,  92, 115, // 5288-5295
131, 148, 144, 141, 149, 162, 170, 141, // 5296-5303
141, 141, 141, 137, 144, 129, 136, 156, // 5304-5311
147, 137, 125, 114, 108, 119, 108, 103, // 5312-5319
 96, 117, 111,  97, 100, 106, 127, 139, // 5320-5327
145, 143, 142, 132, 144, 138, 126, 132, // 5328-5335
125, 114, 115,  98,  90, 119, 139, 152, // 5336-5343
154, 156, 150, 142, 144, 138, 132, 129, // 5344-5351
127, 125, 123, 111, 111, 134, 142, 141, // 5352-5359
133, 113, 105, 107,  94,  88,  90, 100, // 5360-5367
110, 120, 122, 115, 132, 153, 167, 161, // 5368-5375
151, 156, 169, 158, 141, 133, 126, 134, // 5376-5383
139, 121, 104, 109, 114, 119, 117, 120, // 5384-5391
116, 129, 143, 115,  92,  99, 109, 117, // 5392-5399
125, 116, 125, 136, 143, 143, 142, 139, // 5400-5407
155, 148, 128, 111,  89,  99, 112, 127, // 5408-5415
125, 130, 146, 153, 142, 146, 149, 148, // 5416-5423
156, 143, 127, 114, 112, 107, 126, 117, // 5424-5431
115, 118, 114, 112, 106, 107, 104, 121, // 5432-5439
125, 119, 114, 121, 113, 123, 137, 137, // 5440-5447
141, 149, 166, 163, 161, 150, 155, 151, // 5448-5455
144, 132, 112, 105,  98, 101,  92,  99, // 5456-5463
115, 125, 134, 144, 122, 113, 131, 124, // 5464-5471
120, 116, 119, 118, 126, 118, 120, 132, // 5472-5479
147, 158, 143, 138, 120, 119, 120, 121, // 5480-5487
119, 126, 129, 136, 132, 115, 135, 148, // 5488-5495
157, 152, 148, 134, 138, 130, 119, 120, // 5496-5503
112, 116, 105, 100,  83,  91, 103, 116, // 5504-5511
121, 129, 128, 136, 144, 125, 126, 132, // 5512-5519
140, 131, 142, 140, 141, 151, 156, 155, // 5520-5527
149, 154, 141, 135, 118, 102,  93,  96, // 5528-5535
 97, 108, 107, 116, 132, 121, 123, 129, // 5536-5543
133, 132, 141, 137, 125, 119, 117, 120, // 5544-5551
122, 135, 131, 127, 133, 124, 117, 128, // 5552-5559
131, 141, 149, 138, 133, 122, 117, 127, // 5560-5567
136, 132, 133, 141, 141, 137, 130, 132, // 5568-5575
136, 137, 128, 103,  91,  88,  88,  96, // 5576-5583
 98, 103, 122, 134, 143, 141, 135, 139, // 5584-5591
157, 153, 132, 133, 137, 138, 139, 137, // 5592-5599
128, 137, 152, 146, 131, 125, 113, 118, // 5600-5607
118, 109, 103, 107, 121, 121, 107,  99, // 5608-5615
114, 130, 140, 138, 139, 134, 136, 139, // 5616-5623
131, 121, 128, 130, 122, 122, 104, 107, // 5624-5631
126, 139, 143, 145, 142, 143, 142, 134, // 5632-5639
130, 128, 130, 128, 130, 124, 119, 121, // 5640-5647
132, 133, 129, 127, 118, 117, 115, 111, // 5648-5655
107, 111, 116, 121, 124, 125, 126, 131, // 5656-5663
138, 139, 138, 132, 135, 138, 135, 128, // 5664-5671
128, 128, 129, 133, 127, 123, 124, 127, // 5672-5679
127, 125, 124, 124, 129, 131, 126, 122, // 5680-5687
123, 125, 129, 127, 125, 126, 130, 129, // 5688-5695
128, 127, 124, 128, 129, 125, 121, 120, // 5696-5703
121, 124, 125, 127, 127, 130, 134, 131, // 5704-5711
129, 129, 129, 130, 130, 126, 126, 126, // 5712-5719
127, 131, 129, 128, 130, 130, 128, 127, // 5720-5727
123, 122, 124, 127, 126, 125, 126, 128, // 5728-5735
129, 128, 126, 125, 126, 126, 126, 124, // 5736-5743
122, 125, 128, 126, 126, 127, 128, 129, // 5744-5751
130, 129, 127, 129, 131, 130, 130, 129, // 5752-5759
128, 128, 129, 126, 126, 126, 129, 129, // 5760-5767
127, 126, 127, 126, 127, 127, 123, 124, // 5768-5775
124, 124, 123, 123, 124, 127, 129, 131, // 5776-5783
129, 126, 128, 127, 127, 125, 125, 126, // 5784-5791
128, 127, 128, 129, 130, 134, 134, 132, // 5792-5799
128, 127, 127, 127, 125, 125, 124, 127, // 5800-5807
127, 125, 124, 125, 126, 127, 126, 124, // 5808-5815
124, 124, 127, 126, 123, 124, 127, 129, // 5816-5823
128, 127, 128, 130, 132, 133, 130, 130, // 5824-5831
131, 130, 128, 126, 124, 123, 126, 127, // 5832-5839
126, 125, 129, 130, 129, 128, 127, 126, // 5840-5847
126, 125, 122, 120, 121, 123, 126, 127, // 5848-5855
128, 128, 130, 131, 129, 127, 127, 128, // 5856-5863
128, 126, 124, 124, 126, 128, 129, 129, // 5864-5871
129, 130, 130, 130, 129, 127, 129, 129, // 5872-5879
128, 125, 122, 122, 125, 125, 125, 125, // 5880-5887
127, 128, 128, 128, 127, 126, 128, 128, // 5888-5895
125, 123, 122, 125, 127, 127, 127, 129, // 5896-5903
131, 134, 132, 130, 130, 129, 127, 126, // 5904-5911
124, 123, 124, 127, 127, 125, 126, 128, // 5912-5919
130, 129, 126, 124, 125, 125, 124, 124, // 5920-5927
124, 125, 126, 127, 127, 126, 128, 130, // 5928-5935
131, 130, 128, 128, 129, 129, 127, 126, // 5936-5943
127, 129, 127, 125, 127, 127, 129, 131, // 5944-5951
130, 127, 127, 127, 126, 124, 122, 122, // 5952-5959
122, 125, 124, 123, 126, 129, 129, 130, // 5960-5967
129, 127, 128, 126, 127, 125, 124, 126, // 5968-5975
130, 131, 129, 128, 131, 132, 131, 129, // 5976-5983
126, 128, 128, 126, 125, 124, 124, 126, // 5984-5991
126, 125, 125, 125, 127, 127, 126, 124, // 5992-5999
126, 128, 128, 125, 124, 125, 125, 128, // 6000-6007
127, 128, 129, 131, 131, 132, 130, 129, // 6008-6015
130, 131, 129, 125, 124, 125, 126, 126, // 6016-6023
127, 128, 128, 128, 128, 127, 123, 125, // 6024-6031
125, 123, 123, 121, 122, 126, 128, 128, // 6032-6039
127, 129, 130, 129, 128, 128, 127, 128, // 6040-6047
129, 128, 127, 127, 129, 131, 129, 127, // 6048-6055
128, 128, 130, 128, 126, 126, 127, 126, // 6056-6063
125, 123, 123, 124, 125, 125, 124, 125, // 6064-6071
127, 129, 129, 127, 126, 127, 127, 125, // 6072-6079
124, 125, 126, 129, 129, 130, 130, 131, // 6080-6087
132, 132, 131, 128, 127, 127, 127, 125, // 6088-6095
124, 126, 128, 127, 126, 126, 125, 126, // 6096-6103
126, 125, 123, 124, 123, 123, 126, 125, // 6104-6111
126, 128, 129, 129, 128, 129, 131, 131, // 6112-6119
131, 129, 129, 128, 129, 128, 128, 127, // 6120-6127
127, 128, 128, 127, 127, 127, 129, 128, // 6128-6135
125, 125, 125, 124, 124, 123, 122, 123, // 6136-6143
125, 127, 127, 128, 128, 129, 130, 128, // 6144-6151
126, 126, 127, 127, 127, 126, 128, 130, // 6152-6159
132, 131, 131, 131, 130, 129, 128, 126, // 6160-6167
124, 127, 126, 125, 124, 123, 125, 126, // 6168-6175
126, 126, 125, 125, 126, 125, 125, 125, // 6176-6183
126, 126, 126, 126, 125, 126, 129, 131, // 6184-6191
130, 131, 132, 130, 131, 129, 128, 129, // 6192-6199
128, 126, 126, 126, 125, 127, 128, 129, // 6200-6207
128, 127, 126, 127, 124, 122, 122, 124, // 6208-6215
123, 123, 124, 125, 127, 128, 129, 130, // 6216-6223
129, 129, 130, 129, 128, 127, 129, 129, // 6224-6231
129, 129, 128, 129, 129, 128, 128, 129, // 6232-6239
127, 126, 127, 125, 124, 122, 123, 124, // 6240-6247
124, 123, 125, 125, 127, 127, 127, 129, // 6248-6255
129, 129, 128, 127, 125, 126, 125, 128, // 6256-6263
129, 127, 129, 130, 130, 130, 131, 130, // 6264-6271
131, 128, 128, 126, 125, 124, 125, 127, // 6272-6279
127, 126, 127, 128, 127, 126, 125, 126, // 6280-6287
126, 125, 123, 123, 124, 124, 125, 127, // 6288-6295
128, 129, 131, 130, 131, 130, 129, 132, // 6296-6303
132, 129, 128, 127, 126, 126, 126, 124, // 6304-6311
127, 127, 127, 128, 127, 125, 125, 126, // 6312-6319
125, 123, 124, 124, 124, 126, 126, 127, // 6320-6327
130, 130, 130, 131, 129, 128, 128, 127, // 6328-6335
127, 126, 125, 126, 127, 127, 128, 129, // 6336-6343
130, 131, 130, 130, 129, 127, 127, 126, // 6344-6351
126, 125, 125, 124, 124, 125, 125, 126, // 6352-6359
126, 126, 126, 126, 125, 125, 124, 125, // 6360-6367
127, 127, 127, 128, 130, 130, 131, 132, // 6368-6375
132, 133, 131, 131, 129, 127, 124, 124, // 6376-6383
124, 123, 124, 124, 125, 125, 125, 125, // 6384-6391
127, 128, 127, 126, 126, 124, 124, 125, // 6392-6399
126, 127, 128, 129, 130, 131, 130, 129, // 6400-6407
129, 130, 128, 127, 126, 126, 126, 125, // 6408-6415
127, 129, 128, 128, 130, 129, 128, 128, // 6416-6423
128, 128, 126, 124, 124, 124, 124, 123, // 6424-6431
123, 124, 125, 126, 126, 126, 127, 128, // 6432-6439
129, 129, 128, 127, 128, 129, 128, 128, // 6440-6447
129, 131, 132, 133, 131, 130, 130, 128, // 6448-6455
127, 125, 122, 121, 122, 122, 121, 122, // 6456-6463
124, 127, 128, 126, 126, 128, 127, 127, // 6464-6471
127, 126, 127, 128, 129, 128, 128, 128, // 6472-6479
129, 130, 130, 128, 128, 128, 128, 127, // 6480-6487
127, 126, 128, 127, 127, 127, 127, 127, // 6488-6495
128, 130, 128, 128, 127, 127, 125, 125, // 6496-6503
123, 123, 123, 123, 123, 124, 125, 127, // 6504-6511
128, 129, 129, 129, 129, 130, 129, 128, // 6512-6519
127, 129, 130, 131, 131, 130, 129, 130, // 6520-6527
128, 126, 127, 125, 124, 124, 123, 122, // 6528-6535
123, 125, 126, 126, 126, 126, 126, 127, // 6536-6543
126, 127, 129, 128, 128, 129, 127, 128, // 6544-6551
127, 127, 127, 128, 126, 127, 127, 127, // 6552-6559
128, 128, 129, 129, 128, 128, 127, 127, // 6560-6567
127, 127, 129, 128, 128, 128, 127, 125, // 6568-6575
126, 125, 124, 124, 124, 123, 125, 125, // 6576-6583
126, 128, 129, 131, 130, 129, 129, 130, // 6584-6591
129, 128, 129, 130, 130, 130, 128, 127, // 6592-6599
127, 126, 126, 127, 125, 124, 124, 124, // 6600-6607
125, 125, 126, 127, 126, 126, 125, 126, // 6608-6615
127, 127, 129, 130, 129, 128, 130, 129, // 6616-6623
128, 127, 126, 127, 127, 126, 125, 125, // 6624-6631
127, 128, 129, 128, 128, 127, 128, 127, // 6632-6639
126, 126, 127, 128, 128, 126, 126, 127, // 6640-6647
126, 127, 126, 124, 126, 126, 126, 126, // 6648-6655
125, 126, 128, 128, 129, 127, 128, 128, // 6656-6663
128, 129, 129, 130, 131, 130, 129, 128, // 6664-6671
126, 126, 126, 126, 125, 124, 124, 125, // 6672-6679
125, 125, 126, 127, 128, 127, 126, 125, // 6680-6687
125, 127, 128, 128, 129, 128, 128, 130, // 6688-6695
128, 128, 129, 129, 128, 127, 125, 125, // 6696-6703
126, 127, 128, 126, 127, 127, 127, 127, // 6704-6711
126, 127, 127, 128, 128, 128, 127, 127, // 6712-6719
126, 125, 126, 125, 125, 126, 126, 126, // 6720-6727
126, 126, 128, 129, 130, 128, 127, 128, // 6728-6735
127, 127, 128, 129, 129, 130, 129, 128, // 6736-6743
128, 127, 128, 127, 125, 124, 124, 124, // 6744-6751
124, 124, 125, 127, 128, 128, 126, 127, // 6752-6759
126, 127, 129, 129, 128, 129, 129, 128, // 6760-6767
129, 128, 128, 129, 128, 126, 127, 126, // 6768-6775
126, 126, 127, 127, 127, 127, 126, 126, // 6776-6783
125, 126, 128, 128, 128, 129, 128, 128, // 6784-6791
128, 127, 126, 126, 127, 125, 126, 125, // 6792-6799
125, 126, 128, 128, 128, 129, 128, 128, // 6800-6807
127, 127, 127, 129, 129, 130, 129, 128, // 6808-6815
127, 128, 126, 127, 127, 126, 126, 125, // 6816-6823
124, 123, 125, 127, 127, 126, 126, 126, // 6824-6831
127, 127, 127, 128, 130, 130, 130, 129, // 6832-6839
128, 128, 128, 127, 127, 126, 126, 127, // 6840-6847
127, 126, 127, 127, 128, 128, 127, 126, // 6848-6855
125, 126, 126, 127, 127, 128, 129, 129, // 6856-6863
128, 127, 127, 126, 127, 128, 125, 125, // 6864-6871
126, 125, 126, 126, 127, 127, 130, 129, // 6872-6879
128, 127, 128, 129, 130, 129, 128, 128, // 6880-6887
127, 127, 126, 125, 125, 126, 127, 126, // 6888-6895
125, 125, 125, 127, 128, 125, 125, 127, // 6896-6903
126, 127, 126, 127, 129, 131, 130, 129, // 6904-6911
128, 128, 129, 128, 126, 126, 126, 125, // 6912-6919
126, 125, 125, 127, 129, 128, 127, 128, // 6920-6927
127, 126, 126, 126, 126, 127, 127, 127, // 6928-6935
127, 127, 127, 127, 128, 128, 128, 127, // 6936-6943
127, 127, 127, 126, 128, 128, 127, 128, // 6944-6951
127, 127, 127, 127, 129, 129, 129, 127, // 6952-6959
128, 128, 126, 126, 125, 125, 126, 125, // 6960-6967
125, 125, 127, 127, 128, 128, 126, 127, // 6968-6975
128, 127, 125, 126, 127, 128, 129, 128, // 6976-6983
128, 129, 129, 128, 128, 127, 128, 128, // 6984-6991
126, 125, 125, 125, 127, 127, 126, 126, // 6992-6999
127, 128, 126, 127, 127, 127, 128, 127, // 7000-7007
126, 126, 126, 126, 127, 126, 126, 127, // 7008-7015
127, 127, 128, 128, 128, 129, 128, 127, // 7016-7023
127, 127, 126, 126, 126, 127, 128, 129, // 7024-7031
129, 130, 129, 128, 126, 126, 126, 124, // 7032-7039
124, 125, 126, 126, 126, 127, 128, 128, // 7040-7047
128, 129, 128, 126, 127, 127, 126, 127, // 7048-7055
127, 127, 128, 128, 126, 127, 129, 128, // 7056-7063
128, 127, 127, 128, 128, 127, 126, 125, // 7064-7071
125, 127, 126, 124, 126, 128, 128, 129, // 7072-7079
128, 128, 128, 130, 127, 125, 126, 125, // 7080-7087
126, 127, 127, 127, 129, 129, 129, 128, // 7088-7095
127, 127, 128, 126, 125, 124, 125, 126, // 7096-7103
126, 126, 127, 129, 128, 128, 127, 127, // 7104-7111
127, 128, 127, 125, 125, 125, 126, 126, // 7112-7119
127, 126, 128, 129, 128, 129, 128, 130, // 7120-7127
129, 129, 127, 127, 126, 126, 126, 126, // 7128-7135
126, 127, 128, 128, 128, 129, 128, 128, // 7136-7143
126, 126, 124, 124, 124, 125, 125, 126, // 7144-7151
127, 128, 129, 130, 130, 129, 127, 128, // 7152-7159
127, 126, 126, 125, 126, 127, 128, 128, // 7160-7167
128, 129, 130, 129, 128, 127, 127, 128, // 7168-7175
127, 126, 125, 126, 126, 125, 125, 126, // 7176-7183
127, 127, 128, 128, 127, 126, 127, 126, // 7184-7191
126, 125, 126, 127, 127, 126, 126, 129, // 7192-7199
130, 130, 129, 129, 129, 129, 128, 126, // 7200-7207
126, 126, 126, 127, 127, 126, 128, 128, // 7208-7215
128, 127, 127, 126, 126, 125, 124, 125, // 7216-7223
125, 126, 125, 126, 127, 128, 128, 129, // 7224-7231
129, 128, 128, 129, 128, 127, 127, 127, // 7232-7239
127, 126, 127, 127, 127, 127, 128, 127, // 7240-7247
128, 129, 128, 127, 127, 126, 125, 125, // 7248-7255
125, 126, 125, 127, 127, 127, 128, 128, // 7256-7263
128, 127, 127, 126, 126, 125, 125, 125, // 7264-7271
127, 127, 129, 128, 129, 130, 130, 129, // 7272-7279
129, 128, 128, 127, 127, 126, 126, 128, // 7280-7287
127, 126, 126, 126, 127, 126, 125, 126, // 7288-7295
126, 127, 127, 126, 126, 128, 127, 126, // 7296-7303
126, 127, 128, 128, 129, 128, 128, 129, // 7304-7311
129, 128, 127, 127, 127, 126, 126, 126, // 7312-7319
126, 128, 129, 128, 128, 129, 128, 127, // 7320-7327
126, 126, 126, 125, 127, 125, 126, 127, // 7328-7335
127, 128, 128, 128, 128, 127, 126, 126, // 7336-7343
126, 127, 127, 128, 127, 128, 128, 128, // 7344-7351
127, 128, 129, 127, 129, 129, 127, 126, // 7352-7359
127, 126, 125, 125, 125, 125, 125, 125, // 7360-7367
126, 127, 128, 128, 128, 128, 128, 126, // 7368-7375
126, 126, 127, 126, 127, 128, 129, 129, // 7376-7383
130, 130, 129, 130, 128, 127, 127, 125, // 7384-7391
125, 126, 126, 126, 126, 127, 127, 126, // 7392-7399
127, 126, 127, 127, 127, 126, 126, 125, // 7400-7407
126, 126, 126, 126, 127, 127, 127, 127, // 7408-7415
127, 129, 130, 129, 128, 128, 128, 127, // 7416-7423
126, 126, 127, 128, 128, 128, 128, 128, // 7424-7431
128, 128, 127, 125, 125, 124, 124, 124, // 7432-7439
123, 124, 126, 127, 127, 127, 128, 129, // 7440-7447
128, 128, 128, 128, 128, 128, 127, 127, // 7448-7455
127, 128, 129, 128, 128, 127, 128, 127, // 7456-7463
127, 125, 126, 127, 126, 126, 126, 125, // 7464-7471
126, 126, 126, 127, 127, 127, 128, 128, // 7472-7479
127, 126, 127, 127, 127, 125, 125, 126, // 7480-7487
127, 128, 128, 129, 129, 130, 129, 129, // 7488-7495
127, 128, 127, 128, 127, 126, 126, 128, // 7496-7503
125, 129, 127, 136, 168, 173, 147, 104, // 7504-7511
 84,  73,  82,  81, 107,  84,  57, 129, // 7512-7519
182, 200, 220, 185, 120, 169, 190, 208, // 7520-7527
 11, 191, 137,  70, 240,  22,  63,  90, // 7528-7535
 99, 117,  46,  90, 208, 181, 135, 100, // 7536-7543
 75,  53,  46,  24,  87,  88,  27,  11, // 7544-7551
  7,  30,  46,  82,  97, 135, 110, 106, // 7552-7559
180, 218, 241, 236, 235, 213, 209, 178, // 7560-7567
196, 225, 161, 105, 142, 143,  86,  75, // 7568-7575
 63,  85,  82,  61,  63, 119, 210,   7, // 7576-7583
 34,  39,  21,  20, 197, 207, 217, 165, // 7584-7591
142, 112, 104,  85,  83,  61,  72, 254, // 7592-7599
  4,  56, 100,  85, 152, 235, 115,  47, // 7600-7607
226,   2,  22, 226, 215, 229,   7,  46, // 7608-7615
 90, 123, 165, 179, 145, 165,   1,  78, // 7616-7623
 93, 101,  75,  70,  18, 184, 249, 213, // 7624-7631
161, 124, 106,  90,  79, 135, 106,  58, // 7632-7639
225, 234,  32,  56,  73,  78,  87,  83, // 7640-7647
 93,  77, 135, 135,  88,  70,  49,  65, // 7648-7655
 74,  95,  99, 129, 101,  89, 154, 190, // 7656-7663
209, 209, 204, 198, 183, 206, 242, 220, // 7664-7671
131,  71,  51,  41,  66,  34,  37, 109, // 7672-7679
151, 129, 194, 247,  30, 254, 193, 225, // 7680-7687
234, 231, 196, 231, 181, 105,  55,  25, // 7688-7695
  3,   0, 248,   5,   6,  13, 124, 109, // 7696-7703
 71,  48,  38,  42,  46,  67,  72, 123, // 7704-7711
169, 131, 122, 119, 140, 152, 122, 150, // 7712-7719
227, 239, 215,  11,  51,  48, 222, 231, // 7720-7727
241, 234, 210, 188, 222, 150, 139,  98, // 7728-7735
 24, 244, 226, 228, 232,   2, 216, 255, // 7736-7743
 68, 106, 128, 143, 147, 151, 170, 131, // 7744-7751
176, 180, 125,  99,  85,  86,  88, 101, // 7752-7759
105, 127, 108,  85, 155, 178, 230,  16, // 7760-7767
222, 178, 155, 136, 132, 182,  93,  42, // 7768-7775
 73, 108, 127, 153, 162, 183, 174,  75, // 7776-7783
140, 210, 242, 239, 224, 198, 172, 143, // 7784-7791
112, 131, 102,  27,   3, 230,   0, 111, // 7792-7799
 65, 249, 236, 193, 199,  22,  71, 113, // 7800-7807
137, 164, 176, 198, 195, 230,  16, 167, // 7808-7815
140, 173, 193, 207, 214, 213, 212, 138, // 7816-7823
107, 179, 222, 241, 226, 218, 178, 197, // 7824-7831
186, 116, 117,  54, 250, 219, 216, 222, // 7832-7839
242,   7,  28,  57,  35,  62, 128, 181, // 7840-7847
171, 173, 182, 174, 175, 155, 185, 187, // 7848-7855
132, 109,  91,  95,  91, 109, 106, 140, // 7856-7863
167, 115, 138, 148, 166, 157, 174, 134, // 7864-7871
113, 142, 181, 238, 200, 166, 146, 137, // 7872-7879
 80, 101, 133, 153, 158, 112, 130, 160, // 7880-7887
164, 156, 139, 124, 102,  93,  66, 105, // 7888-7895
180,  98,   2, 207, 196, 204, 232,   0, // 7896-7903
 45,  46,  66, 145, 189, 228, 233,   2, // 7904-7911
212, 199, 229,  12,  49, 245, 209, 178, // 7912-7919
118, 110, 144, 148, 162, 143, 108, 126, // 7920-7927
174, 210, 160, 123,  88,  72,  54,  45, // 7928-7935
 85,  64,  27,  19,  19,  33,  49,  65, // 7936-7943
109, 105,  68,  97, 153, 179, 193, 192, // 7944-7951
190, 178, 177, 155, 179, 180, 131, 108, // 7952-7959
 94, 143, 124, 106,  89, 105,  84,  77, // 7960-7967
104, 108, 167, 199, 223, 222, 226, 207, // 7968-7975
211, 188, 143, 136, 127, 122, 114, 109, // 7976-7983
102,  96,  92,  44,  61,  94, 108, 113, // 7984-7991
109, 181, 163,  94,  41,  57,  48,   5, // 7992-7999
  2,  10,  39,  61,  96, 114, 154, 139, // 8000-8007
154, 188, 190, 250,  20,  34,  18,  10, // 8008-8015
239, 191, 199, 174, 147, 130, 116, 113, // 8016-8023
102, 105, 143, 104,  34,  47,  71,  82, // 8024-8031
 86,  87,  86,  88,  90,  91, 132, 120, // 8032-8039
 80, 105,  76,  67,  88, 102, 112, 129, // 8040-8047
104, 110, 156, 175, 189, 183, 182, 169, // 8048-8055
172, 147, 212, 213, 133,  93,  73,  68, // 8056-8063
 76,  75,  48, 103, 124, 126, 177, 216, // 8064-8071
228, 238, 194, 163, 189, 184, 183, 202, // 8072-8079
157, 110,  82,  64,  54,  49,  49,  51, // 8080-8087
 61,  21, 108, 156, 113,  89,  68,  66, // 8088-8095
 62,  75,  73, 122, 134, 112, 110, 117, // 8096-8103
128, 145, 152, 124, 175, 183, 188, 236, // 8104-8111
252,   8, 207, 190, 202, 202, 186, 184, // 8112-8119
196, 140, 103, 115,  88,  46,  30,  20, // 8120-8127
 27,  29,   4,  43,  87, 110, 125, 130, // 8128-8135
139, 130, 164, 141, 146, 145, 113, 104, // 8136-8143
 97, 103, 105, 117, 119, 137, 108, 114, // 8144-8151
151, 175, 176, 206, 213, 171, 151, 127, // 8152-8159
137, 152, 104,  54,  72, 103, 124, 142, // 8160-8167
154, 164, 162, 115, 123, 172, 199, 202, // 8168-8175
194, 178, 160, 140, 126, 142, 103,  65, // 8176-8183
 40,  35,  29,  84, 114,  68,  43, 249, // 8184-8191
 11,  56,  88, 110, 127, 142, 151, 163, // 8192-8199
163, 197, 205, 170, 123, 133, 164, 179, // 8200-8207
192, 187, 203, 144, 114, 172, 197, 209, // 8208-8215
199, 187, 168, 150, 160, 152, 133,  76, // 8216-8223
 34,  16,  11,  18,  28,  43,  58,  76, // 8224-8231
 52,  95, 120, 171, 175, 140, 153, 153, // 8232-8239
158, 146, 177, 160, 128, 113, 107, 104, // 8240-8247
108, 113, 121, 126, 125, 147, 158, 157, // 8248-8255
159, 150, 152, 138, 108, 118, 159, 191, // 8256-8263
161, 149, 134, 138, 123,  99, 119, 145, // 8264-8271
145, 119, 143, 157, 159, 150, 140, 124, // 8272-8279
111,  97,  92, 112, 122, 122,  70,  27, // 8280-8287
  9,  11,  24,  41,  66,  58,  87, 137, // 8288-8295
164, 187, 195, 201, 204, 174, 167, 222, // 8296-8303
234, 201, 177, 168, 132, 113, 137, 144, // 8304-8311
157, 139, 119, 148, 150, 178, 177, 138, // 8312-8319
108,  90,  73,  71,  95,  66,  50,  41, // 8320-8327
 53,  58,  79,  80, 117, 133,  72, 108, // 8328-8335
144, 166, 170, 172, 167, 162, 157, 148, // 8336-8343
168, 159, 122, 113, 101, 115, 142, 131, // 8344-8351
113, 116,  93,  92, 125, 113, 141, 166, // 8352-8359
184, 185, 191, 177, 188, 196, 125, 115, // 8360-8367
119, 123, 120, 120, 113, 114, 103,  73, // 8368-8375
 95, 110, 119, 118, 114, 133, 158, 124, // 8376-8383
 83,  89,  63,  39,  33,  42,  59,  79, // 8384-8391
102, 120, 141, 131, 145, 190, 184, 187, // 8392-8399
216, 226, 226, 214, 203, 187, 168, 150, // 8400-8407
141, 130, 127, 120, 123, 109, 127, 126, // 8408-8415
 81,  90,  92,  98,  92,  96,  91,  96, // 8416-8423
 90, 103, 126, 114,  89,  99, 118,  79, // 8424-8431
 93, 107, 120, 127, 108, 126, 155, 167, // 8432-8439
174, 170, 167, 158, 156, 142, 165, 184, // 8440-8447
140, 106,  90,  87,  89,  99,  75, 101, // 8448-8455
112, 125, 168, 189, 200, 193, 194, 151, // 8456-8463
148, 153, 165, 177, 141, 116,  97,  91, // 8464-8471
 82,  83,  78,  84,  80,  55, 100, 148, // 8472-8479
143, 110,  92,  82,  81,  83,  88, 122, // 8480-8487
121, 109, 110, 113, 125, 134, 152, 144, // 8488-8495
140, 147, 167, 208, 214, 224, 194, 168, // 8496-8503
175, 181, 166, 176, 172, 136, 109, 100, // 8504-8511
116,  90,  77,  63,  68,  56,  44,  76, // 8512-8519
100, 111, 118, 121, 126, 124, 130, 156, // 8520-8527
140, 117, 107, 105, 107, 112, 119, 125, // 8528-8535
130, 136, 116, 128, 150, 161, 164, 158, // 8536-8543
180, 171, 148, 131, 144, 138, 112,  77, // 8544-8551
 78, 105, 121, 141, 145, 159, 139, 137, // 8552-8559
140, 145, 171, 170, 169, 157, 150, 132, // 8560-8567
134, 139, 106,  82,  66,  65,  63,  88, // 8568-8575
114, 115,  83,  46,  63,  87, 102, 112, // 8576-8583
120, 128, 135, 143, 144, 174, 167, 154, // 8584-8591
138, 118, 143, 160, 175, 172, 184, 146, // 8592-8599
126, 162, 180, 184, 177, 168, 153, 142, // 8600-8607
125, 155, 143,  94,  66,  50,  48,  51, // 8608-8615
 61,  67,  79,  80,  72, 107, 127, 145, // 8616-8623
176, 146, 130, 139, 137, 139, 161, 144, // 8624-8631
124, 117, 115, 117, 120, 124, 126, 135, // 8632-8639
111, 142, 171, 161, 155, 146, 141, 136, // 8640-8647
112, 104, 145, 156, 143, 134, 134, 132, // 8648-8655
137, 127, 112, 136, 128, 122, 144, 152, // 8656-8663
150, 142, 135, 123, 115, 101, 106, 116, // 8664-8671
106, 110, 100,  74,  56,  56,  59,  71, // 8672-8679
 81,  74, 103, 134, 155, 164, 172, 174, // 8680-8687
176, 174, 148, 182, 186, 170, 157, 155, // 8688-8695
143, 121, 138, 146, 156, 136, 134, 150, // 8696-8703
154, 149, 160, 146, 116, 101,  83,  90, // 8704-8711
 96,  72,  63,  61,  70,  78,  92,  99, // 8712-8719
112, 141, 105, 110, 137, 149, 152, 154, // 8720-8727
152, 150, 147, 145, 163, 145, 126, 115, // 8728-8735
116, 113, 130, 145, 130, 127, 104, 110, // 8736-8743
134, 124, 126, 147, 157, 163, 165, 159, // 8744-8751
170, 171, 135, 104, 109, 117, 120, 125, // 8752-8759
121, 125, 110,  99, 117, 123, 126, 123, // 8760-8767
116, 121, 134, 129, 111, 105,  78,  60, // 8768-8775
 57,  65,  77,  95, 109, 124, 134, 125, // 8776-8783
146, 168, 183, 167, 172, 185, 187, 184, // 8784-8791
178, 186, 153, 140, 138, 134, 134, 132, // 8792-8799
130, 124, 121, 118, 114, 113, 111, 109, // 8800-8807
103, 100,  94,  98,  93, 107, 120, 102, // 8808-8815
 96,  90, 122, 111,  95, 107, 120, 123, // 8816-8823
112, 136, 152, 162, 162, 162, 154, 150, // 8824-8831
141, 140, 151, 146, 143, 122, 110, 106, // 8832-8839
106, 113,  99, 103, 109, 127, 158, 170, // 8840-8847
176, 169, 167, 155, 133, 130, 151, 153, // 8848-8855
132, 118, 107, 105, 103, 103,  98, 102, // 8856-8863
 94,  80, 112, 136, 145, 131, 110,  97, // 8864-8871
 93,  89,  96, 118, 110, 105, 106, 114, // 8872-8879
120, 133, 138, 151, 141, 127, 156, 181, // 8880-8887
191, 194, 186, 158, 158, 163, 157, 167, // 8888-8895
159, 131, 119, 103, 110, 116, 102,  90, // 8896-8903
 91,  76,  72,  93, 105, 114, 117, 121, // 8904-8911
120, 125, 116, 149, 150, 105, 103, 103, // 8912-8919
109, 113, 123, 126, 135, 134, 122, 135, // 8920-8927
148, 153, 155, 151, 149, 163, 150, 134, // 8928-8935
143, 127, 114,  91,  84, 105, 120, 134, // 8936-8943
139, 149, 135, 139, 154, 142, 147, 154, // 8944-8951
153, 148, 143, 130, 136, 135, 110,  96, // 8952-8959
 85,  87,  83,  99, 109, 120, 107,  82, // 8960-8967
 93, 101, 111, 115, 121, 121, 130, 132, // 8968-8975
142, 158, 148, 137, 137, 125, 123, 141, // 8976-8983
150, 156, 162, 144, 134, 156, 169, 172, // 8984-8991
165, 159, 149, 142, 125, 138, 141, 107, // 8992-8999
 87,  75,  73,  73,  78,  82,  96,  91, // 9000-9007
 95, 118, 132, 138, 159, 156, 124, 129, // 9008-9015
128, 136, 146, 133, 124, 120, 121, 121, // 9016-9023
123, 124, 128, 128, 117, 130, 157, 162, // 9024-9031
151, 145, 137, 136, 120, 109, 138, 140, // 9032-9039
132, 130, 128, 129, 129, 133, 118, 121, // 9040-9047
118, 124, 143, 148, 150, 145, 143, 130, // 9048-9055
126, 110, 119, 117, 106, 105, 100, 100, // 9056-9063
 86,  84,  82,  92,  92,  90, 113, 133, // 9064-9071
147, 155, 157, 157, 158, 157, 149, 152, // 9072-9079
150, 145, 141, 141, 141, 127, 134, 144, // 9080-9087
147, 131, 135, 145, 148, 143, 138, 146, // 9088-9095
130, 116, 100, 107, 103,  86,  80,  79, // 9096-9103
 85,  91,  99, 106, 116, 125, 126, 120, // 9104-9111
128, 142, 146, 147, 147, 148, 142, 147, // 9112-9119
152, 135, 123, 114, 114, 117, 118, 132, // 9120-9127
141, 131, 116, 124, 139, 134, 130, 139, // 9128-9135
146, 150, 149, 145, 157, 146, 132, 113, // 9136-9143
100, 112, 117, 122, 123, 128, 114, 116, // 9144-9151
127, 130, 128, 126, 120, 122, 130, 121, // 9152-9159
131, 121,  97,  84,  80,  85,  91, 100, // 9160-9167
110, 125, 129, 125, 145, 157, 168, 166, // 9168-9175
152, 158, 165, 161, 159, 169, 141, 132, // 9176-9183
130, 126, 125, 125, 125, 124, 125, 109, // 9184-9191
126, 133, 127, 123, 116, 113, 109, 107, // 9192-9199
101, 116, 118, 106, 105, 102, 116, 125, // 9200-9207
108, 106, 121, 120, 118, 136, 147, 154, // 9208-9215
155, 151, 146, 144, 136, 135, 145, 129, // 9216-9223
128, 128, 117, 114, 112, 118, 114, 109, // 9224-9231
108, 129, 148, 157, 160, 160, 154, 151, // 9232-9239
139, 120, 137, 134, 123, 117, 112, 110, // 9240-9247
112, 111, 110, 111, 102, 100, 119, 133, // 9248-9255
134, 136, 125, 114, 110, 102, 111, 120, // 9256-9263
111, 110, 113, 119, 124, 132, 137, 145, // 9264-9271
143, 124, 141, 160, 166, 168, 167, 152, // 9272-9279
149, 150, 146, 154, 141, 127, 116, 111, // 9280-9287
107, 116, 116, 107, 105,  92,  96, 109, // 9288-9295
115, 119, 121, 123, 121, 124, 120, 137, // 9296-9303
145, 114, 101, 106, 114, 119, 126, 130, // 9304-9311
137, 134, 129, 142, 147, 149, 144, 144, // 9312-9319
138, 142, 145, 136, 140, 124, 116, 106, // 9320-9327
100, 109, 120, 128, 135, 137, 130, 136, // 9328-9335
147, 145, 132, 136, 139, 138, 136, 131, // 9336-9343
137, 133, 118, 108, 100, 101, 100, 104, // 9344-9351
116, 117, 115, 108, 113, 115, 118, 119, // 9352-9359
122, 124, 127, 127, 135, 145, 136, 134, // 9360-9367
130, 133, 124, 129, 141, 149, 150, 143, // 9368-9375
144, 148, 157, 154, 151, 146, 141, 133, // 9376-9383
127, 127, 125, 118, 108, 102, 101, 101, // 9384-9391
102, 103, 108, 106, 110, 119, 124, 127, // 9392-9399
131, 137, 127, 121, 123, 129, 130, 126, // 9400-9407
126, 126, 129, 129, 129, 129, 131, 129, // 9408-9415
127, 130, 133, 137, 136, 135, 133, 131, // 9416-9423
128, 126, 129, 128, 127, 128, 126, 128, // 9424-9431
129, 129, 127, 124, 124, 126, 129, 128, // 9432-9439
129, 128, 127, 127, 124, 121, 122, 123, // 9440-9447
120, 122, 121, 122, 124, 126, 128, 128, // 9448-9455
128, 128, 129, 130, 131, 132, 133, 131, // 9456-9463
131, 131, 129, 126, 125, 125, 125, 124, // 9464-9471
124, 125, 127, 129, 128, 127, 128, 129, // 9472-9479
128, 128, 126, 126, 126, 126, 126, 127, // 9480-9487
126, 126, 125, 124, 125, 126, 127, 128, // 9488-9495
130, 131, 132, 130, 129, 130, 130, 129, // 9496-9503
126, 125, 125, 125, 125, 124, 124, 125, // 9504-9511
124, 123, 123, 124, 125, 126, 128, 130, // 9512-9519
129, 130, 131, 131, 130, 128, 129, 128, // 9520-9527
128, 128, 128, 126, 124, 122, 123, 124, // 9528-9535
124, 125, 127, 127, 128, 128, 128, 129, // 9536-9543
130, 129, 127, 126, 125, 126, 128, 130, // 9544-9551
130, 128, 129, 130, 130, 130, 131, 132, // 9552-9559
131, 130, 129, 129, 127, 124, 122, 122, // 9560-9567
120, 119, 122, 124, 125, 124, 124, 125, // 9568-9575
126, 127, 126, 127, 125, 124, 126, 128, // 9576-9583
130, 131, 130, 130, 129, 129, 129, 130, // 9584-9591
130, 130, 129, 128, 127, 127, 127, 128, // 9592-9599
129, 127, 126, 129, 130, 131, 129, 129, // 9600-9607
128, 127, 123, 122, 123, 122, 122, 122, // 9608-9615
124, 126, 127, 129, 131, 130, 128, 127, // 9616-9623
129, 129, 128, 127, 126, 124, 122, 122, // 9624-9631
124, 124, 125, 126, 127, 127, 128, 128, // 9632-9639
129, 129, 127, 125, 127, 127, 128, 130, // 9640-9647
132, 134, 132, 131, 130, 132, 130, 129, // 9648-9655
129, 128, 127, 125, 125, 125, 123, 121, // 9656-9663
124, 124, 125, 126, 127, 127, 126, 124, // 9664-9671
124, 124, 123, 121, 122, 123, 122, 124, // 9672-9679
126, 130, 131, 132, 131, 132, 132, 131, // 9680-9687
129, 131, 131, 128, 127, 128, 128, 127, // 9688-9695
127, 128, 128, 126, 127, 128, 129, 126, // 9696-9703
125, 125, 126, 126, 123, 124, 125, 124, // 9704-9711
125, 127, 128, 129, 128, 127, 127, 126, // 9712-9719
125, 128, 130, 129, 127, 127, 128, 127, // 9720-9727
126, 126, 126, 126, 125, 125, 124, 125, // 9728-9735
124, 124, 123, 124, 123, 125, 127, 128, // 9736-9743
130, 131, 133, 133, 133, 131, 132, 133, // 9744-9751
129, 129, 131, 130, 129, 127, 126, 126, // 9752-9759
124, 123, 123, 125, 124, 124, 124, 125, // 9760-9767
125, 125, 123, 126, 126, 124, 124, 125, // 9768-9775
124, 125, 126, 127, 129, 127, 128, 131, // 9776-9783
132, 131, 132, 133, 132, 131, 130, 131, // 9784-9791
131, 129, 128, 128, 126, 125, 125, 124, // 9792-9799
125, 124, 123, 126, 126, 125, 123, 123, // 9800-9807
123, 125, 125, 126, 128, 127, 127, 129, // 9808-9815
129, 128, 129, 129, 129, 129, 127, 128, // 9816-9823
129, 128, 126, 126, 127, 127, 128, 126, // 9824-9831
126, 126, 125, 124, 124, 124, 124, 123, // 9832-9839
123, 126, 126, 128, 130, 130, 129, 131, // 9840-9847
131, 132, 133, 133, 133, 130, 127, 127, // 9848-9855
128, 127, 125, 123, 123, 124, 124, 123, // 9856-9863
124, 126, 124, 124, 123, 124, 126, 126, // 9864-9871
124, 125, 125, 125, 128, 129, 129, 130, // 9872-9879
130, 130, 130, 130, 130, 131, 130, 129, // 9880-9887
128, 128, 130, 131, 130, 129, 127, 126, // 9888-9895
125, 127, 128, 127, 125, 124, 123, 122, // 9896-9903
121, 123, 124, 123, 125, 125, 127, 130, // 9904-9911
130, 131, 130, 129, 128, 129, 128, 128, // 9912-9919
127, 126, 126, 126, 126, 127, 128, 127, // 9920-9927
126, 125, 126, 127, 127, 126, 125, 125, // 9928-9935
124, 125, 127, 129, 129, 129, 128, 128, // 9936-9943
130, 131, 131, 131, 130, 129, 127, 128, // 9944-9951
129, 128, 127, 126, 124, 124, 126, 126, // 9952-9959
125, 123, 123, 123, 124, 124, 124, 126, // 9960-9967
125, 125, 125, 126, 130, 132, 131, 130, // 9968-9975
130, 129, 131, 131, 130, 129, 126, 124, // 9976-9983
125, 126, 128, 129, 129, 128, 127, 126, // 9984-9991
126, 128, 127, 127, 126, 124, 124, 125, // 9992-9999
124, 125, 124, 122, 124, 126, 128, 130, // 10000-10007
131, 131, 131, 130, 129, 130, 130, 129, // 10008-10015
126, 127, 126, 128, 127, 127, 125, 124, // 10016-10023
122, 123, 123, 125, 126, 125, 123, 124, // 10024-10031
125, 127, 128, 129, 128, 129, 130, 130, // 10032-10039
131, 131, 131, 130, 128, 128, 130, 130, // 10040-10047
129, 128, 128, 128, 127, 128, 129, 128, // 10048-10055
126, 123, 123, 123, 124, 124, 123, 123, // 10056-10063
123, 122, 124, 126, 127, 128, 129, 129, // 10064-10071
128, 130, 132, 133, 132, 128, 128, 127, // 10072-10079
126, 127, 128, 128, 127, 127, 126, 127, // 10080-10087
128, 125, 126, 125, 125, 126, 127, 128, // 10088-10095
128, 128, 125, 125, 124, 125, 127, 128, // 10096-10103
128, 127, 127, 129, 130, 130, 129, 130, // 10104-10111
128, 128, 128, 129, 130, 129, 126, 125, // 10112-10119
124, 124, 124, 123, 123, 123, 122, 122, // 10120-10127
124, 126, 126, 127, 126, 126, 128, 130, // 10128-10135
130, 131, 130, 129, 130, 130, 130, 130, // 10136-10143
129, 127, 126, 126, 127, 128, 127, 128, // 10144-10151
127, 126, 126, 127, 128, 128, 127, 124, // 10152-10159
124, 126, 125, 125, 125, 124, 124, 126, // 10160-10167
126, 129, 131, 130, 130, 130, 129, 130, // 10168-10175
129, 128, 127, 126, 124, 126, 127, 127, // 10176-10183
127, 126, 125, 124, 124, 127, 128, 127, // 10184-10191
127, 127, 127, 128, 128, 126, 126, 127, // 10192-10199
126, 127, 128, 128, 129, 129, 127, 126, // 10200-10207
125, 125, 128, 128, 128, 128, 129, 129, // 10208-10215
129, 128, 128, 127, 126, 125, 126, 124, // 10216-10223
124, 123, 124, 125, 124, 123, 126, 129, // 10224-10231
129, 129, 131, 130, 131, 131, 130, 130, // 10232-10239
128, 126, 125, 126, 126, 126, 126, 126, // 10240-10247
125, 126, 126, 129, 129, 128, 127, 127, // 10248-10255
127, 127, 129, 129, 128, 126, 125, 127, // 10256-10263
128, 127, 128, 127, 127, 126, 127, 129, // 10264-10271
128, 126, 125, 124, 125, 126, 128, 130, // 10272-10279
129, 128, 125, 125, 125, 125, 124, 124, // 10280-10287
124, 124, 125, 127, 130, 130, 129, 128, // 10288-10295
128, 130, 131, 132, 131, 130, 127, 127, // 10296-10303
126, 126, 125, 125, 124, 125, 126, 127, // 10304-10311
129, 128, 128, 125, 127, 125, 130, 126, // 10312-10319
152, 172, 162, 121,  92,  76,  78,  82, // 10320-10327
 91, 109,  61,  88, 164, 196, 213, 217, // 10328-10335
145, 132, 191, 185, 246, 243, 153, 116, // 10336-10343
 14, 248,  44,  78,  90, 110,  87,  35, // 10344-10351
157, 205, 158, 116,  90,  65,  57,  35, // 10352-10359
 49, 109,  56,  20,   6,  20,  35,  63, // 10360-10367
 89, 112, 132,  89, 140, 202, 235, 242, // 10368-10375
239, 226, 210, 196, 173, 218, 199, 120, // 10376-10383
109, 152, 109,  76,  67,  72,  92,  72, // 10384-10391
 59,  83, 167, 249,  28,  49,  32,  30, // 10392-10399
244, 185, 228, 188, 155, 125, 112,  91, // 10400-10407
 86,  66,  68,  39, 233,  29,  74,  98, // 10408-10415
 88, 216, 182,  75,   9, 226,  31, 253, // 10416-10423
217, 217, 245,  24,  69, 106, 142, 179, // 10424-10431
165, 143, 207,  48,  93, 100,  97,  68, // 10432-10439
 65, 216, 209, 249, 175, 146, 103, 103, // 10440-10447
 67, 104, 123,  82,  12, 209,  12,  45, // 10448-10455
 69,  74,  86,  84,  94,  86, 101, 154, // 10456-10463
107,  83,  57,  56,  69,  85,  97, 113, // 10464-10471
126,  81, 119, 175, 199, 211, 205, 202, // 10472-10479
190, 187, 227, 242, 181,  92,  61,  38, // 10480-10487
 53,  52,  19,  63, 141, 139, 151, 231, // 10488-10495
 11,  38, 215, 210, 232, 240, 213, 214, // 10496-10503
225, 137,  81,  35,  13, 249, 252, 244, // 10504-10511
 14, 245,  66, 132,  81,  61,  40,  43, // 10512-10519
 42,  59,  69,  86, 157, 156, 120, 124, // 10520-10527
123, 155, 137, 125, 185, 247, 219, 236, // 10528-10535
 34,  60,  11, 215, 249, 234, 237, 190, // 10536-10543
215, 195, 132, 131,  53,   3, 226, 227, // 10544-10551
221, 248, 239, 218,  38,  89, 123, 135, // 10552-10559
152, 143, 169, 149, 142, 193, 151, 111, // 10560-10567
 89,  85,  85,  94, 102, 113, 126,  84, // 10568-10575
115, 174, 193,  10, 252, 200, 165, 151, // 10576-10583
124, 166, 157,  51,  57,  88, 122, 137, // 10584-10591
162, 161, 197, 115,  84, 181, 225, 249, // 10592-10599
234, 219, 183, 165, 123, 122, 129,  65, // 10600-10607
  8, 247, 217,  55, 104,  15, 242, 218, // 10608-10615
183, 236,  51,  93, 129, 151, 175, 185, // 10616-10623
204, 198,  13, 230, 137, 158, 181, 200, // 10624-10631
210, 210, 216, 187, 105, 140, 203, 234, // 10632-10639
236, 224, 202, 176, 208, 144, 116,  97, // 10640-10647
 20, 237, 216, 222, 228, 254,  11,  49, // 10648-10655
 46,  37,  91, 158, 182, 167, 183, 179, // 10656-10663
182, 166, 164, 198, 159, 117,  97,  87, // 10664-10671
 88,  91, 107, 106, 167, 137, 120, 147, // 10672-10679
159, 166, 167, 171, 114, 133, 153, 219, // 10680-10687
227, 182, 153, 147, 111,  76, 123, 137, // 10688-10695
166, 135, 113, 148, 162, 161, 150, 132, // 10696-10703
113,  96,  80,  66, 152, 154,  45, 230, // 10704-10711
198, 198, 214, 241,  20,  54,  41, 105, // 10712-10719
165, 210, 232, 253, 251, 199, 220, 244, // 10720-10727
 43,  28, 220, 200, 148, 103, 127, 145, // 10728-10735
148, 160, 119, 110, 143, 199, 190, 137, // 10736-10743
110,  78,  69,  41,  67,  84,  43,  20, // 10744-10751
 18,  24,  43,  53,  85, 117,  84,  75, // 10752-10759
127, 168, 186, 193, 192, 185, 178, 167, // 10760-10767
157, 192, 154, 121,  94, 117, 141, 109, // 10768-10775
 96,  89, 103,  68,  97, 101, 134, 184, // 10776-10783
213, 227, 227, 221, 205, 210, 162, 139, // 10784-10791
134, 126, 119, 111, 107,  95, 100,  71, // 10792-10799
 42,  84,  97, 115,  99, 141, 187, 127, // 10800-10807
 61,  40,  62,  20,   3,   3,  23,  45, // 10808-10815
 76, 101, 133, 155, 137, 182, 185, 218, // 10816-10823
 13,  28,  33,  13,   9, 210, 194, 196, // 10824-10831
160, 141, 124, 113, 108,  97, 124, 137, // 10832-10839
 61,  34,  61,  77,  84,  89,  90,  87, // 10840-10847
 91,  86, 106, 138,  91,  89,  95,  62, // 10848-10855
 74,  94, 105, 121, 121,  94, 136, 165, // 10856-10863
184, 186, 189, 176, 177, 160, 171, 235, // 10864-10871
172, 111,  81,  71,  68,  84,  57,  69, // 10872-10879
121, 117, 145, 198, 220, 233, 221, 170, // 10880-10887
174, 192, 179, 196, 190, 131, 100,  72, // 10888-10895
 61,  49,  55,  43,  61,  36,  47, 152, // 10896-10903
134,  99,  74,  68,  61,  71,  73,  93, // 10904-10911
138, 120, 110, 111, 125, 132, 155, 134, // 10912-10919
141, 189, 173, 213, 242,   7, 241, 192, // 10920-10927
202, 205, 201, 180, 194, 177, 115, 112, // 10928-10935
109,  65,  37,  26,  22,  35,  16,  16, // 10936-10943
 70,  94, 118, 122, 138, 129, 143, 157, // 10944-10951
132, 153, 124, 109,  98, 102, 101, 112, // 10952-10959
114, 128, 127, 106, 135, 166, 178, 187, // 10960-10967
225, 194, 162, 140, 128, 151, 138,  74, // 10968-10975
 59,  91, 112, 129, 145, 153, 164, 138, // 10976-10983
106, 149, 186, 202, 199, 191, 171, 159, // 10984-10991
130, 138, 131,  83,  52,  37,  30,  46, // 10992-10999
112,  86,  53,  16, 247,  38,  72,  99, // 11000-11007
116, 136, 143, 159, 163, 179, 208, 190, // 11008-11015
144, 118, 150, 166, 186, 184, 194, 184, // 11016-11023
115, 144, 191, 205, 207, 191, 183, 159, // 11024-11031
159, 161, 147, 109,  51,  26,  14,  17, // 11032-11039
 21,  39,  44,  70,  59,  66, 110, 136, // 11040-11047
183, 148, 146, 151, 158, 150, 160, 176, // 11048-11055
142, 119, 107, 106, 105, 111, 113, 125, // 11056-11063
124, 136, 156, 158, 157, 154, 151, 155, // 11064-11071
125, 114, 139, 182, 179, 151, 142, 131, // 11072-11079
136, 103, 102, 126, 147, 126, 126, 154, // 11080-11087
161, 159, 146, 136, 119, 111,  92, 103, // 11088-11095
117, 126, 100,  41,  15,   4,  17,  26, // 11096-11103
 53,  60,  62, 112, 150, 176, 194, 200, // 11104-11111
206, 197, 166, 193, 236, 220, 187, 174, // 11112-11119
158, 119, 126, 142, 149, 155, 120, 130, // 11120-11127
150, 158, 186, 157, 124,  99,  87,  69, // 11128-11135
 90,  87,  57,  47,  46,  55,  64,  80, // 11136-11143
 83, 136,  94,  75, 127, 151, 169, 169, // 11144-11151
172, 166, 165, 151, 159, 173, 142, 118, // 11152-11159
111, 104, 131, 140, 117, 111, 108,  82, // 11160-11167
114, 121, 124, 159, 177, 189, 188, 190, // 11168-11175
175, 204, 162, 111, 117, 119, 122, 118, // 11176-11183
118, 111, 116,  85,  81, 107, 115, 120, // 11184-11191
114, 119, 149, 151,  97,  85,  80,  46, // 11192-11199
 33,  34,  48,  64,  87, 103, 128, 137, // 11200-11207
129, 168, 192, 178, 201, 222, 229, 226, // 11208-11215
215, 202, 186, 163, 149, 138, 132, 123, // 11216-11223
118, 115, 110, 138,  99,  81,  93,  96, // 11224-11231
 98,  96,  99,  94,  99,  91, 117, 122, // 11232-11239
100,  82, 111,  94,  72,  97, 105, 127, // 11240-11247
117, 110, 141, 162, 169, 171, 169, 163, // 11248-11255
158, 153, 149, 187, 170, 125, 100,  91, // 11256-11263
 87,  98,  86,  81, 115, 112, 147, 177, // 11264-11271
195, 194, 197, 175, 144, 155, 154, 178, // 11272-11279
163, 128, 110,  96,  88,  80,  80,  74, // 11280-11287
 84,  63,  68, 130, 151, 126,  99,  87, // 11288-11295
 80,  82,  77,  99, 123, 107, 106, 110, // 11296-11303
122, 130, 143, 151, 138, 147, 151, 189, // 11304-11311
214, 223, 219, 182, 176, 183, 179, 168, // 11312-11319
182, 155, 124, 102, 113, 107,  80,  69, // 11320-11327
 59,  64,  42,  56,  88, 105, 116, 122, // 11328-11335
125, 129, 124, 146, 151, 123, 107, 101, // 11336-11343
103, 106, 111, 116, 121, 130, 123, 111, // 11344-11351
142, 155, 168, 163, 177, 189, 167, 142, // 11352-11359
136, 145, 125,  95,  71,  96, 114, 132, // 11360-11367
138, 149, 152, 133, 142, 138, 156, 170, // 11368-11375
171, 166, 156, 149, 132, 142, 125,  93, // 11376-11383
 75,  67,  64,  72, 102, 111, 100,  58, // 11384-11391
 47,  74,  89, 104, 113, 124, 132, 144, // 11392-11399
146, 162, 181, 157, 151, 123, 125, 147, // 11400-11407
163, 167, 173, 172, 125, 145, 175, 186, // 11408-11415
183, 177, 164, 158, 141, 143, 164, 119, // 11416-11423
 80,  58,  49,  48,  55,  62,  70,  82, // 11424-11431
 73,  83, 120, 126, 161, 160, 123, 128, // 11432-11439
136, 134, 150, 157, 131, 121, 112, 116, // 11440-11447
117, 124, 122, 134, 124, 120, 165, 169, // 11448-11455
160, 154, 144, 143, 133, 110, 132, 164, // 11456-11463
155, 141, 135, 132, 131, 132, 107, 112, // 11464-11471
129, 114, 129, 147, 151, 149, 142, 130, // 11472-11479
122, 114, 105, 116, 115, 108, 109,  88, // 11480-11487
 64,  56,  55,  58,  75,  74,  81, 119, // 11488-11495
140, 160, 166, 174, 170, 182, 159, 158, // 11496-11503
189, 174, 166, 156, 156, 131, 130, 139, // 11504-11511
149, 146, 128, 140, 154, 150, 154, 162, // 11512-11519
133, 115, 100,  90, 105,  92,  73,  70, // 11520-11527
 67,  76,  81,  94,  91, 123, 118,  88, // 11528-11535
116, 135, 149, 152, 152, 150, 154, 143, // 11536-11543
156, 158, 134, 122, 117, 118, 119, 145, // 11544-11551
138, 129, 118, 101, 126, 133, 124, 141, // 11552-11559
157, 161, 168, 164, 164, 174, 155, 116, // 11560-11567
102, 113, 117, 123, 121, 120, 119,  99, // 11568-11575
102, 118, 121, 124, 118, 118, 129, 139, // 11576-11583
124, 114,  98,  70,  62,  63,  72,  82, // 11584-11591
100, 108, 126, 123, 128, 154, 176, 175, // 11592-11599
162, 179, 184, 193, 184, 190, 175, 144, // 11600-11607
141, 137, 134, 131, 130, 125, 119, 118, // 11608-11615
117, 116, 115, 111, 109, 105, 101, 100, // 11616-11623
103, 101, 121, 112, 101,  91, 105, 122, // 11624-11631
 92,  94, 103, 118, 109, 115, 139, 151, // 11632-11639
156, 155, 154, 150, 152, 145, 157, 156, // 11640-11647
151, 142, 118, 113, 106, 114, 107,  94, // 11648-11655
104, 114, 143, 163, 172, 175, 169, 165, // 11656-11663
147, 133, 144, 160, 146, 125, 114, 106, // 11664-11671
103,  98,  97,  93,  96,  79,  90, 124, // 11672-11679
138, 141, 118, 104,  93,  97,  94, 113, // 11680-11687
117, 107, 107, 111, 119, 127, 136, 142, // 11688-11695
147, 124, 134, 166, 185, 190, 191, 170, // 11696-11703
154, 165, 162, 165, 171, 148, 129, 115, // 11704-11711
106, 120, 113,  95,  89,  85,  67,  82, // 11712-11719
 97, 109, 116, 121, 119, 124, 124, 129, // 11720-11727
164, 128, 100, 102, 103, 108, 113, 119, // 11728-11735
121, 129, 115, 118, 139, 150, 153, 156, // 11736-11743
150, 160, 169, 145, 147, 146, 126, 112, // 11744-11751
 89,  99, 117, 128, 134, 142, 141, 126, // 11752-11759
145, 147, 138, 148, 152, 151, 149, 142, // 11760-11767
134, 144, 123, 104,  93,  89,  88,  90, // 11768-11775
105, 108, 117,  88,  82,  93, 100, 107, // 11776-11783
113, 118, 124, 133, 133, 152, 157, 142, // 11784-11791
138, 138, 123, 133, 148, 154, 162, 156, // 11792-11799
133, 139, 157, 165, 167, 165, 157, 152, // 11800-11807
142, 133, 157, 136, 105,  87,  79,  77, // 11808-11815
 78,  79,  86,  93,  83,  98, 117, 126, // 11816-11823
136, 158, 133, 119, 128, 126, 144, 141, // 11824-11831
126, 121, 118, 117, 120, 122, 124, 131, // 11832-11839
123, 118, 144, 166, 156, 148, 141, 137, // 11840-11847
135, 113, 126, 148, 139, 138, 135, 138, // 11848-11855
133, 138, 129, 117, 123, 118, 133, 143, // 11856-11863
146, 143, 139, 130, 125, 118, 112, 125, // 11864-11871
112, 112, 107, 108,  97,  82,  76,  76, // 11872-11879
 85,  78,  90, 112, 129, 140, 149, 154, // 11880-11887
157, 159, 159, 154, 159, 156, 155, 151, // 11888-11895
153, 140, 129, 136, 145, 140, 132, 145, // 11896-11903
147, 149, 139, 148, 146, 127, 112, 104, // 11904-11911
111,  97,  86,  83,  85,  88,  94,  99, // 11912-11919
106, 114, 124, 117, 113, 127, 135, 138, // 11920-11927
140, 141, 141, 138, 148, 145, 131, 126, // 11928-11935
122, 125, 121, 128, 143, 140, 124, 114, // 11936-11943
126, 132, 124, 127, 140, 146, 154, 152, // 11944-11951
157, 162, 147, 135, 112, 114, 121, 125, // 11952-11959
125, 128, 123, 110, 116, 122, 124, 122, // 11960-11967
123, 118, 128, 127, 127, 133, 108,  87, // 11968-11975
 77,  77,  82,  90,  99, 107, 120, 119, // 11976-11983
126, 146, 155, 167, 154, 153, 163, 170, // 11984-11991
167, 175, 168, 139, 140, 135, 138, 136, // 11992-11999
138, 131, 132, 120, 117, 135, 128, 121, // 12000-12007
113, 108, 104, 104, 103, 105, 117, 111, // 12008-12015
105, 102, 105, 125, 118, 100, 106, 116, // 12016-12023
112, 121, 135, 142, 148, 146, 146, 143, // 12024-12031
144, 139, 149, 146, 133, 143, 133, 124, // 12032-12039
116, 114, 115, 107, 105, 112, 133, 147, // 12040-12047
157, 158, 157, 152, 151, 130, 130, 146, // 12048-12055
137, 129, 120, 116, 113, 113, 109, 109, // 12056-12063
106,  98, 102, 124, 131, 134, 133, 115, // 12064-12071
103,  98,  97, 109, 112, 105, 107, 110, // 12072-12079
120, 124, 134, 136, 148, 134, 127, 151, // 12080-12087
165, 173, 173, 167, 149, 155, 151, 157, // 12088-12095
158, 143, 132, 123, 116, 115, 127, 115, // 12096-12103
107,  96,  85,  95, 105, 111, 114, 117, // 12104-12111
118, 121, 122, 124, 148, 136, 106, 102, // 12112-12119
106, 113, 118, 122, 125, 130, 121, 126, // 12120-12127
138, 142, 146, 146, 147, 141, 154, 148, // 12128-12135
145, 138, 119, 114, 100, 102, 111, 123, // 12136-12143
130, 139, 135, 133, 144, 151, 144, 137, // 12144-12151
145, 145, 146, 139, 138, 140, 126, 113, // 12152-12159
106, 101, 102,  98, 109, 114, 115, 110, // 12160-12167
102, 105, 105, 108, 110, 115, 117, 122, // 12168-12175
123, 139, 141, 135, 133, 136, 135, 125, // 12176-12183
136, 145, 153, 149, 146, 146, 154, 158, // 12184-12191
157, 155, 149, 144, 136, 135, 134, 130, // 12192-12199
118, 107, 101,  95,  95,  96, 101, 102, // 12200-12207
101, 111, 120, 124, 126, 134, 135, 126, // 12208-12215
121, 122, 130, 129, 126, 125, 126, 127, // 12216-12223
126, 127, 127, 130, 128, 130, 132, 136, // 12224-12231
137, 134, 134, 130, 129, 125, 125, 128, // 12232-12239
127, 129, 130, 132, 132, 131, 133, 130, // 12240-12247
126, 127, 129, 131, 131, 131, 130, 131, // 12248-12255
129, 127, 126, 125, 122, 122, 123, 123, // 12256-12263
124, 120, 119, 118, 116, 116, 117, 120, // 12264-12271
121, 122, 124, 127, 129, 131, 132, 132, // 12272-12279
130, 129, 131, 134, 137, 136, 135, 134, // 12280-12287
133, 134, 133, 133, 131, 129, 128, 127, // 12288-12295
128, 129, 128, 127, 124, 121, 122, 124, // 12296-12303
125, 125, 123, 123, 123, 124, 125, 127, // 12304-12311
125, 122, 119, 120, 122, 126, 127, 128, // 12312-12319
127, 126, 127, 129, 130, 131, 130, 129, // 12320-12327
128, 128, 130, 132, 130, 126, 124, 124, // 12328-12335
123, 124, 126, 128, 129, 129, 130, 132, // 12336-12343
133, 132, 130, 128, 129, 129, 130, 130, // 12344-12351
130, 128, 125, 124, 123, 122, 123, 125, // 12352-12359
126, 125, 126, 128, 128, 127, 125, 125, // 12360-12367
125, 122, 123, 125, 127, 126, 126, 125, // 12368-12375
126, 126, 124, 126, 128, 129, 129, 131, // 12376-12383
131, 133, 133, 133, 132, 131, 130, 129, // 12384-12391
130, 129, 128, 127, 126, 125, 122, 122, // 12392-12399
124, 124, 123, 124, 127, 128, 129, 130, // 12400-12407
131, 130, 127, 125, 125, 126, 125, 125, // 12408-12415
123, 124, 124, 124, 125, 127, 128, 126, // 12416-12423
127, 131, 131, 132, 133, 132, 129, 127, // 12424-12431
126, 127, 126, 125, 125, 125, 126, 127, // 12432-12439
128, 128, 129, 126, 124, 128, 129, 131, // 12440-12447
131, 132, 131, 130, 128, 129, 130, 127, // 12448-12455
124, 124, 123, 124, 125, 125, 124, 121, // 12456-12463
119, 122, 125, 125, 127, 128, 128, 128, // 12464-12471
128, 129, 129, 127, 123, 123, 124, 127, // 12472-12479
128, 129, 131, 132, 128, 129, 133, 135, // 12480-12487
134, 133, 132, 132, 131, 130, 129, 127, // 12488-12495
123, 120, 120, 121, 121, 124, 123, 124, // 12496-12503
124, 124, 126, 128, 129, 127, 127, 127, // 12504-12511
128, 128, 130, 131, 128, 124, 125, 125, // 12512-12519
124, 126, 127, 128, 127, 126, 127, 130, // 12520-12527
130, 128, 128, 128, 126, 126, 126, 129, // 12528-12535
129, 126, 123, 123, 123, 124, 125, 125, // 12536-12543
129, 128, 129, 133, 136, 134, 132, 132, // 12544-12551
129, 127, 127, 128, 129, 125, 123, 121, // 12552-12559
120, 118, 119, 121, 121, 123, 123, 125, // 12560-12567
129, 131, 131, 129, 128, 127, 127, 128, // 12568-12575
132, 132, 130, 130, 131, 129, 128, 131, // 12576-12583
131, 130, 128, 128, 131, 133, 131, 129, // 12584-12591
129, 126, 124, 123, 124, 125, 124, 121, // 12592-12599
120, 121, 122, 122, 122, 124, 124, 123, // 12600-12607
125, 129, 131, 132, 132, 131, 128, 130, // 12608-12615
130, 130, 129, 126, 126, 125, 126, 128, // 12616-12623
129, 128, 126, 125, 124, 126, 129, 129, // 12624-12631
129, 128, 127, 127, 126, 128, 128, 125, // 12632-12639
123, 125, 127, 129, 132, 132, 130, 127, // 12640-12647
126, 127, 128, 129, 128, 128, 128, 128, // 12648-12655
126, 126, 125, 122, 119, 118, 119, 122, // 12656-12663
124, 124, 124, 124, 124, 125, 129, 130, // 12664-12671
131, 131, 132, 133, 135, 135, 132, 130, // 12672-12679
129, 128, 127, 128, 129, 129, 129, 128, // 12680-12687
126, 126, 127, 128, 126, 124, 125, 125, // 12688-12695
124, 123, 124, 125, 123, 122, 122, 123, // 12696-12703
123, 125, 126, 126, 128, 129, 129, 129, // 12704-12711
132, 133, 131, 129, 129, 131, 130, 130, // 12712-12719
130, 128, 126, 125, 124, 124, 125, 124, // 12720-12727
126, 125, 126, 128, 130, 130, 130, 130, // 12728-12735
126, 126, 127, 129, 132, 131, 129, 127, // 12736-12743
126, 126, 127, 126, 125, 124, 124, 126, // 12744-12751
128, 129, 127, 125, 123, 122, 122, 123, // 12752-12759
126, 127, 124, 122, 123, 125, 126, 127, // 12760-12767
127, 127, 128, 128, 133, 136, 136, 134, // 12768-12775
131, 131, 133, 132, 131, 131, 129, 127, // 12776-12783
125, 124, 125, 125, 124, 122, 122, 121, // 12784-12791
123, 125, 125, 124, 123, 122, 125, 126, // 12792-12799
127, 128, 126, 124, 125, 128, 129, 130, // 12800-12807
129, 128, 129, 128, 128, 130, 130, 130, // 12808-12815
130, 130, 130, 129, 129, 128, 127, 124, // 12816-12823
123, 125, 126, 126, 126, 125, 126, 127, // 12824-12831
126, 127, 127, 128, 130, 131, 130, 132, // 12832-12839
131, 129, 127, 127, 125, 124, 124, 125, // 12840-12847
126, 126, 125, 124, 123, 123, 124, 124, // 12848-12855
124, 125, 126, 126, 126, 126, 126, 127, // 12856-12863
126, 126, 128, 128, 129, 131, 132, 130, // 12864-12871
130, 130, 131, 132, 132, 132, 130, 129, // 12872-12879
130, 130, 128, 127, 126, 125, 123, 123, // 12880-12887
123, 123, 122, 122, 121, 121, 123, 125, // 12888-12895
126, 127, 127, 126, 127, 128, 129, 129, // 12896-12903
129, 129, 129, 128, 128, 128, 128, 128, // 12904-12911
127, 128, 129, 130, 129, 129, 129, 127, // 12912-12919
126, 126, 127, 127, 126, 126, 126, 125, // 12920-12927
126, 126, 126, 125, 125, 128, 129, 130, // 12928-12935
130, 131, 130, 129, 127, 127, 127, 127, // 12936-12943
126, 127, 125, 125, 125, 124, 122, 123, // 12944-12951
122, 122, 123, 124, 125, 125, 125, 126, // 12952-12959
126, 127, 129, 130, 129, 130, 133, 131, // 12960-12967
130, 130, 130, 130, 128, 128, 130, 131, // 12968-12975
129, 130, 129, 128, 130, 128, 128, 128, // 12976-12983
126, 124, 124, 122, 123, 122, 121, 121, // 12984-12991
122, 123, 124, 126, 125, 126, 127, 128, // 12992-12999
130, 129, 130, 130, 129, 128, 128, 128, // 13000-13007
128, 129, 129, 128, 129, 129, 128, 128, // 13008-13015
127, 126, 126, 126, 127, 129, 128, 129, // 13016-13023
128, 127, 127, 128, 127, 126, 127, 128, // 13024-13031
127, 126, 125, 127, 128, 125, 126, 127, // 13032-13039
128, 129, 129, 128, 129, 127, 125, 124, // 13040-13047
124, 123, 124, 124, 122, 124, 123, 123, // 13048-13055
125, 125, 126, 129, 129, 129, 132, 132, // 13056-13063
132, 130, 129, 129, 131, 131, 130, 131, // 13064-13071
131, 128, 128, 128, 129, 129, 126, 126, // 13072-13079
125, 125, 126, 126, 125, 124, 123, 123, // 13080-13087
125, 125, 125, 126, 125, 122, 124, 125, // 13088-13095
126, 127, 127, 127, 129, 128, 128, 129, // 13096-13103
130, 129, 130, 128, 129, 129, 130, 128, // 13104-13111
128, 125, 125, 126, 125, 127, 127, 127, // 13112-13119
126, 128, 126, 129, 129, 129, 127, 129, // 13120-13127
128, 130, 130, 128, 136, 167, 169, 142, // 13128-13135
107,  84,  84,  74,  99,  67,  50, 124, // 13136-13143
177, 188, 209, 176, 116, 136, 205, 254, // 13144-13151
191, 127, 117,  37,  13,  60, 111, 104, // 13152-13159
 69, 126, 168, 243, 220, 138, 105,  51, // 13160-13167
 51,  89,  39, 235, 230, 229,   5,  18, // 13168-13175
 58,  73,  51, 108, 185, 211, 231, 220, // 13176-13183
219, 202, 188, 233, 185, 120,  92,  90, // 13184-13191
 85, 123, 184, 144,  63,  77, 144, 165, // 13192-13199
197, 137, 138, 200, 216,  45,  23, 209, // 13200-13207
164,  78,  99, 145, 159, 178, 119, 112, // 13208-13215
157, 170, 161, 143, 116,  99,  66,  84, // 13216-13223
205, 127, 234, 168, 144, 160, 170, 226, // 13224-13231
221, 249, 100, 167, 214, 237,   8, 235, // 13232-13239
183,  22,  72,  27, 238, 219, 201, 124, // 13240-13247
123, 173, 163, 127, 188, 210, 225,  15, // 13248-13255
190, 131,  70,  61,  83,  19, 227, 218, // 13256-13263
221, 247,   7,  45,  48,  30,  97, 146, // 13264-13271
180, 196, 190, 189, 170, 166, 205, 160, // 13272-13279
102,  87,  71,  91,  78, 150, 174,  87, // 13280-13287
 92, 144, 155, 178, 164, 114, 142, 184, // 13288-13295
  0, 249, 179, 173, 125,  85, 120, 155, // 13296-13303
174, 130, 127, 181, 180, 180, 147, 134, // 13304-13311
100,  84,  96, 110, 147,  53, 203, 173, // 13312-13319
168, 184, 224, 219, 243,  93, 146, 196, // 13320-13327
222, 235,   3, 193, 225,  44, 251, 237, // 13328-13335
205, 208, 169, 111, 159, 152, 141, 189, // 13336-13343
225, 208, 232, 235, 166,  96,  81,  89, // 13344-13351
 21, 234, 224, 226, 249,   3,  38,  42, // 13352-13359
 22, 109, 154, 165, 193, 184, 192, 168, // 13360-13367
178, 205, 160, 104,  91,  76,  90,  90, // 13368-13375
107, 164, 118, 112, 148, 157, 163, 168, // 13376-13383
138, 103, 155, 231, 226, 179, 161, 156, // 13384-13391
117,  90, 143, 165, 133, 144, 189, 190, // 13392-13399
183, 159, 137, 115,  78, 120,  74,  81, // 13400-13407
119,  16, 215, 187, 193, 223, 206, 240, // 13408-13415
 76, 130, 167, 195, 209, 228, 218, 205, // 13416-13423
239, 225, 216, 214, 204, 216, 152, 147, // 13424-13431
147, 145, 201, 219, 224, 197, 221, 204, // 13432-13439
117, 103,  93,  24, 238, 227, 231, 250, // 13440-13447
  6,  41,  42,  27,  97, 164, 157, 171, // 13448-13455
175, 179, 165, 172, 200, 149, 113,  94, // 13456-13463
 91,  93, 101, 112, 122, 137, 153, 160, // 13464-13471
161, 161, 156, 161, 102, 113, 198, 186, // 13472-13479
158, 149, 145, 152, 103, 113, 156, 128, // 13480-13487
160, 197, 204, 194, 171, 150, 127, 102, // 13488-13495
123,  96,  24,  94,  82,   0, 216, 205, // 13496-13503
227, 202, 240,  68, 111, 149, 170, 194, // 13504-13511
200, 209, 234, 194, 184, 194, 199, 201, // 13512-13519
203, 194, 146, 129, 145, 208, 225, 231, // 13520-13527
213, 190, 221, 166, 133, 109,  34, 252, // 13528-13535
234, 236, 252,   7,  38,  27,  30,  86, // 13536-13543
146, 170, 149, 160, 167, 156, 171, 194, // 13544-13551
147, 114, 100,  93, 104,  98, 126, 107, // 13552-13559
115, 183, 184, 168, 166, 146, 156, 124, // 13560-13567
 97, 160, 161, 143, 149, 141, 157, 141, // 13568-13575
108, 126, 123, 158, 203, 201, 200, 171, // 13576-13583
161, 128, 116, 125, 101,  36,  36, 107, // 13584-13591
 76,   7, 240, 238, 210, 243,  59,  95, // 13592-13599
130, 147, 166, 180, 180, 236, 200, 135, // 13600-13607
166, 177, 199, 196, 210, 186, 117, 144, // 13608-13615
202, 228, 225, 217, 188, 188, 189, 168, // 13616-13623
127,  51,  11, 250, 249,   3,  11,  41, // 13624-13631
 29,  32,  96, 123, 174, 162, 139, 158, // 13632-13639
143, 170, 179, 139, 109, 101,  94, 104, // 13640-13647
104, 123, 115,  90, 170, 211, 184, 171, // 13648-13655
155, 150, 142, 119, 131, 135, 126, 131, // 13656-13663
136, 143, 149, 142, 104, 108, 157, 199, // 13664-13671
204, 201, 180, 166, 140, 124, 141,  96, // 13672-13679
 57,  24,  62, 113,  53,  16, 251, 219, // 13680-13687
255,  58,  89, 117, 133, 152, 161, 169, // 13688-13695
211, 210, 134, 128, 159, 183, 195, 198, // 13696-13703
209, 130, 131, 198, 220, 230, 212, 203, // 13704-13711
171, 173, 203, 149,  70,  29,   6,   6, // 13712-13719
 10,  22,  43,  31,  35,  96, 118, 142, // 13720-13727
175, 138, 135, 135, 159, 174, 132, 115, // 13728-13735
102, 105, 105, 111, 123, 114, 101, 144, // 13736-13743
204, 207, 173, 156, 143, 130, 139, 123, // 13744-13751
103, 115, 126, 136, 148, 148, 166, 123, // 13752-13759
 88, 149, 188, 203, 197, 183, 169, 144, // 13760-13767
133, 143, 101,  61,  46,  33,  99, 106, // 13768-13775
 61,  24, 237,   9,  55,  78, 104, 116, // 13776-13783
136, 142, 158, 194, 186, 153, 113, 128, // 13784-13791
163, 183, 197, 207, 167, 136, 189, 214, // 13792-13799
225, 212, 200, 182, 155, 201, 175,  89, // 13800-13807
 47,  19,  18,  17,  25,  44,  28,  47, // 13808-13815
 94, 125, 131, 159, 166, 126, 126, 155, // 13816-13823
163, 125, 107, 100, 101, 106, 109, 127, // 13824-13831
107, 109, 141, 178, 216, 195, 162, 154, // 13832-13839
127, 149, 141,  84,  91, 108, 121, 137, // 13840-13847
140, 158, 146,  98, 135, 185, 198, 202, // 13848-13855
186, 179, 150, 146, 148, 109,  67,  54, // 13856-13863
 41,  61, 107, 100,  46, 254,  21,  60, // 13864-13871
 78,  96, 107, 126, 133, 145, 183, 167, // 13872-13879
151, 134, 110, 147, 169, 194, 194, 174, // 13880-13887
161, 169, 200, 211, 209, 196, 182, 161, // 13888-13895
178, 181, 118,  69,  41,  31,  31,  36, // 13896-13903
 50,  32,  50,  95, 114, 131, 126, 163, // 13904-13911
145, 111, 151, 152, 126, 112, 107, 107, // 13912-13919
114, 117, 128, 109, 108, 149, 159, 188, // 13920-13927
206, 171, 150, 129, 140, 151,  88,  71, // 13928-13935
 97, 116, 133, 143, 157, 147, 127, 129, // 13936-13943
164, 189, 195, 185, 177, 156, 153, 154, // 13944-13951
111,  79,  60,  53,  51,  83, 122,  84, // 13952-13959
 29,  43,  65,  78,  90,  98, 114, 117, // 13960-13967
138, 169, 157, 135, 142, 118, 120, 150, // 13968-13975
179, 189, 169, 189, 181, 187, 210, 204, // 13976-13983
200, 178, 171, 172, 157, 136,  94,  57, // 13984-13991
 45,  36,  43,  48,  35,  53,  97, 111, // 13992-13999
130, 130, 139, 165, 123, 135, 143, 116, // 14000-14007
111, 104, 112, 113, 119, 127, 113, 115, // 14008-14015
148, 163, 169, 191, 190, 156, 137, 141, // 14016-14023
143, 105,  66,  77, 104, 124, 134, 153, // 14024-14031
139, 140, 152, 147, 175, 185, 184, 177, // 14032-14039
158, 160, 158, 118,  91,  73,  66,  66, // 14040-14047
 68, 112, 111,  65,  62,  71,  75,  87, // 14048-14055
 90, 103, 105, 127, 154, 142, 130, 131, // 14056-14063
137, 121, 132, 170, 182, 168, 195, 205, // 14064-14071
177, 195, 196, 195, 179, 169, 180, 146, // 14072-14079
128, 119,  79,  62,  49,  51,  52,  36, // 14080-14087
 61,  93, 111, 120, 129, 124, 142, 148, // 14088-14095
130, 128, 109, 108, 106, 111, 115, 120, // 14096-14103
132, 113, 122, 151, 166, 170, 169, 191, // 14104-14111
175, 140, 149, 133, 109,  80,  63,  91, // 14112-14119
114, 131, 148, 139, 139, 173, 159, 158, // 14120-14127
177, 177, 175, 158, 163, 156, 117,  92, // 14128-14135
 79,  71,  74,  70,  95, 111,  97,  92, // 14136-14143
 87,  87,  87,  88,  97, 100, 116, 142, // 14144-14151
126, 121, 120, 129, 134, 119, 148, 163, // 14152-14159
163, 190, 215, 194, 181, 191, 191, 182, // 14160-14167
175, 185, 153, 119, 126, 111,  83,  68, // 14168-14175
 62,  57,  39,  63,  93, 107, 117, 115, // 14176-14183
122, 115, 148, 153, 113, 103, 102, 104, // 14184-14191
110, 116, 122, 127, 111, 122, 152, 162, // 14192-14199
172, 164, 170, 184, 160, 158, 141, 109, // 14200-14207
102,  71,  80, 105, 125, 140, 132, 136, // 14208-14215
165, 173, 153, 155, 165, 166, 158, 165, // 14216-14223
159, 122, 102,  88,  83,  83,  82,  89, // 14224-14231
 96, 108, 122, 105,  95,  89,  84,  90, // 14232-14239
 90, 112, 130, 118, 111, 118, 120, 137, // 14240-14247
128, 128, 143, 153, 183, 206, 208, 182, // 14248-14255
177, 186, 176, 182, 185, 159, 128, 118, // 14256-14263
125, 110,  85,  79,  66,  50,  69,  96, // 14264-14271
105, 118, 114, 120, 112, 122, 164, 119, // 14272-14279
 86,  93,  95, 108, 111, 119, 123, 112, // 14280-14287
124, 150, 158, 167, 167, 161, 171, 176, // 14288-14295
166, 146, 112, 105,  91,  76,  95, 116, // 14296-14303
136, 126, 137, 160, 173, 169, 145, 153, // 14304-14311
160, 156, 167, 159, 126, 108,  94,  89, // 14312-14319
 87,  88,  90,  85, 102, 133, 126, 107, // 14320-14327
 98,  90,  92,  90, 112, 125, 114, 111, // 14328-14335
112, 118, 125, 135, 130, 122, 139, 174, // 14336-14343
193, 205, 191, 166, 175, 171, 177, 184, // 14344-14351
155, 137, 119, 118, 129, 103,  91,  76, // 14352-14359
 58,  77,  98, 108, 114, 117, 116, 117, // 14360-14367
116, 148, 142,  90,  87,  93, 106, 111, // 14368-14375
118, 121, 108, 126, 145, 154, 160, 160, // 14376-14383
160, 152, 169, 180, 147, 119, 104, 103, // 14384-14391
 90,  86, 110, 129, 127, 139, 164, 168, // 14392-14399
176, 155, 141, 151, 152, 165, 155, 128, // 14400-14407
114, 100,  96,  92,  91,  93,  79,  96, // 14408-14415
130, 140, 123, 103,  95,  89,  88, 106, // 14416-14423
118, 102, 106, 108, 117, 127, 134, 145, // 14424-14431
122, 126, 166, 187, 196, 198, 173, 163, // 14432-14439
166, 173, 177, 151, 135, 124, 111, 123, // 14440-14447
124, 106,  87,  70,  86,  98, 105, 111, // 14448-14455
114, 118, 114, 124, 131, 139, 116,  85, // 14456-14463
 92, 103, 109, 119, 120, 110, 128, 145, // 14464-14471
150, 156, 152, 154, 147, 150, 179, 153, // 14472-14479
121, 109, 101, 104,  87, 100, 118, 119, // 14480-14487
138, 162, 169, 172, 171, 150, 142, 150, // 14488-14495
164, 155, 131, 120, 108, 104, 100,  97, // 14496-14503
101,  84,  91, 124, 137, 138, 114,  98, // 14504-14511
 91,  88, 106, 109,  98,  98, 103, 109, // 14512-14519
123, 129, 143, 131, 120, 153, 178, 188, // 14520-14527
192, 183, 162, 158, 174, 177, 153, 138, // 14528-14535
128, 120, 116, 126, 121,  92,  79,  90, // 14536-14543
 99, 102, 109, 107, 113, 111, 124, 131, // 14544-14551
120, 129, 104,  88, 104, 112, 123, 121, // 14552-14559
113, 130, 145, 151, 154, 150, 148, 146, // 14560-14567
146, 163, 161, 129, 115, 104, 108, 103, // 14568-14575
 94, 108, 111, 134, 154, 163, 166, 164, // 14576-14583
157, 135, 140, 161, 151, 131, 123, 116, // 14584-14591
112, 109, 108, 103,  89,  91, 120, 134, // 14592-14599
140, 128, 104,  96,  90, 104, 103,  93, // 14600-14607
 93,  98, 110, 121, 131, 138, 137, 133, // 14608-14615
144, 166, 181, 182, 185, 170, 153, 170, // 14616-14623
174, 153, 141, 131, 126, 119, 116, 128, // 14624-14631
106,  88,  97, 100, 102, 103, 103, 106, // 14632-14639
108, 117, 128, 110, 116, 122,  96,  98, // 14640-14647
109, 118, 117, 114, 134, 147, 153, 155, // 14648-14655
151, 152, 147, 152, 155, 152, 140, 119, // 14656-14663
112, 109, 112, 102,  99, 105, 127, 148, // 14664-14671
157, 164, 158, 161, 147, 135, 152, 147, // 14672-14679
131, 124, 116, 115, 109, 112, 108,  94, // 14680-14687
102, 114, 129, 133, 132, 119, 101,  95, // 14688-14695
103, 101,  90,  95,  97, 109, 118, 126, // 14696-14703
134, 130, 140, 147, 153, 173, 176, 177, // 14704-14711
176, 157, 162, 167, 151, 142, 135, 132, // 14712-14719
129, 121, 126, 120, 100, 104, 105, 106, // 14720-14727
102, 102, 104, 104, 116, 122, 113, 106, // 14728-14735
120, 115,  96, 102, 117, 115, 114, 131, // 14736-14743
143, 146, 150, 147, 147, 143, 150, 156, // 14744-14751
141, 145, 135, 121, 118, 112, 115,  97, // 14752-14759
 99, 124, 143, 153, 157, 154, 153, 151, // 14760-14767
139, 139, 138, 129, 124, 120, 119, 115, // 14768-14775
114, 110,  95, 104, 113, 123, 134, 131, // 14776-14783
132, 113, 103, 109, 103,  92,  92,  97, // 14784-14791
106, 115, 124, 134, 128, 140, 155, 149, // 14792-14799
157, 168, 169, 171, 162, 157, 156, 146, // 14800-14807
141, 134, 131, 128, 125, 121, 119, 119, // 14808-14815
117, 115, 111, 106, 103, 106, 104, 118, // 14816-14823
119, 110, 103, 106, 125, 112,  98, 111, // 14824-14831
111, 112, 130, 141, 148, 148, 146, 144, // 14832-14839
141, 148, 154, 139, 133, 139, 127, 121, // 14840-14847
116, 122, 110,  98, 122, 139, 151, 156, // 14848-14855
156, 155, 148, 148, 138, 126, 126, 122, // 14856-14863
119, 117, 113, 112, 110, 102, 107, 118, // 14864-14871
118, 129, 129, 128, 123, 109, 111,  99, // 14872-14879
 91,  90,  96, 107, 113, 124, 128, 127, // 14880-14887
137, 156, 158, 154, 160, 168, 165, 166, // 14888-14895
163, 150, 143, 140, 134, 133, 130, 129, // 14896-14903
124, 112, 122, 124, 116, 115, 111, 109, // 14904-14911
108, 107, 117, 119, 108, 109, 106, 118, // 14912-14919
124, 106, 103, 107, 112, 128, 136, 141, // 14920-14927
142, 142, 145, 140, 146, 146, 136, 126, // 14928-14935
129, 135, 127, 121, 119, 115, 102, 113, // 14936-14943
135, 146, 153, 153, 155, 148, 154, 152, // 14944-14951
129, 124, 124, 122, 123, 119, 121, 114, // 14952-14959
107, 111, 116, 117, 118, 126, 125, 122, // 14960-14967
119, 112, 102,  93,  94,  95, 104, 110, // 14968-14975
120, 126, 126, 139, 151, 158, 153, 147, // 14976-14983
160, 161, 162, 169, 150, 140, 139, 138, // 14984-14991
136, 131, 129, 127, 112, 116, 132, 125, // 14992-14999
118, 111, 109, 105, 104, 113, 115, 110, // 15000-15007
110, 110, 112, 123, 122, 113, 109, 115, // 15008-15015
125, 132, 135, 139, 139, 138, 135, 137, // 15016-15023
137, 133, 131, 127, 133, 132, 126, 127, // 15024-15031
123, 121, 122, 128, 135, 139, 142, 144, // 15032-15039
141, 141, 141, 133, 127, 128, 128, 127, // 15040-15047
125, 124, 120, 116, 118, 118, 117, 118, // 15048-15055
120, 123, 121, 122, 121, 118, 117, 116, // 15056-15063
117, 119, 122, 125, 126, 129, 129, 131, // 15064-15071
134, 135, 136, 137, 140, 141, 141, 139, // 15072-15079
137, 135, 133, 132, 128, 127, 125, 123, // 15080-15087
121, 123, 122, 120, 121, 123, 122, 124, // 15088-15095
126, 127, 128, 126, 127, 128, 126, 127, // 15096-15103
124, 121, 123, 123, 123, 124, 125, 126, // 15104-15111
126, 127, 129, 128, 129, 131, 130, 129, // 15112-15119
128, 128, 128, 126, 124, 125, 126, 127, // 15120-15127
129, 130, 132, 133, 134, 134, 133, 133, // 15128-15135
134, 133, 130, 129, 124, 123, 122, 120, // 15136-15143
120, 117, 116, 119, 120, 120, 123, 123, // 15144-15151
123, 125, 126, 129, 128, 129, 129, 128, // 15152-15159
129, 130, 131, 131, 130, 131, 130, 131, // 15160-15167
133, 131, 130, 131, 130, 130, 130, 129, // 15168-15175
127, 125, 125, 123, 123, 123, 123, 124, // 15176-15183
124, 125, 126, 126, 126, 128, 129, 131, // 15184-15191
132, 128, 128, 126, 125, 125, 124, 124, // 15192-15199
123, 123, 124, 126, 127, 126, 125, 125, // 15200-15207
127, 129, 128, 130, 128, 126, 127, 126, // 15208-15215
126, 127, 128, 129, 131, 132, 134, 135, // 15216-15223
134, 135, 133, 132, 131, 128, 126, 124, // 15224-15231
122, 122, 120, 120, 119, 118, 121, 124, // 15232-15239
125, 126, 125, 125, 127, 128, 129, 128, // 15240-15247
127, 125, 125, 125, 128, 128, 128, 128, // 15248-15255
128, 129, 131, 133, 133, 132, 131, 130, // 15256-15263
132, 131, 130, 127, 123, 122, 121, 121, // 15264-15271
123, 123, 122, 121, 124, 127, 128, 130, // 15272-15279
132, 132, 130, 131, 131, 130, 129, 127, // 15280-15287
124, 123, 124, 122, 123, 123, 124, 125, // 15288-15295
125, 127, 129, 129, 132, 130, 129, 129, // 15296-15303
126, 126, 125, 125, 127, 126, 127, 129, // 15304-15311
130, 130, 133, 131, 132, 133, 132, 132, // 15312-15319
131, 129, 126, 123, 121, 120, 122, 121, // 15320-15327
121, 120, 121, 124, 123, 125, 126, 125, // 15328-15335
127, 127, 127, 129, 128, 128, 128, 127, // 15336-15343
129, 131, 130, 132, 131, 131, 130, 131, // 15344-15351
130, 129, 129, 129, 129, 128, 126, 124, // 15352-15359
122, 122, 122, 123, 124, 125, 124, 125, // 15360-15367
128, 127, 129, 128, 128, 129, 129, 131, // 15368-15375
129, 128, 127, 124, 123, 124, 126, 125, // 15376-15383
125, 126, 128, 128, 130, 130, 127, 127, // 15384-15391
127, 126, 126, 125, 126, 125, 124, 126, // 15392-15399
127, 130, 129, 131, 132, 134, 136, 135, // 15400-15407
134, 132, 129, 128, 125, 123, 122, 119, // 15408-15415
119, 120, 121, 123, 122, 122, 125, 126, // 15416-15423
126, 128, 128, 127, 127, 128, 129, 127, // 15424-15431
125, 126, 126, 128, 130, 131, 131, 131, // 15432-15439
132, 132, 132, 133, 130, 129, 128, 128, // 15440-15447
128, 127, 125, 123, 121, 121, 121, 124, // 15448-15455
125, 123, 125, 126, 128, 129, 131, 130, // 15456-15463
131, 129, 130, 130, 126, 126, 126, 124, // 15464-15471
123, 124, 124, 124, 125, 127, 127, 128, // 15472-15479
129, 129, 128, 128, 129, 127, 125, 125, // 15480-15487
124, 123, 124, 125, 126, 128, 130, 132, // 15488-15495
132, 135, 134, 132, 131, 129, 129, 129, // 15496-15503
126, 125, 122, 120, 121, 121, 123, 122, // 15504-15511
123, 124, 124, 125, 127, 127, 125, 126, // 15512-15519
127, 128, 126, 128, 128, 127, 128, 130, // 15520-15527
132, 132, 132, 134, 132, 132, 132, 132, // 15528-15535
130, 129, 128, 128, 126, 125, 124, 121, // 15536-15543
121, 121, 121, 122, 123, 125, 126, 127, // 15544-15551
128, 128, 129, 128, 129, 130, 130, 129, // 15552-15559
127, 126, 125, 124, 124, 125, 124, 126, // 15560-15567
128, 129, 131, 131, 131, 130, 128, 128, // 15568-15575
127, 125, 125, 123, 123, 124, 126, 126, // 15576-15583
127, 129, 130, 131, 132, 135, 135, 134, // 15584-15591
132, 131, 128, 125, 123, 120, 119, 121, // 15592-15599
120, 122, 122, 122, 123, 124, 125, 126, // 15600-15607
127, 127, 127, 128, 128, 127, 127, 126, // 15608-15615
125, 127, 129, 130, 131, 132, 133, 134, // 15616-15623
134, 134, 133, 132, 130, 130, 129, 127, // 15624-15631
125, 124, 121, 122, 121, 120, 121, 121, // 15632-15639
123, 124, 126, 127, 128, 129, 129, 130, // 15640-15647
130, 128, 129, 128, 127, 125, 125, 126, // 15648-15655
125, 125, 125, 126, 128, 129, 129, 129, // 15656-15663
129, 128, 129, 128, 126, 126, 124, 123, // 15664-15671
123, 124, 125, 125, 127, 130, 131, 133, // 15672-15679
134, 134, 133, 133, 131, 129, 127, 126, // 15680-15687
125, 122, 121, 121, 121, 121, 122, 124, // 15688-15695
125, 126, 127, 127, 128, 127, 127, 127, // 15696-15703
126, 126, 126, 127, 127, 128, 130, 131, // 15704-15711
131, 132, 132, 131, 132, 132, 132, 129, // 15712-15719
129, 128, 127, 125, 125, 124, 124, 122, // 15720-15727
121, 122, 123, 124, 124, 125, 126, 126, // 15728-15735
128, 128, 128, 129, 128, 127, 128, 128, // 15736-15743
127, 126, 126, 126, 125, 126, 127, 128, // 15744-15751
130, 130, 130, 129, 128, 127, 127, 124, // 15752-15759
124, 124, 124, 124, 124, 126, 128, 128, // 15760-15767
130, 130, 131, 133, 133, 132, 132, 131, // 15768-15775
127, 125, 123, 122, 121, 121, 122, 123, // 15776-15783
124, 125, 127, 128, 127, 126, 126, 127, // 15784-15791
127, 128, 128, 126, 126, 125, 125, 126, // 15792-15799
127, 128, 129, 130, 133, 133, 133, 132, // 15800-15807
131, 130, 129, 128, 129, 128, 126, 125, // 15808-15815
124, 124, 123, 122, 123, 123, 125, 124, // 15816-15823
125, 127, 127, 128, 129, 129, 128, 128, // 15824-15831
128, 127, 126, 126, 125, 124, 124, 123, // 15832-15839
125, 126, 127, 128, 128, 130, 130, 130, // 15840-15847
130, 129, 127, 126, 126, 126, 125, 125, // 15848-15855
125, 126, 127, 129, 131, 132, 132, 132, // 15856-15863
132, 131, 131, 128, 126, 125, 123, 122, // 15864-15871
122, 122, 123, 122, 122, 125, 126, 126, // 15872-15879
126, 126, 127, 127, 127, 127, 125, 124, // 15880-15887
124, 126, 128, 128, 129, 130, 131, 133, // 15888-15895
134, 133, 132, 130, 129, 129, 128, 127, // 15896-15903
127, 125, 124, 123, 124, 124, 124, 123, // 15904-15911
124, 126, 127, 128, 128, 128, 128, 128, // 15912-15919
127, 127, 127, 126, 126, 126, 127, 126, // 15920-15927
124, 125, 125, 126, 126, 127, 128, 128, // 15928-15935
129, 130, 130, 130, 127, 126, 125, 125, // 15936-15943
125, 125, 125, 126, 127, 129, 131, 133, // 15944-15951
132, 131, 132, 134, 133, 133, 130, 126, // 15952-15959
123, 121, 120, 120, 119, 121, 121, 122, // 15960-15967
125, 127, 128, 128, 127, 126, 127, 127, // 15968-15975
128, 126, 125, 125, 126, 125, 126, 127, // 15976-15983
128, 129, 131, 134, 134, 133, 131, 131, // 15984-15991
130, 128, 128, 127, 126, 126, 125, 123, // 15992-15999
124, 124, 123, 123, 125, 127, 127, 127, // 16000-16007
128, 129, 129, 129, 129, 129, 127, 127, // 16008-16015
127, 126, 125, 124, 123, 123, 125, 125, // 16016-16023
126, 127, 127, 128, 129, 130, 130, 128, // 16024-16031
127, 126, 125, 126, 126, 125, 125, 126, // 16032-16039
128, 130, 132, 132, 132, 132, 133, 132, // 16040-16047
131, 131, 128, 124, 123, 122, 121, 120, // 16048-16055
121, 121, 122, 124, 125, 127, 127, 126, // 16056-16063
124, 125, 126, 127, 126, 125, 125, 126, // 16064-16071
126, 127, 129, 130, 131, 132, 134, 134, // 16072-16079
134, 132, 131, 129, 126, 126, 127, 126, // 16080-16087
126, 126, 125, 124, 124, 125, 125, 125, // 16088-16095
125, 126, 126, 126, 126, 127, 127, 126, // 16096-16103
126, 126, 127, 127, 127, 127, 126, 126, // 16104-16111
126, 126, 127, 126, 126, 127, 127, 128, // 16112-16119
129, 128, 129, 127, 126, 125, 125, 126, // 16120-16127
125, 125, 127, 128, 129, 131, 132, 132, // 16128-16135
132, 132, 132, 131, 130, 129, 127, 125, // 16136-16143
123, 122, 121, 121, 121, 122, 124, 126, // 16144-16151
127, 127, 127, 127, 125, 124, 125, 126, // 16152-16159
124, 123, 125, 125, 126, 127, 128, 129, // 16160-16167
131, 132, 133, 133, 133, 133, 132, 130, // 16168-16175
130, 128, 128, 127, 127, 127, 125, 126, // 16176-16183
126, 125, 125, 125, 125, 124, 124, 126, // 16184-16191
126, 126, 126, 126, 126, 126, 126, 127, // 16192-16199
127, 126, 126, 126, 125, 127, 128, 127, // 16200-16207
127, 127, 128, 128, 129, 129, 128, 127, // 16208-16215
127, 127, 126, 125, 126, 125, 126, 127, // 16216-16223
130, 132, 131, 130, 131, 131, 130, 129, // 16224-16231
128, 127, 126, 124, 125, 124, 125, 126, // 16232-16239
125, 125, 126, 127, 127, 126, 126, 124, // 16240-16247
122, 122, 124, 122, 123, 124, 124, 126, // 16248-16255
126, 128, 130, 130, 132, 133, 132, 132, // 16256-16263
132, 130, 129, 127, 126, 126, 127, 128, // 16264-16271
127, 127, 127, 128, 128, 127, 127, 128, // 16272-16279
127, 127, 126, 126, 125, 124, 124, 123, // 16280-16287
122, 123, 125, 125, 126, 126, 126, 126, // 16288-16295
127, 129, 127, 128, 129, 129, 129, 129, // 16296-16303
129, 128, 126, 126, 126, 125, 125, 126, // 16304-16311
126, 126, 128, 129, 130, 131, 131, 131, // 16312-16319
130, 130, 131, 129, 126, 126, 125, 124, // 16320-16327
123, 123, 124, 125, 125, 127, 128, 128, // 16328-16335
130, 128, 128, 126, 126, 125, 124, 123, // 16336-16343
124, 124, 125, 126, 127, 127, 128, 130, // 16344-16351
130, 130, 130, 130, 130, 129, 129, 128, // 16352-16359
127, 126, 127, 128, 128, 128, 128, 129, // 16360-16367
128, 128, 128, 127, 127, 126, 126, 126, // 16368-16375
125, 126, 126, 125, 126, 126, 127, 127, // 16376-16383
127, 125, 124, 126, 127, 128, 126, 127, // 16384-16391
126, 126, 126, 128, 128, 127, 126, 127, // 16392-16399
129, 130, 129, 128, 127, 127, 129, 130, // 16400-16407
131, 131, 130, 128, 127, 128, 127, 125, // 16408-16415
125, 124, 124, 124, 125, 126, 126, 126, // 16416-16423
128, 128, 128, 128, 127, 126, 125, 124, // 16424-16431
124, 123, 123, 123, 124, 126, 127, 130, // 16432-16439
130, 130, 131, 131, 132, 132, 131, 129, // 16440-16447
126, 126, 125, 124, 124, 125, 125, 126, // 16448-16455
128, 128, 129, 128, 129, 129, 129, 128, // 16456-16463
128, 128, 127, 126, 126, 124, 125, 125, // 16464-16471
125, 126, 128, 127, 127, 126, 127, 129, // 16472-16479
128, 128, 127, 127, 126, 127, 127, 126, // 16480-16487
126, 125, 124, 125, 127, 127, 125, 126, // 16488-16495
127, 129, 129, 131, 131, 130, 129, 128, // 16496-16503
129, 129, 128, 127, 125, 126, 127, 126, // 16504-16511
126, 125, 125, 125, 125, 128, 128, 127, // 16512-16519
126, 126, 126, 126, 125, 125, 126, 125, // 16520-16527
127, 128, 129, 129, 128, 129, 129, 129, // 16528-16535
129, 128, 127, 127, 127, 126, 126, 126, // 16536-16543
126, 125, 127, 127, 128, 126, 127, 126, // 16544-16551
127, 127, 127, 125, 125, 125, 125, 127, // 16552-16559
126, 127, 127, 129, 130, 131, 131, 130, // 16560-16567
129, 128, 129, 129, 129, 127, 126, 125, // 16568-16575
125, 125, 124, 124, 124, 124, 126, 128, // 16576-16583
129, 128, 126, 127, 127, 127, 128, 127, // 16584-16591
127, 126, 127, 127, 127, 127, 126, 125, // 16592-16599
126, 128, 129, 129, 129, 129, 127, 128, // 16600-16607
129, 127, 125, 124, 124, 124, 125, 126, // 16608-16615
124, 123, 124, 126, 128, 129, 130, 130, // 16616-16623
130, 131, 132, 131, 130, 128, 126, 126, // 16624-16631
126, 126, 124, 124, 124, 125, 126, 126, // 16632-16639
128, 127, 127, 126, 127, 128, 127, 126, // 16640-16647
124, 125, 126, 125, 125, 125, 126, 127, // 16648-16655
128, 129, 129, 129, 129, 129, 131, 131, // 16656-16663
129, 127, 127, 127, 128, 127, 125, 124, // 16664-16671
124, 125, 126, 128, 128, 126, 126, 126, // 16672-16679
127, 128, 128, 127, 127, 127, 127, 127, // 16680-16687
127, 127, 126, 126, 127, 129, 128, 127, // 16688-16695
127, 127, 127, 127, 127, 126, 127, 126, // 16696-16703
126, 126, 126, 125, 124, 124, 126, 128, // 16704-16711
127, 128, 128, 129, 129, 130, 129, 128, // 16712-16719
128, 127, 127, 127, 128, 127, 126, 127, // 16720-16727
128, 129, 128, 128, 128, 127, 126, 126, // 16728-16735
127, 126, 124, 123, 123, 124, 124, 124, // 16736-16743
124, 126, 127, 129, 130, 130, 130, 129, // 16744-16751
129, 128, 129, 127, 128, 127, 127, 126, // 16752-16759
126, 125, 125, 127, 127, 128, 128, 129, // 16760-16767
129, 129, 128, 128, 127, 126, 125, 125, // 16768-16775
126, 126, 127, 125, 125, 126, 126, 126, // 16776-16783
127, 129, 130, 129, 130, 130, 129, 127, // 16784-16791
127, 126, 125, 124, 125, 125, 125, 124, // 16792-16799
125, 126, 126, 127, 127, 128, 130, 130, // 16800-16807
130, 129, 128, 129, 129, 127, 126, 126, // 16808-16815
125, 125, 126, 128, 128, 127, 128, 128, // 16816-16823
129, 128, 128, 127, 128, 127, 126, 126, // 16824-16831
125, 125, 123, 123, 124, 126, 126, 127, // 16832-16839
127, 128, 128, 129, 129, 128, 128, 127, // 16840-16847
128, 128, 128, 127, 126, 125, 127, 127, // 16848-16855
126, 127, 128, 129, 127, 128, 128, 127, // 16856-16863
126, 126, 126, 128, 127, 128, 125, 126, // 16864-16871
125, 128, 125, 127, 126, 128, 128, 128, // 16872-16879
129, 128, 134, 165, 170, 144, 107,  81, // 16880-16887
 81,  73,  99,  69,  52, 124, 179, 192, // 16888-16895
212, 181, 121, 139, 206,   0, 195, 130, // 16896-16903
122,  41,  12,  57, 108, 104,  68, 126, // 16904-16911
168, 241, 221, 135, 102,  48,  45,  83, // 16912-16919
 33, 229, 224, 225,   1,  16,  57,  74, // 16920-16927
 51, 108, 188, 216, 236, 226, 223, 203, // 16928-16935
188, 233, 188, 122,  94,  90,  83, 119, // 16936-16943
182, 148,  67,  76, 143, 165, 199, 140, // 16944-16951
137, 199, 213,  39,  19, 206, 165,  81, // 16952-16959
 99, 144, 156, 179, 120, 114, 159, 172, // 16960-16967
162, 146, 119, 102,  68,  82, 201, 126, // 16968-16975
230, 164, 141, 158, 166, 223, 219, 243, // 16976-16983
 97, 165, 216, 240,  12, 241, 188,  25, // 16984-16991
 79,  34, 244, 221, 202, 125, 122, 174, // 16992-16999
168, 130, 188, 211, 226,  17, 195, 133, // 17000-17007
 69,  56,  79,  17, 224, 214, 215, 239, // 17008-17015
251,  32,  40,  23,  93, 146, 180, 198, // 17016-17023
196, 195, 177, 171, 209, 167, 107,  93, // 17024-17031
 76,  94,  81, 150, 176,  86,  89, 142, // 17032-17039
155, 178, 166, 115, 140, 182, 255, 252, // 17040-17047
178, 173, 125,  83, 117, 154, 174, 131, // 17048-17055
127, 180, 179, 180, 148, 136, 103,  85, // 17056-17063
 96, 110, 148,  59, 207, 171, 165, 179, // 17064-17071
219, 213, 236,  87, 143, 191, 218, 233, // 17072-17079
  2, 194, 223,  46, 254, 240, 210, 213, // 17080-17087
179, 116, 165, 158, 146, 193, 231, 214, // 17088-17095
237, 239, 168,  96,  78,  87,  19, 229, // 17096-17103
219, 220, 242, 252,  33,  39,  17, 103, // 17104-17111
150, 162, 190, 182, 192, 168, 176, 202, // 17112-17119
161, 107,  96,  81,  95,  94, 109, 167, // 17120-17127
125, 117, 151, 160, 166, 171, 141, 102, // 17128-17135
151, 226, 222, 173, 157, 153, 116,  87, // 17136-17143
140, 163, 131, 141, 189, 193, 186, 163, // 17144-17151
140, 120,  84, 124,  80,  80, 121,  15, // 17152-17159
212, 185, 189, 220, 204, 235,  73, 127, // 17160-17167
165, 195, 207, 228, 218, 206, 239, 227, // 17168-17175
215, 213, 200, 212, 149, 145, 147, 145, // 17176-17183
203, 225, 232, 205, 228, 212, 124, 106, // 17184-17191
 95,  28, 240, 226, 229, 247,   2,  34, // 17192-17199
 37,  22,  90, 160, 155, 169, 174, 179, // 17200-17207
164, 171, 200, 150, 111,  94,  91,  94, // 17208-17215
102, 113, 124, 138, 154, 163, 164, 164, // 17216-17223
156, 162, 105, 113, 199, 189, 161, 150, // 17224-17231
144, 151, 103, 111, 154, 126, 156, 194, // 17232-17239
202, 192, 171, 149, 126, 100, 122, 100, // 17240-17247
 26,  94,  88,   6, 221, 207, 229, 205, // 17248-17255
240,  66, 111, 148, 167, 190, 198, 206, // 17256-17263
233, 194, 181, 192, 198, 200, 202, 195, // 17264-17271
146, 128, 144, 207, 225, 231, 214, 191, // 17272-17279
218, 165, 132, 112,  38, 253, 235, 237, // 17280-17287
253,   5,  38,  28,  30,  84, 145, 173, // 17288-17295
152, 162, 169, 157, 170, 192, 146, 111, // 17296-17303
100,  93, 105,  99, 125, 107, 111, 181, // 17304-17311
185, 169, 168, 150, 159, 129, 100, 161, // 17312-17319
163, 140, 145, 138, 152, 139, 107, 123, // 17320-17327
121, 155, 200, 200, 201, 173, 161, 129, // 17328-17335
117, 128, 103,  39,  36, 104,  73,   5, // 17336-17343
238, 237, 211, 243,  60,  97, 132, 149, // 17344-17351
168, 183, 183, 237, 204, 137, 167, 177, // 17352-17359
199, 195, 205, 183, 115, 142, 200, 228, // 17360-17367
226, 218, 189, 187, 190, 168, 127,  52, // 17368-17375
 10, 247, 245,   3,  11,  39,  27,  30, // 17376-17383
 94, 122, 172, 163, 138, 158, 145, 171, // 17384-17391
183, 143, 111, 102,  97, 107, 106, 122, // 17392-17399
116,  91, 169, 211, 185, 171, 154, 147, // 17400-17407
140, 118, 129, 134, 125, 132, 136, 144, // 17408-17415
150, 141, 103, 106, 155, 197, 205, 203, // 17416-17423
181, 165, 141, 124, 141,  97,  58,  25, // 17424-17431
 59, 115,  57,  17, 254, 219, 251,  55, // 17432-17439
 88, 118, 132, 150, 162, 171, 212, 212, // 17440-17447
136, 128, 158, 182, 196, 197, 210, 131, // 17448-17455
129, 197, 220, 231, 212, 204, 174, 175, // 17456-17463
202, 148,  71,  29,   2,   2,   8,  18, // 17464-17471
 38,  27,  30,  93, 118, 143, 178, 141, // 17472-17479
139, 140, 163, 178, 133, 115,  99, 103, // 17480-17487
107, 113, 123, 114, 101, 144, 206, 210, // 17488-17495
177, 159, 145, 132, 141, 126, 103, 109, // 17496-17503
118, 128, 143, 143, 161, 120,  84, 148, // 17504-17511
189, 205, 201, 184, 171, 147, 136, 147, // 17512-17519
105,  63,  48,  33,  97, 107,  60,  23, // 17520-17527
234,   6,  54,  79, 106, 115, 134, 141, // 17528-17535
159, 196, 189, 155, 113, 129, 167, 187, // 17536-17543
197, 205, 165, 132, 186, 213, 228, 212, // 17544-17551
198, 183, 156, 201, 177,  90,  49,  19, // 17552-17559
 15,  17,  25,  43,  24,  39,  87, 122, // 17560-17567
129, 156, 165, 125, 127, 155, 167, 130, // 17568-17575
113, 106, 105, 115, 114, 129, 108, 108, // 17576-17583
141, 176, 216, 194, 160, 152, 126, 147, // 17584-17591
140,  83,  88, 107, 121, 140, 144, 158, // 17592-17599
147,  93, 131, 182, 197, 201, 183, 176, // 17600-17607
150, 149, 152, 112,  69,  56,  40,  63, // 17608-17615
112, 105,  50, 255,  19,  56,  75,  96, // 17616-17623
105, 120, 128, 143, 186, 171, 153, 135, // 17624-17631
108, 148, 171, 195, 196, 175, 161, 169, // 17632-17639
203, 215, 211, 196, 184, 162, 178, 183, // 17640-17647
120,  69,  40,  29,  28,  31,  46,  27, // 17648-17655
 43,  90, 110, 132, 127, 163, 147, 111, // 17656-17663
151, 154, 127, 112, 109, 109, 116, 118, // 17664-17671
130, 113, 108, 150, 161, 191, 208, 171, // 17672-17679
152, 130, 139, 151,  88,  70,  93, 113, // 17680-17687
132, 142, 155, 145, 124, 124, 162, 187, // 17688-17695
194, 184, 175, 155, 152, 158, 114,  82, // 17696-17703
 63,  58,  57,  86, 126,  87,  29,  39, // 17704-17711
 61,  74,  88,  95, 111, 116, 134, 167, // 17712-17719
159, 136, 143, 120, 122, 154, 182, 191, // 17720-17727
167, 187, 179, 184, 209, 203, 200, 179, // 17728-17735
173, 175, 161, 140,  98,  61,  48,  37, // 17736-17743
 41,  46,  32,  46,  91, 105, 125, 125, // 17744-17751
134, 164, 124, 135, 145, 117, 114, 108, // 17752-17759
115, 116, 123, 129, 113, 114, 149, 164, // 17760-17767
167, 190, 191, 159, 139, 142, 145, 106, // 17768-17775
 64,  75, 102, 123, 135, 152, 137, 138, // 17776-17783
149, 145, 173, 184, 182, 175, 158, 160, // 17784-17791
160, 120,  93,  76,  67,  67,  69, 114, // 17792-17799
114,  65,  63,  72,  76,  84,  88, 101, // 17800-17807
103, 123, 151, 142, 131, 134, 139, 123, // 17808-17815
132, 169, 181, 166, 192, 203, 175, 193, // 17816-17823
196, 196, 181, 170, 182, 148, 130, 124, // 17824-17831
 85,  67,  51,  51,  53,  34,  56,  89, // 17832-17839
106, 115, 125, 123, 142, 150, 130, 129, // 17840-17847
111, 110, 108, 113, 118, 122, 131, 113, // 17848-17855
123, 151, 162, 165, 165, 188, 176, 142, // 17856-17863
150, 135, 111,  82,  64,  92, 114, 129, // 17864-17871
148, 141, 138, 171, 156, 153, 173, 175, // 17872-17879
176, 159, 165, 160, 121,  97,  84,  75, // 17880-17887
 75,  68,  93, 111,  96,  91,  86,  82, // 17888-17895
 84,  86,  94,  98, 117, 142, 127, 125, // 17896-17903
125, 132, 137, 119, 148, 165, 162, 187, // 17904-17911
211, 190, 177, 189, 191, 183, 175, 183, // 17912-17919
152, 120, 128, 110,  83,  66,  60,  61, // 17920-17927
 42,  64,  91, 103, 114, 116, 128, 119, // 17928-17935
149, 153, 111, 102, 102, 104, 109, 114, // 17936-17943
122, 128, 115, 126, 155, 161, 167, 161, // 17944-17951
169, 184, 158, 155, 140, 108, 102,  72, // 17952-17959
 78, 104, 124, 141, 134, 139, 168, 176, // 17960-17967
152, 156, 167, 168, 157, 165, 160, 125, // 17968-17975
104,  91,  83,  81,  79,  86,  95, 107, // 17976-17983
118, 100,  91,  86,  86,  91,  90, 110, // 17984-17991
129, 118, 112, 119, 121, 138, 130, 132, // 17992-17999
148, 157, 185, 204, 207, 181, 176, 188, // 18000-18007
176, 180, 183, 156, 126, 117, 124, 109, // 18008-18015
 82,  78,  69,  55,  70,  95, 102, 114, // 18016-18023
111, 120, 116, 123, 165, 121,  87,  97, // 18024-18031
 99, 109, 110, 123, 127, 115, 127, 152, // 18032-18039
159, 163, 159, 155, 165, 172, 164, 143, // 18040-18047
108, 103,  90,  74,  93, 117, 137, 129, // 18048-18055
141, 165, 177, 171, 146, 154, 160, 155, // 18056-18063
165, 159, 129, 112,  97,  91,  89,  90, // 18064-18071
 93,  87, 104, 133, 125, 104,  95,  88, // 18072-18079
 90,  85, 105, 119, 108, 107, 110, 118, // 18080-18087
126, 138, 134, 127, 142, 179, 194, 204, // 18088-18095
193, 166, 177, 172, 177, 183, 155, 134, // 18096-18103
116, 117, 128, 103,  92,  78,  62,  80, // 18104-18111
 96, 105, 110, 113, 114, 117, 115, 148, // 18112-18119
144,  91,  87,  97, 107, 111, 121, 125, // 18120-18127
114, 129, 148, 157, 161, 157, 156, 148, // 18128-18135
163, 178, 146, 117, 101, 100,  88,  82, // 18136-18143
108, 127, 124, 136, 164, 169, 179, 157, // 18144-18151
144, 152, 152, 166, 159, 132, 118, 105, // 18152-18159
 99,  95,  95, 101,  83,  97, 130, 139, // 18160-18167
123, 101,  92,  89,  86, 101, 113,  99, // 18168-18175
102, 103, 115, 122, 131, 144, 122, 126, // 18176-18183
168, 188, 194, 198, 174, 165, 167, 173, // 18184-18191
181, 154, 137, 125, 113, 123, 123, 107, // 18192-18199
 88,  71,  89, 100, 107, 109, 110, 115, // 18200-18207
110, 120, 128, 138, 116,  84,  91, 105, // 18208-18215
112, 121, 125, 116, 133, 149, 155, 159, // 18216-18223
153, 153, 143, 144, 174, 154, 121, 106, // 18224-18231
 99, 105,  86,  98, 120, 120, 135, 160, // 18232-18239
168, 171, 169, 148, 139, 145, 161, 154, // 18240-18247
132, 122, 112, 107, 102, 100, 105,  89, // 18248-18255
 94, 126, 139, 140, 114, 101,  92,  85, // 18256-18263
100, 104,  93,  92,  99, 109, 121, 126, // 18264-18271
145, 134, 122, 154, 182, 191, 192, 183, // 18272-18279
162, 155, 171, 175, 154, 137, 127, 120, // 18280-18287
117, 128, 129,  99,  80,  92, 105, 108, // 18288-18295
110, 107, 111, 104, 116, 126, 117, 126, // 18296-18303
100,  85, 101, 110, 125, 123, 117, 134, // 18304-18311
149, 154, 157, 152, 151, 144, 140, 158, // 18312-18319
160, 129, 112, 100, 106, 100,  94, 110, // 18320-18327
111, 134, 154, 166, 168, 165, 161, 134, // 18328-18335
135, 158, 152, 134, 124, 117, 115, 108, // 18336-18343
107, 107,  94,  95, 121, 134, 141, 132, // 18344-18351
108,  95,  84,  98,  99,  90,  92,  97, // 18352-18359
107, 117, 128, 136, 135, 131, 144, 167, // 18360-18367
186, 187, 189, 173, 151, 165, 169, 149, // 18368-18375
139, 128, 125, 119, 118, 136, 115,  92, // 18376-18383
100, 104, 109, 109, 108, 108, 105, 113, // 18384-18391
125, 108, 114, 120,  92,  93, 106, 121, // 18392-18399
122, 119, 136, 148, 152, 155, 151, 152, // 18400-18407
141, 144, 149, 147, 144, 124, 110, 107, // 18408-18415
108, 100,  99, 106, 128, 151, 157, 167, // 18416-18423
160, 162, 148, 131, 148, 145, 130, 127, // 18424-18431
119, 118, 110, 109, 107,  95, 101, 116, // 18432-18439
132, 139, 140, 128, 105,  95, 103, 100, // 18440-18447
 87,  91,  92, 103, 112, 123, 132, 128, // 18448-18455
138, 147, 152, 175, 181, 181, 181, 156, // 18456-18463
160, 164, 147, 139, 131, 126, 124, 116, // 18464-18471
126, 125, 105, 109, 107, 110, 109, 108, // 18472-18479
109, 105, 114, 120, 107, 102, 118, 113, // 18480-18487
 94,  98, 115, 118, 118, 136, 146, 150, // 18488-18495
152, 148, 151, 145, 147, 153, 136, 141, // 18496-18503
136, 119, 115, 109, 112,  97,  98, 125, // 18504-18511
145, 153, 158, 156, 154, 153, 140, 139, // 18512-18519
137, 129, 126, 122, 122, 117, 113, 109, // 18520-18527
 95, 105, 116, 124, 138, 132, 135, 117, // 18528-18535
102, 108,  99,  88,  88,  92, 103, 113, // 18536-18543
120, 130, 124, 135, 153, 148, 159, 172, // 18544-18551
173, 178, 166, 158, 159, 145, 138, 133, // 18552-18559
130, 128, 123, 121, 121, 123, 120, 116, // 18560-18567
113, 109, 106, 108, 104, 115, 117, 105, // 18568-18575
101, 104, 123, 111,  96, 110, 113, 116, // 18576-18583
136, 146, 150, 150, 145, 146, 143, 145, // 18584-18591
150, 133, 126, 136, 128, 122, 113, 116, // 18592-18599
106,  92, 119, 140, 152, 154, 153, 153, // 18600-18607
150, 151, 142, 128, 125, 123, 123, 124, // 18608-18615
120, 119, 112, 101, 110, 122, 122, 133, // 18616-18623
133, 131, 129, 112, 113, 100,  87,  86, // 18624-18631
 88,  99, 106, 115, 121, 120, 131, 152, // 18632-18639
156, 152, 160, 169, 170, 171, 165, 152, // 18640-18647
143, 138, 133, 133, 129, 125, 123, 113, // 18648-18655
125, 132, 124, 120, 113, 112, 109, 108, // 18656-18663
116, 117, 104, 101,  99, 114, 123, 104, // 18664-18671
103, 107, 113, 134, 145, 149, 149, 146, // 18672-18679
144, 142, 147, 146, 134, 123, 125, 133, // 18680-18687
126, 118, 116, 111,  96, 110, 133, 145, // 18688-18695
151, 149, 151, 145, 151, 152, 127, 120, // 18696-18703
123, 124, 127, 123, 124, 117, 107, 113, // 18704-18711
124, 127, 127, 135, 132, 129, 125, 118, // 18712-18719
104,  89,  88,  88,  96, 102, 113, 118, // 18720-18727
116, 130, 147, 158, 155, 150, 161, 163, // 18728-18735
166, 171, 150, 137, 136, 132, 133, 131, // 18736-18743
129, 127, 114, 120, 138, 134, 127, 118, // 18744-18751
113, 110, 106, 113, 112, 103, 100, 100, // 18752-18759
105, 118, 119, 110, 108, 116, 131, 141, // 18760-18767
145, 146, 144, 141, 138, 141, 140, 131, // 18768-18775
126, 122, 127, 130, 127, 125, 120, 118, // 18776-18783
121, 130, 137, 139, 139, 137, 135, 136, // 18784-18791
138, 130, 122, 121, 121, 124, 125, 123, // 18792-18799
122, 120, 121, 125, 129, 128, 128, 128, // 18800-18807
126, 128, 127, 122, 117, 114, 116, 117, // 18808-18815
117, 121, 123, 123, 128, 133, 137, 139, // 18816-18823
137, 138, 138, 137, 139, 135, 129, 127, // 18824-18831
126, 125, 124, 125, 124, 123, 125, 129, // 18832-18839
132, 130, 130, 127, 124, 126, 126, 124, // 18840-18847
121, 118, 118, 120, 121, 123, 122, 122, // 18848-18855
125, 128, 132, 135, 132, 131, 130, 131, // 18856-18863
131, 131, 128, 126, 126, 127, 128, 129, // 18864-18871
129, 127, 125, 128, 131, 131, 130, 129, // 18872-18879
128, 126, 128, 127, 126, 124, 122, 124, // 18880-18887
123, 125, 125, 124, 123, 125, 128, 128, // 18888-18895
128, 128, 128, 127, 128, 128, 127, 125, // 18896-18903
124, 124, 125, 126, 125, 125, 124, 125, // 18904-18911
130, 130, 131, 133, 132, 131, 132, 132, // 18912-18919
131, 127, 125, 126, 126, 127, 129, 127, // 18920-18927
125, 128, 130, 131, 129, 130, 129, 125, // 18928-18935
125, 126, 124, 118, 118, 118, 119, 122, // 18936-18943
123, 125, 125, 128, 131, 132, 132, 132, // 18944-18951
129, 128, 129, 131, 129, 126, 126, 126, // 18952-18959
127, 128, 131, 130, 129, 129, 130, 132, // 18960-18967
131, 130, 127, 124, 124, 125, 125, 123, // 18968-18975
123, 124, 124, 125, 126, 126, 126, 125, // 18976-18983
126, 129, 128, 129, 129, 127, 127, 127, // 18984-18991
127, 125, 124, 126, 125, 125, 126, 126, // 18992-18999
125, 125, 126, 128, 129, 130, 130, 131, // 19000-19007
132, 132, 131, 128, 127, 126, 125, 126, // 19008-19015
126, 127, 126, 125, 126, 130, 129, 127, // 19016-19023
129, 130, 128, 126, 127, 125, 121, 120, // 19024-19031
120, 121, 122, 124, 125, 126, 128, 131, // 19032-19039
130, 129, 131, 130, 129, 129, 131, 130, // 19040-19047
126, 127, 128, 127, 127, 128, 129, 128, // 19048-19055
129, 131, 130, 128, 127, 127, 125, 124, // 19056-19063
124, 125, 124, 125, 127, 126, 126, 126, // 19064-19071
126, 126, 126, 129, 129, 128, 128, 128, // 19072-19079
128, 127, 127, 127, 124, 125, 127, 128, // 19080-19087
127, 126, 127, 126, 126, 127, 128, 127, // 19088-19095
127, 129, 129, 130, 129, 128, 126, 125, // 19096-19103
126, 127, 126, 126, 128, 128, 127, 129, // 19104-19111
130, 129, 128, 128, 130, 128, 127, 127, // 19112-19119
124, 122, 121, 122, 121, 122, 124, 126, // 19120-19127
127, 129, 131, 130, 131, 130, 131, 129, // 19128-19135
128, 130, 128, 126, 127, 128, 128, 126, // 19136-19143
127, 129, 129, 131, 132, 131, 129, 128, // 19144-19151
127, 126, 124, 124, 122, 120, 123, 125, // 19152-19159
125, 124, 124, 126, 125, 126, 129, 129, // 19160-19167
127, 128, 129, 129, 129, 128, 126, 125, // 19168-19175
125, 127, 128, 129, 128, 127, 126, 127, // 19176-19183
128, 127, 127, 126, 128, 129, 130, 130, // 19184-19191
128, 127, 126, 125, 127, 127, 126, 127, // 19192-19199
127, 127, 128, 128, 128, 127, 127, 129, // 19200-19207
129, 128, 128, 125, 125, 124, 123, 123, // 19208-19215
122, 123, 124, 125, 128, 131, 129, 127, // 19216-19223
128, 129, 128, 128, 128, 126, 127, 128, // 19224-19231
129, 129, 128, 127, 127, 129, 132, 131, // 19232-19239
131, 130, 127, 128, 126, 125, 124, 122, // 19240-19247
122, 124, 126, 129, 128, 125, 126, 126, // 19248-19255
126, 126, 127, 126, 126, 128, 128, 128, // 19256-19263
128, 125, 124, 124, 127, 129, 128, 129, // 19264-19271
129, 127, 128, 128, 126, 126, 125, 126, // 19272-19279
128, 130, 131, 128, 126, 127, 126, 125, // 19280-19287
126, 126, 127, 128, 130, 130, 130, 130, // 19288-19295
127, 125, 127, 129, 128, 127, 126, 124, // 19296-19303
123, 124, 123, 122, 123, 123, 125, 128, // 19304-19311
130, 131, 129, 128, 127, 127, 126, 126, // 19312-19319
126, 127, 128, 129, 128, 130, 130, 128, // 19320-19327
129, 131, 131, 132, 131, 129, 128, 127, // 19328-19335
126, 124, 121, 123, 122, 123, 126, 128, // 19336-19343
128, 126, 127, 128, 126, 126, 127, 127, // 19344-19351
128, 128, 128, 127, 126, 125, 124, 125, // 19352-19359
127, 127, 128, 129, 128, 128, 127, 126, // 19360-19367
126, 126, 126, 127, 129, 129, 128, 128, // 19368-19375
127, 127, 127, 127, 128, 129, 128, 130, // 19376-19383
131, 131, 130, 129, 127, 126, 128, 127, // 19384-19391
126, 127, 125, 123, 124, 124, 123, 122, // 19392-19399
124, 125, 126, 128, 129, 128, 128, 127, // 19400-19407
127, 126, 125, 126, 126, 126, 129, 129, // 19408-19415
129, 130, 130, 129, 129, 131, 131, 131, // 19416-19423
131, 129, 128, 126, 124, 123, 122, 123, // 19424-19431
124, 125, 128, 128, 129, 128, 128, 127, // 19432-19439
125, 126, 126, 127, 127, 127, 126, 125, // 19440-19447
125, 124, 125, 127, 127, 129, 130, 131, // 19448-19455
131, 130, 127, 125, 125, 124, 125, 127, // 19456-19463
127, 127, 126, 127, 127, 127, 128, 127, // 19464-19471
128, 130, 131, 132, 132, 130, 130, 127, // 19472-19479
126, 127, 125, 124, 125, 125, 125, 124, // 19480-19487
125, 124, 124, 125, 125, 126, 128, 128, // 19488-19495
128, 128, 127, 126, 123, 123, 124, 124, // 19496-19503
126, 126, 128, 130, 129, 131, 132, 131, // 19504-19511
131, 130, 131, 132, 131, 130, 127, 125, // 19512-19519
122, 123, 123, 123, 125, 126, 127, 130, // 19520-19527
130, 129, 128, 127, 126, 126, 125, 127, // 19528-19535
126, 125, 124, 123, 124, 123, 125, 127, // 19536-19543
127, 129, 129, 131, 130, 128, 127, 127, // 19544-19551
126, 126, 127, 128, 128, 127, 127, 127, // 19552-19559
126, 128, 127, 127, 129, 130, 131, 129, // 19560-19567
131, 130, 127, 127, 127, 127, 127, 126, // 19568-19575
126, 125, 124, 124, 124, 124, 126, 126, // 19576-19583
126, 126, 127, 128, 128, 127, 126, 125, // 19584-19591
123, 124, 125, 125, 125, 127, 128, 129, // 19592-19599
129, 131, 130, 129, 129, 130, 130, 130, // 19600-19607
129, 128, 126, 124, 124, 126, 124, 127, // 19608-19615
128, 128, 130, 131, 130, 129, 127, 127, // 19616-19623
124, 124, 125, 126, 125, 125, 124, 124, // 19624-19631
124, 125, 127, 127, 128, 129, 128, 129, // 19632-19639
128, 127, 126, 124, 124, 124, 126, 128, // 19640-19647
129, 128, 128, 128, 129, 130, 130, 130, // 19648-19655
130, 129, 128, 129, 130, 128, 126, 125, // 19656-19663
126, 125, 126, 127, 125, 125, 125, 125, // 19664-19671
125, 126, 127, 125, 125, 127, 127, 126, // 19672-19679
126, 127, 126, 125, 125, 126, 126, 126, // 19680-19687
127, 128, 129, 130, 131, 131, 131, 130, // 19688-19695
129, 128, 128, 127, 127, 126, 125, 125, // 19696-19703
124, 124, 125, 127, 128, 128, 129, 130, // 19704-19711
129, 128, 128, 127, 125, 124, 125, 125, // 19712-19719
125, 125, 125, 124, 125, 126, 127, 128, // 19720-19727
129, 129, 127, 127, 127, 125, 125, 125, // 19728-19735
126, 126, 127, 129, 129, 129, 129, 129, // 19736-19743
129, 130, 131, 131, 130, 129, 128, 128, // 19744-19751
128, 126, 126, 126, 126, 125, 125, 125, // 19752-19759
125, 125, 125, 125, 125, 126, 125, 125, // 19760-19767
125, 126, 126, 126, 127, 128, 127, 126, // 19768-19775
128, 127, 128, 128, 129, 130, 131, 131, // 19776-19783
130, 129, 130, 128, 127, 126, 126, 126, // 19784-19791
126, 125, 126, 125, 124, 125, 126, 127, // 19792-19799
129, 129, 129, 129, 129, 128, 127, 125, // 19800-19807
124, 124, 125, 127, 128, 127, 126, 126, // 19808-19815
127, 128, 128, 128, 128, 126, 127, 127, // 19816-19823
126, 125, 124, 124, 125, 125, 127, 128, // 19824-19831
128, 129, 129, 128, 129, 131, 131, 129, // 19832-19839
129, 129, 129, 128, 128, 127, 127, 127, // 19840-19847
127, 125, 125, 125, 125, 125, 125, 125, // 19848-19855
126, 125, 125, 127, 125, 125, 125, 126, // 19856-19863
127, 129, 128, 129, 128, 127, 128, 128, // 19864-19871
129, 130, 130, 129, 128, 129, 129, 127, // 19872-19879
126, 125, 125, 124, 126, 127, 126, 125, // 19880-19887
125, 125, 126, 127, 128, 128, 127, 129, // 19888-19895
128, 127, 127, 127, 126, 126, 127, 129, // 19896-19903
130, 128, 127, 128, 127, 129, 129, 128, // 19904-19911
127, 127, 126, 125, 125, 125, 123, 124, // 19912-19919
126, 127, 127, 128, 129, 129, 128, 128, // 19920-19927
129, 130, 128, 128, 128, 127, 127, 127, // 19928-19935
126, 126, 128, 127, 128, 127, 127, 127, // 19936-19943
127, 127, 126, 126, 125, 125, 125, 125, // 19944-19951
124, 124, 124, 126, 126, 128, 129, 130, // 19952-19959
130, 129, 129, 129, 130, 130, 129, 128, // 19960-19967
128, 128, 127, 126, 124, 123, 125, 126, // 19968-19975
128, 128, 127, 127, 126, 127, 127, 126, // 19976-19983
127, 126, 126, 127, 126, 126, 125, 125, // 19984-19991
125, 126, 128, 130, 130, 129, 130, 129, // 19992-19999
130, 129, 129, 127, 126, 127, 126, 126, // 20000-20007
125, 123, 124, 125, 127, 127, 127, 128, // 20008-20015
129, 129, 128, 129, 129, 129, 128, 128, // 20016-20023
127, 128, 126, 124, 125, 126, 127, 128, // 20024-20031
127, 127, 127, 127, 129, 127, 127, 127, // 20032-20039
125, 125, 125, 125, 123, 122, 124, 125, // 20040-20047
127, 128, 130, 129, 130, 129, 131, 131, // 20048-20055
131, 129, 128, 128, 128, 127, 125, 125, // 20056-20063
123, 125, 127, 127, 129, 128, 127, 126, // 20064-20071
127, 127, 126, 126, 126, 126, 126, 126, // 20072-20079
126, 125, 124, 125, 126, 128, 130, 132, // 20080-20087
129, 128, 129, 129, 128, 127, 127, 126, // 20088-20095
126, 127, 127, 126, 124, 124, 124, 126, // 20096-20103
128, 129, 128, 128, 129, 129, 128, 130, // 20104-20111
129, 128, 127, 128, 128, 126, 125, 124, // 20112-20119
125, 126, 128, 128, 127, 127, 128, 128, // 20120-20127
127, 127, 127, 125, 124, 126, 126, 124, // 20128-20135
123, 124, 125, 126, 128, 130, 131, 130, // 20136-20143
131, 131, 131, 130, 130, 128, 126, 126, // 20144-20151
127, 126, 124, 125, 124, 125, 126, 128, // 20152-20159
128, 127, 128, 128, 127, 126, 126, 126, // 20160-20167
125, 124, 124, 125, 124, 125, 127, 126, // 20168-20175
129, 131, 131, 130, 129, 129, 129, 127, // 20176-20183
128, 128, 126, 126, 126, 126, 125, 124, // 20184-20191
125, 126, 127, 128, 129, 128, 128, 129, // 20192-20199
129, 127, 127, 128, 128, 126, 127, 127, // 20200-20207
126, 125, 126, 125, 126, 127, 128, 128, // 20208-20215
127, 128, 128, 127, 127, 127, 126, 125, // 20216-20223
124, 125, 123, 123, 124, 126, 127, 128, // 20224-20231
129, 132, 132, 132, 131, 130, 130, 129, // 20232-20239
127, 127, 126, 126, 125, 123, 125, 126, // 20240-20247
126, 127, 129, 129, 128, 128, 128, 127, // 20248-20255
125, 124, 124, 124, 124, 124, 124, 125, // 20256-20263
126, 127, 127, 128, 129, 130, 130, 130, // 20264-20271
130, 128, 128, 127, 126, 126, 126, 125, // 20272-20279
126, 125, 126, 127, 127, 129, 129, 129, // 20280-20287
129, 129, 130, 129, 128, 128, 127, 127, // 20288-20295
127, 126, 125, 126, 126, 125, 126, 127, // 20296-20303
128, 128, 127, 128, 127, 126, 125, 124, // 20304-20311
124, 124, 123, 123, 124, 124, 124, 125, // 20312-20319
126, 128, 128, 129, 130, 132, 132, 132, // 20320-20327
130, 129, 129, 128, 126, 126, 126, 126, // 20328-20335
126, 126, 128, 128, 128, 129, 129, 129, // 20336-20343
129, 129, 127, 127, 125, 124, 123, 123, // 20344-20351
123, 123, 124, 125, 127, 128, 129, 130, // 20352-20359
130, 130, 129, 128, 128, 127, 126, 125, // 20360-20367
125, 125, 125, 124, 125, 126, 126, 127, // 20368-20375
128, 129, 130, 129, 130, 129, 128, 128, // 20376-20383
127, 127, 127, 127, 127, 126, 126, 127, // 20384-20391
127, 126, 126, 127, 128, 128, 129, 129, // 20392-20399
128, 126, 125, 125, 125, 125, 123, 123, // 20400-20407
124, 125, 126, 126, 127, 127, 128, 129, // 20408-20415
131, 131, 130, 131, 128, 128, 128, 127, // 20416-20423
126, 124, 125, 126, 125, 128, 128, 128, // 20424-20431
128, 129, 130, 130, 129, 128, 127, 127, // 20432-20439
125, 124, 124, 122, 123, 125, 125, 126, // 20440-20447
127, 128, 128, 130, 130, 130, 128, 128, // 20448-20455
127, 127, 127, 126, 125, 124, 124, 125, // 20456-20463
126, 127, 128, 128, 129, 131, 131, 132, // 20464-20471
130, 129, 127, 126, 126, 126, 126, 125, // 20472-20479
125, 126, 126, 127, 127, 127, 127, 128, // 20480-20487
129, 131, 130, 127, 125, 125, 125, 124, // 20488-20495
124, 124, 123, 124, 126, 127, 128, 128, // 20496-20503
127, 127, 129, 131, 131, 130, 129, 128, // 20504-20511
127, 127, 125, 125, 125, 125, 126, 127, // 20512-20519
128, 128, 129, 129, 130, 130, 129, 129, // 20520-20527
128, 127, 127, 126, 125, 124, 123, 123, // 20528-20535
124, 126, 126, 127, 127, 128, 129, 130, // 20536-20543
130, 128, 127, 126, 126, 126, 125, 125, // 20544-20551
123, 124, 126, 128, 128, 128, 128, 129, // 20552-20559
131, 133, 132, 130, 128, 126, 126, 126, // 20560-20567
126, 125, 125, 126, 126, 128, 128, 127, // 20568-20575
127, 127, 128, 129, 129, 129, 127, 125, // 20576-20583
125, 125, 125, 124, 123, 123, 126, 127, // 20584-20591
127, 127, 128, 128, 127, 129, 130, 129, // 20592-20599
128, 127, 129, 128, 127, 126, 125, 126, // 20600-20607
127, 127, 128, 128, 128, 129, 128, 130, // 20608-20615
129, 128, 127, 127, 127, 129, 126, 127, // 20616-20623
124, 126, 123, 126, 126, 127, 127, 127, // 20624-20631
135, 167, 175, 147, 108,  80,  82,  72, // 20632-20639
 98,  69,  49, 121, 176, 190, 211, 181, // 20640-20647
121, 137, 204,   3, 201, 134, 125,  45, // 20648-20655
 14,  57, 107, 104,  67, 120, 164, 238, // 20656-20663
223, 135, 103,  49,  45,  84,  36, 231, // 20664-20671
227, 226,   3,  18,  56,  75,  49, 102, // 20672-20679
183, 214, 235, 224, 220, 203, 188, 235, // 20680-20687
193, 125,  95,  90,  85, 121, 185, 151, // 20688-20695
 68,  72, 139, 163, 197, 139, 132, 196, // 20696-20703
211,  39,  25, 210, 168,  82,  98, 144, // 20704-20711
158, 182, 123, 112, 159, 172, 163, 145, // 20712-20719
117, 100,  68,  78, 201, 131, 234, 166, // 20720-20727
141, 158, 167, 222, 219, 241,  94, 163, // 20728-20735
214, 238,  10, 240, 184,  20,  78,  34, // 20736-20743
245, 221, 205, 129, 124, 177, 170, 130, // 20744-20751
187, 212, 225,  19, 197, 133,  70,  57, // 20752-20759
 81,  18, 224, 214, 216, 240, 253,  35, // 20760-20767
 42,  22,  90, 144, 179, 197, 194, 193, // 20768-20775
176, 171, 208, 168, 107,  91,  71,  93, // 20776-20783
 80, 148, 178,  87,  88, 140, 153, 178, // 20784-20791
167, 114, 140, 182,   0,   1, 184, 174, // 20792-20799
127,  82, 116, 154, 176, 133, 128, 182, // 20800-20807
180, 181, 150, 137, 102,  82,  96, 108, // 20808-20815
150,  63, 209, 173, 164, 178, 217, 213, // 20816-20823
235,  85, 142, 190, 218, 230,   0, 193, // 20824-20831
218,  43, 254, 240, 212, 216, 184, 118, // 20832-20839
165, 158, 145, 190, 229, 212, 235, 241, // 20840-20847
169,  97,  79,  89,  23, 230, 222, 223, // 20848-20855
245,   0,  37,  44,  18, 100, 148, 158, // 20856-20863
187, 179, 189, 167, 174, 203, 162, 106, // 20864-20871
 95,  80,  91,  93, 108, 167, 127, 116, // 20872-20879
149, 158, 164, 168, 140, 103, 150, 226, // 20880-20887
224, 176, 159, 154, 118,  88, 140, 167, // 20888-20895
136, 145, 192, 195, 187, 163, 138, 120, // 20896-20903
 81, 120,  78,  77, 121,  18, 213, 186, // 20904-20911
189, 221, 205, 236,  72, 126, 164, 194, // 20912-20919
206, 226, 217, 202, 234, 224, 213, 213, // 20920-20927
202, 215, 153, 145, 149, 145, 203, 224, // 20928-20935
230, 204, 226, 214, 126, 106,  96,  29, // 20936-20943
240, 228, 230, 248,   4,  36,  39,  23, // 20944-20951
 90, 160, 153, 167, 172, 178, 164, 170, // 20952-20959
200, 151, 112,  92,  89,  92,  99, 111, // 20960-20967
122, 140, 156, 163, 164, 164, 155, 161, // 20968-20975
106, 112, 198, 189, 162, 152, 146, 154, // 20976-20983
103, 109, 155, 127, 157, 196, 205, 194, // 20984-20991
171, 149, 124,  98, 118,  97,  23,  91, // 20992-20999
 90,   7, 223, 207, 228, 204, 237,  65, // 21000-21007
110, 147, 167, 190, 198, 205, 231, 193, // 21008-21015
179, 191, 198, 202, 205, 198, 150, 132, // 21016-21023
145, 207, 226, 231, 214, 189, 219, 168, // 21024-21031
133, 113,  37, 252, 236, 238, 254,   6, // 21032-21039
 39,  32,  32,  85, 146, 173, 149, 159, // 21040-21047
166, 156, 168, 192, 146, 109,  98,  90, // 21048-21055
102,  97, 123, 105, 109, 181, 187, 170, // 21056-21063
168, 149, 158, 130,  99, 161, 165, 142, // 21064-21071
147, 139, 154, 142, 109, 126, 125, 157, // 21072-21079
203, 205, 204, 174, 163, 130, 115, 125, // 21080-21087
103,  36,  31, 101,  73,   5, 237, 237, // 21088-21095
210, 240,  60,  97, 131, 148, 168, 182, // 21096-21103
179, 234, 204, 134, 164, 175, 198, 195, // 21104-21111
207, 188, 118, 143, 201, 229, 227, 220, // 21112-21119
190, 186, 190, 169, 129,  53,  10, 249, // 21120-21127
247,   4,  11,  40,  30,  31,  95, 124, // 21128-21135
173, 165, 139, 158, 144, 168, 181, 141, // 21136-21143
110, 102,  95, 104, 103, 120, 113,  88, // 21144-21151
167, 211, 185, 170, 153, 147, 139, 117, // 21152-21159
130, 134, 126, 134, 139, 146, 152, 144, // 21160-21167
107, 108, 155, 199, 206, 204, 184, 167, // 21168-21175
141, 122, 139,  97,  57,  25,  56, 111, // 21176-21183
 56,  16, 255, 219, 249,  54,  86, 114, // 21184-21191
131, 150, 161, 168, 208, 212, 136, 128, // 21192-21199
159, 182, 195, 197, 213, 137, 130, 198, // 21200-21207
218, 229, 212, 204, 173, 172, 201, 151, // 21208-21215
 72,  32,   8,   6,   9,  19,  41,  31, // 21216-21223
 32,  95, 119, 141, 178, 142, 138, 138, // 21224-21231
159, 176, 132, 115, 101, 102, 103, 108, // 21232-21239
120, 112,  97, 139, 203, 207, 175, 158, // 21240-21247
146, 131, 141, 125, 103, 111, 122, 132, // 21248-21255
144, 143, 163, 127,  88, 151, 191, 206, // 21256-21263
202, 188, 175, 149, 135, 145, 106,  62, // 21264-21271
 49,  31,  92, 103,  57,  23, 234,   4, // 21272-21279
 53,  77, 103, 117, 137, 142, 156, 194, // 21280-21287
189, 157, 117, 130, 166, 182, 193, 204, // 21288-21295
166, 132, 183, 208, 222, 212, 199, 185, // 21296-21303
154, 198, 179,  95,  54,  25,  19,  19, // 21304-21311
 23,  45,  29,  41,  87, 122, 127, 154, // 21312-21319
167, 129, 128, 156, 167, 130, 114, 108, // 21320-21327
105, 111, 108, 125, 106, 105, 136, 169, // 21328-21335
209, 192, 160, 153, 126, 147, 142,  87, // 21336-21343
 92, 112, 124, 141, 143, 159, 151,  98, // 21344-21351
131, 181, 195, 201, 185, 179, 152, 147, // 21352-21359
150, 113,  72,  58,  43,  58, 106, 102, // 21360-21367
 51,   1,  18,  55,  74,  92, 105, 123, // 21368-21375
130, 142, 183, 170, 153, 137, 110, 146, // 21376-21383
168, 191, 194, 173, 162, 168, 199, 210, // 21384-21391
209, 197, 185, 163, 175, 183, 124,  74, // 21392-21399
 46,  34,  31,  33,  48,  31,  45,  91, // 21400-21407
111, 132, 128, 165, 151, 112, 151, 154, // 21408-21415
127, 111, 107, 108, 112, 113, 125, 109, // 21416-21423
104, 144, 155, 184, 203, 173, 154, 133, // 21424-21431
140, 154,  93,  72,  96, 115, 132, 140, // 21432-21439
155, 149, 128, 127, 163, 188, 195, 186, // 21440-21447
179, 159, 154, 158, 115,  83,  64,  58, // 21448-21455
 54,  79, 120,  86,  29,  38,  62,  74, // 21456-21463
 87,  94, 112, 117, 134, 166, 158, 136, // 21464-21471
144, 121, 123, 153, 178, 189, 167, 185, // 21472-21479
179, 183, 205, 200, 201, 181, 173, 175, // 21480-21487
161, 141, 101,  65,  52,  41,  45,  50, // 21488-21495
 35,  48,  92, 106, 125, 126, 135, 166, // 21496-21503
126, 135, 146, 117, 113, 105, 111, 112, // 21504-21511
117, 124, 109, 109, 143, 159, 162, 186, // 21512-21519
191, 161, 141, 145, 147, 111,  69,  79, // 21520-21527
105, 125, 133, 152, 139, 139, 152, 147, // 21528-21535
174, 185, 184, 179, 161, 162, 162, 122, // 21536-21543
 93,  75,  67,  66,  65, 107, 108,  61, // 21544-21551
 57,  69,  75,  85,  88, 102, 106, 125, // 21552-21559
154, 144, 132, 132, 139, 123, 130, 164, // 21560-21567
177, 161, 185, 200, 175, 192, 195, 198, // 21568-21575
185, 175, 188, 154, 136, 129,  89,  71, // 21576-21583
 55,  53,  55,  34,  54,  87, 105, 113, // 21584-21591
123, 121, 142, 153, 135, 133, 114, 110, // 21592-21599
106, 112, 115, 117, 125, 105, 115, 143, // 21600-21607
158, 161, 160, 184, 176, 144, 154, 142, // 21608-21615
117,  88,  69,  94, 116, 129, 146, 137, // 21616-21623
133, 168, 157, 154, 172, 175, 177, 160, // 21624-21631
168, 164, 128, 102,  88,  80,  79,  72, // 21632-21639
 89, 106,  91,  84,  79,  78,  79,  83, // 21640-21647
 92,  96, 116, 143, 129, 125, 125, 134, // 21648-21655
140, 120, 147, 163, 159, 182, 206, 189, // 21656-21663
176, 186, 190, 184, 178, 188, 159, 126, // 21664-21671
130, 115,  88,  70,  63,  61,  42,  61, // 21672-21679
 89, 100, 111, 113, 125, 117, 148, 158, // 21680-21687
118, 107, 106, 108, 111, 114, 119, 125, // 21688-21695
109, 118, 145, 152, 162, 156, 163, 181, // 21696-21703
158, 158, 143, 111, 106,  76,  82, 105, // 21704-21711
124, 141, 134, 138, 165, 175, 155, 158, // 21712-21719
170, 173, 162, 168, 165, 131, 109,  93, // 21720-21727
 85,  83,  78,  84,  89,  98, 110,  94, // 21728-21735
 85,  81,  81,  89,  88, 112, 132, 123, // 21736-21743
117, 126, 127, 142, 135, 134, 147, 152, // 21744-21751
180, 200, 202, 178, 174, 186, 179, 183, // 21752-21759
186, 161, 129, 119, 125, 111,  83,  78, // 21760-21767
 63,  49,  66,  91,  97, 108, 110, 121, // 21768-21775
119, 127, 172, 131,  96, 103, 103, 112, // 21776-21783
112, 122, 124, 109, 121, 145, 151, 157, // 21784-21791
155, 150, 159, 169, 163, 146, 111, 105, // 21792-21799
 95,  76,  94, 115, 134, 127, 140, 163, // 21800-21807
175, 173, 150, 158, 165, 161, 173, 165, // 21808-21815
135, 117, 102,  95,  90,  88,  88,  80, // 21816-21823
 94, 123, 117,  98,  89,  82,  87,  86, // 21824-21831
107, 122, 110, 109, 113, 122, 129, 140, // 21832-21839
135, 127, 141, 174, 192, 202, 192, 166, // 21840-21847
176, 174, 182, 188, 159, 138, 120, 117, // 21848-21855
126, 101,  90,  72,  55,  75,  92, 103, // 21856-21863
107, 111, 114, 120, 121, 152, 150, 100, // 21864-21871
 95, 100, 109, 113, 120, 121, 109, 124, // 21872-21879
144, 152, 156, 153, 154, 146, 162, 179, // 21880-21887
148, 118, 101, 101,  89,  84, 108, 123, // 21888-21895
121, 134, 162, 167, 177, 160, 148, 157, // 21896-21903
157, 173, 164, 137, 122, 109, 103,  97, // 21904-21911
 95,  96,  79,  91, 123, 132, 117,  97, // 21912-21919
 89,  85,  87, 104, 117, 102, 103, 107, // 21920-21927
118, 126, 133, 146, 122, 126, 166, 185, // 21928-21935
194, 197, 175, 165, 169, 180, 186, 159, // 21936-21943
139, 127, 115, 123, 122, 103,  82,  61, // 21944-21951
 79,  94, 102, 107, 106, 113, 111, 126, // 21952-21959
135, 143, 121,  90,  96, 106, 113, 122, // 21960-21967
121, 111, 125, 144, 151, 156, 152, 153, // 21968-21975
146, 148, 179, 157, 123, 109,  99, 103, // 21976-21983
 86,  98, 116, 115, 132, 158, 167, 170, // 21984-21991
170, 151, 143, 152, 168, 161, 137, 125, // 21992-21999
114, 108, 103, 100, 101,  82,  87, 120, // 22000-22007
133, 133, 110,  96,  88,  85, 102, 107, // 22008-22015
 97,  96, 103, 112, 125, 131, 144, 132, // 22016-22023
119, 152, 178, 187, 192, 184, 164, 161, // 22024-22031
178, 182, 159, 140, 131, 125, 119, 128, // 22032-22039
125,  94,  75,  84,  97, 101, 106, 106, // 22040-22047
111, 108, 123, 135, 122, 130, 104,  87, // 22048-22055
101, 107, 119, 117, 109, 127, 141, 148, // 22056-22063
152, 150, 151, 147, 146, 163, 162, 132, // 22064-22071
117, 104, 106, 100,  91, 107, 108, 130, // 22072-22079
153, 166, 169, 165, 162, 140, 143, 163, // 22080-22087
155, 137, 129, 121, 119, 112, 109, 105, // 22088-22095
 90,  91, 118, 131, 136, 126, 103,  92, // 22096-22103
 84, 101, 102,  91,  93,  97, 110, 120, // 22104-22111
128, 133, 127, 122, 136, 159, 177, 180, // 22112-22119
183, 171, 153, 172, 178, 160, 147, 137, // 22120-22127
133, 127, 124, 137, 112,  89,  97, 100, // 22128-22135
106, 106, 108, 109, 109, 119, 133, 114, // 22136-22143
117, 122,  95,  93, 103, 116, 116, 110, // 22144-22151
129, 142, 147, 150, 145, 147, 141, 148, // 22152-22159
153, 149, 142, 122, 112, 107, 108, 102, // 22160-22167
 97, 102, 126, 150, 157, 164, 156, 159, // 22168-22175
146, 134, 153, 149, 135, 132, 126, 127, // 22176-22183
121, 119, 113,  96, 102, 115, 131, 135, // 22184-22191
133, 120, 100,  93, 102, 100,  88,  90, // 22192-22199
 93, 105, 114, 124, 131, 121, 130, 137, // 22200-22207
143, 164, 171, 173, 174, 154, 163, 169, // 22208-22215
154, 147, 138, 134, 132, 125, 130, 126, // 22216-22223
106, 109, 107, 108, 107, 107, 109, 107, // 22224-22231
119, 126, 114, 107, 120, 116,  96,  99, // 22232-22239
113, 112, 112, 130, 141, 146, 148, 145, // 22240-22247
146, 142, 147, 155, 137, 140, 134, 119, // 22248-22255
115, 109, 114,  96,  95, 121, 142, 153, // 22256-22263
159, 156, 153, 151, 141, 143, 141, 132, // 22264-22271
129, 125, 126, 123, 122, 116,  99, 107, // 22272-22279
116, 124, 136, 130, 132, 112, 101, 108, // 22280-22287
 99,  90,  90,  92, 102, 111, 120, 129, // 22288-22295
119, 128, 144, 140, 150, 164, 165, 170, // 22296-22303
163, 160, 161, 151, 147, 139, 136, 134, // 22304-22311
132, 127, 122, 122, 120, 115, 111, 110, // 22312-22319
108, 110, 107, 120, 124, 113, 109, 109, // 22320-22327
123, 112,  96, 107, 109, 110, 129, 138, // 22328-22335
144, 146, 143, 142, 140, 145, 151, 135, // 22336-22343
127, 136, 127, 120, 113, 117, 105,  91, // 22344-22351
117, 136, 149, 154, 154, 152, 146, 151, // 22352-22359
145, 130, 130, 126, 125, 127, 125, 125, // 22360-22367
118, 106, 111, 123, 122, 134, 133, 131, // 22368-22375
127, 112, 114, 100,  90,  88,  91, 100, // 22376-22383
107, 117, 123, 120, 128, 145, 147, 144, // 22384-22391
151, 161, 160, 164, 162, 150, 144, 143, // 22392-22399
137, 136, 132, 131, 130, 116, 127, 133, // 22400-22407
124, 120, 114, 112, 111, 110, 120, 121, // 22408-22415
110, 110, 105, 116, 124, 106, 102, 103, // 22416-22423
110, 129, 138, 143, 143, 143, 143, 138, // 22424-22431
147, 146, 135, 125, 127, 135, 127, 119, // 22432-22439
116, 110,  98, 112, 130, 142, 150, 148, // 22440-22447
152, 146, 152, 153, 126, 121, 125, 125, // 22448-22455
128, 126, 127, 118, 109, 116, 123, 125, // 22456-22463
125, 134, 130, 128, 127, 119, 105,  93, // 22464-22471
 91,  91,  99, 104, 114, 118, 118, 130, // 22472-22479
141, 148, 146, 139, 152, 156, 160, 168, // 22480-22487
148, 138, 141, 138, 138, 134, 132, 131, // 22488-22495
118, 125, 141, 135, 125, 117, 111, 112, // 22496-22503
108, 122, 112, 122, 157, 167, 138,  96, // 22504-22511
 64,  60,  51,  66,  96,  57,  85, 164, // 22512-22519
197, 216, 225, 165, 145, 185, 252,   5, // 22520-22527
167, 155,  70,  26,  72,  98, 141,  93, // 22528-22535
 98, 146, 207, 249, 172, 115,  81,  29, // 22536-22543
 57,  67, 251, 221, 221, 235,   8,  26, // 22544-22551
 67,  96,  56, 119, 190, 214, 232, 218, // 22552-22559
226, 188, 212, 227, 160, 106,  93,  84, // 22560-22567
 91, 153, 178, 105,  51, 100, 149, 178, // 22568-22575
138, 125, 199, 211, 249,  49, 241, 188, // 22576-22583
116,  66, 123, 137, 169, 154, 101, 128, // 22584-22591
166, 161, 153, 131, 114,  90,  55, 182, // 22592-22599
189,  22, 187, 144, 154, 160, 196, 240, // 22600-22607
226,  43, 141, 195, 237,   2,  18, 205, // 22608-22615
224,  65,  68,   6, 232, 214, 130, 126, // 22616-22623
163, 191, 146, 140, 202, 197, 250, 232, // 22624-22631
150,  99,  43,  66,  58, 241, 217, 210, // 22632-22639
230, 242,  17,  42,  40,  77, 100, 147, // 22640-22647
183, 195, 195, 195, 175, 195, 213, 141, // 22648-22655
110,  86,  91,  88, 105, 184, 137,  66, // 22656-22663
114, 141, 166, 164, 107, 142, 175, 222, // 22664-22671
 22, 221, 174, 157,  86,  87, 128, 159, // 22672-22679
155, 105, 147, 177, 176, 161, 141, 124, // 22680-22687
 93,  83, 117, 167, 101, 243, 177, 168, // 22688-22695
169, 200, 229, 216,  31, 126, 167, 215, // 22696-22703
226,   1, 236, 184,  23,  34, 248, 225, // 22704-22711
216, 189, 119, 156, 182, 151, 154, 210, // 22712-22719
212, 209, 240, 200, 123,  70,  83,  64, // 22720-22727
248, 225, 217, 232, 251,  11,  57,  16, // 22728-22735
 69, 143, 124, 168, 178, 187, 183, 167, // 22736-22743
196, 204, 140, 109,  98,  89, 103,  92, // 22744-22751
148, 160, 104, 127, 151, 153, 173, 132, // 22752-22759
109, 137, 199, 246, 203, 165, 157, 136, // 22760-22767
 86, 102, 155, 149, 120, 157, 190, 183, // 22768-22775
176, 146, 139,  97, 101, 112,  99, 122, // 22776-22783
 58, 223, 193, 180, 208, 224, 210,  25, // 22784-22791
107, 148, 185, 206, 221, 234, 202, 223, // 22792-22799
245, 217, 218, 199, 212, 154, 137, 177, // 22800-22807
144, 172, 211, 227, 210, 206, 229, 164, // 22808-22815
 97, 105,  68,   2, 232, 226, 236, 254, // 22816-22823
 15,  49,  28,  41, 159, 149, 139, 168, // 22824-22831
170, 178, 157, 195, 192, 138, 109,  99, // 22832-22839
 96, 100, 107, 120, 135, 142, 150, 159, // 22840-22847
159, 158, 159, 112, 101, 172, 217, 180, // 22848-22855
160, 147, 149, 126,  84, 135, 137, 124, // 22856-22863
167, 194, 194, 182, 159, 144, 111, 107, // 22864-22871
127,  67,  82, 104,  31, 233, 204, 221, // 22872-22879
225, 210,  23,  93, 132, 164, 181, 205, // 22880-22887
201, 222, 216, 188, 187, 196, 194, 201, // 22888-22895
194, 146, 153, 142, 174, 223, 222, 225, // 22896-22903
190, 206, 198, 132, 125,  80,  13, 246, // 22904-22911
233, 247, 255,  25,  42,  30,  46, 127, // 22912-22919
184, 142, 143, 161, 161, 155, 185, 184, // 22920-22927
129, 113,  98, 105, 101, 111, 125, 101, // 22928-22935
143, 187, 169, 169, 155, 159, 139,  85, // 22936-22943
141, 188, 158, 147, 144, 140, 150, 111, // 22944-22951
109, 125, 122, 175, 195, 201, 189, 169, // 22952-22959
151, 119, 120, 128,  72,  42,  89,  83, // 22960-22967
 24, 234, 240, 229, 216,  23,  85, 117, // 22968-22975
149, 162, 187, 182, 206, 239, 162, 149, // 22976-22983
172, 183, 192, 197, 185, 138, 134, 174, // 22984-22991
222, 226, 223, 204, 182, 191, 173, 147, // 22992-22999
 93,  25,   2, 242, 252,   4,  26,  47, // 23000-23007
 21,  63, 106, 168, 183, 128, 147, 149, // 23008-23015
149, 180, 171, 127, 111, 100, 102, 109, // 23016-23023
111, 130,  97, 115, 200, 195, 173, 163, // 23024-23031
146, 150, 103, 117, 157, 139, 134, 135, // 23032-23039
141, 146, 148, 118,  97, 118, 170, 197, // 23040-23047
198, 192, 173, 158, 125, 133, 132,  80, // 23048-23055
 39,  55,  95,  79,  21,   7, 239, 224, // 23056-23063
 27,  74, 107, 132, 149, 163, 169, 188, // 23064-23071
229, 178, 121, 144, 166, 186, 187, 204, // 23072-23079
156, 117, 175, 214, 230, 221, 207, 188, // 23080-23087
164, 186, 183, 108,  47,  16,   4,   6, // 23088-23095
 13,  30,  45,  23,  60, 114, 130, 192, // 23096-23103
155, 122, 137, 138, 176, 159, 124, 109, // 23104-23111
103, 105, 108, 118, 124, 103, 107, 174, // 23112-23119
215, 191, 168, 152, 142, 130, 117, 126, // 23120-23127
118, 122, 124, 137, 142, 150, 150,  88, // 23128-23135
105, 166, 192, 201, 191, 178, 163, 136, // 23136-23143
143, 137,  86,  54,  40,  76, 101,  70, // 23144-23151
 38,   1, 238,  33,  70,  97, 119, 132, // 23152-23159
151, 151, 182, 204, 184, 132, 116, 145, // 23160-23167
174, 181, 200, 180, 118, 160, 207, 220, // 23168-23175
225, 202, 196, 162, 170, 203, 134,  66, // 23176-23183
 34,  12,  18,  16,  36,  39,  28,  59, // 23184-23191
112, 124, 154, 185, 133, 117, 134, 166, // 23192-23199
154, 118, 112, 105, 113, 112, 123, 126, // 23200-23207
103, 119, 153, 197, 213, 172, 159, 137, // 23208-23215
133, 139, 106,  96, 109, 118, 130, 143, // 23216-23223
146, 162, 115,  93, 155, 182, 196, 189, // 23224-23231
178, 166, 143, 151, 141,  91,  67,  46, // 23232-23239
 59,  95, 100,  76,  19,   1,  39,  69, // 23240-23247
 88, 106, 117, 135, 137, 168, 190, 163, // 23248-23255
150, 115, 122, 158, 175, 193, 186, 145, // 23256-23263
152, 197, 213, 218, 203, 192, 171, 159, // 23264-23271
187, 157,  89,  53,  30,  29,  26,  40, // 23272-23279
 43,  28,  68, 101, 128, 131, 166, 171, // 23280-23287
110, 123, 156, 143, 117, 110, 106, 114, // 23288-23295
115, 124, 129, 104, 125, 155, 168, 207, // 23296-23303
192, 162, 145, 127, 155, 111,  74,  94, // 23304-23311
106, 124, 135, 148, 154, 136, 111, 137, // 23312-23319
173, 188, 187, 179, 166, 148, 156, 143, // 23320-23327
 97,  74,  58,  54,  81, 104, 107,  50, // 23328-23335
 24,  54,  69,  87,  96, 110, 121, 127, // 23336-23343
154, 176, 149, 144, 135, 112, 135, 161, // 23344-23351
185, 176, 166, 164, 179, 206, 209, 204, // 23352-23359
192, 172, 169, 168, 153, 120,  74,  51, // 23360-23367
 41,  38,  48,  46,  33,  72, 102, 118, // 23368-23375
132, 131, 176, 140, 110, 146, 131, 114, // 23376-23383
107, 106, 114, 115, 125, 126, 109, 127, // 23384-23391
158, 162, 178, 199, 176, 150, 136, 151, // 23392-23399
131,  71,  78,  96, 117, 127, 142, 150, // 23400-23407
132, 142, 140, 154, 179, 179, 179, 167, // 23408-23415
153, 163, 144, 104,  83,  70,  63,  71, // 23416-23423
 97, 114,  84,  51,  69,  76,  86,  93, // 23424-23431
102, 113, 114, 145, 156, 139, 129, 137, // 23432-23439
128, 118, 142, 174, 166, 168, 187, 171, // 23440-23447
189, 203, 199, 196, 175, 179, 172, 136, // 23448-23455
132, 103,  70,  59,  46,  56,  46,  41, // 23456-23463
 73, 101, 110, 127, 123, 144, 165, 129, // 23464-23471
128, 120, 106, 107, 105, 114, 113, 125, // 23472-23479
125, 112, 134, 155, 166, 167, 178, 193, // 23480-23487
157, 146, 147, 130,  87,  63,  84, 106, // 23488-23495
121, 133, 146, 129, 149, 163, 144, 163, // 23496-23503
171, 175, 170, 157, 166, 145, 111,  96, // 23504-23511
 81,  80,  71,  91, 112,  96,  85,  82, // 23512-23519
 83,  84,  88,  94, 106, 107, 136, 142, // 23520-23527
127, 127, 126, 139, 125, 125, 159, 159, // 23528-23535
163, 198, 184, 174, 191, 193, 194, 178, // 23536-23543
179, 176, 133, 122, 122,  91,  74,  59, // 23544-23551
 63,  51,  45,  78,  95, 110, 116, 125, // 23552-23559
126, 147, 161, 129, 108, 103, 104, 107, // 23560-23567
114, 115, 127, 124, 113, 136, 154, 160, // 23568-23575
167, 159, 181, 172, 150, 155, 123, 105, // 23576-23583
 73,  70, 100, 115, 134, 140, 133, 146, // 23584-23591
174, 161, 152, 162, 170, 165, 160, 167, // 23592-23599
146, 114, 100,  85,  85,  78,  82, 107, // 23600-23607
 93, 102, 102,  89,  90,  85,  91,  95, // 23608-23615
101, 126, 135, 119, 123, 122, 132, 141, // 23616-23623
127, 142, 150, 160, 192, 200, 177, 176, // 23624-23631
187, 187, 176, 182, 174, 142, 117, 117, // 23632-23639
115,  90,  75,  70,  58,  51,  80,  96, // 23640-23647
110, 115, 118, 126, 122, 163, 155, 101, // 23648-23655
 97, 100, 107, 114, 116, 128, 123, 114, // 23656-23663
136, 153, 158, 161, 156, 158, 169, 161, // 23664-23671
156, 126, 105,  93,  66,  89, 107, 129, // 23672-23679
136, 130, 150, 167, 176, 157, 148, 163, // 23680-23687
159, 159, 169, 147, 121, 106,  96,  92, // 23688-23695
 90,  85,  98,  98, 106, 124, 104,  96, // 23696-23703
 86,  87,  90,  94, 120, 122, 113, 113, // 23704-23711
120, 125, 138, 140, 132, 133, 155, 182, // 23712-23719
200, 190, 167, 175, 181, 174, 183, 173, // 23720-23727
144, 127, 109, 121, 112,  88,  84,  63, // 23728-23735
 61,  82,  97, 107, 114, 114, 123, 116, // 23736-23743
141, 168, 117,  89,  95, 103, 113, 116, // 23744-23751
127, 123, 116, 137, 150, 158, 156, 155, // 23752-23759
154, 152, 171, 162, 131, 106, 101,  84, // 23760-23767
 78, 101, 121, 131, 125, 149, 164, 171, // 23768-23775
169, 143, 147, 153, 156, 169, 147, 125, // 23776-23783
112, 102, 100,  95,  97,  90,  95, 110, // 23784-23791
127, 125, 106,  95,  89,  89,  91, 115, // 23792-23799
115, 107, 109, 113, 125, 129, 144, 141, // 23800-23807
119, 144, 176, 189, 199, 173, 165, 172, // 23808-23815
170, 181, 173, 145, 131, 116, 113, 124, // 23816-23823
108,  96,  74,  69,  88,  95, 106, 110, // 23824-23831
113, 116, 116, 127, 152, 138,  97,  87, // 23832-23839
 99, 110, 116, 126, 121, 119, 138, 150, // 23840-23847
155, 155, 150, 154, 142, 161, 173, 137, // 23848-23855
115, 102, 100,  84,  89, 116, 123, 124, // 23856-23863
144, 164, 167, 172, 158, 140, 142, 153, // 23864-23871
165, 148, 127, 118, 107, 107, 100, 104, // 23872-23879
 97,  86, 116, 125, 132, 122, 100,  95, // 23880-23887
 86,  91, 108, 108, 100, 106, 107, 120, // 23888-23895
127, 137, 146, 124, 130, 165, 178, 190, // 23896-23903
181, 161, 162, 167, 180, 173, 150, 136, // 23904-23911
126, 119, 121, 125, 109,  84,  78,  94, // 23912-23919
 99, 106, 107, 110, 114, 114, 129, 135, // 23920-23927
137, 119,  87,  93, 106, 112, 122, 114, // 23928-23935
117, 136, 146, 153, 153, 148, 148, 144, // 23936-23943
149, 168, 148, 122, 108, 106, 102,  86, // 23944-23951
107, 116, 120, 143, 159, 166, 163, 160, // 23952-23959
146, 131, 146, 160, 146, 133, 124, 118, // 23960-23967
116, 111, 109, 105,  88, 112, 135, 130, // 23968-23975
134, 109,  97,  89,  90, 107, 101,  97, // 23976-23983
100, 107, 117, 123, 130, 135, 127, 126, // 23984-23991
147, 168, 176, 179, 166, 153, 160, 176, // 23992-23999
170, 152, 142, 132, 132, 122, 129, 129, // 24000-24007
 98,  93, 102, 105, 108, 107, 108, 112, // 24008-24015
111, 126, 124, 120, 128, 104,  89,  98, // 24016-24023
108, 120, 115, 119, 139, 146, 151, 148, // 24024-24031
147, 145, 142, 148, 152, 149, 132, 115, // 24032-24039
108, 110,  97,  96, 108, 116, 142, 153, // 24040-24047
160, 159, 153, 152, 131, 136, 152, 142, // 24048-24055
134, 127, 124, 123, 116, 118, 109, 100, // 24056-24063
109, 134, 137, 132, 127, 108,  95,  94, // 24064-24071
106,  97,  93,  98, 103, 114, 117, 127, // 24072-24079
129, 125, 135, 138, 154, 168, 170, 173, // 24080-24087
152, 151, 170, 164, 151, 143, 135, 133, // 24088-24095
127, 123, 133, 113, 104, 110, 109, 110, // 24096-24103
107, 109, 109, 109, 123, 122, 110, 121, // 24104-24111
120, 100,  93, 105, 117, 112, 119, 138, // 24112-24119
145, 149, 149, 146, 144, 139, 151, 146, // 24120-24127
140, 140, 123, 114, 112, 109, 100,  98, // 24128-24135
113, 137, 152, 157, 158, 152, 151, 141, // 24136-24143
134, 141, 136, 131, 127, 123, 124, 117, // 24144-24151
121, 110, 103, 113, 124, 141, 131, 128, // 24152-24159
121, 100, 100, 105,  96,  92,  95, 101, // 24160-24167
111, 116, 125, 127, 122, 139, 145, 143, // 24168-24175
159, 163, 169, 160, 147, 162, 158, 149, // 24176-24183
143, 137, 136, 131, 128, 125, 121, 117, // 24184-24191
116, 114, 112, 108, 109, 108, 110, 124, // 24192-24199
121, 109, 112, 122, 117,  99, 100, 113, // 24200-24207
109, 119, 136, 142, 145, 145, 145, 141, // 24208-24215
138, 149, 148, 131, 136, 133, 122, 116, // 24216-24223
115, 111,  91, 106, 131, 144, 153, 153, // 24224-24231
153, 147, 144, 145, 136, 129, 128, 126, // 24232-24239
124, 123, 121, 119, 112, 104, 118, 120, // 24240-24247
134, 140, 127, 129, 113, 108, 110,  96, // 24248-24255
 92,  92, 100, 108, 114, 124, 124, 121, // 24256-24263
136, 151, 147, 148, 157, 162, 162, 154, // 24264-24271
154, 149, 143, 143, 138, 137, 131, 132, // 24272-24279
123, 117, 128, 125, 120, 117, 111, 111, // 24280-24287
108, 112, 122, 117, 109, 105, 114, 124, // 24288-24295
111, 100, 104, 104, 116, 134, 140, 144, // 24296-24303
141, 145, 142, 140, 149, 146, 133, 129, // 24304-24311
135, 132, 121, 117, 119,  98, 101, 129, // 24312-24319
140, 149, 151, 152, 148, 142, 150, 138, // 24320-24327
120, 124, 125, 126, 122, 122, 120, 110, // 24328-24335
110, 121, 124, 125, 138, 134, 127, 124, // 24336-24343
117, 111,  95,  93,  94,  99, 106, 111, // 24344-24351
120, 120, 121, 135, 147, 151, 143, 148, // 24352-24359
159, 157, 162, 152, 142, 139, 141, 140, // 24360-24367
139, 134, 134, 128, 118, 133, 136, 123, // 24368-24375
117, 112, 111, 109, 112, 119, 112, 108, // 24376-24383
108, 111, 122, 119, 112, 106, 108, 120, // 24384-24391
130, 134, 135, 133, 136, 137, 138, 142, // 24392-24399
137, 133, 131, 133, 136, 128, 123, 122, // 24400-24407
117, 115, 126, 133, 134, 135, 137, 137, // 24408-24415
134, 137, 134, 125, 125, 128, 129, 126, // 24416-24423
125, 123, 118, 121, 126, 126, 124, 127, // 24424-24431
132, 129, 127, 126, 121, 115, 116, 120, // 24432-24439
120, 122, 123, 124, 124, 125, 129, 129, // 24440-24447
128, 129, 130, 134, 135, 136, 133, 128, // 24448-24455
129, 130, 133, 133, 131, 131, 129, 130, // 24456-24463
131, 129, 124, 121, 122, 124, 123, 126, // 24464-24471
126, 124, 124, 125, 126, 125, 125, 123, // 24472-24479
122, 124, 127, 127, 125, 125, 124, 124, // 24480-24487
127, 130, 131, 130, 131, 134, 134, 132, // 24488-24495
129, 126, 124, 125, 125, 126, 127, 127, // 24496-24503
127, 129, 129, 128, 127, 126, 126, 126, // 24504-24511
129, 130, 127, 125, 125, 123, 124, 126, // 24512-24519
127, 125, 126, 130, 132, 130, 129, 126, // 24520-24527
122, 124, 126, 127, 126, 128, 127, 127, // 24528-24535
128, 128, 127, 123, 123, 126, 128, 130, // 24536-24543
130, 128, 127, 126, 128, 128, 129, 130, // 24544-24551
130, 129, 131, 134, 131, 125, 121, 122, // 24552-24559
124, 124, 124, 126, 126, 126, 128, 129, // 24560-24567
128, 127, 127, 125, 127, 129, 128, 125, // 24568-24575
124, 125, 123, 124, 126, 128, 128, 129, // 24576-24583
133, 135, 132, 131, 129, 126, 126, 125, // 24584-24591
124, 124, 125, 127, 126, 127, 126, 125, // 24592-24599
126, 128, 129, 130, 130, 130, 128, 127, // 24600-24607
127, 125, 124, 124, 123, 125, 127, 128, // 24608-24615
128, 126, 127, 124, 124, 128, 128, 126, // 24616-24623
127, 129, 130, 129, 128, 126, 125, 124, // 24624-24631
124, 125, 126, 127, 127, 127, 127, 129, // 24632-24639
128, 128, 129, 131, 131, 130, 131, 130, // 24640-24647
126, 124, 122, 122, 123, 123, 125, 128, // 24648-24655
129, 131, 131, 129, 129, 128, 127, 127, // 24656-24663
127, 127, 125, 124, 125, 124, 122, 122, // 24664-24671
125, 126, 129, 131, 133, 131, 130, 128, // 24672-24679
127, 126, 125, 124, 122, 124, 128, 127, // 24680-24687
127, 127, 127, 128, 129, 131, 131, 129, // 24688-24695
130, 130, 129, 128, 126, 124, 122, 122, // 24696-24703
125, 126, 127, 128, 126, 127, 127, 127, // 24704-24711
127, 126, 126, 127, 128, 130, 130, 128, // 24712-24719
126, 124, 126, 126, 126, 126, 126, 128, // 24720-24727
128, 130, 131, 129, 127, 126, 128, 130, // 24728-24735
129, 128, 128, 127, 126, 124, 123, 123, // 24736-24743
123, 124, 127, 129, 132, 131, 128, 128, // 24744-24751
128, 128, 127, 127, 127, 125, 125, 126, // 24752-24759
126, 123, 122, 123, 127, 129, 131, 131, // 24760-24767
131, 130, 128, 128, 127, 126, 124, 123, // 24768-24775
125, 128, 127, 127, 127, 126, 128, 128, // 24776-24783
132, 132, 128, 129, 129, 130, 129, 126, // 24784-24791
125, 123, 123, 124, 127, 126, 126, 126, // 24792-24799
126, 127, 129, 127, 126, 125, 126, 127, // 24800-24807
127, 129, 129, 125, 124, 126, 126, 127, // 24808-24815
126, 126, 129, 129, 130, 130, 128, 128, // 24816-24823
127, 127, 128, 129, 129, 128, 127, 127, // 24824-24831
125, 123, 123, 123, 124, 125, 127, 129, // 24832-24839
128, 128, 127, 127, 127, 126, 127, 126, // 24840-24847
127, 128, 127, 127, 126, 124, 125, 127, // 24848-24855
128, 130, 130, 130, 130, 129, 129, 127, // 24856-24863
126, 124, 124, 126, 126, 126, 125, 125, // 24864-24871
127, 127, 129, 130, 132, 130, 129, 130, // 24872-24879
130, 129, 128, 126, 124, 125, 124, 125, // 24880-24887
126, 125, 127, 126, 127, 129, 127, 126, // 24888-24895
126, 126, 126, 124, 125, 127, 126, 126, // 24896-24903
125, 125, 127, 128, 128, 129, 131, 131, // 24904-24911
130, 130, 129, 128, 127, 126, 128, 129, // 24912-24919
128, 128, 127, 126, 125, 123, 124, 125, // 24920-24927
125, 126, 127, 127, 128, 128, 127, 126, // 24928-24935
125, 128, 128, 127, 128, 127, 126, 126, // 24936-24943
126, 126, 126, 128, 128, 129, 130, 130, // 24944-24951
129, 127, 127, 126, 125, 125, 125, 125, // 24952-24959
126, 125, 126, 128, 128, 129, 128, 130, // 24960-24967
132, 131, 130, 129, 128, 128, 126, 124, // 24968-24975
124, 124, 124, 124, 126, 127, 126, 125, // 24976-24983
126, 127, 127, 126, 126, 127, 126, 127, // 24984-24991
126, 127, 128, 125, 126, 126, 129, 131, // 24992-24999
130, 130, 130, 130, 130, 129, 128, 128, // 25000-25007
127, 125, 127, 128, 128, 126, 124, 124, // 25008-25015
124, 126, 125, 126, 126, 125, 126, 126, // 25016-25023
128, 128, 127, 125, 126, 128, 128, 128, // 25024-25031
127, 126, 125, 125, 126, 127, 127, 127, // 25032-25039
128, 128, 130, 131, 128, 127, 126, 127, // 25040-25047
127, 126, 127, 127, 125, 126, 128, 129, // 25048-25055
129, 128, 128, 130, 131, 131, 128, 126, // 25056-25063
127, 126, 125, 123, 123, 123, 122, 123, // 25064-25071
126, 126, 126, 125, 126, 128, 128, 128, // 25072-25079
127, 126, 125, 126, 127, 127, 126, 126, // 25080-25087
125, 127, 130, 131, 130, 128, 130, 132, // 25088-25095
131, 131, 130, 128, 126, 126, 128, 127, // 25096-25103
126, 126, 123, 123, 126, 126, 124, 124, // 25104-25111
125, 126, 126, 128, 129, 126, 125, 124, // 25112-25119
127, 128, 127, 126, 124, 125, 127, 126, // 25120-25127
126, 126, 127, 128, 129, 132, 132, 130, // 25128-25135
129, 127, 128, 128, 126, 126, 126, 125, // 25136-25143
126, 127, 128, 127, 127, 128, 129, 131, // 25144-25151
132, 130, 127, 127, 128, 127, 125, 124, // 25152-25159
124, 123, 124, 125, 125, 125, 126, 127, // 25160-25167
127, 129, 130, 127, 125, 125, 127, 127, // 25168-25175
127, 126, 126, 124, 126, 129, 130, 130, // 25176-25183
128, 128, 131, 133, 133, 130, 128, 127, // 25184-25191
127, 128, 128, 127, 126, 125, 124, 125, // 25192-25199
127, 125, 123, 125, 126, 127, 127, 128, // 25200-25207
126, 124, 124, 126, 127, 126, 127, 125, // 25208-25215
125, 127, 128, 126, 126, 127, 128, 129, // 25216-25223
130, 131, 129, 129, 128, 128, 128, 127, // 25224-25231
127, 126, 125, 126, 126, 126, 126, 127, // 25232-25239
128, 129, 130, 130, 130, 128, 127, 128, // 25240-25247
128, 127, 125, 124, 124, 125, 126, 125, // 25248-25255
124, 125, 127, 128, 129, 130, 128, 125, // 25256-25263
125, 126, 128, 126, 125, 125, 125, 126, // 25264-25271
126, 127, 126, 128, 127, 129, 131, 133, // 25272-25279
131, 128, 128, 129, 129, 128, 129, 127, // 25280-25287
126, 125, 125, 125, 126, 124, 125, 126, // 25288-25295
128, 127, 127, 126, 126, 125, 126, 125, // 25296-25303
125, 126, 125, 124, 125, 126, 124, 126, // 25304-25311
126, 128, 128, 131, 129, 130, 130, 131, // 25312-25319
150, 177, 162, 132,  92,  83,  76,  85, // 25320-25327
 94,  47,  76, 157, 188, 203, 210, 148, // 25328-25335
119, 167, 239, 245, 155, 128,  91,  11, // 25336-25343
 29,  80, 116,  72,  84, 143, 198, 253, // 25344-25351
175, 119,  77,  34,  66,  74, 254, 225, // 25352-25359
221, 237,  12,  32,  75,  58,  64, 150, // 25360-25367
206, 229, 239, 223, 221, 188, 214, 231, // 25368-25375
156, 108,  90,  89,  91, 156, 180, 107, // 25376-25383
 53, 108, 152, 183, 181, 115, 167, 196, // 25384-25391
246,  50, 238, 191, 122,  72, 127, 146, // 25392-25399
172, 157, 101, 135, 171, 172, 156, 134, // 25400-25407
106,  93,  58, 142, 203,  49, 197, 148, // 25408-25415
152, 160, 191, 230, 212,  34, 132, 192, // 25416-25423
232, 252,  14, 205, 216,  69,  63,  12, // 25424-25431
225, 219, 169, 109, 147, 179, 141, 142, // 25432-25439
211, 208,   3, 249, 160, 107,  49,  74, // 25440-25447
 59, 241, 214, 208, 223, 244,   8,  47, // 25448-25455
 23,  46, 125, 164, 197, 201, 199, 191, // 25456-25463
171, 193, 209, 134, 102,  79,  85,  88, // 25464-25471
 99, 183, 135,  70, 115, 151, 162, 184, // 25472-25479
136, 116, 157, 211,  18, 217, 172, 159, // 25480-25487
 94,  90, 133, 166, 158, 111, 153, 185, // 25488-25495
182, 170, 140, 128,  86,  95,  98, 137, // 25496-25503
127,   3, 187, 168, 168, 195, 220, 206, // 25504-25511
 24, 118, 163, 211, 221, 251, 236, 186, // 25512-25519
 17,  34, 243, 230, 205, 216, 140, 132, // 25520-25527
169, 140, 157, 213, 225, 216, 250, 212, // 25528-25535
133,  79,  88,  64, 247, 223, 214, 231, // 25536-25543
247,  10,  48,  21,  43, 136, 150, 181, // 25544-25551
188, 188, 187, 165, 195, 195, 135, 100, // 25552-25559
 91,  83, 101,  90, 141, 157, 108, 133, // 25560-25567
155, 161, 168, 162, 116, 112, 188, 233, // 25568-25575
198, 161, 156, 141,  95, 103, 161, 151, // 25576-25583
127, 163, 198, 190, 181, 148, 139,  98, // 25584-25591
100, 117,  60, 115,  83, 236, 204, 179, // 25592-25599
208, 216, 205,  20, 103, 143, 182, 202, // 25600-25607
220, 230, 207, 218, 240, 214, 216, 200, // 25608-25615
210, 188, 133, 153, 134, 168, 214, 230, // 25616-25623
220, 206, 237, 173, 107, 108,  68,   1, // 25624-25631
232, 223, 237, 250,  14,  43,  25,  42, // 25632-25639
132, 162, 160, 177, 178, 181, 161, 193, // 25640-25647
186, 129, 105,  90,  95,  96, 107, 114, // 25648-25655
131, 145, 160, 161, 166, 157, 162, 144, // 25656-25663
 89, 153, 203, 169, 156, 142, 150, 133, // 25664-25671
 88, 136, 142, 129, 177, 198, 201, 183, // 25672-25679
163, 142, 115, 105, 129,  57,  47, 116, // 25680-25687
 51, 244, 208, 219, 220, 206,  22,  87, // 25688-25695
127, 158, 177, 201, 199, 223, 220, 180, // 25696-25703
189, 194, 202, 200, 205, 172, 134, 128, // 25704-25711
167, 220, 223, 231, 193, 208, 208, 142, // 25712-25719
130,  78,  12, 244, 232, 246, 251,  19, // 25720-25727
 40,  21,  52, 112, 166, 163, 153, 172, // 25728-25735
168, 160, 187, 181, 124, 110,  93, 100, // 25736-25743
100, 109, 125,  94, 144, 192, 173, 169, // 25744-25751
157, 150, 156, 104, 121, 170, 145, 142, // 25752-25759
140, 141, 153, 118, 110, 125, 128, 182, // 25760-25767
201, 205, 190, 168, 154, 120, 125, 123, // 25768-25775
 78,  22,  70, 106,  42, 246, 240, 225, // 25776-25783
213,  23,  79, 111, 142, 156, 181, 179, // 25784-25791
204, 241, 161, 145, 174, 184, 201, 193, // 25792-25799
207, 146, 114, 167, 214, 226, 223, 208, // 25800-25807
183, 194, 181, 154,  93,  26,   1, 242, // 25808-25815
253,   3,  22,  42,  18,  60, 108, 143, // 25816-25823
183, 145, 155, 158, 154, 185, 168, 125, // 25824-25831
107,  99,  99, 107, 110, 130,  96, 117, // 25832-25839
202, 199, 176, 162, 147, 146, 128, 118, // 25840-25847
134, 126, 127, 133, 140, 147, 152, 125, // 25848-25855
 97, 126, 177, 202, 202, 194, 170, 157, // 25856-25863
125, 134, 129,  77,  44,  27,  96, 100, // 25864-25871
 34,  14, 236, 224,  26,  71, 101, 125, // 25872-25879
139, 158, 164, 186, 225, 181, 122, 146, // 25880-25887
168, 194, 193, 211, 183, 110, 162, 206, // 25888-25895
224, 222, 207, 191, 163, 190, 189, 110, // 25896-25903
 47,  16,   3,   7,  11,  30,  39,  23, // 25904-25911
 58, 113, 122, 168, 167, 135, 144, 145, // 25912-25919
179, 158, 121, 108, 100, 106, 106, 118, // 25920-25927
121, 102, 109, 173, 213, 192, 162, 152, // 25928-25935
136, 137, 138, 110, 103, 115, 123, 138, // 25936-25943
143, 152, 157,  95, 110, 174, 197, 205, // 25944-25951
192, 179, 160, 138, 141, 136,  80,  59, // 25952-25959
 34,  55, 114,  83,  45, 254, 236,  32, // 25960-25967
 66,  92, 111, 125, 143, 145, 177, 198, // 25968-25975
179, 138, 116, 149, 175, 190, 198, 193, // 25976-25983
138, 149, 200, 213, 223, 202, 199, 164, // 25984-25991
169, 203, 134,  66,  33,  13,  20,  15, // 25992-25999
 34,  38,  27,  63, 107, 127, 138, 174, // 26000-26007
153, 125, 143, 168, 153, 115, 111, 101, // 26008-26015
111, 108, 120, 125, 102, 123, 153, 194, // 26016-26023
212, 173, 155, 137, 129, 155, 111,  77, // 26024-26031
100, 113, 129, 140, 146, 163, 124, 102, // 26032-26039
163, 190, 203, 193, 181, 167, 143, 151, // 26040-26047
136,  90,  63,  51,  41,  84, 112,  83, // 26048-26055
 22,   2,  40,  67,  86, 102, 113, 131, // 26056-26063
134, 165, 184, 156, 153, 120, 123, 160, // 26064-26071
177, 198, 184, 168, 160, 183, 207, 213, // 26072-26079
205, 193, 174, 160, 183, 154,  90,  52, // 26080-26087
 29,  30,  28,  39,  43,  28,  71, 103, // 26088-26095
126, 132, 144, 176, 128, 130, 161, 142, // 26096-26103
117, 108, 106, 110, 114, 119, 127, 103, // 26104-26111
128, 157, 166, 203, 192, 161, 144, 128, // 26112-26119
153, 128,  68,  80, 101, 123, 134, 147, // 26120-26127
153, 139, 124, 143, 178, 192, 192, 181, // 26128-26135
170, 149, 159, 139,  94,  72,  58,  55, // 26136-26143
 60, 103, 116,  54,  27,  54,  69,  85, // 26144-26151
 94, 106, 118, 124, 153, 171, 142, 139, // 26152-26159
138, 115, 139, 164, 190, 176, 173, 188, // 26160-26167
174, 197, 204, 201, 193, 173, 173, 165, // 26168-26175
148, 120,  74,  50,  42,  39,  49,  43, // 26176-26183
 35,  73, 105, 115, 133, 123, 159, 154, // 26184-26191
122, 151, 131, 114, 107, 106, 113, 113, // 26192-26199
123, 121, 108, 127, 159, 161, 174, 193, // 26200-26207
177, 146, 138, 147, 135,  83,  65,  87, // 26208-26215
115, 127, 143, 151, 133, 150, 150, 159, // 26216-26223
184, 182, 182, 168, 155, 163, 143, 100, // 26224-26231
 82,  66,  67,  63,  82, 120,  88,  55, // 26232-26239
 69,  76,  84,  89,  96, 108, 112, 144, // 26240-26247
154, 137, 128, 136, 134, 120, 146, 176, // 26248-26255
170, 168, 202, 187, 181, 197, 193, 194, // 26256-26263
172, 180, 172, 133, 130, 103,  71,  61, // 26264-26271
 48,  58,  45,  39,  74, 102, 115, 123, // 26272-26279
126, 129, 157, 145, 135, 125, 107, 107, // 26280-26287
106, 115, 113, 125, 121, 107, 132, 155, // 26288-26295
164, 162, 170, 189, 155, 145, 153, 128, // 26296-26303
103,  70,  73, 104, 120, 136, 144, 127, // 26304-26311
150, 171, 151, 167, 173, 175, 168, 160, // 26312-26319
171, 149, 112,  93,  78,  77,  72,  73, // 26320-26327
102, 100,  87,  86,  85,  86,  86,  91, // 26328-26335
 99, 105, 135, 144, 125, 125, 123, 142, // 26336-26343
128, 126, 158, 156, 163, 197, 204, 180, // 26344-26351
182, 191, 189, 177, 182, 179, 134, 120, // 26352-26359
121,  97,  77,  64,  64,  50,  43,  78, // 26360-26367
 96, 113, 115, 121, 122, 127, 165, 140, // 26368-26375
107, 102, 100, 107, 114, 117, 127, 123, // 26376-26383
111, 138, 157, 164, 166, 155, 175, 173, // 26384-26391
154, 162, 128, 109,  91,  68,  94, 111, // 26392-26399
132, 136, 127, 146, 176, 167, 150, 160, // 26400-26407
165, 160, 159, 171, 148, 116,  98,  87, // 26408-26415
 85,  79,  77,  87,  91, 108, 110,  98, // 26416-26423
 96,  87,  92,  92,  99, 125, 129, 113, // 26424-26431
116, 120, 132, 141, 127, 140, 144, 161, // 26432-26439
193, 211, 199, 173, 185, 186, 177, 185, // 26440-26447
174, 141, 115, 116, 122,  97,  81,  78, // 26448-26455
 58,  53,  82,  99, 107, 112, 112, 122, // 26456-26463
108, 148, 160,  99,  91,  94, 103, 112, // 26464-26471
114, 128, 121, 115, 139, 157, 161, 162, // 26472-26479
156, 157, 168, 170, 161, 132, 107, 105, // 26480-26487
 81,  83, 103, 125, 130, 124, 150, 168, // 26488-26495
178, 158, 143, 159, 154, 158, 170, 148, // 26496-26503
122, 107,  97,  96,  88,  87,  84,  83, // 26504-26511
113, 132, 115, 103,  92,  90,  89,  92, // 26512-26519
120, 117, 105, 106, 115, 125, 134, 140, // 26520-26527
130, 126, 153, 185, 200, 207, 178, 171, // 26528-26535
180, 173, 187, 172, 141, 125, 108, 123, // 26536-26543
119,  96,  91,  65,  64,  87, 101, 108, // 26544-26551
109, 111, 115, 113, 127, 159, 121,  84, // 26552-26559
 91, 100, 111, 115, 128, 120, 117, 140, // 26560-26567
154, 161, 158, 155, 151, 147, 176, 170, // 26568-26575
134, 112, 104, 101,  84,  93, 120, 125, // 26576-26583
120, 148, 166, 172, 173, 144, 146, 148, // 26584-26591
154, 168, 145, 125, 113, 103, 102,  94, // 26592-26599
 98,  88,  77, 109, 137, 135, 115, 100, // 26600-26607
 95,  88,  93, 115, 110,  97, 102, 108, // 26608-26615
123, 126, 144, 139, 114, 141, 178, 191, // 26616-26623
203, 191, 168, 167, 171, 185, 173, 141, // 26624-26631
129, 113, 112, 127, 117, 100,  74,  70, // 26632-26639
 92, 100, 110, 107, 111, 109, 111, 125, // 26640-26647
135, 135,  97,  82,  97, 107, 116, 127, // 26648-26655
118, 119, 143, 155, 162, 160, 154, 154, // 26656-26663
141, 164, 179, 137, 118, 104, 105,  98, // 26664-26671
 86, 110, 114, 117, 144, 164, 167, 171, // 26672-26679
157, 138, 138, 152, 163, 143, 125, 116, // 26680-26687
108, 108, 102, 104,  95,  77, 105, 132, // 26688-26695
142, 131, 106, 100,  90,  95, 111, 103, // 26696-26703
 90,  95, 102, 118, 124, 133, 143, 120, // 26704-26711
132, 170, 186, 192, 193, 176, 160, 168, // 26712-26719
184, 170, 142, 130, 122, 116, 119, 130, // 26720-26727
114,  85,  84, 100, 105, 108, 106, 105, // 26728-26735
107, 106, 126, 118, 119, 118,  85,  91, // 26736-26743
104, 112, 124, 117, 122, 146, 157, 161, // 26744-26751
158, 154, 153, 145, 151, 167, 146, 121, // 26752-26759
111, 106, 110,  92,  98, 106, 113, 145, // 26760-26767
158, 166, 164, 164, 151, 132, 148, 157, // 26768-26775
138, 125, 119, 114, 114, 109, 108,  99, // 26776-26783
 87, 105, 133, 139, 141, 119, 104,  96, // 26784-26791
 96, 109,  95,  85,  87,  97, 110, 119, // 26792-26799
130, 135, 130, 133, 156, 180, 186, 186, // 26800-26807
186, 160, 160, 180, 166, 143, 131, 125, // 26808-26815
123, 115, 127, 128,  95,  95, 106, 108, // 26816-26823
110, 107, 106, 106, 106, 123, 119, 100, // 26824-26831
118, 104,  87,  98, 110, 121, 114, 122, // 26832-26839
145, 155, 159, 156, 153, 151, 146, 154, // 26840-26847
152, 147, 131, 115, 110, 111, 109,  99, // 26848-26855
100, 111, 141, 155, 163, 163, 158, 159, // 26856-26863
135, 138, 152, 135, 124, 118, 115, 114, // 26864-26871
110, 113, 101,  94, 107, 124, 137, 139, // 26872-26879
134, 116, 100, 101, 108,  94,  85,  87, // 26880-26887
 94, 107, 114, 130, 130, 130, 145, 150, // 26888-26895
165, 181, 179, 183, 169, 154, 172, 162, // 26896-26903
143, 135, 126, 126, 120, 119, 129, 112, // 26904-26911
105, 114, 111, 112, 107, 108, 102, 105, // 26912-26919
117, 117, 100, 105, 118,  99,  90, 106, // 26920-26927
119, 113, 122, 142, 150, 156, 155, 154, // 26928-26935
149, 143, 154, 147, 135, 139, 124, 116, // 26936-26943
111, 115, 111,  94, 109, 136, 151, 156, // 26944-26951
161, 159, 158, 146, 138, 140, 131, 123, // 26952-26959
118, 116, 114, 111, 116, 106,  99, 115, // 26960-26967
120, 133, 136, 135, 130, 106, 106, 109, // 26968-26975
 93,  85,  87,  92, 102, 109, 125, 129, // 26976-26983
126, 148, 156, 154, 169, 175, 175, 171, // 26984-26991
159, 162, 155, 144, 136, 130, 128, 124, // 26992-26999
124, 122, 121, 120, 121, 118, 116, 111, // 27000-27007
110, 105, 103, 116, 110, 101,  97, 110, // 27008-27015
116,  94,  99, 114, 111, 121, 140, 148, // 27016-27023
153, 154, 155, 148, 144, 151, 146, 128, // 27024-27031
132, 133, 122, 115, 114, 121,  99, 103, // 27032-27039
132, 144, 153, 153, 158, 153, 147, 146, // 27040-27047
133, 122, 122, 118, 118, 117, 116, 117, // 27048-27055
110, 105, 120, 125, 127, 137, 133, 134, // 27056-27063
119, 112, 111,  94,  87,  87,  94, 100, // 27064-27071
108, 120, 123, 124, 143, 159, 154, 153, // 27072-27079
164, 168, 165, 165, 159, 147, 141, 138, // 27080-27087
133, 132, 127, 129, 121, 117, 132, 130, // 27088-27095
124, 118, 115, 112, 106, 107, 116, 108, // 27096-27103
 98,  98, 100, 118, 111,  99, 105, 108, // 27104-27111
122, 139, 145, 151, 150, 152, 148, 146, // 27112-27119
152, 143, 128, 123, 131, 131, 121, 117, // 27120-27127
120, 109, 103, 127, 140, 147, 148, 149, // 27128-27135
149, 145, 151, 137, 114, 115, 118, 120, // 27136-27143
120, 121, 122, 113, 113, 125, 133, 130, // 27144-27151
132, 136, 130, 127, 122, 114,  96,  87, // 27152-27159
 87,  92, 100, 106, 116, 115, 120, 138, // 27160-27167
154, 157, 150, 152, 160, 159, 167, 163, // 27168-27175
141, 136, 135, 134, 134, 133, 131, 125, // 27176-27183
116, 133, 143, 133, 126, 117, 113, 108, // 27184-27191
109, 112, 105,  95,  95,  97, 108, 119, // 27192-27199
111, 106, 111, 124, 139, 143, 144, 144, // 27200-27207
143, 142, 142, 143, 137, 128, 124, 126, // 27208-27215
132, 130, 127, 125, 124, 124, 128, 135, // 27216-27223
137, 136, 132, 133, 133, 134, 130, 120, // 27224-27231
116, 118, 121, 124, 123, 123, 123, 125, // 27232-27239
129, 132, 132, 130, 128, 127, 127, 128, // 27240-27247
124, 118, 115, 116, 117, 119, 121, 123, // 27248-27255
124, 126, 130, 135, 137, 137, 133, 131, // 27256-27263
135, 135, 132, 129, 127, 128, 127, 128, // 27264-27271
130, 128, 127, 128, 130, 133, 134, 131, // 27272-27279
128, 126, 127, 124, 122, 121, 119, 117, // 27280-27287
116, 119, 121, 120, 121, 123, 126, 130, // 27288-27295
133, 133, 132, 132, 132, 132, 130, 131, // 27296-27303
128, 127, 126, 128, 129, 128, 128, 129, // 27304-27311
131, 133, 131, 131, 130, 127, 125, 124, // 27312-27319
122, 122, 121, 121, 118, 120, 122, 123, // 27320-27327
123, 127, 129, 130, 131, 131, 132, 129, // 27328-27335
128, 128, 127, 128, 128, 126, 126, 126, // 27336-27343
126, 125, 125, 127, 129, 128, 129, 130, // 27344-27351
129, 129, 127, 128, 128, 127, 128, 129, // 27352-27359
129, 128, 127, 126, 127, 128, 129, 130, // 27360-27367
130, 132, 132, 129, 128, 128, 127, 123, // 27368-27375
122, 122, 121, 120, 120, 119, 119, 121, // 27376-27383
124, 125, 127, 130, 131, 130, 132, 133, // 27384-27391
130, 129, 130, 129, 127, 127, 129, 129, // 27392-27399
129, 130, 131, 131, 132, 134, 131, 129, // 27400-27407
129, 128, 125, 122, 122, 121, 120, 119, // 27408-27415
120, 120, 122, 124, 127, 129, 130, 131, // 27416-27423
130, 130, 130, 129, 128, 127, 128, 128, // 27424-27431
127, 127, 128, 126, 124, 124, 126, 128, // 27432-27439
128, 128, 128, 127, 127, 127, 127, 126, // 27440-27447
126, 128, 129, 129, 129, 128, 127, 126, // 27448-27455
127, 128, 129, 130, 131, 132, 129, 128, // 27456-27463
128, 127, 125, 124, 123, 122, 122, 122, // 27464-27471
120, 119, 120, 122, 124, 125, 128, 130, // 27472-27479
131, 131, 132, 131, 129, 129, 129, 128, // 27480-27487
129, 128, 129, 129, 131, 131, 130, 131, // 27488-27495
131, 130, 128, 128, 128, 127, 123, 122, // 27496-27503
122, 121, 121, 122, 122, 122, 125, 128, // 27504-27511
129, 131, 130, 129, 129, 130, 130, 128, // 27512-27519
127, 128, 128, 127, 127, 127, 127, 126, // 27520-27527
125, 125, 127, 129, 129, 126, 125, 125, // 27528-27535
124, 124, 125, 126, 125, 128, 128, 129, // 27536-27543
130, 128, 128, 128, 128, 130, 130, 130, // 27544-27551
131, 130, 128, 127, 128, 127, 125, 123, // 27552-27559
123, 123, 124, 123, 122, 121, 121, 124, // 27560-27567
124, 126, 128, 129, 130, 131, 132, 131, // 27568-27575
128, 129, 128, 128, 129, 129, 129, 130, // 27576-27583
130, 130, 130, 130, 130, 128, 127, 127, // 27584-27591
128, 127, 123, 122, 121, 120, 120, 122, // 27592-27599
123, 124, 126, 129, 130, 131, 129, 127, // 27600-27607
128, 128, 129, 129, 127, 129, 128, 126, // 27608-27615
127, 127, 127, 126, 126, 127, 128, 129, // 27616-27623
128, 126, 125, 124, 125, 126, 127, 127, // 27624-27631
127, 129, 129, 130, 130, 129, 128, 128, // 27632-27639
127, 128, 130, 131, 130, 129, 127, 128, // 27640-27647
128, 126, 126, 124, 123, 123, 124, 123, // 27648-27655
120, 120, 122, 122, 123, 125, 129, 129, // 27656-27663
130, 131, 130, 130, 128, 127, 126, 126, // 27664-27671
128, 129, 131, 132, 132, 129, 130, 131, // 27672-27679
131, 129, 127, 129, 128, 125, 123, 121, // 27680-27687
120, 119, 120, 122, 124, 127, 128, 128, // 27688-27695
129, 128, 128, 127, 126, 127, 127, 128, // 27696-27703
129, 128, 127, 126, 126, 129, 127, 128, // 27704-27711
128, 129, 128, 128, 128, 127, 124, 125, // 27712-27719
126, 126, 126, 128, 128, 128, 128, 129, // 27720-27727
129, 128, 129, 127, 127, 130, 131, 130, // 27728-27735
128, 129, 128, 127, 126, 126, 124, 122, // 27736-27743
123, 123, 124, 123, 122, 122, 122, 123, // 27744-27751
125, 127, 128, 129, 130, 129, 129, 129, // 27752-27759
128, 126, 126, 129, 130, 132, 132, 133, // 27760-27767
131, 130, 131, 131, 128, 128, 127, 126, // 27768-27775
125, 125, 123, 120, 120, 120, 122, 123, // 27776-27783
126, 128, 128, 129, 129, 128, 128, 126, // 27784-27791
125, 127, 128, 128, 129, 128, 126, 126, // 27792-27799
128, 128, 128, 128, 129, 128, 127, 128, // 27800-27807
128, 126, 124, 124, 126, 127, 128, 128, // 27808-27815
128, 128, 129, 129, 128, 129, 127, 127, // 27816-27823
128, 130, 130, 129, 127, 128, 128, 128, // 27824-27831
126, 125, 123, 122, 122, 123, 123, 123, // 27832-27839
122, 122, 123, 125, 127, 127, 127, 128, // 27840-27847
130, 130, 131, 130, 128, 127, 128, 130, // 27848-27855
131, 132, 132, 131, 131, 131, 131, 128, // 27856-27863
127, 128, 127, 126, 125, 125, 123, 120, // 27864-27871
120, 121, 124, 125, 125, 126, 127, 128, // 27872-27879
127, 126, 126, 125, 126, 128, 129, 129, // 27880-27887
129, 126, 126, 128, 129, 129, 127, 127, // 27888-27895
129, 128, 128, 127, 126, 124, 124, 125, // 27896-27903
128, 129, 129, 127, 128, 129, 130, 129, // 27904-27911
129, 129, 128, 128, 129, 130, 129, 127, // 27912-27919
127, 129, 129, 128, 126, 124, 123, 124, // 27920-27927
125, 123, 122, 123, 122, 121, 123, 124, // 27928-27935
125, 125, 125, 128, 131, 130, 129, 128, // 27936-27943
127, 128, 129, 130, 131, 131, 130, 130, // 27944-27951
132, 132, 129, 126, 126, 128, 129, 128, // 27952-27959
127, 125, 122, 121, 122, 125, 126, 126, // 27960-27967
125, 126, 128, 129, 127, 125, 124, 125, // 27968-27975
128, 128, 130, 129, 126, 125, 127, 129, // 27976-27983
128, 128, 128, 127, 128, 128, 126, 126, // 27984-27991
125, 125, 126, 126, 128, 128, 126, 125, // 27992-27999
128, 129, 130, 129, 129, 128, 128, 129, // 28000-28007
128, 129, 127, 128, 129, 130, 130, 128, // 28008-28015
125, 124, 125, 126, 126, 123, 124, 123, // 28016-28023
123, 124, 124, 124, 124, 123, 126, 128, // 28024-28031
130, 129, 127, 125, 125, 128, 130, 130, // 28032-28039
130, 129, 129, 132, 132, 131, 129, 127, // 28040-28047
128, 130, 130, 129, 125, 124, 123, 122, // 28048-28055
124, 126, 126, 125, 125, 126, 128, 128, // 28056-28063
126, 125, 125, 127, 128, 129, 128, 127, // 28064-28071
125, 126, 129, 130, 129, 129, 128, 128, // 28072-28079
128, 127, 126, 124, 125, 124, 125, 126, // 28080-28087
126, 126, 125, 127, 128, 129, 129, 128, // 28088-28095
127, 128, 128, 127, 127, 127, 127, 128, // 28096-28103
130, 130, 128, 127, 126, 125, 127, 127, // 28104-28111
125, 125, 125, 124, 124, 124, 125, 124, // 28112-28119
124, 125, 129, 129, 130, 127, 127, 125, // 28120-28127
129, 128, 130, 129, 135, 165, 170, 147, // 28128-28135
108,  89,  75,  92,  72,  41, 120, 165, // 28136-28143
186, 196, 131, 120, 189,   6, 193, 145, // 28144-28151
109,  31,  39, 103, 108,  75, 122, 186, // 28152-28159
  2, 198, 135,  87,  57, 103,  45, 245, // 28160-28167
224, 236, 253,  22,  54,  20,  81, 158, // 28168-28175
196, 208, 207, 200, 183, 228, 196, 121, // 28176-28183
101,  86,  97, 163, 171,  67,  71, 126, // 28184-28191
167, 171, 111, 168, 193,  27,  27, 221, // 28192-28199
157,  85, 135, 157, 193, 147, 125, 178, // 28200-28207
187, 182, 154, 135, 105,  96, 222, 149, // 28208-28215
245, 168, 150, 152, 188, 194, 195,  49, // 28216-28223
125, 173, 204, 230, 161, 227,  62,  28, // 28224-28231
236, 225, 183, 119, 168, 185, 143, 202, // 28232-28239
226,  15,  30, 199, 134,  89, 115,  49, // 28240-28247
248, 223, 228, 239,   7,  32,   2,  64, // 28248-28255
123, 164, 180, 183, 181, 161, 206, 169, // 28256-28263
111,  80,  80,  77, 101, 176,  96,  76, // 28264-28271
131, 144, 176, 128, 113, 155, 238,   6, // 28272-28279
188, 180, 112,  98, 138, 185, 153, 138, // 28280-28287
190, 204, 196, 171, 146, 113, 114, 132, // 28288-28295
171,  74, 214, 176, 160, 192, 192, 190, // 28296-28303
 35, 100, 155, 171, 216, 190, 173,  14, // 28304-28311
249, 232, 211, 222, 152, 147, 181, 152, // 28312-28319
208, 247, 242,  19,   0, 165, 119, 127, // 28320-28327
 62, 255, 233, 233, 246,   5,  34, 249, // 28328-28335
 64, 121, 141, 166, 168, 171, 153, 198, // 28336-28343
168, 112,  89,  79,  94,  87, 147, 140, // 28344-28351
109, 143, 150, 161, 162, 112, 111, 201, // 28352-28359
229, 182, 162, 156, 104, 107, 169, 149, // 28360-28367
144, 199, 208, 206, 173, 161, 112, 137, // 28368-28375
114, 102, 139,  28, 221, 183, 205, 195, // 28376-28383
191,  22,  86, 130, 155, 175, 195, 174, // 28384-28391
208, 208, 206, 198, 209, 196, 146, 158, // 28392-28399
150, 203, 243, 250, 233,  14, 212, 142, // 28400-28407
146,  76,  19, 246, 244, 251,  11,  35, // 28408-28415
  2,  51, 133, 135, 146, 160, 163, 153, // 28416-28423
189, 162, 108,  91,  81,  90,  95, 109, // 28424-28431
120, 145, 154, 162, 156, 160, 143,  88, // 28432-28439
171, 200, 171, 152, 153, 147,  96, 141, // 28440-28447
141, 145, 200, 214, 215, 189, 171, 131, // 28448-28455
135, 144,  57, 111, 102,  13, 215, 212, // 28456-28463
200, 191,  14,  68, 111, 134, 164, 169, // 28464-28471
202, 190, 162, 177, 190, 195, 207, 178, // 28472-28479
135, 134, 197, 237, 252, 227, 228, 244, // 28480-28487
181, 169,  94,  34,   1, 254,   2,  18, // 28488-28495
 33,   9,  45, 116, 153, 136, 150, 152, // 28496-28503
148, 186, 161, 115,  94,  88,  89,  97, // 28504-28511
112,  86, 153, 182, 163, 162, 144, 158, // 28512-28519
101, 126, 168, 143, 148, 137, 161, 129, // 28520-28527
117, 124, 144, 204, 223, 220, 198, 178, // 28528-28535
146, 144, 146,  74,  48, 114,  82,   4, // 28536-28543
242, 213, 198,  13,  61, 101, 118, 148, // 28544-28551
145, 181, 209, 129, 138, 162, 184, 188, // 28552-28559
207, 152, 120, 191, 233, 247, 241, 217, // 28560-28567
224, 221, 190, 112,  45,  14,   4,   8, // 28568-28575
 17,  34,   5,  58, 100, 154, 151, 131, // 28576-28583
147, 142, 183, 157, 115,  95,  89,  94, // 28584-28591
 96, 118,  81, 118, 202, 186, 172, 152, // 28592-28599
151, 132, 118, 133, 126, 131, 137, 142, // 28600-28607
151, 128,  93, 128, 191, 214, 218, 199, // 28608-28615
189, 153, 160, 147,  95,  46,  67, 127, // 28616-28623
 60,  22, 231, 210,  13,  55,  88, 107, // 28624-28631
127, 139, 160, 210, 149, 110, 137, 171, // 28632-28639
179, 205, 187, 111, 170, 219, 238, 230, // 28640-28647
224, 193, 216, 225, 132,  69,  31,  20, // 28648-28655
 17,  24,  38,  13,  56, 101, 123, 163, // 28656-28663
132, 128, 134, 172, 153, 113,  99,  94, // 28664-28671
 99, 101, 116,  91, 102, 179, 214, 181, // 28672-28679
160, 143, 135, 139, 108, 104, 113, 128, // 28680-28687
139, 146, 163,  99, 108, 180, 207, 219, // 28688-28695
203, 193, 160, 163, 154,  93,  67,  38, // 28696-28703
 99, 108,  58,   3, 226,  22,  53,  81, // 28704-28711
 95, 116, 123, 152, 183, 162, 110, 104, // 28712-28719
149, 173, 190, 197, 139, 155, 209, 234, // 28720-28727
232, 224, 200, 187, 238, 163,  89,  45, // 28728-28735
 28,  21,  29,  38,  15,  50, 103, 114, // 28736-28743
142, 161, 121, 125, 163, 150, 115, 102, // 28744-28751
 98, 101, 103, 116,  91, 111, 149, 204, // 28752-28759
206, 168, 156, 129, 161, 117,  76,  98, // 28760-28767
112, 137, 136, 163, 126,  95, 158, 198, // 28768-28775
212, 204, 195, 168, 171, 165, 105,  79, // 28776-28783
 53,  61, 114, 108,  36, 248,  28,  51, // 28784-28791
 73,  84, 106, 108, 137, 168, 145, 132, // 28792-28799
 97, 121, 155, 182, 187, 165, 159, 189, // 28800-28807
220, 225, 219, 206, 185, 214, 193, 119, // 28808-28815
 73,  49,  38,  38,  47,  21,  54,  92, // 28816-28823
116, 113, 152, 138, 104, 151, 137, 114, // 28824-28831
102, 102, 105, 107, 119,  94, 114, 149, // 28832-28839
171, 212, 186, 163, 132, 153, 140,  70, // 28840-28847
 79, 102, 126, 137, 152, 142, 119, 137, // 28848-28855
180, 200, 197, 195, 170, 175, 167, 115, // 28856-28863
 84,  69,  59,  83, 134,  82,  25,  45, // 28864-28871
 61,  74,  82,  96, 101, 122, 157, 130, // 28872-28879
128, 111,  99, 126, 166, 173, 165, 183, // 28880-28887
173, 203, 214, 218, 202, 196, 198, 184, // 28888-28895
151,  97,  69,  52,  48,  52,  28,  60, // 28896-28903
 94, 115, 119, 125, 160, 120, 137, 133, // 28904-28911
109, 102, 100, 103, 105, 115,  92, 106, // 28912-28919
146, 157, 181, 201, 172, 145, 152, 149, // 28920-28927
 91,  64,  90, 115, 131, 151, 134, 139, // 28928-28935
143, 154, 189, 191, 194, 173, 181, 172, // 28936-28943
127,  97,  78,  74,  65, 114, 113,  61, // 28944-28951
 61,  65,  73,  76,  89,  89, 113, 142, // 28952-28959
125, 113, 122, 112, 107, 150, 166, 154, // 28960-28967
195, 186, 183, 202, 208, 198, 190, 203, // 28968-28975
161, 156, 124,  88,  68,  62,  60,  38, // 28976-28983
 64,  97, 109, 122, 117, 136, 146, 130, // 28984-28991
121, 102, 102, 104, 109, 110, 121,  98, // 28992-28999
113, 143, 161, 160, 183, 187, 149, 154, // 29000-29007
137, 106,  64,  65, 100, 119, 146, 130, // 29008-29015
138, 167, 150, 168, 183, 189, 175, 181, // 29016-29023
177, 132, 108,  86,  85,  73,  93, 116, // 29024-29031
 98,  89,  82,  83,  79,  87,  86, 107, // 29032-29039
130, 113, 107, 109, 123, 104, 121, 149, // 29040-29047
146, 185, 207, 181, 186, 199, 195, 191, // 29048-29055
207, 163, 137, 141, 114,  87,  73,  67, // 29056-29063
 41,  66,  95, 111, 115, 123, 112, 142, // 29064-29071
156, 110, 100,  96, 103, 108, 112, 121, // 29072-29079
103, 115, 142, 154, 161, 158, 191, 169, // 29080-29087
165, 141, 110,  92,  62,  86, 107, 131, // 29088-29095
125, 130, 167, 164, 147, 162, 177, 171, // 29096-29103
182, 178, 137, 115,  97,  92,  84,  88, // 29104-29111
 97, 113, 123, 102,  95,  86,  89,  86, // 29112-29119
102, 125, 105, 105, 103, 117, 120, 112, // 29120-29127
126, 138, 172, 202, 195, 171, 188, 188, // 29128-29135
190, 197, 169, 135, 135, 139, 107,  89, // 29136-29143
 78,  51,  74,  95, 106, 110, 115, 117, // 29144-29151
116, 169, 120,  84,  91,  97, 107, 112, // 29152-29159
122, 103, 117, 144, 153, 161, 157, 166, // 29160-29167
179, 177, 154, 115, 109,  80,  72,  96, // 29168-29175
122, 120, 130, 158, 172, 156, 143, 167, // 29176-29183
164, 180, 176, 138, 119, 106,  99,  91, // 29184-29191
 90,  82, 100, 139, 126, 105,  92,  89, // 29192-29199
 86, 101, 120, 102,  99, 102, 109, 122, // 29200-29207
124, 109, 120, 163, 187, 205, 179, 174, // 29208-29215
182, 185, 200, 168, 146, 126, 140, 131, // 29216-29223
107,  92,  64,  77,  95, 100, 109, 109, // 29224-29231
118, 109, 145, 146,  86,  84,  92, 101, // 29232-29239
108, 119, 103, 120, 143, 152, 151, 155, // 29240-29247
152, 164, 191, 163, 123, 109, 101,  80, // 29248-29255
 86, 114, 113, 126, 155, 166, 173, 146, // 29256-29263
149, 157, 174, 175, 143, 129, 114, 109, // 29264-29271
 97, 102,  83,  89, 134, 143, 121,  98, // 29272-29279
 94,  85,  98, 112,  95,  92,  96, 106, // 29280-29287
112, 130, 113, 100, 153, 176, 195, 193, // 29288-29295
168, 170, 180, 198, 168, 148, 133, 128, // 29296-29303
140, 126, 104,  76,  85,  98, 103, 104, // 29304-29311
110, 112, 115, 128, 142, 117,  81,  90, // 29312-29319
100, 109, 118, 107, 121, 143, 149, 153, // 29320-29327
149, 153, 143, 182, 172, 132, 112, 107, // 29328-29335
 96,  78, 103, 103, 117, 147, 159, 168, // 29336-29343
160, 139, 142, 166, 170, 145, 133, 120, // 29344-29351
115, 107, 111,  95,  88, 127, 146, 144, // 29352-29359
115, 103,  90,  96, 110,  93,  91,  92, // 29360-29367
102, 107, 121, 125, 100, 132, 169, 180, // 29368-29375
192, 177, 157, 171, 187, 168, 146, 136, // 29376-29383
125, 128, 141, 122,  88,  96, 104, 108, // 29384-29391
107, 110, 109, 111, 129, 120, 131,  99, // 29392-29399
 82,  94, 103, 117, 107, 122, 142, 150, // 29400-29407
154, 151, 151, 144, 162, 174, 143, 123, // 29408-29415
110, 111,  90,  92,  98, 113, 142, 156, // 29416-29423
161, 164, 152, 129, 158, 163, 143, 130, // 29424-29431
120, 117, 111, 111, 100,  87, 114, 137, // 29432-29439
148, 134, 111,  96,  97, 109,  96,  92, // 29440-29447
 94, 103, 109, 121, 127, 117, 123, 151, // 29448-29455
173, 180, 186, 158, 159, 181, 164, 150, // 29456-29463
139, 136, 123, 136, 137, 100, 101, 105, // 29464-29471
106, 107, 107, 107, 105, 129, 114, 115, // 29472-29479
124,  92,  91, 104, 116, 107, 121, 140, // 29480-29487
148, 149, 150, 146, 142, 150, 156, 153, // 29488-29495
132, 115, 114, 108,  97,  93, 110, 138, // 29496-29503
153, 160, 158, 162, 135, 139, 153, 139, // 29504-29511
133, 125, 123, 116, 119, 104,  97, 112, // 29512-29519
133, 144, 143, 125,  96,  97, 103,  90, // 29520-29527
 86,  89,  99, 107, 120, 121, 120, 132, // 29528-29535
136, 161, 170, 182, 172, 152, 172, 161, // 29536-29543
150, 142, 138, 132, 129, 142, 120, 113, // 29544-29551
116, 112, 109, 107, 106, 105, 123, 118, // 29552-29559
100, 119, 114,  87,  94, 109, 105, 118, // 29560-29567
138, 147, 150, 148, 149, 142, 155, 146, // 29568-29575
145, 143, 127, 118, 114, 107,  85, 101, // 29576-29583
130, 147, 155, 153, 153, 144, 135, 141, // 29584-29591
135, 133, 129, 128, 122, 125, 112, 105, // 29592-29599
117, 124, 140, 141, 143, 115, 105, 107, // 29600-29607
 91,  88,  92, 101, 106, 116, 118, 111, // 29608-29615
133, 133, 138, 155, 164, 172, 160, 162, // 29616-29623
155, 146, 142, 141, 137, 130, 130, 129, // 29624-29631
128, 123, 118, 111, 109, 107, 107, 123, // 29632-29639
118, 105, 105, 126, 108,  92, 104, 101, // 29640-29647
116, 136, 145, 147, 145, 145, 137, 148, // 29648-29655
142, 128, 143, 139, 127, 117, 120,  93, // 29656-29663
 97, 127, 142, 150, 151, 153, 149, 149, // 29664-29671
131, 123, 126, 129, 131, 127, 125, 113, // 29672-29679
104, 121, 121, 133, 138, 141, 132, 117, // 29680-29687
114,  94,  87,  87,  96, 102, 114, 117, // 29688-29695
113, 133, 144, 137, 145, 162, 166, 168, // 29696-29703
159, 146, 143, 140, 139, 131, 130, 123, // 29704-29711
120, 139, 133, 124, 117, 114, 114, 110, // 29712-29719
124, 113, 107, 103, 116, 126, 100,  96, // 29720-29727
 95, 113, 133, 142, 146, 148, 146, 142, // 29728-29735
150, 146, 128, 128, 139, 134, 120, 121, // 29736-29743
104,  91, 114, 130, 142, 146, 151, 145, // 29744-29751
155, 141, 118, 125, 127, 130, 127, 130, // 29752-29759
118, 111, 122, 124, 122, 133, 135, 136, // 29760-29767
131, 119,  98,  90,  92,  99, 101, 111, // 29768-29775
114, 113, 131, 143, 144, 133, 149, 154, // 29776-29783
165, 167, 142, 142, 141, 143, 139, 136, // 29784-29791
132, 115, 136, 144, 130, 121, 114, 111, // 29792-29799
106, 116, 108, 103, 103, 104, 124, 121, // 29800-29807
102,  94, 112, 131, 138, 143, 145, 146, // 29808-29815
140, 150, 139, 128, 121, 131, 141, 129, // 29816-29823
125, 115, 106, 112, 127, 138, 145, 149, // 29824-29831
145, 151, 150, 119, 114, 121, 127, 126, // 29832-29839
129, 121, 116, 126, 128, 125, 126, 138, // 29840-29847
130, 139, 128, 104,  94,  89,  93,  96, // 29848-29855
107, 110, 108, 129, 138, 146, 139, 139, // 29856-29863
151, 159, 173, 148, 138, 142, 141, 138, // 29864-29871
135, 131, 117, 124, 141, 139, 126, 120, // 29872-29879
114, 113, 120, 111, 104, 105, 105, 112, // 29880-29887
127, 115,  89, 104, 122, 131, 138, 141, // 29888-29895
144, 140, 149, 143, 131, 128, 122, 137, // 29896-29903
139, 131, 116, 115, 114, 117, 130, 138, // 29904-29911
145, 144, 152, 152, 135, 118, 120, 127, // 29912-29919
129, 132, 124, 118, 126, 123, 126, 117, // 29920-29927
128, 128, 132, 137, 108,  98,  93,  96, // 29928-29935
 97, 106, 108, 110, 127, 137, 141, 145, // 29936-29943
137, 139, 152, 166, 154, 135, 136, 142, // 29944-29951
141, 140, 134, 125, 130, 136, 145, 135, // 29952-29959
126, 118, 112, 119, 109, 103, 104, 106, // 29960-29967
106, 118, 128, 103, 104, 122, 130, 137, // 29968-29975
139, 143, 142, 148, 139, 126, 125, 121, // 29976-29983
122, 133, 133, 115, 118, 123, 115, 125, // 29984-29991
135, 145, 143, 153, 150, 138, 127, 116, // 29992-29999
123, 126, 130, 124, 123, 134, 128, 142, // 30000-30007
208, 207, 158,  78,  41,   9,  27,  31, // 30008-30015
254,  83, 149, 199, 148, 165, 219,  24, // 30016-30023
 61, 206, 102, 117, 155, 154, 177,  93, // 30024-30031
168, 232, 173, 125,  89,  66,  60, 108, // 30032-30039
 31,   6, 234,  22,  63,  31,  14,  40, // 30040-30047
137, 175, 200, 195, 195, 174, 240, 176, // 30048-30055
143, 163, 110,  72,  68,  59, 214,  63, // 30056-30063
171, 242,   2,  28, 242, 223, 255, 205, // 30064-30071
180, 154, 144, 125, 121,  37,  83, 104, // 30072-30079
184, 248, 147,  36,  11,  30, 215, 197, // 30080-30087
196, 236,   5,  68,  56,  42, 149,  10, // 30088-30095
 48,  81,  25, 230,  64,  18, 225, 187, // 30096-30103
162, 188, 184,  76,  16,  55,  81,  87, // 30104-30111
 90,  85,  82, 114, 136,  79, 253,  23, // 30112-30119
 34,  68,  73,  46, 109, 164, 183, 195, // 30120-30127
188, 209,  10, 218, 108,  64,  38, 237, // 30128-30135
 33, 105, 101, 147, 239, 240, 192, 242, // 30136-30143
249,   1,  27, 196, 128,  86,  69,  52, // 30144-30151
 47,  87, 109,  77,  47,  27,  20,  23, // 30152-30159
 30, 100,  89,  56,  59,  76,  39, 113, // 30160-30167
162, 157, 251, 233, 251,  32,  42,  14, // 30168-30175
 37,   8, 234, 157,  74,  32,   9,  15, // 30176-30183
212,  11,  67, 111, 102, 173, 126, 104, // 30184-30191
159, 106,  83,  63,  74,  65,  97,  55, // 30192-30199
 85, 135, 226, 239, 192, 155, 148, 160, // 30200-30207
 75,  88,  98, 137, 134, 182, 117,  79, // 30208-30215
188, 241,   9, 247, 231, 188, 207, 163, // 30216-30223
 84,  46, 110,  92,   6, 214, 157, 217, // 30224-30231
 15,  59,  80, 120, 118, 181, 192,  98, // 30232-30239
132, 158, 193, 193, 158, 129, 194,   0, // 30240-30247
 29,   9,   1,  17, 209, 188,  92,  30, // 30248-30255
245, 250, 246,  22,   4,   4, 137, 115, // 30256-30263
119, 144, 156, 149, 194, 161, 109,  85, // 30264-30271
 82,  86,  96, 145, 101, 120, 130, 156, // 30272-30279
110, 109, 143, 212, 234, 177, 168, 106, // 30280-30287
104, 147, 177, 132, 161, 192, 199, 179, // 30288-30295
170, 130, 151, 235, 131,  13, 203, 192, // 30296-30303
194, 231, 216, 251,  83, 128, 171, 163, // 30304-30311
148, 210,  25,  13, 202, 137, 168, 185, // 30312-30319
205, 183, 144, 207, 253, 201, 151, 120, // 30320-30327
 88, 109,  89,  30,  20,   7,  32,  91, // 30328-30335
 30,   6,  82, 139, 164, 172, 176, 163, // 30336-30343
184, 199, 135, 113, 145, 120,  84,  84, // 30344-30351
 43,  19,  98, 169, 203, 223, 220, 224, // 30352-30359
200, 163, 157, 145, 145, 130, 137,  96, // 30360-30367
 76, 122, 132, 177, 211, 152,  68,  71, // 30368-30375
 27, 240, 228, 244,  12,  53,  67,  71, // 30376-30383
103, 143, 229, 252,  31, 220, 229,   5, // 30384-30391
215, 189, 174, 150, 168, 184,  83,  82, // 30392-30399
 93, 106,  94, 104,  83, 107, 117, 109, // 30400-30407
 92,  14,  44,  54,  93,  65,  84, 135, // 30408-30415
167, 172, 179, 167, 181, 252, 175, 102, // 30416-30423
 73,  60,  17,  75,  99, 112, 172, 218, // 30424-30431
226, 172, 199, 207, 247, 222, 156, 119, // 30432-30439
 94,  82,  75,  69,  73, 136, 112,  79, // 30440-30447
 53,  49,  37,  72, 103,  73,  68,  68, // 30448-30455
 97,  69, 114, 131, 173, 241, 217, 228, // 30456-30463
  3, 254, 243,  11, 197, 184, 147,  88, // 30464-30471
 48,  42,  15,   3,  63,  88, 118, 106, // 30472-30479
168, 132, 119, 121,  93,  87,  83,  88, // 30480-30487
 94, 100,  73, 132, 150, 200, 220, 187, // 30488-30495
142, 162, 130,  60,  85, 101, 129, 133, // 30496-30503
161, 109, 109, 181, 220, 225, 221, 194, // 30504-30511
187, 192, 130,  83,  70, 111, 102,  58, // 30512-30519
236, 224,  19,  51,  73,  91, 111, 121, // 30520-30527
174, 160,  94, 112, 150, 175, 188, 138, // 30528-30535
139, 206, 240, 253, 237, 217, 223, 220, // 30536-30543
159,  85,  44,  23,  20,  30,  42,  18, // 30544-30551
 57, 146, 123, 103, 133, 131, 157, 171, // 30552-30559
131, 110, 102, 100, 106, 115, 121, 143, // 30560-30567
149, 146, 148, 112, 108, 147, 196, 177, // 30568-30575
147, 146, 118,  94, 140, 138, 134, 171, // 30576-30583
185, 183, 167, 158, 131, 174, 178, 122, // 30584-30591
 45,   2, 238, 250,   2, 249,  56, 106, // 30592-30599
135, 153, 163, 127, 194, 220, 201, 162, // 30600-30607
128, 159, 176, 189, 153, 169, 196, 236, // 30608-30615
197, 157, 116, 108, 118,  75,  44,  40, // 30616-30623
 40,  57, 118,  38,  40, 106, 140, 155, // 30624-30631
158, 157, 150, 179, 152, 121, 103, 139, // 30632-30639
133, 112,  92,  67,  74, 120, 169, 184, // 30640-30647
199, 183, 218, 172, 122, 131, 133, 138, // 30648-30655
134, 134,  94, 116, 134, 143, 163, 181, // 30656-30663
143, 101,  84,  28,   8,   6,  27,  44, // 30664-30671
 80,  67, 103, 136, 145, 192, 215, 234, // 30672-30679
197, 215, 203, 181, 164, 162, 143, 158, // 30680-30687
158, 106, 117, 112, 115, 102, 108,  91, // 30688-30695
129, 104, 104, 102,  42,  54,  78,  95, // 30696-30703
 77, 119, 146, 167, 162, 168, 152, 172, // 30704-30711
208, 153, 100,  83,  66,  43,  88,  88, // 30712-30719
131, 174, 198, 205, 170, 165, 191, 217, // 30720-30727
178, 141, 120, 107,  96,  95,  79, 101, // 30728-30735
147, 136,  99,  77,  65,  60,  95,  87, // 30736-30743
 68,  70,  79,  99,  96,  97, 119, 180, // 30744-30751
220, 197, 205, 226, 218, 232, 221, 163, // 30752-30759
153, 150, 106,  80,  66,  33,  56,  91, // 30760-30767
105, 114, 112, 147, 146, 112,  93,  88, // 30768-30775
 92,  99, 104, 117, 100, 105, 148, 158, // 30776-30783
175, 201, 173, 143, 160, 103,  66,  87, // 30784-30791
107, 121, 138, 135, 122, 127, 159, 188, // 30792-30799
191, 193, 171, 188, 161, 122,  92, 103, // 30800-30807
115, 118,  86,  23,  39,  60,  79,  85, // 30808-30815
103, 103, 134, 148, 132,  94, 101, 133, // 30816-30823
156, 167, 116, 153, 197, 217, 211, 210, // 30824-30831
185, 203, 212, 138,  91,  64,  59,  52, // 30832-30839
 66,  49,  56,  97, 157, 131, 101, 119, // 30840-30847
123, 159, 142, 117, 103, 109, 106, 121, // 30848-30855
111, 113, 166, 160, 154, 144, 115, 106, // 30856-30863
155, 167, 146, 132, 135, 124, 103, 128, // 30864-30871
121, 149, 171, 177, 167, 159, 140, 135, // 30872-30879
165, 134, 112,  67,  38,  26,  40,  27, // 30880-30887
 47,  95, 122, 138, 149, 158, 130, 175, // 30888-30895
171, 170, 144, 131, 150, 170, 162, 146, // 30896-30903
176, 179, 206, 183, 149, 115, 122, 102, // 30904-30911
 72,  55,  61,  64,  86, 123,  58,  75, // 30912-30919
117, 141, 145, 152, 144, 159, 164, 128, // 30920-30927
117, 104, 131, 141, 123,  91,  93,  98, // 30928-30935
130, 156, 167, 172, 173, 200, 151, 112, // 30936-30943
120, 131, 134, 141, 122, 111, 137, 141, // 30944-30951
146, 160, 157, 140, 123,  82,  42,  28, // 30952-30959
 33,  44,  63,  79,  77, 124, 149, 146, // 30960-30967
171, 196, 203, 192, 188, 172, 163, 152, // 30968-30975
150, 143, 144, 142, 136, 133, 126, 117, // 30976-30983
113, 105, 104, 123,  90,  99, 104,  60, // 30984-30991
 59,  88,  86,  98, 136, 154, 164, 163, // 30992-30999
159, 155, 172, 170, 144, 105, 102,  78, // 31000-31007
 71,  91,  99, 142, 167, 179, 183, 161, // 31008-31015
141, 179, 175, 148, 127, 121, 111, 113, // 31016-31023
101,  91, 127, 145, 148, 112,  97,  77, // 31024-31031
 90, 101,  81,  73,  81,  89, 106, 112, // 31032-31039
 87, 126, 172, 195, 173, 188, 199, 201, // 31040-31047
212, 183, 151, 139, 150, 116, 102,  76, // 31048-31055
 63,  89, 104, 111, 119, 119, 142, 155, // 31056-31063
100,  81,  82,  91,  95, 107, 110, 101, // 31064-31071
127, 150, 161, 161, 188, 169, 160, 157, // 31072-31079
103,  84, 100, 112, 122, 134, 118, 139, // 31080-31087
141, 153, 171, 177, 170, 166, 175, 137, // 31088-31095
114,  89, 105, 105, 111,  83,  56,  75, // 31096-31103
 83,  93,  98, 108, 110, 143, 130, 125, // 31104-31111
104, 106, 126, 154, 147, 121, 168, 193, // 31112-31119
206, 195, 197, 169, 189, 183, 126,  95, // 31120-31127
 77,  70,  70,  75,  60,  88, 113, 153, // 31128-31135
132, 106, 110, 131, 146, 123, 116, 112, // 31136-31143
118, 113, 126, 107, 122, 166, 160, 148, // 31144-31151
142, 114, 119, 154, 140, 132, 126, 132, // 31152-31159
130, 117, 116, 125, 156, 167, 167, 158, // 31160-31167
153, 139, 146, 150, 119, 107,  86,  59, // 31168-31175
 55,  53,  44,  76, 103, 122, 131, 140, // 31176-31183
148, 145, 155, 150, 154, 138, 133, 152, // 31184-31191
166, 151, 157, 177, 171, 180, 175, 141, // 31192-31199
125, 125,  92,  75,  67,  73,  74,  96, // 31200-31207
109,  83,  92, 121, 137, 143, 147, 145, // 31208-31215
163, 147, 124, 118, 116, 123, 146, 122, // 31216-31223
106, 118, 113, 133, 146, 154, 153, 168, // 31224-31231
166, 135, 105, 116, 126, 132, 134, 117, // 31232-31239
130, 145, 146, 145, 159, 137, 142, 125, // 31240-31247
 80,  57,  50,  59,  67,  86,  84, 100, // 31248-31255
134, 154, 143, 156, 171, 179, 176, 159, // 31256-31263
156, 152, 152, 144, 149, 132, 140, 153, // 31264-31271
139, 131, 122, 117, 106, 118, 110,  88, // 31272-31279
 97, 107,  74,  71,  90,  90, 119, 140, // 31280-31287
152, 153, 157, 146, 157, 155, 143, 139, // 31288-31295
113, 109,  90,  87,  91, 119, 147, 164, // 31296-31303
165, 174, 158, 143, 167, 148, 136, 122, // 31304-31311
122, 111, 118,  96, 107, 139, 138, 142, // 31312-31319
117, 103,  91, 108,  94,  83,  81,  92, // 31320-31327
 96, 115, 116,  98, 137, 171, 183, 166, // 31328-31335
181, 181, 195, 184, 157, 139, 128, 137, // 31336-31343
121, 105,  79,  91, 104, 111, 114, 120, // 31344-31351
118, 144, 148,  96,  85,  94, 102, 107, // 31352-31359
119, 110, 120, 141, 149, 154, 153, 167, // 31360-31367
165, 157, 132,  94,  86, 102, 110, 125, // 31368-31375
123, 121, 152, 147, 142, 154, 159, 156, // 31376-31383
165, 154, 126, 117, 106, 119, 117, 109, // 31384-31391
 95,  92,  97,  97, 100, 104, 108, 123, // 31392-31399
136, 117, 122, 114, 109, 126, 148, 132, // 31400-31407
132, 166, 180, 184, 177, 171, 162, 170, // 31408-31415
157, 125,  99,  91,  83,  89,  79,  82, // 31416-31423
105, 120, 146, 134, 107, 107, 134, 127, // 31424-31431
117, 116, 120, 120, 125, 124, 119, 138, // 31432-31439
166, 163, 147, 140, 112, 128, 137, 125, // 31440-31447
124, 127, 129, 133, 115, 102, 131, 149, // 31448-31455
156, 153, 154, 142, 142, 142, 134, 113, // 31456-31463
107, 102,  82,  82,  66,  77, 102, 118, // 31464-31471
128, 136, 135, 144, 146, 129, 131, 138, // 31472-31479
128, 127, 150, 149, 146, 161, 172, 165, // 31480-31487
167, 166, 136, 133, 118,  95,  86,  83, // 31488-31495
 88,  93, 107, 110, 107, 100, 117, 130, // 31496-31503
135, 133, 142, 149, 131, 122, 120, 121, // 31504-31511
123, 147, 124, 126, 129, 121, 132, 144, // 31512-31519
148, 153, 161, 144, 132, 106, 110, 118, // 31520-31527
130, 121, 124, 142, 145, 140, 139, 151, // 31528-31535
129, 144, 119,  87,  73,  72,  76,  86, // 31536-31543
 96,  96, 122, 138, 154, 143, 146, 155, // 31544-31551
171, 155, 140, 145, 145, 145, 144, 148, // 31552-31559
124, 143, 154, 140, 128, 121, 111, 112, // 31560-31567
120, 106,  96, 103, 111,  91,  88,  91, // 31568-31575
103, 127, 139, 148, 151, 146, 141, 156, // 31576-31583
139, 131, 139, 123, 117, 106,  97, 104, // 31584-31591
130, 147, 157, 156, 157, 145, 136, 139, // 31592-31599
127, 125, 123, 123, 124, 126, 106, 127, // 31600-31607
143, 133, 137, 124, 104, 102, 106,  89, // 31608-31615
 89,  93, 102, 107, 121, 118, 116, 139, // 31616-31623
162, 166, 153, 159, 167, 178, 159, 145, // 31624-31631
138, 129, 136, 134, 110, 101, 113, 118, // 31632-31639
119, 120, 121, 117, 141, 129,  94,  82, // 31640-31647
 95, 101, 112, 115, 115, 135, 145, 149, // 31648-31655
152, 146, 148, 162, 148, 125,  97,  94, // 31656-31663
107, 119, 130, 125, 136, 153, 150, 137, // 31664-31671
147, 146, 149, 152, 136, 123, 116, 108, // 31672-31679
120, 122, 104, 112, 113, 110, 108, 109, // 31680-31687
109, 110, 126, 120, 111, 113, 117, 110, // 31688-31695
125, 137, 128, 141, 162, 173, 173, 170, // 31696-31703
162, 164, 151, 140, 123, 106, 100,  97, // 31704-31711
 99,  89, 106, 118, 128, 137, 133, 108, // 31712-31719
112, 126, 114, 114, 113, 122, 125, 130, // 31720-31727
120, 130, 140, 159, 160, 146, 135, 117, // 31728-31735
132, 126, 122, 120, 125, 124, 135, 116, // 31736-31743
107, 132, 145, 150, 147, 146, 139, 144, // 31744-31751
131, 131, 113, 107, 109, 100,  94,  82, // 31752-31759
 99, 111, 123, 126, 132, 127, 142, 141, // 31760-31767
122, 129, 134, 127, 129, 147, 142, 151, // 31768-31775
160, 165, 158, 151, 150, 136, 130, 109, // 31776-31783
 98,  94,  94,  98, 103, 106, 115, 121, // 31784-31791
112, 118, 127, 132, 133, 143, 138, 128, // 31792-31799
124, 126, 126, 127, 138, 129, 136, 131, // 31800-31807
123, 130, 136, 136, 146, 144, 128, 126, // 31808-31815
110, 112, 122, 130, 122, 133, 144, 146, // 31816-31823
139, 138, 141, 130, 133, 116,  94,  88, // 31824-31831
 90,  93, 103, 101, 110, 127, 135, 144, // 31832-31839
140, 134, 145, 159, 139, 133, 137, 143, // 31840-31847
145, 148, 143, 131, 141, 150, 138, 127, // 31848-31855
119, 111, 119, 115, 102,  97, 108, 111, // 31856-31863
107,  97,  98, 118, 132, 141, 143, 146, // 31864-31871
139, 142, 147, 133, 127, 135, 130, 125, // 31872-31879
118, 109, 122, 133, 142, 141, 140, 138, // 31880-31887
136, 130, 123, 123, 122, 125, 126, 127, // 31888-31895
124, 121, 132, 138, 128, 128, 123, 115, // 31896-31903
117, 113, 110, 110, 114, 117, 121, 122, // 31904-31911
126, 133, 138, 144, 140, 138, 139, 142, // 31912-31919
142, 137, 133, 132, 131, 127, 128, 121, // 31920-31927
120, 124, 127, 125, 123, 119, 118, 121, // 31928-31935
119, 114, 111, 117, 121, 126, 126, 128, // 31936-31943
133, 136, 137, 136, 134, 133, 136, 136, // 31944-31951
129, 122, 123, 125, 126, 127, 127, 128, // 31952-31959
128, 128, 125, 124, 124, 125, 128, 126, // 31960-31967
126, 125, 126, 128, 129, 126, 128, 129, // 31968-31975
127, 124, 124, 126, 126, 127, 125, 122, // 31976-31983
124, 127, 127, 128, 129, 128, 130, 132, // 31984-31991
130, 129, 130, 132, 133, 130, 126, 125, // 31992-31999
127, 126, 126, 128, 125, 125, 126, 124, // 32000-32007
120, 119, 121, 123, 124, 123, 122, 125, // 32008-32015
130, 132, 130, 127, 129, 133, 136, 135, // 32016-32023
131, 129, 128, 129, 129, 124, 126, 126, // 32024-32031
126, 127, 124, 120, 123, 127, 127, 128, // 32032-32039
127, 127, 127, 129, 127, 126, 127, 129, // 32040-32047
130, 129, 126, 125, 128, 128, 127, 125, // 32048-32055
122, 123, 126, 126, 125, 126, 128, 129, // 32056-32063
130, 129, 129, 131, 132, 130, 128, 127, // 32064-32071
127, 127, 125, 125, 128, 128, 128, 127, // 32072-32079
125, 125, 126, 126, 123, 122, 122, 122, // 32080-32087
124, 125, 123, 124, 129, 132, 133, 134, // 32088-32095
132, 134, 133, 129, 126, 125, 125, 128, // 32096-32103
128, 124, 122, 123, 125, 126, 128, 127, // 32104-32111
128, 131, 130, 127, 124, 124, 124, 126, // 32112-32119
126, 124, 124, 126, 128, 131, 130, 128, // 32120-32127
129, 130, 128, 127, 127, 126, 128, 128, // 32128-32135
126, 126, 126, 129, 130, 129, 128, 128, // 32136-32143
129, 127, 126, 124, 123, 126, 126, 124, // 32144-32151
124, 124, 125, 126, 129, 127, 127, 129, // 32152-32159
128, 127, 129, 128, 126, 128, 128, 128, // 32160-32167
131, 133, 132, 129, 126, 127, 130, 128, // 32168-32175
126, 123, 122, 123, 123, 121, 120, 124, // 32176-32183
128, 130, 130, 127, 128, 131, 133, 131, // 32184-32191
128, 128, 127, 128, 126, 124, 126, 128, // 32192-32199
128, 127, 126, 125, 129, 131, 128, 127, // 32200-32207
125, 124, 125, 126, 124, 124, 127, 128, // 32208-32215
128, 129, 128, 128, 131, 130, 129, 127, // 32216-32223
125, 124, 125, 123, 122, 123, 125, 126, // 32224-32231
127, 127, 127, 129, 130, 128, 128, 129, // 32232-32239
130, 131, 130, 129, 129, 130, 132, 131, // 32240-32247
129, 126, 126, 127, 125, 122, 121, 122, // 32248-32255
126, 127, 124, 123, 125, 127, 130, 129, // 32256-32263
126, 128, 130, 128, 126, 124, 125, 127, // 32264-32271
129, 126, 124, 127, 129, 131, 132, 130, // 32272-32279
128, 130, 128, 126, 124, 125, 126, 128, // 32280-32287
127, 124, 126, 126, 129, 130, 129, 128, // 32288-32295
129, 127, 124, 123, 122, 123, 125, 124, // 32296-32303
123, 125, 127, 128, 129, 130, 129, 132, // 32304-32311
133, 130, 129, 128, 127, 128, 128, 126, // 32312-32319
127, 128, 128, 128, 127, 127, 126, 128, // 32320-32327
127, 126, 125, 123, 121, 122, 124, 123, // 32328-32335
126, 128, 130, 129, 128, 129, 130, 131, // 32336-32343
130, 128, 124, 122, 125, 126, 124, 126, // 32344-32351
129, 131, 133, 132, 128, 130, 133, 130, // 32352-32359
127, 123, 121, 121, 122, 123, 125, 128, // 32360-32367
130, 131, 129, 128, 127, 128, 128, 125, // 32368-32375
124, 121, 123, 124, 122, 123, 126, 129, // 32376-32383
133, 132, 132, 132, 133, 131, 129, 128, // 32384-32391
126, 126, 125, 123, 121, 123, 125, 126, // 32392-32399
127, 129, 130, 132, 131, 126, 127, 125, // 32400-32407
126, 126, 126, 124, 124, 125, 127, 128, // 32408-32415
129, 130, 129, 130, 128, 126, 126, 126, // 32416-32423
127, 127, 125, 123, 125, 126, 128, 129, // 32424-32431
130, 130, 131, 130, 129, 128, 128, 129, // 32432-32439
128, 126, 122, 121, 122, 124, 126, 127, // 32440-32447
127, 128, 127, 126, 126, 124, 125, 125, // 32448-32455
125, 126, 127, 129, 131, 132, 132, 133, // 32456-32463
132, 134, 131, 128, 125, 123, 122, 122, // 32464-32471
122, 122, 125, 126, 128, 126, 125, 127, // 32472-32479
128, 127, 126, 125, 125, 124, 123, 125, // 32480-32487
125, 128, 131, 131, 130, 128, 130, 132, // 32488-32495
131, 131, 129, 127, 127, 126, 125, 125, // 32496-32503
127, 129, 129, 129, 127, 127, 129, 130, // 32504-32511
128, 127, 126, 124, 124, 123, 122, 124, // 32512-32519
126, 127, 126, 126, 126, 126, 128, 128, // 32520-32527
127, 126, 128, 129, 128, 128, 128, 129, // 32528-32535
130, 131, 132, 131, 130, 128, 126, 125, // 32536-32543
124, 124, 127, 126, 125, 126, 125, 125, // 32544-32551
127, 127, 127, 129, 130, 128, 124, 123, // 32552-32559
123, 124, 125, 125, 123, 124, 126, 129, // 32560-32567
131, 132, 133, 133, 132, 132, 128, 126, // 32568-32575
126, 126, 125, 125, 124, 126, 127, 129, // 32576-32583
129, 131, 132, 129, 127, 125, 122, 121, // 32584-32591
123, 122, 122, 123, 124, 128, 130, 129, // 32592-32599
131, 131, 132, 132, 131, 128, 126, 126, // 32600-32607
125, 126, 126, 127, 126, 128, 127, 125, // 32608-32615
128, 129, 129, 127, 127, 126, 125, 124, // 32616-32623
123, 124, 125, 128, 131, 130, 127, 128, // 32624-32631
128, 128, 127, 125, 123, 124, 124, 122, // 32632-32639
124, 126, 129, 131, 132, 131, 132, 132, // 32640-32647
132, 130, 129, 127, 127, 126, 123, 123, // 32648-32655
126, 127, 127, 128, 126, 125, 126, 125, // 32656-32663
125, 124, 123, 123, 123, 123, 121, 122, // 32664-32671
125, 127, 129, 131, 133, 135, 135, 134, // 32672-32679
133, 131, 129, 130, 127, 124, 124, 122, // 32680-32687
123, 124, 127, 127, 129, 129, 128, 127, // 32688-32695
124, 122, 123, 124, 124, 124, 124, 123, // 32696-32703
125, 129, 129, 130, 133, 132, 131, 129, // 32704-32711
127, 125, 128, 128, 126, 126, 127, 127, // 32712-32719
129, 129, 128, 129, 129, 129, 127, 124, // 32720-32727
123, 125, 126, 126, 125, 124, 125, 126, // 32728-32735
127, 127, 129, 130, 129, 127, 126, 124, // 32736-32743
124, 124, 123, 124, 126, 129, 130, 130, // 32744-32751
129, 131, 133, 132, 131, 129, 127, 126, // 32752-32759
126, 125, 124, 127, 127, 128, 129, 128, // 32760-32767
126, 126, 126, 125, 126, 126, 123, 120, // 32768-32775
120, 121, 123, 124, 126, 127, 130, 129, // 32776-32783
131, 132, 131, 133, 133, 132, 130, 129, // 32784-32791
127, 127, 125, 124, 125, 127, 128, 127, // 32792-32799
126, 127, 129, 129, 126, 124, 123, 120, // 32800-32807
122, 124, 124, 125, 128, 130, 131, 131, // 32808-32815
128, 128, 129, 128, 127, 127, 128, 126, // 32816-32823
125, 127, 127, 127, 130, 130, 129, 130, // 32824-32831
128, 127, 126, 127, 128, 127, 126, 126, // 32832-32839
127, 126, 127, 126, 128, 129, 129, 127, // 32840-32847
124, 122, 123, 124, 124, 122, 124, 126, // 32848-32855
126, 128, 129, 130, 133, 135, 133, 131, // 32856-32863
130, 130, 129, 126, 125, 125, 126, 128, // 32864-32871
126, 127, 128, 128, 129, 127, 124, 123, // 32872-32879
122, 122, 122, 122, 124, 125, 127, 127, // 32880-32887
126, 126, 129, 129, 130, 129, 131, 131, // 32888-32895
130, 127, 128, 128, 130, 131, 130, 129, // 32896-32903
127, 127, 128, 126, 126, 127, 127, 125, // 32904-32911
124, 123, 124, 123, 123, 125, 127, 128, // 32912-32919
126, 125, 127, 128, 128, 127, 126, 127, // 32920-32927
126, 126, 126, 127, 128, 131, 133, 132, // 32928-32935
131, 130, 131, 128, 126, 124, 123, 124, // 32936-32943
125, 124, 125, 126, 128, 129, 129, 128, // 32944-32951
128, 128, 128, 126, 124, 125, 125, 125, // 32952-32959
123, 123, 124, 127, 127, 129, 132, 132, // 32960-32967
131, 128, 125, 126, 127, 127, 125, 125, // 32968-32975
128, 127, 128, 128, 130, 131, 133, 134, // 32976-32983
131, 128, 126, 124, 122, 120, 121, 123, // 32984-32991
123, 125, 124, 126, 129, 130, 129, 129, // 32992-32999
128, 127, 126, 125, 124, 125, 129, 131, // 33000-33007
131, 131, 131, 132, 132, 130, 128, 128, // 33008-33015
127, 126, 123, 122, 122, 123, 124, 124, // 33016-33023
125, 125, 127, 129, 129, 129, 129, 130, // 33024-33031
130, 127, 124, 124, 125, 124, 126, 128, // 33032-33039
128, 128, 129, 130, 131, 131, 131, 130, // 33040-33047
129, 126, 123, 120, 122, 124, 126, 128, // 33048-33055
129, 129, 130, 131, 129, 127, 127, 127, // 33056-33063
128, 124, 123, 121, 124, 125, 126, 125, // 33064-33071
126, 128, 131, 131, 130, 129, 129, 130, // 33072-33079
129, 128, 126, 127, 127, 127, 126, 126, // 33080-33087
128, 129, 129, 128, 128, 128, 127, 125, // 33088-33095
123, 122, 123, 124, 123, 123, 124, 126, // 33096-33103
128, 130, 129, 127, 128, 129, 129, 128, // 33104-33111
129, 129, 128, 128, 128, 129, 130, 130, // 33112-33119
130, 128, 127, 126, 125, 125, 126, 125, // 33120-33127
126, 127, 126, 125, 124, 125, 125, 126, // 33128-33135
127, 126, 126, 125, 128, 128, 127, 126, // 33136-33143
126, 128, 128, 129, 129, 129, 129, 129, // 33144-33151
129, 128, 129, 129, 129, 128, 127, 126, // 33152-33159
126, 127, 126, 125, 126, 127, 127, 125, // 33160-33167
125, 125, 125, 126, 126, 125, 126, 127, // 33168-33175
127, 128, 128, 126, 128, 127, 127, 126, // 33176-33183
127, 129, 128, 128, 128, 128, 130, 130, // 33184-33191
130, 129, 128, 127, 128, 127, 126, 126, // 33192-33199
126, 127, 127, 126, 125, 125, 125, 127, // 33200-33207
126, 127, 126, 126, 126, 125, 125, 124, // 33208-33215
124, 126, 127, 127, 129, 130, 131, 132, // 33216-33223
132, 130, 130, 131, 131, 128, 127, 126, // 33224-33231
124, 124, 126, 125, 125, 126, 127, 127, // 33232-33239
126, 126, 126, 124, 125, 125, 124, 124, // 33240-33247
124, 124, 126, 127, 128, 128, 129, 130, // 33248-33255
131, 131, 132, 130, 129, 129, 129, 128, // 33256-33263
127, 127, 127, 128, 127, 127, 128, 128, // 33264-33271
129, 129, 127, 126, 125, 125, 123, 123, // 33272-33279
123, 123, 124, 125, 126, 126, 127, 127, // 33280-33287
127, 127, 128, 128, 127, 128, 128, 128, // 33288-33295
128, 129, 128, 130, 131, 132, 131, 130, // 33296-33303
128, 128, 128, 126, 125, 124, 125, 125, // 33304-33311
125, 124, 123, 124, 125, 125, 126, 126, // 33312-33319
126, 127, 126, 126, 125, 127, 126, 127, // 33320-33327
128, 129, 129, 130, 130, 129, 129, 129, // 33328-33335
129, 129, 128, 127, 127, 126, 128, 128, // 33336-33343
128, 127, 126, 125, 126, 126, 126, 125, // 33344-33351
126, 126, 126, 126, 125, 125, 125, 125, // 33352-33359
125, 125, 125, 125, 127, 127, 128, 129, // 33360-33367
129, 129, 128, 129, 129, 130, 130, 129, // 33368-33375
128, 128, 127, 127, 127, 126, 127, 126, // 33376-33383
126, 125, 125, 125, 126, 126, 126, 125, // 33384-33391
126, 126, 126, 125, 124, 125, 127, 127, // 33392-33399
128, 129, 130, 129, 130, 129, 128, 129, // 33400-33407
128, 128, 128, 128, 126, 127, 127, 128, // 33408-33415
127, 128, 128, 128, 127, 127, 127, 126, // 33416-33423
126, 125, 125, 123, 123, 123, 123, 125, // 33424-33431
124, 125, 127, 127, 129, 129, 129, 129, // 33432-33439
129, 129, 128, 127, 128, 129, 129, 130, // 33440-33447
130, 129, 130, 130, 130, 128, 127, 126, // 33448-33455
125, 123, 123, 123, 123, 126, 125, 125, // 33456-33463
127, 127, 128, 128, 126, 124, 126, 127, // 33464-33471
126, 125, 126, 127, 128, 128, 127, 127, // 33472-33479
129, 130, 131, 131, 130, 128, 129, 128, // 33480-33487
127, 127, 127, 128, 127, 127, 127, 126, // 33488-33495
126, 128, 127, 126, 124, 123, 123, 125, // 33496-33503
124, 122, 124, 126, 126, 128, 129, 129, // 33504-33511
131, 131, 130, 128, 128, 129, 128, 128, // 33512-33519
127, 127, 126, 129, 128, 127, 127, 128, // 33520-33527
128, 126, 124, 125, 125, 125, 125, 126, // 33528-33535
125, 126, 127, 127, 128, 127, 128, 129, // 33536-33543
128, 128, 127, 127, 127, 127, 124, 125, // 33544-33551
126, 127, 128, 129, 128, 128, 130, 130, // 33552-33559
129, 127, 128, 127, 128, 126, 124, 125, // 33560-33567
127, 127, 128, 128, 126, 127, 127, 126, // 33568-33575
126, 125, 123, 124, 124, 124, 124, 127, // 33576-33583
129, 129, 129, 130, 130, 131, 132, 130, // 33584-33591
128, 128, 127, 126, 126, 125, 126, 128, // 33592-33599
128, 127, 126, 126, 128, 126, 127, 126, // 33600-33607
125, 125, 124, 125, 124, 125, 126, 127, // 33608-33615
128, 128, 128, 129, 130, 129, 129, 128, // 33616-33623
127, 128, 127, 126, 128, 127, 127, 129, // 33624-33631
129, 129, 129, 130, 129, 127, 127, 124, // 33632-33639
124, 124, 125, 125, 124, 124, 125, 126, // 33640-33647
127, 127, 127, 126, 127, 127, 127, 127, // 33648-33655
128, 128, 128, 128, 128, 129, 131, 131, // 33656-33663
131, 130, 130, 128, 128, 126, 125, 125, // 33664-33671
125, 125, 124, 124, 124, 126, 126, 127, // 33672-33679
128, 129, 128, 127, 126, 126, 126, 126, // 33680-33687
125, 125, 126, 127, 127, 127, 127, 128, // 33688-33695
129, 130, 129, 128, 128, 128, 127, 127, // 33696-33703
127, 127, 129, 130, 129, 128, 128, 127, // 33704-33711
127, 126, 126, 125, 124, 124, 123, 123, // 33712-33719
124, 124, 125, 125, 126, 126, 126, 127, // 33720-33727
129, 130, 129, 129, 129, 130, 131, 131, // 33728-33735
130, 130, 128, 130, 128, 127, 123, 126, // 33736-33743
124, 127, 124, 125, 122, 126, 123, 126, // 33744-33751
125, 129, 128, 131, 130, 133, 161, 164, // 33752-33759
141, 100,  86,  72,  96,  38,  73, 138, // 33760-33767
188, 172, 123, 162, 207,  16, 210, 132, // 33768-33775
 27,  68,  91, 137,  97,  87, 217, 195, // 33776-33783
151, 109,  91,  54, 108,  75,  12, 242, // 33784-33791
249,  11,  45,  60,  31, 111, 164, 197, // 33792-33799
196, 202, 174, 212, 223, 137, 166, 137, // 33800-33807
 85,  65,  72,  36,  18, 103, 201, 252, // 33808-33815
 21,  22, 227,   2, 237, 198, 172, 154, // 33816-33823
133, 132,  76,  47, 121, 107, 218, 238, // 33824-33831
101,  19,  34, 240, 188, 188, 207, 242, // 33832-33839
 26,  66,  23,  92, 211,  38,  53,  75, // 33840-33847
  3,   1,  34, 224, 204, 166, 178, 207, // 33848-33855
145,  33,  50,  84, 100,  95, 101,  80, // 33856-33863
110, 136,  84,  49,  33,  50,  51,  81, // 33864-33871
 37,  64, 134, 166, 182, 186, 178, 239, // 33872-33879
251, 149,  73,  47,  41, 237,  55,  90, // 33880-33887
108, 200,   3, 213, 228,  17,   0,  43, // 33888-33895
251, 166, 113,  84,  59,  59,  27, 100, // 33896-33903
131,  66,  41,  12,  23,   4,  62,  93, // 33904-33911
 57,  44,  70,  48,  62, 156, 150, 205, // 33912-33919
 29, 254, 240,  33,  16,  28,  29, 247, // 33920-33927
210, 110,  62,  18,  28, 236, 237,  55, // 33928-33935
 92, 114, 119, 141, 118, 170, 138,  91, // 33936-33943
 65,  66,  64,  87,  78,  59, 120, 178, // 33944-33951
  2, 204, 179, 127, 177, 137,  41,  68, // 33952-33959
102, 127, 153, 168,  68, 150, 231,  17, // 33960-33967
  6, 254, 207, 206, 198, 123,  59,  36, // 33968-33975
140,  66,   4, 177, 182, 246,  35,  66, // 33976-33983
 93, 111, 130, 203, 121, 102, 142, 173, // 33984-33991
189, 212, 132, 131, 228,  11,  33, 255, // 33992-33999
 31, 247, 215, 151,  61,  15, 250, 250, // 34000-34007
  7,  21, 242,  59, 124, 132, 143, 157, // 34008-34015
142, 168, 179, 116,  91,  72,  86,  77, // 34016-34023
130, 126, 108, 140, 144, 165, 122, 106, // 34024-34031
162, 233, 192, 172, 134,  93, 130, 173, // 34032-34039
154, 141, 192, 199, 201, 169, 164, 113, // 34040-34047
187, 216,  76, 237, 193, 188, 211, 224, // 34048-34055
214,  51, 104, 154, 171, 149, 166,   5, // 34056-34063
 18, 234, 184, 124, 156, 180, 198, 150, // 34064-34071
174, 254, 247, 181, 150, 106, 107, 117, // 34072-34079
 62,  25,  17,  17,  42,  77,  21,  55, // 34080-34087
117, 153, 163, 168, 161, 159, 192, 157, // 34088-34095
105, 125, 138,  90,  88,  57,  51,  61, // 34096-34103
117, 180, 212, 224, 225, 231, 180, 169, // 34104-34111
159, 157, 144, 142, 124,  79, 103, 138, // 34112-34119
128, 187, 217, 105,  75,  52, 247, 223, // 34120-34127
228, 250,  24,  60,  56,  89, 117, 190, // 34128-34135
246,  11,  19, 236, 239, 221, 192, 176, // 34136-34143
164, 153, 199, 130,  76, 100, 106, 109, // 34144-34151
 99, 101,  87, 134,  96,  88,  57,  39, // 34152-34159
 58,  77,  82,  59, 118, 149, 173, 168, // 34160-34167
181, 155, 233, 218, 125,  79,  66,  58, // 34168-34175
 19,  76,  79, 144, 192, 237, 195, 189, // 34176-34183
212, 234,   1, 187, 144, 109,  98,  76, // 34184-34191
 86,  34, 119, 159, 102,  68,  45,  41, // 34192-34199
 39,  94,  70,  58,  52,  84,  75,  80, // 34200-34207
121, 141, 216,   2, 226, 218, 253, 234, // 34208-34215
 15, 233, 184, 181, 124,  79,  57,  45, // 34216-34223
  1,  45,  85, 108, 112, 117, 139, 133, // 34224-34231
137, 101,  85,  77,  84,  86, 104,  73, // 34232-34239
 98, 147, 170, 224, 200, 162, 141, 174, // 34240-34247
102,  49,  77, 110, 127, 150, 141,  95, // 34248-34255
153, 208, 232, 225, 214, 185, 204, 159, // 34256-34263
106,  69,  65, 128, 102,  28, 222,   1, // 34264-34271
 37,  63,  78, 101, 108, 146, 172, 110, // 34272-34279
 87, 131, 156, 180, 187, 115, 160, 220, // 34280-34287
241, 244, 226, 223, 238, 202, 120,  66, // 34288-34295
 39,  30,  27,  44,  27,  36,  97, 148, // 34296-34303
122, 128, 137, 138, 172, 142, 109,  94, // 34304-34311
 93,  95, 106, 107, 131, 149, 151, 148, // 34312-34319
151, 117, 105, 173, 187, 157, 144, 141, // 34320-34327
100, 124, 152, 132, 164, 189, 191, 178, // 34328-34335
163, 142, 136, 164, 165,  88,  18, 245, // 34336-34343
237,   3, 243,  21,  85, 122, 142, 166, // 34344-34351
140, 150, 227, 204, 194, 157, 132, 152, // 34352-34359
182, 164, 156, 183, 224, 228, 171, 145, // 34360-34367
106, 129,  96,  59,  36,  48,  40,  75, // 34368-34375
 90,  31,  88, 124, 152, 150, 162, 146, // 34376-34383
171, 167, 132, 104, 117, 143, 113, 104, // 34384-34391
 63,  90,  89, 129, 162, 190, 186, 204, // 34392-34399
213, 138, 138, 140, 148, 138, 147, 111, // 34400-34407
105, 131, 147, 138, 170, 190, 121, 106, // 34408-34415
 52,  13, 254,  10,  22,  55,  65,  67, // 34416-34423
125, 130, 168, 206, 225, 227, 219, 198, // 34424-34431
183, 170, 162, 155, 147, 176, 130, 117, // 34432-34439
122, 119, 113, 108,  97, 106, 130,  81, // 34440-34447
 96,  75,  49,  67,  89,  77,  92, 136, // 34448-34455
154, 165, 163, 166, 152, 208, 182, 125, // 34456-34463
 88,  87,  70,  56,  77,  94, 157, 180, // 34464-34471
206, 183, 163, 176, 215, 198, 155, 131, // 34472-34479
116, 104, 100,  93,  63, 139, 165, 125, // 34480-34487
 87,  74,  58,  78,  93,  66,  66,  70, // 34488-34495
 91,  99,  91,  99, 149, 199, 225, 193, // 34496-34503
201, 214, 219, 236, 187, 157, 163, 135, // 34504-34511
 94,  85,  50,  47,  81, 100, 110, 119, // 34512-34519
115, 146, 143, 103,  92,  84,  92,  92, // 34520-34527
106, 101,  92, 128, 154, 161, 193, 194, // 34528-34535
154, 155, 148,  91,  62,  90, 108, 131, // 34536-34543
136, 126, 128, 146, 186, 196, 199, 182, // 34544-34551
183, 182, 134, 107,  84,  89, 123, 119, // 34552-34559
 45,  28,  52,  70,  80,  93, 101, 116, // 34560-34567
149, 138, 112,  85, 123, 140, 172, 154, // 34568-34575
121, 172, 208, 220, 215, 202, 188, 228, // 34576-34583
175, 113,  76,  62,  52,  58,  58,  45, // 34584-34591
 79, 110, 156, 119, 119, 120, 145, 153, // 34592-34599
123, 109, 103, 106, 109, 121,  97, 145, // 34600-34607
163, 154, 145, 146, 109, 117, 165, 149, // 34608-34615
140, 130, 139, 108, 123, 127, 134, 167, // 34616-34623
176, 176, 165, 154, 139, 151, 142, 141, // 34624-34631
101,  55,  29,  30,  28,  19,  67,  99, // 34632-34639
126, 133, 154, 135, 149, 182, 165, 169, // 34640-34647
144, 131, 154, 170, 147, 167, 179, 198, // 34648-34655
206, 169, 135, 123, 128,  87,  71,  55, // 34656-34663
 68,  61,  94,  93,  61, 102, 126, 141, // 34664-34671
144, 146, 142, 169, 145, 126, 109, 116, // 34672-34679
137, 132, 103,  87, 114, 105, 134, 156, // 34680-34687
173, 168, 192, 183, 125, 120, 133, 136, // 34688-34695
139, 134, 109, 127, 141, 146, 138, 159, // 34696-34703
161, 141, 109,  59,  37,  32,  44,  56, // 34704-34711
 77,  70,  94, 138, 138, 146, 178, 186, // 34712-34719
202, 192, 162, 161, 158, 159, 152, 150, // 34720-34727
146, 142, 139, 133, 124, 117, 110, 106, // 34728-34735
123, 115,  83, 102,  99,  64,  86,  89, // 34736-34743
 85, 114, 137, 149, 152, 152, 147, 157, // 34744-34751
169, 157, 124, 101,  99,  88,  78,  84, // 34752-34759
120, 158, 173, 180, 176, 144, 164, 189, // 34760-34767
163, 142, 126, 122, 112, 118,  90,  95, // 34768-34775
142, 156, 127,  96,  81,  76, 102,  88, // 34776-34783
 78,  77,  90,  99, 120,  95, 101, 153, // 34784-34791
184, 197, 166, 177, 182, 208, 195, 164, // 34792-34799
137, 149, 137, 113,  97,  66,  86, 102, // 34800-34807
115, 114, 122, 111, 156, 141,  93,  93, // 34808-34815
 91, 102, 102, 117, 101, 115, 136, 153, // 34816-34823
149, 166, 168, 149, 151, 128,  92,  77, // 34824-34831
106, 117, 141, 128, 134, 147, 145, 168, // 34832-34839
175, 174, 160, 173, 153, 124, 107,  95, // 34840-34847
101, 125, 115,  68,  70,  79,  91,  93, // 34848-34855
104, 103, 128, 137, 124, 116,  97, 122, // 34856-34863
140, 160, 132, 131, 168, 192, 194, 190, // 34864-34871
174, 172, 195, 150, 111,  88,  84,  79, // 34872-34879
 89,  71,  79, 105, 124, 156, 122, 112, // 34880-34887
120, 144, 130, 112, 106, 111, 111, 118, // 34888-34895
114, 103, 146, 161, 149, 139, 139, 109, // 34896-34903
134, 149, 136, 134, 131, 139, 125, 119, // 34904-34911
119, 145, 160, 164, 158, 154, 140, 142, // 34912-34919
140, 128, 124, 105,  76,  59,  64,  50, // 34920-34927
 64,  96, 114, 127, 136, 144, 142, 146, // 34928-34935
150, 146, 151, 135, 125, 152, 150, 147, // 34936-34943
166, 170, 172, 180, 156, 131, 133, 118, // 34944-34951
 94,  85,  79,  85,  88, 103, 106,  93, // 34952-34959
110, 128, 133, 136, 132, 147, 151, 127, // 34960-34967
119, 114, 115, 135, 135, 101, 113, 124, // 34968-34975
117, 133, 150, 153, 164, 175, 157, 124, // 34976-34983
115, 133, 133, 140, 121, 121, 138, 144, // 34984-34991
138, 135, 145, 144, 145,  99,  72,  60, // 34992-34999
 64,  68,  84,  84,  89, 117, 141, 141, // 35000-35007
136, 162, 165, 187, 160, 143, 148, 152, // 35008-35015
149, 149, 142, 130, 152, 143, 136, 125, // 35016-35023
125, 112, 120, 121, 106,  91, 109, 110, // 35024-35031
 79,  95,  89, 104, 124, 136, 141, 146, // 35032-35039
140, 143, 154, 139, 142, 125, 111, 109, // 35040-35047
103,  85, 102, 135, 155, 163, 164, 166, // 35048-35055
139, 157, 160, 142, 133, 126, 123, 121, // 35056-35063
116,  95, 120, 140, 146, 128, 106,  92, // 35064-35071
101, 105,  87,  87,  90, 103, 107, 123, // 35072-35079
 97, 115, 152, 171, 172, 153, 161, 175, // 35080-35087
190, 164, 150, 133, 142, 139, 122,  98, // 35088-35095
 92, 110, 116, 120, 117, 120, 116, 156, // 35096-35103
129,  91,  94, 101, 105, 112, 111, 105, // 35104-35111
128, 138, 147, 142, 151, 157, 155, 140, // 35112-35119
120,  95,  93, 112, 122, 133, 121, 139, // 35120-35127
151, 141, 149, 159, 156, 159, 162, 138, // 35128-35135
122, 115, 107, 115, 123, 110,  95,  95, // 35136-35143
 97,  99, 104, 107, 112, 130, 124, 116, // 35144-35151
121, 109, 116, 134, 139, 129, 137, 161, // 35152-35159
172, 176, 171, 164, 166, 169, 144, 115, // 35160-35167
104,  97,  96,  93,  81,  99, 113, 124, // 35168-35175
146, 127, 107, 127, 136, 123, 115, 116, // 35176-35183
117, 120, 124, 112, 116, 143, 158, 140, // 35184-35191
137, 131, 117, 135, 135, 130, 132, 133, // 35192-35199
135, 132, 110, 120, 143, 153, 152, 150, // 35200-35207
146, 140, 148, 132, 127, 118, 115,  92, // 35208-35215
 82,  74,  68,  87, 103, 116, 125, 136, // 35216-35223
137, 151, 139, 136, 138, 145, 129, 127, // 35224-35231
144, 138, 151, 159, 163, 155, 169, 151, // 35232-35239
135, 132, 112,  99,  93,  92,  92,  99, // 35240-35247
101, 119, 107, 111, 124, 132, 136, 137, // 35248-35255
149, 139, 128, 120, 122, 115, 130, 129, // 35256-35263
106, 122, 123, 117, 131, 147, 149, 165, // 35264-35271
158, 146, 128, 118, 127, 129, 132, 119, // 35272-35279
130, 136, 142, 133, 138, 142, 141, 139, // 35280-35287
101,  82,  76,  79,  78,  90,  88, 106, // 35288-35295
126, 141, 144, 138, 151, 161, 176, 144, // 35296-35303
140, 144, 148, 143, 146, 132, 126, 150, // 35304-35311
142, 130, 123, 123, 116, 127, 118, 107, // 35312-35319
 99, 116, 116,  92,  93,  95, 116, 130, // 35320-35327
138, 139, 146, 143, 151, 149, 130, 133, // 35328-35335
128, 111, 110, 100,  86, 111, 134, 149, // 35336-35343
154, 157, 156, 147, 149, 145, 135, 131, // 35344-35351
128, 124, 122, 112, 107, 130, 140, 137, // 35352-35359
133, 113, 105, 113, 105,  93,  93, 101, // 35360-35367
107, 112, 116, 108, 121, 146, 160, 159, // 35368-35375
150, 158, 175, 172, 154, 144, 134, 132, // 35376-35383
136, 118,  96, 103, 114, 119, 117, 122, // 35384-35391
121, 129, 149, 125,  95,  96, 106, 108, // 35392-35399
114, 107, 116, 132, 142, 144, 145, 142, // 35400-35407
156, 157, 132, 117,  96, 100, 110, 123, // 35408-35415
123, 124, 139, 151, 141, 142, 152, 150, // 35416-35423
160, 150, 135, 121, 118, 110, 122, 117, // 35424-35431
107, 112, 106, 107, 106, 112, 109, 123, // 35432-35439
129, 123, 116, 122, 112, 113, 129, 129, // 35440-35447
132, 138, 159, 163, 167, 162, 163, 158, // 35448-35455
149, 140, 116, 107,  99, 102,  92,  94, // 35456-35463
111, 122, 129, 144, 130, 113, 131, 128, // 35464-35471
122, 116, 119, 117, 122, 117, 115, 127, // 35472-35479
138, 155, 143, 137, 127, 125, 128, 126, // 35480-35487
125, 128, 127, 130, 129, 107, 124, 141, // 35488-35495
152, 149, 150, 143, 144, 143, 127, 127, // 35496-35503
114, 115, 102,  94,  79,  86, 101, 112, // 35504-35511
121, 130, 134, 137, 152, 130, 125, 129, // 35512-35519
136, 125, 129, 134, 134, 148, 154, 156, // 35520-35527
149, 158, 150, 143, 126, 110, 102, 100, // 35528-35535
 99, 104, 104, 106, 129, 119, 117, 125, // 35536-35543
134, 135, 143, 143, 130, 123, 120, 121, // 35544-35551
116, 125, 124, 120, 125, 122, 116, 130, // 35552-35559
137, 146, 156, 142, 138, 127, 116, 121, // 35560-35567
131, 125, 125, 137, 139, 140, 135, 138, // 35568-35575
140, 141, 134, 111,  93,  89,  88,  94, // 35576-35583
 96,  97, 118, 128, 140, 143, 134, 136, // 35584-35591
155, 156, 135, 134, 138, 138, 141, 140, // 35592-35599
125, 130, 148, 146, 132, 126, 118, 121, // 35600-35607
126, 114, 110, 106, 119, 121, 106,  93, // 35608-35615
106, 125, 134, 138, 139, 137, 139, 146, // 35616-35623
135, 123, 126, 130, 119, 119, 104, 102, // 35624-35631
124, 136, 145, 145, 144, 144, 147, 137, // 35632-35639
131, 130, 130, 128, 127, 122, 117, 121, // 35640-35647
128, 131, 126, 127, 118, 118, 118, 112, // 35648-35655
110, 112, 118, 122, 125, 123, 126, 129, // 35656-35663
133, 137, 137, 133, 137, 141, 136, 133, // 35664-35671
130, 126, 127, 132, 125, 119, 123, 124, // 35672-35679
127, 127, 129, 128, 132, 132, 128, 121, // 35680-35687
120, 121, 124, 125, 120, 124, 127, 130, // 35688-35695
129, 127, 125, 130, 132, 126, 124, 121, // 35696-35703
124, 127, 129, 128, 130, 131, 134, 133, // 35704-35711
129, 127, 130, 132, 128, 125, 123, 124, // 35712-35719
124, 124, 121, 121, 125, 126, 126, 126, // 35720-35727
127, 129, 133, 133, 132, 129, 129, 129, // 35728-35735
127, 124, 124, 126, 127, 128, 127, 126, // 35736-35743
127, 128, 126, 125, 125, 124, 124, 124, // 35744-35751
123, 125, 127, 130, 132, 131, 131, 132, // 35752-35759
132, 131, 128, 128, 127, 126, 125, 123, // 35760-35767
121, 122, 123, 123, 124, 124, 125, 127, // 35768-35775
129, 129, 130, 130, 131, 132, 130, 130, // 35776-35783
129, 127, 127, 128, 128, 127, 127, 128, // 35784-35791
127, 125, 124, 123, 124, 124, 122, 123, // 35792-35799
124, 126, 129, 130, 130, 131, 132, 132, // 35800-35807
132, 128, 126, 128, 128, 126, 123, 123, // 35808-35815
124, 125, 124, 123, 124, 127, 127, 127, // 35816-35823
127, 126, 128, 130, 130, 129, 129, 130, // 35824-35831
132, 129, 128, 126, 128, 129, 126, 125, // 35832-35839
125, 125, 126, 123, 121, 124, 124, 125, // 35840-35847
127, 126, 126, 128, 131, 131, 130, 129, // 35848-35855
131, 130, 129, 126, 126, 127, 128, 126, // 35856-35863
127, 125, 125, 126, 124, 124, 123, 125, // 35864-35871
126, 128, 127, 128, 130, 130, 130, 130, // 35872-35879
128, 127, 127, 126, 126, 125, 125, 125, // 35880-35887
127, 128, 126, 126, 125, 126, 127, 126, // 35888-35895
124, 126, 128, 129, 129, 128, 129, 131, // 35896-35903
132, 131, 128, 127, 128, 127, 127, 125, // 35904-35911
125, 126, 124, 123, 121, 123, 124, 126, // 35912-35919
125, 125, 126, 128, 129, 128, 128, 128, // 35920-35927
130, 129, 128, 126, 127, 129, 131, 130, // 35928-35935
128, 128, 129, 128, 126, 125, 123, 125, // 35936-35943
126, 126, 126, 127, 129, 130, 129, 128, // 35944-35951
128, 128, 129, 126, 125, 124, 125, 125, // 35952-35959
124, 123, 123, 126, 126, 126, 124, 126, // 35960-35967
128, 129, 129, 128, 128, 129, 130, 131, // 35968-35975
131, 129, 130, 129, 129, 129, 127, 129, // 35976-35983
129, 128, 125, 124, 120, 122, 123, 123, // 35984-35991
123, 124, 126, 128, 129, 128, 129, 131, // 35992-35999
133, 130, 128, 126, 127, 127, 127, 127, // 36000-36007
126, 128, 129, 129, 126, 126, 127, 127, // 36008-36015
127, 126, 124, 126, 128, 128, 128, 128, // 36016-36023
130, 130, 130, 129, 127, 127, 128, 127, // 36024-36031
125, 123, 121, 124, 124, 123, 122, 124, // 36032-36039
126, 129, 130, 129, 129, 130, 131, 130, // 36040-36047
129, 128, 127, 128, 126, 126, 126, 129, // 36048-36055
131, 131, 128, 127, 127, 126, 124, 124, // 36056-36063
123, 124, 126, 125, 123, 125, 128, 129, // 36064-36071
131, 132, 128, 129, 130, 127, 126, 126, // 36072-36079
126, 126, 125, 123, 124, 126, 127, 128, // 36080-36087
128, 129, 129, 130, 129, 128, 128, 126, // 36088-36095
125, 126, 124, 124, 126, 127, 129, 131, // 36096-36103
128, 128, 128, 127, 127, 125, 122, 121, // 36104-36111
123, 124, 125, 126, 128, 129, 131, 132, // 36112-36119
131, 133, 132, 129, 128, 127, 124, 126, // 36120-36127
127, 126, 126, 126, 125, 125, 126, 126, // 36128-36135
128, 128, 128, 126, 124, 123, 124, 125, // 36136-36143
125, 126, 127, 127, 127, 130, 128, 130, // 36144-36151
133, 131, 129, 127, 125, 124, 126, 125, // 36152-36159
124, 125, 127, 128, 129, 131, 130, 131, // 36160-36167
131, 130, 127, 125, 123, 125, 124, 122, // 36168-36175
125, 124, 126, 127, 127, 126, 127, 128, // 36176-36183
128, 128, 127, 125, 126, 127, 126, 126, // 36184-36191
128, 130, 131, 132, 130, 129, 131, 129, // 36192-36199
130, 129, 127, 125, 125, 122, 122, 123, // 36200-36207
125, 127, 129, 129, 128, 129, 127, 127, // 36208-36215
126, 125, 124, 124, 122, 121, 124, 125, // 36216-36223
128, 130, 130, 130, 131, 129, 128, 129, // 36224-36231
128, 127, 126, 127, 127, 127, 128, 130, // 36232-36239
130, 132, 129, 128, 128, 125, 126, 125, // 36240-36247
124, 123, 123, 122, 122, 123, 123, 125, // 36248-36255
127, 128, 129, 130, 129, 131, 129, 129, // 36256-36263
127, 128, 127, 126, 127, 126, 127, 129, // 36264-36271
131, 131, 132, 131, 129, 127, 124, 123, // 36272-36279
123, 124, 123, 125, 126, 126, 127, 129, // 36280-36287
128, 128, 128, 127, 126, 124, 122, 123, // 36288-36295
125, 124, 126, 127, 127, 128, 128, 129, // 36296-36303
132, 133, 132, 131, 130, 128, 127, 127, // 36304-36311
126, 126, 127, 126, 125, 127, 127, 128, // 36312-36319
129, 129, 127, 126, 124, 122, 120, 119, // 36320-36327
122, 123, 124, 126, 129, 131, 131, 131, // 36328-36335
131, 130, 130, 130, 128, 127, 125, 126, // 36336-36343
127, 128, 129, 131, 131, 132, 129, 127, // 36344-36351
127, 128, 127, 125, 124, 123, 123, 122, // 36352-36359
123, 123, 124, 126, 127, 127, 126, 126, // 36360-36367
127, 128, 127, 128, 127, 127, 126, 125, // 36368-36375
127, 129, 131, 132, 133, 133, 132, 131, // 36376-36383
129, 128, 127, 127, 124, 122, 123, 122, // 36384-36391
125, 126, 127, 128, 130, 128, 126, 123, // 36392-36399
122, 123, 124, 123, 125, 126, 127, 127, // 36400-36407
128, 128, 130, 132, 132, 132, 130, 127, // 36408-36415
127, 128, 126, 126, 127, 128, 128, 127, // 36416-36423
126, 129, 131, 130, 129, 128, 127, 125, // 36424-36431
123, 121, 119, 121, 123, 123, 124, 125, // 36432-36439
127, 130, 132, 130, 131, 131, 129, 126, // 36440-36447
123, 124, 127, 129, 130, 130, 131, 131, // 36448-36455
131, 131, 128, 128, 128, 126, 124, 122, // 36456-36463
121, 122, 125, 125, 127, 127, 127, 127, // 36464-36471
126, 125, 127, 127, 127, 128, 126, 125, // 36472-36479
125, 126, 127, 128, 130, 130, 131, 132, // 36480-36487
131, 130, 131, 130, 129, 127, 126, 124, // 36488-36495
123, 123, 125, 127, 126, 128, 129, 129, // 36496-36503
127, 126, 124, 122, 123, 122, 121, 121, // 36504-36511
123, 125, 128, 129, 130, 133, 134, 132, // 36512-36519
129, 127, 128, 128, 128, 128, 128, 128, // 36520-36527
127, 127, 127, 128, 130, 131, 129, 127, // 36528-36535
125, 124, 124, 124, 123, 123, 124, 124, // 36536-36543
124, 123, 124, 128, 131, 131, 130, 128, // 36544-36551
127, 127, 126, 125, 125, 127, 128, 129, // 36552-36559
129, 130, 131, 133, 133, 131, 130, 129, // 36560-36567
127, 124, 123, 122, 123, 125, 127, 127, // 36568-36575
127, 128, 128, 127, 126, 126, 124, 124, // 36576-36583
124, 122, 122, 123, 126, 128, 131, 132, // 36584-36591
132, 131, 130, 131, 131, 132, 130, 130, // 36592-36599
127, 125, 124, 123, 126, 127, 129, 127, // 36600-36607
128, 127, 127, 127, 127, 126, 125, 124, // 36608-36615
122, 121, 121, 123, 126, 129, 129, 130, // 36616-36623
131, 131, 131, 129, 128, 128, 127, 125, // 36624-36631
125, 126, 126, 128, 129, 130, 130, 132, // 36632-36639
131, 129, 127, 125, 124, 125, 124, 123, // 36640-36647
123, 125, 126, 125, 125, 126, 128, 128, // 36648-36655
128, 126, 125, 124, 125, 125, 126, 127, // 36656-36663
129, 128, 129, 128, 128, 132, 134, 132, // 36664-36671
131, 129, 128, 126, 124, 124, 124, 125, // 36672-36679
125, 125, 124, 124, 127, 129, 130, 127, // 36680-36687
127, 125, 124, 122, 122, 124, 125, 126, // 36688-36695
128, 128, 129, 130, 131, 131, 131, 129, // 36696-36703
128, 127, 127, 125, 125, 126, 127, 128, // 36704-36711
129, 130, 129, 129, 129, 127, 126, 126, // 36712-36719
127, 126, 125, 122, 121, 122, 124, 125, // 36720-36727
127, 127, 128, 129, 128, 128, 129, 128, // 36728-36735
129, 128, 126, 125, 124, 127, 129, 131, // 36736-36743
130, 132, 131, 130, 128, 126, 126, 126, // 36744-36751
125, 123, 122, 122, 124, 125, 128, 128, // 36752-36759
129, 130, 129, 128, 126, 126, 126, 127, // 36760-36767
126, 126, 124, 126, 127, 128, 128, 128, // 36768-36775
130, 131, 130, 130, 129, 128, 129, 127, // 36776-36783
127, 126, 126, 126, 127, 126, 126, 127, // 36784-36791
129, 129, 128, 126, 125, 124, 123, 122, // 36792-36799
122, 124, 125, 126, 126, 127, 128, 131, // 36800-36807
132, 132, 131, 129, 129, 128, 126, 126, // 36808-36815
127, 128, 128, 128, 128, 128, 128, 129, // 36816-36823
128, 127, 126, 125, 125, 124, 123, 124, // 36824-36831
125, 126, 126, 126, 127, 127, 129, 129, // 36832-36839
129, 129, 128, 127, 127, 125, 125, 126, // 36840-36847
126, 126, 127, 129, 129, 130, 130, 129, // 36848-36855
130, 129, 128, 126, 126, 124, 124, 124, // 36856-36863
125, 127, 128, 127, 128, 128, 127, 126, // 36864-36871
125, 125, 125, 126, 124, 124, 125, 126, // 36872-36879
129, 131, 131, 130, 132, 131, 130, 129, // 36880-36887
128, 129, 129, 127, 126, 125, 124, 126, // 36888-36895
127, 126, 126, 126, 127, 127, 126, 125, // 36896-36903
125, 127, 127, 125, 124, 125, 126, 126, // 36904-36911
128, 129, 130, 130, 129, 130, 127, 127, // 36912-36919
126, 126, 126, 126, 126, 126, 126, 127, // 36920-36927
128, 129, 130, 129, 129, 128, 127, 125, // 36928-36935
125, 125, 126, 126, 125, 125, 125, 126, // 36936-36943
126, 126, 127, 127, 127, 127, 125, 125, // 36944-36951
126, 127, 129, 128, 128, 128, 130, 128, // 36952-36959
128, 130, 131, 131, 129, 127, 125, 125, // 36960-36967
124, 124, 123, 124, 124, 125, 126, 126, // 36968-36975
127, 127, 129, 128, 127, 126, 127, 127, // 36976-36983
125, 126, 129, 128, 129, 130, 128, 129, // 36984-36991
130, 129, 128, 127, 126, 125, 126, 124, // 36992-36999
125, 126, 127, 128, 128, 128, 129, 128, // 37000-37007
127, 127, 129, 128, 126, 126, 125, 124, // 37008-37015
125, 125, 124, 126, 127, 127, 127, 127, // 37016-37023
128, 129, 130, 129, 128, 127, 128, 128, // 37024-37031
128, 127, 129, 131, 131, 130, 129, 127, // 37032-37039
126, 127, 125, 124, 123, 123, 123, 124, // 37040-37047
122, 123, 127, 129, 128, 127, 128, 128, // 37048-37055
129, 129, 128, 129, 128, 128, 128, 127, // 37056-37063
127, 128, 128, 128, 128, 128, 127, 127, // 37064-37071
127, 126, 127, 126, 127, 126, 127, 126, // 37072-37079
125, 126, 127, 130, 129, 128, 127, 128, // 37080-37087
126, 126, 125, 123, 125, 126, 123, 124, // 37088-37095
125, 126, 129, 129, 130, 130, 131, 131, // 37096-37103
129, 127, 128, 128, 129, 128, 127, 127, // 37104-37111
127, 128, 128, 126, 126, 126, 125, 123, // 37112-37119
123, 123, 123, 124, 126, 124, 126, 128, // 37120-37127
128, 129, 130, 130, 130, 131, 129, 128, // 37128-37135
127, 127, 127, 126, 126, 125, 126, 127, // 37136-37143
127, 128, 128, 128, 129, 128, 127, 127, // 37144-37151
126, 125, 126, 127, 127, 127, 127, 128, // 37152-37159
127, 128, 126, 126, 126, 125, 125, 124, // 37160-37167
123, 124, 125, 125, 127, 128, 130, 131, // 37168-37175
131, 130, 130, 131, 130, 129, 128, 128, // 37176-37183
126, 127, 125, 124, 126, 126, 125, 125, // 37184-37191
124, 125, 126, 125, 126, 126, 126, 126, // 37192-37199
127, 126, 127, 129, 129, 129, 130, 130, // 37200-37207
130, 131, 129, 127, 127, 127, 125, 124, // 37208-37215
124, 124, 126, 127, 128, 129, 129, 129, // 37216-37223
128, 128, 127, 127, 128, 126, 125, 125, // 37224-37231
124, 125, 126, 127, 127, 127, 126, 127, // 37232-37239
127, 126, 126, 127, 126, 126, 127, 127, // 37240-37247
128, 128, 129, 129, 130, 131, 130, 131, // 37248-37255
130, 127, 126, 126, 124, 124, 123, 123, // 37256-37263
124, 125, 125, 127, 127, 129, 129, 128, // 37264-37271
127, 127, 127, 128, 129, 128, 127, 128, // 37272-37279
128, 128, 128, 128, 128, 129, 128, 125, // 37280-37287
124, 125, 125, 125, 126, 126, 126, 127, // 37288-37295
128, 127, 129, 129, 131, 130, 128, 126, // 37296-37303
126, 126, 126, 125, 124, 125, 125, 125, // 37304-37311
125, 126, 128, 129, 128, 129, 128, 128, // 37312-37319
128, 127, 127, 128, 128, 129, 130, 129, // 37320-37327
128, 128, 128, 128, 126, 125, 126, 124, // 37328-37335
123, 123, 123, 125, 125, 128, 127, 128, // 37336-37343
128, 128, 129, 130, 130, 131, 129, 127, // 37344-37351
127, 125, 126, 126, 127, 126, 127, 126, // 37352-37359
125, 126, 127, 128, 127, 127, 127, 126, // 37360-37367
126, 126, 126, 128, 129, 129, 128, 128, // 37368-37375
128, 128, 127, 127, 126, 125, 126, 125, // 37376-37383
124, 123, 126, 127, 127, 128, 128, 129, // 37384-37391
129, 129, 128, 128, 130, 131, 129, 127, // 37392-37399
126, 127, 126, 126, 126, 126, 126, 127, // 37400-37407
125, 124, 124, 126, 126, 126, 125, 125, // 37408-37415
126, 128, 128, 128, 130, 132, 133, 130, // 37416-37423
129, 128, 127, 128, 127, 125, 124, 125, // 37424-37431
125, 124, 124, 126, 128, 128, 128, 126, // 37432-37439
126, 127, 127, 127, 127, 126, 127, 127, // 37440-37447
127, 127, 127, 127, 129, 129, 128, 126, // 37448-37455
127, 126, 126, 126, 126, 127, 127, 126, // 37456-37463
127, 128, 128, 128, 129, 129, 130, 128, // 37464-37471
128, 126, 126, 125, 125, 125, 126, 126, // 37472-37479
126, 125, 124, 127, 127, 128, 128, 128, // 37480-37487
127, 127, 126, 127, 128, 129, 130, 130, // 37488-37495
128, 127, 129, 128, 128, 127, 126, 125, // 37496-37503
125, 125, 125, 129, 161, 162, 138, 102, // 37504-37511
 80,  89,  56,  44, 139, 155, 115, 163, // 37512-37519
198,   8, 245, 154, 125,  93,  91,  83, // 37520-37527
 25,  48, 116, 131, 154, 141, 157, 196, // 37528-37535
132,  85,  10,   2,  93,  94,  86, 148, // 37536-37543
191, 177, 189, 121, 238,  26,  67, 220, // 37544-37551
164, 174, 202, 192, 225,  99, 120, 126, // 37552-37559
203,   1,  81,  55, 236, 212, 185, 188, // 37560-37567
171, 112, 142, 193, 200, 214, 189, 207, // 37568-37575
228, 152, 100,  19,  35, 106,  92,  85, // 37576-37583
149, 175, 167, 168, 110, 254, 238,  30, // 37584-37591
202, 155, 174, 196, 183, 231,  98,  98, // 37592-37599
124, 196, 249,  66,  25, 216, 198, 173, // 37600-37607
179, 152, 104, 145, 187, 194, 205, 180, // 37608-37615
208, 214, 142,  89,  13,  51, 107,  89, // 37616-37623
 89, 155, 166, 168, 151, 118,  15, 199, // 37624-37631
 15, 200, 162, 186, 204, 191,   1, 111, // 37632-37639
 97, 141, 203,   2,  61,   6, 207, 190, // 37640-37647
168, 176, 141, 102, 151, 186, 193, 200, // 37648-37655
177, 211, 202, 135,  78,  15,  68, 110, // 37656-37663
 89,  96, 163, 163, 174, 140, 139,  25, // 37664-37671
163,   4, 198, 171, 197, 212, 200,  24, // 37672-37679
114,  94, 153, 207,   9,  54, 247, 202, // 37680-37687
184, 167, 175, 133, 106, 159, 183, 191, // 37688-37695
193, 174, 213, 190, 129,  67,  22,  85, // 37696-37703
111,  90, 106, 168, 156, 174, 126, 163, // 37704-37711
 21, 129,   0, 199, 182, 207, 218, 208, // 37712-37719
 48, 113,  97, 165, 209,  15,  42, 231, // 37720-37727
195, 177, 163, 169, 123, 109, 163, 182, // 37728-37735
193, 188, 177, 214, 179, 123,  56,  31, // 37736-37743
 95, 110,  87, 114, 168, 156, 174, 119, // 37744-37751
189,   7,  99, 247, 198, 190, 216, 220, // 37752-37759
219,  68, 109, 106, 178, 213,  19,  29, // 37760-37767
218, 190, 171, 161, 164, 116, 114, 166, // 37768-37775
179, 193, 184, 181, 214, 171, 116,  48, // 37776-37783
 46, 104, 110,  89, 125, 163, 154, 165, // 37784-37791
112, 211, 241,  75, 242, 200, 199, 225, // 37792-37799
225, 235,  86, 103, 114, 183, 215,  21, // 37800-37807
 17, 210, 187, 167, 165, 159, 111, 121, // 37808-37815
169, 178, 191, 175, 181, 208, 162, 108, // 37816-37823
 44,  60, 110, 109,  88, 133, 160, 155, // 37824-37831
155, 114, 228, 211,  57, 240, 203, 208, // 37832-37839
236, 230, 252,  99, 100, 128, 191, 222, // 37840-37847
 22,   3, 200, 184, 164, 165, 153, 107, // 37848-37855
129, 172, 179, 191, 174, 185, 199, 150, // 37856-37863
 94,  39,  70, 111, 103,  87, 140, 153, // 37864-37871
158, 147, 126, 242, 184,  42, 234, 208, // 37872-37879
217, 244, 233,  18, 109,  99, 144, 196, // 37880-37887
229,  24, 248, 194, 178, 158, 162, 144, // 37888-37895
104, 134, 170, 177, 187, 168, 188, 193, // 37896-37903
145,  84,  42,  81, 114, 102,  92, 145, // 37904-37911
146, 160, 133, 139, 244, 156,  35, 238, // 37912-37919
218, 229, 255, 240,  40, 112,  99, 154, // 37920-37927
196, 233,  18, 234, 190, 176, 157, 163, // 37928-37935
136, 103, 141, 168, 174, 178, 161, 186, // 37936-37943
182, 135,  75,  50,  94, 118, 100,  97, // 37944-37951
150, 146, 162, 126, 159, 239, 131,  28, // 37952-37959
238, 225, 242,   6, 246,  61, 112, 104, // 37960-37967
166, 198, 235,   9, 219, 180, 166, 152, // 37968-37975
158, 127, 105, 146, 169, 176, 178, 164, // 37976-37983
188, 175, 126,  65,  54,  99, 117,  97, // 37984-37991
108, 153, 148, 163, 123, 181, 228, 108, // 37992-37999
 20, 238, 230, 248,   9,   0,  77, 110, // 38000-38007
113, 176, 201, 243,   3, 207, 175, 160, // 38008-38015
148, 153, 117, 106, 150, 166, 175, 172, // 38016-38023
165, 190, 172, 120,  62,  67, 106, 117, // 38024-38031
 94, 115, 151, 148, 157, 122, 198, 212, // 38032-38039
 93,  19, 244, 237,   2,  11,   7,  88, // 38040-38047
103, 118, 178, 201, 243, 249, 197, 173, // 38048-38055
159, 150, 150, 112, 111, 152, 164, 174, // 38056-38063
168, 167, 188, 165, 111,  62,  78, 112, // 38064-38071
118,  94, 123, 149, 150, 150, 125, 208, // 38072-38079
189,  76,  14, 247, 247,  15,  14,  24, // 38080-38087
101, 104, 132, 183, 201, 241, 235, 183, // 38088-38095
164, 151, 150, 148, 112, 120, 159, 168, // 38096-38103
177, 167, 168, 182, 154,  97,  58,  83, // 38104-38111
114, 117,  96, 133, 149, 156, 145, 133, // 38112-38119
212, 165,  61,   7, 247, 248,  20,  15, // 38120-38127
 40, 110, 106, 146, 190, 208, 243, 226, // 38128-38135
177, 162, 147, 148, 140, 105, 125, 161, // 38136-38143
167, 177, 165, 173, 184, 152,  92,  64, // 38144-38151
 91, 115, 110,  93, 132, 142, 153, 134, // 38152-38159
145, 214, 148,  58,  13,   1,   2,  27, // 38160-38167
 15,  51, 109, 104, 154, 191, 209, 243, // 38168-38175
219, 175, 163, 148, 150, 135, 103, 128, // 38176-38183
158, 164, 172, 160, 170, 177, 141,  84, // 38184-38191
 71,  98, 118, 109,  98, 138, 140, 153, // 38192-38199
127, 156, 205, 127,  48,  13,   7,  15, // 38200-38207
 39,  26,  73, 114, 113, 166, 188, 207, // 38208-38215
233, 201, 165, 155, 143, 149, 131, 107, // 38216-38223
137, 162, 168, 172, 159, 169, 171, 129, // 38224-38231
 75,  73, 100, 119, 106, 106, 142, 143, // 38232-38239
152, 126, 172, 196, 112,  43,  14,   9, // 38240-38247
 20,  40,  30,  85, 113, 121, 174, 192, // 38248-38255
214, 231, 194, 162, 150, 140, 145, 120, // 38256-38263
103, 137, 158, 167, 169, 160, 174, 170, // 38264-38271
125,  75,  82, 105, 119,  99, 107, 139, // 38272-38279
143, 148, 129, 185, 187, 104,  45,  22, // 38280-38287
 15,  30,  41,  35,  93, 108, 125, 176, // 38288-38295
188, 212, 226, 186, 161, 150, 142, 145, // 38296-38303
117, 107, 141, 156, 164, 164, 157, 170, // 38304-38311
163, 115,  76,  93, 113, 124, 102, 117, // 38312-38319
139, 143, 141, 130, 186, 167,  91,  39, // 38320-38327
 25,  22,  41,  47,  49, 104, 110, 136, // 38328-38335
177, 186, 210, 214, 174, 155, 145, 140, // 38336-38343
142, 113, 112, 147, 159, 166, 161, 156, // 38344-38351
169, 157, 104,  76,  96, 115, 123, 102, // 38352-38359
125, 141, 149, 141, 141, 192, 154,  81, // 38360-38367
 36,  24,  21,  44,  43,  56, 107, 110, // 38368-38375
146, 182, 190, 214, 209, 168, 153, 141, // 38376-38383
137, 136, 107, 116, 149, 159, 168, 163, // 38384-38391
162, 172, 153,  98,  81, 100, 116, 117, // 38392-38399
 98, 124, 137, 146, 133, 150, 191, 143, // 38400-38407
 78,  39,  31,  28,  52,  44,  65, 107, // 38408-38415
110, 150, 179, 189, 212, 203, 166, 154, // 38416-38423
141, 141, 134, 106, 119, 147, 155, 164, // 38424-38431
157, 159, 169, 145,  95,  89, 107, 122, // 38432-38439
118, 102, 128, 136, 144, 129, 157, 183, // 38440-38447
128,  69,  38,  34,  35,  58,  51,  81, // 38448-38455
109, 115, 160, 181, 190, 209, 193, 160, // 38456-38463
151, 139, 140, 131, 108, 127, 150, 157, // 38464-38471
163, 154, 157, 165, 134,  87,  92, 107, // 38472-38479
122, 113, 105, 132, 139, 145, 130, 168, // 38480-38487
174, 117,  64,  39,  35,  41,  62,  55, // 38488-38495
 90, 109, 123, 167, 182, 192, 209, 187, // 38496-38503
157, 148, 135, 138, 124, 106, 130, 150, // 38504-38511
156, 161, 154, 159, 164, 127,  86,  98, // 38512-38519
109, 124, 107, 106, 128, 137, 138, 131, // 38520-38527
174, 165, 111,  61,  47,  43,  55,  69, // 38528-38535
 63,  99, 110, 129, 170, 180, 191, 203, // 38536-38543
177, 154, 145, 136, 139, 121, 109, 134, // 38544-38551
148, 154, 155, 148, 156, 157, 117,  87, // 38552-38559
105, 115, 127, 107, 111, 129, 137, 132, // 38560-38567
133, 173, 149, 101,  59,  53,  51,  67, // 38568-38575
 77,  76, 109, 114, 140, 174, 178, 189, // 38576-38583
196, 168, 149, 141, 132, 135, 116, 109, // 38584-38591
135, 147, 153, 155, 146, 153, 153, 109, // 38592-38599
 91, 108, 118, 128, 107, 117, 133, 140, // 38600-38607
131, 142, 173, 141,  94,  58,  54,  51, // 38608-38615
 70,  74,  80, 109, 114, 145, 175, 178, // 38616-38623
192, 194, 166, 150, 139, 131, 133, 113, // 38624-38631
110, 136, 144, 151, 150, 143, 155, 150, // 38632-38639
106,  99, 113, 122, 126, 106, 119, 132, // 38640-38647
138, 127, 149, 169, 132,  91,  61,  60, // 38648-38655
 57,  78,  75,  86, 109, 114, 147, 170, // 38656-38663
172, 186, 187, 159, 148, 137, 133, 133, // 38664-38671
113, 115, 138, 145, 151, 147, 142, 154, // 38672-38679
144, 103, 105, 116, 125, 126, 109, 124, // 38680-38687
134, 138, 128, 155, 160, 124,  84,  59, // 38688-38695
 61,  62,  81,  78,  94, 111, 121, 155, // 38696-38703
171, 173, 186, 179, 151, 142, 131, 130, // 38704-38711
128, 109, 119, 140, 147, 153, 148, 144, // 38712-38719
157, 137,  99, 107, 116, 127, 121, 110, // 38720-38727
126, 136, 138, 132, 162, 156, 119,  78, // 38728-38735
 61,  60,  65,  83,  78,  97, 109, 124, // 38736-38743
158, 172, 175, 188, 178, 152, 143, 132, // 38744-38751
132, 126, 108, 122, 139, 145, 151, 145, // 38752-38759
145, 158, 133, 101, 113, 118, 129, 118, // 38760-38767
111, 125, 134, 131, 133, 163, 147, 115, // 38768-38775
 78,  66,  65,  73,  85,  80, 100, 109, // 38776-38783
128, 159, 168, 172, 184, 170, 149, 142, // 38784-38791
132, 134, 126, 111, 128, 142, 147, 151, // 38792-38799
144, 145, 155, 124, 101, 114, 119, 130, // 38800-38807
115, 112, 126, 136, 129, 137, 160, 137, // 38808-38815
107,  72,  66,  65,  78,  87,  86, 105, // 38816-38823
113, 137, 165, 170, 175, 182, 163, 145, // 38824-38831
137, 127, 131, 122, 112, 130, 142, 148, // 38832-38839
152, 145, 149, 154, 118, 103, 115, 120, // 38840-38847
129, 113, 115, 129, 137, 127, 143, 159, // 38848-38855
133, 102,  69,  67,  66,  81,  87,  89, // 38856-38863
106, 116, 143, 165, 170, 176, 183, 162, // 38864-38871
145, 138, 130, 132, 119, 114, 131, 140, // 38872-38879
144, 146, 139, 148, 149, 110, 105, 117, // 38880-38887
123, 128, 111, 116, 130, 136, 126, 147, // 38888-38895
153, 128,  98,  72,  72,  71,  85,  88, // 38896-38903
 95, 108, 119, 147, 167, 169, 176, 177, // 38904-38911
154, 143, 136, 131, 132, 119, 118, 137, // 38912-38919
142, 146, 146, 139, 147, 140, 101, 105, // 38920-38927
115, 122, 125, 112, 120, 134, 135, 129, // 38928-38935
155, 148, 121,  90,  69,  71,  73,  90, // 38936-38943
 90, 100, 111, 125, 153, 169, 170, 177, // 38944-38951
174, 149, 140, 132, 129, 130, 116, 119, // 38952-38959
136, 141, 147, 147, 140, 151, 137, 104, // 38960-38967
112, 115, 124, 122, 111, 121, 133, 130, // 38968-38975
132, 158, 143, 119,  88,  74,  73,  74, // 38976-38983
 87,  88, 102, 111, 129, 157, 170, 171, // 38984-38991
179, 170, 150, 142, 131, 127, 124, 111, // 38992-38999
118, 133, 138, 146, 143, 140, 153, 133, // 39000-39007
107, 118, 120, 128, 122, 114, 125, 136, // 39008-39015
130, 138, 160, 139, 116,  85,  76,  75, // 39016-39023
 79,  89,  89, 101, 110, 130, 155, 166, // 39024-39031
167, 174, 163, 146, 140, 130, 128, 124, // 39032-39039
113, 124, 136, 140, 145, 143, 141, 151, // 39040-39047
124, 106, 120, 120, 130, 123, 118, 129, // 39048-39055
138, 129, 142, 157, 132, 110,  82,  77, // 39056-39063
 77,  85,  94,  95, 105, 115, 136, 158, // 39064-39071
165, 165, 171, 157, 139, 133, 126, 128, // 39072-39079
123, 115, 127, 138, 142, 147, 142, 143, // 39080-39087
150, 120, 109, 120, 121, 129, 119, 118, // 39088-39095
129, 135, 126, 146, 151, 127, 106,  81, // 39096-39103
 78,  77,  87,  93,  97, 106, 118, 140, // 39104-39111
160, 164, 165, 170, 154, 141, 136, 129, // 39112-39119
130, 122, 115, 129, 137, 142, 146, 141, // 39120-39127
145, 146, 114, 113, 121, 124, 129, 118, // 39128-39135
118, 129, 132, 125, 148, 144, 123, 101, // 39136-39143
 80,  82,  82,  92,  96, 100, 106, 121, // 39144-39151
142, 159, 161, 164, 167, 149, 140, 135, // 39152-39159
130, 131, 122, 119, 132, 139, 142, 144, // 39160-39167
138, 144, 140, 110, 113, 119, 124, 128, // 39168-39175
117, 120, 130, 129, 128, 151, 139, 120, // 39176-39183
 97,  82,  84,  85,  96, 100, 105, 113, // 39184-39191
127, 146, 160, 160, 164, 163, 145, 138, // 39192-39199
133, 129, 129, 120, 122, 135, 140, 143, // 39200-39207
144, 138, 148, 135, 108, 117, 119, 126, // 39208-39215
125, 116, 119, 131, 126, 130, 151, 133, // 39216-39223
116,  94,  83,  85,  88,  98, 101, 107, // 39224-39231
114, 132, 150, 163, 161, 165, 162, 144, // 39232-39239
137, 131, 126, 126, 117, 120, 133, 138, // 39240-39247
142, 142, 137, 147, 130, 110, 120, 121, // 39248-39255
127, 124, 116, 122, 132, 125, 136, 150, // 39256-39263
130, 115,  92,  85,  88,  91, 100, 105, // 39264-39271
108, 116, 135, 151, 162, 159, 163, 156, // 39272-39279
140, 135, 129, 128, 126, 117, 123, 135, // 39280-39287
138, 142, 140, 137, 145, 123, 110, 121, // 39288-39295
121, 128, 124, 118, 125, 135, 125, 141, // 39296-39303
147, 126, 113,  90,  88,  90,  95, 103, // 39304-39311
108, 112, 122, 138, 152, 159, 154, 158, // 39312-39319
149, 134, 131, 126, 126, 125, 118, 127, // 39320-39327
137, 139, 143, 138, 138, 144, 120, 114, // 39328-39335
121, 123, 129, 123, 119, 127, 131, 124, // 39336-39343
144, 141, 122, 110,  90,  90,  91,  98, // 39344-39351
106, 109, 111, 124, 140, 154, 159, 155, // 39352-39359
159, 147, 134, 131, 126, 126, 124, 118, // 39360-39367
126, 136, 137, 143, 138, 141, 143, 120, // 39368-39375
118, 125, 125, 130, 123, 120, 128, 128, // 39376-39383
123, 138, 130, 119, 108,  95,  99, 100, // 39384-39391
106, 112, 115, 117, 127, 136, 144, 146, // 39392-39399
143, 144, 136, 131, 131, 128, 129, 128, // 39400-39407
126, 131, 134, 134, 136, 132, 135, 135, // 39408-39415
124, 124, 125, 127, 129, 125, 125, 127, // 39416-39423
124, 124, 130, 124, 120, 115, 112, 117, // 39424-39431
118, 121, 125, 126, 127, 130, 132, 137, // 39432-39439
136, 132, 130, 126, 127, 127, 126, 127, // 39440-39447
128, 128, 131, 132, 132, 132, 131, 134, // 39448-39455
131, 124, 125, 125, 128, 127, 125, 124, // 39456-39463
125, 122, 123, 126, 123, 122, 119, 120, // 39464-39471
123, 125, 127, 130, 129, 130, 132, 132, // 39472-39479
134, 132, 130, 127, 124, 126, 124, 124, // 39480-39487
126, 127, 126, 127, 129, 132, 132, 131, // 39488-39495
132, 130, 126, 126, 126, 129, 126, 123, // 39496-39503
124, 123, 121, 123, 125, 124, 124, 121, // 39504-39511
123, 127, 128, 129, 130, 130, 131, 131, // 39512-39519
131, 133, 131, 129, 126, 126, 127, 125, // 39520-39527
126, 127, 128, 126, 127, 127, 129, 128, // 39528-39535
128, 130, 127, 125, 125, 126, 129, 127, // 39536-39543
125, 126, 125, 124, 126, 124, 124, 123, // 39544-39551
121, 125, 127, 128, 130, 132, 132, 132, // 39552-39559
131, 131, 133, 130, 127, 124, 124, 126, // 39560-39567
123, 124, 127, 129, 127, 129, 128, 131, // 39568-39575
130, 129, 129, 125, 124, 124, 126, 126, // 39576-39583
124, 124, 126, 125, 124, 127, 126, 125, // 39584-39591
124, 121, 125, 128, 128, 131, 133, 132, // 39592-39599
133, 132, 133, 133, 131, 128, 124, 125, // 39600-39607
123, 122, 123, 126, 126, 126, 127, 128, // 39608-39615
130, 128, 128, 128, 125, 124, 124, 126, // 39616-39623
127, 125, 125, 125, 124, 126, 128, 126, // 39624-39631
126, 123, 123, 126, 127, 128, 131, 133, // 39632-39639
134, 133, 131, 134, 134, 130, 127, 124, // 39640-39647
126, 125, 123, 123, 127, 127, 127, 127, // 39648-39655
127, 129, 127, 127, 126, 123, 124, 124, // 39656-39663
126, 126, 124, 125, 126, 126, 128, 128, // 39664-39671
126, 126, 123, 123, 126, 127, 129, 131, // 39672-39679
132, 132, 132, 129, 132, 132, 129, 126, // 39680-39687
124, 126, 124, 123, 126, 129, 129, 130, // 39688-39695
129, 129, 129, 126, 127, 125, 123, 123, // 39696-39703
124, 126, 126, 125, 126, 126, 124, 127, // 39704-39711
127, 125, 125, 123, 124, 127, 128, 129, // 39712-39719
131, 133, 133, 132, 129, 131, 131, 129, // 39720-39727
125, 123, 124, 123, 123, 125, 128, 127, // 39728-39735
130, 130, 129, 129, 128, 128, 127, 124, // 39736-39743
124, 126, 126, 125, 124, 126, 126, 125, // 39744-39751
126, 125, 124, 124, 121, 123, 127, 128, // 39752-39759
129, 131, 132, 133, 132, 131, 133, 131, // 39760-39767
129, 126, 125, 126, 125, 124, 126, 128, // 39768-39775
128, 129, 127, 128, 127, 127, 127, 125, // 39776-39783
124, 124, 125, 126, 126, 125, 127, 126, // 39784-39791
125, 127, 125, 125, 125, 122, 124, 127, // 39792-39799
128, 129, 130, 132, 133, 130, 130, 131, // 39800-39807
130, 129, 125, 125, 126, 125, 126, 129, // 39808-39815
129, 130, 128, 127, 127, 126, 125, 125, // 39816-39823
123, 123, 124, 126, 126, 126, 126, 128, // 39824-39831
127, 125, 125, 125, 126, 125, 123, 126, // 39832-39839
128, 129, 130, 133, 133, 131, 128, 128, // 39840-39847
130, 127, 126, 124, 126, 126, 126, 127, // 39848-39855
129, 130, 131, 130, 127, 127, 125, 125, // 39856-39863
124, 123, 123, 125, 126, 126, 125, 127, // 39864-39871
129, 127, 126, 127, 127, 127, 124, 125, // 39872-39879
126, 128, 129, 130, 131, 133, 132, 129, // 39880-39887
130, 130, 128, 126, 123, 125, 126, 126, // 39888-39895
126, 128, 129, 130, 129, 127, 127, 127, // 39896-39903
126, 124, 123, 124, 125, 126, 126, 126, // 39904-39911
127, 129, 126, 125, 126, 127, 127, 125, // 39912-39919
125, 127, 128, 128, 131, 132, 132, 131, // 39920-39927
128, 129, 129, 128, 126, 124, 126, 128, // 39928-39935
125, 126, 128, 129, 129, 127, 125, 126, // 39936-39943
127, 126, 125, 124, 126, 128, 127, 127, // 39944-39951
127, 128, 128, 125, 125, 127, 126, 125, // 39952-39959
124, 125, 128, 128, 128, 130, 132, 132, // 39960-39967
130, 128, 129, 128, 126, 125, 124, 127, // 39968-39975
128, 128, 127, 129, 130, 131, 129, 127, // 39976-39983
126, 126, 124, 123, 122, 123, 126, 126, // 39984-39991
127, 128, 130, 129, 126, 126, 126, 125, // 39992-39999
124, 122, 123, 127, 129, 128, 130, 132, // 40000-40007
133, 131, 128, 128, 127, 125, 124, 123, // 40008-40015
125, 127, 127, 128, 130, 131, 131, 130, // 40016-40023
127, 126, 125, 124, 122, 121, 124, 127, // 40024-40031
126, 126, 129, 131, 128, 125, 126, 128, // 40032-40039
128, 125, 124, 125, 127, 127, 127, 129, // 40040-40047
130, 132, 129, 127, 128, 128, 127, 126, // 40048-40055
126, 127, 127, 127, 126, 128, 130, 130, // 40056-40063
127, 126, 127, 126, 125, 123, 122, 125, // 40064-40071
125, 125, 125, 127, 128, 128, 126, 127, // 40072-40079
129, 128, 126, 125, 125, 127, 127, 128, // 40080-40087
129, 131, 132, 130, 127, 128, 128, 127, // 40088-40095
125, 126, 127, 128, 127, 128, 129, 131, // 40096-40103
131, 127, 126, 126, 125, 122, 120, 121, // 40104-40111
124, 124, 125, 126, 129, 129, 128, 127, // 40112-40119
128, 130, 128, 126, 125, 126, 128, 129, // 40120-40127
129, 131, 131, 132, 130, 127, 127, 126, // 40128-40135
126, 123, 124, 127, 127, 126, 127, 129, // 40136-40143
131, 130, 127, 127, 127, 125, 124, 122, // 40144-40151
122, 124, 125, 125, 128, 128, 129, 127, // 40152-40159
127, 128, 130, 128, 127, 126, 127, 128, // 40160-40167
128, 129, 130, 131, 130, 128, 127, 128, // 40168-40175
128, 126, 125, 125, 127, 126, 125, 127, // 40176-40183
128, 130, 128, 125, 125, 126, 124, 124, // 40184-40191
122, 123, 126, 126, 127, 128, 129, 128, // 40192-40199
128, 127, 128, 128, 127, 126, 126, 126, // 40200-40207
129, 128, 129, 130, 130, 130, 128, 126, // 40208-40215
126, 126, 125, 125, 126, 127, 127, 127, // 40216-40223
129, 130, 130, 128, 125, 126, 126, 123, // 40224-40231
123, 122, 123, 126, 127, 128, 129, 129, // 40232-40239
130, 129, 127, 128, 128, 127, 126, 125, // 40240-40247
127, 129, 129, 130, 131, 130, 130, 127, // 40248-40255
126, 126, 126, 125, 124, 124, 126, 126, // 40256-40263
127, 128, 130, 130, 128, 125, 126, 126, // 40264-40271
124, 124, 122, 124, 125, 125, 127, 129, // 40272-40279
129, 130, 129, 129, 130, 130, 128, 126, // 40280-40287
125, 126, 126, 127, 128, 129, 129, 130, // 40288-40295
129, 127, 128, 127, 126, 124, 125, 125, // 40296-40303
126, 125, 128, 129, 131, 128, 127, 128, // 40304-40311
127, 124, 123, 121, 124, 123, 126, 127, // 40312-40319
145, 168, 152, 125,  89,  90,  80,  36, // 40320-40327
 83, 164, 125, 135, 183, 231,  22, 198, // 40328-40335
137, 112,  87,  96,  53,  16,  83, 124, // 40336-40343
139, 152, 136, 187, 177, 109,  56, 238, // 40344-40351
 50, 102,  79, 101, 174, 175, 186, 155, // 40352-40359
149,  52, 184,   6, 195, 163, 196, 203, // 40360-40367
195,  30, 126, 105, 164, 227,  44,  88, // 40368-40375
 15, 223, 199, 181, 189, 136, 111, 170, // 40376-40383
195, 207, 205, 187, 233, 200, 129,  66, // 40384-40391
  7,  79, 106,  80, 106, 171, 158, 175, // 40392-40399
124, 160,  37, 129, 237, 176, 160, 191, // 40400-40407
194, 190,  39, 112,  95, 165, 218,  36, // 40408-40415
 62, 244, 208, 185, 174, 178, 122, 111, // 40416-40423
169, 187, 200, 193, 182, 227, 181, 120, // 40424-40431
 49,  15,  90, 103,  78, 113, 168, 153, // 40432-40439
172, 112, 188,  24,  96, 233, 177, 172, // 40440-40447
201, 200, 205,  63, 108, 102, 177, 224, // 40448-40455
 42,  48, 230, 203, 179, 173, 171, 115, // 40456-40463
119, 173, 187, 200, 188, 187, 225, 169, // 40464-40471
112,  39,  29, 100, 101,  80, 124, 166, // 40472-40479
153, 168, 109, 217,   3,  70, 230, 180, // 40480-40487
183, 210, 207, 221,  83, 104, 113, 188, // 40488-40495
230,  45,  34, 220, 198, 173, 171, 163, // 40496-40503
108, 124, 174, 184, 199, 182, 191, 219, // 40504-40511
160, 106,  33,  46, 107,  99,  81, 134, // 40512-40519
161, 154, 160, 112, 240, 230,  51, 228, // 40520-40527
185, 194, 220, 210, 240,  97,  98, 125, // 40528-40535
194, 235,  45,  18, 210, 192, 168, 171, // 40536-40543
153, 103, 130, 173, 182, 196, 176, 195, // 40544-40551
210, 151,  97,  31,  61, 111,  98,  85, // 40552-40559
142, 154, 158, 150, 122,   0, 198,  35, // 40560-40567
225, 190, 204, 228, 215,   6, 108,  95, // 40568-40575
139, 199, 241,  41,   1, 202, 185, 163, // 40576-40583
168, 144, 102, 139, 175, 184, 194, 173, // 40584-40591
199, 200, 142,  85,  32,  74, 111,  95, // 40592-40599
 90, 150, 149, 161, 137, 138,   6, 165, // 40600-40607
 24, 223, 198, 214, 236, 221,  29, 112, // 40608-40615
 95, 152, 201, 245,  34, 241, 195, 180, // 40616-40623
160, 166, 135, 102, 146, 174, 184, 190, // 40624-40631
172, 202, 191, 136,  77,  39,  87, 114, // 40632-40639
 93,  97, 153, 145, 164, 126, 158,   1, // 40640-40647
134,  16, 223, 206, 223, 243, 228,  51, // 40648-40655
112,  99, 164, 203, 250,  27, 227, 190, // 40656-40663
174, 157, 164, 126, 104, 151, 173, 183, // 40664-40671
185, 171, 201, 181, 128,  67,  46,  97, // 40672-40679
114,  90, 106, 155, 144, 163, 119, 180, // 40680-40687
246, 109,  10, 222, 213, 234, 247, 238, // 40688-40695
 71, 110, 106, 175, 205, 255,  17, 215, // 40696-40703
185, 169, 157, 160, 119, 110, 157, 172, // 40704-40711
184, 179, 171, 199, 170, 119,  58,  56, // 40712-40719
102, 114,  88, 115, 153, 145, 159, 115, // 40720-40727
199, 228,  88,   6, 226, 221, 245, 252, // 40728-40735
252,  89, 106, 116, 181, 207,   2,   6, // 40736-40743
204, 180, 163, 156, 155, 112, 115, 160, // 40744-40751
171, 184, 175, 174, 196, 163, 109,  53, // 40752-40759
 66, 108, 112,  87, 122, 149, 147, 151, // 40760-40767
118, 217, 205,  72,   3, 230, 230, 255, // 40768-40775
253,  10, 100, 102, 128, 186, 211,   5, // 40776-40783
251, 196, 177, 159, 157, 149, 106, 120, // 40784-40791
160, 169, 181, 168, 175, 192, 155, 100, // 40792-40799
 53,  79, 113, 110,  89, 132, 147, 151, // 40800-40807
142, 127, 227, 180,  59,   0, 234, 238, // 40808-40815
  8, 255,  27, 108, 101, 139, 188, 212, // 40816-40823
  3, 239, 189, 173, 156, 156, 143, 104, // 40824-40831
128, 164, 169, 179, 165, 176, 186, 146, // 40832-40839
 88,  55,  86, 115, 108,  91, 138, 144, // 40840-40847
156, 135, 141, 229, 156,  49, 254, 238, // 40848-40855
245,  16,   3,  47, 113, 103, 153, 190, // 40856-40863
216,   0, 224, 179, 167, 150, 154, 135, // 40864-40871
102, 134, 163, 170, 179, 163, 179, 180, // 40872-40879
138,  80,  60,  95, 118, 104,  96, 143, // 40880-40887
142, 157, 128, 158, 226, 135,  42,   0, // 40888-40895
245, 255,  23,   9,  65, 114, 108, 163, // 40896-40903
191, 221, 252, 212, 174, 162, 146, 151, // 40904-40911
126, 102, 139, 161, 169, 175, 162, 180, // 40912-40919
174, 130,  73,  70, 102, 120, 101, 104, // 40920-40927
145, 142, 154, 121, 174, 213, 114,  34, // 40928-40935
  0, 250,   7,  27,  15,  81, 113, 115, // 40936-40943
171, 193, 225, 246, 202, 170, 158, 145, // 40944-40951
150, 120, 105, 144, 161, 170, 172, 161, // 40952-40959
178, 169, 122,  70,  77, 107, 121,  98, // 40960-40967
112, 146, 144, 151, 123, 189, 199,  99, // 40968-40975
 30,   3, 254,  16,  28,  23,  93, 108, // 40976-40983
123, 176, 194, 227, 237, 191, 165, 154, // 40984-40991
144, 146, 114, 109, 148, 162, 171, 170, // 40992-40999
164, 179, 163, 113,  68,  84, 109, 118, // 41000-41007
 94, 117, 142, 145, 146, 129, 200, 182, // 41008-41015
 87,  26,   7,   3,  25,  30,  36, 102, // 41016-41023
109, 134, 181, 196, 228, 229, 183, 160, // 41024-41031
147, 140, 140, 107, 112, 150, 161, 171, // 41032-41039
166, 165, 178, 158, 104,  71,  92, 114, // 41040-41047
118,  95, 124, 142, 149, 139, 136, 203, // 41048-41055
163,  77,  25,  11,   8,  33,  32,  49, // 41056-41063
108, 109, 144, 183, 197, 228, 220, 176, // 41064-41071
159, 145, 140, 136, 104, 117, 151, 161, // 41072-41079
170, 162, 165, 175, 151,  95,  74,  98, // 41080-41087
118, 114,  96, 130, 140, 150, 134, 147, // 41088-41095
204, 148,  69,  25,  16,  16,  41,  33, // 41096-41103
 61, 110, 110, 152, 183, 198, 227, 210, // 41104-41111
170, 155, 141, 141, 131, 103, 122, 152, // 41112-41119
160, 168, 160, 165, 173, 143,  88,  79, // 41120-41127
103, 119, 111,  98, 132, 139, 150, 130, // 41128-41135
161, 199, 133,  62,  27,  20,  24,  48, // 41136-41143
 38,  75, 112, 114, 160, 184, 200, 223, // 41144-41151
200, 163, 151, 138, 140, 125, 103, 129, // 41152-41159
153, 160, 167, 157, 164, 169, 136,  84, // 41160-41167
 86, 107, 122, 108, 103, 135, 140, 148, // 41168-41175
128, 170, 188, 119,  57,  29,  24,  33, // 41176-41183
 53,  42,  85, 112, 121, 166, 183, 201, // 41184-41191
220, 191, 159, 148, 136, 139, 121, 104, // 41192-41199
132, 153, 161, 164, 155, 164, 166, 125, // 41200-41207
 81,  91, 110, 123, 104, 109, 136, 142, // 41208-41215
146, 130, 179, 178, 109,  53,  32,  29, // 41216-41223
 42,  56,  49,  95, 111, 128, 171, 183, // 41224-41231
204, 216, 183, 156, 144, 134, 137, 116, // 41232-41239
105, 134, 151, 161, 161, 154, 165, 163, // 41240-41247
118,  81,  97, 112, 122, 101, 114, 136, // 41248-41255
145, 142, 136, 185, 165,  99,  49,  35, // 41256-41263
 32,  49,  57,  57, 101, 110, 137, 176, // 41264-41271
186, 205, 209, 175, 154, 142, 135, 136, // 41272-41279
111, 109, 138, 150, 158, 156, 151, 162, // 41280-41287
156, 108,  83, 104, 116, 122, 102, 120, // 41288-41295
137, 146, 137, 143, 185, 150,  90,  49, // 41296-41303
 42,  39,  59,  60,  67, 105, 112, 145, // 41304-41311
176, 183, 202, 201, 168, 152, 139, 135, // 41312-41319
134, 109, 112, 140, 149, 157, 153, 150, // 41320-41327
163, 151, 102,  90, 107, 119, 120, 102, // 41328-41335
123, 135, 145, 135, 151, 181, 141,  87, // 41336-41343
 52,  48,  45,  66,  62,  76, 109, 114, // 41344-41351
151, 176, 183, 201, 192, 161, 146, 134, // 41352-41359
132, 128, 106, 116, 141, 149, 157, 152, // 41360-41367
151, 163, 145,  98,  95, 109, 121, 117, // 41368-41375
103, 126, 136, 144, 133, 158, 176, 132, // 41376-41383
 82,  53,  49,  50,  72,  64,  85, 111, // 41384-41391
121, 160, 177, 183, 200, 186, 155, 144, // 41392-41399
132, 131, 124, 102, 118, 142, 149, 157, // 41400-41407
150, 152, 163, 138,  95, 100, 109, 121, // 41408-41415
113, 105, 127, 136, 141, 133, 163, 168, // 41416-41423
123,  77,  55,  51,  55,  74,  67,  93, // 41424-41431
112, 126, 164, 177, 185, 199, 180, 152, // 41432-41439
143, 130, 132, 121, 103, 125, 144, 150, // 41440-41447
157, 149, 152, 161, 128,  92, 103, 109, // 41448-41455
121, 111, 110, 130, 139, 140, 136, 168, // 41456-41463
160, 116,  72,  56,  51,  61,  74,  69, // 41464-41471
 98, 113, 132, 168, 176, 183, 194, 172, // 41472-41479
148, 140, 128, 131, 117, 104, 130, 145, // 41480-41487
152, 158, 149, 153, 158, 120,  93, 106, // 41488-41495
110, 122, 109, 113, 132, 140, 138, 140, // 41496-41503
170, 151, 109,  69,  59,  54,  67,  76, // 41504-41511
 75, 103, 115, 140, 170, 175, 184, 192, // 41512-41519
166, 146, 137, 127, 129, 112, 106, 132, // 41520-41527
144, 151, 154, 147, 154, 154, 113,  96, // 41528-41535
109, 113, 123, 108, 116, 133, 141, 135, // 41536-41543
146, 169, 143, 103,  69,  61,  56,  72, // 41544-41551
 77,  81, 108, 118, 146, 172, 175, 186, // 41552-41559
189, 161, 145, 136, 127, 128, 110, 109, // 41560-41567
134, 143, 151, 152, 146, 154, 149, 107, // 41568-41575
100, 110, 115, 121, 106, 119, 133, 141, // 41576-41583
133, 152, 166, 137,  99,  69,  64,  60, // 41584-41591
 78,  78,  86, 109, 121, 150, 172, 174, // 41592-41599
184, 184, 156, 143, 132, 127, 126, 108, // 41600-41607
113, 136, 143, 151, 151, 145, 155, 145, // 41608-41615
103, 104, 112, 119, 121, 108, 122, 134, // 41616-41623
139, 132, 156, 159, 130,  93,  68,  64, // 41624-41631
 63,  82,  81,  93, 113, 126, 155, 170, // 41632-41639
172, 183, 177, 151, 140, 130, 127, 125, // 41640-41647
108, 117, 137, 145, 152, 148, 144, 155, // 41648-41655
139, 102, 108, 113, 123, 121, 111, 124, // 41656-41663
136, 138, 133, 159, 153, 124,  90,  69, // 41664-41671
 65,  68,  85,  82,  98, 112, 130, 158, // 41672-41679
169, 171, 181, 172, 149, 139, 129, 127, // 41680-41687
122, 107, 120, 138, 145, 153, 147, 145, // 41688-41695
155, 132, 101, 110, 113, 123, 118, 113, // 41696-41703
126, 137, 135, 136, 161, 146, 118,  85, // 41704-41711
 71,  66,  72,  88,  87, 104, 115, 134, // 41712-41719
160, 168, 169, 178, 166, 146, 137, 127, // 41720-41727
127, 122, 111, 127, 141, 146, 151, 144, // 41728-41735
144, 153, 125, 102, 112, 114, 124, 117, // 41736-41743
116, 127, 136, 129, 138, 157, 138, 113, // 41744-41751
 83,  72,  68,  78,  92,  92, 108, 118, // 41752-41759
140, 162, 167, 169, 177, 162, 143, 136, // 41760-41767
127, 127, 120, 113, 130, 142, 146, 149, // 41768-41775
141, 144, 149, 118, 105, 114, 116, 125, // 41776-41783
116, 120, 128, 134, 126, 141, 153, 131, // 41784-41791
107,  80,  75,  71,  85,  93,  96, 111, // 41792-41799
121, 143, 161, 165, 170, 175, 159, 143, // 41800-41807
136, 129, 128, 119, 116, 131, 138, 142, // 41808-41815
143, 137, 144, 146, 114, 107, 115, 119, // 41816-41823
126, 117, 122, 131, 135, 126, 146, 150, // 41824-41831
129, 105,  81,  76,  74,  89,  94, 100, // 41832-41839
113, 124, 145, 161, 165, 170, 173, 155, // 41840-41847
142, 134, 128, 127, 118, 118, 133, 139, // 41848-41855
141, 141, 137, 146, 141, 109, 110, 115, // 41856-41863
121, 123, 116, 122, 132, 133, 127, 151, // 41864-41871
147, 126, 102,  81,  79,  78,  92,  95, // 41872-41879
103, 115, 129, 150, 163, 165, 171, 172, // 41880-41887
151, 139, 131, 125, 123, 114, 116, 132, // 41888-41895
137, 139, 141, 138, 148, 137, 109, 114, // 41896-41903
117, 122, 122, 116, 122, 131, 129, 129, // 41904-41911
152, 142, 123,  97,  83,  81,  82,  94, // 41912-41919
 97, 106, 115, 132, 152, 163, 165, 171, // 41920-41927
169, 149, 138, 131, 125, 122, 113, 118, // 41928-41935
133, 137, 139, 140, 139, 150, 133, 108, // 41936-41943
115, 118, 124, 120, 117, 123, 135, 127, // 41944-41951
133, 153, 137, 122,  95,  84,  81,  85, // 41952-41959
 96,  99, 107, 118, 136, 153, 161, 162, // 41960-41967
171, 166, 145, 136, 128, 124, 122, 113, // 41968-41975
120, 136, 138, 140, 139, 139, 149, 126, // 41976-41983
107, 117, 118, 124, 119, 117, 125, 135, // 41984-41991
126, 138, 152, 134, 119,  92,  86,  83, // 41992-41999
 88,  98, 101, 108, 119, 138, 154, 160, // 42000-42007
161, 169, 162, 142, 134, 128, 126, 123, // 42008-42015
112, 123, 137, 138, 141, 139, 141, 149, // 42016-42023
123, 110, 119, 120, 125, 117, 114, 124, // 42024-42031
133, 123, 141, 146, 130, 116,  92,  88, // 42032-42039
 85,  91,  99, 102, 108, 122, 140, 155, // 42040-42047
159, 159, 170, 159, 141, 135, 127, 127, // 42048-42055
122, 113, 127, 138, 138, 141, 138, 143, // 42056-42063
148, 118, 112, 120, 120, 125, 116, 114, // 42064-42071
126, 130, 123, 145, 143, 128, 114,  91, // 42072-42079
 89,  87,  95, 101, 104, 109, 124, 142, // 42080-42087
155, 156, 158, 168, 156, 139, 134, 127, // 42088-42095
129, 121, 115, 130, 140, 140, 141, 137, // 42096-42103
144, 144, 115, 115, 119, 121, 123, 113, // 42104-42111
113, 126, 128, 126, 147, 138, 128, 112, // 42112-42119
 93,  91,  89,  97, 102, 104, 109, 126, // 42120-42127
143, 155, 155, 160, 167, 153, 138, 132, // 42128-42135
127, 128, 118, 114, 131, 139, 141, 141, // 42136-42143
137, 146, 142, 114, 116, 117, 121, 121, // 42144-42151
110, 112, 127, 125, 129, 149, 136, 128, // 42152-42159
111,  96,  95,  94, 102, 106, 106, 112, // 42160-42167
131, 147, 154, 151, 158, 164, 148, 136, // 42168-42175
129, 126, 128, 117, 116, 132, 139, 141, // 42176-42183
140, 135, 147, 136, 114, 118, 118, 123, // 42184-42191
120, 111, 114, 126, 122, 130, 140, 129, // 42192-42199
126, 112, 104, 104, 105, 111, 113, 113, // 42200-42207
118, 130, 140, 144, 141, 147, 148, 138, // 42208-42215
132, 127, 128, 128, 121, 122, 131, 134, // 42216-42223
135, 133, 131, 139, 129, 121, 123, 122, // 42224-42231
125, 122, 117, 120, 126, 124, 131, 134, // 42232-42239
130, 130, 122, 120, 119, 119, 122, 122, // 42240-42247
120, 123, 130, 134, 134, 133, 137, 137, // 42248-42255
132, 129, 126, 127, 126, 121, 122, 127, // 42256-42263
130, 131, 129, 129, 135, 129, 126, 125, // 42264-42271
124, 126, 123, 118, 122, 125, 124, 129, // 42272-42279
130, 131, 132, 128, 128, 126, 126, 127, // 42280-42287
125, 122, 124, 128, 130, 130, 130, 134, // 42288-42295
135, 132, 127, 125, 126, 123, 119, 121, // 42296-42303
125, 127, 127, 127, 130, 134, 130, 128, // 42304-42311
126, 127, 126, 122, 120, 124, 125, 126, // 42312-42319
129, 130, 131, 132, 128, 126, 125, 126, // 42320-42327
126, 124, 122, 125, 129, 130, 128, 128, // 42328-42335
132, 133, 130, 126, 126, 127, 124, 122, // 42336-42343
123, 128, 128, 127, 127, 131, 132, 130, // 42344-42351
128, 126, 127, 126, 123, 122, 125, 126, // 42352-42359
127, 128, 130, 130, 131, 129, 126, 126, // 42360-42367
125, 125, 123, 122, 125, 129, 129, 127, // 42368-42375
129, 132, 132, 128, 126, 126, 125, 124, // 42376-42383
122, 124, 128, 129, 128, 128, 130, 131, // 42384-42391
130, 126, 125, 127, 126, 123, 123, 124, // 42392-42399
127, 127, 129, 130, 130, 131, 128, 126, // 42400-42407
125, 127, 126, 125, 124, 126, 128, 127, // 42408-42415
128, 129, 131, 131, 128, 126, 127, 126, // 42416-42423
125, 124, 125, 128, 128, 126, 128, 129, // 42424-42431
129, 128, 125, 126, 126, 124, 123, 124, // 42432-42439
125, 127, 127, 130, 130, 130, 130, 128, // 42440-42447
126, 125, 126, 125, 125, 125, 127, 129, // 42448-42455
129, 129, 131, 133, 131, 127, 126, 126, // 42456-42463
125, 125, 124, 126, 130, 128, 127, 130, // 42464-42471
129, 128, 126, 123, 125, 124, 123, 123, // 42472-42479
125, 125, 128, 129, 131, 132, 132, 131, // 42480-42487
128, 125, 124, 123, 123, 124, 125, 127, // 42488-42495
129, 129, 130, 131, 132, 131, 128, 127, // 42496-42503
126, 124, 123, 124, 126, 130, 129, 128, // 42504-42511
131, 130, 128, 126, 124, 125, 124, 121, // 42512-42519
123, 125, 125, 128, 128, 129, 132, 130, // 42520-42527
128, 127, 125, 124, 125, 123, 125, 126, // 42528-42535
128, 129, 129, 131, 131, 132, 131, 128, // 42536-42543
127, 126, 124, 122, 124, 126, 129, 128, // 42544-42551
128, 130, 127, 127, 126, 125, 126, 125, // 42552-42559
122, 123, 125, 126, 129, 129, 131, 132, // 42560-42567
130, 128, 127, 124, 124, 123, 123, 125, // 42568-42575
126, 127, 129, 130, 132, 132, 132, 130, // 42576-42583
128, 127, 125, 122, 123, 125, 127, 130, // 42584-42591
130, 130, 130, 128, 127, 125, 124, 125, // 42592-42599
122, 120, 122, 124, 126, 130, 131, 133, // 42600-42607
134, 131, 129, 127, 126, 124, 123, 123, // 42608-42615
124, 126, 127, 129, 131, 133, 132, 130, // 42616-42623
129, 127, 126, 124, 122, 123, 125, 127, // 42624-42631
130, 131, 132, 131, 128, 127, 127, 126, // 42632-42639
125, 122, 120, 122, 124, 125, 128, 130, // 42640-42647
132, 132, 129, 127, 127, 126, 124, 122, // 42648-42655
123, 126, 127, 127, 129, 132, 132, 132, // 42656-42663
130, 129, 128, 126, 124, 122, 122, 124, // 42664-42671
127, 129, 131, 132, 130, 129, 128, 128, // 42672-42679
129, 127, 122, 120, 122, 123, 126, 128, // 42680-42687
129, 131, 131, 127, 127, 126, 126, 124, // 42688-42695
122, 122, 125, 126, 126, 130, 132, 134, // 42696-42703
131, 130, 130, 129, 127, 123, 122, 122, // 42704-42711
125, 127, 130, 132, 131, 129, 128, 128, // 42712-42719
128, 128, 125, 122, 120, 122, 124, 126, // 42720-42727
128, 130, 132, 131, 128, 127, 126, 126, // 42728-42735
123, 122, 123, 125, 126, 126, 130, 133, // 42736-42743
133, 131, 130, 129, 130, 127, 125, 124, // 42744-42751
123, 125, 128, 130, 130, 130, 129, 128, // 42752-42759
128, 128, 127, 125, 122, 121, 122, 125, // 42760-42767
127, 128, 129, 130, 129, 129, 127, 127, // 42768-42775
126, 124, 123, 125, 127, 126, 127, 129, // 42776-42783
131, 130, 129, 129, 129, 129, 126, 124, // 42784-42791
124, 124, 126, 129, 131, 130, 129, 128, // 42792-42799
128, 127, 128, 127, 125, 123, 123, 123, // 42800-42807
127, 128, 129, 129, 128, 129, 128, 125, // 42808-42815
127, 125, 123, 123, 125, 127, 127, 127, // 42816-42823
129, 131, 129, 130, 129, 129, 129, 126, // 42824-42831
126, 125, 124, 127, 129, 130, 129, 127, // 42832-42839
127, 128, 128, 128, 126, 124, 123, 122, // 42840-42847
124, 128, 129, 129, 129, 128, 129, 129, // 42848-42855
127, 128, 126, 124, 125, 125, 126, 127, // 42856-42863
127, 130, 130, 128, 129, 130, 128, 128, // 42864-42871
126, 125, 125, 123, 126, 129, 130, 128, // 42872-42879
126, 127, 128, 129, 127, 126, 124, 123, // 42880-42887
122, 124, 128, 128, 129, 128, 128, 130, // 42888-42895
130, 127, 129, 127, 124, 125, 125, 126, // 42896-42903
129, 129, 130, 130, 128, 130, 130, 128, // 42904-42911
127, 125, 125, 125, 124, 126, 130, 129, // 42912-42919
128, 128, 127, 129, 129, 127, 125, 124, // 42920-42927
123, 122, 124, 128, 128, 128, 126, 126, // 42928-42935
129, 128, 126, 126, 125, 124, 125, 125, // 42936-42943
126, 129, 130, 131, 129, 129, 130, 130, // 42944-42951
127, 125, 125, 125, 126, 125, 127, 130, // 42952-42959
130, 128, 128, 128, 129, 129, 126, 125, // 42960-42967
125, 124, 124, 126, 129, 129, 129, 126, // 42968-42975
127, 129, 127, 126, 126, 124, 124, 125, // 42976-42983
125, 127, 129, 130, 130, 127, 127, 129, // 42984-42991
129, 127, 126, 125, 126, 126, 126, 127, // 42992-42999
131, 131, 128, 127, 129, 130, 129, 126, // 43000-43007
125, 125, 124, 124, 127, 128, 129, 128, // 43008-43015
125, 127, 128, 128, 126, 125, 124, 125, // 43016-43023
126, 126, 127, 129, 128, 128, 127, 126, // 43024-43031
127, 129, 126, 125, 125, 126, 127, 127, // 43032-43039
129, 131, 130, 128, 129, 129, 131, 130, // 43040-43047
125, 125, 126, 125, 125, 127, 128, 129, // 43048-43055
127, 126, 127, 127, 126, 126, 124, 125, // 43056-43063
124, 126, 126, 127, 129, 129, 128, 127, // 43064-43071
126, 127, 128, 125, 124, 125, 126, 128, // 43072-43079
127, 130, 132, 130, 128, 128, 129, 129, // 43080-43087
128, 125, 125, 126, 125, 126, 128, 129, // 43088-43095
128, 126, 125, 125, 125, 126, 126, 125, // 43096-43103
125, 125, 127, 128, 129, 130, 129, 127, // 43104-43111
126, 125, 127, 127, 126, 124, 126, 127, // 43112-43119
130, 129, 130, 132, 130, 128, 128, 129, // 43120-43127
127, 127, 125, 128, 128, 159, 157, 136, // 43128-43135
 95,  92,  64,  32, 109, 156, 175,  96, // 43136-43143
163, 241, 191, 142,  50,  80, 121,  92, // 43144-43151
158,   5, 242, 157, 120, 134,  59, 252, // 43152-43159
237, 248,  17, 238,  66, 138, 165, 170, // 43160-43167
161, 209, 152,  99,  63, 111, 154,  51, // 43168-43175
 63, 134, 123,  99, 160, 247,   3, 170, // 43176-43183
106, 153, 203, 168, 179, 245, 232, 236, // 43184-43191
169, 217,  36, 109, 232, 170, 181, 161, // 43192-43199
182,  29,  79, 133,  76, 169, 242, 199, // 43200-43207
194, 116, 146, 162, 175, 243,  54,  63, // 43208-43215
213, 194, 175,  81,  30,   5,  20,   8, // 43216-43223
  2,  85, 129, 157, 147, 159, 191, 112, // 43224-43231
 84,  47,  91, 129,  51,  81, 122, 122, // 43232-43239
 73, 143, 231, 203, 166,  95, 147, 185, // 43240-43247
157, 205, 243, 233, 214, 178, 199, 247, // 43248-43255
129, 244, 194, 186, 158, 210,  42,  76, // 43256-43263
123,  84, 151, 192, 168, 185, 127, 144, // 43264-43271
146, 204,   2,  46,  68, 219, 212, 151, // 43272-43279
 65,  28,  12,  37,   0,  39, 110, 138, // 43280-43287
160, 144, 175, 170,  92,  76,  52,  85, // 43288-43295
112,  86, 113, 133, 136,  73, 145, 205, // 43296-43303
160, 160,  91, 131, 154, 157, 225, 244, // 43304-43311
243, 203, 204, 186, 200, 150,   4, 221, // 43312-43319
182, 166, 237,  51,  84, 117, 114, 142, // 43320-43327
158, 155, 177, 144, 126, 133, 221,   4, // 43328-43335
 31,  56, 237, 222, 131,  66,  33,  24, // 43336-43343
 35, 244,  65, 115, 130, 144, 141, 181, // 43344-43351
142,  87,  73,  69,  81,  96, 124, 130, // 43352-43359
137, 135,  75, 141, 177, 141, 159, 110, // 43360-43367
126, 138, 177, 240, 243, 238, 190, 217, // 43368-43375
161, 159, 162,  28, 246, 180, 192,  10, // 43376-43383
 55,  84, 100, 134, 113, 117, 136, 165, // 43384-43391
159, 109, 142, 238,  11,  21,  37,   6, // 43392-43399
212, 111,  59,  29,  32,  28,   1,  95, // 43400-43407
130, 136, 138, 153, 179, 116,  83,  64, // 43408-43415
 80,  68,  85, 160, 146, 147, 135,  97, // 43416-43423
137, 145, 125, 142, 122, 105, 118, 189, // 43424-43431
240, 245, 233, 197, 228, 144, 133, 164, // 43432-43439
 59,   0, 180, 217,  20,  56,  83,  96, // 43440-43447
157,  97,  97, 129, 161, 169,  95, 153, // 43448-43455
236,  11,   6,  20,  31, 199, 108,  64, // 43456-43463
 45,  48,  23,  23, 103, 133, 126, 121, // 43464-43471
157, 158, 100,  83,  68,  93,  61,  88, // 43472-43479
183, 160, 147, 129, 112, 114, 115, 117, // 43480-43487
133, 144,  95, 120, 208, 245, 248, 220, // 43488-43495
205, 215, 125, 109, 156,  91,   5, 201, // 43496-43503
252,  38,  68,  82, 100, 157,  76,  72, // 43504-43511
111, 153, 163,  92, 168, 236,  14, 250, // 43512-43519
 10,  43, 181, 106,  59,  50,  42,  14, // 43520-43527
 52, 107, 150, 127, 124, 170, 141,  94, // 43528-43535
 79,  71,  90,  55,  95, 188, 174, 147, // 43536-43543
134, 135,  98, 100, 116, 128, 151,  83, // 43544-43551
120, 207, 234, 239, 212, 220, 199, 123, // 43552-43559
 99, 152, 122,   9, 228,  15,  42,  61, // 43560-43567
 71, 104, 143,  73,  62, 106, 156, 158, // 43568-43575
107, 177, 230,   5, 237,   2,  33, 169, // 43576-43583
109,  67,  67,  44,  28,  83, 107, 152, // 43584-43591
119, 120, 157, 112,  87,  75,  83,  85, // 43592-43599
 64, 115, 190, 193, 145, 141, 141,  74, // 43600-43607
 81, 103, 123, 149,  88, 133, 209, 238, // 43608-43615
235, 214, 226, 173, 118,  87, 142, 133, // 43616-43623
 17,  10,  34,  57,  65,  78, 119, 122, // 43624-43631
 73,  49,  95, 142, 140, 125, 179, 227, // 43632-43639
251, 234,   1,  17, 171, 112,  73,  71, // 43640-43647
 35,  38,  95, 105, 153, 124, 131, 148, // 43648-43655
101,  91,  78,  94,  73,  75, 124, 180, // 43656-43663
197, 142, 152, 141,  62,  73, 104, 130, // 43664-43671
138, 102, 139, 197, 228, 218, 217, 222, // 43672-43679
154, 120,  86, 139, 141,  39,  42,  46, // 43680-43687
 61,  58,  79, 114,  96,  77,  45,  95, // 43688-43695
133, 137, 153, 177, 225, 236, 235, 250, // 43696-43703
241, 174, 115,  87,  73,  37,  61, 112, // 43704-43711
111, 144, 132, 132, 123,  90,  84,  81, // 43712-43719
 93,  65,  95, 133, 172, 202, 149, 163, // 43720-43727
133,  57,  64, 100, 125, 124, 123, 147, // 43728-43735
192, 220, 211, 228, 209, 145, 122,  91, // 43736-43743
130, 135,  67,  65,  56,  64,  56,  90, // 43744-43751
111,  80,  82,  49,  90, 115, 135, 168, // 43752-43759
169, 215, 217, 239, 238, 214, 183, 120, // 43760-43767
104,  71,  50,  81, 112, 114, 130, 147, // 43768-43775
133, 105,  89,  85,  93,  94,  72, 115, // 43776-43783
138, 161, 191, 158, 161, 119,  57,  56, // 43784-43791
103, 123, 116, 148, 151, 182, 207, 204, // 43792-43799
226, 187, 136, 119,  99, 122, 131, 102, // 43800-43807
 85,  71,  66,  60,  95,  93,  64,  78, // 43808-43815
 58,  85, 101, 145, 183, 171, 210, 212, // 43816-43823
247, 223, 188, 183, 125, 110,  65,  63, // 43824-43831
 95, 117, 118, 120, 163, 126,  88,  85, // 43832-43839
 80,  96,  81,  79, 125, 143, 158, 184, // 43840-43847
177, 159, 112,  62,  54, 102, 110, 112, // 43848-43855
163, 157, 175, 194, 209, 225, 174, 139, // 43856-43863
119, 111, 108, 124, 129,  95,  80,  63, // 43864-43871
 69,  97,  81,  63,  79,  74,  77,  93, // 43872-43879
152, 187, 171, 193, 208, 243, 205, 175, // 43880-43887
182, 139, 113,  66,  83, 105, 116, 115, // 43888-43895
112, 169, 118,  75,  82,  84, 100,  77, // 43896-43903
 97, 133, 148, 148, 173, 192, 147, 108, // 43904-43911
 67,  54, 100, 103, 122, 176, 166, 168, // 43912-43919
185, 212, 209, 159, 136, 119, 117,  97, // 43920-43927
128, 152, 108,  88,  63,  82,  90,  67, // 43928-43935
 60,  71,  85,  65,  89, 159, 189, 175, // 43936-43943
181, 213, 232, 191, 164, 175, 152, 111, // 43944-43951
 75,  99, 111, 119, 116, 117, 168, 114, // 43952-43959
 71,  79,  88,  95,  75, 112, 135, 152, // 43960-43967
144, 168, 199, 137, 106,  73,  60,  92, // 43968-43975
 97, 131, 174, 172, 157, 177, 211, 190, // 43976-43983
155, 136, 123, 119,  90, 133, 164, 121, // 43984-43991
 94,  69,  91,  81,  61,  61,  72,  93, // 43992-43999
 61,  95, 161, 189, 174, 168, 216, 213, // 44000-44007
182, 157, 169, 162, 108,  89, 111, 116, // 44008-44015
117, 116, 122, 154, 112,  68,  77,  92, // 44016-44023
 87,  83, 125, 137, 152, 140, 166, 196, // 44024-44031
130, 106,  77,  65,  82,  96, 141, 172, // 44032-44039
180, 151, 174, 205, 174, 152, 131, 128, // 44040-44047
116,  94, 140, 167, 134,  95,  78,  95, // 44048-44055
 69,  57,  63,  76,  94,  64, 103, 159, // 44056-44063
188, 172, 165, 214, 194, 174, 153, 165, // 44064-44071
168, 109, 106, 118, 123, 116, 116, 127, // 44072-44079
135, 113,  67,  75,  93,  83,  98, 130, // 44080-44087
139, 148, 141, 163, 180, 127, 104,  88, // 44088-44095
 72,  72, 106, 151, 169, 178, 148, 173, // 44096-44103
192, 161, 149, 133, 134, 111, 101, 145, // 44104-44111
171, 146,  98,  90,  90,  61,  57,  60, // 44112-44119
 75,  86,  75, 111, 153, 185, 172, 168, // 44120-44127
202, 176, 170, 152, 161, 164, 118, 125, // 44128-44135
124, 125, 113, 121, 130, 115, 115,  71, // 44136-44143
 78,  93,  82, 112, 134, 145, 144, 146, // 44144-44151
161, 166, 132, 102,  93,  72,  65, 112, // 44152-44159
148, 163, 175, 152, 169, 174, 153, 148, // 44160-44167
136, 134, 109, 118, 151, 172, 154, 106, // 44168-44175
102,  82,  57,  54,  62,  78,  77,  85, // 44176-44183
112, 147, 179, 167, 169, 187, 168, 165, // 44184-44191
153, 160, 160, 133, 136, 128, 128, 111, // 44192-44199
126, 125, 100, 116,  78,  80,  87,  88, // 44200-44207
126, 137, 147, 139, 153, 157, 150, 136, // 44208-44215
102, 101,  70,  63, 118, 146, 162, 165, // 44216-44223
154, 159, 157, 150, 143, 140, 133, 115, // 44224-44231
132, 152, 172, 158, 118, 109,  76,  58, // 44232-44239
 55,  66,  74,  70, 101, 114, 138, 166, // 44240-44247
166, 172, 170, 161, 159, 158, 155, 151, // 44248-44255
150, 145, 135, 127, 114, 131, 121,  95, // 44256-44263
115,  87,  78,  80,  95, 130, 135, 144, // 44264-44271
136, 157, 147, 136, 138, 107, 108,  70, // 44272-44279
 72, 122, 145, 158, 157, 166, 152, 142, // 44280-44287
146, 142, 144, 127, 121, 140, 153, 169, // 44288-44295
157, 133, 112,  73,  61,  56,  71,  73, // 44296-44303
 73, 112, 114, 132, 155, 168, 167, 153, // 44304-44311
156, 151, 160, 147, 147, 164, 150, 139, // 44312-44319
125, 120, 132, 112,  92, 111, 103,  77, // 44320-44327
 78, 108, 132, 139, 142, 139, 159, 137, // 44328-44335
128, 138, 114, 109,  71,  81, 123, 143, // 44336-44343
152, 153, 172, 140, 130, 139, 141, 145, // 44344-44351
122, 130, 144, 154, 165, 157, 147, 110, // 44352-44359
 73,  64,  61,  75,  69,  81, 120, 121, // 44360-44367
129, 147, 173, 161, 141, 153, 151, 162, // 44368-44375
140, 146, 174, 154, 141, 120, 126, 125, // 44376-44383
105,  90, 105, 113,  74,  78, 115, 132, // 44384-44391
140, 137, 142, 155, 133, 124, 136, 125, // 44392-44399
109,  82,  92, 121, 141, 147, 154, 172, // 44400-44407
132, 126, 137, 143, 142, 120, 143, 149, // 44408-44415
153, 157, 157, 153, 105,  73,  63,  68, // 44416-44423
 74,  67,  89, 119, 125, 122, 141, 173, // 44424-44431
151, 135, 148, 150, 161, 140, 152, 178, // 44432-44439
160, 142, 123, 132, 117, 100,  91, 104, // 44440-44447
120,  74,  85, 119, 132, 138, 133, 150, // 44448-44455
146, 127, 118, 133, 132, 105,  94,  98, // 44456-44463
122, 140, 142, 155, 164, 130, 119, 132, // 44464-44471
143, 137, 126, 149, 149, 153, 154, 159, // 44472-44479
153, 102,  77,  66,  73,  71,  71,  99, // 44480-44487
121, 131, 117, 140, 170, 142, 130, 143, // 44488-44495
155, 156, 140, 154, 177, 166, 140, 128, // 44496-44503
134, 112, 100,  92, 103, 121,  78,  90, // 44504-44511
118, 130, 135, 134, 151, 136, 127, 117, // 44512-44519
132, 135, 102, 106, 103, 120, 137, 143, // 44520-44527
160, 155, 131, 114, 130, 142, 129, 133, // 44528-44535
151, 152, 151, 152, 162, 150, 105,  79, // 44536-44543
 70,  77,  69,  79, 105, 118, 132, 116, // 44544-44551
137, 159, 137, 127, 139, 154, 146, 145, // 44552-44559
158, 176, 172, 142, 138, 132, 107, 101, // 44560-44567
 93, 100, 115,  88,  93, 118, 131, 131, // 44568-44575
138, 150, 129, 125, 115, 130, 134, 107, // 44576-44583
118, 111, 122, 135, 144, 159, 145, 132, // 44584-44591
111, 125, 135, 126, 139, 150, 153, 144, // 44592-44599
152, 163, 142, 110,  84,  79,  79,  68, // 44600-44607
 86, 109, 120, 131, 123, 139, 152, 137, // 44608-44615
125, 138, 153, 139, 150, 156, 168, 169, // 44616-44623
141, 142, 128, 107, 100,  98, 103, 110, // 44624-44631
101,  96, 115, 126, 127, 139, 141, 124, // 44632-44639
124, 120, 129, 131, 118, 128, 117, 120, // 44640-44647
130, 147, 154, 137, 134, 116, 128, 132, // 44648-44655
128, 144, 148, 153, 138, 150, 155, 133, // 44656-44663
113,  86,  85,  80,  76,  96, 113, 123, // 44664-44671
130, 129, 132, 138, 133, 121, 135, 148, // 44672-44679
140, 158, 159, 166, 168, 148, 144, 120, // 44680-44687
103,  97, 101, 101, 107, 116, 104, 117, // 44688-44695
124, 128, 143, 135, 121, 118, 121, 125, // 44696-44703
127, 128, 132, 125, 120, 131, 150, 148, // 44704-44711
133, 132, 117, 121, 122, 129, 144, 146, // 44712-44719
150, 137, 153, 150, 129, 116,  93,  91, // 44720-44727
 77,  80, 101, 113, 123, 126, 137, 131, // 44728-44735
133, 136, 124, 138, 142, 141, 158, 160, // 44736-44743
161, 162, 154, 142, 118, 106, 100, 107, // 44744-44751
 99, 105, 126, 105, 109, 115, 126, 138, // 44752-44759
127, 122, 119, 129, 122, 126, 138, 136, // 44760-44767
129, 114, 128, 146, 142, 132, 131, 128, // 44768-44775
121, 124, 137, 148, 149, 146, 135, 148, // 44776-44783
143, 126, 117, 100,  93,  80,  91, 107, // 44784-44791
117, 122, 123, 139, 119, 118, 128, 123, // 44792-44799
133, 136, 146, 161, 163, 158, 160, 163, // 44800-44807
140, 116, 104, 100, 108,  98, 108, 132, // 44808-44815
116, 112, 117, 132, 136, 123, 118, 115, // 44816-44823
127, 116, 125, 143, 139, 133, 114, 133, // 44824-44831
146, 138, 132, 129, 131, 111, 117, 136, // 44832-44839
145, 148, 142, 143, 146, 141, 126, 118, // 44840-44847
110,  92,  81,  94, 106, 116, 118, 125, // 44848-44855
143, 122, 119, 130, 130, 130, 134, 148, // 44856-44863
158, 164, 151, 155, 164, 137, 116, 104, // 44864-44871
106, 110,  99, 112, 132, 121, 104, 110, // 44872-44879
129, 128, 120, 119, 119, 129, 117, 128, // 44880-44887
147, 144, 131, 112, 129, 137, 132, 129, // 44888-44895
130, 138, 114, 123, 144, 151, 149, 140, // 44896-44903
145, 139, 135, 121, 116, 115,  91,  86, // 44904-44911
 99, 111, 118, 117, 128, 137, 117, 109, // 44912-44919
123, 129, 125, 136, 156, 164, 167, 153, // 44920-44927
158, 164, 136, 113, 102, 106, 104,  98, // 44928-44935
115, 135, 130, 106, 115, 131, 126, 119, // 44936-44943
115, 120, 123, 116, 128, 147, 148, 134, // 44944-44951
119, 131, 134, 130, 129, 130, 132, 111, // 44952-44959
121, 140, 147, 146, 143, 152, 138, 132, // 44960-44967
123, 118, 118,  92,  92, 101, 110, 113, // 44968-44975
115, 130, 132, 122, 110, 125, 134, 123, // 44976-44983
137, 154, 160, 160, 150, 156, 157, 136, // 44984-44991
117, 109, 110, 102, 103, 118, 132, 129, // 44992-44999
105, 114, 123, 118, 118, 121, 127, 124, // 45000-45007
124, 133, 144, 145, 131, 125, 126, 127, // 45008-45015
125, 127, 131, 132, 125, 128, 137, 140, // 45016-45023
137, 135, 137, 129, 126, 122, 121, 122, // 45024-45031
114, 115, 118, 122, 122, 123, 129, 125, // 45032-45039
122, 117, 121, 127, 124, 133, 140, 144, // 45040-45047
140, 136, 137, 134, 130, 121, 119, 121, // 45048-45055
119, 121, 126, 131, 130, 123, 123, 124, // 45056-45063
124, 122, 122, 125, 124, 126, 129, 132, // 45064-45071
136, 131, 130, 130, 131, 129, 129, 130, // 45072-45079
126, 124, 123, 125, 127, 126, 128, 128, // 45080-45087
128, 125, 124, 124, 124, 124, 124, 125, // 45088-45095
127, 128, 127, 131, 131, 130, 127, 126, // 45096-45103
127, 128, 129, 129, 130, 128, 126, 127, // 45104-45111
126, 128, 126, 125, 127, 127, 128, 128, // 45112-45119
128, 125, 123, 121, 122, 125, 124, 126, // 45120-45127
129, 128, 129, 128, 129, 130, 127, 127, // 45128-45135
128, 130, 129, 128, 131, 130, 129, 125, // 45136-45143
126, 126, 125, 124, 122, 125, 123, 121, // 45144-45151
123, 126, 128, 128, 128, 131, 132, 131, // 45152-45159
132, 131, 129, 127, 125, 126, 128, 128, // 45160-45167
128, 129, 127, 125, 125, 125, 125, 123, // 45168-45175
123, 126, 125, 126, 127, 130, 128, 126, // 45176-45183
126, 127, 128, 126, 126, 128, 129, 127, // 45184-45191
126, 129, 130, 130, 128, 130, 131, 130, // 45192-45199
129, 129, 129, 128, 125, 124, 125, 125, // 45200-45207
124, 124, 125, 124, 124, 124, 125, 126, // 45208-45215
126, 129, 129, 129, 129, 130, 131, 130, // 45216-45223
129, 129, 129, 129, 128, 128, 129, 128, // 45224-45231
123, 123, 124, 124, 125, 125, 127, 129, // 45232-45239
128, 129, 129, 128, 126, 125, 123, 125, // 45240-45247
126, 125, 128, 129, 130, 129, 129, 129, // 45248-45255
127, 127, 127, 128, 127, 127, 128, 130, // 45256-45263
130, 129, 128, 128, 125, 123, 122, 123, // 45264-45271
121, 121, 121, 124, 127, 127, 130, 130, // 45272-45279
130, 130, 129, 129, 127, 127, 127, 127, // 45280-45287
129, 131, 131, 131, 130, 127, 126, 125, // 45288-45295
123, 122, 124, 126, 127, 127, 128, 130, // 45296-45303
128, 126, 126, 124, 124, 123, 124, 126, // 45304-45311
128, 127, 126, 128, 128, 128, 128, 128, // 45312-45319
130, 130, 130, 131, 130, 130, 128, 128, // 45320-45327
126, 126, 126, 125, 125, 124, 124, 125, // 45328-45335
125, 125, 126, 127, 127, 126, 126, 126, // 45336-45343
128, 127, 128, 129, 129, 130, 129, 130, // 45344-45351
130, 127, 124, 122, 123, 122, 124, 127, // 45352-45359
129, 131, 131, 130, 129, 128, 126, 124, // 45360-45367
124, 123, 125, 128, 129, 131, 131, 129, // 45368-45375
129, 128, 126, 126, 125, 126, 126, 127, // 45376-45383
128, 130, 131, 130, 129, 126, 125, 125, // 45384-45391
124, 123, 123, 124, 124, 124, 125, 128, // 45392-45399
130, 128, 128, 128, 127, 126, 126, 127, // 45400-45407
128, 129, 129, 130, 132, 130, 129, 127, // 45408-45415
125, 124, 124, 125, 127, 127, 127, 129, // 45416-45423
128, 127, 127, 127, 125, 124, 123, 125, // 45424-45431
128, 127, 129, 130, 128, 127, 125, 126, // 45432-45439
126, 126, 126, 129, 130, 129, 129, 129, // 45440-45447
129, 127, 124, 124, 125, 125, 125, 127, // 45448-45455
128, 127, 127, 127, 129, 129, 127, 126, // 45456-45463
127, 127, 127, 127, 129, 128, 128, 127, // 45464-45471
129, 129, 129, 127, 126, 124, 123, 122, // 45472-45479
123, 126, 128, 129, 129, 128, 128, 127, // 45480-45487
126, 125, 124, 124, 126, 128, 129, 130, // 45488-45495
132, 129, 127, 125, 127, 128, 127, 126, // 45496-45503
128, 129, 128, 128, 130, 129, 127, 125, // 45504-45511
123, 124, 125, 125, 126, 126, 126, 126, // 45512-45519
126, 126, 127, 128, 128, 127, 126, 127, // 45520-45527
129, 129, 130, 129, 129, 129, 129, 129, // 45528-45535
128, 128, 125, 123, 125, 126, 128, 128, // 45536-45543
129, 127, 126, 126, 125, 125, 124, 123, // 45544-45551
124, 126, 128, 131, 133, 132, 129, 126, // 45552-45559
125, 125, 124, 125, 127, 128, 129, 129, // 45560-45567
130, 130, 128, 127, 124, 124, 125, 125, // 45568-45575
127, 127, 127, 127, 127, 127, 127, 128, // 45576-45583
127, 125, 124, 125, 127, 128, 129, 130, // 45584-45591
131, 130, 129, 129, 130, 129, 127, 123, // 45592-45599
123, 125, 124, 126, 127, 129, 127, 124, // 45600-45607
124, 124, 125, 124, 125, 125, 128, 131, // 45608-45615
132, 135, 133, 130, 127, 125, 125, 125, // 45616-45623
126, 128, 126, 127, 129, 131, 130, 127, // 45624-45631
127, 124, 124, 124, 125, 129, 128, 128, // 45632-45639
127, 127, 126, 125, 125, 125, 126, 124, // 45640-45647
124, 127, 128, 130, 131, 131, 131, 130, // 45648-45655
129, 129, 129, 127, 125, 124, 125, 124, // 45656-45663
127, 128, 129, 125, 123, 123, 124, 124, // 45664-45671
124, 125, 125, 127, 130, 132, 135, 133, // 45672-45679
130, 127, 125, 126, 126, 127, 127, 128, // 45680-45687
128, 129, 130, 129, 128, 126, 123, 124, // 45688-45695
124, 126, 127, 128, 127, 127, 127, 125, // 45696-45703
125, 126, 125, 126, 124, 126, 129, 129, // 45704-45711
130, 131, 132, 130, 128, 128, 128, 129, // 45712-45719
128, 126, 126, 125, 126, 128, 128, 127, // 45720-45727
125, 123, 122, 123, 124, 126, 127, 126, // 45728-45735
129, 131, 131, 132, 131, 128, 125, 123, // 45736-45743
124, 126, 128, 129, 129, 130, 130, 131, // 45744-45751
128, 127, 125, 122, 122, 123, 125, 127, // 45752-45759
129, 128, 128, 128, 126, 127, 125, 124, // 45760-45767
124, 124, 125, 127, 128, 130, 132, 132, // 45768-45775
131, 131, 129, 128, 128, 126, 125, 124, // 45776-45783
124, 125, 127, 127, 127, 127, 125, 124, // 45784-45791
125, 126, 126, 127, 126, 128, 130, 131, // 45792-45799
131, 132, 129, 127, 127, 126, 128, 127, // 45800-45807
127, 127, 126, 126, 127, 127, 126, 125, // 45808-45815
124, 124, 126, 128, 129, 130, 128, 127, // 45816-45823
127, 125, 125, 125, 125, 126, 127, 129, // 45824-45831
130, 131, 131, 131, 130, 128, 128, 126, // 45832-45839
126, 126, 126, 127, 126, 126, 127, 127, // 45840-45847
127, 126, 124, 121, 122, 122, 124, 127, // 45848-45855
128, 129, 130, 131, 132, 131, 131, 129, // 45856-45863
126, 124, 124, 127, 127, 128, 129, 129, // 45864-45871
130, 129, 128, 126, 125, 124, 121, 124, // 45872-45879
125, 127, 128, 128, 128, 127, 127, 126, // 45880-45887
125, 125, 124, 125, 126, 128, 129, 130, // 45888-45895
132, 130, 130, 130, 128, 127, 127, 128, // 45896-45903
127, 126, 126, 126, 126, 125, 124, 125, // 45904-45911
123, 124, 124, 125, 126, 127, 127, 128, // 45912-45919
130, 130, 130, 130, 129, 128, 127, 126, // 45920-45927
128, 128, 128, 128, 128, 128, 127, 126, // 45928-45935
125, 125, 124, 125, 127, 127, 129, 130, // 45936-45943
129, 128, 126, 126, 125, 124, 123, 124, // 45944-45951
126, 127, 130, 130, 131, 131, 130, 128, // 45952-45959
127, 126, 125, 127, 127, 128, 128, 127, // 45960-45967
129, 128, 126, 125, 124, 123, 123, 123, // 45968-45975
125, 127, 129, 129, 129, 130, 129, 129, // 45976-45983
128, 128, 127, 126, 126, 127, 128, 127, // 45984-45991
128, 127, 127, 127, 126, 127, 126, 125, // 45992-45999
125, 126, 127, 128, 128, 128, 127, 127, // 46000-46007
126, 126, 125, 124, 125, 126, 127, 129, // 46008-46015
129, 130, 130, 129, 128, 128, 127, 126, // 46016-46023
127, 127, 129, 128, 127, 127, 126, 125, // 46024-46031
124, 125, 124, 124, 124, 125, 128, 130, // 46032-46039
128, 128, 128, 128, 129, 127, 127, 127, // 46040-46047
127, 127, 128, 129, 129, 128, 126, 127, // 46048-46055
128, 126, 127, 127, 127, 126, 126, 127, // 46056-46063
128, 129, 127, 127, 127, 125, 125, 125, // 46064-46071
125, 126, 127, 128, 129, 129, 128, 129, // 46072-46079
129, 126, 128, 127, 127, 128, 127, 129, // 46080-46087
129, 127, 126, 126, 125, 124, 123, 124, // 46088-46095
125, 126, 126, 129, 131, 130, 129, 127, // 46096-46103
128, 126, 126, 126, 126, 126, 125, 127, // 46104-46111
129, 129, 129, 127, 129, 127, 126, 125, // 46112-46119
127, 128, 126, 126, 128, 129, 129, 126, // 46120-46127
126, 126, 125, 124, 124, 125, 125, 126, // 46128-46135
128, 130, 131, 130, 131, 130, 128, 128, // 46136-46143
126, 127, 126, 126, 128, 128, 127, 126, // 46144-46151
126, 127, 124, 124, 125, 126, 126, 124, // 46152-46159
126, 129, 129, 128, 127, 128, 128, 127, // 46160-46167
126, 128, 128, 126, 127, 128, 130, 128, // 46168-46175
127, 127, 127, 127, 127, 128, 128, 127, // 46176-46183
128, 127, 127, 126, 125, 126, 125, 124, // 46184-46191
124, 126, 127, 127, 128, 129, 130, 129, // 46192-46199
126, 128, 128, 127, 126, 126, 128, 128, // 46200-46207
128, 130, 130, 129, 126, 125, 125, 123, // 46208-46215
123, 123, 125, 125, 126, 128, 130, 130, // 46216-46223
128, 127, 127, 126, 125, 125, 127, 127, // 46224-46231
127, 128, 131, 132, 130, 128, 128, 127, // 46232-46239
125, 124, 126, 127, 126, 127, 127, 129, // 46240-46247
128, 127, 126, 125, 123, 123, 124, 125, // 46248-46255
125, 126, 127, 129, 129, 129, 130, 130, // 46256-46263
129, 128, 128, 129, 128, 127, 128, 129, // 46264-46271
127, 125, 126, 127, 127, 125, 125, 127, // 46272-46279
126, 125, 126, 129, 128, 126, 125, 125, // 46280-46287
126, 125, 126, 128, 128, 127, 128, 128, // 46288-46295
128, 128, 127, 127, 127, 126, 128, 130, // 46296-46303
131, 130, 130, 128, 128, 126, 125, 124, // 46304-46311
122, 121, 122, 126, 127, 128, 128, 129, // 46312-46319
129, 128, 127, 128, 127, 124, 125, 127, // 46320-46327
129, 128, 129, 130, 131, 129, 127, 127, // 46328-46335
126, 125, 124, 124, 126, 126, 126, 127, // 46336-46343
130, 130, 130, 129, 126, 126, 125, 124, // 46344-46351
125, 125, 125, 126, 128, 129, 130, 130, // 46352-46359
129, 128, 126, 127, 128, 128, 126, 126, // 46360-46367
126, 126, 127, 127, 127, 126, 124, 125, // 46368-46375
126, 126, 126, 126, 127, 128, 127, 128, // 46376-46383
129, 130, 129, 130, 129, 129, 129, 128, // 46384-46391
127, 126, 125, 125, 125, 126, 125, 127, // 46392-46399
128, 128, 127, 128, 127, 128, 127, 125, // 46400-46407
126, 124, 125, 125, 127, 128, 129, 129, // 46408-46415
129, 129, 128, 129, 128, 126, 125, 125, // 46416-46423
128, 128, 129, 130, 131, 129, 126, 126, // 46424-46431
126, 125, 121, 120, 122, 124, 127, 128, // 46432-46439
130, 131, 130, 128, 128, 129, 126, 124, // 46440-46447
125, 127, 128, 129, 129, 131, 130, 129, // 46448-46455
127, 127, 126, 124, 125, 124, 126, 125, // 46456-46463
127, 128, 129, 129, 129, 128, 126, 124, // 46464-46471
124, 126, 125, 125, 125, 127, 129, 128, // 46472-46479
130, 131, 129, 128, 127, 128, 129, 128, // 46480-46487
127, 127, 126, 126, 126, 126, 126, 124, // 46488-46495
124, 125, 126, 127, 128, 128, 127, 127, // 46496-46503
126, 128, 128, 127, 128, 129, 129, 129, // 46504-46511
129, 129, 128, 125, 125, 125, 126, 124, // 46512-46519
124, 126, 127, 128, 128, 128, 129, 127, // 46520-46527
127, 127, 126, 124, 124, 125, 126, 127, // 46528-46535
128, 129, 130, 128, 129, 129, 129, 127, // 46536-46543
126, 126, 128, 128, 129, 130, 131, 128, // 46544-46551
127, 127, 125, 124, 122, 121, 123, 124, // 46552-46559
126, 127, 129, 129, 129, 130, 129, 129, // 46560-46567
127, 126, 127, 126, 128, 129, 129, 128, // 46568-46575
128, 128, 128, 127, 125, 125, 126, 125, // 46576-46583
127, 127, 128, 128, 126, 128, 128, 128, // 46584-46591
127, 126, 125, 125, 125, 126, 125, 127, // 46592-46599
127, 128, 128, 129, 129, 129, 129, 129, // 46600-46607
129, 129, 129, 129, 127, 127, 127, 125, // 46608-46615
125, 124, 124, 124, 125, 126, 127, 128, // 46616-46623
126, 126, 128, 128, 128, 128, 129, 129, // 46624-46631
129, 129, 130, 129, 128, 126, 125, 126, // 46632-46639
125, 125, 126, 126, 126, 127, 128, 128, // 46640-46647
128, 128, 127, 126, 126, 126, 126, 125, // 46648-46655
125, 126, 128, 128, 127, 128, 128, 128, // 46656-46663
127, 127, 127, 128, 126, 127, 129, 130, // 46664-46671
130, 129, 129, 128, 126, 124, 123, 123, // 46672-46679
123, 124, 126, 127, 127, 128, 128, 128, // 46680-46687
128, 127, 127, 126, 126, 128, 128, 129, // 46688-46695
130, 130, 129, 128, 127, 127, 127, 125, // 46696-46703
124, 124, 125, 127, 127, 126, 127, 127, // 46704-46711
127, 128, 128, 128, 127, 125, 126, 126, // 46712-46719
128, 127, 128, 128, 127, 127, 127, 127, // 46720-46727
126, 127, 127, 128, 128, 128, 129, 128, // 46728-46735
128, 127, 127, 126, 125, 124, 125, 126, // 46736-46743
126, 126, 127, 128, 127, 127, 128, 128, // 46744-46751
128, 128, 129, 129, 130, 131, 129, 127, // 46752-46759
126, 126, 127, 125, 125, 125, 125, 126, // 46760-46767
125, 126, 126, 126, 126, 126, 127, 127, // 46768-46775
128, 128, 127, 128, 128, 129, 128, 128, // 46776-46783
128, 127, 127, 127, 127, 127, 126, 126, // 46784-46791
127, 129, 129, 128, 128, 128, 126, 125, // 46792-46799
124, 124, 124, 124, 125, 126, 127, 128, // 46800-46807
128, 128, 127, 127, 127, 127, 126, 128, // 46808-46815
129, 130, 130, 129, 130, 129, 128, 127, // 46816-46823
126, 126, 124, 124, 125, 126, 127, 127, // 46824-46831
126, 126, 127, 127, 127, 127, 126, 126, // 46832-46839
126, 127, 127, 127, 129, 130, 129, 129, // 46840-46847
129, 129, 127, 126, 126, 126, 127, 128, // 46848-46855
128, 128, 129, 129, 128, 127, 126, 124, // 46856-46863
124, 124, 124, 125, 126, 128, 127, 127, // 46864-46871
128, 127, 127, 128, 128, 129, 129, 130, // 46872-46879
129, 131, 131, 160, 157, 136,  94,  89, // 46880-46887
 65,  32, 109, 156, 175,  99, 161, 244, // 46888-46895
193, 144,  50,  75, 118,  90, 156,   6, // 46896-46903
246, 161, 121, 137,  64, 254, 237, 244, // 46904-46911
 14, 233,  58, 133, 164, 173, 162, 212, // 46912-46919
155, 102,  64, 108, 153,  50,  58, 130, // 46920-46927
122,  99, 160, 250,   6, 173, 106, 153, // 46928-46935
204, 172, 180, 246, 233, 237, 174, 216, // 46936-46943
 40, 115, 233, 171, 180, 161, 178,  25, // 46944-46951
 72, 129,  73, 160, 237, 197, 194, 117, // 46952-46959
145, 162, 174, 243,  54,  65, 216, 194, // 46960-46967
176,  82,  32,   9,  23,  12,   2,  86, // 46968-46975
132, 159, 152, 160, 192, 112,  82,  49, // 46976-46983
 87, 129,  52,  78, 120, 122,  73, 139, // 46984-46991
228, 198, 162,  91, 139, 182, 156, 205, // 46992-46999
247, 238, 219, 185, 201, 248, 133, 245, // 47000-47007
192, 184, 157, 207,  43,  77, 126,  86, // 47008-47015
150, 193, 167, 186, 126, 140, 142, 200, // 47016-47023
  3,  46,  71, 224, 214, 155,  67,  30, // 47024-47031
 12,  36, 252,  34, 108, 135, 159, 146, // 47032-47039
177, 173,  94,  76,  52,  82, 110,  84, // 47040-47047
109, 129, 135,  72, 141, 207, 160, 161, // 47048-47055
 93, 129, 156, 158, 229, 247, 244, 206, // 47056-47063
209, 190, 200, 152,   7, 221, 182, 165, // 47064-47071
237,  50,  81, 114, 111, 137, 153, 150, // 47072-47079
174, 143, 125, 132, 220,   5,  31,  58, // 47080-47087
240, 221, 132,  63,  31,  24,  38, 246, // 47088-47095
 67, 119, 132, 147, 144, 184, 143,  86, // 47096-47103
 71,  70,  82,  95, 125, 131, 138, 138, // 47104-47111
 77, 139, 177, 136, 153, 105, 120, 134, // 47112-47119
174, 241, 247, 244, 196, 220, 165, 157, // 47120-47127
162,  29, 243, 178, 187,   7,  56,  87, // 47128-47135
102, 138, 116, 116, 135, 162, 159, 108, // 47136-47143
137, 234,  12,  23,  41,  10, 217, 115, // 47144-47151
 61,  31,  33,  29, 254,  89, 128, 134, // 47152-47159
137, 152, 179, 119,  84,  64,  78,  66, // 47160-47167
 82, 158, 146, 145, 136,  97, 134, 145, // 47168-47175
124, 142, 123, 106, 117, 189, 244, 249, // 47176-47183
237, 200, 229, 148, 131, 164,  60,   2, // 47184-47191
182, 216,  22,  58,  84,  94, 154,  96, // 47192-47199
 92, 124, 156, 166,  95, 151, 236,  11, // 47200-47207
  8,  22,  33, 201, 108,  62,  41,  44, // 47208-47215
 22,  23, 103, 138, 130, 125, 161, 160, // 47216-47223
101,  82,  65,  89,  60,  86, 182, 161, // 47224-47231
149, 133, 115, 115, 115, 115, 130, 142, // 47232-47239
 93, 117, 205, 243, 249, 225, 210, 219, // 47240-47247
129, 109, 156,  92,   7, 199, 247,  35, // 47248-47255
 64,  81,  98, 156,  78,  71, 110, 152, // 47256-47263
164,  92, 167, 234,  13, 253,  10,  44, // 47264-47271
184, 107,  61,  50,  44,  16,  53, 107, // 47272-47279
149, 128, 124, 167, 139,  92,  79,  70, // 47280-47287
 90,  56,  95, 189, 176, 149, 134, 135, // 47288-47295
 96,  95, 110, 123, 150,  84, 119, 210, // 47296-47303
240, 246, 217, 223, 201, 124,  97, 149, // 47304-47311
121,   9, 229,  15,  43,  64,  75, 105, // 47312-47319
143,  72,  58, 101, 148, 154, 105, 176, // 47320-47327
230,   8, 242,   5,  38, 172, 111,  65, // 47328-47335
 63,  42,  24,  81, 107, 154, 124, 123, // 47336-47343
160, 116,  89,  75,  83,  84,  63, 112, // 47344-47351
188, 191, 146, 141, 142,  74,  79, 103, // 47352-47359
120, 149,  88, 131, 208, 237, 237, 217, // 47360-47367
229, 177, 122,  88, 141, 136,  19,   9, // 47368-47375
 33,  55,  64,  74, 113, 118,  70,  45, // 47376-47383
 91, 139, 142, 127, 180, 230, 255, 237, // 47384-47391
  1,  17, 171, 112,  72,  70,  37,  41, // 47392-47399
100, 108, 155, 127, 129, 145,  99,  87, // 47400-47407
 74,  89,  73,  75, 124, 181, 203, 146, // 47408-47415
152, 142,  61,  69,  98, 121, 136, 102, // 47416-47423
139, 199, 234, 227, 222, 226, 158, 123, // 47424-47431
 85, 133, 141,  40,  42,  45,  61,  60, // 47432-47439
 81, 114,  94,  75,  41,  86, 128, 134, // 47440-47447
150, 176, 225, 238, 238, 252, 244, 178, // 47448-47455
114,  86,  74,  41,  64, 112, 113, 149, // 47456-47463
136, 132, 125,  91,  83,  77,  92,  66, // 47464-47471
 94, 132, 171, 203, 150, 160, 131,  53, // 47472-47479
 59,  95, 122, 124, 126, 148, 193, 228, // 47480-47487
216, 228, 211, 145, 122,  89, 128, 137, // 47488-47495
 71,  68,  59,  69,  60,  88, 107,  73, // 47496-47503
 77,  42,  81, 111, 134, 170, 173, 221, // 47504-47511
223, 242, 239, 213, 182, 117,  99,  69, // 47512-47519
 49,  84, 119, 120, 136, 151, 132, 104, // 47520-47527
 87,  81,  86,  89,  68, 112, 139, 165, // 47528-47535
195, 160, 161, 119,  55,  53,  96, 118, // 47536-47543
114, 148, 152, 184, 213, 210, 231, 192, // 47544-47551
141, 121,  98, 118, 131, 103,  86,  71, // 47552-47559
 67,  61,  94,  93,  62,  77,  53,  77, // 47560-47567
 97, 143, 185, 172, 211, 213, 246, 223, // 47568-47575
190, 184, 125, 110,  66,  66, 101, 121, // 47576-47583
122, 121, 162, 125,  85,  84,  78,  93, // 47584-47591
 82,  80, 125, 145, 159, 184, 175, 156, // 47592-47599
110,  59,  48,  96, 111, 114, 167, 160, // 47600-47607
179, 201, 213, 226, 174, 140, 118, 106, // 47608-47615
105, 126, 132, 100,  83,  66,  70,  95, // 47616-47623
 79,  58,  72,  67,  68,  87, 152, 190, // 47624-47631
176, 198, 211, 244, 208, 174, 181, 137, // 47632-47639
113,  66,  82, 108, 122, 123, 116, 170, // 47640-47647
119,  75,  81,  80,  96,  74,  94, 131, // 47648-47655
148, 152, 172, 190, 146, 106,  65,  50, // 47656-47663
 95, 102, 120, 174, 167, 169, 187, 215, // 47664-47671
212, 163, 140, 118, 116,  96, 126, 153, // 47672-47679
111,  91,  64,  79,  89,  66,  57,  68, // 47680-47687
 82,  61,  86, 158, 192, 178, 182, 212, // 47688-47695
232, 193, 164, 175, 153, 113,  77, 101, // 47696-47703
115, 125, 122, 116, 167, 113,  68,  76, // 47704-47711
 84,  94,  76, 112, 134, 152, 146, 166, // 47712-47719
196, 134, 103,  68,  52,  88,  96, 131, // 47720-47727
176, 177, 162, 179, 215, 195, 157, 136, // 47728-47735
122, 118,  90, 132, 165, 126,  97,  69, // 47736-47743
 90,  79,  59,  57,  65,  89,  56,  89, // 47744-47751
158, 191, 179, 172, 216, 214, 183, 156, // 47752-47759
167, 163, 111,  91, 112, 121, 125, 121, // 47760-47767
123, 156, 114,  66,  74,  91,  88,  83, // 47768-47775
122, 136, 151, 141, 163, 194, 129, 105, // 47776-47783
 75,  61,  80,  98, 142, 172, 182, 154, // 47784-47791
176, 209, 178, 154, 134, 128, 115,  91, // 47792-47799
139, 170, 140, 100,  80,  94,  70,  56, // 47800-47807
 57,  68,  90,  58,  94, 153, 189, 177, // 47808-47815
167, 213, 194, 175, 152, 162, 168, 113, // 47816-47823
109, 119, 125, 123, 122, 129, 136, 114, // 47824-47831
 65,  71,  91,  80,  94, 128, 138, 149, // 47832-47839
142, 165, 184, 131, 104,  82,  67,  69, // 47840-47847
102, 148, 169, 184, 153, 174, 195, 163, // 47848-47855
149, 130, 131, 108, 100, 144, 173, 153, // 47856-47863
106,  96,  95,  62,  54,  57,  71,  83, // 47864-47871
 66, 101, 148, 185, 173, 168, 205, 181, // 47872-47879
171, 151, 161, 167, 120, 124, 123, 128, // 47880-47887
119, 126, 131, 116, 116,  67,  71,  87, // 47888-47895
 78, 108, 131, 143, 144, 149, 164, 166, // 47896-47903
132, 104,  95,  72,  64, 110, 151, 166, // 47904-47911
178, 154, 169, 175, 152, 143, 133, 134, // 47912-47919
108, 115, 150, 173, 159, 114, 106,  85, // 47920-47927
 56,  52,  59,  72,  76,  84, 107, 142, // 47928-47935
178, 171, 171, 188, 166, 163, 154, 158, // 47936-47943
161, 137, 141, 132, 132, 119, 131, 128, // 47944-47951
100, 115,  74,  71,  80,  83, 121, 133, // 47952-47959
146, 140, 156, 158, 148, 136, 103, 100, // 47960-47967
 68,  62, 118, 149, 163, 170, 162, 162, // 47968-47975
156, 147, 141, 139, 132, 112, 128, 152, // 47976-47983
174, 163, 125, 114,  79,  58,  52,  63, // 47984-47991
 72,  71,  97, 107, 134, 167, 170, 171, // 47992-47999
169, 159, 156, 155, 152, 154, 154, 148, // 48000-48007
138, 133, 122, 135, 122,  93, 113,  86, // 48008-48015
 72,  76,  93, 126, 134, 145, 137, 158, // 48016-48023
147, 134, 137, 108, 107,  71,  71, 122, // 48024-48031
147, 161, 163, 170, 151, 140, 143, 137, // 48032-48039
140, 126, 118, 137, 152, 172, 166, 142, // 48040-48047
117,  76,  60,  53,  67,  69,  73, 110, // 48048-48055
112, 131, 157, 173, 167, 151, 153, 147, // 48056-48063
155, 143, 147, 167, 154, 144, 131, 128, // 48064-48071
137, 116,  91, 108,  98,  69,  73, 103, // 48072-48079
130, 138, 142, 140, 159, 140, 125, 136, // 48080-48087
113, 107,  74,  79, 122, 147, 158, 160, // 48088-48095
177, 144, 130, 138, 136, 141, 122, 128, // 48096-48103
142, 152, 167, 163, 153, 115,  75,  62, // 48104-48111
 57,  71,  67,  80, 118, 119, 127, 148, // 48112-48119
176, 161, 140, 149, 144, 156, 139, 147, // 48120-48127
176, 160, 146, 129, 133, 130, 109,  90, // 48128-48135
103, 110,  70,  76, 112, 132, 141, 139, // 48136-48143
144, 153, 131, 118, 131, 122, 107,  83, // 48144-48151
 90, 123, 146, 153, 159, 174, 136, 120, // 48152-48159
131, 136, 138, 121, 138, 145, 152, 162, // 48160-48167
163, 159, 111,  76,  61,  61,  70,  68, // 48168-48175
 91, 122, 126, 123, 144, 177, 153, 131, // 48176-48183
142, 143, 152, 135, 149, 180, 168, 148, // 48184-48191
130, 138, 123, 104,  89,  97, 116,  71, // 48192-48199
 80, 117, 134, 140, 138, 151, 147, 128, // 48200-48207
114, 128, 128, 104,  94,  98, 122, 144, // 48208-48215
150, 162, 170, 133, 114, 126, 136, 131, // 48216-48223
124, 145, 148, 152, 157, 165, 160, 110, // 48224-48231
 79,  64,  68,  69,  70,  99, 122, 132, // 48232-48239
121, 141, 172, 147, 127, 138, 146, 147, // 48240-48247
136, 153, 180, 172, 148, 134, 139, 116, // 48248-48255
100,  89,  96, 115,  76,  86, 120, 134, // 48256-48263
138, 138, 154, 136, 123, 110, 125, 133, // 48264-48271
105, 110, 109, 124, 140, 147, 162, 155, // 48272-48279
129, 107, 121, 134, 126, 131, 151, 152, // 48280-48287
149, 154, 166, 155, 110,  80,  69,  73, // 48288-48295
 66,  78, 107, 123, 135, 121, 141, 165, // 48296-48303
140, 123, 134, 148, 142, 142, 159, 180, // 48304-48311
178, 149, 142, 137, 108,  94,  87,  93, // 48312-48319
109,  85,  91, 119, 134, 135, 140, 153, // 48320-48327
128, 121, 111, 123, 132, 111, 123, 116, // 48328-48335
126, 136, 147, 161, 145, 130, 107, 121, // 48336-48343
131, 125, 141, 154, 156, 145, 152, 163, // 48344-48351
144, 111,  84,  76,  75,  67,  87, 112, // 48352-48359
123, 131, 123, 138, 151, 137, 123, 133, // 48360-48367
148, 136, 148, 161, 173, 174, 149, 144, // 48368-48375
129, 104,  93,  91,  95, 106, 102, 100, // 48376-48383
119, 132, 133, 143, 144, 122, 118, 112, // 48384-48391
121, 130, 122, 135, 123, 124, 133, 148, // 48392-48399
155, 136, 131, 110, 118, 126, 128, 149, // 48400-48407
152, 154, 138, 149, 157, 134, 112,  86, // 48408-48415
 81,  74,  72,  97, 116, 126, 130, 131, // 48416-48423
136, 140, 136, 122, 132, 145, 135, 154, // 48424-48431
162, 170, 173, 155, 147, 123, 104,  95, // 48432-48439
 95,  95, 100, 114, 103, 115, 127, 132, // 48440-48447
145, 136, 121, 116, 116, 119, 124, 131, // 48448-48455
139, 127, 121, 132, 151, 149, 132, 132, // 48456-48463
115, 117, 121, 132, 151, 150, 151, 135, // 48464-48471
149, 151, 129, 117,  94,  88,  74,  80, // 48472-48479
104, 116, 125, 125, 135, 129, 129, 136, // 48480-48487
124, 133, 140, 138, 157, 162, 166, 168, // 48488-48495
160, 147, 118, 105,  96,  99,  94,  99, // 48496-48503
124, 109, 114, 124, 133, 143, 127, 119, // 48504-48511
113, 119, 116, 122, 141, 143, 134, 120, // 48512-48519
133, 150, 141, 129, 128, 120, 113, 116, // 48520-48527
136, 154, 152, 151, 137, 149, 146, 126, // 48528-48535
119, 101,  92,  74,  86, 106, 117, 124, // 48536-48543
124, 139, 123, 122, 133, 125, 131, 133, // 48544-48551
141, 158, 163, 163, 166, 167, 145, 117, // 48552-48559
107,  99, 102,  91, 100, 129, 114, 112, // 48560-48567
120, 135, 139, 122, 120, 113, 123, 114, // 48568-48575
122, 147, 145, 138, 116, 131, 144, 132, // 48576-48583
127, 126, 127, 111, 116, 141, 153, 153, // 48584-48591
146, 141, 143, 138, 125, 120, 111,  94, // 48592-48599
 80,  97, 111, 118, 122, 123, 139, 118, // 48600-48607
114, 129, 126, 128, 130, 147, 157, 164, // 48608-48615
158, 161, 169, 140, 116, 105, 100, 102, // 48616-48623
 91, 107, 133, 122, 112, 119, 137, 133, // 48624-48631
119, 117, 113, 121, 111, 125, 151, 149, // 48632-48639
142, 119, 135, 140, 129, 127, 124, 130, // 48640-48647
106, 116, 141, 150, 151, 142, 145, 137, // 48648-48655
133, 125, 119, 117,  94,  87, 100, 111, // 48656-48663
119, 121, 128, 138, 118, 113, 127, 132, // 48664-48671
125, 129, 150, 154, 161, 153, 158, 166, // 48672-48679
137, 118, 105, 106, 103,  95, 111, 131, // 48680-48687
127, 108, 117, 133, 126, 119, 118, 118, // 48688-48695
122, 115, 129, 151, 152, 140, 122, 132, // 48696-48703
131, 125, 126, 126, 133, 110, 122, 143, // 48704-48711
151, 150, 139, 145, 129, 126, 121, 117, // 48712-48719
121,  96,  96, 105, 115, 120, 120, 130, // 48720-48727
131, 118, 109, 124, 134, 121, 133, 153, // 48728-48735
155, 160, 152, 159, 162, 135, 118, 107, // 48736-48743
109, 100,  98, 114, 130, 132, 110, 119, // 48744-48751
130, 122, 118, 118, 122, 118, 118, 130, // 48752-48759
144, 149, 140, 131, 132, 130, 128, 128, // 48760-48767
129, 129, 117, 122, 132, 138, 137, 133, // 48768-48775
136, 124, 124, 125, 124, 125, 114, 115, // 48776-48783
118, 122, 123, 125, 131, 128, 125, 120, // 48784-48791
128, 133, 125, 128, 133, 134, 133, 132, // 48792-48799
136, 136, 131, 125, 122, 123, 119, 120, // 48800-48807
122, 126, 127, 121, 124, 127, 125, 124, // 48808-48815
125, 126, 123, 125, 130, 134, 137, 134, // 48816-48823
132, 131, 129, 128, 128, 129, 128, 124, // 48824-48831
123, 127, 129, 126, 126, 125, 120, 119, // 48832-48839
121, 124, 126, 125, 124, 126, 129, 131, // 48840-48847
132, 134, 132, 130, 126, 129, 132, 129, // 48848-48855
126, 126, 126, 125, 126, 129, 130, 128, // 48856-48863
125, 125, 125, 125, 124, 124, 125, 126, // 48864-48871
125, 128, 129, 129, 127, 127, 125, 122, // 48872-48879
122, 125, 127, 130, 132, 132, 132, 132, // 48880-48887
132, 132, 132, 128, 124, 121, 124, 125, // 48888-48895
124, 124, 123, 121, 121, 123, 126, 128, // 48896-48903
127, 126, 126, 129, 130, 133, 133, 134, // 48904-48911
132, 130, 131, 132, 129, 126, 124, 121, // 48912-48919
121, 122, 124, 126, 126, 127, 126, 126, // 48920-48927
127, 127, 126, 126, 127, 127, 128, 129, // 48928-48935
130, 128, 128, 125, 123, 124, 125, 128, // 48936-48943
130, 131, 132, 131, 130, 131, 131, 130, // 48944-48951
128, 125, 123, 124, 125, 125, 124, 122, // 48952-48959
120, 121, 122, 125, 127, 128, 126, 126, // 48960-48967
127, 132, 135, 135, 135, 134, 131, 131, // 48968-48975
130, 130, 126, 122, 119, 121, 122, 124, // 48976-48983
127, 127, 127, 125, 125, 125, 126, 125, // 48984-48991
125, 128, 128, 128, 129, 130, 131, 128, // 48992-48999
125, 123, 123, 123, 125, 128, 131, 132, // 49000-49007
131, 131, 133, 133, 130, 129, 126, 124, // 49008-49015
122, 124, 124, 124, 123, 121, 122, 122, // 49016-49023
124, 127, 126, 126, 125, 127, 131, 134, // 49024-49031
133, 133, 135, 133, 131, 131, 130, 128, // 49032-49039
124, 121, 121, 123, 124, 126, 126, 127, // 49040-49047
125, 124, 124, 126, 126, 125, 127, 128, // 49048-49055
128, 128, 129, 129, 127, 125, 124, 125, // 49056-49063
126, 127, 130, 131, 132, 131, 129, 132, // 49064-49071
131, 128, 127, 127, 124, 122, 126, 127, // 49072-49079
126, 122, 120, 122, 121, 122, 125, 126, // 49080-49087
127, 126, 127, 131, 135, 133, 132, 133, // 49088-49095
130, 129, 128, 129, 127, 124, 122, 123, // 49096-49103
126, 126, 126, 128, 127, 125, 123, 124, // 49104-49111
126, 126, 125, 127, 128, 128, 129, 131, // 49112-49119
130, 128, 125, 124, 125, 125, 127, 131, // 49120-49127
132, 131, 130, 131, 131, 131, 128, 127, // 49128-49135
126, 124, 124, 125, 126, 125, 123, 121, // 49136-49143
123, 123, 124, 125, 127, 127, 127, 129, // 49144-49151
131, 132, 132, 131, 132, 130, 130, 129, // 49152-49159
129, 128, 126, 124, 122, 124, 124, 125, // 49160-49167
125, 125, 125, 125, 125, 125, 126, 127, // 49168-49175
127, 127, 128, 129, 129, 128, 127, 126, // 49176-49183
124, 126, 127, 129, 131, 131, 131, 130, // 49184-49191
131, 129, 129, 127, 125, 124, 124, 125, // 49192-49199
124, 125, 125, 124, 121, 121, 123, 124, // 49200-49207
125, 126, 128, 128, 130, 130, 132, 134, // 49208-49215
132, 132, 130, 130, 129, 127, 127, 126, // 49216-49223
125, 122, 124, 125, 126, 126, 125, 126, // 49224-49231
125, 123, 124, 126, 127, 127, 126, 128, // 49232-49239
129, 129, 128, 128, 127, 125, 126, 127, // 49240-49247
128, 130, 130, 132, 130, 130, 130, 130, // 49248-49255
128, 126, 126, 126, 126, 124, 125, 125, // 49256-49263
123, 122, 122, 124, 125, 124, 127, 129, // 49264-49271
129, 130, 130, 131, 132, 131, 131, 130, // 49272-49279
130, 128, 128, 127, 127, 126, 123, 124, // 49280-49287
124, 125, 125, 125, 126, 125, 124, 126, // 49288-49295
127, 127, 127, 128, 127, 127, 128, 127, // 49296-49303
127, 126, 125, 126, 127, 128, 130, 131, // 49304-49311
131, 129, 130, 129, 129, 128, 126, 127, // 49312-49319
125, 125, 125, 125, 126, 123, 123, 122, // 49320-49327
123, 124, 124, 127, 129, 130, 130, 131, // 49328-49335
131, 132, 132, 130, 130, 129, 127, 127, // 49336-49343
127, 127, 126, 122, 123, 123, 125, 126, // 49344-49351
125, 126, 125, 126, 126, 127, 129, 128, // 49352-49359
128, 127, 128, 129, 128, 128, 126, 126, // 49360-49367
126, 127, 128, 129, 131, 130, 128, 129, // 49368-49375
129, 129, 128, 128, 127, 126, 126, 125, // 49376-49383
124, 124, 123, 122, 122, 123, 124, 124, // 49384-49391
126, 129, 131, 131, 131, 131, 131, 132, // 49392-49399
129, 130, 129, 126, 128, 127, 127, 127, // 49400-49407
125, 124, 124, 124, 124, 125, 126, 125, // 49408-49415
127, 126, 129, 129, 129, 129, 128, 126, // 49416-49423
126, 125, 126, 125, 125, 125, 127, 128, // 49424-49431
129, 131, 130, 130, 129, 129, 128, 127, // 49432-49439
127, 126, 127, 127, 126, 126, 125, 124, // 49440-49447
123, 123, 124, 124, 124, 126, 129, 131, // 49448-49455
131, 131, 131, 131, 130, 128, 129, 129, // 49456-49463
126, 125, 125, 127, 127, 126, 125, 125, // 49464-49471
124, 124, 127, 127, 127, 126, 126, 128, // 49472-49479
129, 129, 128, 127, 126, 125, 126, 126, // 49480-49487
126, 126, 127, 128, 129, 129, 130, 129, // 49488-49495
128, 126, 128, 127, 127, 127, 126, 127, // 49496-49503
128, 126, 126, 124, 123, 123, 124, 125, // 49504-49511
127, 126, 128, 130, 131, 131, 131, 130, // 49512-49519
129, 128, 127, 127, 128, 126, 125, 126, // 49520-49527
127, 127, 126, 125, 125, 124, 124, 125, // 49528-49535
127, 126, 128, 128, 129, 130, 130, 129, // 49536-49543
128, 126, 125, 125, 126, 126, 127, 128, // 49544-49551
128, 129, 129, 130, 129, 127, 126, 127, // 49552-49559
127, 126, 126, 127, 126, 126, 125, 125, // 49560-49567
125, 124, 124, 125, 126, 126, 126, 128, // 49568-49575
130, 130, 131, 131, 130, 129, 127, 127, // 49576-49583
128, 128, 126, 126, 126, 126, 126, 125, // 49584-49591
126, 125, 124, 124, 126, 127, 127, 128, // 49592-49599
129, 129, 129, 129, 128, 127, 125, 125, // 49600-49607
126, 127, 127, 128, 129, 128, 129, 129, // 49608-49615
129, 128, 126, 125, 127, 128, 127, 128, // 49616-49623
128, 128, 127, 126, 126, 124, 123, 123, // 49624-49631
123, 127, 127, 127, 129, 130, 130, 129, // 49632-49639
130, 129, 128, 128, 127, 129, 127, 127, // 49640-49647
127, 125, 126, 126, 126, 126, 124, 124, // 49648-49655
124, 126, 126, 127, 129, 128, 129, 129, // 49656-49663
130, 129, 127, 126, 125, 126, 127, 127, // 49664-49671
129, 129, 128, 128, 128, 129, 127, 125, // 49672-49679
126, 127, 128, 127, 129, 128, 127, 125, // 49680-49687
124, 125, 124, 123, 125, 126, 128, 127, // 49688-49695
128, 130, 129, 128, 128, 130, 129, 128, // 49696-49703
128, 129, 129, 127, 126, 128, 125, 126, // 49704-49711
125, 126, 126, 124, 124, 124, 126, 127, // 49712-49719
127, 129, 128, 129, 128, 129, 129, 126, // 49720-49727
126, 126, 127, 127, 128, 130, 129, 128, // 49728-49735
127, 127, 127, 126, 125, 125, 127, 127, // 49736-49743
128, 130, 129, 128, 125, 124, 125, 123, // 49744-49751
124, 126, 125, 127, 127, 128, 130, 130, // 49752-49759
129, 128, 129, 127, 129, 128, 128, 130, // 49760-49767
128, 128, 128, 126, 126, 127, 126, 124, // 49768-49775
124, 124, 124, 125, 126, 127, 128, 128, // 49776-49783
128, 128, 129, 127, 126, 127, 126, 127, // 49784-49791
127, 128, 131, 129, 128, 127, 127, 126, // 49792-49799
127, 127, 126, 128, 127, 128, 129, 127, // 49800-49807
127, 125, 123, 123, 122, 124, 126, 126, // 49808-49815
127, 128, 129, 128, 129, 128, 127, 128, // 49816-49823
126, 128, 129, 130, 129, 129, 129, 127, // 49824-49831
126, 125, 125, 125, 124, 125, 126, 126, // 49832-49839
125, 126, 128, 128, 127, 127, 127, 127, // 49840-49847
125, 126, 127, 126, 126, 126, 129, 131, // 49848-49855
130, 128, 128, 128, 126, 127, 128, 128, // 49856-49863
129, 128, 129, 129, 127, 126, 125, 123, // 49864-49871
122, 122, 123, 126, 127, 127, 129, 129, // 49872-49879
128, 128, 129, 128, 127, 128, 128, 131, // 49880-49887
130, 128, 128, 128, 126, 124, 124, 125, // 49888-49895
125, 124, 126, 128, 127, 126, 128, 128, // 49896-49903
128, 127, 127, 127, 127, 126, 127, 128, // 49904-49911
127, 126, 127, 128, 129, 128, 128, 129, // 49912-49919
127, 125, 126, 128, 129, 128, 129, 128, // 49920-49927
129, 126, 125, 124, 122, 121, 122, 125, // 49928-49935
127, 129, 129, 130, 130, 128, 128, 128, // 49936-49943
127, 126, 127, 128, 130, 130, 129, 130, // 49944-49951
128, 126, 125, 125, 124, 124, 124, 125, // 49952-49959
128, 127, 127, 128, 128, 128, 127, 127, // 49960-49967
126, 126, 124, 125, 127, 127, 128, 128, // 49968-49975
128, 130, 128, 128, 129, 128, 127, 126, // 49976-49983
128, 127, 128, 129, 128, 127, 126, 125, // 49984-49991
125, 123, 123, 122, 124, 126, 128, 128, // 49992-49999
128, 130, 129, 128, 128, 127, 128, 127, // 50000-50007
129, 129, 130, 129, 127, 126, 126, 125, // 50008-50015
125, 124, 126, 126, 127, 128, 128, 129, // 50016-50023
127, 126, 125, 125, 126, 124, 125, 126, // 50024-50031
127, 127, 128, 129, 127, 127, 127, 127, // 50032-50039
128, 128, 130, 129, 128, 129, 130, 130, // 50040-50047
128, 127, 126, 125, 123, 122, 123, 124, // 50048-50055
123, 125, 127, 129, 128, 128, 129, 129, // 50056-50063
128, 127, 127, 127, 128, 128, 129, 130, // 50064-50071
130, 127, 127, 126, 125, 125, 125, 126, // 50072-50079
126, 127, 129, 130, 130, 127, 126, 126, // 50080-50087
126, 125, 126, 126, 126, 126, 126, 128, // 50088-50095
129, 127, 126, 126, 127, 128, 129, 130, // 50096-50103
130, 129, 129, 130, 129, 126, 127, 126, // 50104-50111
124, 123, 123, 125, 124, 125, 125, 127, // 50112-50119
128, 127, 127, 128, 129, 127, 127, 129, // 50120-50127
129, 129, 128, 131, 131, 128, 126, 126, // 50128-50135
124, 124, 124, 125, 126, 126, 128, 130, // 50136-50143
131, 130, 128, 126, 126, 124, 124, 127, // 50144-50151
127, 125, 126, 128, 128, 128, 126, 126, // 50152-50159
127, 126, 126, 129, 130, 130, 128, 129, // 50160-50167
130, 130, 128, 127, 128, 125, 123, 122, // 50168-50175
124, 125, 124, 125, 126, 128, 128, 128, // 50176-50183
129, 129, 128, 127, 128, 129, 129, 128, // 50184-50191
129, 129, 128, 127, 126, 126, 124, 124, // 50192-50199
125, 126, 126, 126, 129, 130, 129, 128, // 50200-50207
126, 127, 126, 126, 127, 128, 126, 125, // 50208-50215
126, 127, 127, 126, 126, 127, 126, 127, // 50216-50223
130, 130, 130, 128, 128, 129, 129, 127, // 50224-50231
126, 127, 124, 123, 123, 125, 126, 125, // 50232-50239
125, 126, 128, 128, 128, 129, 128, 128, // 50240-50247
127, 128, 130, 129, 129, 130, 130, 127, // 50248-50255
125, 126, 125, 124, 124, 124, 125, 126, // 50256-50263
127, 129, 130, 129, 129, 128, 127, 127, // 50264-50271
126, 126, 127, 125, 125, 126, 128, 128, // 50272-50279
126, 128, 127, 127, 126, 127, 130, 128, // 50280-50287
128, 128, 128, 130, 129, 129, 128, 127, // 50288-50295
124, 123, 124, 124, 124, 124, 125, 126, // 50296-50303
127, 128, 129, 130, 129, 129, 129, 130, // 50304-50311
129, 128, 128, 128, 127, 126, 126, 126, // 50312-50319
126, 125, 125, 126, 125, 126, 126, 127, // 50320-50327
127, 127, 127, 127, 128, 128, 128, 128, // 50328-50335
128, 127, 126, 127, 127, 125, 126, 126, // 50336-50343
126, 126, 128, 129, 128, 128, 128, 128, // 50344-50351
129, 128, 127, 127, 126, 125, 124, 125, // 50352-50359
126, 126, 125, 125, 126, 126, 127, 128, // 50360-50367
128, 129, 128, 127, 129, 130, 130, 130, // 50368-50375
129, 128, 127, 126, 126, 125, 124, 124, // 50376-50383
124, 125, 126, 127, 127, 128, 127, 128, // 50384-50391
128, 128, 128, 127, 128, 127, 126, 126, // 50392-50399
127, 128, 126, 126, 126, 128, 127, 127, // 50400-50407
128, 128, 128, 127, 127, 129, 129, 128, // 50408-50415
128, 128, 127, 125, 126, 126, 126, 125, // 50416-50423
124, 126, 125, 126, 128, 129, 130, 128, // 50424-50431
129, 129, 130, 129, 128, 127, 126, 125, // 50432-50439
124, 126, 127, 125, 125, 126, 127, 127, // 50440-50447
127, 127, 127, 126, 126, 127, 129, 129, // 50448-50455
129, 130, 129, 128, 125, 126, 125, 124, // 50456-50463
124, 126, 126, 127, 128, 129, 130, 129, // 50464-50471
129, 129, 129, 128, 127, 128, 128, 127, // 50472-50479
125, 125, 127, 125, 125, 125, 126, 125, // 50480-50487
126, 127, 128, 128, 127, 127, 129, 129, // 50488-50495
130, 129, 128, 127, 125, 125, 127, 127, // 50496-50503
125, 125, 126, 126, 126, 126, 126, 127, // 50504-50511
126, 126, 129, 129, 129, 129, 129, 128, // 50512-50519
127, 126, 125, 126, 124, 125, 127, 127, // 50520-50527
127, 128, 128, 128, 127, 127, 127, 128, // 50528-50535
128, 127, 130, 129, 128, 126, 127, 127, // 50536-50543
125, 125, 125, 126, 125, 124, 126, 128, // 50544-50551
128, 128, 129, 130, 130, 129, 129, 128, // 50552-50559
126, 124, 125, 126, 127, 126, 127, 128, // 50560-50567
127, 127, 127, 127, 125, 124, 126, 127, // 50568-50575
129, 129, 129, 130, 128, 127, 126, 126, // 50576-50583
125, 124, 125, 127, 127, 127, 128, 129, // 50584-50591
128, 128, 127, 128, 128, 126, 127, 128, // 50592-50599
128, 127, 126, 126, 126, 125, 126, 126, // 50600-50607
127, 125, 126, 128, 128, 128, 127, 127, // 50608-50615
129, 128, 128, 128, 129, 127, 126, 127, // 50616-50623
128, 127, 127, 127, 126, 127, 126, 127, // 50624-50631
127, 157, 156, 136,  97,  93,  71,  35, // 50632-50639
110, 157, 176, 100, 158, 243, 193, 146, // 50640-50647
 52,  74, 119,  91, 154,   4, 245, 161, // 50648-50655
120, 138,  67, 255, 239, 245,  16, 233, // 50656-50663
 55, 131, 159, 169, 157, 208, 156, 102, // 50664-50671
 66, 111, 159,  56,  61, 131, 124,  98, // 50672-50679
157, 247,   7, 176, 107, 153, 205, 173, // 50680-50687
176, 243, 229, 233, 169, 207,  40, 118, // 50688-50695
237, 173, 183, 165, 179,  27,  73, 130, // 50696-50703
 72, 155, 236, 195, 195, 118, 146, 166, // 50704-50711
176, 241,  52,  65, 215, 191, 176,  84, // 50712-50719
 32,   9,  25,  14,   1,  84, 130, 156, // 50720-50727
148, 156, 191, 113,  83,  49,  88, 134, // 50728-50735
 55,  79, 123, 125,  74, 135, 228, 202, // 50736-50743
166,  92, 138, 182, 155, 200, 242, 234, // 50744-50751
215, 180, 194, 248, 137, 249, 196, 187, // 50752-50759
160, 205,  42,  76, 125,  85, 147, 196, // 50760-50767
168, 187, 131, 143, 145, 197, 255,  41, // 50768-50775
 70, 221, 212, 158,  69,  32,  14,  38, // 50776-50783
255,  32, 104, 131, 154, 140, 172, 173, // 50784-50791
 96,  79,  56,  85, 115,  87, 111, 131, // 50792-50799
136,  71, 137, 209, 163, 164,  96, 130, // 50800-50807
159, 156, 224, 244, 242, 201, 202, 185, // 50808-50815
198, 156,  10, 224, 187, 166, 235,  50, // 50816-50823
 81, 113, 111, 136, 154, 150, 175, 146, // 50824-50831
128, 133, 219,   6,  29,  57, 239, 222, // 50832-50839
135,  64,  33,  24,  40, 246,  62, 117, // 50840-50847
130, 144, 139, 181, 145,  89,  73,  71, // 50848-50855
 84,  95, 125, 133, 139, 139,  77, 137, // 50856-50863
178, 137, 155, 108, 121, 134, 169, 237, // 50864-50871
244, 242, 193, 217, 168, 156, 165,  34, // 50872-50879
248, 183, 188,   5,  54,  85,  99, 137, // 50880-50887
117, 117, 137, 164, 162, 111, 136, 232, // 50888-50895
  9,  17,  36,   9, 218, 118,  63,  34, // 50896-50903
 35,  30, 253,  87, 128, 131, 133, 147, // 50904-50911
178, 121,  87,  68,  82,  73,  83, 158, // 50912-50919
149, 147, 137,  94, 131, 146, 125, 143, // 50920-50927
126, 108, 117, 185, 240, 245, 234, 196, // 50928-50935
225, 148, 128, 165,  64,   6, 185, 216, // 50936-50943
 20,  55,  83,  91, 155,  98,  92, 124, // 50944-50951
156, 171,  98, 149, 235,  11,   6,  17, // 50952-50959
 32, 204, 111,  65,  42,  45,  20,  20, // 50960-50967
 99, 137, 129, 121, 157, 162, 104,  85, // 50968-50975
 68,  93,  63,  82, 180, 162, 150, 133, // 50976-50983
114, 115, 116, 117, 131, 144,  94, 112, // 50984-50991
199, 238, 246, 223, 207, 219, 133, 109, // 50992-50999
158,  98,  12, 201, 245,  33,  60,  78, // 51000-51007
 95, 159,  83,  73, 112, 153, 168,  94, // 51008-51015
163, 233,  11, 251,   5,  45, 189, 110, // 51016-51023
 64,  51,  46,  14,  48, 104, 147, 126, // 51024-51031
118, 164, 140,  95,  81,  74,  94,  59, // 51032-51039
 92, 188, 178, 150, 133, 134,  97,  96, // 51040-51047
112, 124, 154,  86, 116, 204, 234, 242, // 51048-51055
214, 221, 202, 126,  97, 149, 124,  13, // 51056-51063
228,  13,  41,  61,  72, 102, 146,  77, // 51064-51071
 60, 103, 150, 158, 105, 173, 229,   6, // 51072-51079
240,   0,  39, 177, 112,  67,  63,  43, // 51080-51087
 20,  75, 103, 153, 124, 121, 160, 117, // 51088-51095
 91,  77,  83,  87,  64, 109, 186, 193, // 51096-51103
148, 141, 144,  78,  80, 105, 121, 151, // 51104-51111
 88, 126, 202, 232, 234, 213, 227, 178, // 51112-51119
123,  90, 141, 140,  22,   7,  30,  51, // 51120-51127
 62,  73, 112, 122,  77,  50,  94, 142, // 51128-51135
142, 126, 176, 226, 254, 236, 255,  20, // 51136-51143
176, 115,  73,  71,  37,  35,  95, 104, // 51144-51151
151, 126, 127, 146, 101,  88,  76,  92, // 51152-51159
 76,  76, 124, 179, 203, 147, 154, 145, // 51160-51167
 64,  69,  99, 122, 137, 101, 137, 197, // 51168-51175
229, 221, 219, 224, 159, 123,  87, 134, // 51176-51183
144,  42,  42,  45,  61,  59,  78, 116, // 51184-51191
 97,  79,  45,  89, 130, 134, 150, 174, // 51192-51199
223, 237, 237, 252, 246, 180, 116,  87, // 51200-51207
 72,  38,  59, 107, 109, 143, 134, 132, // 51208-51215
125,  91,  84,  80,  94,  68,  95, 134, // 51216-51223
170, 203, 151, 163, 136,  57,  62,  98, // 51224-51231
124, 124, 124, 145, 189, 221, 211, 228, // 51232-51239
211, 145, 122,  89, 126, 137,  70,  66, // 51240-51247
 57,  64,  57,  87, 110,  79,  82,  49, // 51248-51255
 86, 115, 135, 172, 171, 217, 221, 242, // 51256-51263
241, 214, 185, 120, 100,  69,  46,  79, // 51264-51271
113, 115, 130, 149, 134, 105,  89,  83, // 51272-51279
 90,  90,  67, 110, 139, 163, 195, 162, // 51280-51287
165, 125,  58,  53,  96, 120, 113, 147, // 51288-51295
152, 183, 211, 207, 230, 192, 139, 118, // 51296-51303
 96, 116, 129, 102,  85,  71,  67,  60, // 51304-51311
 94,  96,  66,  81,  58,  82, 101, 141, // 51312-51319
185, 170, 207, 210, 243, 225, 189, 185, // 51320-51327
127, 111,  66,  62,  96, 117, 121, 119, // 51328-51335
163, 130,  88,  84,  79,  95,  81,  76, // 51336-51343
124, 144, 159, 185, 179, 162, 115,  64, // 51344-51351
 50,  97, 112, 112, 164, 159, 177, 198, // 51352-51359
208, 224, 173, 137, 116, 106, 105, 124, // 51360-51367
132,  99,  83,  65,  70,  97,  82,  62, // 51368-51375
 77,  73,  75,  90, 150, 191, 173, 193, // 51376-51383
207, 241, 207, 173, 182, 140, 116,  66, // 51384-51391
 80, 106, 118, 121, 112, 168, 122,  76, // 51392-51399
 81,  81,  99,  74,  92, 131, 148, 153, // 51400-51407
174, 193, 151, 109,  68,  51,  95, 103, // 51408-51415
119, 174, 166, 168, 184, 211, 210, 159, // 51416-51423
135, 116, 114,  94, 125, 155, 112,  94, // 51424-51431
 66,  81,  91,  68,  61,  72,  85,  66, // 51432-51439
 87, 157, 191, 177, 179, 209, 232, 192, // 51440-51447
162, 175, 153, 114,  74,  97, 112, 120, // 51448-51455
120, 116, 166, 116,  70,  78,  85,  96, // 51456-51463
 74, 109, 134, 151, 147, 168, 201, 140, // 51464-51471
107,  74,  57,  90,  97, 130, 176, 174, // 51472-51479
160, 176, 211, 192, 153, 133, 121, 118, // 51480-51487
 89, 129, 167, 126,  98,  70,  91,  81, // 51488-51495
 60,  60,  71,  94,  61,  91, 159, 190, // 51496-51503
179, 169, 211, 214, 179, 154, 168, 164, // 51504-51511
111,  89, 110, 118, 121, 117, 121, 154, // 51512-51519
113,  67,  75,  91,  90,  83, 123, 138, // 51520-51527
154, 143, 164, 198, 131, 105,  78,  64, // 51528-51535
 82,  97, 141, 173, 182, 152, 172, 203, // 51536-51543
173, 148, 129, 125, 116,  91, 136, 172, // 51544-51551
141, 100,  80,  94,  70,  56,  59,  74, // 51552-51559
 96,  64, 100, 159, 191, 178, 165, 211, // 51560-51567
195, 172, 149, 161, 169, 112, 105, 118, // 51568-51575
125, 119, 118, 127, 136, 113,  65,  72, // 51576-51583
 93,  84,  96, 129, 140, 150, 142, 161, // 51584-51591
183, 130, 105,  86,  72,  73, 105, 150, // 51592-51599
170, 183, 151, 170, 191, 160, 148, 131, // 51600-51607
132, 111, 100, 142, 171, 149, 102,  91, // 51608-51615
 91,  63,  55,  61,  77,  91,  76, 107, // 51616-51623
152, 186, 175, 166, 202, 177, 166, 147, // 51624-51631
154, 164, 119, 122, 123, 129, 117, 122, // 51632-51639
131, 116, 118,  71,  75,  91,  84, 112, // 51640-51647
134, 145, 145, 147, 158, 164, 132, 103, // 51648-51655
 95,  74,  67, 111, 150, 166, 179, 155, // 51656-51663
168, 174, 151, 142, 131, 132, 105, 109, // 51664-51671
143, 168, 157, 111, 106,  88,  62,  54, // 51672-51679
 62,  80,  82,  90, 113, 149, 183, 173, // 51680-51687
171, 189, 166, 158, 147, 150, 155, 130, // 51688-51695
135, 128, 130, 114, 126, 129, 103, 118, // 51696-51703
 80,  78,  86,  86, 122, 136, 148, 138, // 51704-51711
150, 152, 146, 133, 104, 105,  75,  67, // 51712-51719
117, 152, 168, 173, 164, 164, 158, 145, // 51720-51727
138, 136, 131, 107, 120, 143, 165, 155, // 51728-51735
118, 110,  80,  60,  52,  67,  81,  78, // 51736-51743
106, 119, 146, 174, 174, 174, 172, 159, // 51744-51751
153, 150, 147, 146, 145, 143, 134, 129, // 51752-51759
115, 130, 121,  92, 113,  90,  80,  81, // 51760-51767
 93, 129, 138, 146, 135, 155, 146, 131, // 51768-51775
133, 107, 111,  76,  72, 121, 150, 165, // 51776-51783
164, 172, 158, 145, 143, 137, 141, 126, // 51784-51791
114, 130, 145, 162, 154, 131, 112,  74, // 51792-51799
 60,  54,  69,  76,  76, 117, 122, 140, // 51800-51807
163, 175, 173, 155, 156, 150, 157, 143, // 51808-51815
141, 159, 150, 140, 126, 119, 130, 112, // 51816-51823
 88, 107, 103,  78,  76, 103, 132, 139, // 51824-51831
143, 137, 156, 139, 122, 133, 114, 114, // 51832-51839
 79,  81, 123, 148, 160, 159, 178, 149, // 51840-51847
133, 139, 138, 144, 123, 127, 138, 147, // 51848-51855
159, 153, 143, 109,  72,  60,  57,  72, // 51856-51863
 71,  81, 122, 127, 135, 154, 179, 166, // 51864-51871
143, 152, 147, 159, 139, 142, 170, 155, // 51872-51879
144, 125, 127, 126, 105,  88, 101, 114, // 51880-51887
 77,  77, 111, 131, 141, 139, 143, 154, // 51888-51895
132, 117, 130, 123, 111,  86,  91, 121, // 51896-51903
145, 154, 158, 177, 142, 126, 135, 138, // 51904-51911
141, 122, 137, 142, 147, 154, 152, 149, // 51912-51919
105,  74,  62,  61,  71,  69,  91, 123, // 51920-51927
132, 130, 147, 179, 157, 136, 149, 149, // 51928-51935
158, 138, 145, 175, 160, 145, 126, 132, // 51936-51943
118,  98,  87,  98, 120,  77,  82, 116, // 51944-51951
131, 140, 135, 148, 145, 126, 112, 125, // 51952-51959
130, 108,  98, 102, 122, 144, 150, 161, // 51960-51967
171, 138, 123, 131, 139, 136, 126, 146, // 51968-51975
145, 148, 150, 155, 151, 103,  76,  64, // 51976-51983
 68,  68,  69, 100, 123, 135, 126, 144, // 51984-51991
174, 147, 130, 142, 150, 152, 137, 149, // 51992-51999
175, 167, 145, 132, 136, 113,  97,  89, // 52000-52007
 96, 121,  84,  91, 121, 131, 138, 135, // 52008-52015
151, 135, 121, 110, 120, 131, 105, 111, // 52016-52023
109, 121, 141, 148, 163, 159, 136, 118, // 52024-52031
128, 139, 131, 136, 153, 149, 146, 148, // 52032-52039
155, 144, 101,  78,  67,  72,  66,  77, // 52040-52047
109, 123, 139, 127, 144, 165, 139, 125, // 52048-52055
136, 149, 143, 142, 154, 172, 172, 148, // 52056-52063
140, 135, 106,  96,  91,  98, 118,  97, // 52064-52071
101, 122, 131, 135, 140, 147, 123, 116, // 52072-52079
106, 114, 126, 107, 121, 116, 122, 136, // 52080-52087
148, 163, 147, 136, 118, 128, 136, 126, // 52088-52095
145, 156, 155, 144, 147, 156, 135, 104, // 52096-52103
 81,  75,  75,  65,  86, 111, 122, 136, // 52104-52111
127, 140, 150, 133, 122, 134, 150, 140, // 52112-52119
151, 160, 168, 172, 148, 146, 130, 102, // 52120-52127
 96,  93,  98, 111, 110, 108, 122, 130, // 52128-52135
131, 143, 142, 119, 115, 109, 115, 122, // 52136-52143
115, 132, 121, 119, 130, 146, 154, 136, // 52144-52151
135, 118, 126, 131, 129, 152, 157, 159, // 52152-52159
143, 150, 155, 129, 110,  86,  82,  74, // 52160-52167
 69,  94, 111, 123, 132, 133, 136, 137, // 52168-52175
133, 121, 133, 145, 137, 156, 160, 165, // 52176-52183
169, 154, 149, 123, 105,  96,  98,  98, // 52184-52191
108, 125, 113, 122, 128, 131, 143, 134, // 52192-52199
118, 113, 113, 113, 118, 125, 135, 125, // 52200-52207
116, 126, 144, 144, 132, 134, 123, 125, // 52208-52215
126, 136, 154, 154, 157, 141, 151, 149, // 52216-52223
125, 114,  92,  87,  74,  79, 101, 112, // 52224-52231
123, 128, 140, 131, 128, 133, 121, 131, // 52232-52239
139, 140, 159, 160, 161, 162, 157, 143, // 52240-52247
117, 104,  96, 102,  96, 108, 135, 118, // 52248-52255
121, 126, 134, 142, 127, 119, 112, 117, // 52256-52263
110, 116, 133, 136, 129, 114, 128, 144, // 52264-52271
137, 131, 132, 127, 119, 123, 141, 154, // 52272-52279
154, 154, 143, 149, 142, 123, 113,  98, // 52280-52287
 88,  75,  88, 104, 115, 122, 128, 144, // 52288-52295
126, 123, 132, 124, 129, 133, 145, 158, // 52296-52303
161, 156, 160, 162, 141, 117, 105,  99, // 52304-52311
104,  94, 109, 139, 124, 119, 124, 137, // 52312-52319
137, 123, 119, 112, 118, 107, 118, 139, // 52320-52327
138, 132, 113, 129, 139, 131, 129, 131, // 52328-52335
133, 117, 124, 146, 155, 154, 150, 148, // 52336-52343
145, 137, 123, 116, 105,  88,  78,  94, // 52344-52351
106, 114, 119, 127, 142, 121, 117, 129, // 52352-52359
128, 125, 131, 151, 159, 162, 153, 158, // 52360-52367
163, 137, 117, 107, 104, 104,  95, 113, // 52368-52375
140, 129, 116, 123, 136, 130, 119, 118, // 52376-52383
115, 118, 107, 120, 142, 138, 132, 113, // 52384-52391
129, 132, 126, 128, 130, 135, 115, 127, // 52392-52399
148, 155, 153, 148, 153, 141, 134, 125, // 52400-52407
117, 112,  89,  85, 100, 108, 112, 116, // 52408-52415
127, 136, 118, 113, 127, 128, 119, 130, // 52416-52423
153, 159, 161, 152, 158, 162, 136, 120, // 52424-52431
110, 109, 101,  98, 117, 139, 134, 115, // 52432-52439
124, 135, 124, 118, 118, 118, 116, 108, // 52440-52447
122, 140, 140, 131, 118, 128, 128, 124, // 52448-52455
128, 132, 135, 117, 129, 146, 152, 152, // 52456-52463
147, 155, 138, 133, 126, 120, 114,  91, // 52464-52471
 93, 102, 109, 112, 114, 129, 129, 119, // 52472-52479
112, 124, 128, 115, 130, 152, 157, 158, // 52480-52487
151, 158, 158, 135, 122, 113, 113, 102, // 52488-52495
104, 121, 139, 136, 118, 125, 129, 120, // 52496-52503
118, 120, 121, 120, 150, 160, 126,  94, // 52504-52511
 69,  95,  53,  70, 143, 190, 156, 121, // 52512-52519
223, 252, 183,  78,  78, 137, 124, 100, // 52520-52527
202, 253, 184, 110,  99, 106,   8, 241, // 52528-52535
221,   3,  32, 233,  66, 132, 166, 154, // 52536-52543
175, 205, 135,  98,  82, 164, 128,  36, // 52544-52551
106, 113, 104, 159, 217,  31, 242, 136, // 52552-52559
125, 186, 205, 152, 200, 226, 227, 197, // 52560-52567
162,  39, 194,   7, 185, 161, 190, 152, // 52568-52575
235,  50, 120, 115,  98, 227, 236, 210, // 52576-52583
131, 136, 201, 175, 208,  15,  75,   8, // 52584-52591
180, 181, 129,  40,  10,   4,  17,  29, // 52592-52599
 25,  83, 135, 156, 140, 177, 167,  94, // 52600-52607
 74,  56, 137, 104,  46, 115, 113,  91, // 52608-52615
121, 213, 239, 196, 126,  98, 172, 168, // 52616-52623
158, 219, 230, 225, 189, 172,   3, 185, // 52624-52631
 22, 195, 178, 178, 162,   8,  65, 120, // 52632-52639
120, 108, 206, 192, 195, 134, 138, 183, // 52640-52647
168, 241,  15,  77,  14, 193, 190, 100, // 52648-52655
 39,   4,  22,  11,  22,  72,  88, 138, // 52656-52663
145, 145, 184, 141,  84,  74,  64, 121, // 52664-52671
108,  86, 132, 131,  91, 110, 216, 202, // 52672-52679
174, 133,  95, 160, 148, 179, 234, 236, // 52680-52687
220, 187, 187, 213, 177,  44, 215, 197, // 52688-52695
169, 187,  27,  73, 113, 123, 124, 168, // 52696-52703
156, 179, 143, 138, 161, 177,   7,  12, // 52704-52711
 63,  16, 212, 184,  78,  41,   3,  38, // 52712-52719
  1,  24, 112,  92, 133, 131, 153, 175, // 52720-52727
114,  80,  71,  81,  97, 117, 127, 140, // 52728-52735
146,  88, 110, 204, 167, 157, 137, 103, // 52736-52743
137, 139, 200, 240, 241, 212, 193, 196, // 52744-52751
166, 168,  63, 238, 210, 166, 220,  36, // 52752-52759
 80, 100, 128, 137, 128, 133, 162, 155, // 52760-52767
134, 144, 195,  15,  14,  38,  21, 234, // 52768-52775
167,  69,  42,  12,  44, 251,  35, 136, // 52776-52783
101, 122, 123, 163, 156,  97,  79,  73, // 52784-52791
 92,  72, 130, 160, 146, 153,  87, 116, // 52792-52799
178, 143, 144, 142, 117, 112, 143, 216, // 52800-52807
241, 241, 203, 203, 193, 132, 159,  84, // 52808-52815
 11, 215, 177, 249,  39,  83,  87, 134, // 52816-52823
144,  93, 117, 148, 167, 124, 136, 215, // 52824-52831
 13,  16,  10,  28, 245, 147,  70,  42, // 52832-52839
 29,  40,   3,  57, 150, 115, 108, 123, // 52840-52847
163, 132,  87,  78,  78,  97,  59, 146, // 52848-52855
183, 153, 153,  95, 121, 146, 128, 131, // 52856-52863
147, 127,  93, 155, 221, 240, 235, 199, // 52864-52871
213, 176, 112, 144, 103,  34, 216, 203, // 52872-52879
 17,  45,  85,  82, 142, 139,  71, 103, // 52880-52887
136, 172, 115, 137, 229,   8,  18, 241, // 52888-52895
 34, 244, 132,  76,  43,  45,  27,  19, // 52896-52903
 74, 153, 131,  94, 130, 154, 112,  85, // 52904-52911
 77,  87,  91,  62, 155, 197, 163, 151, // 52912-52919
114, 119, 116, 121, 123, 152, 131,  83, // 52920-52927
166, 219, 238, 225, 202, 215, 154, 104, // 52928-52935
130, 124,  49, 223, 237,  30,  51,  78, // 52936-52943
 84, 141, 126,  63,  89, 132, 170, 110, // 52944-52951
147, 233,   3,  13, 230,  34, 235, 127, // 52952-52959
 81,  49,  54,  18,  42,  84, 150, 143, // 52960-52967
 85, 136, 136,  99,  83,  80,  94,  82, // 52968-52975
 78, 157, 205, 170, 145, 132, 108,  93, // 52976-52983
114, 119, 153, 128,  89, 171, 216, 234, // 52984-52991
214, 209, 208, 138, 102, 118, 138,  59, // 52992-52999
242,  11,  39,  59,  69,  93, 134, 110, // 53000-53007
 64,  76, 131, 161, 115, 158, 230, 252, // 53008-53015
  0, 228,  23, 222, 130,  86,  61,  57, // 53016-53023
 16,  68,  93, 146, 149,  88, 136, 117, // 53024-53031
 91,  82,  87,  97,  75, 100, 154, 207, // 53032-53039
172, 143, 147,  91,  76, 106, 121, 150, // 53040-53047
126, 107, 170, 212, 223, 206, 215, 192, // 53048-53055
126, 101, 113, 145,  67,  16,  39,  48, // 53056-53063
 64,  64, 105, 119,  98,  68,  69, 128, // 53064-53071
145, 128, 166, 225, 245, 241, 234, 254, // 53072-53079
208, 135,  92,  75,  55,  27,  89, 102, // 53080-53087
139, 152, 100, 125,  97,  86,  81,  94, // 53088-53095
 94,  75, 122, 149, 204, 177, 150, 156, // 53096-53103
 78,  69,  98, 125, 138, 124, 131, 164, // 53104-53111
208, 212, 206, 218, 173, 122,  98, 111, // 53112-53119
140,  78,  48,  56,  58,  65,  65, 113, // 53120-53127
102,  88,  75,  68, 119, 131, 145, 168, // 53128-53135
217, 236, 229, 242, 224, 198, 143, 100, // 53136-53143
 85,  51,  49, 101, 110, 130, 154, 121, // 53144-53151
109,  85,  81,  83,  97,  84,  82, 137, // 53152-53159
146, 194, 179, 161, 156,  70,  63,  92, // 53160-53167
129, 127, 131, 155, 160, 201, 200, 211, // 53168-53175
212, 155, 121,  97, 114, 128,  91,  79, // 53176-53183
 68,  67,  63,  74, 112,  86,  81,  78, // 53184-53191
 72, 104, 122, 162, 169, 209, 223, 226, // 53192-53199
247, 198, 189, 149, 111,  88,  51,  72, // 53200-53207
106, 117, 120, 155, 139,  90,  77,  76, // 53208-53215
 86,  94,  78,  97, 145, 148, 180, 184, // 53216-53223
172, 147,  69,  59,  91, 127, 117, 141, // 53224-53231
170, 157, 190, 192, 215, 198, 144, 123, // 53232-53239
 99, 116, 115, 111, 105,  80,  73,  62, // 53240-53247
 85, 103,  74,  77,  82,  80,  85, 122, // 53248-53255
175, 169, 198, 212, 227, 237, 176, 179, // 53256-53263
155, 122,  86,  60,  93, 109, 122, 110, // 53264-53271
158, 150,  72,  73,  74,  93,  91,  81, // 53272-53279
116, 146, 152, 164, 191, 178, 133,  74, // 53280-53287
 55,  91, 117, 110, 152, 178, 158, 176, // 53288-53295
189, 214, 182, 138, 123, 104, 113, 106, // 53296-53303
130, 123,  92,  77,  67,  94,  88,  69, // 53304-53311
 72,  87,  85,  72, 128, 181, 172, 188, // 53312-53319
205, 230, 223, 166, 169, 161, 130,  84, // 53320-53327
 73, 105, 110, 123, 106, 159, 153,  65, // 53328-53335
 69,  74,  96,  84,  87, 128, 146, 155, // 53336-53343
151, 197, 178, 124,  83,  53,  92, 107, // 53344-53351
113, 158, 181, 161, 159, 191, 206, 168, // 53352-53359
138, 123, 113, 107, 105, 144, 135, 103, // 53360-53367
 78,  74,  98,  75,  67,  68,  91,  86, // 53368-53375
 64, 133, 180, 175, 174, 201, 227, 205, // 53376-53383
163, 158, 167, 135,  86,  90, 112, 114, // 53384-53391
121, 108, 154, 148,  67,  65,  77,  95, // 53392-53399
 80, 100, 135, 146, 156, 144, 198, 173, // 53400-53407
119,  91,  55,  89,  95, 119, 160, 182, // 53408-53415
168, 150, 194, 192, 159, 136, 122, 117, // 53416-53423
 98, 111, 150, 145, 113,  82,  88,  93, // 53424-53431
 66,  66,  65,  92,  85,  70, 135, 179, // 53432-53439
180, 166, 204, 221, 189, 165, 148, 170, // 53440-53447
135,  93, 107, 115, 120, 118, 117, 145, // 53448-53455
142,  78,  58,  81,  89,  80, 109, 136, // 53456-53463
146, 153, 146, 190, 164, 117,  93,  63, // 53464-53471
 82,  88, 130, 160, 183, 173, 152, 195, // 53472-53479
180, 155, 134, 126, 120,  93, 123, 152, // 53480-53487
154, 121,  87,  97,  84,  62,  63,  68, // 53488-53495
 90,  82,  79, 130, 176, 178, 158, 199, // 53496-53503
204, 176, 163, 143, 168, 134, 105, 117, // 53504-53511
121, 124, 116, 130, 136, 135,  89,  59, // 53512-53519
 87,  82,  87, 117, 138, 146, 147, 152, // 53520-53527
176, 156, 118,  96,  73,  74,  89, 138, // 53528-53535
162, 180, 171, 153, 183, 165, 149, 129, // 53536-53543
127, 118,  93, 132, 152, 157, 124,  94, // 53544-53551
102,  76,  63,  62,  77,  87,  84,  99, // 53552-53559
129, 175, 176, 160, 195, 188, 166, 159, // 53560-53567
145, 159, 136, 122, 127, 126, 124, 117, // 53568-53575
135, 119, 123,  94,  58,  83,  77,  97, // 53576-53583
124, 141, 145, 144, 159, 157, 150, 119, // 53584-53591
100,  83,  69, 101, 145, 165, 176, 172, // 53592-53599
162, 168, 154, 143, 129, 127, 113, 101, // 53600-53607
140, 152, 157, 129, 106,  97,  66,  60, // 53608-53615
 59,  77,  78,  89, 116, 127, 171, 174, // 53616-53623
166, 187, 176, 162, 156, 149, 149, 141, // 53624-53631
138, 132, 130, 122, 120, 134, 106, 115, // 53632-53639
100,  65,  78,  76, 108, 126, 141, 143, // 53640-53647
145, 163, 141, 144, 122, 106,  87,  65, // 53648-53655
109, 143, 164, 170, 173, 170, 151, 147, // 53656-53663
140, 133, 127, 112, 113, 143, 156, 153, // 53664-53671
135, 117,  91,  63,  59,  60,  79,  72, // 53672-53679
 95, 125, 127, 162, 170, 170, 173, 165, // 53680-53687
158, 155, 154, 140, 148, 151, 136, 132, // 53688-53695
119, 125, 128,  97, 107, 105,  75,  71, // 53696-53703
 81, 116, 130, 141, 140, 147, 160, 129, // 53704-53711
138, 124, 113,  89,  68, 116, 141, 163, // 53712-53719
161, 172, 171, 136, 141, 136, 138, 126, // 53720-53727
114, 126, 144, 161, 149, 141, 125,  85, // 53728-53735
 65,  59,  67,  79,  72, 103, 130, 129, // 53736-53743
150, 167, 172, 158, 156, 153, 154, 154, // 53744-53751
133, 156, 160, 143, 133, 120, 130, 120, // 53752-53759
 94, 100, 110,  84,  65,  88, 121, 133, // 53760-53767
140, 138, 152, 151, 124, 130, 127, 119, // 53768-53775
 91,  76, 120, 143, 160, 156, 173, 168, // 53776-53783
128, 134, 132, 140, 121, 117, 134, 142, // 53784-53791
161, 145, 147, 129,  84,  68,  61,  73, // 53792-53799
 75,  76, 108, 132, 131, 138, 168, 169, // 53800-53807
145, 150, 149, 156, 151, 132, 161, 167, // 53808-53815
149, 133, 125, 133, 113,  95,  94, 115, // 53816-53823
 90,  63,  97, 120, 133, 134, 138, 151, // 53824-53831
142, 122, 124, 132, 123,  95,  89, 120, // 53832-53839
143, 154, 155, 172, 161, 124, 127, 133, // 53840-53847
140, 120, 125, 142, 142, 159, 145, 153, // 53848-53855
129,  84,  71,  64,  77,  70,  84, 112, // 53856-53863
132, 132, 129, 167, 162, 136, 144, 147, // 53864-53871
157, 147, 137, 164, 170, 153, 131, 131, // 53872-53879
130, 107,  96,  92, 118,  93,  67, 100, // 53880-53887
121, 134, 129, 141, 149, 134, 122, 120, // 53888-53895
137, 122, 100, 100, 119, 142, 147, 157, // 53896-53903
169, 154, 124, 122, 135, 134, 118, 132, // 53904-53911
144, 143, 153, 150, 155, 128,  88,  73, // 53912-53919
 70,  76,  68,  91, 112, 130, 129, 124, // 53920-53927
164, 154, 131, 140, 149, 155, 142, 144, // 53928-53935
165, 173, 154, 132, 138, 124, 105,  97, // 53936-53943
 95, 117,  96,  76, 104, 121, 132, 130, // 53944-53951
146, 145, 130, 125, 120, 137, 118, 106, // 53952-53959
107, 113, 137, 141, 159, 160, 146, 128, // 53960-53967
118, 135, 127, 123, 139, 146, 143, 152, // 53968-53975
159, 153, 127,  94,  76,  74,  70,  68, // 53976-53983
 96, 111, 128, 130, 128, 159, 147, 131, // 53984-53991
137, 149, 149, 141, 153, 161, 173, 156, // 53992-53999
138, 140, 117, 106, 100,  97, 112, 100, // 54000-54007
 89, 103, 121, 131, 134, 149, 138, 127, // 54008-54015
125, 119, 130, 116, 113, 111, 109, 131, // 54016-54023
138, 160, 151, 141, 130, 117, 132, 124, // 54024-54031
133, 145, 150, 148, 151, 166, 146, 128, // 54032-54039
100,  80,  78,  67,  76, 100, 111, 125, // 54040-54047
130, 131, 145, 143, 130, 134, 147, 141, // 54048-54055
142, 157, 156, 171, 158, 145, 138, 113, // 54056-54063
108, 101, 100, 105, 106, 101, 101, 122, // 54064-54071
128, 138, 146, 132, 126, 124, 120, 124, // 54072-54079
121, 124, 115, 111, 127, 140, 156, 142, // 54080-54087
139, 131, 116, 125, 121, 139, 144, 149, // 54088-54095
145, 148, 167, 140, 129, 108,  86,  81, // 54096-54103
 68,  86, 102, 114, 124, 133, 135, 131, // 54104-54111
139, 127, 130, 142, 136, 146, 158, 156, // 54112-54119
167, 161, 151, 133, 111, 106, 102, 101, // 54120-54127
100, 114, 111, 103, 120, 128, 143, 141, // 54128-54135
128, 125, 122, 122, 116, 125, 133, 121, // 54136-54143
114, 123, 143, 151, 137, 134, 130, 116, // 54144-54151
117, 123, 142, 145, 150, 145, 150, 163, // 54152-54159
135, 127, 112,  92,  82,  72,  94, 105, // 54160-54167
117, 122, 136, 138, 122, 135, 127, 128, // 54168-54175
136, 133, 150, 158, 156, 161, 167, 156, // 54176-54183
130, 112, 105, 103,  99,  96, 120, 118, // 54184-54191
105, 117, 129, 145, 135, 126, 123, 122, // 54192-54199
122, 111, 131, 138, 127, 116, 123, 145, // 54200-54207
143, 134, 131, 131, 118, 109, 126, 143, // 54208-54215
146, 148, 145, 151, 156, 133, 125, 117, // 54216-54223
 97,  80,  79,  99, 107, 117, 121, 139, // 54224-54231
137, 115, 131, 126, 128, 130, 134, 153, // 54232-54239
157, 157, 155, 169, 155, 125, 114, 105, // 54240-54247
106,  96,  98, 126, 124, 110, 115, 132, // 54248-54255
143, 130, 125, 121, 122, 119, 110, 134, // 54256-54263
141, 130, 116, 123, 142, 135, 132, 127, // 54264-54271
131, 118, 106, 131, 143, 148, 146, 147, // 54272-54279
151, 149, 134, 123, 121, 100,  82,  89, // 54280-54287
102, 110, 118, 123, 140, 134, 113, 126, // 54288-54295
128, 124, 124, 137, 153, 155, 155, 150, // 54296-54303
169, 152, 122, 114, 104, 108,  95, 103, // 54304-54311
129, 131, 115, 112, 133, 138, 127, 124, // 54312-54319
121, 124, 117, 115, 137, 145, 135, 117, // 54320-54327
122, 136, 127, 129, 125, 131, 119, 107, // 54328-54335
133, 144, 148, 144, 149, 147, 140, 135, // 54336-54343
120, 124, 104,  88,  99, 107, 113, 116, // 54344-54351
125, 136, 130, 112, 119, 129, 121, 123, // 54352-54359
143, 154, 158, 154, 149, 164, 149, 122, // 54360-54367
112, 107, 107,  96, 109, 129, 134, 120, // 54368-54375
112, 131, 129, 124, 123, 123, 124, 118, // 54376-54383
123, 134, 141, 136, 123, 126, 128, 126, // 54384-54391
129, 128, 130, 123, 120, 132, 137, 139, // 54392-54399
137, 141, 135, 130, 132, 123, 125, 114, // 54400-54407
108, 114, 117, 120, 122, 127, 129, 127, // 54408-54415
122, 123, 128, 123, 124, 132, 134, 137, // 54416-54423
136, 135, 138, 135, 128, 125, 123, 121, // 54424-54431
121, 124, 128, 131, 129, 126, 129, 127, // 54432-54439
128, 127, 124, 123, 121, 125, 125, 127, // 54440-54447
127, 125, 124, 124, 127, 129, 128, 128, // 54448-54455
126, 127, 128, 130, 132, 131, 131, 128, // 54456-54463
128, 131, 128, 128, 125, 122, 124, 123, // 54464-54471
126, 128, 129, 127, 127, 127, 126, 128, // 54472-54479
126, 126, 126, 123, 126, 127, 126, 127, // 54480-54487
127, 126, 126, 126, 125, 129, 129, 128, // 54488-54495
131, 132, 130, 128, 128, 131, 129, 124, // 54496-54503
124, 125, 126, 124, 126, 127, 125, 124, // 54504-54511
122, 127, 130, 129, 127, 127, 127, 126, // 54512-54519
127, 130, 129, 127, 123, 125, 127, 128, // 54520-54527
129, 127, 126, 125, 126, 128, 131, 131, // 54528-54535
128, 128, 128, 127, 129, 128, 127, 124, // 54536-54543
122, 124, 125, 124, 125, 127, 126, 125, // 54544-54551
126, 126, 129, 129, 128, 131, 131, 129, // 54552-54559
129, 129, 131, 130, 126, 125, 125, 125, // 54560-54567
125, 125, 127, 126, 124, 124, 126, 130, // 54568-54575
129, 126, 126, 126, 126, 127, 129, 129, // 54576-54583
128, 126, 127, 129, 129, 130, 129, 126, // 54584-54591
125, 126, 128, 130, 130, 128, 128, 128, // 54592-54599
126, 128, 127, 126, 124, 122, 123, 125, // 54600-54607
125, 126, 127, 127, 124, 125, 125, 127, // 54608-54615
128, 127, 129, 130, 131, 130, 132, 133, // 54616-54623
131, 128, 126, 126, 126, 125, 127, 127, // 54624-54631
125, 124, 124, 124, 127, 127, 125, 125, // 54632-54639
124, 124, 126, 129, 129, 129, 127, 127, // 54640-54647
129, 129, 131, 130, 127, 126, 126, 128, // 54648-54655
129, 130, 129, 129, 128, 125, 127, 127, // 54656-54663
125, 123, 122, 123, 124, 124, 125, 127, // 54664-54671
127, 125, 124, 125, 127, 128, 127, 130, // 54672-54679
131, 130, 129, 130, 132, 131, 128, 126, // 54680-54687
127, 126, 126, 128, 128, 127, 125, 124, // 54688-54695
125, 126, 126, 124, 124, 124, 124, 126, // 54696-54703
127, 128, 129, 127, 127, 127, 127, 129, // 54704-54711
130, 127, 127, 127, 128, 130, 131, 130, // 54712-54719
130, 128, 125, 126, 126, 127, 126, 124, // 54720-54727
124, 126, 125, 125, 127, 126, 124, 123, // 54728-54735
123, 125, 127, 127, 129, 131, 130, 129, // 54736-54743
130, 132, 131, 129, 126, 127, 127, 126, // 54744-54751
128, 129, 128, 125, 124, 124, 125, 126, // 54752-54759
124, 125, 125, 124, 125, 127, 129, 129, // 54760-54767
127, 126, 127, 127, 128, 130, 128, 127, // 54768-54775
127, 127, 129, 131, 130, 129, 128, 125, // 54776-54783
126, 127, 127, 127, 125, 125, 126, 126, // 54784-54791
126, 128, 127, 123, 123, 124, 125, 127, // 54792-54799
128, 129, 129, 130, 129, 129, 130, 130, // 54800-54807
128, 125, 126, 128, 127, 128, 129, 129, // 54808-54815
128, 125, 124, 124, 127, 124, 123, 125, // 54816-54823
125, 126, 126, 129, 130, 127, 124, 125, // 54824-54831
126, 127, 128, 128, 128, 128, 128, 130, // 54832-54839
133, 131, 128, 127, 125, 124, 124, 125, // 54840-54847
126, 125, 125, 127, 128, 127, 127, 127, // 54848-54855
125, 125, 123, 124, 128, 128, 128, 130, // 54856-54863
132, 130, 128, 128, 127, 127, 123, 125, // 54864-54871
127, 128, 128, 130, 131, 130, 127, 125, // 54872-54879
126, 126, 124, 123, 126, 126, 126, 126, // 54880-54887
128, 129, 127, 125, 125, 126, 125, 127, // 54888-54895
127, 127, 129, 128, 129, 132, 131, 128, // 54896-54903
128, 127, 125, 125, 126, 126, 126, 126, // 54904-54911
127, 128, 128, 127, 128, 125, 123, 123, // 54912-54919
123, 127, 127, 128, 130, 132, 129, 127, // 54920-54927
128, 128, 126, 124, 125, 128, 129, 129, // 54928-54935
131, 133, 130, 127, 126, 125, 125, 124, // 54936-54943
124, 127, 127, 126, 126, 128, 128, 127, // 54944-54951
124, 125, 124, 124, 126, 128, 127, 128, // 54952-54959
129, 129, 131, 131, 131, 130, 128, 125, // 54960-54967
125, 126, 126, 127, 127, 128, 128, 127, // 54968-54975
128, 128, 125, 122, 123, 123, 124, 127, // 54976-54983
128, 130, 132, 129, 127, 128, 126, 125, // 54984-54991
124, 125, 128, 128, 129, 132, 133, 130, // 54992-54999
129, 127, 125, 126, 126, 126, 126, 127, // 55000-55007
126, 126, 126, 126, 127, 125, 124, 125, // 55008-55015
124, 126, 127, 127, 128, 130, 128, 129, // 55016-55023
132, 132, 130, 129, 126, 126, 126, 125, // 55024-55031
128, 129, 129, 128, 128, 129, 128, 125, // 55032-55039
122, 124, 124, 124, 127, 129, 130, 130, // 55040-55047
128, 127, 127, 125, 124, 126, 127, 128, // 55048-55055
129, 129, 131, 131, 128, 129, 127, 125, // 55056-55063
126, 128, 128, 127, 127, 127, 126, 125, // 55064-55071
125, 127, 126, 125, 125, 126, 127, 126, // 55072-55079
127, 129, 130, 128, 127, 131, 132, 129, // 55080-55087
128, 128, 127, 127, 126, 127, 128, 128, // 55088-55095
125, 126, 127, 126, 124, 123, 125, 125, // 55096-55103
123, 127, 129, 130, 128, 129, 128, 126, // 55104-55111
125, 125, 127, 128, 129, 130, 131, 131, // 55112-55119
129, 128, 128, 126, 123, 125, 126, 128, // 55120-55127
126, 129, 129, 127, 124, 124, 126, 124, // 55128-55135
124, 123, 125, 127, 125, 128, 131, 130, // 55136-55143
127, 127, 130, 130, 129, 127, 128, 128, // 55144-55151
126, 127, 129, 131, 129, 126, 126, 126, // 55152-55159
124, 123, 123, 125, 124, 124, 127, 130, // 55160-55167
129, 128, 129, 127, 125, 125, 125, 128, // 55168-55175
127, 129, 130, 132, 130, 128, 128, 127, // 55176-55183
124, 122, 124, 126, 126, 126, 129, 131, // 55184-55191
127, 125, 125, 127, 126, 125, 124, 126, // 55192-55199
127, 126, 127, 130, 129, 126, 125, 127, // 55200-55207
128, 128, 126, 129, 129, 126, 129, 131, // 55208-55215
131, 129, 127, 127, 126, 124, 123, 125, // 55216-55223
125, 124, 124, 126, 129, 129, 128, 129, // 55224-55231
127, 125, 125, 127, 129, 128, 130, 131, // 55232-55239
132, 130, 128, 128, 126, 124, 122, 125, // 55240-55247
126, 126, 127, 130, 131, 128, 125, 126, // 55248-55255
126, 124, 124, 124, 126, 126, 126, 127, // 55256-55263
129, 129, 127, 126, 127, 127, 127, 127, // 55264-55271
130, 129, 127, 129, 130, 131, 129, 128, // 55272-55279
126, 125, 125, 124, 125, 126, 125, 125, // 55280-55287
126, 127, 127, 127, 128, 127, 126, 126, // 55288-55295
128, 128, 128, 130, 131, 130, 129, 127, // 55296-55303
127, 126, 126, 123, 126, 127, 127, 128, // 55304-55311
129, 130, 129, 125, 125, 124, 126, 123, // 55312-55319
140, 164, 149, 120,  85,  94,  40,  63, // 55320-55327
135, 175, 147, 102, 222, 229, 180, 100, // 55328-55335
 42, 107, 104, 101, 210,  11, 205, 128, // 55336-55343
128, 116,  23, 247, 230,   8, 252, 253, // 55344-55351
104, 143, 176, 155, 185, 199, 126,  88, // 55352-55359
 72, 155, 117,  36,  98, 136, 105, 113, // 55360-55367
202,  13, 234, 132, 120, 188, 201, 159, // 55368-55375
210, 238, 227, 211, 156,  21, 234,  39, // 55376-55383
203, 168, 186, 151, 231,  45, 106, 110, // 55384-55391
 86, 223, 217, 206, 161, 114, 165, 157, // 55392-55399
203,  15,  74,  19, 188, 197, 133,  52, // 55400-55407
 17,  10,  26, 252,  35, 115, 143, 163, // 55408-55415
141, 185, 162,  90,  72,  49, 128,  96, // 55416-55423
 51, 104, 129, 101,  81, 196, 221, 190, // 55424-55431
129,  97, 175, 166, 169, 225, 240, 224, // 55432-55439
201, 176, 233, 218,  62, 216, 189, 174, // 55440-55447
162,   0,  55, 103, 112,  98, 196, 178, // 55448-55455
188, 165, 125, 145, 153, 234,  10,  73, // 55456-55463
 24, 206, 205, 107,  53,  16,  28,  21, // 55464-55471
252,  73, 118, 145, 150, 149, 189, 137, // 55472-55479
 81,  71,  60, 112,  97,  94, 120, 139, // 55480-55487
104,  77, 194, 185, 165, 137,  96, 159, // 55488-55495
146, 190, 237, 245, 220, 197, 200, 186, // 55496-55503
201,  86, 237, 211, 164, 190,  18,  64, // 55504-55511
 95, 115, 118, 155, 148, 168, 169, 133, // 55512-55519
121, 161, 252,   8,  56,  24, 228, 196, // 55520-55527
 89,  53,  18,  41,  10,   7, 102, 120, // 55528-55535
143, 138, 161, 177, 112,  77,  70,  76, // 55536-55543
 88, 108, 133, 130, 146, 106,  87, 179, // 55544-55551
154, 148, 139, 104, 135, 137, 210, 242, // 55552-55559
247, 213, 198, 211, 144, 184, 107,   6, // 55560-55567
222, 162, 222,  27,  72,  85, 118, 134, // 55568-55575
113, 129, 150, 175, 136, 105, 178,   2, // 55576-55583
 10,  32,  28, 250, 175,  83,  53,  29, // 55584-55591
 46,   4,  28, 119, 124, 135, 132, 170, // 55592-55599
157,  97,  75,  70,  85,  63, 122, 163, // 55600-55607
138, 148, 110, 103, 150, 133, 133, 143, // 55608-55615
116, 108, 142, 223, 244, 245, 207, 208, // 55616-55623
206, 114, 166, 125,  34, 225, 177, 252, // 55624-55631
 32,  77,  75, 125, 139,  79, 115, 136, // 55632-55639
179, 131, 101, 195, 254,  12,   7,  35, // 55640-55647
  5, 155,  86,  52,  45,  41,   9,  52, // 55648-55655
126, 133, 123, 133, 172, 132,  90,  73, // 55656-55663
 76,  87,  50, 136, 182, 149, 145, 118, // 55664-55671
116, 117, 119, 122, 146, 125,  87, 154, // 55672-55679
226, 244, 238, 206, 218, 190, 102, 145, // 55680-55687
144,  59, 227, 206,  17,  39,  76,  73, // 55688-55695
131, 133,  57,  99, 126, 179, 126, 108, // 55696-55703
204, 247,  12, 241,  41,   3, 141,  92, // 55704-55711
 54,  59,  29,  25,  75, 127, 141, 110, // 55712-55719
140, 164, 112,  87,  74,  85,  83,  55, // 55720-55727
147, 193, 160, 138, 134, 121,  87, 111, // 55728-55735
113, 149, 128,  79, 166, 222, 243, 228, // 55736-55743
211, 219, 168, 100, 122, 158,  73, 235, // 55744-55751
243,  28,  48,  69,  78, 132, 120,  52, // 55752-55759
 83, 122, 170, 125, 124, 206, 241,   5, // 55760-55767
232,  39, 249, 136,  95,  59,  67,  20, // 55768-55775
 48,  89, 125, 148, 106, 147, 146, 100, // 55776-55783
 86,  78,  91,  72,  73, 151, 199, 170, // 55784-55791
134, 150, 115,  66, 102, 108, 147, 124, // 55792-55799
 86, 170, 216, 239, 218, 221, 211, 150, // 55800-55807
105, 106, 166,  84, 255,  19,  36,  57, // 55808-55815
 62,  90, 123, 104,  55,  68, 122, 152, // 55816-55823
131, 144, 202, 238, 248, 232,  25, 234, // 55824-55831
140,  98,  71,  65,  23,  71,  98, 121, // 55832-55839
146, 109, 145, 124,  95,  85,  85,  92, // 55840-55847
 68,  97, 146, 198, 175, 134, 161, 105, // 55848-55855
 56,  92, 110, 140, 121, 106, 165, 211, // 55856-55863
229, 211, 228, 196, 139, 108,  98, 165, // 55864-55871
 95,  31,  45,  44,  62,  56, 102, 108, // 55872-55879
 91,  62,  58, 121, 135, 146, 158, 195, // 55880-55887
233, 233, 241,   0, 220, 146, 100,  83, // 55888-55895
 59,  37,  87, 105, 118, 142, 122, 135, // 55896-55903
107,  91,  83,  93,  89,  72, 119, 144, // 55904-55911
197, 179, 143, 163,  95,  51,  79, 114, // 55912-55919
129, 121, 129, 160, 208, 217, 213, 230, // 55920-55927
178, 132, 106,  96, 151, 103,  62,  62, // 55928-55935
 55,  62,  60, 109,  92,  82,  66,  55, // 55936-55943
113, 119, 162, 169, 192, 225, 222, 249, // 55944-55951
227, 208, 153, 106,  92,  53,  57,  97, // 55952-55959
114, 115, 137, 141, 117,  95,  86,  84, // 55960-55967
 97,  80,  81, 132, 143, 187, 182, 158, // 55968-55975
157,  89,  51,  72, 118, 117, 128, 151, // 55976-55983
156, 200, 204, 218, 221, 162, 130, 106, // 55984-55991
101, 131, 119,  93,  77,  66,  60,  71, // 55992-55999
108,  77,  74,  71,  60,  97, 111, 175, // 56000-56007
177, 187, 213, 220, 249, 200, 197, 158, // 56008-56015
117,  95,  53,  81, 104, 123, 112, 137, // 56016-56023
154,  98,  85,  80,  88,  96,  75,  97, // 56024-56031
138, 146, 173, 185, 173, 143,  89,  51, // 56032-56039
 71, 117, 107, 140, 166, 156, 189, 196, // 56040-56047
223, 207, 153, 127, 108, 105, 111, 134, // 56048-56055
116,  88,  72,  58,  83,  97,  70,  68, // 56056-56063
 76,  68,  79, 113, 183, 184, 182, 202, // 56064-56071
222, 238, 181, 184, 164, 128,  93,  62, // 56072-56079
 99, 108, 127, 108, 139, 159,  84,  79, // 56080-56087
 79,  94,  91,  77, 114, 140, 149, 155, // 56088-56095
189, 179, 129,  92,  52,  72, 109, 103, // 56096-56103
150, 176, 158, 172, 193, 221, 189, 148, // 56104-56111
125, 115, 105,  98, 150, 135, 100,  76, // 56112-56119
 62,  92,  80,  64,  64,  82,  77,  66, // 56120-56127
121, 184, 191, 175, 194, 225, 219, 171, // 56128-56135
170, 170, 137,  91,  77, 110, 112, 125, // 56136-56143
107, 139, 155,  79,  72,  78,  98,  86, // 56144-56151
 88, 127, 142, 151, 143, 192, 178, 118, // 56152-56159
 97,  57,  75,  98, 108, 158, 182, 164, // 56160-56167
158, 194, 210, 174, 145, 126, 123, 102, // 56168-56175
 95, 159, 150, 110,  78,  70,  93,  66, // 56176-56183
 62,  62,  88,  80,  62, 128, 180, 194, // 56184-56191
167, 190, 222, 197, 166, 156, 175, 142, // 56192-56199
 95,  97, 117, 118, 120, 112, 137, 144, // 56200-56207
 80,  65,  83,  96,  83, 102, 135, 143, // 56208-56215
149, 137, 189, 171, 113,  99,  65,  76, // 56216-56223
 87, 117, 161, 184, 168, 148, 192, 193, // 56224-56231
162, 144, 129, 129,  98, 101, 161, 161, // 56232-56239
119,  81,  82,  88,  60,  61,  63,  92, // 56240-56247
 80,  65, 128, 174, 193, 162, 189, 215, // 56248-56255
183, 165, 150, 179, 144, 101, 113, 121, // 56256-56263
123, 113, 121, 132, 132,  88,  62,  88, // 56264-56271
 90,  85, 114, 140, 145, 144, 138, 178, // 56272-56279
163, 112,  99,  77,  72,  81, 128, 160, // 56280-56287
182, 167, 145, 188, 180, 159, 145, 135, // 56288-56295
131,  97, 112, 159, 167, 125,  87,  92, // 56296-56303
 78,  57,  59,  67,  88,  78,  77, 125, // 56304-56311
168, 188, 160, 187, 199, 171, 163, 146, // 56312-56319
173, 142, 113, 124, 124, 126, 112, 133, // 56320-56327
124, 124, 100,  62,  92,  84,  91, 122, // 56328-56335
141, 144, 137, 145, 164, 155, 114,  99, // 56336-56343
 88,  65,  81, 135, 160, 180, 168, 149, // 56344-56351
177, 166, 153, 141, 137, 126, 100, 123, // 56352-56359
154, 169, 129,  97,  96,  71,  58,  60, // 56360-56367
 75,  86,  83,  96, 124, 165, 181, 165, // 56368-56375
183, 182, 162, 158, 147, 163, 143, 129, // 56376-56383
131, 126, 124, 112, 137, 114, 115, 107, // 56384-56391
 67,  87,  80, 102, 128, 141, 142, 135, // 56392-56399
151, 145, 146, 119, 103,  96,  61,  90, // 56400-56407
141, 162, 175, 168, 158, 160, 153, 147, // 56408-56415
143, 140, 121, 108, 130, 150, 166, 133, // 56416-56423
108,  94,  63,  59,  62,  82,  82,  89, // 56424-56431
109, 119, 157, 173, 171, 175, 170, 160, // 56432-56439
157, 152, 151, 148, 144, 135, 129, 120, // 56440-56447
118, 136, 106, 108, 112,  77,  80,  81, // 56448-56455
111, 131, 142, 139, 137, 153, 129, 141, // 56456-56463
123, 108,  99,  61,  97, 138, 161, 166, // 56464-56471
169, 164, 143, 147, 145, 147, 143, 121, // 56472-56479
123, 136, 150, 162, 140, 120,  90,  61, // 56480-56487
 59,  64,  82,  74,  95, 118, 118, 147, // 56488-56495
166, 178, 162, 159, 156, 153, 154, 138, // 56496-56503
154, 156, 141, 132, 121, 126, 129, 102, // 56504-56511
100, 115,  87,  71,  86, 119, 135, 143, // 56512-56519
139, 142, 151, 119, 132, 126, 113,  99, // 56520-56527
 68, 102, 136, 159, 159, 171, 166, 129, // 56528-56535
139, 140, 148, 138, 122, 134, 137, 151, // 56536-56543
156, 150, 129,  86,  64,  59,  69,  80, // 56544-56551
 74, 103, 124, 122, 138, 165, 179, 150, // 56552-56559
150, 152, 152, 154, 131, 159, 163, 146, // 56560-56567
134, 123, 132, 120, 101,  94, 119,  98, // 56568-56575
 66,  94, 121, 136, 140, 139, 146, 142, // 56576-56583
115, 123, 131, 117,  99,  81, 106, 134, // 56584-56591
155, 155, 173, 164, 123, 132, 138, 148, // 56592-56599
134, 127, 143, 139, 150, 150, 156, 131, // 56600-56607
 85,  66,  61,  73,  75,  79, 109, 127, // 56608-56615
124, 127, 163, 175, 142, 143, 150, 153, // 56616-56623
149, 131, 162, 168, 149, 132, 127, 133, // 56624-56631
112, 102,  92, 119, 104,  68, 102, 124, // 56632-56639
138, 138, 142, 148, 134, 114, 115, 135, // 56640-56647
118,  99,  94, 106, 133, 148, 153, 170, // 56648-56655
157, 120, 125, 139, 147, 133, 136, 148, // 56656-56663
141, 147, 148, 159, 130,  86,  69,  65, // 56664-56671
 76,  73,  87, 113, 129, 126, 123, 162, // 56672-56679
167, 137, 137, 148, 152, 144, 137, 162, // 56680-56687
172, 152, 131, 132, 127, 105, 100,  92, // 56688-56695
118, 108,  76, 108, 126, 138, 135, 145, // 56696-56703
146, 126, 115, 111, 135, 119, 105, 106, // 56704-56711
105, 131, 142, 156, 164, 151, 122, 119, // 56712-56719
138, 139, 133, 143, 151, 144, 145, 152, // 56720-56727
158, 128,  90,  71,  68,  73,  70,  94, // 56728-56735
113, 129, 128, 123, 156, 158, 135, 132, // 56736-56743
147, 148, 141, 146, 160, 172, 154, 135, // 56744-56751
135, 122, 104, 102,  95, 112, 111,  88, // 56752-56759
109, 127, 137, 137, 150, 141, 122, 118, // 56760-56767
109, 130, 116, 109, 113, 106, 126, 137, // 56768-56775
157, 157, 145, 124, 116, 138, 134, 138, // 56776-56783
149, 155, 148, 142, 156, 156, 128,  94, // 56784-56791
 75,  74,  70,  72,  99, 113, 126, 126, // 56792-56799
125, 150, 150, 134, 129, 148, 145, 141, // 56800-56807
152, 159, 172, 155, 140, 137, 117, 102, // 56808-56815
 99,  99, 108, 113, 100, 110, 128, 133, // 56816-56823
140, 150, 137, 119, 117, 112, 127, 116, // 56824-56831
115, 119, 107, 119, 132, 154, 148, 139, // 56832-56839
126, 118, 136, 132, 144, 154, 156, 149, // 56840-56847
142, 159, 148, 127, 100,  80,  78,  68, // 56848-56855
 79, 101, 114, 123, 127, 128, 138, 142, // 56856-56863
133, 128, 147, 142, 144, 160, 157, 169, // 56864-56871
157, 145, 134, 112, 102, 100, 104, 102, // 56872-56879
118, 114, 110, 127, 129, 142, 145, 130, // 56880-56887
119, 116, 114, 117, 120, 123, 123, 109, // 56888-56895
114, 133, 150, 140, 135, 130, 120, 131, // 56896-56903
132, 150, 158, 157, 149, 142, 158, 141, // 56904-56911
125, 105,  87,  81,  70,  88, 104, 115, // 56912-56919
119, 128, 132, 127, 136, 131, 128, 143, // 56920-56927
138, 148, 161, 155, 162, 158, 150, 131, // 56928-56935
110, 103, 102, 105,  97, 122, 124, 111, // 56936-56943
124, 127, 145, 142, 127, 119, 119, 119, // 56944-56951
112, 126, 131, 127, 112, 109, 134, 143, // 56952-56959
133, 130, 131, 124, 123, 132, 152, 159, // 56960-56967
156, 147, 144, 154, 136, 124, 110,  94, // 56968-56975
 82,  74,  93, 106, 116, 116, 129, 133, // 56976-56983
118, 132, 132, 132, 139, 139, 153, 163, // 56984-56991
156, 155, 160, 151, 125, 109, 102, 105, // 56992-56999
106,  96, 125, 132, 112, 120, 127, 145, // 57000-57007
136, 125, 120, 121, 122, 109, 131, 137, // 57008-57015
130, 114, 108, 134, 134, 129, 127, 132, // 57016-57023
125, 116, 135, 153, 159, 154, 146, 147, // 57024-57031
148, 133, 123, 116, 101,  83,  82, 100, // 57032-57039
108, 116, 115, 130, 132, 111, 126, 133, // 57040-57047
133, 132, 140, 155, 160, 156, 149, 163, // 57048-57055
152, 122, 111, 103, 107, 102,  98, 127, // 57056-57063
136, 116, 116, 131, 143, 131, 124, 120, // 57064-57071
123, 119, 107, 133, 139, 132, 116, 110, // 57072-57079
133, 129, 129, 125, 134, 126, 111, 138, // 57080-57087
151, 157, 150, 147, 149, 140, 133, 122, // 57088-57095
120, 104,  84,  92, 103, 110, 116, 118, // 57096-57103
133, 130, 111, 122, 134, 130, 126, 142, // 57104-57111
155, 156, 154, 145, 164, 149, 121, 112, // 57112-57119
107, 110, 101, 104, 127, 139, 120, 113, // 57120-57127
133, 138, 128, 122, 120, 124, 116, 111, // 57128-57135
133, 142, 135, 118, 114, 129, 123, 127, // 57136-57143
125, 134, 127, 114, 138, 150, 156, 147, // 57144-57151
149, 146, 132, 132, 120, 124, 107,  89, // 57152-57159
 99, 105, 113, 114, 121, 131, 126, 112, // 57160-57167
115, 133, 128, 122, 144, 153, 156, 152, // 57168-57175
145, 161, 147, 123, 113, 110, 110, 101, // 57176-57183
111, 126, 140, 125, 113, 131, 130, 126, // 57184-57191
120, 122, 124, 116, 119, 129, 139, 133, // 57192-57199
122, 121, 124, 126, 127, 127, 132, 129, // 57200-57207
124, 133, 140, 144, 139, 141, 137, 129, // 57208-57215
130, 125, 126, 118, 110, 113, 114, 118, // 57216-57223
118, 124, 126, 125, 123, 123, 132, 129, // 57224-57231
126, 132, 134, 136, 133, 133, 136, 134, // 57232-57239
127, 124, 126, 125, 123, 124, 126, 131, // 57240-57247
128, 124, 130, 131, 130, 127, 126, 127, // 57248-57255
124, 122, 121, 125, 125, 123, 123, 123, // 57256-57263
126, 127, 128, 129, 129, 129, 127, 130, // 57264-57271
132, 133, 132, 130, 130, 129, 129, 128, // 57272-57279
126, 123, 122, 122, 122, 125, 128, 128, // 57280-57287
127, 127, 127, 130, 128, 126, 125, 126, // 57288-57295
127, 126, 127, 129, 129, 126, 125, 127, // 57296-57303
126, 125, 125, 125, 128, 130, 130, 131, // 57304-57311
132, 132, 129, 128, 127, 126, 123, 121, // 57312-57319
123, 123, 124, 125, 124, 126, 127, 127, // 57320-57327
127, 128, 129, 127, 128, 130, 133, 133, // 57328-57335
130, 131, 129, 129, 129, 126, 125, 123, // 57336-57343
123, 123, 126, 127, 128, 128, 128, 128, // 57344-57351
128, 128, 126, 125, 124, 125, 126, 127, // 57352-57359
128, 127, 127, 126, 126, 127, 127, 126, // 57360-57367
125, 127, 130, 132, 131, 132, 132, 130, // 57368-57375
128, 126, 126, 124, 121, 122, 124, 124, // 57376-57383
125, 124, 125, 127, 126, 125, 126, 128, // 57384-57391
128, 128, 129, 132, 131, 129, 129, 129, // 57392-57399
128, 128, 127, 126, 125, 125, 125, 128, // 57400-57407
128, 127, 127, 127, 127, 127, 127, 127, // 57408-57415
125, 123, 124, 126, 127, 128, 128, 128, // 57416-57423
126, 125, 125, 126, 127, 124, 126, 129, // 57424-57431
131, 131, 130, 132, 129, 127, 125, 127, // 57432-57439
126, 125, 126, 127, 127, 127, 125, 125, // 57440-57447
125, 125, 124, 125, 126, 125, 127, 129, // 57448-57455
131, 131, 128, 130, 130, 128, 129, 128, // 57456-57463
127, 125, 125, 126, 127, 128, 127, 128, // 57464-57471
127, 126, 127, 127, 127, 125, 123, 125, // 57472-57479
127, 127, 127, 129, 128, 127, 126, 125, // 57480-57487
125, 125, 126, 126, 128, 130, 130, 131, // 57488-57495
131, 129, 128, 127, 127, 126, 127, 128, // 57496-57503
128, 128, 126, 125, 125, 124, 125, 123, // 57504-57511
124, 125, 125, 127, 128, 129, 130, 129, // 57512-57519
128, 128, 128, 129, 130, 128, 127, 127, // 57520-57527
126, 127, 128, 128, 128, 128, 126, 127, // 57528-57535
127, 126, 125, 125, 125, 126, 127, 127, // 57536-57543
128, 127, 126, 124, 124, 125, 124, 125, // 57544-57551
127, 128, 129, 129, 131, 131, 129, 129, // 57552-57559
128, 128, 127, 129, 128, 129, 127, 126, // 57560-57567
126, 125, 125, 124, 125, 125, 125, 126, // 57568-57575
127, 128, 127, 127, 129, 127, 128, 128, // 57576-57583
129, 129, 128, 126, 127, 126, 127, 126, // 57584-57591
128, 129, 127, 126, 128, 129, 127, 126, // 57592-57599
127, 127, 126, 126, 128, 129, 127, 126, // 57600-57607
125, 125, 124, 124, 125, 127, 126, 126, // 57608-57615
128, 130, 130, 128, 128, 129, 128, 127, // 57616-57623
128, 129, 128, 126, 125, 126, 126, 125, // 57624-57631
125, 126, 126, 124, 124, 127, 128, 126, // 57632-57639
127, 129, 128, 128, 128, 130, 130, 127, // 57640-57647
126, 126, 126, 124, 126, 126, 128, 127, // 57648-57655
127, 129, 130, 128, 127, 127, 128, 126, // 57656-57663
125, 128, 129, 126, 126, 127, 127, 125, // 57664-57671
124, 124, 127, 125, 125, 127, 129, 128, // 57672-57679
126, 129, 129, 129, 126, 127, 130, 127, // 57680-57687
127, 126, 127, 128, 126, 127, 127, 128, // 57688-57695
125, 125, 127, 127, 126, 125, 127, 127, // 57696-57703
126, 128, 130, 129, 127, 126, 127, 127, // 57704-57711
127, 127, 127, 128, 126, 127, 130, 129, // 57712-57719
127, 126, 127, 127, 126, 127, 128, 130, // 57720-57727
126, 127, 128, 127, 126, 125, 125, 127, // 57728-57735
125, 125, 126, 129, 127, 126, 128, 128, // 57736-57743
128, 127, 129, 130, 127, 126, 127, 127, // 57744-57751
128, 128, 128, 127, 127, 125, 126, 128, // 57752-57759
127, 126, 126, 126, 127, 127, 130, 128, // 57760-57767
127, 126, 126, 127, 126, 127, 127, 125, // 57768-57775
126, 126, 128, 129, 130, 127, 127, 128, // 57776-57783
127, 127, 129, 128, 128, 126, 127, 128, // 57784-57791
127, 127, 126, 126, 125, 126, 126, 126, // 57792-57799
128, 127, 128, 128, 126, 128, 128, 129, // 57800-57807
128, 128, 127, 126, 126, 127, 128, 127, // 57808-57815
125, 126, 126, 126, 128, 128, 128, 127, // 57816-57823
126, 127, 128, 130, 128, 127, 126, 125, // 57824-57831
125, 126, 127, 126, 124, 125, 127, 129, // 57832-57839
129, 129, 129, 128, 128, 128, 129, 129, // 57840-57847
128, 127, 127, 127, 127, 127, 126, 125, // 57848-57855
124, 124, 126, 127, 125, 128, 128, 128, // 57856-57863
128, 127, 129, 129, 128, 127, 128, 127, // 57864-57871
126, 126, 127, 128, 127, 125, 126, 127, // 57872-57879
127, 128, 129, 129, 127, 125, 128, 129, // 57880-57887
130, 128, 127, 126, 125, 125, 125, 127, // 57888-57895
126, 124, 125, 126, 129, 129, 130, 129, // 57896-57903
127, 127, 128, 129, 129, 128, 127, 128, // 57904-57911
128, 127, 127, 127, 126, 124, 123, 125, // 57912-57919
126, 125, 127, 128, 128, 127, 127, 128, // 57920-57927
128, 127, 127, 128, 127, 126, 126, 127, // 57928-57935
130, 129, 125, 125, 127, 126, 128, 129, // 57936-57943
129, 127, 126, 126, 130, 130, 128, 127, // 57944-57951
125, 125, 125, 125, 127, 126, 123, 124, // 57952-57959
126, 129, 130, 130, 129, 127, 126, 126, // 57960-57967
128, 130, 128, 128, 128, 129, 127, 127, // 57968-57975
128, 126, 124, 123, 124, 125, 126, 126, // 57976-57983
129, 128, 128, 127, 128, 128, 128, 126, // 57984-57991
126, 126, 125, 126, 128, 130, 130, 128, // 57992-57999
127, 127, 128, 127, 129, 128, 128, 127, // 58000-58007
127, 129, 130, 130, 127, 125, 123, 123, // 58008-58015
123, 124, 126, 124, 123, 124, 127, 129, // 58016-58023
130, 129, 128, 127, 127, 128, 129, 130, // 58024-58031
130, 128, 129, 129, 129, 129, 128, 125, // 58032-58039
124, 122, 124, 125, 126, 128, 128, 129, // 58040-58047
127, 126, 127, 128, 126, 124, 125, 126, // 58048-58055
126, 127, 129, 130, 128, 126, 126, 127, // 58056-58063
128, 128, 130, 129, 128, 128, 128, 130, // 58064-58071
130, 128, 125, 124, 124, 123, 124, 125, // 58072-58079
124, 123, 123, 127, 129, 130, 129, 129, // 58080-58087
128, 125, 126, 129, 130, 129, 128, 129, // 58088-58095
131, 128, 129, 127, 126, 123, 121, 123, // 58096-58103
126, 128, 127, 130, 130, 127, 126, 128, // 58104-58111
127, 126, 124, 126, 125, 127, 125, 129, // 58112-58119
128, 127, 126, 126, 127, 128, 127, 128, // 58120-58127
130, 128, 129, 128, 135, 153, 158, 117, // 58128-58135
 99,  71,  28, 105, 152, 102, 161, 248, // 58136-58143
202,  65, 103, 129, 112, 212, 221, 163, // 58144-58151
129, 146, 102,  20,  10,  26,   1,  41, // 58152-58159
127, 146, 139, 179, 158, 145, 102,  51, // 58160-58167
 16, 209,  66, 172, 221, 218, 241, 232, // 58168-58175
201, 213, 160, 145, 161,  44,  16, 142, // 58176-58183
 95, 247, 196, 205, 239, 191,  10, 157, // 58184-58191
219, 212, 220, 245, 177, 226, 231, 118, // 58192-58199
109, 152, 144, 139, 167, 145,  72,  64, // 58200-58207
 69,  36,  53, 133, 147, 162, 252, 169, // 58208-58215
 72,   2, 228,   4,  72, 171, 169, 225, // 58216-58223
 35,  55, 216, 168, 145, 117, 194, 150, // 58224-58231
 98,  34,  44,  64,  23, 248, 223,  13, // 58232-58239
 67, 157, 175, 213,  16,  49,  59, 207, // 58240-58247
133,  92,  36,  66, 128, 143, 151, 175, // 58248-58255
154,  80,  64,  58,  33,  43, 170, 197, // 58256-58263
129, 154,  80,  28,  61, 124,  79,  80, // 58264-58271
220,  21,  23,  20,  25, 160, 180, 200, // 58272-58279
 36, 211, 235,  38,  27,  82,  93,  36, // 58280-58287
 58, 130, 110,  65, 180,   0,  31,  68, // 58288-58295
 26, 182,  89,  68,  58,  20,  74, 135, // 58296-58303
141, 148, 176, 149,  81,  64,  71, 105, // 58304-58311
 75, 116, 109,  59, 141, 183, 150,  81, // 58312-58319
130, 148, 166, 223, 248, 219, 219,  58, // 58320-58327
173,  21, 235, 198, 193,   8,  89,  57, // 58328-58335
107, 204, 191, 101, 126, 165, 145, 239, // 58336-58343
 28, 211, 178, 179, 135,  63,  63,  75, // 58344-58351
 28,  69, 135, 147, 142, 177, 145, 114, // 58352-58359
123,  67,  33, 244,  65, 141, 184, 210, // 58360-58367
181, 180, 174, 196, 149, 147, 163, 243, // 58368-58375
 16, 167, 107,   5, 217, 224, 238, 232, // 58376-58383
 18, 126, 188, 202, 199, 207, 173, 196, // 58384-58391
224, 150, 134, 163, 145, 149, 162, 147, // 58392-58399
 80,  59,  68,  40,  71, 130, 145, 139, // 58400-58407
224, 177,  80,  42, 252,  17,  73, 177, // 58408-58415
167, 184,   7,  18, 205, 160, 155, 103, // 58416-58423
177, 189, 115,  58,  56,  74,  21,  15, // 58424-58431
  6,   5,  62, 154, 175, 185, 252,  16, // 58432-58439
  4, 214, 147, 100,  52,  83, 129, 130, // 58440-58447
157, 157, 130,  79,  77,  75,  53,  72, // 58448-58455
152, 205, 151, 163,  95,  31,  64, 107, // 58456-58463
 95,  75, 185, 238, 247, 254, 247, 152, // 58464-58471
146, 203,  80,   0,  19,  55,  50,  88, // 58472-58479
116,  45,  46, 118, 110,  76, 165, 239, // 58480-58487
241,  38,  25, 173, 102,  82,  72,  31, // 58488-58495
 89, 146, 123, 142, 164, 142,  82,  81, // 58496-58503
 68,  91, 110, 125, 119,  68, 134, 157, // 58504-58511
141, 104, 111, 136, 161, 223, 232, 216, // 58512-58519
203,  11, 191,  57,  13, 220, 222,  24, // 58520-58527
 90,  75,  92, 163, 162, 105, 118, 154, // 58528-58535
144, 213,  24, 219, 185, 179, 130,  75, // 58536-58543
 65,  89,  40,  70, 131, 138, 145, 167, // 58544-58551
142,  94, 134,  93,  51,  28,  72, 134, // 58552-58559
165, 213, 166, 144, 159, 176, 143, 143, // 58560-58567
169, 199, 250, 192, 118,  28, 245,   2, // 58568-58575
253,  15,  51, 108, 167, 195, 187, 177, // 58576-58583
169, 174, 194, 166, 147, 162, 137, 145, // 58584-58591
147, 129,  93,  60,  70,  50,  92, 136, // 58592-58599
148, 140, 197, 187,  91,  67,  17,  26, // 58600-58607
 81, 169, 174, 158, 229, 235, 186, 155, // 58608-58615
155, 104, 153, 208, 139,  81,  76,  82, // 58616-58623
 32,  26,  37,   8,  51, 147, 166, 167, // 58624-58631
229, 252, 216, 206, 168, 112,  74,  98, // 58632-58639
137, 122, 163, 156, 113,  82,  83,  82, // 58640-58647
 58,  90, 133, 184, 162, 160, 103,  33, // 58648-58655
 74, 101, 109,  96, 164, 214, 224, 242, // 58656-58663
224, 154, 131, 187, 115,  40,  51,  61, // 58664-58671
 61,  87, 113,  57,  39, 106, 110,  87, // 58672-58679
161, 229, 221,   3,  19, 173, 109,  89, // 58680-58687
 76,  45,  91, 151, 113, 133, 156, 134, // 58688-58695
 88,  94,  82,  82, 134, 141, 129,  86, // 58696-58703
128, 145, 130, 125, 102, 117, 150, 205, // 58704-58711
208, 201, 195, 218, 188,  92,  43, 248, // 58712-58719
252,  49,  87,  95,  97, 135, 147, 112, // 58720-58727
120, 144, 151, 193, 252, 220, 181, 171, // 58728-58735
117,  85,  70,  95,  66,  76, 133, 135, // 58736-58743
149, 160, 140,  89, 126, 111,  66,  58, // 58744-58751
 74, 123, 148, 201, 161, 120, 147, 162, // 58752-58759
143, 148, 180, 182, 224, 212, 132,  51, // 58760-58767
 15,  25,   8,  31,  72,  87, 139, 181, // 58768-58775
170, 155, 163, 170, 169, 176, 165, 164, // 58776-58783
139, 144, 146, 117, 111,  73,  68,  63, // 58784-58791
100, 136, 140, 143, 166, 172, 104,  85, // 58792-58799
 38,  33,  93, 157, 177, 150, 196, 207, // 58800-58807
172, 155, 152, 113, 138, 204, 155,  99, // 58808-58815
 91,  82,  45,  36,  57,  26,  47, 143, // 58816-58823
160, 157, 207, 234, 192, 188, 181, 120, // 58824-58831
 90, 104, 134, 114, 154, 159,  94,  82, // 58832-58839
 87,  91,  74, 110, 135, 163, 172, 161, // 58840-58847
114,  45,  81, 101, 112, 117, 145, 185, // 58848-58855
201, 222, 198, 150, 129, 164, 135,  78, // 58856-58863
 80,  77,  77,  96, 108,  72,  40,  91, // 58864-58871
107,  92, 149, 203, 207, 226, 252, 177, // 58872-58879
118, 102,  82,  70,  99, 160, 119, 122, // 58880-58887
148, 126,  98, 102,  96,  78, 134, 149, // 58888-58895
130,  97, 115, 132, 114, 132, 105, 105, // 58896-58903
148, 195, 198, 190, 191, 189, 176, 122, // 58904-58911
 71,  23,  23,  70,  89, 102, 108, 111, // 58912-58919
126, 110, 113, 132, 153, 187, 226, 224, // 58920-58927
187, 170, 116,  94,  81,  93,  87,  78, // 58928-58935
123, 125, 145, 153, 135,  95, 113, 124, // 58936-58943
 88,  89,  89, 121, 145, 185, 164, 112, // 58944-58951
136, 152, 138, 145, 173, 168, 192, 208, // 58952-58959
141,  64,  36,  41,  31,  49,  97,  93, // 58960-58967
122, 171, 158, 142, 153, 169, 153, 171, // 58968-58975
180, 164, 140, 139, 144, 104, 113,  86, // 58976-58983
 64,  75, 108, 142, 138, 150, 153, 156, // 58984-58991
121, 101,  60,  38,  98, 145, 168, 151, // 58992-58999
169, 181, 155, 151, 144, 119, 137, 193, // 59000-59007
171, 118, 106,  87,  59,  53,  69,  50, // 59008-59015
 49, 131, 149, 144, 188, 210, 176, 167, // 59016-59023
183, 132, 107, 117, 136, 119, 143, 164, // 59024-59031
 93,  83,  94,  95,  84, 116, 138, 142, // 59032-59039
171, 163, 117,  53,  79, 102, 107, 134, // 59040-59047
145, 167, 188, 206, 183, 144, 132, 147, // 59048-59055
137, 103,  96,  87,  84, 105, 103,  82, // 59056-59063
 56,  80, 106, 101, 149, 189, 200, 209, // 59064-59071
229, 183, 128, 111,  84,  80,  97, 148, // 59072-59079
125, 112, 138, 115, 100, 100, 104,  87, // 59080-59087
135, 164, 142, 115, 114, 127, 111, 132, // 59088-59095
116,  97, 140, 181, 184, 179, 183, 172, // 59096-59103
156, 134,  89,  46,  47,  84,  96, 106, // 59104-59111
123, 105, 114, 114, 111, 123, 146, 180, // 59112-59119
198, 212, 191, 166, 114,  93,  85,  83, // 59120-59127
104,  94, 119, 128, 146, 154, 132, 110, // 59128-59135
111, 124, 103, 102,  96, 112, 141, 167, // 59136-59143
159, 114, 123, 140, 132, 146, 167, 162, // 59144-59151
178, 198, 151,  82,  59,  54,  45,  60, // 59152-59159
107, 105, 111, 164, 151, 133, 145, 161, // 59160-59167
144, 160, 188, 162, 142, 138, 139,  98, // 59168-59175
110, 103,  63,  76, 110, 138, 136, 155, // 59176-59183
154, 143, 128, 111,  76,  52, 104, 142, // 59184-59191
161, 164, 163, 165, 151, 149, 140, 115, // 59192-59199
130, 172, 167, 129, 114,  93,  65,  63, // 59200-59207
 72,  67,  60, 123, 149, 143, 181, 195, // 59208-59215
173, 158, 175, 139, 112, 122, 130, 121, // 59216-59223
132, 161, 100,  79,  96,  93,  92, 120, // 59224-59231
143, 138, 164, 168, 125,  74,  83, 100, // 59232-59239
103, 136, 144, 149, 176, 193, 174, 140, // 59240-59247
129, 135, 130, 120, 110,  98,  95, 113, // 59248-59255
107,  93,  79,  77, 102, 105, 141, 173, // 59256-59263
187, 197, 200, 178, 133, 116,  88,  87, // 59264-59271
101, 136, 137, 115, 132, 116, 108, 110, // 59272-59279
107,  97, 127, 159, 147, 129, 117, 120, // 59280-59287
113, 127, 122,  97, 130, 169, 171, 174, // 59288-59295
174, 159, 145, 137, 102,  62,  65,  89, // 59296-59303
101, 108, 131, 107, 104, 119, 111, 120, // 59304-59311
143, 178, 183, 197, 195, 164, 122, 100, // 59312-59319
 95,  81, 108, 105, 105, 122, 138, 146, // 59320-59327
124, 113, 109, 116, 115, 119, 110, 112, // 59328-59335
142, 160, 155, 123, 117, 132, 131, 147, // 59336-59343
162, 156, 168, 181, 152,  95,  72,  62, // 59344-59351
 53,  71, 108, 114, 107, 154, 147, 128, // 59352-59359
142, 154, 144, 150, 185, 168, 148, 142, // 59360-59367
136, 101, 105, 115,  67,  75, 111, 133, // 59368-59375
135, 149, 152, 133, 130, 125,  93,  69, // 59376-59383
107, 138, 149, 162, 153, 142, 139, 140, // 59384-59391
134, 115, 132, 163, 163, 142, 124, 102, // 59392-59399
 74,  77,  80,  83,  82, 115, 146, 141, // 59400-59407
170, 177, 162, 150, 160, 143, 119, 129, // 59408-59415
128, 123, 127, 152, 109,  77,  94,  93, // 59416-59423
 99, 124, 143, 138, 158, 169, 134,  90, // 59424-59431
 89, 102, 103, 136, 150, 138, 161, 179, // 59432-59439
163, 139, 130, 132, 125, 130, 120, 103, // 59440-59447
101, 110, 103,  89,  93,  78,  95, 113, // 59448-59455
139, 168, 178, 193, 184, 173, 144, 123, // 59456-59463
 99,  97, 110, 129, 143, 118, 119, 111, // 59464-59471
106, 110, 104, 103, 124, 153, 152, 137, // 59472-59479
121, 115, 113, 121, 124, 107, 124, 161, // 59480-59487
163, 171, 168, 152, 141, 135, 115,  75, // 59488-59495
 79,  95, 104, 110, 131, 116,  97, 119, // 59496-59503
113, 121, 141, 171, 172, 179, 191, 160, // 59504-59511
122, 102,  98,  81, 107, 118, 105, 119, // 59512-59519
138, 146, 125, 118, 116, 114, 125, 133, // 59520-59527
120, 114, 138, 150, 140, 124, 112, 118, // 59528-59535
125, 143, 162, 153, 165, 173, 151, 108, // 59536-59543
 82,  72,  60,  82, 108, 122, 112, 142, // 59544-59551
144, 125, 142, 147, 141, 143, 179, 172, // 59552-59559
150, 144, 132, 105, 100, 116,  79,  76, // 59560-59567
112, 130, 134, 146, 149, 128, 128, 133, // 59568-59575
103,  80, 107, 136, 143, 157, 154, 131, // 59576-59583
133, 137, 135, 124, 137, 161, 156, 150, // 59584-59591
129, 102,  76,  79,  81,  84,  94, 111, // 59592-59599
141, 143, 164, 169, 155, 147, 151, 150, // 59600-59607
131, 134, 127, 123, 124, 137, 115,  80, // 59608-59615
 90,  94, 105, 129, 145, 144, 155, 166, // 59616-59623
139,  98,  91,  99, 107, 132, 149, 135, // 59624-59631
147, 166, 152, 139, 130, 131, 127, 137, // 59632-59639
134, 111, 107, 109, 103,  90,  98,  87, // 59640-59647
 95, 120, 139, 163, 171, 183, 169, 161, // 59648-59655
148, 123, 102, 101, 115, 123, 141, 127, // 59656-59663
110, 105, 105, 113, 110, 115, 132, 150, // 59664-59671
156, 142, 120, 107, 110, 117, 120, 115, // 59672-59679
124, 152, 159, 168, 167, 146, 138, 133, // 59680-59687
123,  92,  89,  98, 102, 108, 124, 117, // 59688-59695
 94, 114, 115, 120, 145, 168, 171, 173, // 59696-59703
188, 159, 122, 105, 101,  89, 107, 129, // 59704-59711
109, 112, 129, 135, 123, 119, 121, 116, // 59712-59719
129, 142, 127, 116, 132, 142, 132, 128, // 59720-59727
116, 114, 127, 144, 160, 150, 158, 162, // 59728-59735
144, 117,  92,  81,  72,  91, 109, 122, // 59736-59743
119, 130, 137, 122, 138, 146, 145, 147, // 59744-59751
169, 170, 146, 137, 124, 104, 100, 117, // 59752-59759
 96,  84, 113, 128, 135, 145, 146, 127, // 59760-59767
124, 136, 116,  95, 110, 131, 137, 149, // 59768-59775
150, 124, 125, 135, 137, 131, 140, 159, // 59776-59783
150, 150, 133, 103,  82,  83,  86,  87, // 59784-59791
104, 111, 130, 138, 152, 161, 151, 150, // 59792-59799
145, 147, 140, 137, 128, 121, 125, 131, // 59800-59807
121,  93,  93, 100, 110, 131, 140, 140, // 59808-59815
144, 150, 139, 109,  99, 100, 111, 131, // 59816-59823
147, 135, 136, 154, 144, 139, 133, 135, // 59824-59831
130, 134, 140, 117, 108, 106, 102,  93, // 59832-59839
104,  99,  95, 121, 138, 155, 163, 176, // 59840-59847
164, 149, 149, 130, 108, 103, 114, 120, // 59848-59855
133, 130, 109, 103, 108, 117, 116, 121, // 59856-59863
136, 141, 151, 148, 126, 110, 111, 122, // 59864-59871
122, 122, 121, 138, 148, 156, 159, 141, // 59872-59879
138, 131, 125, 106, 100, 102, 101, 111, // 59880-59887
122, 121, 100, 112, 119, 121, 144, 162, // 59888-59895
169, 162, 172, 158, 126, 110, 104,  96, // 59896-59903
108, 130, 116, 108, 126, 132, 126, 123, // 59904-59911
127, 118, 121, 143, 131, 116, 126, 137, // 59912-59919
130, 127, 123, 111, 122, 141, 155, 147, // 59920-59927
154, 159, 138, 125, 107,  90,  78,  95, // 59928-59935
111, 120, 122, 125, 129, 120, 137, 144, // 59936-59943
143, 148, 157, 161, 148, 139, 125, 106, // 59944-59951
105, 117, 106,  92, 111, 127, 134, 145, // 59952-59959
143, 130, 121, 133, 125, 102, 112, 127, // 59960-59967
134, 143, 148, 124, 117, 131, 132, 131, // 59968-59975
136, 155, 145, 143, 140, 109,  91,  90, // 59976-59983
 95,  93, 111, 118, 123, 133, 149, 156, // 59984-59991
148, 152, 145, 137, 143, 140, 127, 122, // 59992-59999
124, 126, 116, 106,  95, 102, 111, 136, // 60000-60007
167, 165, 125, 100,  71,  28, 104, 155, // 60008-60015
 93, 194, 252, 115,  96, 154, 111, 203, // 60016-60023
 28, 184, 162, 129,  49, 249,  37, 239, // 60024-60031
  4, 105, 120, 151, 172,  87,  81, 142, // 60032-60039
 50,  63,  61,  88, 171, 253, 149,  95, // 60040-60047
175, 163, 191,  12, 246, 250,  93, 172, // 60048-60055
  8, 217, 175, 196,  47,  75,  56, 171, // 60056-60063
162,  84, 117, 152, 163,  46,  56, 237, // 60064-60071
226, 134,  61,  38,  57,  20,  86, 136, // 60072-60079
150, 184, 148,  61,  91, 106,  43,  87, // 60080-60087
 52, 102, 195, 209, 102, 105, 149, 150, // 60088-60095
221, 253, 215,  19,  47,  99,   2, 197, // 60096-60103
172, 246,  74,  67,  84, 165, 125,  88, // 60104-60111
123, 153, 210,  67,  33, 248, 189,  91, // 60112-60119
 62,  38,  60,  64, 114, 129, 172, 168, // 60120-60127
102,  58,  97,  84,  81, 105,  45, 132, // 60128-60135
193, 162,  90, 116, 139, 188,   2, 249, // 60136-60143
228,  29, 240,  71, 254, 176, 209,  32, // 60144-60151
 75,  82, 101, 131, 101,  91, 113, 174, // 60152-60159
250,  60,  28, 247, 140,  73,  57,  24, // 60160-60167
 81,  99, 120, 144, 184, 130,  84,  70, // 60168-60175
 90,  94, 125,  92,  58, 158, 158, 128, // 60176-60183
 90, 104, 143, 230,   2, 240, 244,   7, // 60184-60191
188,  61, 234, 178,   4,  48,  83,  95, // 60192-60199
 86, 109, 105,  90, 128, 220,   9,  53, // 60200-60207
 33, 211,  94,  79,  39,  26, 119, 107, // 60208-60215
115, 162, 165,  92,  83,  64,  87, 127, // 60216-60223
145,  78,  91, 154, 121, 124,  83,  97, // 60224-60231
177, 253, 247, 254, 243, 226, 167,  51, // 60232-60239
214, 218,  43,  46,  98,  88,  55, 100, // 60240-60247
 94,  78, 163, 251,  12,  63,  18, 160, // 60248-60255
 80,  81,  19,  65, 148,  99, 132, 171, // 60256-60263
126,  79,  87,  49, 110, 161, 138,  78, // 60264-60271
115, 124, 108, 123,  65, 114, 215, 248, // 60272-60279
241, 253, 206, 201, 153,  25, 223,  15, // 60280-60287
 54,  60, 122,  59,  44, 106,  76,  86, // 60288-60295
208, 255,  13,  71, 238, 124,  84,  68, // 60296-60303
 16, 117, 148,  96, 150, 148,  90,  83, // 60304-60311
 75,  51, 150, 170, 128,  94, 113,  94, // 60312-60319
114, 110,  59, 158, 236, 238, 254, 234, // 60320-60327
170, 194, 124,   6,   2,  51,  53,  86, // 60328-60335
118,  25,  59, 104,  61, 121, 235, 237, // 60336-60343
 25,  53, 181, 109,  84,  51,  51, 161, // 60344-60351
134, 109, 154, 113,  81,  89,  57,  80, // 60352-60359
184, 165, 130,  99,  91,  85, 124,  85, // 60360-60367
 76, 194, 231, 242,   2, 193, 155, 191, // 60368-60375
 90,  14,  38,  55,  62, 110,  89,   8, // 60376-60383
 78,  88,  75, 174, 245, 238,  40,   8, // 60384-60391
141, 106,  68,  48,  91, 176, 125, 130, // 60392-60399
133,  85,  84,  78,  56, 125, 191, 156, // 60400-60407
135,  83,  73,  93, 118,  77, 120, 212, // 60408-60415
222, 252, 236, 158, 168, 179,  70,  45, // 60416-60423
 60,  58,  81, 104,  49,  12,  87,  73, // 60424-60431
105, 201, 237, 249,  35, 216, 131,  96, // 60432-60439
 52,  69, 124, 171, 127, 132, 103,  85, // 60440-60447
 89,  68,  82, 161, 186, 165, 129,  53, // 60448-60455
 69,  99, 106,  90, 156, 208, 227, 251, // 60456-60463
188, 136, 169, 149,  72,  76,  62,  71, // 60464-60471
 94,  84,  33,  27,  80,  79, 150, 212, // 60472-60479
241,   4,   6, 183, 131,  78,  61,  99, // 60480-60487
134, 164, 126, 111,  78,  87,  76,  74, // 60488-60495
114, 171, 183, 175, 100,  39,  84,  93, // 60496-60503
103, 118, 174, 207, 244, 230, 156, 145, // 60504-60511
163, 126,  89,  87,  59,  90,  86,  62, // 60512-60519
 31,  37,  79, 106, 170, 211, 251, 246, // 60520-60527
220, 168, 120,  66,  92, 118, 141, 171, // 60528-60535
116,  81,  73,  89,  67,  98, 142, 177, // 60536-60543
193, 166,  62,  43,  90,  87, 122, 140, // 60544-60551
174, 217, 242, 188, 139, 145, 144, 130, // 60552-60559
111,  79,  67,  98,  61,  53,  34,  37, // 60560-60567
 94, 139, 181, 224,   2, 221, 204, 162, // 60568-60575
100,  69, 117, 116, 156, 172,  89,  66, // 60576-60583
 80,  76,  71, 127, 143, 177, 199, 136, // 60584-60591
 39,  61,  84,  93, 152, 149, 181, 228, // 60592-60599
218, 159, 141, 141, 143, 149, 115,  80, // 60600-60607
 87,  82,  35,  54,  23,  45, 124, 152, // 60608-60615
183, 240, 235, 186, 195, 147,  90, 100, // 60616-60623
135, 114, 175, 152,  62,  72,  83,  69, // 60624-60631
 98, 145, 146, 194, 187,  95,  33,  68, // 60632-60639
 77, 122, 167, 144, 198, 226, 186, 148, // 60640-60647
138, 126, 155, 161, 104,  86,  96,  61, // 60648-60655
 38,  60,  12,  68, 143, 152, 196, 242, // 60656-60663
202, 179, 194, 127,  99, 125, 129, 126, // 60664-60671
187, 112,  48,  78,  71,  80, 130, 145, // 60672-60679
149, 200, 156,  68,  40,  68,  84, 154, // 60680-60687
168, 155, 212, 197, 160, 145, 131, 136, // 60688-60695
182, 154, 102,  98,  77,  35,  47,  51, // 60696-60703
 18, 112, 149, 152, 210, 224, 171, 179, // 60704-60711
176, 115, 120, 139, 129, 145, 173,  79, // 60712-60719
 55,  74,  69, 106, 145, 145, 173, 197, // 60720-60727
127,  62,  43,  63, 106, 169, 153, 163, // 60728-60735
207, 172, 156, 138, 119, 151, 192, 145, // 60736-60743
109,  95,  56,  36,  56,  41,  46, 139, // 60744-60751
145, 172, 215, 191, 160, 183, 157, 124, // 60752-60759
137, 133, 129, 154, 148,  60,  63,  67, // 60760-60767
 85, 131, 144, 146, 173, 166, 106,  63, // 60768-60775
 45,  85, 139, 172, 152, 173, 179, 149, // 60776-60783
154, 126, 131, 180, 189, 138, 118,  81, // 60784-60791
 43,  40,  51,  41,  80, 149, 145, 186, // 60792-60799
197, 171, 159, 170, 144, 138, 139, 134, // 60800-60807
140, 148, 120,  59,  64,  66, 111, 142, // 60808-60815
146, 161, 173, 145, 100,  53,  45, 108, // 60816-60823
154, 171, 159, 170, 156, 148, 144, 113, // 60824-60831
147, 187, 177, 140, 110,  57,  46,  48, // 60832-60839
 55,  62, 103, 142, 150, 188, 175, 164, // 60840-60847
160, 164, 159, 157, 135, 137, 135, 128, // 60848-60855
106,  58,  58,  85, 136, 140, 151, 159, // 60856-60863
146, 130,  95,  40,  65, 135, 157, 173, // 60864-60871
163, 156, 143, 149, 132, 124, 174, 188, // 60872-60879
173, 140,  90,  45,  49,  40,  61,  85, // 60880-60887
118, 150, 162, 172, 155, 161, 148, 159, // 60888-60895
169, 156, 139, 152, 126, 119,  99,  48, // 60896-60903
 60, 107, 140, 138, 163, 152, 136, 133, // 60904-60911
 82,  40,  96, 141, 151, 177, 151, 138, // 60912-60919
145, 149, 124, 144, 183, 178, 171, 126, // 60920-60927
 65,  46,  52,  44,  87,  99, 122, 152, // 60928-60935
159, 156, 160, 159, 143, 178, 178, 147, // 60936-60943
142, 142, 102, 118,  91,  41,  80, 126, // 60944-60951
136, 144, 161, 128, 130, 129,  69,  61, // 60952-60959
125, 146, 166, 178, 127, 127, 140, 132, // 60960-60967
128, 167, 185, 184, 175, 104,  52,  51, // 60968-60975
 41,  50, 104, 102, 136, 159, 150, 147, // 60976-60983
159, 147, 149, 191, 169, 145, 148, 124, // 60984-60991
 97, 124,  70,  46, 105, 130, 136, 155, // 60992-60999
149, 114, 138, 118,  63,  88, 138, 146, // 61000-61007
174, 161, 114, 134, 137, 130, 142, 173, // 61008-61015
178, 184, 153,  81,  58,  54,  42,  80, // 61016-61023
115,  98, 141, 143, 131, 148, 160, 144, // 61024-61031
172, 205, 166, 151, 142, 102,  96, 117, // 61032-61039
 59,  69, 120, 130, 148, 156, 126, 113, // 61040-61047
136,  97,  71, 108, 137, 156, 180, 136, // 61048-61055
109, 132, 126, 139, 161, 179, 184, 185, // 61056-61063
131,  75,  60,  45,  55, 102, 111, 111, // 61064-61071
152, 127, 128, 149, 146, 143, 186, 194, // 61072-61079
161, 155, 126,  92, 107, 104,  57,  90, // 61080-61087
122, 135, 153, 143, 119, 124, 133,  98, // 61088-61095
 91, 115, 137, 159, 162, 117, 116, 129, // 61096-61103
127, 157, 164, 178, 185, 168, 104,  69, // 61104-61111
 55,  49,  78, 115, 111, 124, 143, 114, // 61112-61119
134, 146, 145, 159, 196, 187, 165, 147, // 61120-61127
107,  91, 107,  94,  72, 110, 126, 146, // 61128-61135
150, 126, 111, 118, 123, 105, 107, 124, // 61136-61143
153, 162, 144, 109, 112, 117, 137, 164, // 61144-61151
160, 184, 181, 147,  95,  71,  49,  61, // 61152-61159
 97, 119, 118, 133, 127, 111, 141, 143, // 61160-61167
152, 170, 191, 179, 158, 125,  97,  94, // 61168-61175
106,  97,  89, 111, 128, 152, 137, 119, // 61176-61183
116, 117, 127, 116, 110, 128, 156, 150, // 61184-61191
130, 108, 111, 121, 154, 162, 164, 189, // 61192-61199
164, 130,  93,  66,  54,  87, 107, 121, // 61200-61207
126, 127, 111, 113, 134, 135, 164, 180, // 61208-61215
192, 182, 147, 107,  91,  91, 104, 105, // 61216-61223
 99, 119, 142, 150, 124, 119, 111, 116, // 61224-61231
137, 119, 110, 141, 153, 134, 125, 105, // 61232-61239
107, 134, 167, 158, 172, 183, 144, 122, // 61240-61247
 90,  62,  67,  96, 106, 127, 124, 116, // 61248-61255
107, 120, 132, 148, 175, 173, 193, 180, // 61256-61263
135, 106,  96,  88, 111, 114, 100, 120, // 61264-61271
143, 135, 116, 121, 106, 125, 145, 117, // 61272-61279
115, 145, 138, 124, 123,  98, 114, 149, // 61280-61287
167, 161, 184, 169, 132, 120,  80,  63, // 61288-61295
 87, 106, 111, 131, 113, 103, 104, 118, // 61296-61303
131, 163, 179, 179, 199, 164, 117, 103, // 61304-61311
 91,  92, 126, 111, 100, 132, 139, 118, // 61312-61319
114, 118, 105, 144, 150, 114, 127, 146, // 61320-61327
128, 126, 119,  93, 124, 154, 161, 161, // 61328-61335
179, 152, 133, 118,  75,  78,  99, 104, // 61336-61343
121, 132, 101, 102, 104, 115, 142, 177, // 61344-61351
175, 183, 195, 146, 112, 103,  84, 101, // 61352-61359
134, 108, 108, 131, 120, 112, 118, 113, // 61360-61367
115, 161, 147, 121, 137, 133, 118, 125, // 61368-61375
109, 101, 141, 156, 160, 164, 165, 135, // 61376-61383
126, 104,  81,  98, 109, 114, 132, 121, // 61384-61391
 95, 105, 103, 123, 153, 174, 169, 186, // 61392-61399
176, 127, 111,  96,  89, 121, 134, 103, // 61400-61407
117, 128, 117, 115, 114, 110, 129, 165, // 61408-61415
138, 126, 133, 125, 122, 126, 105, 116, // 61416-61423
150, 158, 163, 157, 148, 125, 121,  95, // 61424-61431
 90, 102, 109, 119, 129, 109,  96, 105, // 61432-61439
103, 141, 171, 178, 172, 180, 155, 118, // 61440-61447
108,  90,  99, 138, 137, 112, 120, 112, // 61448-61455
109, 112, 109, 115, 140, 160, 135, 129, // 61456-61463
124, 119, 122, 120, 111, 134, 153, 161, // 61464-61471
165, 152, 143, 126, 115,  94,  97, 103, // 61472-61479
109, 119, 118, 101, 101, 106, 115, 155, // 61480-61487
172, 179, 175, 171, 142, 114,  98,  90, // 61488-61495
114, 138, 128, 111, 113, 107, 113, 109, // 61496-61503
111, 128, 152, 162, 135, 121, 114, 120, // 61504-61511
122, 122, 123, 144, 157, 168, 154, 135, // 61512-61519
133, 116, 111, 103, 107, 103, 113, 114, // 61520-61527
103,  96,  99, 102, 132, 172, 179, 184, // 61528-61535
175, 163, 138, 116,  97,  95, 120, 135, // 61536-61543
125, 107, 101, 104, 113, 109, 124, 135, // 61544-61551
152, 161, 135, 115, 114, 121, 115, 124, // 61552-61559
130, 141, 155, 167, 143, 136, 136, 113, // 61560-61567
112, 111, 110, 110, 120, 109, 102,  97, // 61568-61575
 95, 104, 141, 166, 175, 182, 162, 153, // 61576-61583
135, 111, 101, 113, 128, 135, 123,  99, // 61584-61591
 94, 105, 110, 110, 135, 142, 160, 160, // 61592-61599
124, 107, 115, 118, 118, 134, 133, 143, // 61600-61607
160, 157, 128, 135, 127, 112, 124, 119, // 61608-61615
109, 115, 120, 103, 103,  98,  94, 111, // 61616-61623
148, 164, 176, 172, 151, 149, 131, 111, // 61624-61631
108, 120, 134, 144, 122,  93,  96, 104, // 61632-61639
104, 116, 136, 136, 160, 154, 116, 110, // 61640-61647
118, 116, 125, 142, 135, 147, 160, 144, // 61648-61655
125, 137, 121, 117, 128, 118, 115, 117, // 61656-61663
107,  96, 103,  97, 103, 128, 154, 164, // 61664-61671
174, 157, 141, 144, 122, 113, 121, 130, // 61672-61679
139, 143, 111,  89,  99, 103, 108, 126, // 61680-61687
138, 139, 164, 137, 105, 111, 116, 118, // 61688-61695
138, 143, 135, 155, 156, 134, 127, 132, // 61696-61703
113, 123, 129, 115, 117, 116, 103, 101, // 61704-61711
104,  96, 112, 136, 158, 172, 172, 146, // 61712-61719
140, 138, 116, 117, 119, 124, 142, 137, // 61720-61727
101,  93, 104, 109, 123, 139, 137, 143, // 61728-61735
156, 119, 102, 109, 113, 125, 147, 142, // 61736-61743
140, 152, 141, 128, 130, 130, 120, 134, // 61744-61751
126, 117, 116, 103,  95, 102, 102, 107, // 61752-61759
127, 144, 165, 174, 161, 138, 138, 129, // 61760-61767
114, 123, 120, 128, 140, 122,  90,  94, // 61768-61775
102, 115, 135, 146, 145, 154, 152, 112, // 61776-61783
105, 105, 112, 131, 142, 136, 143, 147, // 61784-61791
136, 131, 130, 129, 127, 136, 124, 121, // 61792-61799
110,  96,  98, 102, 103, 114, 127, 143, // 61800-61807
168, 167, 151, 138, 140, 130, 127, 128, // 61808-61815
116, 130, 133, 108,  89,  96, 104, 128, // 61816-61823
143, 145, 145, 149, 137, 109, 108, 108, // 61824-61831
124, 138, 141, 136, 136, 131, 130, 128, // 61832-61839
131, 138, 138, 140, 131, 123, 103,  95, // 61840-61847
 97,  97, 107, 121, 129, 150, 167, 156, // 61848-61855
143, 135, 134, 131, 134, 129, 125, 137, // 61856-61863
125, 100,  89,  93, 109, 133, 140, 145, // 61864-61871
148, 146, 132, 113, 110, 115, 133, 136, // 61872-61879
137, 135, 129, 126, 130, 125, 131, 136, // 61880-61887
132, 131, 128, 120, 108, 110, 110, 114, // 61888-61895
124, 125, 128, 143, 146, 139, 136, 130, // 61896-61903
132, 136, 133, 126, 126, 125, 116, 110, // 61904-61911
107, 110, 125, 135, 137, 138, 133, 129, // 61912-61919
126, 121, 122, 130, 134, 133, 135, 130, // 61920-61927
122, 122, 123, 121, 129, 130, 127, 128, // 61928-61935
127, 122, 118, 120, 120, 125, 131, 131, // 61936-61943
133, 140, 138, 136, 130, 124, 125, 126, // 61944-61951
124, 124, 125, 124, 122, 119, 115, 119, // 61952-61959
128, 131, 132, 135, 132, 132, 131, 128, // 61960-61967
128, 132, 131, 127, 126, 124, 122, 126, // 61968-61975
127, 128, 130, 126, 124, 123, 122, 120, // 61976-61983
123, 125, 126, 130, 133, 131, 132, 133, // 61984-61991
132, 131, 128, 127, 127, 129, 127, 124, // 61992-61999
122, 120, 121, 120, 121, 125, 132, 133, // 62000-62007
135, 132, 128, 125, 126, 127, 127, 128, // 62008-62015
128, 127, 127, 126, 123, 124, 126, 129, // 62016-62023
129, 128, 128, 129, 129, 128, 125, 122, // 62024-62031
123, 124, 127, 127, 130, 134, 136, 132, // 62032-62039
127, 125, 125, 126, 124, 123, 123, 125, // 62040-62047
125, 123, 124, 127, 130, 131, 132, 129, // 62048-62055
128, 128, 128, 128, 127, 128, 126, 124, // 62056-62063
122, 124, 125, 131, 134, 134, 130, 128, // 62064-62071
125, 122, 124, 124, 124, 125, 127, 125, // 62072-62079
126, 126, 127, 130, 130, 130, 129, 129, // 62080-62087
128, 130, 128, 124, 123, 123, 120, 122, // 62088-62095
124, 127, 132, 135, 134, 131, 129, 125, // 62096-62103
124, 125, 125, 126, 127, 127, 127, 127, // 62104-62111
124, 126, 128, 128, 129, 128, 125, 126, // 62112-62119
128, 126, 123, 125, 124, 124, 127, 128, // 62120-62127
130, 136, 135, 131, 129, 126, 123, 125, // 62128-62135
122, 120, 122, 124, 125, 126, 125, 128, // 62136-62143
130, 130, 130, 131, 131, 131, 133, 130, // 62144-62151
125, 124, 123, 121, 123, 124, 125, 131, // 62152-62159
132, 129, 128, 128, 124, 124, 126, 124, // 62160-62167
126, 128, 127, 129, 129, 128, 129, 133, // 62168-62175
131, 128, 126, 124, 125, 126, 123, 124, // 62176-62183
123, 121, 121, 124, 126, 132, 136, 136, // 62184-62191
135, 133, 129, 127, 127, 124, 124, 125, // 62192-62199
124, 122, 125, 124, 125, 129, 128, 127, // 62200-62207
128, 126, 125, 130, 130, 127, 128, 127, // 62208-62215
124, 125, 126, 127, 132, 137, 134, 131, // 62216-62223
127, 122, 121, 122, 120, 122, 124, 125, // 62224-62231
127, 125, 125, 129, 133, 133, 134, 130, // 62232-62239
127, 130, 130, 126, 126, 126, 123, 124, // 62240-62247
124, 122, 126, 130, 130, 129, 129, 124, // 62248-62255
124, 126, 125, 123, 126, 127, 128, 131, // 62256-62263
129, 129, 131, 132, 131, 130, 127, 126, // 62264-62271
127, 125, 123, 123, 122, 122, 124, 122, // 62272-62279
124, 129, 131, 131, 133, 130, 130, 131, // 62280-62287
128, 125, 127, 127, 125, 127, 128, 125, // 62288-62295
129, 128, 124, 124, 123, 121, 125, 128, // 62296-62303
127, 127, 128, 126, 127, 128, 127, 133, // 62304-62311
135, 134, 132, 128, 126, 128, 126, 122, // 62312-62319
122, 123, 122, 125, 125, 123, 126, 130, // 62320-62327
127, 128, 128, 125, 127, 132, 130, 130, // 62328-62335
131, 128, 126, 128, 125, 126, 130, 130, // 62336-62343
128, 128, 123, 120, 123, 123, 124, 124, // 62344-62351
127, 127, 128, 128, 128, 132, 134, 134, // 62352-62359
131, 126, 124, 124, 123, 125, 127, 126, // 62360-62367
125, 127, 124, 124, 128, 131, 129, 130, // 62368-62375
128, 124, 127, 127, 124, 123, 126, 126, // 62376-62383
128, 130, 129, 130, 131, 131, 128, 125, // 62384-62391
124, 125, 125, 125, 125, 124, 126, 126, // 62392-62399
126, 125, 129, 131, 133, 134, 132, 127, // 62400-62407
127, 126, 123, 123, 121, 123, 126, 128, // 62408-62415
126, 127, 129, 130, 131, 129, 126, 125, // 62416-62423
128, 127, 126, 126, 125, 126, 126, 128, // 62424-62431
129, 132, 133, 132, 128, 127, 125, 125, // 62432-62439
125, 125, 122, 121, 124, 123, 124, 127, // 62440-62447
130, 130, 133, 133, 128, 128, 130, 128, // 62448-62455
127, 129, 125, 126, 126, 123, 123, 125, // 62456-62463
127, 130, 131, 129, 127, 127, 126, 124, // 62464-62471
123, 123, 124, 127, 126, 127, 129, 131, // 62472-62479
133, 133, 128, 127, 127, 126, 126, 127, // 62480-62487
125, 124, 125, 123, 124, 125, 129, 130, // 62488-62495
133, 130, 127, 127, 127, 128, 128, 127, // 62496-62503
124, 127, 125, 124, 126, 127, 128, 131, // 62504-62511
130, 127, 127, 127, 127, 127, 126, 125, // 62512-62519
126, 127, 126, 126, 126, 128, 129, 130, // 62520-62527
128, 128, 129, 128, 127, 125, 123, 125, // 62528-62535
126, 125, 127, 128, 130, 130, 131, 126, // 62536-62543
124, 126, 125, 126, 128, 127, 126, 128, // 62544-62551
126, 125, 126, 128, 131, 131, 129, 128, // 62552-62559
127, 126, 127, 128, 125, 124, 128, 127, // 62560-62567
126, 127, 127, 127, 129, 129, 124, 126, // 62568-62575
127, 127, 126, 126, 126, 126, 127, 128, // 62576-62583
130, 129, 132, 130, 130, 127, 126, 125, // 62584-62591
124, 126, 126, 124, 124, 124, 124, 127, // 62592-62599
129, 129, 131, 132, 130, 127, 124, 124, // 62600-62607
127, 126, 126, 126, 128, 128, 129, 126, // 62608-62615
126, 129, 130, 127, 124, 126, 125, 126, // 62616-62623
127, 125, 124, 126, 128, 127, 129, 131, // 62624-62631
133, 132, 131, 127, 124, 125, 125, 124, // 62632-62639
124, 124, 124, 125, 126, 128, 126, 130, // 62640-62647
132, 131, 130, 127, 126, 126, 127, 126, // 62648-62655
126, 126, 127, 128, 128, 128, 130, 131, // 62656-62663
129, 127, 124, 123, 123, 124, 122, 123, // 62664-62671
124, 126, 128, 130, 131, 133, 134, 131, // 62672-62679
130, 129, 127, 127, 126, 124, 125, 123, // 62680-62687
121, 122, 124, 124, 127, 130, 130, 131, // 62688-62695
130, 127, 127, 128, 128, 128, 128, 127, // 62696-62703
127, 129, 127, 127, 129, 130, 129, 127, // 62704-62711
125, 125, 124, 123, 122, 122, 122, 126, // 62712-62719
127, 127, 130, 134, 134, 132, 132, 127, // 62720-62727
127, 129, 128, 125, 125, 123, 121, 123, // 62728-62735
125, 125, 127, 128, 128, 129, 129, 126, // 62736-62743
128, 129, 129, 129, 128, 126, 128, 127, // 62744-62751
126, 127, 129, 128, 129, 127, 124, 125, // 62752-62759
125, 124, 125, 126, 126, 126, 128, 128, // 62760-62767
130, 131, 130, 131, 129, 128, 128, 128, // 62768-62775
125, 126, 126, 123, 124, 125, 124, 127, // 62776-62783
131, 130, 127, 127, 125, 123, 126, 128, // 62784-62791
128, 128, 128, 128, 129, 128, 128, 128, // 62792-62799
129, 131, 129, 126, 124, 126, 124, 123, // 62800-62807
123, 124, 126, 128, 127, 127, 128, 129, // 62808-62815
130, 130, 127, 126, 127, 128, 127, 127, // 62816-62823
126, 126, 127, 126, 127, 128, 128, 128, // 62824-62831
128, 128, 124, 124, 125, 126, 127, 127, // 62832-62839
126, 127, 128, 130, 132, 133, 132, 131, // 62840-62847
127, 124, 124, 122, 123, 124, 124, 124, // 62848-62855
126, 126, 126, 129, 131, 130, 130, 129, // 62856-62863
128, 128, 128, 127, 125, 126, 126, 126, // 62864-62871
126, 127, 129, 129, 128, 128, 125, 124, // 62872-62879
124, 124, 125, 127, 128, 126, 126, 127, // 62880-62887
127, 128, 131, 132, 133, 133, 130, 126, // 62888-62895
124, 124, 124, 124, 123, 124, 125, 126, // 62896-62903
127, 128, 130, 132, 131, 129, 126, 126, // 62904-62911
125, 125, 126, 125, 125, 126, 128, 129, // 62912-62919
130, 130, 130, 129, 128, 127, 126, 124, // 62920-62927
125, 126, 125, 125, 125, 125, 127, 129, // 62928-62935
129, 130, 131, 130, 127, 126, 126, 125, // 62936-62943
126, 125, 126, 127, 126, 126, 126, 128, // 62944-62951
131, 131, 130, 130, 128, 126, 125, 124, // 62952-62959
122, 123, 126, 125, 127, 129, 129, 131, // 62960-62967
132, 129, 128, 127, 125, 125, 126, 125, // 62968-62975
124, 124, 124, 126, 128, 129, 130, 132, // 62976-62983
131, 129, 128, 125, 125, 126, 126, 125, // 62984-62991
125, 125, 126, 128, 128, 128, 130, 131, // 62992-62999
130, 129, 126, 125, 126, 125, 124, 126, // 63000-63007
125, 124, 127, 129, 128, 129, 132, 130, // 63008-63015
131, 129, 126, 126, 126, 125, 123, 124, // 63016-63023
123, 125, 128, 130, 129, 131, 129, 128, // 63024-63031
126, 123, 124, 126, 126, 126, 127, 127, // 63032-63039
126, 128, 129, 131, 133, 132, 131, 129, // 63040-63047
126, 125, 124, 124, 123, 125, 124, 125, // 63048-63055
126, 126, 127, 129, 129, 127, 128, 127, // 63056-63063
127, 129, 129, 127, 127, 127, 126, 127, // 63064-63071
128, 128, 129, 130, 129, 128, 126, 124, // 63072-63079
124, 124, 123, 123, 123, 124, 126, 128, // 63080-63087
130, 132, 133, 133, 132, 129, 127, 126, // 63088-63095
125, 125, 124, 125, 124, 126, 126, 126, // 63096-63103
126, 127, 127, 127, 129, 128, 127, 127, // 63104-63111
128, 126, 127, 127, 127, 129, 130, 129, // 63112-63119
128, 126, 125, 125, 124, 125, 125, 125, // 63120-63127
125, 125, 125, 125, 126, 128, 130, 132, // 63128-63135
134, 133, 131, 129, 128, 127, 126, 125, // 63136-63143
123, 124, 123, 124, 124, 125, 127, 127, // 63144-63151
127, 127, 126, 126, 127, 126, 127, 126, // 63152-63159
128, 129, 130, 131, 130, 129, 130, 130, // 63160-63167
127, 125, 124, 125, 124, 124, 124, 123, // 63168-63175
124, 125, 127, 127, 130, 130, 131, 130, // 63176-63183
130, 127, 126, 126, 127, 127, 127, 127, // 63184-63191
126, 125, 126, 127, 127, 127, 129, 129, // 63192-63199
128, 127, 125, 123, 125, 126, 125, 127, // 63200-63207
130, 131, 132, 132, 130, 129, 128, 127, // 63208-63215
126, 125, 123, 123, 123, 124, 125, 125, // 63216-63223
126, 128, 130, 130, 131, 130, 128, 128, // 63224-63231
129, 127, 127, 127, 127, 127, 126, 126, // 63232-63239
126, 127, 128, 128, 127, 125, 125, 126, // 63240-63247
125, 125, 125, 124, 127, 129, 129, 130, // 63248-63255
132, 131, 131, 132, 129, 128, 127, 126, // 63256-63263
124, 123, 121, 120, 121, 123, 126, 130, // 63264-63271
131, 131, 131, 128, 127, 127, 127, 126, // 63272-63279
129, 129, 128, 127, 127, 126, 128, 128, // 63280-63287
128, 129, 129, 127, 126, 124, 122, 123, // 63288-63295
125, 124, 127, 126, 127, 129, 129, 130, // 63296-63303
131, 130, 128, 128, 128, 125, 126, 125, // 63304-63311
124, 126, 126, 125, 126, 128, 128, 130, // 63312-63319
132, 129, 128, 128, 127, 125, 126, 123, // 63320-63327
124, 126, 126, 126, 129, 129, 131, 131, // 63328-63335
128, 127, 126, 125, 125, 125, 124, 125, // 63336-63343
128, 127, 127, 127, 126, 127, 130, 130, // 63344-63351
129, 130, 128, 126, 126, 125, 123, 125, // 63352-63359
126, 127, 128, 128, 128, 128, 127, 125, // 63360-63367
127, 127, 126, 128, 127, 125, 127, 126, // 63368-63375
126, 129, 131, 130, 131, 131, 129, 129, // 63376-63383
127, 125, 124, 124, 122, 124, 124, 124, // 63384-63391
127, 129, 128, 130, 130, 127, 128, 128, // 63392-63399
127, 126, 128, 126, 126, 128, 127, 127, // 63400-63407
129, 129, 129, 130, 127, 126, 126, 127, // 63408-63415
126, 126, 125, 122, 124, 125, 126, 127, // 63416-63423
130, 131, 133, 130, 128, 126, 125, 126, // 63424-63431
128, 127, 126, 128, 127, 126, 126, 126, // 63432-63439
126, 130, 130, 129, 129, 126, 124, 124, // 63440-63447
124, 122, 125, 127, 128, 129, 130, 129, // 63448-63455
129, 130, 128, 128, 126, 126, 126, 126, // 63456-63463
125, 125, 125, 124, 126, 127, 127, 129, // 63464-63471
130, 129, 129, 129, 126, 126, 127, 127, // 63472-63479
126, 128, 127, 127, 128, 126, 127, 127, // 63480-63487
127, 127, 127, 125, 126, 125, 124, 124, // 63488-63495
127, 128, 129, 131, 130, 128, 129, 130, // 63496-63503
129, 128, 127, 127, 126, 125, 123, 122, // 63504-63511
123, 125, 127, 127, 129, 129, 130, 128, // 63512-63519
126, 125, 126, 128, 129, 129, 128, 128, // 63520-63527
127, 129, 128, 127, 127, 129, 129, 128, // 63528-63535
126, 125, 125, 124, 125, 123, 123, 125, // 63536-63543
128, 129, 130, 129, 129, 129, 128, 127, // 63544-63551
127, 127, 128, 128, 126, 125, 125, 125, // 63552-63559
127, 128, 130, 129, 129, 128, 126, 125, // 63560-63567
125, 125, 125, 126, 126, 126, 125, 126, // 63568-63575
127, 130, 131, 131, 130, 128, 126, 124, // 63576-63583
123, 124, 126, 125, 126, 127, 127, 127, // 63584-63591
127, 128, 129, 131, 130, 129, 129, 128, // 63592-63599
126, 125, 123, 122, 125, 126, 127, 128, // 63600-63607
128, 129, 128, 127, 125, 125, 126, 126, // 63608-63615
128, 126, 127, 128, 127, 128, 129, 129, // 63616-63623
129, 132, 131, 130, 127, 126, 123, 123, // 63624-63631
123, 122, 124, 126, 126, 127, 128, 128, // 63632-63639
129, 130, 130, 130, 130, 128, 127, 126, // 63640-63647
124, 124, 126, 126, 128, 130, 128, 128, // 63648-63655
127, 125, 125, 127, 128, 127, 127, 125, // 63656-63663
125, 124, 125, 127, 129, 130, 132, 132, // 63664-63671
129, 127, 127, 125, 123, 125, 124, 124, // 63672-63679
128, 127, 126, 127, 127, 128, 130, 132, // 63680-63687
130, 130, 130, 128, 126, 125, 122, 123, // 63688-63695
125, 125, 126, 128, 128, 128, 127, 126, // 63696-63703
125, 126, 127, 129, 129, 127, 126, 126, // 63704-63711
125, 127, 128, 129, 130, 131, 128, 126, // 63712-63719
125, 125, 125, 127, 126, 125, 126, 126, // 63720-63727
126, 126, 126, 127, 129, 129, 129, 130, // 63728-63735
128, 125, 126, 126, 125, 128, 128, 129, // 63736-63743
128, 128, 126, 127, 126, 127, 127, 129, // 63744-63751
128, 129, 126, 127, 125, 126, 148, 150, // 63752-63759
118, 102,  52,  60, 158, 117, 126, 218, // 63760-63767
191,  80,  83, 104, 129,  22, 243, 175, // 63768-63775
170,  89,  16,  16, 245,   4, 114, 134, // 63776-63783
149, 173, 134,  45, 113,  86,  21,  91, // 63784-63791
 61,  88, 205, 206,  93, 150, 175, 184, // 63792-63799
244,  27, 225,  40,  59,  91, 254, 192, // 63800-63807
168, 247,  72,  35, 104, 172, 138,  89, // 63808-63815
107, 133, 221,  83,  10, 242, 188,  91, // 63816-63823
 63,  48,  21,  84, 150, 145, 179, 164, // 63824-63831
 92,  49, 112,  58,  61, 103,  45, 113, // 63832-63839
193, 141,  81, 142, 151, 207,   4,   2, // 63840-63847
222,  45, 240,  57, 245, 171, 206,  34, // 63848-63855
 66,  54, 118, 133, 120,  87, 102, 164, // 63856-63863
 15,  70,  10, 241, 136,  78,  66,  34, // 63864-63871
 53, 129, 147, 158, 184, 122,  67,  59, // 63872-63879
 98,  64, 106,  91,  58, 144, 164, 114, // 63880-63887
 93, 129, 161, 248,   2, 251, 235,  23, // 63888-63895
190,  53, 223, 178,   2,  50,  71,  77, // 63896-63903
101, 111, 121,  73, 115, 205,  27,  57, // 63904-63911
 17, 205,  94,  83,  50,  34, 100, 143, // 63912-63919
141, 177, 160,  86,  69,  62,  94,  99, // 63920-63927
131,  77,  85, 139, 128, 107,  91, 124, // 63928-63935
200,  10, 247,   3, 225, 239, 160,  36, // 63936-63943
201, 222,  39,  53,  91,  80,  74, 112, // 63944-63951
112,  61, 155, 237,  29,  61,   2, 153, // 63952-63959
 81,  81,  26,  62, 133, 135, 154, 183, // 63960-63967
119,  76,  69,  51, 114, 131, 126,  81, // 63968-63975
106, 112, 115, 105,  78, 141, 238,   0, // 63976-63983
250,   4, 194, 220, 142,  10, 211,  17, // 63984-63991
 47,  66, 107,  53,  62, 122,  88,  74, // 63992-63999
203, 241,  31,  61, 215, 113,  85,  67, // 64000-64007
 30, 113, 142, 132, 168, 158,  85,  85, // 64008-64015
 58,  61, 152, 143, 123,  94,  98,  84, // 64016-64023
119,  88,  75, 181, 254, 242,   8, 232, // 64024-64031
163, 215, 112, 249, 251,  50,  46,  94, // 64032-64039
 97,  23,  72, 117,  67, 114, 233, 235, // 64040-64047
 51,  41, 166, 103,  83,  45,  59, 146, // 64048-64055
134, 146, 170, 119,  73,  85,  38,  94, // 64056-64063
177, 137, 128,  96,  74,  82, 125,  69, // 64064-64071
103, 217, 247, 243,  10, 182, 158, 211, // 64072-64079
 77,   7,  36,  53,  54, 111,  61,  11, // 64080-64087
 91, 104,  75, 166, 237, 238,  63, 249, // 64088-64095
134, 103,  68,  49, 101, 155, 131, 159, // 64096-64103
142,  90,  80,  73,  41, 143, 181, 139, // 64104-64111
138,  76,  56,  94, 114,  63, 148, 232, // 64112-64119
240,   0, 239, 140, 170, 184,  50,  37, // 64120-64127
 55,  55,  79, 106,  26,  23,  96,  89, // 64128-64135
104, 198, 230,   3,  53, 198, 128,  95, // 64136-64143
 56,  74, 128, 150, 139, 154, 107,  84, // 64144-64151
 81,  60,  71, 175, 167, 148, 127,  44, // 64152-64159
 59, 104,  98,  86, 184, 225, 244, 255, // 64160-64167
195, 127, 185, 154,  59,  69,  55,  65, // 64168-64175
 93,  77,  10,  40,  90,  96, 140, 206, // 64176-64183
231,  14,  12, 164, 128,  75,  66, 107, // 64184-64191
139, 152, 147, 127,  84,  88,  69,  65, // 64192-64199
112, 188, 164, 164,  97,  26,  69,  97, // 64200-64207
 93, 120, 198, 224,   1, 228, 160, 132, // 64208-64215
180, 131,  83,  78,  55,  84,  82,  48, // 64216-64223
 12,  46,  87, 121, 160, 209, 244,   6, // 64224-64231
230, 158, 120,  65,  97, 122, 140, 161, // 64232-64239
136,  96,  84,  84,  60,  88, 138, 182, // 64240-64247
169, 156,  57,  33,  79,  91, 112, 147, // 64248-64255
196, 233, 250, 191, 147, 138, 169, 135, // 64256-64263
106,  74,  69,  90,  56,  39,  18,  44, // 64264-64271
103, 145, 164, 221, 246, 230, 202, 151, // 64272-64279
100,  75, 127, 122, 153, 164, 109,  79, // 64280-64287
 87,  71,  72, 120, 146, 184, 177, 129, // 64288-64295
 35,  51,  77, 101, 141, 155, 198, 242, // 64296-64303
219, 162, 142, 132, 164, 146, 106,  70, // 64304-64311
 86,  75,  39,  44,  15,  55, 133, 152, // 64312-64319
168, 237, 229, 206, 197, 140,  91, 103, // 64320-64327
137, 118, 169, 146,  80,  81,  86,  64, // 64328-64335
100, 135, 148, 192, 165,  92,  29,  59, // 64336-64343
 71, 128, 156, 156, 213, 235, 184, 154, // 64344-64351
136, 126, 180, 155, 100,  82,  92,  48, // 64352-64359
 39,  48,  12,  87, 157, 149, 185, 237, // 64360-64367
193, 191, 185, 118,  98, 129, 132, 127, // 64368-64375
178, 113,  71,  88,  76,  78, 133, 136, // 64376-64383
161, 197, 140,  71,  36,  57,  83, 157, // 64384-64391
152, 163, 223, 207, 161, 153, 122, 137, // 64392-64399
198, 145,  96,  91,  75,  30,  51,  38, // 64400-64407
 21, 125, 162, 150, 205, 219, 169, 196, // 64408-64415
168, 110, 120, 139, 126, 145, 165,  81, // 64416-64423
 74,  82,  71, 103, 144, 131, 176, 182, // 64424-64431
110,  63,  39,  60, 113, 173, 146, 179, // 64432-64439
215, 178, 158, 149, 114, 164, 204, 130, // 64440-64447
102,  88,  50,  29,  56,  26,  50, 150, // 64448-64455
152, 162, 209, 189, 163, 195, 147, 122, // 64456-64463
138, 136, 129, 152, 139,  71,  81,  74, // 64464-64471
 86, 128, 142, 137, 184, 152,  97,  62, // 64472-64479
 36,  77, 142, 171, 149, 191, 191, 160, // 64480-64487
157, 132, 118, 191, 193, 124, 109,  71, // 64488-64495
 37,  40,  53,  29,  88, 157, 151, 177, // 64496-64503
196, 167, 169, 185, 138, 142, 140, 135, // 64504-64511
136, 144, 112,  69,  77,  73, 113, 138, // 64512-64519
139, 149, 174, 126,  95,  51,  40, 106, // 64520-64527
158, 166, 158, 186, 166, 158, 150, 122, // 64528-64535
141, 205, 175, 126, 102,  49,  40,  45, // 64536-64543
 48,  51, 115, 154, 156, 178, 174, 161, // 64544-64551
169, 168, 147, 155, 136, 142, 135, 127, // 64552-64559
100,  70,  69,  88, 132, 138, 147, 157, // 64560-64567
153, 116,  94,  37,  61, 130, 159, 166, // 64568-64575
164, 167, 154, 160, 138, 129, 167, 202, // 64576-64583
165, 126,  78,  38,  45,  40,  57,  77, // 64584-64591
125, 154, 164, 165, 161, 162, 163, 167, // 64592-64599
165, 155, 135, 151, 121, 117,  97,  62, // 64600-64607
 70, 111, 136, 136, 152, 145, 134, 116, // 64608-64615
 82,  35,  93, 141, 160, 171, 154, 148, // 64616-64623
154, 154, 131, 147, 181, 197, 165, 117, // 64624-64631
 57,  42,  44,  37,  75,  89, 129, 161, // 64632-64639
159, 148, 162, 159, 157, 178, 172, 148, // 64640-64647
143, 145, 101, 117,  89,  56,  88, 129, // 64648-64655
134, 146, 151, 128, 130, 113,  67,  53, // 64656-64663
121, 141, 168, 167, 133, 142, 154, 141, // 64664-64671
139, 166, 182, 196, 161,  95,  47,  50, // 64672-64679
 38,  53,  95,  92, 138, 163, 144, 143, // 64680-64687
164, 148, 164, 193, 168, 145, 149, 124, // 64688-64695
 92, 121,  72,  61, 112, 136, 136, 156, // 64696-64703
137, 117, 132, 105,  62,  79, 130, 142, // 64704-64711
177, 150, 121, 145, 148, 137, 155, 171, // 64712-64719
182, 196, 144,  76,  52,  50,  37,  78, // 64720-64727
103,  95, 152, 152, 128, 146, 161, 142, // 64728-64735
182, 195, 159, 149, 145, 102,  97, 118, // 64736-64743
 62,  84, 126, 131, 142, 154, 118, 120, // 64744-64751
130,  93,  72,  98, 129, 148, 176, 129, // 64752-64759
123, 150, 140, 148, 169, 170, 188, 190, // 64760-64767
116,  68,  55,  44,  49,  99,  98, 105, // 64768-64775
158, 132, 125, 153, 151, 149, 198, 187, // 64776-64783
159, 153, 129,  92, 108, 107,  64, 106, // 64784-64791
127, 135, 150, 139, 106, 123, 119,  91, // 64792-64799
 89, 108, 132, 158, 159, 112, 127, 141, // 64800-64807
141, 167, 172, 170, 194, 170,  95,  69, // 64808-64815
 51,  46,  74, 111,  98, 125, 151, 116, // 64816-64823
131, 149, 143, 165, 203, 177, 162, 143, // 64824-64831
109,  88, 107,  94,  80, 120, 128, 145, // 64832-64839
147, 122, 107, 125, 113, 104, 101, 113, // 64840-64847
143, 159, 140, 108, 129, 132, 151, 173, // 64848-64855
165, 176, 191, 144,  89,  68,  45,  60, // 64856-64863
 91, 109, 101, 133, 134, 114, 138, 143, // 64864-64871
151, 182, 199, 175, 162, 126, 102,  91, // 64872-64879
105,  95,  96, 121, 131, 151, 133, 114, // 64880-64887
112, 120, 118, 118, 102, 122, 149, 145, // 64888-64895
125, 109, 122, 131, 165, 170, 165, 184, // 64896-64903
176, 128,  91,  63,  51,  81,  98, 111, // 64904-64911
111, 129, 118, 117, 134, 142, 166, 187, // 64912-64919
195, 178, 151, 110, 100,  87, 103, 102, // 64920-64927
103, 121, 141, 145, 120, 115, 111, 120, // 64928-64935
130, 121, 102, 135, 146, 133, 121, 109, // 64936-64943
120, 144, 174, 163, 171, 182, 157, 120, // 64944-64951
 87,  57,  66,  94, 100, 117, 112, 118, // 64952-64959
112, 120, 130, 151, 177, 186, 196, 175, // 64960-64967
132, 106, 100,  84, 115, 111, 106, 127, // 64968-64975
144, 129, 113, 116, 106, 126, 140, 116, // 64976-64983
109, 142, 132, 126, 121, 104, 127, 160, // 64984-64991
172, 163, 178, 168, 142, 117,  79,  61, // 64992-64999
 86,  97, 105, 123, 105, 112, 113, 117, // 65000-65007
132, 167, 177, 185, 196, 159, 118, 108, // 65008-65015
 94,  89, 130, 111, 109, 135, 137, 115, // 65016-65023
115, 110, 105, 140, 142, 111, 120, 139, // 65024-65031
119, 128, 116, 105, 142, 168, 169, 167, // 65032-65039
174, 151, 137, 108,  71,  74,  97,  97, // 65040-65047
116, 120,  95, 113, 111, 117, 144, 178, // 65048-65055
173, 190, 189, 140, 112, 107,  86, 104, // 65056-65063
139, 108, 118, 137, 124, 111, 117, 105, // 65064-65071
115, 151, 136, 113, 127, 128, 115, 128, // 65072-65079
106, 113, 155, 167, 169, 170, 164, 142, // 65080-65087
135,  97,  74,  88, 100, 100, 123, 109, // 65088-65095
 93, 115, 107, 123, 159, 178, 174, 196, // 65096-65103
173, 126, 112, 100,  86, 122, 137, 106, // 65104-65111
127, 131, 115, 114, 115, 103, 130, 155, // 65112-65119
130, 117, 123, 118, 117, 125, 104, 129, // 65120-65127
160, 166, 173, 166, 151, 140, 126,  89, // 65128-65135
 86,  97,  99, 108, 123,  95,  94, 112, // 65136-65143
103, 138, 173, 177, 179, 192, 153, 120, // 65144-65151
109,  93,  96, 136, 132, 111, 130, 118, // 65152-65159
112, 114, 109, 112, 144, 150, 129, 119, // 65160-65167
117, 112, 119, 119, 110, 146, 163, 172, // 65168-65175
176, 157, 143, 136, 114,  89,  95,  98, // 65176-65183
103, 113, 113,  86, 100, 105, 110, 154, // 65184-65191
175, 179, 184, 180, 139, 119, 103,  95, // 65192-65199
111, 141, 126, 117, 121, 109, 113, 110, // 65200-65207
111, 125, 148, 147, 130, 113, 110, 116, // 65208-65215
119, 118, 125, 152, 160, 174, 163, 143, // 65216-65223
142, 130, 107, 100, 103,  99, 109, 111, // 65224-65231
102,  91, 106, 103, 125, 162, 172, 179, // 65232-65239
176, 161, 133, 117, 101, 107, 123, 140, // 65240-65247
127, 117, 109, 107, 110, 103, 118, 135, // 65248-65255
147, 147, 128, 106, 113, 118, 117, 124, // 65256-65263
139, 154, 163, 171, 146, 138, 139, 119, // 65264-65271
109, 108, 103, 105, 114, 105,  99,  97, // 65272-65279
104, 108, 141, 162, 173, 178, 165, 151, // 65280-65287
131, 109, 104, 117, 126, 141, 127, 110, // 65288-65295
105, 111, 108, 108, 131, 136, 147, 147, // 65296-65303
117, 101, 117, 117, 121, 136, 142, 152, // 65304-65311
165, 161, 135, 142, 132, 117, 117, 111, // 65312-65319
102, 110, 107,  97, 101,  96, 103, 120, // 65320-65327
150, 162, 178, 172, 154, 147, 127, 106, // 65328-65335
114, 123, 129, 144, 121, 100, 104, 110, // 65336-65343
103, 119, 138, 137, 153, 141, 104, 103, // 65344-65351
117, 112, 129, 143, 142, 157, 165, 147, // 65352-65359
133, 142, 125, 121, 123, 108, 105, 113, // 65360-65367
 99,  98, 102,  94, 110, 131, 151, 166, // 65368-65375
181, 160, 150, 146, 118, 109, 122, 121, // 65376-65383
133, 143, 108,  96, 107, 106, 107, 130, // 65384-65391
137, 138, 157, 130,  99, 110, 116, 115, // 65392-65399
140, 142, 141, 159, 155, 137, 134, 137, // 65400-65407
122, 130, 123, 110, 112, 108,  92, 101, // 65408-65415
 99,  95, 121, 136, 153, 171, 172, 147, // 65416-65423
149, 140, 115, 120, 128, 123, 141, 136, // 65424-65431
 97,  99, 107, 104, 117, 138, 135, 145, // 65432-65439
153, 116, 100, 112, 111, 121, 144, 137, // 65440-65447
147, 159, 146, 135, 135, 132, 126, 135, // 65448-65455
120, 113, 114, 102,  94, 104,  94, 103, // 65456-65463
127, 135, 157, 171, 160, 143, 150, 134, // 65464-65471
117, 127, 125, 127, 143, 123,  92, 102, // 65472-65479
105, 109, 128, 139, 136, 148, 142, 106, // 65480-65487
103, 109, 114, 133, 146, 137, 150, 149, // 65488-65495
137, 134, 133, 133, 135, 138, 120, 117, // 65496-65503
107,  93,  95, 102,  96, 116, 131, 140, // 65504-65511
162, 163, 148, 142, 145, 129, 126, 131, // 65512-65519
125, 133, 141, 112,  95, 103, 104, 119, // 65520-65527
133, 138, 139, 148, 131, 104, 102, 107, // 65528-65535
122, 139, 144, 141, 149, 140, 136, 131, // 65536-65543
131, 138, 141, 135, 122, 116,  99,  93, // 65544-65551
 98,  99, 102, 125, 131, 145, 162, 152, // 65552-65559
142, 141, 141, 129, 132, 129, 127, 136, // 65560-65567
131, 104,  97, 103, 111, 131, 136, 140, // 65568-65575
142, 141, 122, 103, 101, 113, 132, 142, // 65576-65583
142, 140, 140, 131, 135, 127, 136, 146, // 65584-65591
144, 136, 124, 109,  94,  96,  97, 102, // 65592-65599
112, 126, 130, 150, 154, 146, 143, 139, // 65600-65607
139, 136, 133, 127, 130, 132, 121, 100, // 65608-65615
 97, 103, 122, 137, 137, 144, 139, 136, // 65616-65623
121, 104, 106, 123, 135, 137, 138, 133, // 65624-65631
129, 130, 133, 126, 140, 143, 137, 131, // 65632-65639
122, 109, 105, 108, 109, 116, 123, 128, // 65640-65647
130, 140, 138, 136, 135, 135, 137, 134, // 65648-65655
129, 125, 125, 122, 119, 112, 114, 122, // 65656-65663
130, 133, 134, 134, 130, 129, 122, 118, // 65664-65671
123, 129, 131, 132, 129, 126, 125, 125, // 65672-65679
127, 127, 134, 134, 132, 127, 122, 119, // 65680-65687
119, 121, 122, 127, 130, 132, 131, 132, // 65688-65695
129, 129, 129, 129, 130, 128, 127, 124, // 65696-65703
124, 124, 122, 121, 126, 127, 131, 131, // 65704-65711
130, 131, 129, 129, 124, 124, 125, 128, // 65712-65719
127, 126, 126, 126, 127, 128, 129, 128, // 65720-65727
131, 129, 126, 124, 124, 122, 126, 128, // 65728-65735
127, 128, 130, 129, 129, 132, 128, 128, // 65736-65743
128, 127, 125, 124, 121, 122, 123, 123, // 65744-65751
124, 127, 129, 130, 132, 129, 128, 130, // 65752-65759
128, 128, 126, 125, 126, 129, 127, 126, // 65760-65767
126, 127, 128, 128, 127, 126, 129, 127, // 65768-65775
125, 124, 123, 123, 127, 127, 126, 129, // 65776-65783
130, 130, 132, 131, 129, 130, 128, 126, // 65784-65791
125, 123, 122, 123, 125, 125, 126, 127, // 65792-65799
128, 129, 129, 127, 129, 130, 130, 129, // 65800-65807
127, 125, 126, 126, 124, 125, 126, 128, // 65808-65815
130, 129, 125, 126, 127, 125, 126, 125, // 65816-65823
125, 127, 128, 127, 127, 127, 129, 129, // 65824-65831
129, 128, 128, 129, 128, 126, 125, 123, // 65832-65839
124, 125, 125, 127, 126, 126, 128, 129, // 65840-65847
128, 128, 130, 130, 130, 130, 125, 125, // 65848-65855
126, 126, 127, 127, 126, 127, 128, 126, // 65856-65863
124, 125, 126, 128, 129, 126, 127, 128, // 65864-65871
127, 126, 127, 127, 129, 130, 128, 127, // 65872-65879
129, 127, 125, 126, 124, 124, 127, 125, // 65880-65887
127, 129, 127, 126, 128, 127, 127, 129, // 65888-65895
128, 129, 132, 128, 125, 126, 125, 125, // 65896-65903
127, 126, 125, 129, 129, 125, 125, 127, // 65904-65911
125, 129, 127, 124, 128, 130, 128, 128, // 65912-65919
127, 127, 129, 128, 126, 127, 128, 126, // 65920-65927
127, 126, 124, 125, 126, 124, 127, 127, // 65928-65935
126, 126, 128, 127, 128, 130, 128, 129, // 65936-65943
131, 127, 125, 127, 126, 127, 128, 125, // 65944-65951
126, 129, 127, 124, 125, 126, 127, 130, // 65952-65959
128, 125, 128, 126, 125, 125, 126, 127, // 65960-65967
129, 129, 127, 129, 129, 126, 126, 126, // 65968-65975
125, 126, 125, 124, 128, 128, 126, 126, // 65976-65983
127, 127, 129, 131, 129, 131, 132, 127, // 65984-65991
125, 124, 124, 125, 125, 124, 126, 128, // 65992-65999
126, 125, 125, 128, 129, 130, 128, 127, // 66000-66007
128, 127, 126, 126, 127, 129, 129, 127, // 66008-66015
127, 128, 128, 128, 128, 125, 125, 126, // 66016-66023
124, 124, 127, 127, 126, 127, 127, 128, // 66024-66031
129, 129, 129, 131, 130, 127, 125, 125, // 66032-66039
125, 126, 126, 124, 125, 127, 126, 125, // 66040-66047
127, 129, 131, 132, 129, 129, 129, 127, // 66048-66055
126, 125, 125, 127, 127, 126, 125, 127, // 66056-66063
127, 126, 126, 126, 126, 127, 126, 127, // 66064-66071
128, 128, 127, 126, 127, 128, 130, 129, // 66072-66079
129, 130, 129, 126, 123, 124, 125, 126, // 66080-66087
125, 124, 124, 127, 126, 126, 128, 130, // 66088-66095
132, 131, 129, 128, 129, 128, 127, 127, // 66096-66103
128, 128, 126, 124, 124, 126, 125, 126, // 66104-66111
127, 128, 127, 127, 126, 126, 128, 127, // 66112-66119
127, 126, 128, 127, 130, 127, 128, 130, // 66120-66127
128, 127, 126, 126, 127, 128, 126, 125, // 66128-66135
125, 125, 123, 125, 126, 129, 132, 130, // 66136-66143
128, 129, 128, 126, 129, 128, 128, 128, // 66144-66151
126, 123, 124, 126, 125, 127, 127, 128, // 66152-66159
128, 127, 126, 128, 128, 127, 128, 127, // 66160-66167
127, 128, 129, 127, 129, 130, 127, 127, // 66168-66175
127, 126, 127, 126, 124, 125, 125, 124, // 66176-66183
124, 126, 126, 129, 131, 128, 130, 130, // 66184-66191
129, 129, 130, 129, 129, 129, 125, 123, // 66192-66199
125, 124, 124, 126, 125, 126, 128, 126, // 66200-66207
125, 128, 127, 126, 127, 127, 127, 129, // 66208-66215
128, 127, 131, 129, 128, 129, 127, 127, // 66216-66223
129, 127, 123, 126, 124, 121, 123, 125, // 66224-66231
125, 130, 130, 128, 130, 130, 129, 129, // 66232-66239
129, 128, 128, 127, 124, 124, 126, 124, // 66240-66247
126, 127, 126, 128, 126, 126, 128, 128, // 66248-66255
127, 128, 128, 126, 126, 127, 125, 128, // 66256-66263
130, 129, 129, 129, 127, 127, 127, 126, // 66264-66271
126, 126, 125, 124, 125, 125, 127, 128, // 66272-66279
128, 128, 130, 130, 129, 129, 129, 129, // 66280-66287
127, 127, 124, 125, 125, 125, 128, 126, // 66288-66295
126, 127, 126, 126, 127, 127, 128, 128, // 66296-66303
128, 126, 127, 126, 126, 129, 129, 128, // 66304-66311
129, 129, 127, 128, 127, 126, 127, 127, // 66312-66319
125, 124, 125, 125, 126, 127, 127, 128, // 66320-66327
129, 129, 130, 129, 129, 128, 127, 127, // 66328-66335
125, 125, 124, 126, 127, 126, 128, 126, // 66336-66343
126, 128, 129, 128, 129, 129, 127, 127, // 66344-66351
126, 125, 126, 129, 128, 128, 129, 127, // 66352-66359
126, 127, 126, 126, 126, 126, 125, 125, // 66360-66367
126, 126, 127, 126, 128, 128, 128, 129, // 66368-66375
129, 129, 130, 129, 127, 126, 126, 124, // 66376-66383
124, 127, 126, 127, 128, 126, 125, 128, // 66384-66391
127, 127, 129, 128, 127, 127, 126, 124, // 66392-66399
127, 128, 127, 128, 128, 127, 127, 127, // 66400-66407
126, 126, 127, 127, 126, 127, 127, 127, // 66408-66415
128, 127, 128, 128, 127, 128, 128, 128, // 66416-66423
129, 128, 126, 126, 126, 124, 125, 127, // 66424-66431
127, 129, 129, 126, 126, 128, 127, 127, // 66432-66439
129, 129, 128, 127, 125, 124, 126, 127, // 66440-66447
127, 129, 129, 128, 128, 127, 126, 127, // 66448-66455
127, 126, 126, 126, 127, 126, 126, 127, // 66456-66463
129, 129, 128, 128, 128, 128, 128, 126, // 66464-66471
124, 126, 126, 125, 127, 128, 128, 129, // 66472-66479
128, 126, 127, 128, 127, 127, 129, 128, // 66480-66487
127, 126, 124, 125, 127, 127, 128, 130, // 66488-66495
130, 129, 127, 127, 126, 126, 128, 127, // 66496-66503
128, 126, 126, 125, 125, 126, 128, 128, // 66504-66511
129, 129, 129, 128, 127, 126, 125, 126, // 66512-66519
125, 125, 126, 127, 127, 127, 127, 126, // 66520-66527
128, 128, 129, 129, 129, 128, 127, 125, // 66528-66535
123, 125, 126, 127, 128, 129, 128, 128, // 66536-66543
126, 127, 127, 127, 128, 127, 127, 127, // 66544-66551
126, 125, 124, 125, 128, 128, 130, 130, // 66552-66559
130, 129, 127, 126, 125, 126, 125, 125, // 66560-66567
126, 126, 127, 126, 126, 127, 128, 129, // 66568-66575
130, 129, 129, 128, 126, 124, 123, 125, // 66576-66583
127, 129, 130, 129, 129, 128, 126, 126, // 66584-66591
126, 128, 127, 128, 128, 126, 125, 124, // 66592-66599
124, 126, 129, 129, 130, 131, 129, 128, // 66600-66607
127, 125, 125, 127, 126, 126, 126, 127, // 66608-66615
126, 127, 127, 127, 128, 129, 130, 129, // 66616-66623
129, 127, 126, 125, 124, 127, 126, 128, // 66624-66631
130, 130, 128, 128, 125, 125, 127, 127, // 66632-66639
127, 128, 127, 125, 125, 124, 123, 127, // 66640-66647
130, 129, 129, 130, 128, 127, 126, 125, // 66648-66655
126, 128, 128, 128, 127, 125, 126, 125, // 66656-66663
125, 127, 128, 129, 129, 128, 126, 126, // 66664-66671
125, 123, 126, 127, 128, 130, 131, 129, // 66672-66679
128, 127, 125, 126, 128, 127, 127, 128, // 66680-66687
126, 124, 124, 124, 126, 128, 129, 129, // 66688-66695
129, 128, 127, 127, 125, 125, 126, 128, // 66696-66703
129, 129, 127, 126, 126, 125, 125, 127, // 66704-66711
127, 129, 128, 127, 126, 125, 124, 125, // 66712-66719
128, 129, 129, 131, 130, 128, 127, 126, // 66720-66727
125, 127, 127, 126, 127, 126, 125, 125, // 66728-66735
125, 125, 127, 129, 130, 130, 129, 128, // 66736-66743
127, 127, 126, 128, 127, 129, 129, 128, // 66744-66751
127, 127, 126, 124, 127, 126, 127, 128, // 66752-66759
128, 126, 126, 125, 124, 126, 129, 129, // 66760-66767
129, 131, 129, 128, 127, 125, 127, 128, // 66768-66775
128, 128, 127, 125, 126, 124, 124, 124, // 66776-66783
126, 128, 130, 130, 127, 128, 127, 125, // 66784-66791
126, 128, 127, 130, 129, 127, 126, 125, // 66792-66799
125, 125, 128, 128, 128, 129, 128, 125, // 66800-66807
124, 124, 125, 128, 128, 129, 129, 129, // 66808-66815
128, 128, 126, 126, 127, 128, 127, 127, // 66816-66823
125, 125, 126, 125, 125, 126, 128, 129, // 66824-66831
130, 129, 127, 127, 127, 126, 126, 127, // 66832-66839
128, 130, 129, 127, 125, 126, 126, 127, // 66840-66847
128, 127, 127, 128, 126, 124, 124, 124, // 66848-66855
127, 130, 130, 129, 128, 128, 127, 126, // 66856-66863
125, 126, 127, 129, 129, 127, 125, 126, // 66864-66871
128, 126, 126, 127, 128, 130, 130, 127, // 66872-66879
125, 125, 125, 125, 126, 127, 128, 129, // 66880-66887
129, 127, 126, 126, 127, 128, 128, 127, // 66888-66895
127, 127, 125, 125, 125, 126, 127, 129, // 66896-66903
130, 128, 128, 127, 128, 127, 126, 126, // 66904-66911
126, 127, 127, 126, 125, 126, 127, 128, // 66912-66919
127, 128, 129, 130, 129, 125, 124, 125, // 66920-66927
125, 125, 127, 127, 129, 130, 128, 126, // 66928-66935
126, 126, 128, 129, 128, 127, 126, 125, // 66936-66943
124, 125, 125, 127, 130, 131, 130, 128, // 66944-66951
126, 126, 126, 125, 125, 126, 127, 127, // 66952-66959
126, 124, 125, 126, 129, 129, 128, 129, // 66960-66967
128, 130, 128, 126, 125, 124, 126, 126, // 66968-66975
126, 127, 128, 129, 128, 126, 126, 126, // 66976-66983
127, 128, 128, 127, 126, 125, 124, 126, // 66984-66991
126, 128, 130, 131, 129, 129, 127, 125, // 66992-66999
126, 126, 126, 126, 127, 126, 127, 126, // 67000-67007
126, 127, 129, 128, 128, 129, 128, 128, // 67008-67015
126, 125, 126, 127, 127, 128, 127, 128, // 67016-67023
128, 128, 127, 127, 127, 127, 128, 128, // 67024-67031
127, 126, 124, 123, 124, 126, 127, 130, // 67032-67039
130, 130, 129, 128, 126, 126, 128, 127, // 67040-67047
127, 126, 126, 125, 126, 125, 126, 128, // 67048-67055
130, 130, 129, 127, 126, 127, 126, 125, // 67056-67063
125, 126, 127, 128, 128, 129, 129, 128, // 67064-67071
128, 128, 127, 127, 127, 126, 126, 125, // 67072-67079
123, 124, 125, 126, 129, 131, 130, 129, // 67080-67087
129, 128, 126, 126, 128, 127, 127, 126, // 67088-67095
125, 124, 126, 125, 127, 129, 130, 130, // 67096-67103
129, 127, 126, 126, 125, 125, 126, 127, // 67104-67111
127, 128, 128, 128, 128, 127, 127, 129, // 67112-67119
128, 128, 127, 124, 124, 125, 124, 124, // 67120-67127
126, 128, 129, 130, 129, 128, 129, 128, // 67128-67135
126, 127, 127, 127, 128, 126, 125, 125, // 67136-67143
126, 125, 127, 129, 129, 129, 128, 126, // 67144-67151
125, 126, 125, 126, 127, 127, 127, 127, // 67152-67159
126, 128, 129, 128, 129, 130, 128, 127, // 67160-67167
126, 125, 125, 126, 125, 124, 127, 127, // 67168-67175
127, 129, 127, 127, 130, 128, 127, 128, // 67176-67183
127, 127, 128, 126, 125, 127, 127, 127, // 67184-67191
128, 128, 128, 129, 127, 126, 126, 126, // 67192-67199
126, 127, 127, 127, 127, 127, 127, 128, // 67200-67207
128, 128, 130, 129, 127, 127, 125, 125, // 67208-67215
126, 126, 125, 126, 126, 126, 128, 128, // 67216-67223
127, 130, 130, 128, 128, 126, 125, 126, // 67224-67231
127, 126, 126, 127, 127, 128, 127, 126, // 67232-67239
127, 128, 127, 127, 127, 127, 127, 127, // 67240-67247
126, 126, 126, 128, 128, 130, 129, 129, // 67248-67255
130, 127, 125, 125, 124, 125, 127, 128, // 67256-67263
126, 126, 125, 125, 127, 128, 128, 130, // 67264-67271
130, 129, 128, 125, 124, 125, 126, 125, // 67272-67279
126, 127, 128, 129, 128, 127, 128, 127, // 67280-67287
126, 126, 126, 126, 127, 127, 126, 126, // 67288-67295
126, 127, 128, 129, 129, 129, 128, 126, // 67296-67303
125, 126, 125, 126, 127, 127, 127, 126, // 67304-67311
126, 126, 127, 128, 129, 129, 129, 128, // 67312-67319
127, 124, 125, 127, 126, 127, 127, 127, // 67320-67327
128, 129, 127, 127, 127, 128, 128, 128, // 67328-67335
127, 127, 127, 125, 124, 125, 125, 127, // 67336-67343
129, 130, 130, 129, 127, 125, 126, 126, // 67344-67351
127, 128, 128, 128, 126, 125, 124, 125, // 67352-67359
128, 128, 130, 130, 130, 129, 127, 125, // 67360-67367
126, 126, 126, 127, 127, 127, 128, 127, // 67368-67375
125, 125, 127, 128, 129, 129, 129, 128, // 67376-67383
126, 124, 123, 125, 126, 128, 129, 130, // 67384-67391
129, 128, 126, 126, 127, 128, 129, 128, // 67392-67399
126, 126, 125, 123, 124, 126, 128, 129, // 67400-67407
131, 130, 129, 128, 127, 125, 126, 127, // 67408-67415
126, 128, 127, 127, 126, 126, 125, 126, // 67416-67423
127, 128, 130, 130, 129, 128, 125, 124, // 67424-67431
124, 126, 128, 129, 130, 129, 128, 126, // 67432-67439
125, 125, 127, 129, 128, 128, 127, 126, // 67440-67447
125, 123, 123, 126, 129, 129, 130, 130, // 67448-67455
129, 128, 126, 124, 126, 127, 128, 128, // 67456-67463
128, 125, 126, 125, 124, 126, 128, 129, // 67464-67471
130, 129, 128, 126, 126, 124, 125, 126, // 67472-67479
127, 127, 130, 128, 128, 126, 126, 127, // 67480-67487
129, 129, 128, 129, 126, 126, 125, 124, // 67488-67495
124, 128, 128, 129, 128, 128, 128, 128, // 67496-67503
126, 126, 128, 129, 151, 152, 117,  99, // 67504-67511
 48,  54, 156, 120, 127, 222, 198,  83, // 67512-67519
 80, 101, 122,  17, 246, 175, 173,  93, // 67520-67527
 18,  16, 246, 255, 112, 136, 151, 177, // 67528-67535
140,  47, 110,  86,  15,  86,  61,  87, // 67536-67543
205, 213,  96, 149, 176, 182, 241,  28, // 67544-67551
227,  37,  63,  94, 252, 192, 166, 242, // 67552-67559
 72,  38, 103, 175, 141,  89, 104, 133, // 67560-67567
217,  84,  13, 242, 190,  91,  60,  46, // 67568-67575
 20,  81, 153, 148, 181, 168,  95,  46, // 67576-67583
109,  57,  56, 102,  45, 112, 193, 145, // 67584-67591
 81, 138, 147, 205,   4,   5, 225,  45, // 67592-67599
247,  59, 244, 168, 200,  32,  68,  56, // 67600-67607
120, 138, 123,  87,  99, 159,  10,  72, // 67608-67615
 13, 243, 138,  75,  62,  27,  47, 127, // 67616-67623
149, 161, 189, 127,  70,  60,  99,  64, // 67624-67631
107,  95,  56, 141, 163, 112,  90, 127, // 67632-67639
157, 246,   5, 253, 236,  23, 192,  53, // 67640-67647
223, 175, 255,  50,  73,  80, 104, 112, // 67648-67655
121,  73, 112, 205,  27,  59,  19, 207, // 67656-67663
 94,  80,  47,  27,  96, 143, 144, 181, // 67664-67671
165,  88,  71,  61,  92,  98, 132,  81, // 67672-67679
 86, 139, 126, 105,  88, 118, 193,  10, // 67680-67687
250,   6, 229, 242, 164,  39, 201, 217, // 67688-67695
 37,  54,  93,  83,  75, 111, 112,  59, // 67696-67703
152, 237,  29,  63,   6, 153,  78,  79, // 67704-67711
 22,  57, 134, 137, 155, 187, 123,  78, // 67712-67719
 73,  50, 111, 132, 129,  82, 106, 110, // 67720-67727
111, 104,  75, 136, 236,   3, 252,   9, // 67728-67735
196, 220, 144,  10, 209,  13,  44,  64, // 67736-67743
108,  54,  60, 121,  88,  71, 203, 243, // 67744-67751
 33,  66, 219, 114,  82,  62,  22, 108, // 67752-67759
143, 134, 174, 162,  87,  85,  57,  55, // 67760-67767
150, 143, 124,  96,  99,  82, 117,  89, // 67768-67775
 72, 177, 254, 246,  14, 238, 164, 216, // 67776-67783
114, 248, 246,  45,  43,  93, 100,  23, // 67784-67791
 71, 118,  68, 113, 235, 236,  52,  46, // 67792-67799
168, 102,  81,  41,  52, 143, 134, 147, // 67800-67807
172, 122,  76,  89,  40,  90, 178, 138, // 67808-67815
130,  97,  73,  77, 122,  68,  98, 214, // 67816-67823
249, 248,  16, 190, 157, 210,  76,   3, // 67824-67831
 32,  52,  55, 112,  64,  11,  89, 102, // 67832-67839
 72, 163, 239, 241,  65, 253, 135, 102, // 67840-67847
 66,  44,  96, 154, 132, 161, 145,  92, // 67848-67855
 82,  77,  42, 139, 181, 138, 139,  76, // 67856-67863
 52,  89, 112,  62, 142, 230, 241,   4, // 67864-67871
246, 146, 171, 188,  53,  36,  53,  53, // 67872-67879
 79, 106,  28,  21,  93,  88, 103, 196, // 67880-67887
232,   2,  53, 199, 126,  94,  54,  71, // 67888-67895
127, 153, 141, 158, 109,  85,  82,  62, // 67896-67903
 70, 172, 169, 149, 130,  44,  54,  99, // 67904-67911
 96,  83, 180, 226, 247,   4, 201, 130, // 67912-67919
184, 155,  59,  69,  55,  65,  92,  77, // 67920-67927
 10,  37,  86,  94, 138, 206, 234,  15, // 67928-67935
 14, 165, 127,  74,  63, 104, 138, 155, // 67936-67943
150, 131,  86,  90,  72,  66, 110, 184, // 67944-67951
163, 161,  96,  24,  67,  94,  93, 118, // 67952-67959
195, 223,   3, 234, 165, 135, 179, 134, // 67960-67967
 83,  79,  55,  85,  83,  50,  13,  44, // 67968-67975
 84, 119, 160, 210, 246,   6, 228, 155, // 67976-67983
117,  62,  93, 121, 139, 164, 140,  99, // 67984-67991
 84,  88,  65,  92, 139, 182, 169, 156, // 67992-67999
 56,  28,  76,  88, 110, 145, 194, 233, // 68000-68007
254, 195, 148, 139, 167, 134, 104,  75, // 68008-68015
 70,  93,  58,  38,  18,  42, 101, 146, // 68016-68023
164, 222, 248, 230, 201, 149,  97,  70, // 68024-68031
123, 121, 152, 167, 112,  82,  91,  74, // 68032-68039
 73, 121, 149, 186, 178, 129,  30,  44, // 68040-68047
 71,  94, 136, 154, 199, 245, 225, 166, // 68048-68055
145, 133, 165, 147, 107,  70,  87,  77, // 68056-68063
 39,  44,  15,  51, 133, 154, 170, 240, // 68064-68071
230, 205, 195, 136,  86,  98, 136, 118, // 68072-68079
171, 150,  82,  82,  89,  66, 102, 137, // 68080-68087
151, 197, 169,  93,  25,  54,  65, 121, // 68088-68095
151, 152, 213, 238, 189, 158, 140, 127, // 68096-68103
180, 156,  99,  82,  93,  50,  38,  45, // 68104-68111
  6,  79, 155, 150, 188, 244, 198, 195, // 68112-68119
188, 116,  93, 125, 130, 127, 180, 114, // 68120-68127
 69,  88,  76,  76, 133, 138, 164, 203, // 68128-68135
142,  70,  34,  54,  77, 151, 150, 160, // 68136-68143
224, 210, 164, 157, 124, 136, 200, 147, // 68144-68151
 98,  94,  77,  30,  48,  34,  13, 118, // 68152-68159
159, 152, 209, 224, 172, 198, 170, 109, // 68160-68167
117, 137, 126, 145, 167,  82,  72,  81, // 68168-68175
 70, 104, 146, 136, 182, 188, 113,  63, // 68176-68183
 34,  53, 107, 170, 145, 178, 216, 177, // 68184-68191
157, 150, 113, 163, 208, 136, 108,  92, // 68192-68199
 51,  27,  53,  20,  41, 145, 150, 164, // 68200-68207
214, 192, 165, 198, 149, 122, 138, 138, // 68208-68215
132, 155, 139,  67,  76,  69,  83, 129, // 68216-68223
146, 142, 190, 158,  97,  59,  29,  70, // 68224-68231
138, 169, 148, 191, 191, 160, 159, 134, // 68232-68239
120, 194, 199, 131, 114,  73,  36,  36, // 68240-68247
 48,  23,  79, 152, 148, 178, 198, 169, // 68248-68255
169, 186, 140, 144, 142, 137, 140, 147, // 68256-68263
113,  66,  72,  68, 111, 140, 143, 155, // 68264-68271
180, 130,  96,  48,  33, 100, 154, 164, // 68272-68279
158, 185, 164, 158, 153, 124, 144, 210, // 68280-68287
183, 134, 107,  49,  35,  39,  41,  45, // 68288-68295
109, 151, 156, 181, 176, 162, 170, 170, // 68296-68303
148, 158, 137, 145, 138, 128,  99,  66, // 68304-68311
 63,  83, 131, 139, 150, 161, 157, 117, // 68312-68319
 93,  34,  55, 127, 158, 166, 164, 166, // 68320-68327
152, 159, 137, 128, 169, 207, 173, 135, // 68328-68335
 83,  37,  43,  35,  50,  71, 121, 152, // 68336-68343
165, 168, 161, 162, 162, 166, 165, 157, // 68344-68351
137, 152, 123, 115,  95,  60,  66, 111, // 68352-68359
139, 141, 157, 149, 136, 116,  81,  32, // 68360-68367
 90, 140, 159, 173, 155, 146, 151, 152, // 68368-68375
129, 147, 184, 201, 172, 124,  59,  41, // 68376-68383
 43,  34,  72,  89, 128, 161, 161, 149, // 68384-68391
158, 157, 154, 177, 174, 150, 145, 147, // 68392-68399
102, 115,  88,  54,  86, 131, 137, 149, // 68400-68407
156, 130, 128, 113,  65,  49, 116, 140, // 68408-68415
170, 171, 135, 139, 152, 140, 137, 166, // 68416-68423
186, 198, 165,  98,  46,  48,  37,  51, // 68424-68431
 96,  96, 139, 163, 144, 139, 161, 147, // 68432-68439
161, 192, 172, 148, 152, 128,  93, 119, // 68440-68447
 73,  61, 110, 136, 137, 156, 138, 115, // 68448-68455
128, 103,  61,  77, 131, 143, 180, 154, // 68456-68463
121, 143, 146, 135, 153, 174, 185, 200, // 68464-68471
147,  76,  49,  48,  36,  77, 106,  99, // 68472-68479
152, 153, 127, 141, 157, 139, 180, 199, // 68480-68487
164, 152, 148, 105,  96, 116,  60,  80, // 68488-68495
124, 132, 141, 155, 120, 116, 129,  91, // 68496-68503
 70,  99, 134, 153, 180, 133, 120, 145, // 68504-68511
135, 143, 166, 172, 189, 194, 121,  67, // 68512-68519
 53,  43,  49, 102, 103, 108, 159, 132, // 68520-68527
120, 146, 146, 143, 197, 190, 160, 155, // 68528-68535
133,  95, 107, 107,  64, 103, 128, 135, // 68536-68543
150, 140, 106, 120, 117,  88,  86, 109, // 68544-68551
138, 164, 166, 116, 126, 138, 133, 160, // 68552-68559
171, 173, 197, 176,  98,  67,  51,  45, // 68560-68567
 73, 113,  99, 122, 150, 113, 124, 144, // 68568-68575
139, 161, 205, 182, 164, 149, 116,  94, // 68576-68583
113,  98,  78, 119, 128, 145, 147, 121, // 68584-68591
103, 120, 108,  96,  98, 113, 145, 164, // 68592-68599
145, 109, 128, 130, 146, 173, 167, 179, // 68600-68607
197, 150,  89,  68,  44,  57,  92, 113, // 68608-68615
104, 132, 133, 107, 130, 138, 146, 177, // 68616-68623
200, 178, 166, 132, 107,  97, 110,  98, // 68624-68631
 97, 121, 131, 151, 131, 108, 105, 113, // 68632-68639
107, 109,  98, 121, 154, 154, 131, 113, // 68640-68647
126, 132, 164, 174, 166, 188, 181, 128, // 68648-68655
 86,  60,  45,  77, 101, 114, 113, 129, // 68656-68663
115, 112, 130, 136, 160, 185, 195, 181, // 68664-68671
155, 114, 106,  95, 110, 108, 108, 122, // 68672-68679
140, 145, 115, 108, 105, 110, 121, 115, // 68680-68687
 98, 133, 152, 139, 127, 113, 122, 144, // 68688-68695
175, 167, 173, 186, 159, 118,  84,  53, // 68696-68703
 61,  93, 104, 121, 115, 117, 109, 114, // 68704-68711
125, 145, 173, 184, 196, 178, 136, 108, // 68712-68719
105,  91, 119, 117, 110, 128, 146, 130, // 68720-68727
108, 109,  99, 116, 133, 111, 105, 143, // 68728-68735
138, 130, 125, 107, 126, 161, 176, 166, // 68736-68743
181, 172, 143, 114,  75,  55,  82,  99, // 68744-68751
108, 127, 108, 109, 109, 113, 126, 161, // 68752-68759
175, 184, 200, 164, 119, 109,  97,  93, // 68760-68767
134, 118, 112, 138, 140, 115, 110, 105, // 68768-68775
 96, 131, 138, 107, 118, 142, 125, 132, // 68776-68783
119, 104, 140, 170, 172, 170, 178, 154, // 68784-68791
137, 108,  67,  67,  95,  98, 119, 126, // 68792-68799
 96, 108, 108, 111, 138, 174, 172, 191, // 68800-68807
195, 144, 112, 108,  89, 106, 145, 113, // 68808-68815
120, 140, 126, 109, 112,  97, 105, 147, // 68816-68823
133, 109, 126, 129, 118, 134, 110, 111, // 68824-68831
156, 171, 172, 175, 166, 143, 136,  97, // 68832-68839
 69,  84,  99, 101, 128, 114,  90, 111, // 68840-68847
102, 116, 155, 177, 171, 196, 178, 128, // 68848-68855
112, 100,  86, 126, 146, 111, 129, 133, // 68856-68863
116, 111, 109,  95, 123, 152, 129, 115, // 68864-68871
124, 118, 121, 129, 104, 127, 162, 169, // 68872-68879
176, 169, 152, 139, 128,  88,  80,  95, // 68880-68887
100, 111, 130,  98,  93, 110,  98, 130, // 68888-68895
166, 172, 177, 195, 159, 124, 111,  94, // 68896-68903
 97, 142, 139, 115, 132, 121, 112, 112, // 68904-68911
102, 102, 137, 150, 128, 117, 114, 114, // 68912-68919
124, 121, 107, 142, 161, 172, 177, 156, // 68920-68927
144, 140, 119,  89,  95,  98, 105, 120, // 68928-68935
120,  90, 100, 102, 102, 145, 167, 171, // 68936-68943
180, 182, 144, 122, 105,  95, 113, 148, // 68944-68951
134, 121, 125, 112, 116, 109, 103, 117, // 68952-68959
144, 146, 129, 112, 107, 116, 124, 118, // 68960-68967
117, 147, 157, 177, 170, 146, 144, 134, // 68968-68975
110,  97,  99,  96, 111, 119, 110,  90, // 68976-68983
103,  96, 115, 155, 165, 174, 178, 167, // 68984-68991
139, 121, 101, 103, 125, 149, 134, 124, // 68992-68999
117, 111, 118, 105, 109, 123, 142, 146, // 69000-69007
127, 102, 107, 117, 119, 120, 128, 148, // 69008-69015
161, 181, 157, 145, 145, 127, 112, 107, // 69016-69023
100, 102, 118, 112, 103,  92,  99,  97, // 69024-69031
129, 157, 167, 177, 167, 155, 135, 114, // 69032-69039
101, 115, 130, 149, 136, 117, 109, 114, // 69040-69047
114, 105, 122, 127, 142, 147, 116,  96, // 69048-69055
111, 115, 119, 130, 135, 149, 167, 173, // 69056-69063
143, 145, 139, 121, 120, 113, 102, 112, // 69064-69071
114, 103, 101,  91,  97, 107, 140, 156, // 69072-69079
171, 170, 153, 149, 131, 108, 112, 123, // 69080-69087
134, 154, 130, 108, 108, 114, 109, 114, // 69088-69095
128, 127, 149, 143, 104,  98, 113, 110, // 69096-69103
127, 136, 135, 155, 168, 159, 138, 145, // 69104-69111
129, 125, 126, 112, 108, 116, 104, 101, // 69112-69119
102,  89, 102, 119, 144, 159, 175, 157, // 69120-69127
148, 148, 123, 111, 122, 124, 140, 154, // 69128-69135
117, 103, 109, 110, 110, 125, 130, 131, // 69136-69143
154, 130,  96, 101, 109, 112, 138, 137, // 69144-69151
138, 160, 162, 147, 138, 141, 125, 134, // 69152-69159
126, 111, 113, 111,  96, 104,  96,  90, // 69160-69167
114, 125, 147, 165, 170, 146, 149, 143, // 69168-69175
117, 119, 126, 123, 146, 147, 106, 104, // 69176-69183
108, 109, 118, 133, 128, 138, 153, 116, // 69184-69191
 97, 105, 107, 121, 145, 134, 145, 159, // 69192-69199
151, 143, 138, 135, 129, 140, 122, 114, // 69200-69207
114, 101,  94, 106,  92,  99, 122, 128, // 69208-69215
152, 168, 159, 140, 150, 134, 120, 129, // 69216-69223
126, 128, 151, 132,  99, 106, 104, 111, // 69224-69231
127, 133, 129, 144, 142, 107, 101, 105, // 69232-69239
111, 134, 145, 136, 152, 152, 144, 141, // 69240-69247
135, 133, 136, 138, 118, 119, 109,  96, // 69248-69255
 99, 103,  91, 111, 124, 131, 157, 162, // 69256-69263
148, 141, 146, 129, 129, 133, 127, 137, // 69264-69271
149, 121, 102, 107, 102, 119, 128, 129, // 69272-69279
132, 142, 128, 105, 102, 104, 121, 140, // 69280-69287
143, 140, 152, 142, 143, 137, 131, 137, // 69288-69295
140, 134, 122, 118, 101,  95, 100,  99, // 69296-69303
 99, 120, 123, 138, 158, 151, 142, 140, // 69304-69311
141, 132, 136, 131, 129, 141, 138, 112, // 69312-69319
102, 101, 107, 127, 128, 133, 134, 135, // 69320-69327
122, 104,  99, 109, 133, 144, 145, 144, // 69328-69335
144, 136, 142, 130, 134, 144, 141, 134, // 69336-69343
124, 111,  94,  96,  96,  99, 108, 122, // 69344-69351
124, 147, 154, 145, 143, 138, 140, 140, // 69352-69359
139, 131, 135, 138, 129, 108,  98, 100, // 69360-69367
118, 131, 128, 136, 130, 128, 119, 103, // 69368-69375
103, 121, 137, 142, 145, 141, 136, 137, // 69376-69383
139, 129, 139, 140, 135, 133, 123, 109, // 69384-69391
103, 105, 104, 112, 119, 123, 128, 140, // 69392-69399
137, 136, 133, 130, 137, 137, 133, 132, // 69400-69407
134, 131, 128, 119, 113, 116, 127, 127, // 69408-69415
128, 130, 124, 125, 122, 115, 117, 127, // 69416-69423
132, 135, 138, 133, 131, 132, 131, 129, // 69424-69431
134, 130, 129, 129, 123, 118, 117, 117, // 69432-69439
117, 123, 125, 125, 128, 132, 130, 131, // 69440-69447
128, 127, 132, 133, 131, 130, 130, 129, // 69448-69455
128, 125, 122, 123, 128, 128, 126, 126, // 69456-69463
122, 122, 121, 120, 123, 128, 131, 133, // 69464-69471
133, 131, 130, 131, 131, 131, 131, 128, // 69472-69479
127, 126, 124, 121, 120, 121, 123, 126, // 69480-69487
127, 126, 128, 128, 127, 126, 126, 127, // 69488-69495
131, 133, 132, 130, 130, 128, 127, 127, // 69496-69503
126, 126, 129, 126, 124, 121, 119, 120, // 69504-69511
123, 125, 126, 129, 131, 131, 131, 130, // 69512-69519
128, 131, 131, 130, 130, 128, 126, 125, // 69520-69527
125, 122, 123, 125, 126, 128, 129, 125, // 69528-69535
125, 127, 125, 126, 127, 127, 131, 133, // 69536-69543
130, 128, 129, 128, 128, 131, 128, 128, // 69544-69551
130, 125, 121, 120, 118, 121, 126, 127, // 69552-69559
127, 130, 130, 129, 130, 128, 128, 132, // 69560-69567
131, 129, 129, 126, 122, 125, 124, 123, // 69568-69575
126, 128, 128, 130, 129, 125, 127, 126, // 69576-69583
125, 125, 126, 126, 131, 132, 128, 129, // 69584-69591
129, 128, 131, 132, 128, 129, 128, 123, // 69592-69599
120, 118, 116, 122, 127, 126, 130, 131, // 69600-69607
130, 131, 132, 129, 131, 134, 131, 129, // 69608-69615
126, 121, 121, 124, 122, 124, 127, 127, // 69616-69623
129, 130, 127, 126, 128, 126, 125, 127, // 69624-69631
125, 126, 131, 129, 128, 129, 128, 129, // 69632-69639
132, 131, 128, 130, 126, 122, 120, 117, // 69640-69647
117, 124, 127, 127, 129, 128, 129, 131, // 69648-69655
130, 130, 134, 134, 132, 129, 124, 120, // 69656-69663
122, 123, 121, 125, 126, 126, 129, 128, // 69664-69671
125, 127, 128, 126, 128, 129, 128, 129, // 69672-69679
131, 127, 128, 127, 126, 129, 132, 129, // 69680-69687
129, 128, 124, 123, 121, 119, 121, 127, // 69688-69695
128, 129, 129, 126, 129, 131, 130, 131, // 69696-69703
133, 132, 131, 127, 122, 121, 123, 124, // 69704-69711
124, 127, 126, 127, 128, 127, 126, 128, // 69712-69719
128, 129, 129, 126, 126, 127, 129, 128, // 69720-69727
128, 127, 126, 129, 130, 129, 128, 126, // 69728-69735
124, 124, 121, 120, 123, 127, 128, 129, // 69736-69743
126, 126, 130, 131, 132, 131, 132, 132, // 69744-69751
130, 125, 121, 121, 125, 126, 126, 126, // 69752-69759
125, 126, 126, 126, 126, 127, 128, 130, // 69760-69767
129, 127, 126, 127, 128, 128, 128, 126, // 69768-69775
129, 130, 131, 129, 126, 124, 124, 123, // 69776-69783
121, 122, 125, 129, 129, 128, 125, 126, // 69784-69791
130, 132, 133, 131, 131, 130, 129, 123, // 69792-69799
122, 122, 126, 127, 128, 125, 125, 126, // 69800-69807
125, 126, 127, 128, 128, 130, 128, 127, // 69808-69815
126, 127, 129, 129, 129, 128, 130, 131, // 69816-69823
130, 127, 123, 123, 124, 122, 122, 123, // 69824-69831
124, 127, 128, 126, 124, 128, 131, 133, // 69832-69839
134, 132, 131, 130, 127, 123, 123, 124, // 69840-69847
127, 128, 127, 124, 125, 123, 124, 126, // 69848-69855
125, 127, 129, 129, 127, 127, 125, 128, // 69856-69863
132, 131, 129, 130, 131, 130, 130, 126, // 69864-69871
123, 124, 124, 122, 122, 123, 124, 127, // 69872-69879
127, 126, 127, 129, 131, 133, 132, 130, // 69880-69887
129, 128, 126, 125, 125, 126, 129, 129, // 69888-69895
127, 124, 123, 124, 127, 127, 127, 127, // 69896-69903
128, 127, 126, 124, 125, 128, 132, 132, // 69904-69911
130, 131, 130, 129, 128, 124, 122, 124, // 69912-69919
124, 123, 124, 125, 125, 127, 128, 126, // 69920-69927
127, 129, 132, 133, 133, 130, 128, 126, // 69928-69935
125, 124, 124, 126, 128, 128, 127, 125, // 69936-69943
123, 124, 127, 127, 126, 127, 127, 126, // 69944-69951
126, 125, 126, 130, 133, 132, 130, 130, // 69952-69959
129, 130, 128, 126, 124, 124, 122, 122, // 69960-69967
122, 123, 125, 126, 128, 128, 128, 130, // 69968-69975
132, 132, 130, 129, 127, 126, 128, 126, // 69976-69983
126, 128, 128, 128, 125, 124, 123, 126, // 69984-69991
127, 127, 126, 125, 125, 125, 125, 125, // 69992-69999
128, 131, 133, 133, 130, 129, 128, 129, // 70000-70007
128, 126, 124, 124, 123, 122, 122, 123, // 70008-70015
123, 127, 128, 128, 128, 130, 131, 132, // 70016-70023
131, 128, 127, 128, 127, 126, 127, 128, // 70024-70031
127, 127, 125, 123, 124, 126, 126, 127, // 70032-70039
126, 125, 125, 125, 125, 127, 129, 131, // 70040-70047
134, 132, 131, 130, 129, 128, 129, 126, // 70048-70055
124, 124, 122, 121, 122, 123, 123, 127, // 70056-70063
129, 128, 129, 131, 130, 131, 130, 128, // 70064-70071
128, 128, 127, 127, 128, 127, 128, 127, // 70072-70079
125, 124, 125, 125, 127, 127, 124, 124, // 70080-70087
124, 124, 125, 127, 129, 131, 134, 132, // 70088-70095
131, 130, 128, 128, 130, 126, 125, 125, // 70096-70103
122, 122, 123, 122, 124, 128, 128, 127, // 70104-70111
129, 129, 129, 131, 129, 127, 128, 128, // 70112-70119
127, 128, 128, 127, 128, 128, 125, 125, // 70120-70127
125, 124, 126, 126, 124, 124, 124, 124, // 70128-70135
127, 128, 130, 132, 132, 131, 131, 130, // 70136-70143
128, 130, 130, 126, 125, 123, 121, 122, // 70144-70151
123, 122, 125, 128, 128, 128, 129, 127, // 70152-70159
129, 131, 128, 128, 128, 128, 127, 129, // 70160-70167
127, 128, 127, 126, 126, 125, 126, 126, // 70168-70175
127, 126, 124, 124, 123, 125, 128, 129, // 70176-70183
131, 133, 131, 130, 129, 127, 127, 130, // 70184-70191
128, 126, 125, 123, 122, 123, 123, 123, // 70192-70199
127, 129, 128, 129, 128, 128, 130, 130, // 70200-70207
129, 128, 128, 127, 127, 127, 126, 127, // 70208-70215
127, 126, 127, 126, 125, 127, 127, 126, // 70216-70223
125, 124, 124, 127, 129, 128, 130, 132, // 70224-70231
131, 130, 129, 126, 128, 130, 127, 126, // 70232-70239
124, 122, 123, 123, 123, 125, 128, 130, // 70240-70247
129, 128, 127, 128, 129, 129, 129, 128, // 70248-70255
128, 127, 127, 126, 127, 126, 127, 127, // 70256-70263
127, 126, 126, 127, 126, 126, 125, 124, // 70264-70271
125, 128, 128, 129, 131, 130, 130, 128, // 70272-70279
127, 126, 128, 129, 128, 126, 125, 122, // 70280-70287
123, 123, 124, 126, 129, 129, 129, 126, // 70288-70295
127, 128, 128, 128, 129, 129, 129, 128, // 70296-70303
127, 127, 126, 127, 125, 127, 124, 127, // 70304-70311
124, 129, 125, 128, 124, 127, 126, 128, // 70312-70319
139, 163, 148, 113, 103,  46,  59,  79, // 70320-70327
142, 198, 244, 253, 145, 108, 152,  73, // 70328-70335
253,  74, 103, 132, 114,  43,  92, 136, // 70336-70343
183, 186, 141, 228,  37, 193, 151, 151, // 70344-70351
 80,  15, 221, 213,   3,  79, 166, 170, // 70352-70359
156,  39, 224,  12, 216, 189, 184, 218, // 70360-70367
 12,  97, 179, 247,   8, 174, 175, 222, // 70368-70375
135,  87, 161, 176, 208, 171, 111, 167, // 70376-70383
198, 244, 219, 183,  24,  59, 205, 178, // 70384-70391
160,  81,  22, 231, 224,  19,  93, 169, // 70392-70399
154, 165,  41, 176, 246, 206, 178, 181, // 70400-70407
216,  13,  98, 174, 240, 235, 150, 172, // 70408-70415
204, 110,  94, 167, 173, 206, 150, 107, // 70416-70423
159, 192, 231, 196, 183,  31,  35, 183, // 70424-70431
171, 140,  67,  16, 232, 233,  34, 107, // 70432-70439
173, 140, 184,  38, 137, 239, 211, 181, // 70440-70447
190, 235,  28, 109, 183, 241, 214, 142, // 70448-70455
179, 191, 100, 110, 170, 176, 205, 135, // 70456-70463
117, 168, 202, 231, 188, 191,  36,  13, // 70464-70471
170, 170, 126,  57,  13, 232, 240,  49, // 70472-70479
122, 176, 137, 211,  25, 103, 239, 214, // 70480-70487
185, 203, 252,  43, 123, 190, 241, 198, // 70488-70495
140, 187, 180,  91, 122, 168, 173, 197, // 70496-70503
124, 123, 169, 207, 224, 180, 206,  43, // 70504-70511
251, 170, 170, 113,  50,  10, 232, 250, // 70512-70519
 62, 134, 173, 133, 230,   5,  76, 240, // 70520-70527
219, 190, 217,  11,  55, 134, 200, 236, // 70528-70535
181, 142, 191, 164,  90, 138, 166, 178, // 70536-70543
186, 111, 126, 168, 204, 214, 173, 217, // 70544-70551
 42, 230, 166, 166, 102,  47,  14, 237, // 70552-70559
  7,  75, 144, 163, 135, 246, 231,  53, // 70560-70567
241, 219, 196, 234,  25,  70, 146, 206, // 70568-70575
229, 166, 145, 193, 151,  93, 150, 163, // 70576-70583
181, 174, 108, 133, 173, 208, 202, 168, // 70584-70591
228,  32, 207, 166, 158,  91,  45,  13, // 70592-70599
240,  21,  90, 155, 158, 147,   3, 199, // 70600-70607
 34, 241, 217, 200, 250,  35,  80, 156, // 70608-70615
212, 219, 155, 151, 191, 137,  99, 159, // 70616-70623
162, 185, 161, 105, 138, 175, 208, 193, // 70624-70631
171, 242,  25, 192, 165, 145,  76,  39, // 70632-70639
 11, 245,  37, 104, 163, 149, 160,   4, // 70640-70647
169,  26, 249, 222, 211,   9,  42,  88, // 70648-70655
160, 211, 205, 146, 159, 190, 125, 109, // 70656-70663
164, 157, 186, 147, 106, 145, 183, 208, // 70664-70671
184, 173, 249,   8, 180, 167, 137,  73, // 70672-70679
 42,  10, 246,  45, 111, 162, 141, 179, // 70680-70687
  4, 141,  20, 250, 219, 222,  27,  54, // 70688-70695
106, 176, 213, 191, 138, 159, 179, 114, // 70696-70703
120, 166, 163, 185, 134, 108, 146, 182, // 70704-70711
202, 176, 181,   3, 249, 172, 164, 123, // 70712-70719
 62,  41,   9,   3,  66, 126, 164, 135, // 70720-70727
189, 240, 110,  14, 254, 224, 238,  40, // 70728-70735
 61, 115, 178, 213, 181, 140, 172, 174, // 70736-70743
107, 130, 159, 157, 178, 123, 113, 153, // 70744-70751
190, 197, 169, 185,   2, 229, 165, 162, // 70752-70759
114,  61,  44,   8,   8,  76, 135, 163, // 70760-70767
138, 212, 228,  90,  14, 251, 219, 249, // 70768-70775
 47,  65, 129, 188, 209, 168, 138, 171, // 70776-70783
163, 109, 145, 163, 167, 173, 113, 114, // 70784-70791
151, 186, 188, 166, 198,   6, 215, 162, // 70792-70799
155,  99,  55,  43,   7,  23,  91, 143, // 70800-70807
157, 139, 218, 205,  73,  18,   3, 231, // 70808-70815
 14,  57,  72, 133, 185, 198, 156, 140, // 70816-70823
178, 153, 108, 151, 156, 166, 165, 113, // 70824-70831
125, 164, 194, 182, 161, 202, 251, 196, // 70832-70839
159, 149,  92,  58,  43,   6,  34, 100, // 70840-70847
149, 151, 149, 228, 182,  59,  18, 253, // 70848-70855
231,  28,  64,  85, 150, 197, 194, 149, // 70856-70863
143, 172, 137, 110, 153, 152, 168, 152, // 70864-70871
105, 125, 165, 190, 180, 171, 218, 250, // 70872-70879
186, 156, 137,  77,  55,  41,   8,  50, // 70880-70887
114, 155, 145, 157, 226, 159,  52,  24, // 70888-70895
  1, 245,  44,  66,  90, 153, 194, 185, // 70896-70903
146, 153, 178, 135, 118, 155, 146, 165, // 70904-70911
140, 107, 129, 172, 188, 170, 167, 219, // 70912-70919
236, 175, 160, 133,  76,  62,  39,   9, // 70920-70927
 61, 119, 155, 141, 171, 223, 137,  44, // 70928-70935
 22, 251, 252,  56,  73, 103, 164, 195, // 70936-70943
175, 139, 152, 168, 125, 129, 158, 152, // 70944-70951
171, 136, 106, 134, 173, 181, 167, 172, // 70952-70959
225, 226, 166, 153, 118,  67,  63,  39, // 70960-70967
 22,  81, 134, 158, 138, 178, 208, 114, // 70968-70975
 41,  27, 253,  12,  68,  73, 110, 168, // 70976-70983
192, 169, 142, 158, 164, 120, 133, 151, // 70984-70991
149, 163, 127, 111, 143, 180, 179, 165, // 70992-70999
176, 225, 210, 160, 152, 109,  66,  64, // 71000-71007
 32,  25,  87, 137, 156, 144, 197, 202, // 71008-71015
102,  42,  23, 249,  21,  72,  78, 122, // 71016-71023
176, 189, 160, 140, 158, 156, 120, 143, // 71024-71031
153, 154, 159, 120, 110, 144, 176, 174, // 71032-71039
165, 184, 229, 201, 160, 149,  98,  64, // 71040-71047
 65,  29,  38, 102, 144, 152, 146, 198, // 71048-71055
182,  88,  43,  28,   4,  40,  79,  82, // 71056-71063
128, 176, 181, 154, 142, 162, 150, 119, // 71064-71071
146, 147, 153, 155, 117, 116, 154, 177, // 71072-71079
168, 162, 187, 223, 189, 158, 143,  93, // 71080-71087
 68,  65,  29,  49, 109, 147, 147, 151, // 71088-71095
201, 166,  78,  42,  24,   5,  52,  83, // 71096-71103
 89, 142, 183, 177, 149, 142, 158, 141, // 71104-71111
122, 150, 147, 157, 146, 112, 118, 156, // 71112-71119
175, 167, 166, 195, 222, 179, 153, 134, // 71120-71127
 82,  67,  63,  29,  62, 120, 150, 145, // 71128-71135
160, 201, 149,  72,  44,  24,  15,  65, // 71136-71143
 83,  93, 146, 180, 170, 146, 146, 163, // 71144-71151
139, 128, 151, 144, 154, 140, 110, 122, // 71152-71159
162, 171, 161, 164, 196, 213, 174, 155, // 71160-71167
128,  80,  73,  59,  30,  72, 126, 150, // 71168-71175
142, 167, 195, 134,  67,  46,  25,  25, // 71176-71183
 76,  85, 100, 155, 178, 161, 141, 145, // 71184-71191
158, 133, 134, 152, 146, 156, 134, 109, // 71192-71199
125, 163, 167, 161, 167, 201, 205, 164, // 71200-71207
147, 117,  74,  75,  58,  37,  87, 133, // 71208-71215
148, 140, 174, 186, 121,  65,  49,  26, // 71216-71223
 36,  84,  86, 107, 161, 177, 157, 141, // 71224-71231
148, 157, 130, 137, 146, 142, 151, 128, // 71232-71239
109, 133, 167, 166, 162, 171, 203, 197, // 71240-71247
161, 147, 110,  73,  76,  50,  42,  96, // 71248-71255
136, 148, 146, 181, 179, 111,  63,  49, // 71256-71263
 29,  50,  92,  87, 116, 162, 168, 150, // 71264-71271
141, 152, 157, 134, 145, 147, 144, 146, // 71272-71279
121, 107, 136, 164, 160, 161, 173, 201, // 71280-71287
188, 157, 143, 103,  75,  81,  52,  52, // 71288-71295
106, 138, 141, 146, 180, 164, 103,  68, // 71296-71303
 54,  35,  65,  97,  90, 124, 165, 163, // 71304-71311
147, 139, 150, 150, 131, 145, 145, 146, // 71312-71319
145, 120, 111, 142, 164, 155, 157, 173, // 71320-71327
196, 177, 151, 135,  96,  77,  83,  52, // 71328-71335
 65, 118, 143, 142, 152, 180, 152,  94, // 71336-71343
 62,  52,  39,  76, 100,  95, 134, 168, // 71344-71351
158, 143, 141, 152, 147, 134, 148, 143, // 71352-71359
145, 138, 113, 111, 148, 161, 154, 160, // 71360-71367
176, 193, 169, 147, 129,  89,  78,  80, // 71368-71375
 52,  74, 123, 145, 140, 158, 180, 143, // 71376-71383
 89,  68,  56,  49,  90, 101,  98, 138, // 71384-71391
164, 151, 140, 139, 151, 143, 136, 147, // 71392-71399
142, 145, 135, 114, 117, 150, 157, 151, // 71400-71407
155, 177, 190, 164, 148, 127,  87,  85, // 71408-71415
 79,  51,  83, 127, 139, 137, 162, 171, // 71416-71423
131,  87,  70,  56,  58,  97, 102, 106, // 71424-71431
146, 164, 148, 136, 137, 148, 136, 137, // 71432-71439
148, 143, 147, 134, 112, 120, 154, 154, // 71440-71447
150, 160, 178, 183, 161, 145, 119,  88, // 71448-71455
 89,  78,  58,  94, 132, 139, 137, 163, // 71456-71463
165, 122,  83,  71,  56,  65, 103, 101, // 71464-71471
109, 152, 162, 144, 138, 139, 146, 136, // 71472-71479
139, 142, 141, 144, 129, 112, 127, 156, // 71480-71487
152, 151, 159, 178, 179, 158, 143, 116, // 71488-71495
 86,  92,  74,  59, 103, 138, 138, 144, // 71496-71503
169, 158, 115,  79,  67,  55,  74, 107, // 71504-71511
 99, 116, 154, 156, 142, 136, 141, 148, // 71512-71519
138, 144, 144, 142, 141, 124, 107, 127, // 71520-71527
154, 147, 152, 165, 181, 177, 156, 138, // 71528-71535
107,  86,  92,  70,  68, 111, 137, 135, // 71536-71543
143, 166, 151, 111,  83,  73,  60,  83, // 71544-71551
108,  98, 118, 156, 152, 140, 138, 142, // 71552-71559
145, 138, 144, 141, 143, 140, 123, 111, // 71560-71567
135, 152, 145, 150, 161, 177, 171, 152, // 71568-71575
137, 105,  89,  95,  69,  73, 118, 138, // 71576-71583
135, 151, 167, 141, 103,  79,  67,  60, // 71584-71591
 91, 110, 103, 131, 158, 148, 137, 134, // 71592-71599
140, 143, 139, 146, 143, 141, 136, 120, // 71600-71607
110, 139, 152, 145, 154, 167, 176, 167, // 71608-71615
149, 128,  96,  89,  91,  68,  83, 125, // 71616-71623
138, 137, 154, 162, 136, 100,  81,  71, // 71624-71631
 67,  97, 107, 100, 131, 155, 143, 138, // 71632-71639
139, 145, 142, 140, 142, 139, 141, 135, // 71640-71647
118, 116, 144, 148, 143, 154, 166, 176, // 71648-71655
164, 147, 127,  97,  93,  89,  67,  89, // 71656-71663
129, 137, 136, 159, 160, 130,  98,  81, // 71664-71671
 69,  72, 103, 106, 106, 141, 154, 139, // 71672-71679
135, 134, 140, 141, 141, 144, 143, 142, // 71680-71687
133, 117, 118, 147, 147, 144, 155, 167, // 71688-71695
171, 157, 141, 120,  93,  96,  88,  70, // 71696-71703
100, 132, 133, 137, 159, 151, 123,  94, // 71704-71711
 80,  72,  79, 109, 109, 113, 148, 154, // 71712-71719
139, 137, 136, 139, 136, 138, 140, 139, // 71720-71727
137, 131, 116, 127, 152, 145, 146, 158, // 71728-71735
166, 169, 155, 139, 115,  91,  95,  82, // 71736-71743
 71, 107, 136, 134, 144, 161, 144, 113, // 71744-71751
 87,  76,  67,  84, 111, 108, 119, 153, // 71752-71759
151, 139, 139, 137, 141, 140, 141, 142, // 71760-71767
141, 136, 128, 113, 126, 149, 142, 150, // 71768-71775
163, 172, 168, 152, 133, 107,  88,  95, // 71776-71783
 81,  79, 116, 136, 131, 147, 159, 138, // 71784-71791
112,  90,  81,  73,  90, 112, 105, 119, // 71792-71799
149, 144, 136, 139, 139, 142, 142, 145, // 71800-71807
145, 140, 133, 123, 111, 131, 147, 141, // 71808-71815
151, 163, 170, 164, 149, 131, 106,  92, // 71816-71823
 98,  82,  84, 122, 136, 133, 152, 157, // 71824-71831
133, 107,  88,  79,  75,  98, 115, 107, // 71832-71839
126, 149, 138, 133, 134, 135, 142, 141, // 71840-71847
144, 144, 138, 131, 122, 113, 137, 149, // 71848-71855
141, 152, 163, 166, 160, 146, 126, 100, // 71856-71863
 93,  98,  80,  94, 130, 137, 135, 154, // 71864-71871
149, 127, 105,  87,  82,  81, 104, 115, // 71872-71879
108, 130, 149, 137, 135, 137, 136, 139, // 71880-71887
140, 143, 141, 136, 132, 121, 115, 141, // 71888-71895
145, 142, 156, 164, 166, 158, 140, 120, // 71896-71903
 96,  94,  96,  81,  98, 131, 132, 134, // 71904-71911
154, 145, 123, 103,  89,  83,  84, 110, // 71912-71919
114, 111, 137, 150, 135, 135, 134, 136, // 71920-71927
140, 143, 144, 142, 135, 130, 118, 116, // 71928-71935
142, 144, 143, 156, 161, 162, 154, 138, // 71936-71943
119,  97, 101,  98,  83, 105, 134, 131, // 71944-71951
137, 154, 137, 118, 100,  86,  82,  91, // 71952-71959
116, 117, 116, 142, 146, 133, 135, 134, // 71960-71967
136, 141, 143, 142, 140, 132, 131, 117, // 71968-71975
121, 145, 140, 143, 155, 158, 158, 150, // 71976-71983
132, 112,  95, 100,  95,  87, 115, 139, // 71984-71991
134, 143, 152, 133, 116,  98,  88,  83, // 71992-71999
 95, 117, 112, 116, 142, 143, 134, 139, // 72000-72007
136, 138, 143, 142, 141, 139, 132, 128, // 72008-72015
115, 125, 145, 139, 146, 157, 158, 158, // 72016-72023
147, 128, 108,  96, 103,  94,  89, 118, // 72024-72031
134, 129, 145, 150, 131, 117, 101,  90, // 72032-72039
 86, 101, 119, 113, 122, 144, 138, 131, // 72040-72047
134, 130, 135, 142, 142, 142, 138, 132, // 72048-72055
128, 116, 131, 146, 140, 149, 156, 155, // 72056-72063
154, 143, 125, 107,  99, 105,  94,  95, // 72064-72071
125, 134, 130, 148, 145, 124, 112,  96, // 72072-72079
 89,  90, 107, 121, 116, 128, 146, 137, // 72080-72087
134, 137, 133, 137, 139, 137, 136, 132, // 72088-72095
128, 125, 117, 137, 146, 139, 150, 154, // 72096-72103
154, 153, 140, 121, 105, 100, 105,  93, // 72104-72111
101, 130, 135, 133, 149, 140, 122, 110, // 72112-72119
 95,  89,  90, 109, 119, 114, 131, 147, // 72120-72127
135, 136, 137, 132, 138, 142, 139, 139, // 72128-72135
133, 128, 122, 116, 137, 141, 139, 152, // 72136-72143
154, 153, 151, 135, 118, 103, 104, 108, // 72144-72151
 96, 109, 134, 132, 132, 147, 133, 119, // 72152-72159
109,  96,  92,  96, 116, 120, 116, 132, // 72160-72167
141, 131, 134, 134, 133, 140, 142, 139, // 72168-72175
140, 131, 130, 122, 122, 144, 143, 142, // 72176-72183
152, 149, 147, 144, 129, 114, 105, 108, // 72184-72191
109, 102, 116, 132, 128, 131, 138, 126, // 72192-72199
117, 108, 102, 101, 107, 121, 121, 120, // 72200-72207
132, 136, 130, 134, 133, 132, 134, 134, // 72208-72215
133, 132, 130, 131, 128, 131, 141, 138, // 72216-72223
138, 141, 138, 136, 131, 122, 117, 114, // 72224-72231
117, 119, 118, 126, 131, 127, 128, 128, // 72232-72239
123, 121, 118, 118, 120, 123, 127, 125, // 72240-72247
126, 131, 130, 129, 132, 131, 131, 132, // 72248-72255
129, 131, 128, 124, 126, 125, 130, 135, // 72256-72263
135, 135, 134, 131, 128, 122, 120, 121, // 72264-72271
122, 126, 127, 127, 130, 128, 123, 123, // 72272-72279
122, 122, 123, 122, 125, 128, 127, 128, // 72280-72287
129, 128, 130, 129, 130, 131, 131, 130, // 72288-72295
127, 125, 127, 126, 124, 126, 129, 133, // 72296-72303
134, 132, 131, 128, 125, 123, 119, 119, // 72304-72311
123, 124, 127, 131, 134, 133, 130, 126, // 72312-72319
123, 121, 121, 120, 120, 126, 130, 128, // 72320-72327
129, 130, 130, 129, 129, 131, 131, 132, // 72328-72335
131, 127, 125, 127, 124, 122, 126, 129, // 72336-72343
131, 134, 133, 132, 128, 125, 119, 115, // 72344-72351
118, 122, 123, 129, 134, 135, 134, 130, // 72352-72359
125, 123, 123, 124, 124, 124, 129, 130, // 72360-72367
126, 127, 127, 127, 127, 129, 130, 131, // 72368-72375
132, 131, 127, 127, 127, 125, 124, 126, // 72376-72383
129, 131, 132, 131, 129, 126, 124, 120, // 72384-72391
117, 119, 124, 124, 128, 132, 133, 131, // 72392-72399
129, 124, 122, 123, 124, 124, 126, 131, // 72400-72407
133, 130, 130, 130, 127, 126, 127, 128, // 72408-72415
129, 131, 130, 127, 127, 127, 124, 123, // 72416-72423
128, 131, 132, 134, 134, 130, 127, 122, // 72424-72431
116, 115, 117, 120, 124, 129, 134, 134, // 72432-72439
131, 128, 122, 120, 122, 123, 124, 129, // 72440-72447
134, 132, 129, 130, 129, 128, 128, 130, // 72448-72455
131, 132, 131, 128, 125, 124, 124, 123, // 72456-72463
123, 127, 131, 131, 134, 134, 130, 127, // 72464-72471
123, 118, 116, 120, 123, 124, 129, 134, // 72472-72479
132, 129, 126, 122, 121, 122, 122, 124, // 72480-72487
127, 133, 132, 129, 131, 130, 128, 128, // 72488-72495
129, 129, 131, 132, 129, 126, 126, 126, // 72496-72503
123, 122, 127, 128, 130, 133, 132, 130, // 72504-72511
126, 121, 117, 118, 121, 124, 127, 133, // 72512-72519
136, 132, 130, 124, 119, 119, 120, 121, // 72520-72527
124, 130, 133, 130, 128, 130, 128, 127, // 72528-72535
129, 130, 130, 132, 132, 128, 126, 127, // 72536-72543
127, 124, 126, 130, 130, 131, 132, 129, // 72544-72551
127, 123, 119, 116, 117, 122, 124, 128, // 72552-72559
132, 135, 133, 131, 126, 122, 121, 122, // 72560-72567
122, 122, 127, 131, 128, 128, 130, 129, // 72568-72575
128, 128, 129, 130, 131, 131, 127, 127, // 72576-72583
128, 127, 124, 126, 129, 131, 133, 134, // 72584-72591
130, 127, 123, 117, 114, 117, 121, 124, // 72592-72599
127, 133, 133, 131, 128, 123, 120, 122, // 72600-72607
124, 124, 127, 132, 132, 129, 129, 129, // 72608-72615
128, 128, 128, 129, 129, 130, 129, 126, // 72616-72623
125, 127, 126, 126, 128, 130, 132, 132, // 72624-72631
131, 128, 125, 122, 119, 117, 120, 123, // 72632-72639
126, 129, 132, 132, 130, 127, 123, 120, // 72640-72647
120, 122, 122, 126, 131, 132, 132, 133, // 72648-72655
132, 131, 129, 127, 128, 127, 128, 128, // 72656-72663
125, 124, 126, 125, 125, 128, 130, 133, // 72664-72671
134, 134, 130, 124, 121, 118, 116, 120, // 72672-72679
122, 127, 133, 134, 134, 132, 127, 122, // 72680-72687
120, 120, 123, 123, 127, 130, 128, 130, // 72688-72695
130, 130, 130, 131, 132, 131, 129, 129, // 72696-72703
127, 123, 123, 123, 125, 127, 129, 130, // 72704-72711
131, 132, 131, 128, 123, 122, 119, 119, // 72712-72719
121, 122, 127, 131, 132, 132, 131, 129, // 72720-72727
126, 123, 122, 123, 123, 126, 128, 128, // 72728-72735
130, 130, 130, 130, 129, 131, 129, 128, // 72736-72743
129, 128, 125, 124, 126, 126, 126, 128, // 72744-72751
130, 131, 132, 132, 126, 123, 122, 119, // 72752-72759
119, 122, 124, 128, 132, 132, 131, 129, // 72760-72767
127, 123, 122, 122, 125, 127, 128, 129, // 72768-72775
127, 128, 129, 128, 128, 130, 131, 129, // 72776-72783
128, 127, 125, 123, 124, 126, 128, 130, // 72784-72791
131, 132, 131, 130, 129, 125, 121, 121, // 72792-72799
121, 121, 122, 124, 127, 131, 131, 130, // 72800-72807
130, 129, 126, 124, 124, 123, 125, 127, // 72808-72815
127, 128, 130, 130, 130, 129, 129, 130, // 72816-72823
129, 127, 127, 126, 124, 123, 125, 125, // 72824-72831
127, 130, 130, 131, 134, 131, 127, 123, // 72832-72839
121, 119, 121, 122, 124, 130, 132, 131, // 72840-72847
130, 128, 125, 124, 123, 124, 127, 129, // 72848-72855
129, 128, 127, 127, 129, 128, 129, 132, // 72856-72863
132, 130, 129, 126, 123, 123, 123, 124, // 72864-72871
127, 130, 130, 129, 129, 129, 127, 125, // 72872-72879
122, 122, 124, 124, 123, 126, 128, 130, // 72880-72887
130, 129, 129, 127, 125, 124, 123, 125, // 72888-72895
127, 128, 127, 129, 132, 132, 130, 129, // 72896-72903
130, 129, 128, 127, 125, 126, 125, 124, // 72904-72911
125, 126, 127, 128, 129, 129, 129, 128, // 72912-72919
125, 121, 121, 122, 122, 124, 127, 131, // 72920-72927
133, 132, 130, 128, 126, 124, 123, 123, // 72928-72935
126, 129, 127, 126, 128, 129, 130, 129, // 72936-72943
130, 132, 132, 130, 127, 124, 124, 122, // 72944-72951
123, 125, 128, 131, 131, 129, 129, 128, // 72952-72959
127, 125, 120, 122, 124, 124, 124, 127, // 72960-72967
129, 131, 131, 132, 130, 127, 125, 124, // 72968-72975
123, 126, 128, 127, 127, 129, 131, 130, // 72976-72983
129, 129, 129, 129, 129, 127, 125, 126, // 72984-72991
125, 124, 125, 127, 128, 127, 128, 129, // 72992-72999
128, 128, 125, 121, 121, 123, 122, 124, // 73000-73007
128, 131, 132, 132, 131, 128, 126, 125, // 73008-73015
125, 126, 129, 129, 129, 128, 128, 130, // 73016-73023
128, 127, 128, 129, 128, 128, 125, 124, // 73024-73031
126, 125, 125, 128, 129, 129, 129, 129, // 73032-73039
128, 128, 126, 123, 121, 123, 124, 123, // 73040-73047
125, 127, 131, 132, 131, 131, 129, 127, // 73048-73055
125, 124, 123, 127, 129, 127, 129, 131, // 73056-73063
132, 130, 129, 129, 129, 128, 125, 123, // 73064-73071
124, 124, 123, 123, 125, 128, 128, 128, // 73072-73079
129, 130, 130, 128, 124, 122, 123, 123, // 73080-73087
122, 125, 128, 131, 132, 132, 130, 128, // 73088-73095
126, 124, 122, 125, 126, 127, 127, 127, // 73096-73103
128, 131, 130, 130, 130, 130, 130, 127, // 73104-73111
124, 124, 124, 122, 124, 125, 128, 128, // 73112-73119
128, 128, 128, 129, 127, 123, 123, 124, // 73120-73127
123, 125, 127, 130, 133, 159, 168, 145, // 73128-73135
107,  87,  76,  91,  61,  47,  68, 151, // 73136-73143
225, 244, 249, 211,   2, 192, 114,  57, // 73144-73151
 29,   9,  36,  31,   5,  88, 146, 180, // 73152-73159
119, 144, 178, 235, 238, 139,  93,  64, // 73160-73167
 33, 151, 152, 219, 219,   2,  46,  56, // 73168-73175
 85,  98,  88, 141, 161, 162, 170, 180, // 73176-73183
185, 203, 155, 152, 203, 220, 227, 225, // 73184-73191
213, 202, 242, 196,  85,  31,  89, 111, // 73192-73199
136, 113,  63, 141, 135, 219,  12, 136, // 73200-73207
 31,  43,  13, 213, 195, 230, 235, 232, // 73208-73215
 75,  88, 184,   0,  34,  30,  24, 244, // 73216-73223
245, 244, 150, 121,  95, 109,  95, 131, // 73224-73231
 59,  38, 139, 214, 224, 226, 188, 183, // 73232-73239
196, 132, 183,  78, 227, 183, 193, 180, // 73240-73247
179,  24,  80,  73, 126, 207, 226,  54, // 73248-73255
 14, 208, 165, 158, 133, 132, 111,  78, // 73256-73263
140, 191, 215, 208, 218, 134, 169, 219, // 73264-73271
159, 128,  99,  85,  80,  57, 101, 146, // 73272-73279
 80,  56,  29,  39,  30,  61, 126,  40, // 73280-73287
 11,  76, 124, 151, 187, 157, 159, 225, // 73288-73295
246, 234, 213, 199, 186, 227, 184, 121, // 73296-73303
109,  66,  35, 103, 117,  96, 163, 176, // 73304-73311
199, 153, 198, 237, 166,  72, 225, 186, // 73312-73319
195, 206, 250,  13, 209,  83, 191, 251, // 73320-73327
 12,  19, 252,   5,  17, 180, 134, 102, // 73328-73335
111, 103, 132,  80, 112, 155, 134, 165, // 73336-73343
211, 205, 203, 223, 160,  90,  53, 152, // 73344-73351
 92,  13, 206, 176, 255,  41,  83, 101, // 73352-73359
 80, 101, 222, 223, 192, 166, 169, 155, // 73360-73367
164, 144,  95, 139, 179, 201, 202, 208, // 73368-73375
181, 218, 167,  94, 110, 110, 114, 107, // 73376-73383
108,  64,  62, 189, 234, 122,  73,  25, // 73384-73391
 36,  77,  27,  24, 247, 255,  77, 142, // 73392-73399
140, 155, 228, 255,   2, 244, 218, 189, // 73400-73407
222, 178, 125, 107,  96, 104,  90,  47, // 73408-73415
 66, 158, 193, 213, 184, 188, 131, 191, // 73416-73423
246,  98, 250, 205, 198, 223, 244, 232, // 73424-73431
 37,  62, 143, 200, 238, 236, 254,  21, // 73432-73439
200, 164, 128, 122, 106, 130,  89, 118, // 73440-73447
163, 194, 192, 141, 148, 185, 226, 178, // 73448-73455
122,  95,  80,  54, 159, 104, 251,  18, // 73456-73463
 27,  53,  59,  82,  88, 107, 109, 130, // 73464-73471
134, 155, 158, 175, 167, 131, 166, 188, // 73472-73479
197, 191, 195, 174, 203, 201, 148,  78, // 73480-73487
 53,  98, 115, 132,  90, 106, 154, 143, // 73488-73495
204, 235, 121,  72,  70,  14, 243, 233, // 73496-73503
 14,   4,  23,  70, 113, 197, 237,   0, // 73504-73511
251, 238, 216, 235, 183, 129, 108, 101, // 73512-73519
108, 114, 116,  74,  93, 155, 203, 199, // 73520-73527
202, 161, 190, 152, 109, 155,  77,   2, // 73528-73535
233, 236, 213,   9,  75, 106,  89, 138, // 73536-73543
178, 220, 255, 199, 175, 149, 150, 131, // 73544-73551
140,  96, 111, 158, 187, 189, 189, 179, // 73552-73559
129, 170, 166, 136, 119, 107,  96, 103, // 73560-73567
 60, 124, 162,  95,  72,  47,  56,  45, // 73568-73575
 97, 103,  42,  37,  99, 127, 159, 164, // 73576-73583
140, 179, 211, 220, 204, 195, 172, 193, // 73584-73591
197, 147, 115, 109,  77,  61, 113,  97, // 73592-73599
123, 164, 169, 176, 147, 177, 217, 157, // 73600-73607
 57, 252, 228, 242, 246,  38,  15,   9, // 73608-73615
122, 187, 226, 236, 236, 223, 248, 207, // 73616-73623
147, 117, 105, 106, 114, 118,  90, 148, // 73624-73631
161, 142, 161, 195, 175, 203, 179, 129, // 73632-73639
 82,  72, 143,  97,  34, 228, 252,  47, // 73640-73647
 75,  97, 113,  82, 127, 195, 169, 160, // 73648-73655
146, 156, 148, 166, 126, 128, 161, 181, // 73656-73663
181, 184, 174, 167, 198, 121,  89, 106, // 73664-73671
118, 118, 123,  99,  85, 106, 191, 205, // 73672-73679
116,  80,  40,  76,  68,  36,  40,  23, // 73680-73687
 33, 104, 136, 130, 174, 212, 225, 217, // 73688-73695
211, 180, 188, 192, 146, 121, 114, 111, // 73696-73703
118, 101,  50, 104, 162, 184, 187, 172, // 73704-73711
165, 138, 190, 191,  87,  17, 248, 239, // 73712-73719
 15,   2,  23,  76,  88, 147, 186, 209, // 73720-73727
209, 243, 218, 170, 145, 128, 118, 116, // 73728-73735
111,  86, 137, 160, 185, 173, 143, 144, // 73736-73743
197, 191, 144, 109,  98,  84,  79, 154, // 73744-73751
 90,  52,  62,  66,  73,  83,  87, 109, // 73752-73759
109,  91, 116, 122, 145, 147, 168, 139, // 73760-73767
147, 177, 190, 187, 183, 172, 167, 193, // 73768-73775
154, 124,  72,  70, 103, 130, 122, 107, // 73776-73783
138, 159, 144, 185, 197, 106,  97,  62, // 73784-73791
 25,  14,  22,  46,  45,  50,  79, 143, // 73792-73799
191, 215, 218, 218, 198, 205, 200, 148, // 73800-73807
119, 106, 108, 115, 123, 106, 102, 117, // 73808-73815
160, 180, 180, 172, 157, 182, 125, 115, // 73816-73823
146,  90,  33,  23, 250,   1,  54,  94, // 73824-73831
112,  99, 138, 169, 217, 204, 168, 154, // 73832-73839
145, 140, 136, 126,  98, 135, 156, 175, // 73840-73847
167, 175, 155, 144, 153, 142, 126, 119, // 73848-73855
110, 106, 103,  63, 146, 159, 113,  90, // 73856-73863
 78,  74,  85, 111,  86,  46,  50, 103, // 73864-73871
123, 156, 138, 154, 188, 205, 199, 187, // 73872-73879
173, 162, 182, 153, 124, 105, 112,  82, // 73880-73887
 87, 107, 109, 148, 168, 169, 166, 143, // 73888-73895
165, 207, 125,  51,  10,   5,  18,  36, // 73896-73903
 64,  39,  70, 142, 184, 200, 207, 196, // 73904-73911
208, 211, 165, 134, 118, 114, 113, 122, // 73912-73919
104, 112, 153, 156, 135, 155, 170, 170, // 73920-73927
190, 142, 116,  83,  94, 142, 110,  43, // 73928-73935
 20,  52,  76,  88, 102, 109,  87, 143, // 73936-73943
165, 152, 149, 150, 151, 152, 147, 117, // 73944-73951
143, 158, 173, 165, 172, 156, 174, 172, // 73952-73959
106,  92, 109, 119, 122, 122,  92, 110, // 73960-73967
124, 189, 178, 117,  82,  74,  95,  63, // 73968-73975
 53,  58,  51,  58, 114, 116, 137, 176, // 73976-73983
201, 206, 202, 192, 175, 186, 155, 126, // 73984-73991
109, 111, 105, 124,  94,  73, 134, 168, // 73992-73999
179, 173, 162, 148, 147, 165, 156,  82, // 74000-74007
 40,  23,  26,  37,  22,  69, 100, 109, // 74008-74015
146, 177, 184, 200, 207, 169, 145, 132, // 74016-74023
126, 122, 126, 107, 119, 154, 162, 170, // 74024-74031
160, 129, 142, 182, 155, 134, 109, 110, // 74032-74039
 93, 106, 140, 100,  84,  84,  84,  87, // 74040-74047
 90,  92, 123,  95,  88, 111, 126, 141, // 74048-74055
150, 153, 133, 162, 172, 178, 166, 164, // 74056-74063
150, 168, 168, 134, 121,  90,  92, 117, // 74064-74071
132, 113, 124, 142, 154, 142, 184, 174, // 74072-74079
119, 107,  63,  44,  36,  46,  61,  67, // 74080-74087
 55, 100, 151, 183, 194, 194, 189, 180, // 74088-74095
195, 165, 133, 115, 114, 111, 123, 110, // 74096-74103
104, 119, 125, 159, 172, 176, 163, 165, // 74104-74111
157, 112, 117, 140,  92,  60,  48,  25, // 74112-74119
 57,  84, 110, 113, 106, 128, 163, 187, // 74120-74127
165, 149, 141, 139, 136, 137, 113, 114, // 74128-74135
144, 156, 167, 162, 159, 149, 143, 130, // 74136-74143
129, 118, 123, 110, 115, 101,  97, 171, // 74144-74151
160, 122, 100,  89,  84, 105, 101,  84, // 74152-74159
 59,  72, 107, 128, 142, 128, 158, 175, // 74160-74167
187, 177, 171, 150, 159, 158, 133, 119, // 74168-74175
109, 116,  95, 101, 108, 132, 158, 164, // 74176-74183
152, 151, 133, 169, 189, 111,  69,  45, // 74184-74191
 49,  54,  69,  68,  65,  94, 142, 168, // 74192-74199
180, 182, 176, 192, 174, 148, 129, 121, // 74200-74207
113, 119, 114, 109, 130, 150, 146, 129, // 74208-74215
148, 153, 170, 166, 126, 114,  98, 114, // 74216-74223
148, 110,  57,  61,  78,  96,  99, 111, // 74224-74231
107, 105, 140, 142, 141, 142, 143, 142, // 74232-74239
148, 131, 130, 148, 152, 156, 153, 157, // 74240-74247
151, 168, 144, 104, 101, 118, 119, 129, // 74248-74255
111, 102, 124, 135, 182, 164, 119,  92, // 74256-74263
 98,  93,  70,  68,  76,  67,  83, 119, // 74264-74271
119, 153, 172, 187, 182, 182, 165, 167, // 74272-74279
161, 133, 118, 112, 114, 112, 125,  92, // 74280-74287
100, 142, 162, 165, 160, 143, 143, 143, // 74288-74295
148, 145,  91,  68,  51,  62,  55,  59, // 74296-74303
 99, 108, 112, 141, 162, 168, 186, 174, // 74304-74311
155, 140, 136, 129, 128, 121, 110, 130, // 74312-74319
149, 152, 153, 145, 119, 148, 161, 140, // 74320-74327
129, 114, 114, 104, 117, 133, 116, 101, // 74328-74335
 96,  90,  97,  95, 110, 123,  92, 101, // 74336-74343
120, 135, 140, 147, 137, 138, 160, 162, // 74344-74351
159, 152, 149, 143, 164, 145, 128, 118, // 74352-74359
 99, 101, 125, 123, 117, 131, 141, 147, // 74360-74367
136, 174, 158, 129, 105,  72,  63,  63, // 74368-74375
 68,  82,  76,  72, 124, 154, 174, 174, // 74376-74383
179, 169, 176, 174, 143, 125, 114, 114, // 74384-74391
111, 122, 106, 120, 127, 132, 152, 162, // 74392-74399
159, 154, 156, 137, 108, 120, 139,  99, // 74400-74407
 83,  60,  60,  88, 101, 116, 112, 108, // 74408-74415
129, 165, 164, 149, 142, 143, 137, 139, // 74416-74423
131, 114, 129, 143, 148, 149, 148, 143, // 74424-74431
147, 131, 122, 125, 124, 127, 118, 124, // 74432-74439
101, 117, 165, 148, 113, 100,  88,  97, // 74440-74447
110, 100,  94,  78,  98, 121, 139, 133, // 74448-74455
136, 160, 167, 168, 162, 156, 143, 156, // 74456-74463
139, 126, 116, 118, 116, 106, 104, 114, // 74464-74471
139, 152, 151, 143, 145, 129, 173, 170, // 74472-74479
111,  81,  66,  68,  70,  77,  73,  84, // 74480-74487
105, 144, 158, 172, 167, 177, 180, 154, // 74488-74495
138, 126, 120, 113, 119, 106, 117, 133, // 74496-74503
147, 136, 130, 144, 152, 166, 146, 124, // 74504-74511
116, 106, 118, 145, 102,  75,  85,  97, // 74512-74519
108, 108, 118, 113, 121, 132, 133, 131, // 74520-74527
137, 138, 143, 139, 127, 140, 148, 147, // 74528-74535
142, 143, 141, 147, 150, 127, 103, 110, // 74536-74543
126, 127, 130, 110, 121, 132, 141, 168, // 74544-74551
150, 112, 101, 104,  89,  77,  79,  90, // 74552-74559
 82, 105, 120, 132, 159, 167, 170, 164, // 74560-74567
161, 155, 163, 143, 125, 116, 120, 118, // 74568-74575
119, 116,  95, 115, 142, 153, 151, 150, // 74576-74583
139, 151, 137, 142, 136,  98,  80,  72, // 74584-74591
 77,  68,  84, 108, 112, 113, 142, 153, // 74592-74599
168, 178, 162, 149, 138, 136, 127, 124, // 74600-74607
106, 111, 130, 143, 143, 148, 138, 131, // 74608-74615
155, 149, 133, 122, 117, 115, 111, 115, // 74616-74623
130, 119, 105, 100,  98, 104, 102, 124, // 74624-74631
119,  98, 109, 127, 133, 140, 140, 132, // 74632-74639
144, 157, 160, 153, 149, 142, 147, 150, // 74640-74647
128, 117, 112, 102, 112, 131, 121, 129, // 74648-74655
138, 145, 140, 138, 160, 149, 124,  95, // 74656-74663
 76,  73,  77,  82,  95,  80,  93, 135, // 74664-74671
155, 168, 170, 171, 163, 171, 155, 134, // 74672-74679
119, 117, 115, 121, 119, 113, 131, 128, // 74680-74687
132, 146, 152, 145, 152, 145, 129, 112, // 74688-74695
128, 134, 101,  86,  65,  78,  96, 107, // 74696-74703
117, 117, 112, 141, 160, 152, 146, 142, // 74704-74711
141, 136, 139, 124, 122, 131, 138, 139, // 74712-74719
143, 139, 143, 146, 126, 126, 130, 129, // 74720-74727
125, 122, 115, 103, 125, 156, 136, 113, // 74728-74735
105,  97, 112, 107, 101,  96,  86, 102, // 74736-74743
126, 135, 134, 148, 159, 163, 161, 158, // 74744-74751
146, 145, 147, 130, 122, 117, 119, 118, // 74752-74759
109, 102, 124, 141, 148, 146, 146, 141, // 74760-74767
137, 167, 143, 101,  81,  75,  76,  85, // 74768-74775
 84,  92, 101, 117, 144, 155, 163, 160, // 74776-74783
170, 159, 145, 133, 127, 119, 121, 119, // 74784-74791
112, 127, 135, 146, 135, 132, 141, 157, // 74792-74799
153, 135, 119, 118, 108, 125, 139, 100, // 74800-74807
 93,  96, 102, 104, 109, 113, 114, 117, // 74808-74815
125, 133, 137, 142, 141, 146, 133, 134, // 74816-74823
140, 141, 140, 142, 137, 138, 147, 140, // 74824-74831
125, 107, 116, 126, 132, 126, 116, 131, // 74832-74839
133, 139, 159, 140, 110, 111, 101,  91, // 74840-74847
 88,  93,  96,  91, 104, 116, 137, 153, // 74848-74855
160, 162, 161, 155, 157, 152, 131, 125, // 74856-74863
117, 117, 117, 124, 116, 111, 124, 144, // 74864-74871
150, 150, 142, 140, 146, 125, 138, 130, // 74872-74879
102,  89,  88,  81,  83, 100, 115, 113, // 74880-74887
118, 142, 149, 166, 158, 145, 136, 134, // 74888-74895
129, 128, 121, 113, 127, 133, 142, 140, // 74896-74903
145, 130, 131, 142, 138, 131, 126, 122, // 74904-74911
125, 118, 118, 140, 124, 112, 105, 106, // 74912-74919
103, 108, 122, 109,  98, 113, 129, 135, // 74920-74927
145, 136, 137, 146, 150, 147, 142, 136, // 74928-74935
134, 140, 135, 126, 125, 122, 108, 120, // 74936-74943
128, 123, 134, 134, 139, 135, 135, 151, // 74944-74951
148, 120, 101,  91,  89,  90,  97, 103, // 74952-74959
 87, 108, 135, 150, 158, 159, 153, 155, // 74960-74967
157, 142, 132, 122, 122, 120, 126, 116, // 74968-74975
121, 130, 125, 128, 144, 144, 143, 149, // 74976-74983
135, 128, 111, 128, 130, 109,  90,  84, // 74984-74991
 97, 106, 115, 121, 116, 114, 144, 147, // 74992-74999
147, 143, 141, 138, 139, 136, 125, 129, // 75000-75007
130, 135, 136, 138, 133, 140, 135, 122, // 75008-75015
127, 128, 126, 124, 124, 120, 118, 126, // 75016-75023
139, 128, 116, 109, 109, 115, 112, 115, // 75024-75031
113, 112, 121, 134, 134, 135, 139, 138, // 75032-75039
139, 139, 137, 133, 135, 132, 131, 129, // 75040-75047
127, 126, 127, 122, 120, 127, 127, 128, // 75048-75055
128, 128, 124, 127, 133, 130, 121, 117, // 75056-75063
116, 117, 119, 116, 118, 116, 121, 128, // 75064-75071
135, 137, 139, 141, 138, 136, 133, 130, // 75072-75079
127, 127, 124, 125, 125, 125, 127, 127, // 75080-75087
126, 128, 132, 129, 129, 128, 126, 123, // 75088-75095
127, 128, 120, 118, 117, 118, 122, 124, // 75096-75103
124, 126, 128, 131, 132, 133, 134, 133, // 75104-75111
131, 131, 133, 130, 128, 127, 126, 125, // 75112-75119
126, 126, 127, 130, 130, 127, 130, 130, // 75120-75127
126, 126, 123, 121, 123, 125, 124, 121, // 75128-75135
122, 122, 125, 125, 125, 125, 126, 127, // 75136-75143
130, 130, 130, 131, 130, 127, 128, 131, // 75144-75151
130, 132, 133, 134, 132, 131, 129, 126, // 75152-75159
125, 122, 122, 125, 124, 124, 126, 127, // 75160-75167
128, 129, 129, 127, 125, 124, 123, 123, // 75168-75175
119, 119, 122, 123, 124, 128, 132, 134, // 75176-75183
136, 136, 135, 136, 133, 128, 124, 123, // 75184-75191
122, 123, 125, 126, 129, 132, 131, 133, // 75192-75199
131, 129, 128, 127, 127, 124, 122, 120, // 75200-75207
120, 120, 119, 120, 123, 124, 129, 132, // 75208-75215
130, 130, 134, 134, 131, 128, 126, 129, // 75216-75223
129, 129, 127, 127, 129, 130, 130, 129, // 75224-75231
127, 129, 128, 128, 128, 126, 126, 124, // 75232-75239
125, 123, 122, 125, 126, 127, 127, 125, // 75240-75247
127, 126, 125, 126, 124, 122, 125, 128, // 75248-75255
127, 127, 127, 131, 133, 133, 132, 130, // 75256-75263
132, 131, 129, 127, 124, 125, 125, 123, // 75264-75271
125, 124, 127, 128, 131, 131, 129, 130, // 75272-75279
129, 126, 122, 119, 118, 120, 120, 122, // 75280-75287
125, 127, 131, 135, 134, 132, 133, 133, // 75288-75295
131, 128, 125, 122, 121, 123, 123, 124, // 75296-75303
125, 129, 131, 133, 133, 133, 133, 130, // 75304-75311
127, 126, 122, 121, 124, 123, 122, 124, // 75312-75319
126, 127, 126, 127, 129, 129, 129, 130, // 75320-75327
128, 126, 126, 127, 127, 127, 127, 127, // 75328-75335
128, 129, 131, 129, 129, 127, 127, 126, // 75336-75343
125, 125, 125, 125, 123, 127, 126, 126, // 75344-75351
128, 130, 127, 127, 128, 128, 125, 124, // 75352-75359
125, 124, 125, 126, 127, 126, 128, 131, // 75360-75367
133, 132, 132, 131, 129, 128, 127, 125, // 75368-75375
123, 122, 120, 122, 125, 126, 128, 130, // 75376-75383
132, 132, 132, 130, 128, 125, 124, 120, // 75384-75391
118, 119, 120, 120, 125, 130, 133, 135, // 75392-75399
137, 135, 134, 133, 131, 128, 125, 123, // 75400-75407
122, 122, 123, 124, 127, 127, 128, 129, // 75408-75415
132, 131, 130, 128, 124, 123, 122, 121, // 75416-75423
121, 123, 126, 128, 128, 129, 129, 129, // 75424-75431
128, 128, 127, 127, 126, 126, 126, 126, // 75432-75439
129, 130, 132, 132, 133, 133, 131, 130, // 75440-75447
129, 126, 122, 122, 122, 123, 123, 125, // 75448-75455
125, 127, 128, 127, 126, 126, 127, 126, // 75456-75463
124, 123, 124, 124, 124, 124, 125, 128, // 75464-75471
130, 131, 131, 131, 134, 135, 134, 132, // 75472-75479
129, 127, 126, 123, 122, 122, 122, 123, // 75480-75487
126, 128, 128, 131, 132, 130, 129, 127, // 75488-75495
125, 125, 123, 121, 119, 120, 122, 123, // 75496-75503
125, 127, 130, 133, 135, 133, 132, 129, // 75504-75511
129, 129, 126, 124, 125, 127, 129, 130, // 75512-75519
130, 131, 130, 129, 128, 128, 126, 125, // 75520-75527
125, 123, 121, 122, 123, 124, 125, 127, // 75528-75535
128, 129, 130, 127, 125, 125, 126, 126, // 75536-75543
126, 125, 125, 127, 129, 134, 132, 132, // 75544-75551
133, 132, 129, 128, 125, 124, 125, 124, // 75552-75559
122, 124, 126, 127, 129, 129, 130, 129, // 75560-75567
130, 128, 125, 124, 123, 123, 122, 120, // 75568-75575
119, 122, 125, 129, 130, 131, 132, 133, // 75576-75583
133, 134, 132, 129, 129, 128, 126, 123, // 75584-75591
123, 124, 124, 125, 125, 128, 130, 131, // 75592-75599
132, 130, 129, 127, 124, 122, 119, 120, // 75600-75607
123, 125, 127, 126, 126, 129, 131, 131, // 75608-75615
131, 130, 129, 128, 126, 125, 125, 127, // 75616-75623
128, 129, 131, 131, 130, 130, 129, 127, // 75624-75631
124, 124, 125, 124, 124, 123, 125, 126, // 75632-75639
129, 129, 126, 126, 128, 127, 126, 125, // 75640-75647
122, 124, 125, 126, 125, 127, 130, 130, // 75648-75655
131, 132, 132, 133, 132, 131, 130, 126, // 75656-75663
126, 125, 123, 122, 122, 125, 127, 127, // 75664-75671
127, 129, 129, 130, 128, 126, 124, 123, // 75672-75679
125, 125, 124, 123, 123, 124, 127, 127, // 75680-75687
129, 130, 132, 132, 131, 129, 128, 129, // 75688-75695
129, 128, 127, 128, 129, 129, 127, 126, // 75696-75703
126, 126, 128, 126, 125, 126, 128, 127, // 75704-75711
125, 123, 123, 123, 124, 126, 126, 127, // 75712-75719
128, 129, 129, 129, 129, 127, 128, 128, // 75720-75727
126, 126, 128, 128, 131, 130, 130, 130, // 75728-75735
132, 131, 129, 127, 125, 125, 124, 122, // 75736-75743
120, 123, 125, 128, 128, 126, 127, 128, // 75744-75751
126, 125, 125, 124, 123, 124, 124, 124, // 75752-75759
126, 129, 130, 132, 131, 131, 132, 131, // 75760-75767
131, 129, 128, 129, 129, 128, 126, 124, // 75768-75775
124, 125, 126, 128, 125, 126, 129, 130, // 75776-75783
129, 125, 124, 123, 123, 122, 122, 125, // 75784-75791
126, 125, 126, 126, 128, 130, 130, 130, // 75792-75799
130, 129, 130, 130, 128, 128, 127, 128, // 75800-75807
129, 130, 129, 128, 128, 129, 130, 129, // 75808-75815
125, 123, 123, 126, 126, 124, 123, 124, // 75816-75823
125, 123, 123, 126, 127, 127, 127, 128, // 75824-75831
128, 128, 128, 125, 125, 126, 127, 128, // 75832-75839
130, 130, 131, 132, 133, 132, 130, 127, // 75840-75847
124, 124, 124, 123, 122, 122, 124, 127, // 75848-75855
130, 131, 129, 129, 128, 127, 124, 123, // 75856-75863
123, 122, 121, 123, 125, 127, 130, 131, // 75864-75871
132, 132, 133, 132, 130, 128, 127, 126, // 75872-75879
126, 127, 127, 127, 127, 127, 128, 129, // 75880-75887
128, 126, 127, 128, 127, 126, 124, 122, // 75888-75895
122, 123, 122, 123, 125, 127, 129, 128, // 75896-75903
128, 129, 129, 128, 128, 126, 126, 128, // 75904-75911
129, 129, 127, 128, 129, 130, 130, 129, // 75912-75919
128, 128, 128, 128, 126, 124, 124, 125, // 75920-75927
125, 126, 126, 125, 126, 125, 125, 124, // 75928-75935
126, 127, 126, 125, 126, 127, 129, 129, // 75936-75943
127, 128, 127, 129, 130, 130, 129, 130, // 75944-75951
130, 130, 130, 128, 125, 125, 124, 123, // 75952-75959
124, 124, 126, 128, 129, 130, 131, 130, // 75960-75967
127, 125, 123, 123, 123, 123, 122, 122, // 75968-75975
124, 127, 129, 131, 132, 132, 133, 133, // 75976-75983
131, 130, 126, 123, 124, 125, 125, 127, // 75984-75991
129, 130, 130, 131, 130, 128, 128, 126, // 75992-75999
124, 124, 124, 125, 124, 123, 123, 124, // 76000-76007
125, 127, 127, 127, 129, 130, 129, 129, // 76008-76015
127, 127, 127, 127, 127, 129, 130, 130, // 76016-76023
130, 131, 130, 129, 128, 126, 124, 124, // 76024-76031
125, 125, 126, 127, 127, 127, 128, 129, // 76032-76039
127, 125, 124, 125, 125, 125, 124, 124, // 76040-76047
124, 126, 127, 127, 128, 131, 131, 131, // 76048-76055
131, 131, 130, 128, 127, 126, 127, 128, // 76056-76063
128, 128, 125, 126, 126, 125, 126, 126, // 76064-76071
127, 127, 129, 129, 128, 126, 125, 124, // 76072-76079
124, 123, 122, 124, 127, 129, 129, 130, // 76080-76087
130, 132, 131, 129, 127, 127, 127, 126, // 76088-76095
125, 124, 125, 127, 128, 128, 129, 129, // 76096-76103
129, 130, 128, 127, 126, 124, 123, 124, // 76104-76111
124, 125, 126, 127, 127, 127, 127, 127, // 76112-76119
128, 127, 126, 126, 126, 128, 129, 129, // 76120-76127
128, 130, 131, 131, 128, 128, 127, 126, // 76128-76135
126, 125, 124, 124, 125, 125, 126, 127, // 76136-76143
129, 130, 129, 129, 129, 128, 126, 125, // 76144-76151
124, 124, 123, 125, 125, 128, 128, 129, // 76152-76159
130, 131, 130, 128, 129, 127, 127, 126, // 76160-76167
125, 126, 127, 127, 128, 127, 127, 128, // 76168-76175
128, 128, 128, 128, 127, 128, 125, 125, // 76176-76183
126, 126, 126, 125, 125, 125, 124, 125, // 76184-76191
126, 127, 128, 129, 130, 131, 130, 129, // 76192-76199
129, 129, 127, 126, 125, 125, 124, 126, // 76200-76207
126, 128, 128, 129, 130, 128, 128, 127, // 76208-76215
126, 126, 126, 124, 125, 127, 127, 127, // 76216-76223
127, 127, 125, 125, 125, 126, 126, 127, // 76224-76231
127, 128, 129, 128, 129, 130, 130, 129, // 76232-76239
129, 129, 129, 129, 127, 126, 125, 125, // 76240-76247
125, 126, 127, 129, 130, 130, 130, 128, // 76248-76255
126, 125, 125, 125, 124, 123, 123, 123, // 76256-76263
124, 125, 127, 128, 130, 131, 132, 131, // 76264-76271
130, 129, 129, 126, 125, 125, 125, 125, // 76272-76279
127, 129, 130, 130, 130, 129, 128, 127, // 76280-76287
127, 127, 127, 127, 126, 125, 125, 126, // 76288-76295
126, 124, 125, 123, 124, 126, 127, 126, // 76296-76303
127, 128, 128, 128, 127, 128, 129, 129, // 76304-76311
128, 128, 128, 128, 127, 127, 127, 127, // 76312-76319
127, 127, 128, 128, 128, 129, 129, 128, // 76320-76327
126, 126, 126, 127, 128, 126, 125, 124, // 76328-76335
123, 124, 125, 125, 125, 127, 130, 130, // 76336-76343
129, 130, 129, 129, 127, 126, 126, 126, // 76344-76351
126, 126, 126, 127, 128, 128, 128, 129, // 76352-76359
130, 130, 131, 131, 128, 126, 125, 125, // 76360-76367
125, 124, 123, 122, 124, 125, 127, 128, // 76368-76375
128, 129, 130, 130, 129, 129, 129, 128, // 76376-76383
126, 124, 125, 127, 125, 126, 128, 128, // 76384-76391
129, 130, 128, 128, 128, 128, 128, 126, // 76392-76399
125, 125, 125, 127, 128, 129, 127, 125, // 76400-76407
125, 125, 125, 125, 126, 126, 128, 127, // 76408-76415
127, 128, 130, 129, 129, 128, 127, 129, // 76416-76423
127, 127, 126, 127, 126, 125, 125, 126, // 76424-76431
127, 129, 130, 130, 130, 128, 127, 126, // 76432-76439
126, 125, 125, 124, 124, 125, 125, 125, // 76440-76447
126, 128, 129, 130, 130, 130, 132, 130, // 76448-76455
128, 127, 125, 124, 124, 124, 126, 127, // 76456-76463
129, 130, 129, 129, 129, 128, 129, 128, // 76464-76471
126, 126, 124, 124, 125, 126, 126, 125, // 76472-76479
126, 125, 125, 127, 128, 129, 129, 127, // 76480-76487
128, 128, 128, 128, 128, 128, 128, 128, // 76488-76495
128, 127, 128, 128, 128, 127, 126, 125, // 76496-76503
126, 126, 127, 128, 129, 128, 126, 126, // 76504-76511
125, 125, 126, 126, 125, 124, 124, 126, // 76512-76519
126, 126, 127, 127, 127, 130, 132, 130, // 76520-76527
129, 129, 127, 127, 127, 126, 126, 127, // 76528-76535
127, 127, 127, 127, 128, 128, 128, 129, // 76536-76543
129, 128, 126, 126, 125, 124, 125, 124, // 76544-76551
124, 123, 123, 126, 128, 129, 130, 129, // 76552-76559
128, 128, 130, 129, 127, 126, 128, 126, // 76560-76567
125, 126, 128, 130, 130, 129, 129, 130, // 76568-76575
128, 128, 126, 125, 126, 126, 125, 123, // 76576-76583
124, 125, 127, 128, 129, 126, 126, 125, // 76584-76591
127, 126, 126, 126, 126, 127, 128, 129, // 76592-76599
129, 129, 130, 129, 127, 129, 128, 129, // 76600-76607
128, 126, 126, 126, 127, 126, 126, 128, // 76608-76615
130, 131, 130, 126, 125, 125, 125, 125, // 76616-76623
123, 123, 122, 123, 125, 126, 127, 128, // 76624-76631
129, 129, 129, 129, 130, 129, 128, 126, // 76632-76639
124, 124, 128, 128, 128, 128, 129, 131, // 76640-76647
131, 130, 128, 128, 129, 129, 127, 124, // 76648-76655
123, 124, 125, 124, 125, 125, 126, 127, // 76656-76663
127, 127, 127, 127, 127, 126, 125, 126, // 76664-76671
128, 129, 128, 126, 127, 127, 129, 130, // 76672-76679
129, 127, 128, 130, 130, 127, 127, 127, // 76680-76687
129, 130, 128, 126, 125, 127, 126, 125, // 76688-76695
124, 126, 125, 125, 125, 125, 126, 127, // 76696-76703
128, 126, 125, 127, 128, 128, 128, 126, // 76704-76711
126, 127, 128, 128, 127, 126, 127, 128, // 76712-76719
129, 127, 127, 128, 130, 131, 130, 128, // 76720-76727
128, 128, 125, 124, 124, 125, 126, 125, // 76728-76735
125, 124, 127, 128, 128, 128, 126, 128, // 76736-76743
130, 130, 128, 125, 125, 125, 125, 125, // 76744-76751
125, 126, 127, 130, 131, 129, 128, 129, // 76752-76759
128, 128, 128, 127, 128, 127, 127, 125, // 76760-76767
125, 126, 127, 125, 125, 126, 126, 128, // 76768-76775
128, 127, 126, 126, 127, 128, 128, 127, // 76776-76783
127, 128, 128, 126, 126, 126, 126, 126, // 76784-76791
127, 128, 129, 129, 129, 128, 128, 129, // 76792-76799
129, 127, 126, 125, 125, 127, 127, 127, // 76800-76807
126, 126, 127, 128, 126, 126, 126, 127, // 76808-76815
128, 128, 128, 126, 127, 127, 127, 126, // 76816-76823
127, 127, 128, 128, 127, 127, 127, 128, // 76824-76831
127, 126, 128, 129, 131, 130, 128, 127, // 76832-76839
126, 126, 125, 123, 123, 125, 125, 128, // 76840-76847
128, 129, 129, 129, 128, 127, 127, 127, // 76848-76855
127, 126, 127, 125, 126, 126, 127, 127, // 76856-76863
129, 129, 130, 129, 129, 127, 127, 126, // 76864-76871
127, 126, 126, 126, 126, 126, 127, 127, // 76872-76879
127, 128, 126, 152, 163, 143, 106,  88, // 76880-76887
 78,  93,  64,  50,  68, 148, 224, 240, // 76888-76895
246, 209,   0, 193, 114,  57,  31,  13, // 76896-76903
 37,  35,   8,  87, 146, 181, 120, 143, // 76904-76911
175, 231, 236, 141,  98,  70,  36, 153, // 76912-76919
159, 223, 216, 250,  38,  51,  80,  96, // 76920-76927
 89, 143, 165, 164, 173, 180, 182, 204, // 76928-76935
153, 147, 200, 219, 226, 223, 212, 201, // 76936-76943
242, 201,  92,  35,  88, 110, 131, 109, // 76944-76951
 57, 134, 129, 213,  16, 146,  38,  50, // 76952-76959
 22, 218, 197, 227, 231, 226,  71,  85, // 76960-76967
180, 254,  35,  33,  26, 247, 244, 247, // 76968-76975
154, 120,  91, 106,  91, 129,  61,  36, // 76976-76983
137, 213, 225, 227, 189, 180, 197, 130, // 76984-76991
182,  81, 226, 180, 191, 182, 180,  24, // 76992-76999
 85,  78, 127, 211, 225,  49,  12, 207, // 77000-77007
165, 158, 135, 134, 117,  79, 138, 188, // 77008-77015
212, 206, 218, 134, 167, 219, 158, 126, // 77016-77023
 96,  81,  78,  58, 101, 148,  83,  59, // 77024-77031
 29,  38,  29,  54, 123,  43,  14,  80, // 77032-77039
127, 155, 189, 158, 158, 220, 241, 233, // 77040-77047
215, 202, 188, 231, 190, 124, 110,  68, // 77048-77055
 34, 100, 117,  91, 156, 169, 195, 151, // 77056-77063
194, 237, 167,  77, 228, 188, 195, 205, // 77064-77071
246,  14, 209,  80, 189, 250,  16,  23, // 77072-77079
  2,   7,  24, 184, 137, 103, 110,  99, // 77080-77087
131,  80, 109, 157, 138, 169, 213, 204, // 77088-77095
200, 220, 158,  91,  49, 148,  94,  12, // 77096-77103
206, 172, 252,  38,  78, 100,  84, 101, // 77104-77111
221, 226, 194, 167, 168, 156, 166, 149, // 77112-77119
100, 142, 182, 205, 204, 208, 178, 215, // 77120-77127
168,  96, 113, 110, 113, 105, 105,  61, // 77128-77135
 56, 183, 232, 122,  73,  26,  31,  76, // 77136-77143
 28,  23, 250,   1,  78, 142, 141, 154, // 77144-77151
222, 249,   1, 244, 220, 191, 223, 184, // 77152-77159
130, 112,  98, 106,  93,  50,  63, 154, // 77160-77167
187, 209, 183, 188, 132, 189, 251, 104, // 77168-77175
252, 206, 196, 217, 239, 228,  31,  60, // 77176-77183
143, 204, 241, 240,   1,  23, 204, 168, // 77184-77191
131, 122, 105, 129,  90, 113, 159, 190, // 77192-77199
194, 146, 153, 187, 227, 179, 121,  92, // 77200-77207
 78,  51, 156, 109, 253,  18,  27,  53, // 77208-77215
 58,  80,  86, 106, 109, 130, 136, 154, // 77216-77223
156, 173, 167, 132, 168, 190, 198, 193, // 77224-77231
198, 176, 200, 199, 150,  83,  55, 102, // 77232-77239
117, 133,  91, 102, 150, 139, 197, 232, // 77240-77247
120,  69,  71,  14, 244, 235,  15,   8, // 77248-77255
 26,  71, 114, 196, 235, 252, 248, 237, // 77256-77263
216, 234, 186, 133, 114, 106, 110, 112, // 77264-77271
116,  71,  88, 151, 199, 196, 202, 163, // 77272-77279
191, 159, 114, 159,  82,   4, 232, 232, // 77280-77287
206,   0,  68, 103,  87, 139, 181, 222, // 77288-77295
  4, 203, 177, 151, 151, 131, 138,  94, // 77296-77303
111, 157, 184, 188, 190, 184, 133, 171, // 77304-77311
168, 137, 118, 106,  92, 100,  58, 120, // 77312-77319
162,  97,  75,  49,  56,  45,  96, 102, // 77320-77327
 41,  38, 100, 129, 160, 166, 142, 180, // 77328-77335
211, 220, 201, 193, 172, 191, 196, 147, // 77336-77343
114, 111,  79,  60, 114, 100, 125, 166, // 77344-77351
169, 175, 146, 173, 215, 156,  56, 252, // 77352-77359
228, 242, 247,  39,  18,   9, 122, 186, // 77360-77367
223, 234, 235, 221, 248, 212, 153, 123, // 77368-77375
110, 110, 116, 118,  87, 142, 155, 138, // 77376-77383
157, 191, 174, 203, 180, 130,  88,  77, // 77384-77391
147, 101,  38, 226, 248,  42,  66,  89, // 77392-77399
110,  82, 128, 203, 177, 169, 153, 161, // 77400-77407
147, 162, 122, 122, 155, 178, 182, 185, // 77408-77415
177, 168, 203, 125,  91, 108, 117, 114, // 77416-77423
120,  97,  80, 102, 187, 203, 116,  82, // 77424-77431
 44,  78,  69,  36,  42,  26,  35, 104, // 77432-77439
138, 132, 174, 213, 227, 218, 213, 183, // 77440-77447
188, 190, 142, 118, 111, 107, 117, 104, // 77448-77455
 52, 103, 164, 182, 184, 168, 162, 133, // 77456-77463
186, 191,  90,  19, 252, 243,  15,   3, // 77464-77471
 24,  81,  91, 147, 187, 209, 205, 239, // 77472-77479
215, 164, 145, 130, 121, 121, 120,  94, // 77480-77487
142, 161, 181, 169, 136, 136, 188, 190, // 77488-77495
147, 113, 101,  88,  80, 155,  92,  50, // 77496-77503
 59,  62,  69,  77,  82, 108, 115,  96, // 77504-77511
122, 132, 153, 150, 171, 136, 139, 172, // 77512-77519
181, 177, 174, 169, 166, 195, 160, 133, // 77520-77527
 83,  80, 108, 131, 122, 101, 133, 154, // 77528-77535
139, 184, 199, 107,  97,  65,  24,  12, // 77536-77543
 19,  45,  47,  54,  80, 144, 194, 215, // 77544-77551
216, 214, 194, 203, 201, 147, 117, 109, // 77552-77559
111, 115, 122, 105, 101, 117, 159, 183, // 77560-77567
183, 175, 158, 181, 121, 108, 143,  91, // 77568-77575
 34,  26,   1,   4,  57,  95, 112,  97, // 77576-77583
136, 165, 214, 204, 167, 152, 143, 142, // 77584-77591
137, 128,  97, 135, 157, 175, 167, 174, // 77592-77599
155, 142, 152, 140, 127, 121, 114, 110, // 77600-77607
110,  68, 148, 162, 110,  82,  70,  65, // 77608-77615
 75, 108,  87,  53,  60, 113, 132, 162, // 77616-77623
142, 148, 181, 196, 192, 179, 167, 155, // 77624-77631
181, 155, 127, 110, 117,  89,  90, 112, // 77632-77639
110, 149, 167, 165, 162, 139, 162, 207, // 77640-77647
131,  55,  18,  13,  22,  35,  61,  36, // 77648-77655
 63, 139, 182, 200, 207, 196, 204, 209, // 77656-77663
165, 133, 116, 111, 112, 122, 105, 112, // 77664-77671
155, 156, 135, 156, 171, 168, 191, 145, // 77672-77679
119,  87,  96, 144, 112,  46,  18,  49, // 77680-77687
 75,  88, 103, 112,  90, 143, 166, 151, // 77688-77695
149, 147, 148, 149, 148, 116, 142, 156, // 77696-77703
167, 161, 166, 152, 170, 171, 106,  95, // 77704-77711
115, 123, 127, 129,  98, 111, 124, 185, // 77712-77719
178, 117,  81,  69,  91,  62,  52,  61, // 77720-77727
 55,  63, 121, 125, 143, 179, 198, 197, // 77728-77735
193, 182, 165, 179, 152, 125, 112, 115, // 77736-77743
110, 127,  97,  71, 132, 165, 175, 171, // 77744-77751
160, 147, 145, 164, 159,  89,  46,  27, // 77752-77759
 29,  43,  26,  71,  99, 106, 144, 177, // 77760-77767
183, 198, 209, 172, 150, 137, 127, 119, // 77768-77775
124, 104, 112, 148, 158, 167, 157, 128, // 77776-77783
142, 183, 157, 135, 112, 111,  94, 103, // 77784-77791
139, 101,  83,  81,  80,  84,  89,  93, // 77792-77799
124, 101,  95, 120, 134, 144, 151, 155, // 77800-77807
131, 157, 169, 172, 162, 163, 149, 163, // 77808-77815
165, 135, 122,  89,  92, 120, 135, 116, // 77816-77823
127, 144, 152, 136, 176, 169, 114, 104, // 77824-77831
 61,  43,  39,  49,  65,  71,  63, 103, // 77832-77839
155, 184, 194, 196, 190, 178, 192, 161, // 77840-77847
129, 114, 114, 111, 124, 117, 112, 124, // 77848-77855
127, 158, 170, 171, 158, 163, 158, 110, // 77856-77863
112, 137,  90,  56,  45,  22,  51,  81, // 77864-77871
109, 115, 112, 134, 169, 194, 170, 153, // 77872-77879
143, 139, 137, 136, 112, 113, 143, 153, // 77880-77887
161, 159, 160, 149, 144, 136, 135, 124, // 77888-77895
126, 115, 121, 102,  88, 158, 151, 112, // 77896-77903
 92,  80,  76,  97,  99,  86,  65,  79, // 77904-77911
115, 136, 150, 135, 162, 176, 186, 176, // 77912-77919
167, 149, 158, 162, 134, 121, 113, 118, // 77920-77927
 95, 103, 109, 129, 154, 164, 159, 158, // 77928-77935
132, 163, 186, 108,  64,  37,  40,  44, // 77936-77943
 63,  66,  64,  95, 144, 172, 185, 186, // 77944-77951
179, 195, 178, 151, 129, 120, 114, 121, // 77952-77959
117, 107, 129, 153, 150, 134, 155, 158, // 77960-77967
172, 170, 131, 116,  93, 103, 136, 104, // 77968-77975
 50,  52,  73,  92,  97, 112, 110, 109, // 77976-77983
145, 147, 143, 140, 141, 142, 147, 133, // 77984-77991
129, 148, 156, 161, 158, 157, 150, 169, // 77992-77999
144, 102,  99, 119, 120, 130, 119, 107, // 78000-78007
127, 132, 177, 160, 114,  87,  93,  89, // 78008-78015
 67,  62,  72,  66,  85, 120, 119, 153, // 78016-78023
175, 188, 184, 185, 168, 168, 164, 135, // 78024-78031
120, 111, 115, 113, 126,  92,  99, 143, // 78032-78039
163, 165, 162, 147, 146, 143, 143, 140, // 78040-78047
 85,  63,  49,  59,  53,  55,  96, 110, // 78048-78055
116, 146, 163, 169, 191, 180, 155, 140, // 78056-78063
136, 127, 126, 120, 109, 129, 148, 154, // 78064-78071
157, 148, 124, 150, 164, 139, 128, 114, // 78072-78079
113, 103, 112, 126, 110,  97,  94,  91, // 78080-78087
 97,  93, 107, 126,  96, 102, 119, 131, // 78088-78095
140, 151, 139, 138, 162, 166, 164, 156, // 78096-78103
154, 146, 163, 144, 126, 115,  95,  98, // 78104-78111
124, 123, 116, 136, 145, 149, 137, 169, // 78112-78119
153, 124, 102,  68,  58,  58,  65,  81, // 78120-78127
 81,  75, 124, 156, 178, 181, 185, 171, // 78128-78135
177, 177, 144, 124, 115, 115, 113, 124, // 78136-78143
107, 120, 128, 132, 152, 161, 156, 153, // 78144-78151
159, 139, 106, 115, 134,  93,  78,  57, // 78152-78159
 52,  82,  99, 117, 118, 114, 132, 166, // 78160-78167
166, 151, 143, 140, 137, 140, 132, 114, // 78168-78175
130, 146, 150, 152, 151, 147, 150, 136, // 78176-78183
123, 126, 122, 123, 118, 122,  98, 110, // 78184-78191
160, 146, 115, 104,  91,  96, 110,  97, // 78192-78199
 91,  77,  94, 116, 136, 134, 137, 162, // 78200-78207
169, 174, 166, 159, 147, 162, 144, 126, // 78208-78215
117, 116, 115, 105, 102, 109, 137, 152, // 78216-78223
155, 149, 148, 127, 167, 162, 102,  74, // 78224-78231
 61,  61,  68,  78,  75,  90, 111, 147, // 78232-78239
160, 173, 168, 175, 178, 154, 138, 125, // 78240-78247
120, 116, 123, 107, 118, 139, 153, 142, // 78248-78255
134, 143, 151, 164, 145, 120, 114, 102, // 78256-78263
112, 141, 102,  73,  87,  95, 103, 105, // 78264-78271
114, 111, 121, 133, 131, 133, 137, 138, // 78272-78279
142, 140, 128, 141, 152, 152, 151, 149, // 78280-78287
142, 152, 156, 126, 100, 103, 119, 122, // 78288-78295
131, 110, 120, 134, 138, 167, 151, 113, // 78296-78303
104, 108,  89,  78,  80,  91,  83, 103, // 78304-78311
116, 125, 157, 169, 172, 167, 166, 156, // 78312-78319
166, 146, 126, 117, 116, 117, 123, 120, // 78320-78327
 95, 114, 142, 153, 151, 151, 137, 149, // 78328-78335
134, 136, 133,  96,  79,  73,  76,  65, // 78336-78343
 85, 112, 119, 121, 146, 151, 165, 175, // 78344-78351
153, 139, 134, 133, 127, 132, 115, 121, // 78352-78359
137, 150, 151, 152, 136, 122, 145, 141, // 78360-78367
127, 120, 114, 113, 112, 112, 129, 125, // 78368-78375
111, 109, 104, 105, 100, 121, 117,  96, // 78376-78383
103, 118, 127, 137, 141, 130, 146, 160, // 78384-78391
161, 157, 152, 145, 149, 153, 133, 124, // 78392-78399
114, 100, 105, 125, 115, 126, 140, 145, // 78400-78407
144, 138, 157, 148, 128,  97,  79,  72, // 78408-78415
 76,  82,  98,  87,  94, 134, 152, 164, // 78416-78423
164, 163, 155, 168, 153, 134, 122, 121, // 78424-78431
120, 125, 126, 116, 135, 132, 132, 144, // 78432-78439
151, 143, 151, 143, 125, 105, 119, 130, // 78440-78447
103,  91,  72,  85, 101, 111, 120, 121, // 78448-78455
115, 137, 155, 145, 138, 133, 133, 132, // 78456-78463
138, 123, 126, 140, 149, 149, 152, 148, // 78464-78471
146, 147, 120, 116, 119, 120, 120, 121, // 78472-78479
117, 105, 126, 157, 142, 117, 108,  98, // 78480-78487
112, 106,  98,  95,  90, 104, 122, 131, // 78488-78495
127, 143, 156, 162, 162, 159, 149, 151, // 78496-78503
152, 131, 124, 119, 120, 119, 109,  99, // 78504-78511
123, 140, 149, 148, 144, 138, 130, 160, // 78512-78519
140, 101,  81,  77,  78,  86,  84,  93, // 78520-78527
110, 124, 147, 155, 160, 155, 167, 155, // 78528-78535
140, 128, 124, 121, 125, 123, 116, 136, // 78536-78543
144, 151, 137, 130, 134, 149, 148, 131, // 78544-78551
118, 114, 105, 119, 136, 100,  94, 100, // 78552-78559
108, 111, 113, 115, 121, 125, 125, 127, // 78560-78567
128, 132, 132, 140, 130, 134, 146, 151, // 78568-78575
151, 149, 144, 145, 152, 140, 121, 101, // 78576-78583
107, 117, 124, 122, 114, 129, 133, 139, // 78584-78591
159, 144, 114, 114, 104,  92,  84,  88, // 78592-78599
 96,  98, 110, 117, 138, 153, 159, 159, // 78600-78607
159, 153, 154, 154, 134, 125, 119, 122, // 78608-78615
123, 126, 115, 110, 122, 141, 147, 148, // 78616-78623
143, 138, 144, 121, 128, 123,  97,  85, // 78624-78631
 87,  83,  85, 104, 121, 125, 128, 143, // 78632-78639
147, 162, 152, 140, 134, 131, 129, 131, // 78640-78647
128, 119, 134, 142, 149, 146, 147, 130, // 78648-78655
129, 137, 127, 121, 119, 117, 119, 115, // 78656-78663
113, 137, 128, 117, 110, 109, 105, 109, // 78664-78671
122, 111, 101, 111, 124, 131, 138, 130, // 78672-78679
135, 149, 155, 154, 151, 146, 143, 150, // 78680-78687
139, 126, 120, 115, 104, 112, 119, 118, // 78688-78695
134, 140, 143, 136, 134, 146, 144, 119, // 78696-78703
 97,  87,  87,  89,  98, 105,  96, 116, // 78704-78711
140, 151, 156, 155, 151, 155, 158, 139, // 78712-78719
130, 124, 124, 124, 128, 119, 123, 136, // 78720-78727
130, 129, 138, 139, 140, 147, 130, 119, // 78728-78735
108, 124, 128, 112,  94,  88, 103, 111, // 78736-78743
116, 122, 120, 119, 141, 142, 135, 131, // 78744-78751
131, 133, 136, 135, 128, 139, 144, 147, // 78752-78759
143, 143, 137, 140, 134, 115, 116, 118, // 78760-78767
121, 123, 123, 117, 118, 128, 140, 131, // 78768-78775
122, 116, 116, 121, 113, 113, 112, 114, // 78776-78783
120, 127, 126, 128, 136, 139, 141, 141, // 78784-78791
139, 138, 141, 136, 129, 127, 126, 125, // 78792-78799
124, 118, 117, 124, 128, 131, 131, 130, // 78800-78807
127, 128, 131, 125, 121, 117, 116, 118, // 78808-78815
117, 118, 122, 126, 129, 132, 132, 132, // 78816-78823
132, 133, 131, 130, 129, 130, 131, 131, // 78824-78831
128, 128, 132, 132, 131, 128, 125, 125, // 78832-78839
126, 125, 123, 123, 121, 121, 124, 124, // 78840-78847
124, 126, 127, 130, 128, 127, 127, 127, // 78848-78855
128, 125, 125, 125, 124, 125, 127, 128, // 78856-78863
132, 133, 135, 136, 134, 132, 133, 131, // 78864-78871
127, 123, 120, 118, 119, 119, 121, 123, // 78872-78879
126, 126, 129, 129, 129, 129, 129, 127, // 78880-78887
127, 125, 124, 123, 126, 126, 126, 128, // 78888-78895
127, 127, 129, 131, 131, 132, 132, 131, // 78896-78903
131, 128, 127, 127, 126, 124, 123, 123, // 78904-78911
124, 125, 127, 128, 128, 127, 126, 125, // 78912-78919
124, 124, 125, 125, 126, 126, 127, 127, // 78920-78927
129, 131, 131, 130, 130, 126, 127, 126, // 78928-78935
126, 126, 127, 128, 129, 130, 129, 131, // 78936-78943
133, 130, 128, 126, 123, 122, 122, 121, // 78944-78951
121, 121, 123, 125, 126, 128, 131, 132, // 78952-78959
133, 131, 130, 128, 125, 127, 124, 123, // 78960-78967
122, 122, 123, 127, 129, 132, 134, 135, // 78968-78975
135, 134, 131, 128, 128, 124, 122, 120, // 78976-78983
120, 121, 123, 124, 126, 128, 128, 130, // 78984-78991
128, 127, 128, 127, 129, 127, 125, 125, // 78992-78999
124, 126, 129, 127, 129, 128, 128, 127, // 79000-79007
128, 128, 129, 129, 128, 127, 128, 129, // 79008-79015
129, 130, 128, 126, 125, 124, 124, 124, // 79016-79023
125, 125, 125, 125, 125, 124, 127, 127, // 79024-79031
130, 131, 129, 130, 129, 128, 129, 128, // 79032-79039
127, 125, 124, 123, 124, 126, 129, 130, // 79040-79047
131, 130, 132, 132, 131, 129, 129, 126, // 79048-79055
124, 122, 120, 120, 121, 123, 123, 126, // 79056-79063
127, 128, 130, 132, 131, 132, 129, 127, // 79064-79071
127, 123, 123, 124, 125, 126, 127, 126, // 79072-79079
128, 130, 133, 132, 131, 131, 129, 128, // 79080-79087
127, 125, 123, 123, 122, 123, 124, 125, // 79088-79095
127, 128, 129, 127, 129, 126, 126, 125, // 79096-79103
124, 126, 128, 128, 128, 128, 127, 130, // 79104-79111
129, 129, 127, 126, 125, 126, 128, 129, // 79112-79119
128, 128, 130, 130, 131, 131, 129, 129, // 79120-79127
127, 125, 122, 122, 122, 123, 122, 123, // 79128-79135
126, 128, 128, 130, 130, 129, 132, 130, // 79136-79143
128, 125, 125, 125, 126, 126, 125, 123, // 79144-79151
125, 127, 129, 132, 131, 132, 133, 132, // 79152-79159
129, 129, 126, 124, 123, 122, 120, 121, // 79160-79167
124, 125, 127, 126, 128, 129, 128, 128, // 79168-79175
128, 127, 129, 128, 126, 125, 123, 126, // 79176-79183
127, 128, 128, 128, 128, 129, 130, 131, // 79184-79191
131, 129, 129, 128, 127, 126, 128, 127, // 79192-79199
125, 125, 123, 124, 126, 126, 125, 125, // 79200-79207
125, 127, 126, 126, 126, 127, 129, 130, // 79208-79215
130, 128, 127, 128, 129, 128, 126, 124, // 79216-79223
123, 125, 125, 128, 130, 131, 133, 133, // 79224-79231
132, 131, 131, 129, 124, 122, 121, 119, // 79232-79239
121, 122, 122, 123, 126, 128, 130, 129, // 79240-79247
129, 130, 130, 130, 128, 126, 123, 124, // 79248-79255
125, 125, 126, 127, 127, 128, 130, 130, // 79256-79263
132, 132, 132, 130, 129, 127, 128, 129, // 79264-79271
126, 123, 124, 124, 124, 126, 125, 126, // 79272-79279
126, 128, 127, 126, 126, 126, 127, 128, // 79280-79287
128, 128, 127, 126, 129, 128, 127, 126, // 79288-79295
125, 125, 125, 127, 128, 130, 131, 130, // 79296-79303
131, 130, 131, 132, 130, 125, 125, 124, // 79304-79311
123, 123, 123, 122, 122, 125, 126, 127, // 79312-79319
128, 130, 130, 131, 131, 130, 128, 125, // 79320-79327
125, 125, 123, 123, 123, 123, 123, 126, // 79328-79335
129, 131, 133, 133, 133, 132, 132, 132, // 79336-79343
130, 126, 122, 123, 122, 123, 124, 125, // 79344-79351
124, 126, 128, 128, 127, 128, 128, 127, // 79352-79359
128, 126, 127, 126, 125, 126, 126, 125, // 79360-79367
126, 127, 125, 126, 129, 131, 130, 131, // 79368-79375
129, 129, 130, 131, 131, 129, 127, 126, // 79376-79383
126, 124, 125, 124, 123, 122, 125, 125, // 79384-79391
124, 127, 128, 128, 128, 129, 129, 129, // 79392-79399
127, 126, 126, 126, 125, 124, 123, 122, // 79400-79407
125, 128, 130, 131, 132, 132, 133, 134, // 79408-79415
133, 131, 127, 126, 124, 123, 121, 122, // 79416-79423
123, 122, 123, 126, 126, 127, 130, 129, // 79424-79431
129, 129, 129, 128, 126, 124, 124, 124, // 79432-79439
125, 125, 126, 126, 127, 131, 132, 131, // 79440-79447
132, 131, 130, 129, 130, 129, 126, 126, // 79448-79455
126, 125, 125, 125, 126, 126, 123, 125, // 79456-79463
125, 125, 126, 127, 125, 125, 128, 129, // 79464-79471
128, 128, 128, 128, 129, 128, 126, 124, // 79472-79479
124, 125, 127, 128, 128, 130, 130, 131, // 79480-79487
132, 132, 131, 130, 127, 124, 123, 123, // 79488-79495
122, 123, 121, 122, 125, 126, 128, 129, // 79496-79503
130, 129, 130, 130, 127, 125, 125, 124, // 79504-79511
125, 125, 124, 125, 125, 128, 130, 132, // 79512-79519
132, 133, 133, 131, 131, 130, 129, 126, // 79520-79527
124, 122, 122, 123, 124, 125, 124, 125, // 79528-79535
128, 129, 127, 128, 127, 127, 126, 127, // 79536-79543
125, 125, 126, 127, 128, 128, 128, 128, // 79544-79551
128, 128, 128, 129, 129, 129, 129, 127, // 79552-79559
128, 129, 130, 129, 128, 126, 126, 126, // 79560-79567
127, 124, 124, 123, 123, 124, 124, 124, // 79568-79575
126, 127, 128, 129, 130, 130, 130, 130, // 79576-79583
128, 128, 126, 125, 123, 122, 124, 127, // 79584-79591
130, 131, 132, 132, 132, 132, 132, 131, // 79592-79599
126, 124, 122, 121, 122, 121, 121, 123, // 79600-79607
124, 127, 128, 130, 131, 131, 130, 129, // 79608-79615
128, 127, 125, 125, 124, 124, 126, 126, // 79616-79623
127, 127, 129, 131, 133, 134, 131, 129, // 79624-79631
129, 127, 128, 127, 124, 123, 124, 123, // 79632-79639
125, 125, 126, 127, 125, 127, 126, 125, // 79640-79647
126, 125, 126, 126, 126, 129, 128, 128, // 79648-79655
129, 128, 129, 129, 128, 126, 126, 127, // 79656-79663
128, 129, 128, 127, 129, 130, 130, 131, // 79664-79671
130, 127, 127, 125, 123, 124, 122, 121, // 79672-79679
121, 122, 124, 125, 127, 128, 130, 131, // 79680-79687
131, 132, 132, 129, 127, 125, 125, 123, // 79688-79695
123, 123, 123, 126, 129, 132, 134, 134, // 79696-79703
134, 134, 133, 131, 129, 124, 121, 121, // 79704-79711
120, 121, 122, 123, 124, 125, 128, 129, // 79712-79719
130, 129, 128, 129, 128, 126, 127, 124, // 79720-79727
124, 126, 127, 127, 129, 129, 130, 130, // 79728-79735
130, 131, 130, 129, 127, 128, 128, 128, // 79736-79743
129, 128, 125, 126, 126, 126, 126, 125, // 79744-79751
124, 123, 123, 123, 123, 124, 124, 127, // 79752-79759
128, 129, 131, 131, 131, 130, 129, 128, // 79760-79767
125, 125, 124, 123, 125, 127, 129, 130, // 79768-79775
130, 132, 134, 133, 134, 131, 128, 126, // 79776-79783
124, 123, 121, 120, 120, 119, 121, 124, // 79784-79791
126, 129, 130, 130, 132, 130, 130, 129, // 79792-79799
127, 125, 124, 124, 123, 125, 125, 127, // 79800-79807
128, 131, 132, 133, 133, 131, 131, 130, // 79808-79815
128, 127, 124, 122, 122, 123, 125, 126, // 79816-79823
128, 127, 127, 128, 127, 127, 126, 125, // 79824-79831
124, 124, 125, 127, 127, 128, 128, 129, // 79832-79839
130, 129, 129, 128, 127, 127, 128, 127, // 79840-79847
127, 125, 127, 129, 130, 131, 131, 129, // 79848-79855
129, 128, 127, 126, 123, 122, 121, 121, // 79856-79863
122, 123, 126, 126, 128, 130, 132, 132, // 79864-79871
132, 130, 129, 127, 125, 123, 121, 122, // 79872-79879
122, 124, 127, 130, 131, 133, 134, 135, // 79880-79887
134, 132, 129, 126, 124, 122, 121, 122, // 79888-79895
122, 123, 123, 124, 128, 129, 129, 130, // 79896-79903
129, 129, 128, 127, 126, 126, 124, 124, // 79904-79911
124, 125, 126, 128, 129, 130, 131, 131, // 79912-79919
131, 129, 128, 126, 126, 126, 126, 126, // 79920-79927
126, 127, 127, 128, 129, 129, 127, 126, // 79928-79935
125, 125, 124, 124, 123, 124, 126, 127, // 79936-79943
128, 129, 130, 131, 130, 129, 127, 127, // 79944-79951
126, 125, 124, 125, 126, 127, 129, 129, // 79952-79959
130, 131, 132, 132, 130, 129, 126, 126, // 79960-79967
125, 123, 121, 120, 121, 123, 124, 127, // 79968-79975
129, 130, 132, 132, 132, 130, 129, 126, // 79976-79983
125, 123, 123, 123, 124, 125, 126, 129, // 79984-79991
131, 133, 134, 131, 131, 130, 128, 128, // 79992-79999
125, 122, 122, 123, 125, 125, 126, 126, // 80000-80007
128, 129, 127, 127, 127, 126, 126, 125, // 80008-80015
126, 125, 126, 126, 126, 128, 128, 129, // 80016-80023
129, 130, 129, 129, 130, 129, 130, 127, // 80024-80031
126, 127, 127, 128, 128, 127, 128, 128, // 80032-80039
129, 128, 126, 125, 123, 123, 121, 122, // 80040-80047
123, 124, 126, 127, 129, 131, 131, 131, // 80048-80055
129, 128, 128, 126, 126, 124, 124, 124, // 80056-80063
126, 128, 130, 131, 131, 133, 134, 133, // 80064-80071
131, 128, 126, 124, 123, 121, 121, 120, // 80072-80079
121, 123, 124, 126, 128, 131, 131, 130, // 80080-80087
131, 130, 128, 127, 124, 122, 123, 125, // 80088-80095
125, 127, 128, 131, 132, 134, 134, 133, // 80096-80103
130, 128, 128, 126, 124, 124, 124, 124, // 80104-80111
124, 126, 128, 128, 127, 126, 124, 124, // 80112-80119
124, 124, 124, 123, 124, 127, 127, 128, // 80120-80127
130, 129, 130, 131, 130, 129, 128, 127, // 80128-80135
126, 126, 127, 128, 127, 128, 129, 130, // 80136-80143
130, 131, 131, 129, 126, 126, 125, 123, // 80144-80151
122, 120, 120, 121, 123, 124, 126, 128, // 80152-80159
130, 131, 132, 131, 129, 128, 126, 125, // 80160-80167
125, 125, 126, 127, 128, 129, 131, 133, // 80168-80175
133, 132, 131, 129, 129, 128, 127, 124, // 80176-80183
123, 122, 123, 124, 123, 125, 125, 126, // 80184-80191
127, 127, 127, 127, 127, 126, 126, 125, // 80192-80199
124, 124, 125, 126, 128, 129, 130, 132, // 80200-80207
133, 132, 132, 132, 131, 129, 126, 126, // 80208-80215
125, 126, 126, 127, 127, 127, 128, 129, // 80216-80223
128, 126, 125, 122, 121, 121, 121, 122, // 80224-80231
124, 126, 127, 130, 130, 130, 130, 129, // 80232-80239
128, 127, 127, 126, 127, 126, 127, 129, // 80240-80247
130, 130, 131, 131, 132, 131, 131, 129, // 80248-80255
127, 125, 124, 123, 122, 122, 121, 123, // 80256-80263
123, 125, 125, 126, 129, 129, 128, 128, // 80264-80271
127, 126, 126, 125, 124, 124, 127, 128, // 80272-80279
129, 129, 130, 131, 134, 132, 130, 129, // 80280-80287
127, 127, 126, 126, 125, 125, 126, 126, // 80288-80295
126, 126, 127, 125, 126, 125, 125, 125, // 80296-80303
126, 126, 125, 125, 125, 126, 126, 125, // 80304-80311
126, 127, 129, 131, 131, 130, 130, 130, // 80312-80319
131, 130, 128, 126, 127, 126, 127, 128, // 80320-80327
129, 128, 129, 128, 127, 127, 126, 124, // 80328-80335
122, 122, 122, 123, 124, 126, 126, 128, // 80336-80343
129, 130, 129, 128, 127, 127, 126, 127, // 80344-80351
126, 126, 127, 127, 129, 131, 131, 131, // 80352-80359
131, 130, 130, 129, 128, 126, 125, 125, // 80360-80367
123, 124, 124, 124, 125, 124, 125, 126, // 80368-80375
128, 128, 128, 126, 126, 126, 126, 125, // 80376-80383
124, 125, 125, 127, 128, 130, 130, 131, // 80384-80391
130, 131, 130, 130, 128, 128, 127, 126, // 80392-80399
127, 126, 127, 128, 127, 126, 127, 127, // 80400-80407
126, 125, 125, 125, 125, 126, 125, 125, // 80408-80415
125, 127, 126, 126, 126, 127, 127, 127, // 80416-80423
129, 129, 129, 129, 129, 129, 128, 128, // 80424-80431
128, 127, 127, 127, 129, 129, 128, 129, // 80432-80439
127, 126, 127, 126, 124, 123, 122, 123, // 80440-80447
124, 126, 127, 128, 128, 129, 129, 127, // 80448-80455
127, 126, 126, 125, 126, 127, 127, 129, // 80456-80463
130, 130, 130, 131, 131, 130, 129, 127, // 80464-80471
127, 127, 125, 125, 125, 123, 125, 126, // 80472-80479
126, 126, 126, 127, 128, 128, 127, 127, // 80480-80487
126, 125, 125, 124, 124, 125, 125, 126, // 80488-80495
128, 129, 130, 131, 131, 131, 130, 129, // 80496-80503
129, 127, 127, 126, 126, 127, 127, 128, // 80504-80511
127, 127, 126, 128, 126, 126, 125, 125, // 80512-80519
124, 125, 126, 126, 126, 126, 126, 127, // 80520-80527
127, 126, 127, 127, 127, 128, 128, 129, // 80528-80535
128, 129, 129, 129, 129, 129, 129, 129, // 80536-80543
129, 128, 128, 127, 127, 125, 126, 125, // 80544-80551
126, 126, 125, 125, 125, 125, 126, 127, // 80552-80559
126, 126, 126, 128, 126, 125, 125, 125, // 80560-80567
125, 127, 128, 128, 129, 130, 131, 131, // 80568-80575
131, 130, 129, 128, 127, 126, 126, 126, // 80576-80583
126, 125, 125, 126, 127, 127, 127, 127, // 80584-80591
126, 126, 126, 126, 124, 124, 124, 124, // 80592-80599
125, 126, 127, 128, 129, 129, 129, 129, // 80600-80607
129, 130, 129, 128, 128, 129, 128, 128, // 80608-80615
129, 128, 128, 128, 127, 126, 127, 127, // 80616-80623
127, 126, 125, 124, 124, 124, 124, 128, // 80624-80631
126, 152, 164, 144, 108,  88,  77,  93, // 80632-80639
 63,  47,  67, 146, 225, 242, 250, 212, // 80640-80647
  1, 198, 117,  60,  32,  14,  36,  36, // 80648-80655
  5,  84, 142, 179, 119, 141, 176, 230, // 80656-80663
240, 145,  98,  70,  35, 148, 160, 224, // 80664-80671
214, 249,  35,  50,  79,  96,  87, 142, // 80672-80679
165, 165, 175, 185, 187, 207, 158, 148, // 80680-80687
200, 218, 224, 221, 211, 200, 240, 202, // 80688-80695
 93,  35,  87, 111, 131, 113,  57, 134, // 80696-80703
130, 210,  16, 147,  36,  45,  20, 216, // 80704-80711
197, 228, 234, 226,  73,  87, 178, 255, // 80712-80719
 35,  32,  25, 248, 243, 250, 156, 123, // 80720-80727
 93, 107,  91, 129,  63,  33, 136, 213, // 80728-80735
226, 227, 190, 178, 197, 129, 179,  84, // 80736-80743
229, 182, 190, 182, 177,  21,  83,  76, // 80744-80751
123, 209, 224,  50,  19, 212, 169, 161, // 80752-80759
138, 135, 117,  76, 135, 186, 210, 205, // 80760-80767
217, 134, 164, 222, 161, 128, 100,  85, // 80768-80775
 81,  59,  99, 146,  81,  56,  27,  35, // 80776-80783
 27,  52, 125,  46,  14,  79, 127, 153, // 80784-80791
190, 161, 157, 220, 243, 235, 216, 203, // 80792-80799
187, 229, 190, 122, 110,  70,  34,  99, // 80800-80807
119,  92, 156, 170, 195, 151, 191, 236, // 80808-80815
169,  79, 230, 189, 193, 205, 247,  16, // 80816-80823
208,  75, 188, 250,  16,  23,   2,   6, // 80824-80831
 24, 185, 137, 103, 109, 100, 131,  81, // 80832-80839
106, 157, 136, 167, 211, 205, 200, 222, // 80840-80847
161,  93,  49, 147,  97,  14, 207, 170, // 80848-80855
248,  35,  78, 102,  83,  96, 219, 228, // 80856-80863
195, 169, 170, 158, 169, 153, 101, 140, // 80864-80871
180, 202, 201, 205, 175, 212, 170,  97, // 80872-80879
112, 112, 115, 107, 107,  63,  54, 179, // 80880-80887
234, 125,  73,  25,  29,  75,  29,  25, // 80888-80895
250, 254,  76, 142, 142, 152, 221, 252, // 80896-80903
  2, 246, 221, 190, 223, 186, 130, 111, // 80904-80911
 96, 105,  94,  50,  61, 153, 188, 211, // 80912-80919
183, 187, 132, 186, 252, 107, 253, 205, // 80920-80927
195, 217, 241, 229,  32,  59, 141, 204, // 80928-80935
241, 242,   0,  27, 208, 171, 132, 122, // 80936-80943
105, 129,  87, 109, 156, 189, 194, 145, // 80944-80951
150, 185, 229, 182, 123,  92,  78,  49, // 80952-80959
155, 112, 253,  17,  26,  53,  57,  79, // 80960-80967
 86, 107, 110, 130, 135, 155, 157, 175, // 80968-80975
171, 131, 167, 191, 200, 195, 197, 175, // 80976-80983
199, 199, 151,  82,  52,  98, 117, 134, // 80984-80991
 91,  99, 150, 139, 196, 235, 122,  69, // 80992-80999
 72,  15, 246, 234,  14,   9,  25,  71, // 81000-81007
111, 195, 237,   0, 251, 240, 216, 237, // 81008-81015
191, 133, 112, 103, 108, 110, 114,  69, // 81016-81023
 86, 149, 201, 198, 203, 163, 190, 161, // 81024-81031
111, 158,  82,   5, 231, 233, 206, 253, // 81032-81039
 67, 105,  89, 137, 181, 220,   8, 206, // 81040-81047
179, 151, 152, 134, 141,  96, 108, 154, // 81048-81055
184, 189, 187, 182, 131, 170, 170, 137, // 81056-81063
117, 106,  91,  99,  58, 116, 161,  99, // 81064-81071
 78,  51,  58,  46,  96, 106,  44,  34, // 81072-81079
 95, 126, 158, 167, 140, 177, 210, 223, // 81080-81087
206, 196, 172, 190, 198, 148, 114, 109, // 81088-81095
 78,  59, 114, 101, 121, 164, 170, 175, // 81096-81103
146, 171, 215, 159,  58, 252, 225, 241, // 81104-81111
246,  39,  20,   6, 118, 186, 225, 236, // 81112-81119
237, 221, 249, 216, 155, 123, 108, 109, // 81120-81127
115, 118,  85, 139, 156, 139, 158, 193, // 81128-81135
175, 201, 183, 131,  88,  72, 145, 101, // 81136-81143
 38, 227, 245,  41,  68,  91, 111,  82, // 81144-81151
123, 201, 179, 169, 152, 160, 148, 165, // 81152-81159
125, 121, 154, 176, 182, 184, 179, 167, // 81160-81167
203, 129,  92, 109, 117, 113, 120,  97, // 81168-81175
 78,  98, 185, 206, 119,  84,  44,  77, // 81176-81183
 72,  38,  43,  26,  32, 100, 136, 129, // 81184-81191
172, 211, 226, 221, 217, 185, 188, 192, // 81192-81199
145, 118, 109, 103, 111, 103,  50, 100, // 81200-81207
163, 182, 188, 171, 165, 135, 187, 195, // 81208-81215
 94,  19, 249, 239,  12,   2,  20,  78, // 81216-81223
 88, 146, 189, 212, 210, 241, 218, 169, // 81224-81231
148, 129, 118, 117, 118,  90, 137, 158, // 81232-81239
179, 170, 139, 137, 189, 191, 148, 114, // 81240-81247
100,  86,  78, 155,  96,  51,  58,  61, // 81248-81255
 71,  79,  85, 108, 112,  94, 122, 130, // 81256-81263
151, 148, 169, 140, 143, 173, 182, 179, // 81264-81271
177, 172, 164, 193, 158, 131,  81,  74, // 81272-81279
104, 128, 120, 101, 130, 153, 141, 186, // 81280-81287
205, 113, 100,  68,  26,  14,  19,  42, // 81288-81295
 42,  51,  78, 141, 193, 217, 219, 219, // 81296-81303
200, 206, 202, 148, 120, 109, 108, 113, // 81304-81311
119, 102,  98, 112, 154, 181, 182, 175, // 81312-81319
157, 182, 124, 110, 146,  92,  33,  24, // 81320-81327
  1,   4,  56,  95, 113,  99, 138, 167, // 81328-81335
215, 207, 169, 153, 144, 141, 136, 126, // 81336-81343
 96, 134, 155, 176, 170, 175, 158, 142, // 81344-81351
151, 140, 125, 118, 108, 104, 106,  65, // 81352-81359
147, 163, 111,  86,  73,  69,  79, 110, // 81360-81367
 89,  54,  58, 109, 128, 160, 141, 147, // 81368-81375
181, 197, 196, 183, 171, 159, 183, 158, // 81376-81383
130, 110, 115,  84,  85, 108, 107, 146, // 81384-81391
162, 162, 161, 141, 163, 209, 133,  58, // 81392-81399
 20,  13,  21,  34,  61,  35,  63, 136, // 81400-81407
181, 201, 210, 198, 205, 212, 168, 137, // 81408-81415
118, 112, 111, 121, 107, 112, 152, 152, // 81416-81423
134, 153, 170, 168, 190, 144, 119,  89, // 81424-81431
 95, 141, 112,  46,  17,  49,  74,  90, // 81432-81439
104, 114,  90, 143, 167, 153, 150, 145, // 81440-81447
145, 147, 148, 118, 142, 155, 169, 164, // 81448-81455
173, 159, 172, 171, 106,  94, 111, 119, // 81456-81463
121, 122,  92, 108, 122, 185, 181, 120, // 81464-81471
 86,  74,  94,  66,  55,  59,  52,  58, // 81472-81479
117, 122, 141, 177, 194, 198, 196, 189, // 81480-81487
169, 183, 155, 128, 115, 118, 109, 123, // 81488-81495
 94,  70, 129, 161, 173, 167, 157, 147, // 81496-81503
146, 165, 162,  91,  46,  28,  28,  42, // 81504-81511
 28,  71,  98, 105, 144, 177, 184, 199, // 81512-81519
208, 171, 150, 139, 129, 119, 123, 105, // 81520-81527
114, 151, 161, 169, 159, 130, 141, 181, // 81528-81535
155, 132, 107, 105,  90,  98, 137, 102, // 81536-81543
 85,  83,  84,  88,  96,  98, 127, 102, // 81544-81551
 94, 119, 131, 142, 147, 149, 127, 156, // 81552-81559
169, 174, 165, 167, 154, 168, 172, 138, // 81560-81567
123,  88,  89, 113, 128, 110, 120, 138, // 81568-81575
150, 136, 177, 176, 119, 109,  65,  46, // 81576-81583
 40,  51,  63,  68,  59, 102, 154, 184, // 81584-81591
196, 196, 191, 179, 193, 163, 131, 114, // 81592-81599
113, 110, 124, 117, 111, 124, 126, 157, // 81600-81607
169, 171, 158, 160, 156, 108, 110, 137, // 81608-81615
 91,  57,  47,  23,  53,  83, 111, 117, // 81616-81623
111, 135, 171, 193, 171, 152, 141, 138, // 81624-81631
134, 135, 111, 114, 143, 154, 165, 163, // 81632-81639
162, 153, 146, 133, 130, 118, 121, 109, // 81640-81647
115,  99,  86, 160, 155, 117,  98,  87, // 81648-81655
 82, 102, 102,  87,  63,  77, 114, 133, // 81656-81663
147, 132, 159, 174, 185, 176, 171, 154, // 81664-81671
161, 161, 133, 121, 112, 118,  95, 101, // 81672-81679
106, 127, 153, 162, 154, 154, 131, 162, // 81680-81687
186, 109,  67,  40,  42,  46,  63,  68, // 81688-81695
 67,  96, 145, 172, 185, 190, 181, 194, // 81696-81703
173, 145, 125, 118, 113, 120, 115, 110, // 81704-81711
134, 156, 154, 135, 153, 154, 167, 164, // 81712-81719
126, 113,  92, 102, 139, 108,  57,  61, // 81720-81727
 76,  93,  97, 113, 111, 107, 141, 143, // 81728-81735
142, 142, 144, 141, 146, 130, 128, 148, // 81736-81743
152, 160, 156, 157, 152, 170, 146, 106, // 81744-81751
100, 119, 118, 128, 116, 104, 124, 128, // 81752-81759
175, 163, 119,  93,  96,  89,  69,  68, // 81760-81767
 76,  68,  84, 121, 120, 156, 174, 186, // 81768-81775
181, 180, 163, 164, 161, 133, 120, 111, // 81776-81783
117, 115, 129,  94, 100, 142, 159, 162, // 81784-81791
162, 148, 145, 141, 141, 143,  88,  65, // 81792-81799
 50,  58,  53,  59, 101, 112, 118, 147, // 81800-81807
166, 171, 192, 176, 152, 137, 131, 121, // 81808-81815
123, 117, 108, 130, 149, 157, 161, 153, // 81816-81823
125, 150, 161, 136, 125, 110, 110,  99, // 81824-81831
109, 128, 117, 101,  98,  94,  99,  96, // 81832-81839
111, 127,  95, 103, 119, 132, 140, 150, // 81840-81847
137, 137, 159, 161, 162, 155, 153, 145, // 81848-81855
162, 144, 128, 118,  98,  99, 124, 123, // 81856-81863
116, 136, 143, 147, 134, 167, 154, 126, // 81864-81871
102,  68,  59,  58,  67,  84,  83,  76, // 81872-81879
126, 157, 178, 182, 183, 169, 174, 172, // 81880-81887
139, 123, 113, 115, 114, 126, 110, 125, // 81888-81895
131, 133, 153, 160, 155, 153, 157, 135, // 81896-81903
105, 112, 133,  94,  80,  58,  54,  83, // 81904-81911
 99, 119, 119, 114, 133, 168, 166, 152, // 81912-81919
142, 137, 133, 137, 128, 113, 130, 146, // 81920-81927
153, 154, 153, 149, 152, 135, 122, 125, // 81928-81935
118, 121, 116, 120,  97, 110, 161, 148, // 81936-81943
117, 105,  90,  97, 109,  97,  92,  77, // 81944-81951
 94, 118, 138, 136, 140, 162, 167, 171, // 81952-81959
162, 154, 144, 159, 142, 126, 118, 118, // 81960-81967
120, 110, 105, 115, 139, 150, 155, 149, // 81968-81975
145, 124, 162, 159, 101,  76,  60,  62, // 81976-81983
 70,  80,  80,  94, 113, 147, 162, 173, // 81984-81991
168, 175, 175, 150, 134, 120, 117, 115, // 81992-81999
125, 110, 121, 139, 154, 146, 136, 145, // 82000-82007
152, 163, 144, 122, 112, 100, 109, 139, // 82008-82015
100,  74,  86,  95, 105, 108, 118, 116, // 82016-82023
124, 133, 132, 132, 135, 136, 141, 135, // 82024-82031
124, 137, 147, 150, 151, 150, 144, 152, // 82032-82039
155, 132, 106, 106, 121, 124, 128, 109, // 82040-82047
118, 129, 133, 163, 150, 114, 104, 106, // 82048-82055
 89,  81,  81,  91,  86, 104, 116, 130, // 82056-82063
158, 169, 175, 168, 162, 152, 159, 141, // 82064-82071
124, 115, 115, 116, 122, 122, 102, 119, // 82072-82079
145, 158, 154, 150, 137, 145, 128, 129, // 82080-82087
128,  91,  77,  72,  77,  69,  90, 117, // 82088-82095
125, 125, 144, 150, 165, 174, 156, 142, // 82096-82103
131, 129, 124, 127, 111, 119, 135, 147, // 82104-82111
149, 153, 140, 130, 152, 145, 128, 119, // 82112-82119
113, 114, 110, 107, 126, 122, 109, 108, // 82120-82127
104, 104, 102, 124, 121,  98, 105, 120, // 82128-82135
130, 142, 142, 132, 143, 155, 157, 153, // 82136-82143
147, 141, 149, 152, 131, 124, 118, 107, // 82144-82151
114, 130, 117, 125, 138, 143, 140, 131, // 82152-82159
150, 146, 127,  98,  80,  73,  77,  86, // 82160-82167
101,  85,  93, 133, 153, 166, 166, 166, // 82168-82175
159, 169, 153, 132, 120, 116, 117, 122, // 82176-82183
118, 111, 134, 135, 139, 149, 153, 146, // 82184-82191
154, 146, 126, 106, 117, 129, 103,  88, // 82192-82199
 69,  81,  99, 111, 123, 121, 114, 139, // 82200-82207
157, 147, 141, 135, 136, 133, 135, 119, // 82208-82215
122, 135, 144, 147, 147, 141, 145, 151, // 82216-82223
127, 122, 123, 122, 122, 122, 115, 103, // 82224-82231
124, 155, 142, 119, 109, 100, 113, 110, // 82232-82239
101,  98,  89, 103, 124, 132, 127, 144, // 82240-82247
158, 160, 159, 153, 144, 148, 150, 130, // 82248-82255
123, 115, 118, 122, 113, 105, 124, 141, // 82256-82263
148, 147, 143, 137, 130, 161, 141, 102, // 82264-82271
 86,  80,  80,  89,  86,  95, 108, 120, // 82272-82279
145, 152, 158, 156, 170, 157, 140, 128, // 82280-82287
122, 120, 122, 119, 111, 128, 136, 149, // 82288-82295
139, 134, 140, 154, 151, 134, 120, 116, // 82296-82303
106, 120, 136,  98,  94, 101, 106, 110, // 82304-82311
114, 118, 122, 126, 126, 130, 130, 135, // 82312-82319
135, 141, 126, 128, 139, 143, 145, 144, // 82320-82327
141, 141, 149, 140, 125, 107, 115, 123, // 82328-82335
127, 123, 113, 129, 132, 137, 157, 141, // 82336-82343
113, 117, 107,  93,  89,  94, 100,  97, // 82344-82351
108, 115, 135, 154, 160, 161, 158, 151, // 82352-82359
151, 151, 131, 122, 116, 119, 117, 122, // 82360-82367
115, 111, 127, 145, 149, 149, 144, 139, // 82368-82375
147, 124, 131, 126, 100,  89,  88,  81, // 82376-82383
 83, 105, 120, 121, 122, 141, 145, 163, // 82384-82391
158, 145, 136, 131, 128, 127, 123, 113, // 82392-82399
126, 136, 144, 140, 145, 132, 134, 144, // 82400-82407
134, 128, 124, 118, 119, 115, 111, 136, // 82408-82415
125, 116, 110, 108, 108, 113, 128, 115, // 82416-82423
102, 110, 124, 129, 140, 132, 133, 144, // 82424-82431
150, 149, 146, 141, 138, 146, 139, 125, // 82432-82439
120, 118, 107, 117, 123, 120, 135, 138, // 82440-82447
140, 136, 135, 149, 147, 122, 100,  86, // 82448-82455
 86,  90,  96, 105,  92, 109, 137, 151, // 82456-82463
158, 161, 156, 158, 160, 141, 129, 119, // 82464-82471
119, 116, 122, 115, 117, 132, 132, 133, // 82472-82479
144, 146, 145, 152, 134, 124, 110, 124, // 82480-82487
126, 108,  93,  82,  95, 107, 116, 122, // 82488-82495
122, 118, 143, 147, 143, 140, 137, 136, // 82496-82503
135, 133, 122, 129, 134, 138, 138, 141, // 82504-82511
135, 141, 138, 124, 124, 125, 127, 127, // 82512-82519
124, 117, 118, 125, 138, 129, 120, 113, // 82520-82527
110, 117, 115, 113, 114, 112, 118, 127, // 82528-82535
128, 131, 137, 141, 141, 140, 139, 136, // 82536-82543
137, 134, 127, 126, 126, 124, 125, 123, // 82544-82551
121, 126, 131, 135, 134, 131, 130, 130, // 82552-82559
133, 128, 120, 116, 111, 112, 115, 114, // 82560-82567
119, 122, 126, 131, 136, 138, 139, 139, // 82568-82575
136, 133, 130, 129, 125, 125, 122, 121, // 82576-82583
127, 126, 127, 129, 130, 131, 133, 134, // 82584-82591
132, 127, 125, 123, 124, 123, 121, 121, // 82592-82599
119, 119, 123, 125, 126, 127, 128, 130, // 82600-82607
131, 134, 132, 130, 130, 128, 127, 128, // 82608-82615
127, 126, 127, 127, 129, 130, 129, 128, // 82616-82623
127, 128, 127, 128, 129, 125, 125, 125, // 82624-82631
126, 126, 126, 125, 122, 121, 122, 123, // 82632-82639
124, 124, 124, 125, 127, 130, 132, 130, // 82640-82647
131, 133, 132, 132, 133, 128, 128, 126, // 82648-82655
127, 127, 125, 123, 125, 125, 127, 129, // 82656-82663
132, 131, 129, 130, 129, 128, 126, 125, // 82664-82671
121, 117, 118, 119, 121, 123, 124, 127, // 82672-82679
129, 133, 136, 134, 132, 132, 130, 129, // 82680-82687
128, 125, 123, 123, 125, 128, 129, 127, // 82688-82695
129, 130, 130, 131, 131, 129, 126, 125, // 82696-82703
124, 123, 122, 124, 123, 121, 122, 125, // 82704-82711
126, 128, 128, 128, 128, 128, 130, 129, // 82712-82719
126, 126, 128, 128, 130, 130, 128, 128, // 82720-82727
129, 131, 131, 128, 127, 127, 126, 126, // 82728-82735
128, 128, 127, 125, 126, 127, 128, 128, // 82736-82743
127, 123, 121, 123, 123, 123, 122, 122, // 82744-82751
123, 126, 130, 132, 130, 131, 132, 133, // 82752-82759
133, 130, 127, 123, 125, 126, 127, 126, // 82760-82767
126, 127, 128, 129, 132, 134, 132, 130, // 82768-82775
127, 127, 126, 125, 123, 119, 116, 119, // 82776-82783
122, 124, 126, 126, 128, 130, 133, 133, // 82784-82791
130, 128, 127, 127, 127, 125, 125, 124, // 82792-82799
125, 129, 130, 132, 131, 130, 131, 129, // 82800-82807
131, 130, 127, 125, 122, 122, 124, 125, // 82808-82815
127, 124, 122, 125, 127, 127, 126, 125, // 82816-82823
124, 125, 126, 127, 127, 126, 127, 129, // 82824-82831
131, 130, 132, 130, 129, 129, 129, 129, // 82832-82839
128, 125, 124, 123, 126, 129, 129, 131, // 82840-82847
128, 128, 129, 129, 128, 125, 121, 120, // 82848-82855
121, 121, 122, 121, 123, 125, 128, 130, // 82856-82863
132, 132, 131, 132, 131, 131, 128, 128, // 82864-82871
124, 125, 124, 126, 129, 129, 128, 128, // 82872-82879
131, 133, 133, 131, 129, 125, 125, 124, // 82880-82887
123, 121, 118, 120, 122, 123, 125, 127, // 82888-82895
128, 130, 130, 130, 129, 129, 128, 125, // 82896-82903
126, 127, 127, 127, 126, 127, 129, 132, // 82904-82911
133, 132, 129, 127, 128, 129, 128, 125, // 82912-82919
125, 124, 124, 125, 125, 126, 125, 125, // 82920-82927
126, 125, 125, 125, 125, 123, 123, 125, // 82928-82935
126, 128, 129, 129, 130, 133, 133, 132, // 82936-82943
130, 128, 128, 127, 128, 126, 125, 123, // 82944-82951
125, 129, 130, 128, 130, 130, 128, 129, // 82952-82959
127, 125, 123, 121, 120, 119, 119, 121, // 82960-82967
124, 126, 128, 131, 133, 132, 133, 131, // 82968-82975
128, 129, 129, 126, 125, 124, 125, 127, // 82976-82983
129, 130, 130, 129, 129, 131, 132, 128, // 82984-82991
127, 127, 125, 123, 124, 123, 122, 122, // 82992-82999
123, 124, 125, 126, 127, 128, 128, 129, // 83000-83007
129, 126, 126, 127, 126, 126, 129, 129, // 83008-83015
128, 129, 131, 132, 131, 131, 129, 127, // 83016-83023
124, 126, 128, 126, 125, 127, 127, 127, // 83024-83031
128, 128, 126, 124, 125, 125, 124, 123, // 83032-83039
123, 123, 124, 125, 128, 128, 126, 129, // 83040-83047
131, 130, 131, 131, 129, 128, 128, 128, // 83048-83055
126, 126, 127, 125, 126, 127, 131, 131, // 83056-83063
128, 129, 130, 129, 127, 126, 123, 120, // 83064-83071
120, 123, 123, 124, 125, 126, 128, 130, // 83072-83079
132, 131, 129, 128, 129, 126, 126, 127, // 83080-83087
126, 126, 127, 130, 129, 129, 130, 130, // 83088-83095
129, 128, 129, 129, 125, 124, 124, 126, // 83096-83103
126, 125, 125, 122, 124, 126, 128, 127, // 83104-83111
127, 127, 127, 128, 127, 128, 127, 126, // 83112-83119
127, 126, 126, 130, 130, 128, 129, 129, // 83120-83127
130, 129, 128, 127, 127, 126, 128, 128, // 83128-83135
126, 125, 127, 129, 128, 127, 127, 124, // 83136-83143
122, 123, 124, 123, 124, 125, 125, 126, // 83144-83151
129, 131, 131, 129, 129, 129, 128, 129, // 83152-83159
129, 127, 125, 127, 127, 127, 126, 126, // 83160-83167
127, 129, 129, 130, 130, 128, 127, 128, // 83168-83175
128, 125, 124, 123, 120, 121, 123, 125, // 83176-83183
127, 127, 128, 128, 130, 132, 131, 129, // 83184-83191
126, 126, 126, 125, 125, 125, 125, 128, // 83192-83199
129, 131, 130, 129, 130, 130, 129, 128, // 83200-83207
127, 126, 125, 125, 128, 125, 127, 126, // 83208-83215
124, 122, 124, 127, 127, 126, 125, 125, // 83216-83223
127, 129, 129, 130, 126, 126, 128, 128, // 83224-83231
127, 127, 127, 127, 128, 127, 127, 126, // 83232-83239
127, 126, 128, 129, 128, 129, 130, 128, // 83240-83247
129, 129, 128, 127, 124, 121, 120, 124, // 83248-83255
125, 124, 124, 125, 128, 131, 132, 132, // 83256-83263
130, 128, 129, 127, 125, 124, 125, 125, // 83264-83271
125, 126, 127, 128, 129, 129, 129, 131, // 83272-83279
130, 130, 130, 127, 126, 127, 127, 125, // 83280-83287
122, 121, 121, 125, 128, 127, 126, 127, // 83288-83295
128, 130, 131, 129, 128, 126, 125, 126, // 83296-83303
125, 125, 127, 128, 128, 127, 129, 130, // 83304-83311
129, 129, 127, 128, 128, 128, 127, 126, // 83312-83319
126, 128, 131, 129, 125, 123, 123, 123, // 83320-83327
125, 124, 122, 123, 125, 127, 129, 131, // 83328-83335
131, 131, 129, 129, 128, 127, 126, 126, // 83336-83343
125, 123, 125, 127, 126, 126, 127, 129, // 83344-83351
132, 131, 129, 129, 129, 129, 129, 128, // 83352-83359
123, 121, 121, 121, 122, 125, 125, 126, // 83360-83367
128, 129, 129, 132, 132, 130, 127, 124, // 83368-83375
125, 125, 125, 124, 125, 126, 128, 130, // 83376-83383
130, 129, 129, 129, 130, 129, 126, 125, // 83384-83391
126, 127, 126, 129, 127, 125, 126, 126, // 83392-83399
124, 126, 127, 126, 125, 125, 125, 128, // 83400-83407
130, 129, 126, 125, 126, 128, 129, 128, // 83408-83415
127, 127, 127, 127, 127, 125, 125, 126, // 83416-83423
128, 127, 128, 128, 130, 131, 130, 129, // 83424-83431
129, 126, 124, 123, 120, 121, 125, 126, // 83432-83439
126, 126, 128, 131, 134, 134, 130, 127, // 83440-83447
126, 126, 125, 123, 122, 123, 123, 125, // 83448-83455
126, 128, 130, 130, 132, 131, 129, 129, // 83456-83463
128, 128, 126, 124, 126, 125, 123, 124, // 83464-83471
124, 125, 129, 131, 130, 128, 128, 129, // 83472-83479
131, 129, 126, 124, 123, 124, 125, 125, // 83480-83487
126, 128, 128, 128, 128, 128, 128, 128, // 83488-83495
126, 125, 125, 125, 127, 128, 128, 128, // 83496-83503
131, 131, 130, 128, 126, 126, 126, 126, // 83504-83511
125, 123, 124, 126, 128, 130, 131, 131, // 83512-83519
129, 129, 128, 127, 126, 126, 124, 122, // 83520-83527
122, 123, 125, 127, 128, 128, 128, 131, // 83528-83535
131, 132, 131, 129, 128, 128, 125, 123, // 83536-83543
122, 122, 123, 125, 128, 127, 129, 131, // 83544-83551
131, 132, 132, 130, 128, 125, 124, 124, // 83552-83559
123, 124, 124, 124, 125, 127, 129, 129, // 83560-83567
130, 129, 127, 128, 127, 126, 127, 125, // 83568-83575
125, 126, 126, 127, 127, 128, 127, 127, // 83576-83583
129, 128, 127, 127, 127, 127, 127, 127, // 83584-83591
126, 126, 125, 127, 129, 129, 129, 129, // 83592-83599
128, 127, 127, 127, 126, 125, 124, 124, // 83600-83607
125, 127, 128, 130, 129, 129, 129, 129, // 83608-83615
129, 127, 125, 123, 124, 125, 124, 125, // 83616-83623
126, 127, 130, 131, 131, 130, 129, 128, // 83624-83631
128, 127, 125, 124, 124, 124, 125, 127, // 83632-83639
128, 130, 129, 128, 129, 129, 128, 128, // 83640-83647
126, 125, 125, 125, 126, 125, 125, 126, // 83648-83655
126, 129, 130, 129, 130, 130, 129, 128, // 83656-83663
127, 126, 125, 124, 124, 125, 127, 127, // 83664-83671
128, 129, 129, 129, 130, 129, 127, 125, // 83672-83679
125, 125, 125, 125, 125, 125, 127, 127, // 83680-83687
128, 129, 128, 129, 128, 127, 127, 127, // 83688-83695
127, 127, 127, 125, 127, 128, 129, 127, // 83696-83703
127, 128, 128, 128, 127, 125, 126, 126, // 83704-83711
126, 127, 125, 126, 127, 128, 128, 127, // 83712-83719
128, 127, 128, 126, 126, 127, 127, 126, // 83720-83727
125, 124, 126, 128, 129, 129, 129, 129, // 83728-83735
130, 132, 130, 126, 123, 125, 124, 124, // 83736-83743
123, 123, 125, 128, 130, 129, 130, 130, // 83744-83751
130, 130, 128, 126, 125, 126, 125, 125, // 83752-83759
123, 126, 129, 130, 128, 127, 128, 130, // 83760-83767
130, 129, 127, 125, 126, 126, 127, 124, // 83768-83775
123, 125, 127, 126, 126, 126, 128, 129, // 83776-83783
129, 127, 126, 128, 128, 127, 125, 125, // 83784-83791
126, 128, 128, 127, 127, 128, 131, 131, // 83792-83799
128, 126, 127, 128, 127, 126, 125, 125, // 83800-83807
126, 128, 128, 128, 126, 127, 128, 126, // 83808-83815
124, 125, 125, 125, 125, 126, 126, 128, // 83816-83823
130, 128, 127, 128, 129, 129, 128, 126, // 83824-83831
126, 127, 128, 129, 127, 125, 126, 129, // 83832-83839
129, 129, 130, 130, 128, 128, 128, 126, // 83840-83847
125, 125, 124, 122, 122, 124, 126, 127, // 83848-83855
127, 128, 129, 131, 131, 130, 127, 126, // 83856-83863
128, 125, 124, 124, 125, 127, 128, 129, // 83864-83871
130, 130, 130, 130, 130, 127, 128, 128, // 83872-83879
126, 124, 125, 125, 126, 127, 126, 125, // 83880-83887
125, 127, 128, 128, 126, 127, 127, 128, // 83888-83895
127, 128, 126, 125, 128, 127, 126, 127, // 83896-83903
128, 128, 129, 130, 129, 129, 128, 127, // 83904-83911
127, 127, 127, 129, 127, 126, 126, 128, // 83912-83919
128, 128, 127, 124, 123, 124, 125, 125, // 83920-83927
125, 125, 126, 127, 129, 129, 130, 129, // 83928-83935
128, 128, 126, 126, 127, 127, 125, 126, // 83936-83943
129, 129, 130, 130, 128, 129, 130, 130, // 83944-83951
129, 126, 124, 126, 126, 125, 125, 123, // 83952-83959
121, 123, 125, 126, 127, 128, 128, 129, // 83960-83967
129, 129, 129, 127, 126, 125, 125, 124, // 83968-83975
126, 127, 128, 128, 131, 133, 133, 132, // 83976-83983
130, 129, 129, 129, 127, 125, 123, 123, // 83984-83991
124, 126, 126, 126, 124, 124, 125, 126, // 83992-83999
126, 126, 126, 126, 125, 127, 128, 128, // 84000-84007
127, 126, 126, 126, 126, 128, 127, 128, // 84008-84015
129, 130, 131, 129, 129, 129, 129, 129, // 84016-84023
130, 128, 127, 127, 126, 126, 127, 126, // 84024-84031
124, 123, 124, 124, 126, 127, 126, 126, // 84032-84039
126, 128, 130, 130, 128, 127, 126, 125, // 84040-84047
125, 125, 126, 126, 128, 129, 130, 131, // 84048-84055
132, 131, 131, 131, 131, 128, 126, 124, // 84056-84063
123, 123, 125, 125, 124, 122, 123, 126, // 84064-84071
127, 129, 129, 127, 128, 128, 129, 128, // 84072-84079
127, 125, 124, 124, 124, 125, 126, 127, // 84080-84087
129, 131, 132, 133, 133, 132, 130, 130, // 84088-84095
129, 127, 125, 124, 123, 123, 125, 126, // 84096-84103
126, 125, 124, 125, 126, 127, 127, 126, // 84104-84111
125, 126, 127, 127, 128, 127, 126, 126, // 84112-84119
127, 127, 127, 127, 127, 129, 129, 130, // 84120-84127
131, 130, 130, 130, 131, 129, 128, 128, // 84128-84135
126, 125, 125, 126, 125, 123, 122, 123, // 84136-84143
123, 126, 127, 127, 128, 128, 130, 130, // 84144-84151
129, 128, 127, 125, 125, 124, 123, 124, // 84152-84159
125, 127, 129, 131, 132, 133, 132, 132, // 84160-84167
132, 130, 128, 127, 124, 123, 122, 123, // 84168-84175
123, 123, 123, 123, 125, 127, 129, 129, // 84176-84183
128, 128, 128, 128, 127, 127, 126, 124, // 84184-84191
125, 125, 125, 125, 127, 129, 130, 131, // 84192-84199
132, 132, 131, 130, 130, 129, 128, 127, // 84200-84207
125, 124, 124, 125, 126, 125, 125, 125, // 84208-84215
124, 126, 127, 127, 127, 127, 127, 127, // 84216-84223
128, 127, 128, 127, 126, 126, 126, 125, // 84224-84231
125, 127, 127, 129, 130, 131, 131, 131, // 84232-84239
132, 132, 130, 129, 127, 126, 124, 123, // 84240-84247
124, 123, 122, 122, 123, 125, 127, 127, // 84248-84255
128, 129, 130, 130, 129, 128, 128, 126, // 84256-84263
125, 124, 123, 123, 123, 126, 127, 128, // 84264-84271
130, 132, 133, 133, 133, 133, 131, 128, // 84272-84279
126, 125, 123, 122, 123, 123, 122, 123, // 84280-84287
125, 126, 128, 129, 128, 129, 129, 129, // 84288-84295
127, 126, 125, 125, 125, 125, 124, 125, // 84296-84303
125, 127, 129, 130, 130, 131, 132, 131, // 84304-84311
130, 130, 129, 128, 127, 126, 125, 124, // 84312-84319
126, 125, 123, 124, 125, 125, 125, 126, // 84320-84327
126, 127, 128, 128, 127, 127, 126, 127, // 84328-84335
127, 126, 125, 125, 125, 125, 126, 127, // 84336-84343
129, 130, 131, 132, 131, 132, 132, 131, // 84344-84351
129, 127, 125, 124, 124, 123, 122, 122, // 84352-84359
123, 125, 125, 126, 128, 129, 131, 129, // 84360-84367
129, 127, 127, 126, 125, 124, 123, 123, // 84368-84375
125, 125, 127, 129, 130, 133, 131, 157, // 84376-84383
169, 149, 112,  92,  79,  93,  64,  45, // 84384-84391
 63, 140, 219, 235, 245, 207, 252, 196, // 84392-84399
116,  59,  32,  14,  35,  37,   4,  83, // 84400-84407
141, 181, 121, 140, 176, 229, 241, 148, // 84408-84415
101,  74,  38, 148, 167, 232, 217, 253, // 84416-84423
 38,  52,  79,  97,  85, 139, 161, 160, // 84424-84431
168, 179, 180, 201, 154, 144, 198, 219, // 84432-84439
225, 223, 214, 202, 241, 204,  94,  33, // 84440-84447
 84, 110, 130, 116,  59, 136, 135, 213, // 84448-84455
 22, 157,  44,  50,  26, 219, 197, 225, // 84456-84463
232, 220,  66,  81, 170, 249,  31,  30, // 84464-84471
 23, 248, 241, 251, 156, 121,  91, 106, // 84472-84479
 90, 127,  64,  31, 133, 213, 228, 229, // 84480-84487
196, 180, 203, 134, 183,  92, 234, 185, // 84488-84495
191, 185, 177,  21,  83,  77, 119, 206, // 84496-84503
219,  44,  15, 209, 165, 156, 136, 131, // 84504-84511
117,  77, 134, 185, 211, 204, 217, 135, // 84512-84519
161, 220, 163, 129, 101,  87,  83,  62, // 84520-84527
100, 151,  89,  61,  32,  38,  31,  52, // 84528-84535
124,  47,   9,  73, 122, 148, 184, 158, // 84536-84543
153, 216, 240, 235, 215, 203, 186, 228, // 84544-84551
192, 123, 111,  70,  33,  95, 120,  91, // 84552-84559
157, 172, 199, 157, 193, 241, 175,  84, // 84560-84567
235, 191, 194, 206, 245,  17, 207,  68, // 84568-84575
183, 245,  12,  18,   0,   1,  22, 185, // 84576-84583
136, 101, 108,  98, 130,  82, 106, 159, // 84584-84591
137, 166, 212, 209, 202, 224, 162,  97, // 84592-84599
 50, 148, 103,  19, 212, 172, 251,  38, // 84600-84607
 79, 102,  84,  93, 213, 224, 191, 165, // 84608-84615
165, 154, 162, 151,  99, 138, 180, 202, // 84616-84623
201, 207, 178, 214, 172,  95, 111, 113, // 84624-84631
118, 110, 109,  66,  57, 181, 238, 130, // 84632-84639
 77,  29,  30,  78,  31,  25, 252, 253, // 84640-84647
 72, 138, 139, 148, 218, 247, 253, 241, // 84648-84655
219, 189, 221, 185, 128, 112,  98, 108, // 84656-84663
 96,  52,  61, 154, 190, 213, 185, 189, // 84664-84671
135, 184,   0, 113,   2, 210, 198, 218, // 84672-84679
242, 228,  32,  59, 135, 198, 235, 238, // 84680-84687
250,  23, 203, 166, 130, 122, 105, 129, // 84688-84695
 88, 107, 158, 189, 196, 146, 151, 185, // 84696-84703
231, 185, 126,  95,  81,  51, 155, 119, // 84704-84711
  1,  21,  29,  54,  58,  80,  86, 106, // 84712-84719
107, 124, 131, 152, 155, 170, 167, 128, // 84720-84727
163, 188, 198, 193, 196, 174, 198, 201, // 84728-84735
153,  86,  53,  99, 117, 135,  95, 101, // 84736-84743
151, 140, 195, 237, 127,  72,  74,  16, // 84744-84751
246, 236,  15,  10,  24,  68, 107, 191, // 84752-84759
233, 250, 246, 236, 212, 233, 189, 132, // 84760-84767
113, 103, 108, 112, 118,  74,  89, 150, // 84768-84775
201, 199, 204, 164, 189, 162, 110, 159, // 84776-84783
 88,   9, 235, 235, 208, 254,  68, 104, // 84784-84791
 88, 133, 177, 214,   3, 202, 175, 148, // 84792-84799
150, 131, 139,  97, 108, 155, 183, 189, // 84800-84807
188, 185, 132, 171, 170, 138, 119, 109, // 84808-84815
 95, 103,  60, 116, 165, 101,  79,  51, // 84816-84823
 58,  46,  95, 106,  44,  33,  93, 124, // 84824-84831
156, 166, 139, 175, 209, 220, 202, 193, // 84832-84839
171, 188, 196, 147, 113, 111,  84,  62, // 84840-84847
115, 102, 123, 167, 171, 176, 145, 170, // 84848-84855
215, 162,  60, 255, 228, 244, 249,  40, // 84856-84863
 22,   5, 116, 184, 222, 231, 233, 217, // 84864-84871
243, 213, 152, 121, 108, 109, 114, 119, // 84872-84879
 86, 140, 158, 140, 158, 192, 176, 202, // 84880-84887
184, 131,  89,  72, 146, 105,  42, 231, // 84888-84895
249,  44,  71,  92, 110,  81, 119, 198, // 84896-84903
175, 166, 149, 158, 148, 164, 125, 119, // 84904-84911
154, 176, 182, 182, 178, 165, 201, 131, // 84912-84919
 93, 109, 118, 116, 123, 101,  81, 101, // 84920-84927
185, 208, 119,  84,  44,  76,  71,  37, // 84928-84935
 41,  26,  34, 100, 136, 129, 169, 209, // 84936-84943
225, 220, 213, 182, 185, 191, 144, 118, // 84944-84951
111, 106, 114, 106,  55, 102, 164, 184, // 84952-84959
189, 171, 165, 135, 183, 195,  95,  21, // 84960-84967
253, 243,  15,   5,  20,  76,  86, 144, // 84968-84975
185, 208, 206, 237, 218, 169, 148, 129, // 84976-84983
118, 116, 119,  92, 137, 158, 179, 171, // 84984-84991
141, 138, 187, 192, 149, 117, 101,  91, // 84992-84999
 79, 153,  98,  51,  59,  63,  72,  79, // 85000-85007
 84, 105, 112,  93, 121, 128, 149, 146, // 85008-85015
168, 141, 143, 173, 183, 181, 177, 173, // 85016-85023
163, 192, 158, 132,  83,  75, 105, 128, // 85024-85031
121, 101, 129, 153, 141, 184, 206, 115, // 85032-85039
100,  71,  30,  15,  17,  40,  42,  50, // 85040-85047
 76, 138, 188, 214, 217, 219, 199, 205, // 85048-85055
203, 152, 124, 112, 110, 113, 119, 103, // 85056-85063
 98, 111, 153, 180, 182, 176, 157, 182, // 85064-85071
128, 112, 145,  93,  34,  25,   2,   3, // 85072-85079
 52,  92, 112, 100, 135, 162, 209, 205, // 85080-85087
170, 155, 144, 142, 138, 131,  99, 135, // 85088-85095
157, 176, 170, 176, 159, 141, 152, 141, // 85096-85103
126, 117, 109, 105, 109,  66, 142, 161, // 85104-85111
112,  89,  74,  69,  75, 108,  90,  56, // 85112-85119
 55, 105, 124, 157, 140, 147, 179, 195, // 85120-85127
197, 186, 174, 160, 186, 160, 133, 110, // 85128-85135
116,  85,  86, 109, 107, 142, 161, 163, // 85136-85143
162, 141, 157, 205, 135,  62,  23,  12, // 85144-85151
 20,  32,  62,  37,  59, 131, 176, 196, // 85152-85159
208, 197, 205, 211, 171, 140, 120, 114, // 85160-85167
115, 125, 107, 110, 150, 154, 135, 154, // 85168-85175
169, 165, 189, 148, 123,  90,  92, 139, // 85176-85183
112,  48,  17,  45,  71,  87, 103, 114, // 85184-85191
 90, 139, 166, 152, 149, 145, 148, 148, // 85192-85199
149, 119, 141, 155, 170, 167, 172, 155, // 85200-85207
170, 175, 110,  96, 112, 118, 120, 125, // 85208-85215
 95, 107, 118, 180, 181, 122,  87,  72, // 85216-85223
 93,  66,  55,  60,  53,  58, 115, 120, // 85224-85231
137, 174, 195, 200, 197, 189, 168, 183, // 85232-85239
160, 133, 116, 115, 108, 124,  98,  70, // 85240-85247
127, 159, 171, 171, 162, 149, 144, 163, // 85248-85255
164,  93,  48,  28,  27,  41,  26,  68, // 85256-85263
 97, 104, 141, 173, 179, 195, 211, 178, // 85264-85271
153, 139, 130, 121, 127, 110, 113, 147, // 85272-85279
155, 168, 159, 130, 139, 180, 156, 134, // 85280-85287
112, 109,  93, 100, 139, 103,  84,  82, // 85288-85295
 82,  85,  90,  91, 123, 102,  93, 116, // 85296-85303
127, 141, 149, 156, 132, 156, 169, 175, // 85304-85311
168, 170, 155, 167, 171, 137, 123,  87, // 85312-85319
 87, 112, 129, 110, 119, 138, 151, 137, // 85320-85327
177, 177, 121, 113,  70,  48,  39,  47, // 85328-85335
 61,  69,  57,  95, 145, 177, 192, 197, // 85336-85343
193, 181, 196, 169, 138, 120, 118, 113, // 85344-85351
125, 117, 108, 118, 119, 151, 166, 168, // 85352-85359
156, 159, 158, 114, 115, 143,  99,  64, // 85360-85367
 54,  26,  52,  80, 106, 113, 107, 125, // 85368-85375
159, 185, 166, 152, 143, 140, 137, 140, // 85376-85383
118, 117, 146, 157, 167, 162, 159, 149, // 85384-85391
144, 129, 130, 117, 119, 109, 115, 102, // 85392-85399
 87, 160, 159, 122, 102,  91,  82, 103, // 85400-85407
103,  89,  65,  73, 108, 128, 144, 128, // 85408-85415
156, 171, 182, 175, 171, 154, 164, 168, // 85416-85423
141, 127, 113, 118,  96,  99, 102, 121, // 85424-85431
145, 157, 152, 153, 132, 161, 193, 121, // 85432-85439
 76,  49,  45,  49,  66,  68,  64,  90, // 85440-85447
138, 167, 178, 183, 177, 195, 177, 149, // 85448-85455
127, 118, 114, 123, 119, 108, 127, 149, // 85456-85463
149, 130, 147, 150, 163, 166, 131, 116, // 85464-85471
 97, 107, 144, 118,  63,  65,  79,  96, // 85472-85479
101, 113, 109, 104, 139, 141, 137, 135, // 85480-85487
139, 140, 148, 131, 126, 146, 155, 162, // 85488-85495
158, 157, 149, 167, 146, 103,  94, 113, // 85496-85503
114, 126, 116, 101, 124, 133, 181, 172, // 85504-85511
127,  99, 102,  96,  76,  68,  74,  67, // 85512-85519
 81, 116, 113, 145, 166, 183, 179, 179, // 85520-85527
163, 164, 165, 138, 123, 114, 118, 114, // 85528-85535
126,  91,  93, 135, 156, 160, 161, 146, // 85536-85543
145, 148, 151, 151,  97,  73,  57,  64, // 85544-85551
 58,  59,  95, 109, 113, 140, 159, 163, // 85552-85559
185, 175, 154, 139, 133, 124, 126, 120, // 85560-85567
109, 129, 149, 155, 156, 148, 119, 144, // 85568-85575
159, 135, 124, 110, 111, 106, 118, 135, // 85576-85583
122, 108, 105,  98, 102,  96, 107, 125, // 85584-85591
 94,  97, 114, 126, 135, 146, 136, 135, // 85592-85599
157, 163, 163, 157, 154, 147, 165, 147, // 85600-85607
127, 115,  94,  94, 121, 120, 112, 131, // 85608-85615
142, 150, 140, 173, 161, 133, 112,  78, // 85616-85623
 64,  62,  68,  82,  81,  71, 117, 149, // 85624-85631
171, 174, 178, 168, 173, 175, 145, 125, // 85632-85639
116, 118, 117, 127, 108, 119, 125, 127, // 85640-85647
148, 156, 152, 151, 157, 139, 111, 118, // 85648-85655
140, 103,  87,  66,  56,  84, 100, 117, // 85656-85663
115, 111, 128, 162, 164, 149, 139, 138, // 85664-85671
135, 139, 131, 114, 128, 146, 154, 156, // 85672-85679
152, 145, 148, 132, 120, 121, 116, 119, // 85680-85687
116, 122, 100, 113, 164, 155, 123, 111, // 85688-85695
 94,  98, 110,  98,  89,  74,  90, 114, // 85696-85703
133, 132, 134, 159, 168, 172, 165, 157, // 85704-85711
146, 161, 146, 129, 118, 116, 115, 104, // 85712-85719
100, 109, 134, 148, 154, 149, 149, 129, // 85720-85727
169, 170, 111,  82,  66,  66,  71,  80, // 85728-85735
 76,  87, 106, 142, 156, 168, 163, 171, // 85736-85743
177, 153, 138, 124, 120, 117, 127, 113, // 85744-85751
120, 135, 149, 140, 130, 141, 147, 159, // 85752-85759
144, 122, 114, 104, 114, 147, 111,  82, // 85760-85767
 91,  98, 107, 108, 117, 110, 116, 129, // 85768-85775
129, 127, 131, 133, 142, 142, 130, 140, // 85776-85783
150, 154, 153, 153, 144, 148, 151, 127, // 85784-85791
 99, 101, 116, 118, 127, 110, 119, 132, // 85792-85799
140, 171, 158, 120, 107, 108,  94,  79, // 85800-85807
 76,  84,  77,  97, 113, 123, 151, 164, // 85808-85815
172, 171, 168, 155, 162, 146, 129, 119, // 85816-85823
119, 117, 123, 123, 100, 115, 144, 155, // 85824-85831
153, 150, 136, 146, 133, 136, 134,  98, // 85832-85839
 83,  78,  83,  74,  87, 112, 117, 115, // 85840-85847
137, 143, 154, 164, 149, 139, 132, 133, // 85848-85855
128, 132, 119, 126, 142, 152, 150, 152, // 85856-85863
138, 122, 145, 141, 125, 116, 112, 113, // 85864-85871
113, 117, 138, 130, 118, 113, 107, 109, // 85872-85879
100, 118, 113,  91,  98, 116, 126, 138, // 85880-85887
142, 135, 147, 160, 161, 154, 149, 142, // 85888-85895
147, 150, 130, 120, 115, 101, 108, 130, // 85896-85903
118, 125, 136, 143, 141, 136, 156, 149, // 85904-85911
127, 102,  83,  79,  82,  86, 101,  87, // 85912-85919
 93, 130, 149, 160, 160, 161, 154, 166, // 85920-85927
154, 134, 122, 121, 122, 128, 127, 117, // 85928-85935
133, 130, 132, 144, 149, 138, 144, 138, // 85936-85943
124, 107, 123, 135, 109,  99,  80,  90, // 85944-85951
106, 114, 120, 117, 107, 129, 149, 142, // 85952-85959
136, 132, 135, 135, 143, 128, 126, 138, // 85960-85967
147, 148, 148, 141, 139, 142, 120, 119, // 85968-85975
122, 120, 119, 121, 119, 107, 128, 161, // 85976-85983
146, 122, 112, 100, 114, 110, 101,  95, // 85984-85991
 86, 100, 122, 134, 130, 143, 155, 161, // 85992-85999
161, 156, 142, 142, 147, 131, 124, 118, // 86000-86007
119, 120, 114, 108, 126, 140, 146, 142, // 86008-86015
140, 133, 126, 159, 144, 106,  90,  84, // 86016-86023
 88,  97,  93,  96, 105, 116, 140, 148, // 86024-86031
153, 148, 159, 152, 140, 132, 127, 123, // 86032-86039
127, 128, 119, 133, 140, 148, 134, 129, // 86040-86047
134, 146, 144, 127, 116, 114, 107, 124, // 86048-86055
145, 109, 103, 106, 113, 116, 115, 114, // 86056-86063
113, 115, 119, 123, 126, 132, 133, 142, // 86064-86071
134, 137, 146, 148, 147, 146, 141, 138, // 86072-86079
145, 138, 120, 103, 112, 122, 129, 126, // 86080-86087
115, 129, 132, 138, 159, 144, 113, 114, // 86088-86095
107,  97,  91,  93,  97,  94, 107, 115, // 86096-86103
134, 151, 157, 158, 157, 151, 152, 151, // 86104-86111
133, 123, 118, 121, 122, 129, 120, 113, // 86112-86119
126, 144, 147, 146, 137, 131, 139, 121, // 86120-86127
131, 128, 104,  95,  96,  93,  93, 107, // 86128-86135
120, 118, 117, 134, 137, 154, 149, 138, // 86136-86143
133, 134, 133, 133, 130, 119, 131, 139, // 86144-86151
146, 142, 144, 128, 127, 140, 131, 123, // 86152-86159
119, 116, 120, 119, 118, 141, 132, 122, // 86160-86167
115, 111, 110, 110, 121, 107,  95, 105, // 86168-86175
120, 129, 140, 133, 135, 148, 156, 153, // 86176-86183
147, 141, 135, 144, 136, 125, 120, 117, // 86184-86191
107, 119, 126, 120, 134, 137, 141, 136, // 86192-86199
134, 147, 146, 123, 104,  91,  91,  94, // 86200-86207
 99, 105,  91, 108, 133, 146, 153, 153, // 86208-86215
148, 151, 158, 141, 130, 121, 122, 121, // 86216-86223
129, 121, 123, 135, 131, 133, 142, 140, // 86224-86231
138, 144, 130, 122, 109, 126, 130, 115, // 86232-86239
100,  93, 104, 115, 119, 122, 116, 113, // 86240-86247
134, 140, 135, 131, 129, 131, 138, 138, // 86248-86255
131, 131, 169, 175, 158, 118, 103,  87, // 86256-86263
111,  79,  49,  90,  92, 173, 220, 231, // 86264-86271
209, 240, 235, 132,  32,  67,  68,  45, // 86272-86279
 57, 241,  47, 106, 155, 149, 103, 121, // 86280-86287
194, 240, 177, 116,  93,  57, 112, 194, // 86288-86295
 43, 212, 251,  21,  51,  67,  90, 111, // 86296-86303
132, 131, 156, 164, 187, 191, 211, 194, // 86304-86311
104, 191,  14, 251, 238, 216, 188, 226, // 86312-86319
204, 131,  40,  22,  86, 107, 126,  61, // 86320-86327
117, 140, 175,   7, 209,  70,  46,  42, // 86328-86335
222, 205, 202, 255, 234,  19,  59, 139, // 86336-86343
235,  35,  36,  46, 249, 212,  54, 212, // 86344-86351
144, 103,  97,  89, 104,  84,  40,  73, // 86352-86359
162, 210, 214, 210, 172, 213, 145, 160, // 86360-86367
134,  17, 195, 190, 187, 168, 243,  72, // 86368-86375
105,  86, 164, 207,  23,  45, 225, 190, // 86376-86383
168, 113, 155, 178,  96, 131, 170, 205, // 86384-86391
193, 204, 172, 127, 176, 159, 121, 105, // 86392-86399
 90,  87,  76,  76, 142, 127,  70,  44, // 86400-86407
 29,  32,  34, 108,  93,  12,  24, 105, // 86408-86415
139, 184, 179, 149, 229, 216, 238,  16, // 86416-86423
233, 200, 221, 202, 129,  94,  89,  41, // 86424-86431
 34, 102,  73, 136, 172, 196, 174, 172, // 86432-86439
229, 210, 124,   1, 199, 181, 207, 217, // 86440-86447
 30, 233,   6, 147, 230,  10,  29,  11, // 86448-86455
 12,  24, 183, 188, 141, 123, 107, 119, // 86456-86463
 93,  73, 148, 154, 130, 167, 199, 184, // 86464-86471
227, 180, 119,  56, 116, 132,  52, 235, // 86472-86479
174, 226,  28,  65,  94, 114,  69, 158, // 86480-86487
227, 192, 178, 166, 169, 170, 135, 122, // 86488-86495
171, 190, 214, 200, 205, 175, 186, 207, // 86496-86503
 97,  68,  93, 102, 107, 113,  82,  57, // 86504-86511
142, 236, 180,  92,  48,  19,  69,  42, // 86512-86519
 12,  21, 252,  21, 115, 141, 140, 213, // 86520-86527
246,  22, 228, 221, 238, 238, 215, 140, // 86528-86535
110,  93,  89, 102,  71,  12, 109, 169, // 86536-86543
204, 194, 191, 156, 157, 245, 164,  37, // 86544-86551
217, 202, 201, 243, 218,  21,  73,  95, // 86552-86559
170, 226, 241, 249,  29, 236, 176, 113, // 86560-86567
156, 139, 138, 111,  91, 149, 168, 194, // 86568-86575
170, 128, 139, 209, 187, 138,  97,  91, // 86576-86583
 56, 118, 148,  37,  18,  31,  47,  56, // 86584-86591
 73,  78, 121, 102,  92, 126, 141, 160, // 86592-86599
168, 185, 148, 131, 199, 244, 213, 210, // 86600-86607
180, 184, 199, 149, 111,  46,  51,  94, // 86608-86615
121, 103,  92, 147, 149, 172, 233, 177, // 86616-86623
 81,  81,  29, 243, 234, 250,  26,  25, // 86624-86631
 36,  82, 173, 227,   5, 252,   8, 206, // 86632-86639
217, 248, 164, 128, 107, 103, 104, 109, // 86640-86647
 82,  90, 105, 169, 188, 197, 175, 178, // 86648-86655
184, 111, 141, 118,  39, 237, 242, 207, // 86656-86663
238,  47, 104, 112, 103, 153, 197, 254, // 86664-86671
224, 183, 164, 154, 110, 164, 145, 111, // 86672-86679
158, 174, 190, 176, 184, 152, 143, 142, // 86680-86687
130, 110, 110,  95, 105,  78,  86, 165, // 86688-86695
133,  89,  61,  56,  44,  75, 105,  75, // 86696-86703
 28,  51, 114, 143, 176, 150, 172, 222, // 86704-86711
200, 212, 239, 195, 189, 199, 154, 113, // 86712-86719
 95, 100,  59,  72,  92, 100, 157, 172, // 86720-86727
181, 158, 157, 199, 196,  90,  11, 230, // 86728-86735
230, 243,  17,  46,  12,  70, 159, 216, // 86736-86743
232, 248, 221, 254, 221, 147, 162, 133, // 86744-86751
121, 115, 120,  87, 114, 159, 156, 127, // 86752-86759
164, 169, 182, 197, 139, 106,  68, 123, // 86760-86767
124,  70, 246, 241,  30,  65,  83, 110, // 86768-86775
110,  90, 166, 177, 164, 158, 160, 157, // 86776-86783
168, 118, 134, 185, 186, 196, 179, 181, // 86784-86791
153, 186, 161,  82,  74, 102, 106, 120, // 86792-86799
111,  85,  99, 157, 215, 155,  96,  52, // 86800-86807
 59,  72,  37,  31,  42,  29,  56, 129, // 86808-86815
129, 165, 214, 231, 240, 202, 192, 217, // 86816-86823
213, 164, 123, 106, 102,  97, 118,  67, // 86824-86831
 56, 139, 171, 188, 175, 169, 140, 164, // 86832-86839
190, 131,  41, 255, 242,   0,  13,   5, // 86840-86847
 76,  97, 114, 164, 206, 205, 238, 230, // 86848-86855
189, 149, 113, 149, 140, 134, 100, 123, // 86856-86863
155, 167, 175, 158, 116, 148, 186, 148, // 86864-86871
123,  96,  96,  73, 132, 124,  71,  60, // 86872-86879
 63,  67,  77,  82,  95, 132,  86,  93, // 86880-86887
121, 142, 153, 169, 160, 146, 152, 196, // 86888-86895
221, 191, 187, 160, 185, 163, 127, 101, // 86896-86903
 61,  68, 109, 119, 100, 122, 151, 150, // 86904-86911
165, 210, 151, 102,  83,  31,  11,  10, // 86912-86919
 29,  53,  54,  46, 117, 181, 216, 229, // 86920-86927
224, 220, 187, 203, 194, 143, 119, 111, // 86928-86935
107, 119, 100, 101, 115, 120, 163, 173, // 86936-86943
177, 157, 176, 144, 103, 132, 117,  52, // 86944-86951
 24,  11, 248,  45,  80, 120, 114, 114, // 86952-86959
144, 199, 212, 181, 158, 152, 141, 118, // 86960-86967
158, 127, 135, 161, 172, 174, 168, 161, // 86968-86975
150, 136, 118, 119, 108, 112,  99, 113, // 86976-86983
 74, 115, 173, 138,  97,  78,  69,  68, // 86984-86991
102,  93,  76,  44,  76, 118, 149, 154, // 86992-86999
146, 182, 205, 184, 195, 210, 171, 188, // 87000-87007
166, 133, 109, 103, 100,  75,  82,  93, // 87008-87015
129, 160, 166, 164, 150, 146, 198, 171, // 87016-87023
 76,  28,   7,  14,  26,  54,  54,  58, // 87024-87031
102, 165, 196, 209, 210, 201, 227, 170, // 87032-87039
134, 147, 130, 119, 125, 109, 105, 137, // 87040-87047
159, 148, 126, 153, 156, 183, 159, 120, // 87048-87055
 97,  83, 125, 131,  73,  18,  42,  65, // 87056-87063
 89,  96, 120, 107, 115, 153, 152, 148, // 87064-87071
149, 149, 153, 155, 106, 152, 179, 179, // 87072-87079
176, 169, 161, 157, 174, 129,  80,  81, // 87080-87087
109, 110, 127,  98, 103, 120, 161, 194, // 87088-87095
147,  98,  71,  88,  70,  52,  53,  67, // 87096-87103
 52,  87, 122, 129, 175, 199, 207, 207, // 87104-87111
179, 171, 208, 178, 140, 116, 112, 107, // 87112-87119
110, 115,  69,  91, 145, 166, 171, 164, // 87120-87127
150, 146, 156, 159, 119,  56,  31,  21, // 87128-87135
 37,  27,  52, 104, 111, 120, 161, 182, // 87136-87143
190, 218, 184, 164, 133, 120, 143, 142, // 87144-87151
121, 110, 140, 158, 161, 162, 146, 116, // 87152-87159
159, 158, 134, 117, 105, 100,  93, 127, // 87160-87167
115,  96,  83,  83,  78,  91,  88, 121, // 87168-87175
125,  83,  99, 123, 138, 149, 158, 138, // 87176-87183
153, 155, 188, 193, 175, 165, 160, 176, // 87184-87191
137, 119, 102,  79,  85, 120, 108, 116, // 87192-87199
138, 153, 144, 159, 184, 141, 118,  78, // 87200-87207
 44,  34,  43,  54,  79,  61,  69, 140, // 87208-87215
176, 197, 200, 199, 191, 184, 176, 162, // 87216-87223
129, 119, 111, 114, 115,  95, 121, 125, // 87224-87231
131, 156, 165, 162, 164, 167, 125, 104, // 87232-87239
130, 116,  69,  54,  26,  37,  78, 100, // 87240-87247
122, 118, 114, 147, 187, 170, 156, 142, // 87248-87255
146, 133, 126, 139, 126, 148, 160, 164, // 87256-87263
163, 156, 150, 156, 123, 114, 114, 114, // 87264-87271
114, 113, 111,  84, 139, 168, 137, 106, // 87272-87279
 95,  79,  98, 105,  88,  79,  62,  91, // 87280-87287
123, 142, 134, 152, 177, 190, 168, 181, // 87288-87295
179, 165, 176, 139, 121, 105, 107, 104, // 87296-87303
 93,  84, 109, 141, 162, 161, 159, 143, // 87304-87311
148, 192, 142,  80,  49,  39,  42,  60, // 87312-87319
 64,  70,  90, 121, 164, 179, 189, 183, // 87320-87327
195, 191, 142, 124, 137, 122, 122, 119, // 87328-87335
101, 122, 141, 155, 140, 131, 144, 159, // 87336-87343
171, 139, 117, 102,  98, 129, 130,  74, // 87344-87351
 61,  79,  91, 104, 109, 120, 115, 127, // 87352-87359
134, 134, 133, 140, 136, 150, 133, 112, // 87360-87367
160, 170, 169, 164, 157, 149, 159, 150, // 87368-87375
116,  84,  93, 109, 119, 123, 103, 128, // 87376-87383
133, 166, 180, 144, 105, 103,  97,  74, // 87384-87391
 64,  69,  79,  71,  99, 110, 136, 170, // 87392-87399
184, 186, 187, 157, 169, 188, 146, 127, // 87400-87407
109, 110, 107, 116, 105,  88, 116, 150, // 87408-87415
161, 166, 155, 150, 154, 141, 145, 111, // 87416-87423
 75,  57,  58,  56,  54,  88, 119, 121, // 87424-87431
126, 156, 162, 183, 183, 152, 144, 123, // 87432-87439
117, 139, 131, 111, 126, 145, 155, 152, // 87440-87447
155, 134, 128, 151, 134, 124, 114, 112, // 87448-87455
109, 108, 122, 128, 118, 108, 103,  98, // 87456-87463
101, 103, 130, 110,  86, 100, 121, 130, // 87464-87471
145, 136, 135, 157, 152, 177, 174, 161, // 87472-87479
151, 159, 149, 120, 111, 103,  86, 101, // 87480-87487
117, 109, 134, 145, 157, 143, 158, 166, // 87488-87495
146, 119,  80,  61,  58,  65,  78,  94, // 87496-87503
 70,  98, 146, 168, 178, 180, 171, 176, // 87504-87511
167, 147, 143, 120, 120, 113, 121, 107, // 87512-87519
108, 134, 132, 133, 149, 152, 153, 162, // 87520-87527
145, 116, 107, 131, 115,  91,  70,  53, // 87528-87535
 80, 102, 115, 127, 121, 116, 153, 164, // 87536-87543
146, 140, 133, 139, 131, 124, 129, 137, // 87544-87551
150, 156, 153, 152, 141, 149, 146, 109, // 87552-87559
109, 112, 118, 119, 122, 107, 103, 149, // 87560-87567
163, 137, 114, 101,  96, 114,  99,  93, // 87568-87575
 87,  80, 101, 127, 129, 133, 155, 170, // 87576-87583
175, 154, 167, 162, 164, 153, 126, 116, // 87584-87591
108, 110, 113,  97,  91, 125, 146, 160, // 87592-87599
152, 153, 134, 152, 172, 125,  87,  68, // 87600-87607
 63,  69,  80,  75,  96, 109, 129, 154, // 87608-87615
165, 166, 169, 178, 162, 130, 122, 136, // 87616-87623
122, 127, 113, 113, 132, 142, 149, 135, // 87624-87631
127, 138, 157, 150, 126, 115, 108, 105, // 87632-87639
133, 122,  86,  91,  99, 106, 111, 115, // 87640-87647
119, 126, 122, 122, 126, 128, 135, 136, // 87648-87655
145, 127, 129, 164, 167, 160, 156, 144, // 87656-87663
147, 149, 129, 110,  89, 101, 113, 126, // 87664-87671
117, 115, 135, 138, 159, 164, 134, 110, // 87672-87679
111,  93,  82,  76,  84,  90,  90, 101, // 87680-87687
116, 146, 163, 171, 170, 171, 147, 168, // 87688-87695
166, 134, 123, 115, 118, 119, 121, 108, // 87696-87703
111, 127, 149, 151, 155, 140, 144, 140, // 87704-87711
125, 132, 109,  90,  79,  82,  74,  88, // 87712-87719
110, 127, 119, 124, 140, 150, 165, 150, // 87720-87727
136, 135, 125, 123, 145, 128, 124, 141, // 87728-87735
150, 153, 147, 146, 128, 132, 134, 121, // 87736-87743
118, 114, 111, 115, 113, 124, 138, 127, // 87744-87751
118, 108, 109, 107, 116, 123, 103,  90, // 87752-87759
105, 123, 132, 142, 129, 145, 158, 153, // 87760-87767
165, 160, 147, 146, 150, 133, 117, 112, // 87768-87775
109,  98, 114, 115, 121, 141, 142, 145, // 87776-87783
135, 147, 151, 140, 110,  85,  76,  84, // 87784-87791
 87,  99, 102,  89, 119, 147, 159, 160, // 87792-87799
161, 154, 166, 147, 135, 135, 123, 124, // 87800-87807
122, 126, 114, 127, 139, 133, 130, 142, // 87808-87815
138, 145, 144, 125, 109, 110, 132, 120, // 87816-87823
104,  84,  86, 106, 117, 120, 127, 118, // 87824-87831
118, 146, 142, 134, 131, 132, 136, 134, // 87832-87839
122, 133, 143, 149, 149, 144, 143, 136, // 87840-87847
147, 130, 107, 111, 117, 121, 123, 118, // 87848-87855
110, 121, 151, 156, 130, 116, 104, 111, // 87856-87863
117, 100,  99,  98,  96, 112, 130, 126, // 87864-87871
140, 154, 163, 158, 145, 153, 154, 153, // 87872-87879
135, 119, 117, 118, 118, 120, 100, 109, // 87880-87887
135, 145, 148, 140, 138, 128, 149, 149, // 87888-87895
117,  93,  88,  86,  95,  95,  94, 116, // 87896-87903
119, 129, 144, 151, 150, 159, 155, 141, // 87904-87911
122, 125, 136, 129, 129, 116, 128, 141, // 87912-87919
144, 140, 129, 122, 138, 144, 131, 118, // 87920-87927
113, 113, 116, 139, 120, 105, 109, 112, // 87928-87935
114, 116, 116, 122, 126, 112, 117, 124, // 87936-87943
131, 134, 138, 135, 127, 137, 158, 154, // 87944-87951
147, 143, 137, 146, 137, 123, 109, 102, // 87952-87959
113, 122, 125, 117, 126, 137, 136, 149, // 87960-87967
153, 126, 117, 111,  95,  92,  94, 101, // 87968-87975
104, 102, 105, 129, 148, 157, 155, 156, // 87976-87983
152, 141, 156, 144, 125, 120, 119, 120, // 87984-87991
124, 117, 116, 120, 133, 144, 143, 144, // 87992-87999
135, 143, 127, 123, 130, 117,  99,  96, // 88000-88007
 91,  91, 109, 122, 131, 120, 125, 136, // 88008-88015
153, 153, 138, 130, 132, 125, 128, 139, // 88016-88023
122, 131, 138, 144, 141, 140, 135, 128, // 88024-88031
128, 124, 118, 120, 120, 117, 120, 114, // 88032-88039
136, 144, 131, 119, 114, 112, 114, 123, // 88040-88047
116, 102,  95, 113, 125, 135, 133, 130, // 88048-88055
149, 152, 147, 155, 151, 140, 146, 135, // 88056-88063
123, 114, 116, 110, 105, 115, 115, 131, // 88064-88071
143, 143, 140, 137, 144, 155, 135, 104, // 88072-88079
 91,  91,  95,  98, 107, 100, 104, 128, // 88080-88087
147, 149, 153, 150, 152, 157, 132, 129, // 88088-88095
129, 124, 123, 123, 118, 117, 132, 138, // 88096-88103
128, 130, 139, 138, 149, 134, 121, 113, // 88104-88111
121, 133, 124, 104,  92, 105, 117, 122, // 88112-88119
122, 128, 119, 130, 139, 131, 127, 129, // 88120-88127
130, 133, 127, 121, 139, 143, 146, 141, // 88128-88135
140, 137, 137, 137, 119, 110, 117, 122, // 88136-88143
123, 124, 117, 122, 132, 144, 139, 128, // 88144-88151
121, 121, 125, 118, 111, 112, 115, 113, // 88152-88159
121, 123, 124, 132, 137, 138, 136, 134, // 88160-88167
136, 138, 132, 124, 121, 124, 122, 123, // 88168-88175
119, 118, 129, 136, 137, 134, 134, 133, // 88176-88183
135, 135, 129, 122, 120, 120, 121, 123, // 88184-88191
120, 125, 130, 129, 129, 129, 128, 129, // 88192-88199
128, 124, 122, 121, 125, 125, 125, 124, // 88200-88207
125, 130, 132, 128, 128, 126, 129, 132, // 88208-88215
127, 125, 124, 126, 128, 128, 128, 128, // 88216-88223
131, 133, 133, 133, 132, 131, 131, 126, // 88224-88231
122, 120, 121, 121, 120, 121, 122, 128, // 88232-88239
130, 130, 127, 129, 128, 128, 127, 121, // 88240-88247
119, 121, 124, 126, 126, 126, 129, 132, // 88248-88255
134, 133, 133, 132, 132, 131, 128, 127, // 88256-88263
127, 128, 126, 125, 125, 127, 128, 129, // 88264-88271
125, 125, 126, 127, 128, 124, 121, 121, // 88272-88279
124, 124, 124, 122, 122, 126, 129, 131, // 88280-88287
129, 130, 131, 130, 129, 127, 126, 126, // 88288-88295
127, 128, 128, 131, 135, 135, 134, 130, // 88296-88303
131, 130, 127, 124, 120, 118, 119, 122, // 88304-88311
123, 124, 123, 127, 130, 130, 129, 127, // 88312-88319
125, 126, 125, 124, 123, 122, 125, 125, // 88320-88327
127, 128, 131, 133, 133, 134, 132, 134, // 88328-88335
134, 134, 130, 126, 124, 125, 124, 122, // 88336-88343
120, 121, 125, 128, 129, 128, 128, 127, // 88344-88351
129, 126, 122, 121, 121, 123, 123, 124, // 88352-88359
127, 129, 132, 132, 130, 130, 130, 130, // 88360-88367
127, 125, 125, 126, 131, 131, 130, 130, // 88368-88375
132, 133, 133, 128, 125, 124, 124, 123, // 88376-88383
121, 121, 121, 123, 125, 126, 126, 127, // 88384-88391
130, 130, 130, 128, 130, 130, 128, 125, // 88392-88399
123, 123, 125, 127, 125, 125, 129, 132, // 88400-88407
136, 137, 134, 133, 132, 131, 127, 122, // 88408-88415
119, 117, 121, 122, 122, 124, 128, 130, // 88416-88423
131, 131, 129, 129, 128, 125, 123, 122, // 88424-88431
123, 126, 125, 124, 124, 128, 131, 133, // 88432-88439
132, 128, 130, 132, 133, 131, 129, 127, // 88440-88447
128, 128, 127, 124, 123, 124, 125, 128, // 88448-88455
126, 126, 127, 127, 125, 124, 123, 124, // 88456-88463
125, 124, 123, 125, 128, 131, 132, 129, // 88464-88471
128, 128, 130, 128, 126, 123, 124, 128, // 88472-88479
130, 131, 130, 131, 132, 133, 132, 129, // 88480-88487
126, 124, 121, 121, 121, 120, 122, 123, // 88488-88495
123, 124, 128, 130, 131, 129, 127, 127, // 88496-88503
128, 130, 127, 124, 123, 123, 126, 127, // 88504-88511
127, 128, 129, 133, 135, 135, 134, 133, // 88512-88519
131, 129, 127, 124, 122, 120, 119, 120, // 88520-88527
122, 126, 126, 128, 127, 128, 130, 131, // 88528-88535
128, 124, 122, 122, 125, 126, 127, 127, // 88536-88543
127, 128, 131, 131, 130, 130, 129, 129, // 88544-88551
130, 130, 128, 128, 127, 128, 127, 128, // 88552-88559
127, 125, 123, 123, 126, 125, 126, 123, // 88560-88567
122, 122, 124, 126, 126, 123, 124, 127, // 88568-88575
128, 131, 131, 131, 130, 129, 129, 129, // 88576-88583
128, 126, 126, 125, 128, 130, 131, 132, // 88584-88591
131, 131, 130, 131, 128, 124, 120, 118, // 88592-88599
121, 122, 122, 122, 122, 124, 126, 131, // 88600-88607
132, 129, 127, 129, 129, 128, 129, 128, // 88608-88615
126, 125, 125, 127, 128, 129, 129, 129, // 88616-88623
131, 133, 134, 133, 130, 128, 127, 127, // 88624-88631
125, 121, 119, 118, 122, 125, 126, 127, // 88632-88639
127, 127, 128, 127, 129, 127, 124, 123, // 88640-88647
123, 124, 126, 129, 128, 128, 129, 131, // 88648-88655
133, 133, 130, 128, 128, 130, 131, 128, // 88656-88663
126, 125, 126, 128, 129, 126, 125, 123, // 88664-88671
124, 127, 126, 125, 124, 122, 122, 122, // 88672-88679
125, 127, 125, 126, 127, 128, 131, 133, // 88680-88687
133, 129, 127, 128, 129, 128, 126, 125, // 88688-88695
126, 130, 133, 133, 132, 131, 130, 131, // 88696-88703
130, 126, 123, 119, 118, 120, 121, 122, // 88704-88711
124, 124, 125, 126, 130, 132, 130, 128, // 88712-88719
126, 126, 128, 128, 127, 126, 124, 127, // 88720-88727
129, 130, 130, 129, 131, 132, 134, 132, // 88728-88735
130, 127, 126, 125, 126, 124, 122, 121, // 88736-88743
121, 124, 126, 128, 128, 127, 125, 125, // 88744-88751
126, 128, 126, 124, 122, 123, 127, 129, // 88752-88759
130, 131, 129, 130, 132, 131, 130, 127, // 88760-88767
126, 126, 127, 128, 127, 128, 128, 128, // 88768-88775
130, 131, 129, 126, 124, 124, 124, 124, // 88776-88783
124, 123, 122, 122, 124, 128, 129, 128, // 88784-88791
129, 128, 130, 132, 131, 129, 127, 126, // 88792-88799
125, 126, 125, 125, 126, 127, 129, 133, // 88800-88807
133, 132, 132, 129, 128, 127, 124, 121, // 88808-88815
119, 119, 121, 123, 125, 126, 127, 128, // 88816-88823
129, 132, 132, 129, 127, 126, 125, 126, // 88824-88831
127, 126, 126, 126, 128, 129, 131, 130, // 88832-88839
129, 129, 129, 130, 129, 128, 126, 125, // 88840-88847
125, 126, 125, 125, 124, 125, 126, 127, // 88848-88855
128, 127, 126, 125, 124, 124, 126, 125, // 88856-88863
125, 126, 127, 130, 132, 133, 133, 131, // 88864-88871
130, 129, 128, 126, 123, 124, 125, 126, // 88872-88879
128, 128, 129, 129, 130, 130, 129, 127, // 88880-88887
124, 123, 123, 122, 121, 123, 122, 124, // 88888-88895
125, 127, 129, 130, 131, 131, 131, 131, // 88896-88903
131, 130, 129, 126, 125, 124, 125, 126, // 88904-88911
126, 127, 130, 131, 131, 132, 131, 130, // 88912-88919
128, 127, 125, 123, 121, 120, 121, 122, // 88920-88927
124, 126, 127, 127, 127, 127, 129, 128, // 88928-88935
128, 127, 125, 126, 127, 128, 130, 130, // 88936-88943
129, 130, 130, 130, 129, 129, 128, 128, // 88944-88951
128, 127, 126, 126, 125, 127, 126, 125, // 88952-88959
126, 125, 125, 126, 126, 125, 124, 124, // 88960-88967
123, 123, 123, 125, 126, 128, 128, 130, // 88968-88975
132, 132, 133, 134, 132, 129, 127, 127, // 88976-88983
125, 125, 126, 126, 127, 128, 128, 130, // 88984-88991
130, 131, 131, 128, 125, 124, 122, 121, // 88992-88999
121, 121, 121, 122, 125, 125, 127, 129, // 89000-89007
130, 131, 131, 129, 129, 129, 128, 128, // 89008-89015
128, 127, 126, 128, 127, 128, 130, 131, // 89016-89023
131, 130, 129, 128, 128, 128, 127, 124, // 89024-89031
122, 122, 123, 124, 125, 125, 126, 127, // 89032-89039
128, 127, 124, 124, 125, 127, 126, 125, // 89040-89047
126, 127, 130, 131, 132, 132, 131, 131, // 89048-89055
131, 127, 126, 127, 127, 125, 124, 125, // 89056-89063
125, 127, 129, 128, 127, 127, 128, 128, // 89064-89071
126, 124, 124, 124, 124, 124, 122, 123, // 89072-89079
125, 128, 129, 129, 129, 131, 132, 132, // 89080-89087
131, 130, 129, 127, 126, 123, 124, 126, // 89088-89095
129, 128, 127, 128, 129, 130, 131, 129, // 89096-89103
124, 124, 125, 124, 122, 122, 123, 126, // 89104-89111
126, 127, 127, 128, 128, 130, 129, 127, // 89112-89119
127, 128, 128, 127, 128, 129, 129, 129, // 89120-89127
128, 127, 127, 130, 131, 129, 125, 126, // 89128-89135
126, 127, 127, 126, 123, 123, 126, 126, // 89136-89143
126, 125, 128, 128, 128, 127, 125, 125, // 89144-89151
125, 124, 126, 126, 126, 129, 129, 130, // 89152-89159
131, 133, 134, 132, 129, 125, 124, 126, // 89160-89167
127, 125, 122, 122, 125, 127, 129, 131, // 89168-89175
130, 129, 128, 129, 126, 124, 124, 123, // 89176-89183
122, 122, 122, 124, 125, 126, 128, 130, // 89184-89191
131, 132, 131, 131, 129, 131, 132, 128, // 89192-89199
126, 124, 123, 125, 126, 128, 127, 127, // 89200-89207
128, 129, 130, 129, 129, 126, 123, 124, // 89208-89215
125, 123, 126, 126, 126, 127, 129, 129, // 89216-89223
128, 126, 125, 127, 127, 126, 125, 126, // 89224-89231
127, 129, 133, 131, 129, 130, 128, 127, // 89232-89239
128, 126, 126, 124, 124, 123, 125, 126, // 89240-89247
127, 127, 126, 126, 129, 130, 129, 129, // 89248-89255
127, 126, 127, 126, 124, 122, 123, 125, // 89256-89263
127, 129, 128, 129, 132, 131, 133, 133, // 89264-89271
129, 128, 125, 122, 122, 124, 124, 124, // 89272-89279
125, 125, 128, 131, 131, 130, 128, 127, // 89280-89287
128, 127, 125, 124, 125, 125, 126, 126, // 89288-89295
126, 126, 127, 129, 129, 130, 129, 128, // 89296-89303
129, 128, 127, 128, 127, 126, 125, 124, // 89304-89311
125, 128, 129, 128, 127, 127, 127, 129, // 89312-89319
129, 126, 124, 124, 125, 126, 126, 126, // 89320-89327
128, 129, 130, 129, 128, 127, 126, 126, // 89328-89335
126, 125, 127, 127, 127, 128, 129, 132, // 89336-89343
132, 131, 127, 126, 126, 126, 127, 124, // 89344-89351
122, 123, 125, 126, 128, 128, 128, 128, // 89352-89359
130, 129, 128, 128, 127, 126, 126, 125, // 89360-89367
124, 124, 123, 124, 126, 128, 130, 131, // 89368-89375
130, 130, 131, 132, 131, 128, 125, 123, // 89376-89383
123, 125, 125, 126, 125, 127, 128, 130, // 89384-89391
130, 129, 129, 128, 128, 126, 125, 124, // 89392-89399
124, 124, 125, 125, 126, 127, 127, 127, // 89400-89407
127, 129, 129, 129, 127, 126, 127, 129, // 89408-89415
129, 127, 127, 125, 126, 128, 129, 127, // 89416-89423
127, 127, 127, 128, 127, 126, 126, 127, // 89424-89431
126, 127, 127, 128, 129, 128, 127, 127, // 89432-89439
127, 125, 125, 123, 123, 124, 127, 127, // 89440-89447
128, 128, 129, 132, 133, 132, 129, 128, // 89448-89455
126, 125, 125, 123, 122, 125, 125, 125, // 89456-89463
128, 129, 130, 131, 131, 129, 129, 128, // 89464-89471
127, 125, 124, 124, 124, 125, 123, 124, // 89472-89479
125, 127, 129, 131, 129, 129, 129, 129, // 89480-89487
129, 128, 127, 125, 125, 124, 125, 126, // 89488-89495
127, 127, 128, 128, 128, 129, 128, 127, // 89496-89503
127, 126, 125, 126, 126, 125, 127, 127, // 89504-89511
128, 128, 128, 126, 127, 125, 126, 126, // 89512-89519
126, 126, 128, 128, 128, 129, 131, 130, // 89520-89527
129, 128, 126, 127, 127, 126, 125, 124, // 89528-89535
124, 126, 128, 126, 128, 129, 130, 130, // 89536-89543
130, 128, 127, 127, 125, 124, 123, 123, // 89544-89551
123, 124, 124, 126, 128, 129, 131, 130, // 89552-89559
130, 129, 131, 130, 126, 124, 124, 124, // 89560-89567
125, 125, 125, 126, 128, 130, 131, 130, // 89568-89575
129, 130, 129, 127, 126, 126, 125, 125, // 89576-89583
125, 124, 125, 126, 127, 127, 126, 127, // 89584-89591
129, 129, 128, 126, 125, 126, 128, 128, // 89592-89599
126, 126, 128, 129, 129, 128, 128, 128, // 89600-89607
128, 128, 127, 125, 125, 127, 127, 127, // 89608-89615
126, 129, 130, 129, 127, 127, 126, 127, // 89616-89623
126, 124, 122, 122, 125, 127, 127, 127, // 89624-89631
127, 129, 131, 131, 129, 128, 128, 128, // 89632-89639
126, 125, 125, 126, 126, 127, 127, 128, // 89640-89647
129, 130, 131, 129, 128, 129, 129, 127, // 89648-89655
123, 123, 123, 124, 124, 124, 124, 125, // 89656-89663
128, 130, 128, 128, 128, 128, 128, 126, // 89664-89671
125, 125, 126, 126, 127, 127, 128, 130, // 89672-89679
130, 129, 128, 129, 128, 128, 127, 125, // 89680-89687
124, 126, 128, 127, 125, 125, 128, 128, // 89688-89695
129, 127, 126, 125, 126, 126, 124, 123, // 89696-89703
125, 126, 125, 126, 127, 129, 131, 131, // 89704-89711
130, 128, 130, 130, 129, 126, 124, 125, // 89712-89719
127, 126, 127, 126, 127, 129, 131, 130, // 89720-89727
127, 127, 127, 126, 125, 124, 123, 124, // 89728-89735
124, 126, 127, 126, 129, 129, 129, 127, // 89736-89743
127, 129, 129, 126, 127, 125, 126, 128, // 89744-89751
128, 127, 127, 129, 130, 129, 129, 129, // 89752-89759
128, 127, 128, 126, 124, 124, 126, 125, // 89760-89767
125, 126, 127, 128, 128, 127, 127, 128, // 89768-89775
128, 127, 125, 123, 124, 126, 128, 127, // 89776-89783
127, 129, 129, 131, 131, 129, 129, 128, // 89784-89791
128, 126, 125, 126, 127, 127, 128, 128, // 89792-89799
128, 128, 128, 128, 125, 126, 127, 126, // 89800-89807
125, 124, 124, 125, 127, 127, 125, 125, // 89808-89815
126, 128, 129, 128, 128, 128, 128, 129, // 89816-89823
128, 128, 127, 128, 128, 127, 127, 129, // 89824-89831
130, 129, 128, 127, 128, 128, 126, 125, // 89832-89839
124, 124, 125, 127, 126, 126, 127, 128, // 89840-89847
129, 128, 127, 126, 126, 125, 126, 126, // 89848-89855
125, 126, 127, 128, 128, 129, 130, 129, // 89856-89863
129, 129, 128, 128, 128, 127, 126, 126, // 89864-89871
126, 126, 126, 126, 126, 126, 127, 128, // 89872-89879
128, 128, 127, 127, 127, 127, 125, 125, // 89880-89887
123, 125, 124, 127, 128, 129, 129, 130, // 89888-89895
130, 129, 129, 129, 127, 126, 126, 126, // 89896-89903
127, 128, 128, 128, 128, 129, 129, 129, // 89904-89911
127, 127, 126, 126, 126, 126, 125, 125, // 89912-89919
126, 127, 126, 127, 126, 127, 127, 128, // 89920-89927
128, 128, 127, 127, 127, 127, 126, 127, // 89928-89935
127, 127, 127, 128, 129, 130, 130, 129, // 89936-89943
128, 127, 127, 126, 125, 124, 124, 125, // 89944-89951
126, 127, 128, 128, 129, 129, 128, 127, // 89952-89959
127, 125, 125, 125, 125, 126, 126, 127, // 89960-89967
128, 128, 129, 130, 131, 129, 128, 128, // 89968-89975
128, 128, 127, 128, 126, 126, 126, 126, // 89976-89983
126, 126, 127, 127, 128, 128, 129, 127, // 89984-89991
127, 126, 125, 124, 124, 125, 125, 124, // 89992-89999
126, 128, 129, 130, 130, 129, 130, 128, // 90000-90007
153, 167, 146, 111,  91,  79,  94,  69, // 90008-90015
 45,  65, 137, 222, 235, 248, 205, 252, // 90016-90023
202, 117, 128,  97,  14,   8, 247, 150, // 90024-90031
  3, 120, 190, 154, 186, 236,  32,  50, // 90032-90039
202, 150, 108,  80, 108, 117, 224, 229, // 90040-90047
 21,  61,  66,  87,  84,  75, 179, 147, // 90048-90055
 95,  65,  67,  54,  87,  35,  84, 192, // 90056-90063
167, 161, 150, 160, 158, 224, 207, 126, // 90064-90071
 73, 151, 182, 236, 197,  91, 210,   8, // 90072-90079
 70,  92,  25, 187, 198, 163,  83,  30, // 90080-90087
 27,   3, 215,  32,  26,  92, 153, 172, // 90088-90095
164, 156, 128, 219, 240,  57, 219, 162, // 90096-90103
183, 182, 248, 219, 212,  95, 208, 255, // 90104-90111
 29,  20,  16,  55, 246, 243, 176, 116, // 90112-90119
 79,  97,  39, 242, 127, 203, 194, 217, // 90120-90127
 35,  17,  69,  16, 178, 119,  82, 108, // 90128-90135
 91,  13, 189, 232,  29,  61,  62,  98, // 90136-90143
 20, 110, 224, 130,  90,  54,  55,  50, // 90144-90151
 63,  62, 115, 119, 133, 134, 149, 155, // 90152-90159
169, 241, 151,  98, 143, 185, 190, 230, // 90160-90167
129, 105, 199,  26,  78, 255, 206, 157, // 90168-90175
186, 139,  68,  47,  13, 228,  44,  75, // 90176-90183
 53, 122, 149, 171, 143, 166, 162, 200, // 90184-90191
151,  18, 206, 191, 199, 232,   4, 190, // 90192-90199
 50, 172, 233,   5,  10, 255, 255,  29, // 90200-90207
  5, 181, 106,  92,  70, 107,   9,  42, // 90208-90215
157, 166, 224,  30,  38,  25,  50, 231, // 90216-90223
152, 100, 127,  82,  31, 236, 196,  13, // 90224-90231
 53,  78,  92,  58,  52, 220, 209, 123, // 90232-90239
 74,  51,  46,  40,  97,  63,  68, 100, // 90240-90247
125, 136, 161, 152, 208, 190, 129, 160, // 90248-90255
178, 194, 196, 202,  98, 122, 246,  46, // 90256-90263
247, 207, 174, 157, 188, 117,  87,  25, // 90264-90271
255,  45,  98,  78,  74, 121, 152, 139, // 90272-90279
157, 174, 116, 168,  95, 254, 218, 208, // 90280-90287
234, 250, 230,   9, 132, 197, 246, 244, // 90288-90295
  6, 224,  11,  43, 194, 116,  95,  78, // 90296-90303
 96,  90,  18,  91, 135, 214,  21,  40, // 90304-90311
 24,   8,  21, 181, 127, 127,  91,  18, // 90312-90319
 15, 215, 231,  33,  74,  90,  64,  74, // 90320-90327
146, 250, 184, 107,  67,  56,  39, 100, // 90328-90335
 82,  15,  69, 101, 136, 147, 167, 170, // 90336-90343
181, 175, 184, 180, 192, 179, 192, 161, // 90344-90351
 68, 179, 249, 225, 195, 183, 154, 168, // 90352-90359
170, 120,  53,  17,  69,  89, 115,  74, // 90360-90367
 86, 132, 137, 157, 178, 106, 107, 154, // 90368-90375
 62,   9, 226, 252, 237, 249,  35,  79, // 90376-90383
162, 209, 227, 236, 224, 220,  36, 218, // 90384-90391
131,  96,  87,  87, 105,  80,  30,  92, // 90392-90399
186,  11,  24,  35, 246,   9, 235, 162, // 90400-90407
150,  93,  36,  13,  11, 231,   6,  64, // 90408-90415
 92,  63,  99, 127, 196, 243, 144,  95, // 90416-90423
 54,  47,  78,  89,  14,  16,  73, 117, // 90424-90431
138, 155, 174, 142, 196, 218, 197, 189, // 90432-90439
184, 174, 188, 114, 116, 197, 189, 194, // 90440-90447
175, 177, 152, 178, 169,  86,  48,  84, // 90448-90455
 97, 109, 107,  64,  97, 116, 153, 161, // 90456-90463
116,  72, 122, 131,  51,   5,   2, 248, // 90464-90471
238,  65,  73, 116, 177, 207, 223, 215, // 90472-90479
224, 246, 233, 160, 114,  92,  99,  94, // 90480-90487
125,  52,  34, 157, 235,  15,  15,   1, // 90488-90495
229, 238, 201, 170, 100,  47,  20,  17, // 90496-90503
 16, 239,  41,  78,  68, 101, 145, 148, // 90504-90511
228, 205, 128,  79,  54,  88,  68,  45, // 90512-90519
  4,  37,  98, 130, 151, 172, 139, 170, // 90520-90527
242, 216, 194, 174, 170, 164, 156, 115, // 90528-90535
127, 153, 172, 174, 173, 167, 154, 190, // 90536-90543
124,  82,  98, 107, 108, 113,  95,  71, // 90544-90551
 96, 146, 157, 113,  88,  79, 143, 114, // 90552-90559
 46,  28, 251, 250,  55,  98,  89, 135, // 90560-90567
174, 204, 195, 221, 224, 196, 186, 132, // 90568-90575
102,  98,  97, 118, 101,  26, 111, 206, // 90576-90583
252,  11, 254, 241, 209, 233, 202, 121, // 90584-90591
 58,  39,  21,  40,  17,  20,  64,  64, // 90592-90599
106, 145, 151, 170, 218, 169,  97,  66, // 90600-90607
 86,  58,  33,  30,   5,  66, 107, 145, // 90608-90615
156, 143, 155, 222, 243, 208, 179, 171, // 90616-90623
159, 157, 165,  99, 110, 149, 168, 175, // 90624-90631
175, 165, 169, 156, 117, 122, 113, 118, // 90632-90639
105, 113,  81,  66, 130, 144, 108,  93, // 90640-90647
 73,  98, 145,  93,  57,   6,   6,  56, // 90648-90655
 96, 108, 101, 146, 180, 187, 210, 226, // 90656-90663
170, 175, 161, 121, 108, 103, 117, 111, // 90664-90671
 72,  77, 163, 221, 252, 241, 240, 201, // 90672-90679
214, 233, 140,  78,  47,  35,  35,  45, // 90680-90687
 32,  34,  56, 108, 143, 155, 153, 178, // 90688-90695
206, 131,  93,  92,  65,  29,  39,  27, // 90696-90703
 36,  89, 132, 151, 134, 166, 194, 236, // 90704-90711
233, 187, 170, 155, 150, 180, 124,  67, // 90712-90719
115, 143, 169, 166, 176, 162, 144, 155, // 90720-90727
145, 129, 122, 113, 106, 106,  68, 108, // 90728-90735
133, 105,  94,  85,  82, 122, 139,  91, // 90736-90743
 30,  16,  66,  84, 116, 105, 110, 153, // 90744-90751
168, 203, 210, 171, 146, 163, 146, 118, // 90752-90759
110, 119, 103, 101, 102, 119, 188, 225, // 90760-90767
235, 228, 212, 202, 225, 172, 102,  66, // 90768-90775
 49,  48,  47,  66,  26,  34, 102, 138, // 90776-90783
152, 155, 149, 187, 171, 120, 108,  62, // 90784-90791
 36,  26,  45,  39,  58, 116, 137, 130, // 90792-90799
165, 196, 205, 240, 206, 176, 155, 152, // 90800-90807
175, 149,  77,  76, 123, 155, 168, 173, // 90808-90815
172, 130, 162, 176, 147, 131, 116, 107, // 90816-90823
101,  94,  93, 105,  94,  91,  86,  88, // 90824-90831
 95, 139, 132,  60,  43,  72,  91, 104, // 90832-90839
120, 102, 120, 150, 193, 197, 167, 148, // 90840-90847
142, 164, 140, 121, 122, 102, 104, 132, // 90848-90855
116, 145, 193, 214, 219, 203, 213, 198, // 90856-90863
176, 130,  85,  63,  59,  53,  71,  53, // 90864-90871
 24,  91, 132, 150, 155, 147, 156, 176, // 90872-90879
161, 129,  75,  43,  36,  39,  61,  49, // 90880-90887
 90, 117, 123, 158, 192, 196, 208, 219, // 90888-90895
187, 158, 152, 167, 144, 102,  65,  88, // 90896-90903
136, 157, 172, 171, 142, 151, 195, 175, // 90904-90911
147, 123, 115,  99, 104, 115,  84,  83, // 90912-90919
 89,  90,  95,  94, 116, 145,  94,  67, // 90920-90927
 81,  89,  98, 106, 115,  99, 125, 174, // 90928-90935
182, 154, 148, 134, 148, 160, 133, 128, // 90936-90943
104, 107, 142, 140, 126, 159, 194, 210, // 90944-90951
201, 216, 204, 160, 156, 114,  84,  71, // 90952-90959
 67,  70,  64,  44,  69, 119, 137, 146, // 90960-90967
142, 144, 152, 179, 152,  87,  50,  43, // 90968-90975
 42,  58,  63,  67,  96, 110, 154, 181, // 90976-90983
196, 192, 204, 208, 167, 161, 169, 145, // 90984-90991
119,  92,  73, 114, 143, 167, 163, 146, // 90992-90999
155, 179, 193, 161, 133, 121, 108, 102, // 91000-91007
126,  88,  60,  80,  85,  96,  93, 103, // 91008-91015
127, 120,  99,  99,  93, 102,  99, 115, // 91016-91023
109, 101, 154, 166, 150, 144, 142, 136, // 91024-91031
156, 157, 137, 111, 110, 143, 148, 134, // 91032-91039
126, 164, 191, 194, 207, 203, 154, 144, // 91040-91047
138, 104,  86,  72,  80,  64,  70,  79, // 91048-91055
 99, 130, 139, 144, 141, 136, 168, 176, // 91056-91063
110,  69,  50,  52,  57,  72,  76,  69, // 91064-91071
 96, 143, 173, 182, 187, 178, 204, 185, // 91072-91079
168, 169, 137, 123, 109,  86,  90, 124, // 91080-91087
156, 162, 146, 166, 172, 186, 185, 148, // 91088-91095
132, 112, 111, 124, 107,  60,  66,  84, // 91096-91103
 94,  97,  99, 109, 113, 126, 115, 101, // 91104-91111
 97,  99, 106, 115, 102, 125, 143, 135, // 91112-91119
138, 135, 137, 136, 163, 153, 118, 122, // 91120-91127
144, 159, 154, 133, 140, 171, 185, 207, // 91128-91135
194, 160, 138, 143, 133, 101,  87,  85, // 91136-91143
 69,  73, 101,  89, 113, 130, 137, 140, // 91144-91151
127, 150, 168, 132,  85,  61,  54,  62, // 91152-91159
 68,  88,  66,  77, 134, 163, 177, 181, // 91160-91167
178, 181, 193, 181, 172, 139, 121, 118, // 91168-91175
103,  90, 100, 141, 151, 146, 165, 176, // 91176-91183
172, 187, 168, 140, 119, 115, 124, 104, // 91184-91191
 81,  55,  73,  90,  98, 105, 101, 103, // 91192-91199
135, 144, 118, 108, 102, 108, 109, 117, // 91200-91207
118, 120, 125, 131, 133, 137, 133, 145, // 91208-91215
164, 128, 128, 142, 152, 158, 141, 129, // 91216-91223
141, 168, 197, 189, 158, 143, 130, 142, // 91224-91231
123, 101,  93,  73,  79, 108, 109, 100, // 91232-91239
123, 133, 140, 131, 144, 155, 139, 111, // 91240-91247
 77,  63,  62,  70,  84,  79,  69, 116, // 91248-91255
151, 169, 175, 175, 170, 172, 195, 173, // 91256-91263
140, 117, 116, 111, 102,  94, 119, 139, // 91264-91271
145, 169, 180, 177, 174, 181, 156, 129, // 91272-91279
122, 125, 102,  90,  73,  60,  87,  94, // 91280-91287
110, 101,  97, 128, 152, 139, 116, 104, // 91288-91295
103, 102, 114, 129, 103, 108, 122, 130, // 91296-91303
135, 137, 138, 150, 144, 137, 151, 148, // 91304-91311
159, 150, 139, 131, 149, 185, 181, 158, // 91312-91319
146, 131, 130, 137, 116, 101,  77,  84, // 91320-91327
107, 119, 112, 106, 127, 131, 135, 140, // 91328-91335
141, 128, 121,  95,  73,  67,  71,  82, // 91336-91343
 81,  87, 105, 141, 162, 174, 173, 173, // 91344-91351
162, 187, 186, 141, 125, 112, 116, 109, // 91352-91359
103, 107, 120, 138, 167, 177, 178, 168, // 91360-91367
166, 169, 137, 130, 124, 102,  87,  87, // 91368-91375
 69,  73,  93, 105, 106,  95, 125, 145, // 91376-91383
152, 134, 115, 108, 104, 112, 129, 110, // 91384-91391
 90, 109, 119, 133, 135, 142, 136, 143, // 91392-91399
156, 155, 153, 151, 153, 140, 130, 131, // 91400-91407
161, 166, 156, 148, 138, 131, 133, 139, // 91408-91415
116,  91,  92, 110, 116, 125, 108, 111, // 91416-91423
123, 129, 145, 131, 123, 119, 112,  93, // 91424-91431
 80,  76,  81,  75,  91, 109, 119, 149, // 91432-91439
161, 168, 167, 162, 169, 183, 155, 130, // 91440-91447
116, 112, 117, 108, 112, 105, 127, 161, // 91448-91455
177, 182, 178, 164, 166, 156, 141, 131, // 91456-91463
101,  89,  84,  83,  71,  82, 100, 103, // 91464-91471
101, 119, 142, 151, 151, 127, 113, 101, // 91472-91479
108, 118, 111,  93,  91, 109, 125, 132, // 91480-91487
139, 139, 133, 163, 165, 162, 157, 153, // 91488-91495
151, 134, 134, 144, 150, 147, 145, 136, // 91496-91503
135, 128, 139, 131, 103, 104, 113, 118, // 91504-91511
122, 117, 101, 110, 118, 138, 127, 116, // 91512-91519
119, 113, 111,  93,  86,  84,  80,  92, // 91520-91527
116, 117, 132, 150, 161, 163, 161, 171, // 91528-91535
168, 163, 142, 126, 117, 121, 118, 113, // 91536-91543
105, 112, 149, 165, 176, 171, 164, 154, // 91544-91551
157, 154, 135, 109,  97,  87,  86,  84, // 91552-91559
 73,  93,  94, 103, 116, 133, 148, 150, // 91560-91567
144, 124, 110, 111, 118, 107, 105,  89, // 91568-91575
100, 118, 130, 139, 138, 133, 153, 174, // 91576-91583
165, 161, 148, 152, 136, 133, 138, 132, // 91584-91591
140, 141, 138, 137, 131, 131, 139, 116, // 91592-91599
114, 115, 119, 121, 121, 115, 101, 115, // 91600-91607
129, 127, 109, 116, 114, 117, 110,  96, // 91608-91615
 91,  83,  96, 114, 123, 122, 137, 150, // 91616-91623
155, 153, 166, 158, 152, 154, 131, 125, // 91624-91631
118, 127, 117, 108, 110, 134, 157, 171, // 91632-91639
171, 166, 159, 149, 164, 143, 115,  99, // 91640-91647
 93,  87,  91,  84,  85,  94, 102, 123, // 91648-91655
125, 145, 146, 147, 134, 111, 112, 114, // 91656-91663
105, 102,  99,  91, 111, 124, 140, 134, // 91664-91671
136, 148, 165, 173, 161, 153, 148, 144, // 91672-91679
134, 140, 123, 127, 137, 138, 138, 135, // 91680-91687
136, 132, 130, 124, 122, 118, 123, 117, // 91688-91695
120, 103, 104, 125, 122, 115, 109, 118, // 91696-91703
116, 117, 109,  96,  84,  97, 111, 121, // 91704-91711
127, 124, 144, 150, 156, 163, 159, 143, // 91712-91719
149, 142, 128, 120, 122, 127, 106, 116, // 91720-91727
127, 146, 164, 168, 163, 157, 147, 155, // 91728-91735
152, 121, 106,  93,  94,  89,  94,  88, // 91736-91743
 85, 100, 122, 127, 133, 148, 144, 145, // 91744-91751
124, 119, 115, 105, 101, 102,  99,  99, // 91752-91759
118, 134, 136, 132, 150, 153, 170, 165, // 91760-91767
154, 144, 139, 141, 133, 126, 117, 129, // 91768-91775
135, 138, 134, 139, 129, 127, 137, 129, // 91776-91783
123, 122, 123, 120, 116, 106, 119, 118, // 91784-91791
116, 109, 110, 121, 117, 124, 108,  92, // 91792-91799
100, 114, 119, 129, 124, 128, 139, 145, // 91800-91807
157, 150, 143, 138, 145, 137, 126, 124, // 91808-91815
129, 114, 112, 128, 131, 153, 161, 162, // 91816-91823
154, 150, 150, 150, 133, 113, 101,  98, // 91824-91831
 96,  99, 103,  86,  98, 120, 129, 130, // 91832-91839
140, 145, 138, 133, 123, 116, 102, 102, // 91840-91847
101, 106, 101, 110, 130, 130, 132, 147, // 91848-91855
153, 157, 168, 158, 148, 137, 146, 136, // 91856-91863
120, 116, 115, 129, 135, 137, 140, 134, // 91864-91871
124, 142, 141, 130, 126, 122, 119, 113, // 91872-91879
113, 109, 109, 110, 111, 108, 117, 119, // 91880-91887
122, 119, 106, 110, 117, 123, 127, 132, // 91888-91895
127, 130, 137, 142, 138, 135, 132, 132, // 91896-91903
137, 132, 133, 134, 131, 127, 132, 133, // 91904-91911
136, 142, 141, 137, 132, 132, 129, 128, // 91912-91919
123, 119, 118, 117, 118, 120, 117, 115, // 91920-91927
123, 125, 124, 124, 128, 127, 126, 126, // 91928-91935
122, 121, 122, 123, 124, 125, 124, 129, // 91936-91943
129, 128, 130, 133, 133, 136, 137, 134, // 91944-91951
132, 133, 133, 128, 127, 127, 127, 128, // 91952-91959
127, 126, 125, 124, 127, 129, 127, 128, // 91960-91967
130, 130, 127, 126, 124, 122, 122, 121, // 91968-91975
118, 120, 122, 124, 126, 125, 126, 129, // 91976-91983
130, 131, 132, 132, 130, 130, 128, 124, // 91984-91991
125, 125, 126, 128, 128, 129, 131, 132, // 91992-91999
130, 131, 130, 129, 130, 129, 126, 124, // 92000-92007
125, 124, 124, 124, 126, 127, 128, 127, // 92008-92015
127, 127, 124, 125, 124, 121, 120, 124, // 92016-92023
125, 125, 125, 124, 125, 129, 131, 131, // 92024-92031
131, 129, 130, 129, 127, 125, 127, 126, // 92032-92039
126, 130, 130, 131, 133, 134, 131, 131, // 92040-92047
131, 131, 129, 127, 125, 124, 124, 123, // 92048-92055
125, 123, 124, 127, 129, 128, 128, 126, // 92056-92063
123, 124, 124, 122, 122, 124, 124, 125, // 92064-92071
124, 124, 128, 129, 129, 130, 132, 130, // 92072-92079
131, 131, 127, 125, 128, 127, 127, 128, // 92080-92087
127, 131, 133, 133, 131, 131, 129, 130, // 92088-92095
131, 129, 126, 124, 122, 120, 123, 123, // 92096-92103
124, 127, 127, 126, 127, 126, 125, 126, // 92104-92111
123, 122, 123, 125, 124, 126, 126, 125, // 92112-92119
128, 131, 131, 132, 132, 131, 132, 129, // 92120-92127
128, 127, 126, 127, 128, 130, 128, 130, // 92128-92135
132, 130, 128, 131, 129, 129, 128, 125, // 92136-92143
124, 122, 122, 120, 122, 122, 124, 127, // 92144-92151
128, 127, 130, 128, 126, 128, 125, 124, // 92152-92159
123, 125, 124, 124, 124, 125, 127, 128, // 92160-92167
130, 133, 134, 131, 131, 130, 127, 127, // 92168-92175
128, 125, 126, 127, 127, 129, 130, 131, // 92176-92183
129, 129, 129, 130, 129, 127, 126, 126, // 92184-92191
123, 124, 126, 126, 126, 127, 127, 127, // 92192-92199
127, 125, 124, 124, 123, 123, 125, 125, // 92200-92207
124, 126, 125, 127, 128, 130, 130, 131, // 92208-92215
131, 129, 128, 127, 126, 124, 125, 126, // 92216-92223
128, 128, 129, 131, 132, 131, 131, 130, // 92224-92231
129, 129, 129, 127, 124, 123, 122, 122, // 92232-92239
123, 124, 126, 127, 128, 128, 129, 127, // 92240-92247
127, 126, 125, 123, 124, 126, 125, 125, // 92248-92255
124, 124, 126, 128, 130, 131, 131, 130, // 92256-92263
131, 131, 129, 129, 128, 128, 129, 129, // 92264-92271
129, 128, 128, 127, 126, 127, 128, 128, // 92272-92279
128, 126, 126, 126, 124, 125, 125, 125, // 92280-92287
126, 127, 126, 125, 124, 124, 123, 125, // 92288-92295
124, 124, 125, 127, 127, 127, 126, 128, // 92296-92303
129, 129, 130, 130, 129, 128, 127, 128, // 92304-92311
126, 126, 127, 128, 128, 129, 130, 132, // 92312-92319
130, 130, 128, 128, 129, 129, 128, 126, // 92320-92327
124, 123, 123, 122, 124, 125, 125, 126, // 92328-92335
127, 127, 127, 127, 127, 126, 126, 126, // 92336-92343
125, 126, 125, 124, 125, 124, 126, 127, // 92344-92351
127, 129, 129, 128, 128, 129, 129, 129, // 92352-92359
129, 131, 129, 130, 129, 128, 129, 127, // 92360-92367
126, 127, 126, 127, 127, 127, 127, 125, // 92368-92375
128, 127, 128, 127, 125, 125, 124, 124, // 92376-92383
123, 123, 122, 123, 123, 125, 127, 129, // 92384-92391
127, 126, 128, 127, 128, 129, 129, 127, // 92392-92399
128, 127, 128, 129, 127, 129, 130, 130, // 92400-92407
131, 132, 131, 130, 131, 130, 128, 129, // 92408-92415
127, 126, 126, 125, 125, 125, 124, 124, // 92416-92423
125, 125, 126, 125, 126, 123, 123, 125, // 92424-92431
124, 125, 125, 125, 126, 128, 128, 127, // 92432-92439
126, 127, 128, 129, 130, 128, 129, 128, // 92440-92447
129, 131, 131, 130, 132, 129, 129, 128, // 92448-92455
128, 128, 127, 125, 124, 126, 128, 128, // 92456-92463
127, 126, 124, 126, 127, 126, 127, 124, // 92464-92471
123, 124, 125, 123, 123, 123, 123, 125, // 92472-92479
126, 126, 128, 129, 127, 129, 130, 130, // 92480-92487
130, 128, 126, 127, 127, 128, 128, 126, // 92488-92495
126, 127, 131, 132, 131, 130, 129, 129, // 92496-92503
130, 128, 126, 125, 125, 126, 125, 126, // 92504-92511
125, 125, 125, 126, 127, 127, 126, 127, // 92512-92519
126, 125, 127, 127, 126, 125, 123, 124, // 92520-92527
127, 128, 127, 125, 125, 126, 129, 130, // 92528-92535
128, 128, 127, 128, 130, 130, 129, 129, // 92536-92543
129, 128, 128, 129, 129, 128, 127, 125, // 92544-92551
126, 129, 128, 127, 127, 126, 128, 129, // 92552-92559
129, 126, 124, 125, 126, 126, 124, 121, // 92560-92567
121, 122, 125, 126, 126, 126, 128, 129, // 92568-92575
128, 129, 129, 128, 126, 127, 126, 126, // 92576-92583
127, 127, 126, 125, 127, 131, 132, 131, // 92584-92591
131, 131, 132, 132, 131, 127, 124, 126, // 92592-92599
126, 126, 125, 124, 123, 124, 126, 128, // 92600-92607
127, 127, 127, 127, 126, 126, 128, 125, // 92608-92615
123, 123, 123, 124, 126, 127, 125, 125, // 92616-92623
127, 130, 131, 129, 128, 128, 129, 130, // 92624-92631
129, 128, 126, 127, 129, 129, 129, 128, // 92632-92639
128, 127, 127, 128, 128, 128, 127, 126, // 92640-92647
126, 126, 128, 129, 127, 125, 125, 126, // 92648-92655
127, 126, 124, 123, 124, 126, 127, 126, // 92656-92663
126, 127, 129, 130, 129, 129, 128, 128, // 92664-92671
127, 127, 126, 124, 126, 125, 125, 126, // 92672-92679
128, 129, 130, 131, 131, 131, 132, 132, // 92680-92687
129, 125, 125, 125, 126, 124, 124, 125, // 92688-92695
125, 129, 130, 129, 128, 128, 129, 128, // 92696-92703
126, 125, 123, 123, 124, 124, 123, 123, // 92704-92711
125, 127, 126, 126, 128, 129, 129, 128, // 92712-92719
127, 127, 128, 129, 127, 125, 126, 127, // 92720-92727
128, 129, 128, 129, 128, 129, 130, 128, // 92728-92735
127, 128, 129, 127, 126, 128, 127, 127, // 92736-92743
127, 126, 125, 125, 126, 125, 123, 122, // 92744-92751
123, 125, 125, 125, 126, 127, 129, 131, // 92752-92759
131, 128, 128, 128, 127, 126, 125, 125, // 92760-92767
126, 127, 128, 127, 129, 129, 131, 132, // 92768-92775
130, 130, 130, 129, 127, 126, 124, 124, // 92776-92783
125, 124, 124, 124, 126, 127, 127, 128, // 92784-92791
127, 128, 127, 127, 127, 125, 124, 125, // 92792-92799
125, 125, 125, 126, 127, 128, 129, 128, // 92800-92807
129, 129, 128, 128, 127, 127, 127, 128, // 92808-92815
127, 128, 128, 127, 129, 130, 128, 127, // 92816-92823
128, 127, 127, 127, 126, 126, 127, 126, // 92824-92831
127, 128, 128, 128, 127, 126, 125, 125, // 92832-92839
125, 124, 126, 124, 123, 126, 127, 128, // 92840-92847
128, 128, 129, 130, 129, 128, 128, 127, // 92848-92855
125, 126, 126, 125, 127, 127, 127, 129, // 92856-92863
130, 130, 131, 131, 129, 129, 128, 128, // 92864-92871
128, 127, 123, 123, 125, 125, 126, 127, // 92872-92879
127, 127, 128, 128, 127, 127, 126, 125, // 92880-92887
126, 125, 124, 125, 124, 125, 126, 126, // 92888-92895
127, 128, 128, 127, 128, 129, 129, 129, // 92896-92903
128, 128, 129, 129, 129, 130, 129, 127, // 92904-92911
129, 129, 128, 127, 127, 126, 127, 127, // 92912-92919
127, 127, 127, 127, 127, 128, 126, 127, // 92920-92927
126, 125, 125, 125, 124, 124, 125, 124, // 92928-92935
124, 125, 128, 128, 127, 127, 127, 128, // 92936-92943
129, 129, 128, 127, 126, 129, 129, 128, // 92944-92951
129, 128, 129, 130, 130, 129, 129, 129, // 92952-92959
129, 128, 128, 128, 128, 126, 125, 126, // 92960-92967
125, 125, 125, 125, 124, 124, 127, 126, // 92968-92975
126, 125, 125, 126, 127, 126, 125, 124, // 92976-92983
125, 126, 126, 126, 126, 128, 128, 129, // 92984-92991
130, 130, 129, 130, 130, 128, 129, 129, // 92992-92999
130, 129, 128, 127, 128, 129, 129, 127, // 93000-93007
126, 126, 128, 128, 127, 125, 125, 126, // 93008-93015
127, 127, 126, 124, 125, 126, 126, 124, // 93016-93023
125, 125, 127, 125, 125, 126, 127, 128, // 93024-93031
128, 127, 128, 129, 130, 129, 128, 127, // 93032-93039
127, 128, 128, 127, 127, 128, 130, 131, // 93040-93047
130, 128, 128, 129, 130, 129, 126, 127, // 93048-93055
125, 126, 124, 124, 124, 125, 127, 126, // 93056-93063
125, 126, 127, 128, 127, 125, 125, 125, // 93064-93071
126, 126, 123, 123, 126, 127, 127, 126, // 93072-93079
127, 129, 130, 130, 130, 127, 128, 129, // 93080-93087
130, 128, 128, 128, 129, 129, 128, 126, // 93088-93095
127, 128, 128, 127, 126, 127, 127, 128, // 93096-93103
126, 125, 125, 127, 127, 126, 124, 124, // 93104-93111
126, 126, 125, 122, 123, 125, 127, 128, // 93112-93119
126, 126, 128, 129, 129, 129, 128, 129, // 93120-93127
129, 129, 127, 125, 127, 128, 128, 127, // 93128-93135
128, 129, 131, 131, 129, 128, 128, 130, // 93136-93143
128, 126, 124, 124, 124, 126, 124, 124, // 93144-93151
124, 126, 128, 128, 127, 127, 128, 128, // 93152-93159
127, 125, 126, 125, 127, 126, 125, 125, // 93160-93167
126, 128, 127, 127, 128, 129, 131, 130, // 93168-93175
128, 127, 127, 130, 129, 127, 125, 127, // 93176-93183
129, 128, 128, 126, 126, 128, 128, 128, // 93184-93191
126, 126, 126, 127, 125, 126, 127, 128, // 93192-93199
128, 126, 125, 125, 127, 127, 125, 124, // 93200-93207
125, 126, 129, 128, 127, 127, 129, 131, // 93208-93215
131, 129, 126, 126, 128, 127, 125, 125, // 93216-93223
125, 128, 129, 129, 129, 130, 131, 131, // 93224-93231
129, 126, 127, 127, 126, 124, 123, 123, // 93232-93239
125, 127, 125, 125, 126, 128, 130, 129, // 93240-93247
126, 125, 126, 127, 126, 124, 123, 124, // 93248-93255
126, 127, 126, 127, 129, 129, 131, 130, // 93256-93263
130, 129, 130, 128, 127, 126, 127, 128, // 93264-93271
129, 126, 127, 129, 130, 130, 128, 125, // 93272-93279
125, 127, 128, 127, 125, 124, 125, 127, // 93280-93287
126, 126, 126, 126, 127, 126, 124, 124, // 93288-93295
126, 126, 125, 125, 126, 127, 129, 129, // 93296-93303
127, 127, 129, 130, 130, 127, 126, 128, // 93304-93311
128, 128, 126, 125, 127, 129, 130, 128, // 93312-93319
128, 129, 129, 129, 128, 127, 125, 126, // 93320-93327
124, 124, 122, 124, 126, 127, 127, 127, // 93328-93335
130, 130, 129, 128, 126, 125, 126, 126, // 93336-93343
124, 123, 123, 125, 127, 128, 128, 128, // 93344-93351
129, 131, 132, 130, 128, 128, 128, 126, // 93352-93359
126, 125, 126, 127, 125, 126, 127, 128, // 93360-93367
130, 130, 128, 127, 127, 128, 127, 125, // 93368-93375
124, 123, 126, 127, 127, 126, 126, 128, // 93376-93383
128, 127, 126, 125, 125, 125, 125, 126, // 93384-93391
126, 127, 129, 128, 129, 129, 129, 131, // 93392-93399
129, 127, 126, 126, 127, 126, 125, 126, // 93400-93407
127, 129, 129, 128, 130, 128, 128, 129, // 93408-93415
127, 125, 124, 125, 126, 125, 124, 124, // 93416-93423
125, 126, 127, 129, 130, 129, 130, 127, // 93424-93431
126, 126, 125, 125, 124, 125, 125, 126, // 93432-93439
128, 130, 129, 130, 131, 131, 132, 129, // 93440-93447
127, 127, 126, 126, 125, 125, 125, 126, // 93448-93455
128, 128, 129, 128, 128, 128, 127, 126, // 93456-93463
126, 126, 125, 126, 124, 124, 126, 127, // 93464-93471
126, 126, 128, 128, 128, 128, 127, 126, // 93472-93479
127, 128, 128, 127, 127, 129, 128, 129, // 93480-93487
129, 128, 129, 129, 129, 127, 125, 125, // 93488-93495
126, 125, 126, 126, 128, 128, 129, 130, // 93496-93503
128, 127, 128, 126, 125, 125, 123, 124, // 93504-93511
124, 124, 123, 124, 126, 128, 129, 129, // 93512-93519
129, 129, 129, 128, 128, 125, 125, 125, // 93520-93527
125, 125, 125, 126, 127, 129, 129, 129, // 93528-93535
130, 131, 131, 130, 128, 127, 126, 125, // 93536-93543
125, 125, 126, 126, 127, 126, 127, 127, // 93544-93551
128, 129, 128, 127, 127, 127, 126, 126, // 93552-93559
124, 124, 124, 127, 127, 127, 127, 127, // 93560-93567
128, 128, 128, 126, 126, 127, 127, 127, // 93568-93575
128, 127, 129, 128, 128, 129, 129, 129, // 93576-93583
129, 127, 126, 126, 126, 127, 126, 126, // 93584-93591
126, 128, 129, 129, 128, 127, 126, 126, // 93592-93599
127, 125, 124, 124, 123, 123, 124, 124, // 93600-93607
125, 128, 128, 129, 129, 130, 129, 128, // 93608-93615
127, 126, 126, 127, 126, 126, 125, 127, // 93616-93623
129, 131, 130, 130, 131, 131, 132, 129, // 93624-93631
127, 125, 124, 124, 125, 124, 125, 126, // 93632-93639
127, 126, 127, 129, 128, 127, 127, 126, // 93640-93647
127, 126, 126, 124, 123, 123, 126, 128, // 93648-93655
128, 127, 128, 127, 128, 129, 128, 126, // 93656-93663
126, 127, 128, 128, 128, 128, 128, 127, // 93664-93671
128, 130, 129, 127, 128, 126, 126, 127, // 93672-93679
126, 125, 125, 126, 127, 129, 130, 128, // 93680-93687
127, 126, 127, 127, 126, 124, 124, 124, // 93688-93695
124, 125, 127, 127, 127, 128, 130, 131, // 93696-93703
131, 129, 126, 125, 125, 125, 125, 125, // 93704-93711
125, 126, 127, 129, 130, 130, 129, 130, // 93712-93719
130, 129, 129, 128, 125, 124, 124, 125, // 93720-93727
126, 126, 127, 127, 127, 128, 129, 128, // 93728-93735
127, 127, 127, 127, 127, 126, 123, 124, // 93736-93743
125, 126, 126, 126, 127, 127, 128, 128, // 93744-93751
129, 127, 126, 126, 129, 126, 151, 168, // 93752-93759
149, 114,  91,  80,  94,  70,  45,  63, // 93760-93767
133, 220, 234, 248, 205, 251, 208, 121, // 93768-93775
131, 101,  16,   7, 249, 150, 254, 114, // 93776-93783
186, 154, 184, 234,  28,  53, 205, 150, // 93784-93791
109,  81, 106, 119, 227, 225,  16,  57, // 93792-93799
 64,  83,  82,  72, 178, 152, 101,  72, // 93800-93807
 71,  58,  93,  42,  82, 190, 167, 158, // 93808-93815
148, 157, 155, 221, 210, 131,  77, 151, // 93816-93823
184, 237, 203,  88, 203,   3,  64,  90, // 93824-93831
 23, 183, 192, 163,  85,  30,  24,   5, // 93832-93839
218,  34,  28,  90, 151, 170, 165, 158, // 93840-93847
128, 216, 244,  63, 224, 166, 186, 185, // 93848-93855
250, 223, 211,  91, 207, 255,  27,  18, // 93856-93863
 12,  54, 247, 244, 178, 117,  78,  97, // 93864-93871
 41, 238, 117, 196, 191, 213,  32,  15, // 93872-93879
 68,  20, 185, 125,  85, 110,  94,  18, // 93880-93887
189, 227,  23,  57,  57,  96,  21, 108, // 93888-93895
226, 137,  95,  58,  58,  53,  66,  61, // 93896-93903
109, 115, 130, 132, 146, 150, 163, 239, // 93904-93911
156, 104, 147, 190, 193, 234, 135, 105, // 93912-93919
196,  21,  74, 252, 202, 153, 183, 142, // 93920-93927
 70,  48,  18, 232,  46,  78,  52, 116, // 93928-93935
143, 167, 138, 159, 157, 196, 155,  24, // 93936-93943
212, 195, 201, 233,   9, 192,  47, 169, // 93944-93951
231,   4,   9,   1,   1,  32,  10, 187, // 93952-93959
109,  98,  74, 110,  10,  36, 153, 164, // 93960-93967
220,  25,  34,  20,  48, 234, 155,  98, // 93968-93975
124,  83,  31, 238, 194,   6,  46,  72, // 93976-93983
 89,  58,  52, 219, 215, 129,  81,  59, // 93984-93991
 55,  47, 100,  65,  66,  99, 126, 136, // 93992-93999
157, 150, 206, 195, 135, 166, 182, 196, // 94000-94007
197, 204,  99, 114, 234,  37, 240, 201, // 94008-94015
170, 152, 186, 119,  89,  29,   4,  49, // 94016-94023
 99,  78,  72, 119, 151, 137, 153, 172, // 94024-94031
115, 169, 103,   5, 223, 212, 239, 255, // 94032-94039
235,  10, 129, 193, 243, 240,   3, 221, // 94040-94047
  5,  42, 196, 118,  98,  81,  97,  91, // 94048-94055
 17,  88, 132, 209,  15,  34,  20,   8, // 94056-94063
 24, 188, 131, 129,  96,  21,  18, 218, // 94064-94071
228,  28,  71,  88,  63,  73, 145, 249, // 94072-94079
187, 111,  72,  58,  40,  98,  83,  13, // 94080-94087
 65,  99, 133, 143, 164, 169, 183, 177, // 94088-94095
188, 184, 194, 184, 195, 166,  69, 175, // 94096-94103
245, 223, 193, 182, 152, 165, 170, 124, // 94104-94111
 59,  19,  71,  89, 113,  74,  83, 127, // 94112-94119
131, 150, 175, 105, 104, 155,  66,  11, // 94120-94127
228,   0, 243, 251,  38,  79, 159, 208, // 94128-94135
229, 236, 225, 220,  37, 223, 135, 101, // 94136-94143
 90,  87, 106,  83,  31,  89, 181,   7, // 94144-94151
 18,  29, 243,   4, 232, 159, 149,  94, // 94152-94159
 37,  14,  11, 229,   2,  60,  90,  61, // 94160-94167
 95, 126, 192, 244, 149, 101,  59,  52, // 94168-94175
 83,  95,  21,  19,  74, 116, 138, 156, // 94176-94183
176, 142, 194, 219, 198, 189, 185, 174, // 94184-94191
186, 113, 111, 194, 186, 191, 173, 173, // 94192-94199
148, 174, 170,  88,  48,  82,  97, 107, // 94200-94207
109,  67,  97, 114, 153, 163, 119,  73, // 94208-94215
122, 133,  54,  10,   7, 253, 239,  66, // 94216-94223
 75, 114, 175, 205, 220, 212, 221, 244, // 94224-94231
234, 160, 115,  92,  98,  93, 126,  55, // 94232-94239
 32, 154, 233,  12,  13,   1, 228, 235, // 94240-94247
201, 172, 104,  49,  23,  17,  19, 242, // 94248-94255
 43,  79,  67,  98, 144, 145, 223, 205, // 94256-94263
126,  79,  54,  90,  72,  48,   7,  38, // 94264-94271
 95, 128, 150, 171, 137, 165, 241, 216, // 94272-94279
196, 180, 174, 166, 159, 118, 130, 154, // 94280-94287
169, 172, 170, 167, 153, 190, 125,  82, // 94288-94295
 99, 108, 107, 113,  94,  68,  92, 140, // 94296-94303
155, 112,  87,  76, 140, 115,  49,  33, // 94304-94311
  0, 253,  58, 101,  91, 137, 174, 203, // 94312-94319
195, 222, 226, 197, 186, 134, 106, 102, // 94320-94327
100, 121, 106,  27, 106, 201, 245,   3, // 94328-94335
248, 234, 202, 228, 200, 121,  60,  41, // 94336-94343
 21,  39,  18,  21,  64,  64, 105, 144, // 94344-94351
150, 168, 220, 172, 100,  69,  90,  64, // 94352-94359
 39,  36,   9,  69, 110, 146, 158, 144, // 94360-94367
154, 220, 242, 208, 180, 171, 158, 156, // 94368-94375
164,  98, 107, 147, 165, 169, 170, 161, // 94376-94383
168, 157, 117, 122, 115, 119, 107, 113, // 94384-94391
 81,  64, 127, 144, 107,  92,  73,  97, // 94392-94399
147,  95,  60,  12,  12,  59,  98, 109, // 94400-94407
101, 145, 180, 185, 206, 221, 170, 173, // 94408-94415
162, 120, 107, 105, 119, 116,  78,  79, // 94416-94423
162, 219, 249, 238, 236, 200, 210, 230, // 94424-94431
140,  78,  49,  39,  38,  46,  33,  35, // 94432-94439
 58, 108, 142, 152, 151, 175, 204, 131, // 94440-94447
 91,  90,  65,  30,  40,  29,  37,  90, // 94448-94455
133, 153, 136, 167, 196, 237, 232, 186, // 94456-94463
171, 158, 151, 179, 125,  66, 115, 145, // 94464-94471
170, 164, 174, 162, 147, 155, 144, 127, // 94472-94479
121, 112, 105, 104,  66, 102, 129, 103, // 94480-94487
 92,  83,  81, 122, 140,  92,  36,  22, // 94488-94495
 70,  87, 116, 105, 109, 155, 169, 200, // 94496-94503
207, 172, 149, 167, 149, 119, 110, 120, // 94504-94511
107, 104, 103, 118, 187, 222, 232, 225, // 94512-94519
210, 198, 219, 170,  99,  64,  47,  48, // 94520-94527
 44,  63,  29,  38, 106, 140, 152, 155, // 94528-94535
148, 187, 173, 119, 105,  61,  38,  29, // 94536-94543
 46,  40,  58, 116, 140, 133, 165, 198, // 94544-94551
206, 238, 205, 175, 155, 149, 170, 146, // 94552-94559
 75,  74, 122, 155, 167, 170, 173, 134, // 94560-94567
165, 178, 146, 131, 116, 107, 101,  93, // 94568-94575
 89, 104,  96,  93,  87,  89,  97, 139, // 94576-94583
134,  63,  43,  72,  90, 102, 117, 100, // 94584-94591
120, 150, 189, 195, 164, 148, 142, 164, // 94592-94599
141, 118, 122, 106, 107, 134, 116, 143, // 94600-94607
194, 215, 220, 201, 209, 197, 177, 131, // 94608-94615
 84,  62,  60,  53,  69,  55,  26,  91, // 94616-94623
134, 150, 154, 145, 155, 176, 157, 124, // 94624-94631
 71,  40,  35,  38,  61,  46,  89, 122, // 94632-94639
128, 160, 194, 199, 212, 222, 188, 156, // 94640-94647
150, 165, 145, 103,  65,  87, 137, 159, // 94648-94655
172, 173, 146, 153, 197, 174, 145, 121, // 94656-94663
113,  97,  97, 107,  78,  80,  88,  89, // 94664-94671
 95,  95, 117, 152, 102,  71,  82,  91, // 94672-94679
100, 106, 113,  96, 120, 170, 182, 154, // 94680-94687
150, 135, 150, 165, 136, 130, 107, 110, // 94688-94695
143, 141, 125, 156, 190, 209, 197, 211, // 94696-94703
201, 158, 153, 110,  80,  69,  65,  70, // 94704-94711
 66,  46,  72, 122, 145, 153, 145, 144, // 94712-94719
150, 178, 150,  83,  44,  36,  35,  58, // 94720-94727
 66,  68, 101, 117, 161, 189, 206, 200, // 94728-94735
206, 207, 163, 153, 158, 134, 109,  82, // 94736-94743
 64, 109, 146, 173, 171, 157, 164, 186, // 94744-94751
201, 168, 133, 115, 102,  92, 117,  82, // 94752-94759
 54,  78,  86, 100, 100, 110, 133, 128, // 94760-94767
106, 102,  96, 103,  97, 109, 105,  96, // 94768-94775
148, 163, 147, 141, 142, 139, 158, 160, // 94776-94783
136, 110, 110, 143, 150, 138, 127, 162, // 94784-94791
189, 195, 208, 204, 156, 143, 137, 104, // 94792-94799
 84,  72,  76,  56,  64,  78, 100, 137, // 94800-94807
147, 148, 143, 141, 170, 178, 110,  64, // 94808-94815
 40,  42,  49,  68,  75,  68,  99, 150, // 94816-94823
183, 196, 203, 188, 205, 185, 163, 162, // 94824-94831
130, 113,  97,  77,  85, 123, 159, 168, // 94832-94839
155, 177, 182, 195, 192, 148, 124, 103, // 94840-94847
100, 108,  96,  52,  58,  80,  99, 105, // 94848-94855
110, 121, 123, 136, 123, 107, 100,  96, // 94856-94863
 96, 106,  98, 121, 142, 138, 141, 138, // 94864-94871
148, 144, 168, 155, 117, 118, 140, 152, // 94872-94879
149, 128, 131, 165, 183, 207, 197, 166, // 94880-94887
139, 139, 132, 102,  85,  82,  64,  64, // 94888-94895
 97,  92, 118, 137, 143, 144, 134, 157, // 94896-94903
172, 136,  85,  56,  48,  56,  61,  85, // 94904-94911
 66,  77, 137, 170, 187, 192, 188, 183, // 94912-94919
192, 178, 163, 129, 112, 104,  90,  84, // 94920-94927
 96, 141, 154, 153, 174, 189, 182, 195, // 94928-94935
172, 139, 113, 109, 113,  93,  76,  49, // 94936-94943
 71,  95, 105, 112, 112, 114, 144, 150, // 94944-94951
123, 110,  97,  99,  97, 109, 112, 115, // 94952-94959
123, 131, 132, 143, 143, 150, 168, 129, // 94960-94967
127, 140, 150, 154, 136, 125, 136, 165, // 94968-94975
195, 191, 163, 148, 130, 144, 125, 102, // 94976-94983
 91,  72,  74, 100, 107, 102, 124, 135, // 94984-94991
142, 133, 148, 158, 141, 112,  72,  60, // 94992-94999
 59,  64,  79,  78,  70, 117, 155, 178, // 95000-95007
182, 184, 180, 175, 195, 170, 135, 113, // 95008-95015
109, 101,  93,  89, 117, 139, 148, 173, // 95016-95023
186, 187, 179, 183, 158, 124, 115, 119, // 95024-95031
 92,  79,  66,  55,  88,  99, 117, 109, // 95032-95039
108, 138, 159, 145, 121, 103, 101,  96, // 95040-95047
104, 122,  98, 105, 120, 131, 138, 145, // 95048-95055
147, 155, 149, 137, 146, 145, 155, 140, // 95056-95063
129, 121, 142, 180, 180, 160, 151, 137, // 95064-95071
136, 144, 122, 104,  78,  85,  99, 113, // 95072-95079
110, 105, 129, 133, 137, 143, 148, 136, // 95080-95087
129,  98,  75,  67,  69,  77,  76,  84, // 95088-95095
100, 139, 164, 175, 174, 179, 165, 186, // 95096-95103
182, 136, 119, 105, 110, 101,  95, 103, // 95104-95111
120, 142, 171, 183, 188, 178, 172, 174, // 95112-95119
137, 126, 119,  97,  78,  79,  65,  74, // 95120-95127
 98, 113, 113, 103, 134, 154, 159, 134, // 95128-95135
110, 102,  97, 102, 120, 103,  87, 110, // 95136-95143
123, 137, 139, 150, 142, 146, 151, 148, // 95144-95151
149, 148, 148, 133, 125, 127, 163, 169, // 95152-95159
159, 150, 144, 136, 138, 140, 113,  89, // 95160-95167
 89, 106, 109, 120, 103, 113, 128, 132, // 95168-95175
146, 135, 129, 125, 117,  93,  79,  74, // 95176-95183
 80,  72,  89, 106, 119, 152, 164, 170, // 95184-95191
170, 170, 173, 184, 150, 125, 113, 112, // 95192-95199
115, 103, 107, 102, 129, 162, 179, 183, // 95200-95207
180, 163, 166, 155, 136, 126,  98,  84, // 95208-95215
 74,  80,  71,  87, 107, 109, 107, 125, // 95216-95223
150, 155, 151, 121, 109,  97, 104, 112, // 95224-95231
110,  92,  95, 119, 134, 143, 149, 147, // 95232-95239
135, 162, 158, 152, 145, 140, 140, 125, // 95240-95247
129, 143, 155, 152, 152, 146, 145, 133, // 95248-95255
142, 130,  99,  97, 104, 108, 111, 113, // 95256-95263
101, 117, 125, 143, 135, 122, 124, 118, // 95264-95271
114,  91,  84,  80,  75,  86, 114, 115, // 95272-95279
132, 151, 162, 167, 168, 175, 168, 163, // 95280-95287
136, 122, 115, 117, 114, 110, 104, 115, // 95288-95295
154, 170, 180, 176, 169, 156, 158, 150, // 95296-95303
128, 102,  88,  79,  83,  87,  79, 104, // 95304-95311
104, 111, 125, 141, 151, 147, 135, 113, // 95312-95319
100, 102, 109, 100, 102,  90, 106, 129, // 95320-95327
139, 150, 149, 140, 153, 172, 156, 150, // 95328-95335
139, 141, 128, 128, 138, 136, 146, 146, // 95336-95343
149, 149, 142, 135, 139, 115, 108, 111, // 95344-95351
112, 110, 111, 110, 100, 121, 134, 133, // 95352-95359
117, 120, 119, 119, 108,  92,  88,  77, // 95360-95367
 88, 109, 125, 123, 139, 154, 160, 163, // 95368-95375
175, 163, 151, 148, 125, 122, 115, 120, // 95376-95383
113, 106, 112, 140, 165, 175, 175, 169, // 95384-95391
159, 147, 160, 138, 108,  91,  83,  81, // 95392-95399
 89,  87,  91, 103, 108, 130, 135, 150, // 95400-95407
147, 142, 126, 105, 107, 107,  97,  97, // 95408-95415
100,  96, 119, 133, 146, 145, 145, 151, // 95416-95423
166, 168, 151, 143, 136, 134, 126, 135, // 95424-95431
126, 130, 141, 145, 148, 145, 140, 132, // 95432-95439
129, 119, 118, 114, 112, 107, 113, 104, // 95440-95447
109, 132, 127, 121, 115, 125, 121, 119, // 95448-95455
107,  92,  81,  89, 105, 120, 126, 123, // 95456-95463
144, 151, 158, 168, 165, 144, 146, 137, // 95464-95471
124, 120, 119, 123, 104, 116, 131, 153, // 95472-95479
168, 170, 167, 161, 148, 152, 150, 115, // 95480-95487
101,  90,  89,  88,  98,  94,  94, 109, // 95488-95495
127, 136, 140, 149, 139, 135, 114, 110, // 95496-95503
106,  95,  91,  97,  99, 104, 126, 140, // 95504-95511
142, 141, 156, 156, 168, 160, 145, 138, // 95512-95519
132, 135, 130, 127, 120, 134, 142, 148, // 95520-95527
147, 147, 133, 128, 136, 125, 120, 117, // 95528-95535
112, 111, 113, 107, 122, 123, 118, 113, // 95536-95543
115, 125, 117, 120, 100,  87,  93, 107, // 95544-95551
114, 127, 125, 129, 143, 151, 163, 158, // 95552-95559
146, 136, 142, 133, 124, 121, 123, 111, // 95560-95567
111, 133, 138, 159, 165, 165, 159, 154, // 95568-95575
150, 147, 129, 107,  97,  93,  93,  97, // 95576-95583
105,  90, 104, 125, 135, 136, 142, 143, // 95584-95591
133, 129, 117, 112,  98,  96,  96, 106, // 95592-95599
105, 113, 133, 134, 137, 151, 155, 154, // 95600-95607
163, 149, 141, 131, 139, 133, 122, 122, // 95608-95615
122, 137, 143, 146, 145, 139, 125, 137, // 95616-95623
136, 124, 118, 113, 111, 111, 117, 115, // 95624-95631
118, 117, 119, 115, 122, 122, 119, 114, // 95632-95639
100, 102, 108, 114, 120, 127, 126, 130, // 95640-95647
139, 147, 146, 141, 136, 133, 135, 130, // 95648-95655
128, 125, 126, 124, 130, 135, 139, 145, // 95656-95663
145, 144, 141, 139, 134, 130, 124, 118, // 95664-95671
114, 113, 113, 116, 117, 117, 124, 126, // 95672-95679
128, 126, 128, 126, 123, 122, 119, 117, // 95680-95687
116, 119, 120, 124, 125, 128, 131, 132, // 95688-95695
134, 134, 132, 132, 131, 129, 128, 128, // 95696-95703
131, 131, 131, 133, 134, 135, 134, 134, // 95704-95711
131, 128, 125, 126, 124, 123, 122, 121, // 95712-95719
122, 123, 126, 128, 128, 128, 128, 126, // 95720-95727
127, 124, 122, 120, 118, 119, 119, 122, // 95728-95735
123, 126, 128, 130, 132, 134, 135, 135, // 95736-95743
133, 131, 129, 127, 126, 125, 125, 125, // 95744-95751
126, 128, 130, 130, 131, 132, 130, 132, // 95752-95759
130, 129, 128, 125, 124, 123, 123, 124, // 95760-95767
124, 125, 125, 125, 126, 125, 125, 125, // 95768-95775
124, 125, 125, 125, 125, 127, 127, 128, // 95776-95783
127, 128, 129, 129, 129, 127, 127, 126, // 95784-95791
126, 127, 126, 127, 130, 131, 133, 133, // 95792-95799
132, 131, 131, 131, 129, 127, 125, 124, // 95800-95807
125, 123, 122, 122, 124, 125, 128, 129, // 95808-95815
130, 130, 129, 127, 126, 124, 124, 123, // 95816-95823
122, 120, 121, 123, 124, 127, 127, 128, // 95824-95831
132, 133, 134, 131, 129, 128, 127, 126, // 95832-95839
126, 125, 126, 126, 128, 129, 129, 131, // 95840-95847
132, 131, 131, 131, 130, 129, 128, 125, // 95848-95855
123, 123, 125, 124, 125, 124, 125, 128, // 95856-95863
126, 125, 125, 124, 124, 127, 126, 126, // 95864-95871
126, 127, 127, 128, 128, 128, 128, 129, // 95872-95879
127, 127, 126, 125, 126, 126, 127, 129, // 95880-95887
132, 133, 132, 132, 131, 130, 130, 128, // 95888-95895
125, 125, 123, 125, 124, 123, 123, 124, // 95896-95903
126, 128, 131, 130, 130, 130, 128, 125, // 95904-95911
125, 124, 123, 122, 122, 122, 124, 125, // 95912-95919
126, 128, 129, 132, 134, 134, 133, 131, // 95920-95927
130, 126, 127, 125, 123, 124, 126, 127, // 95928-95935
128, 128, 129, 131, 130, 130, 130, 129, // 95936-95943
128, 127, 124, 122, 122, 124, 124, 124, // 95944-95951
126, 125, 128, 128, 126, 125, 125, 125, // 95952-95959
128, 128, 125, 125, 128, 128, 127, 128, // 95960-95967
126, 127, 129, 129, 128, 127, 127, 127, // 95968-95975
127, 126, 127, 130, 132, 130, 131, 130, // 95976-95983
129, 131, 129, 126, 125, 125, 124, 125, // 95984-95991
122, 122, 123, 126, 128, 129, 130, 129, // 95992-95999
131, 131, 127, 123, 123, 122, 122, 122, // 96000-96007
121, 124, 125, 128, 129, 130, 131, 133, // 96008-96015
134, 133, 130, 129, 127, 125, 125, 122, // 96016-96023
122, 126, 129, 129, 129, 128, 132, 134, // 96024-96031
133, 131, 129, 127, 126, 126, 123, 120, // 96032-96039
121, 124, 124, 126, 127, 128, 129, 128, // 96040-96047
126, 125, 125, 126, 126, 123, 122, 125, // 96048-96055
127, 127, 128, 127, 127, 130, 131, 131, // 96056-96063
127, 126, 127, 127, 127, 126, 127, 130, // 96064-96071
131, 132, 132, 128, 130, 131, 127, 124, // 96072-96079
124, 124, 124, 124, 122, 123, 126, 128, // 96080-96087
129, 130, 129, 129, 132, 128, 125, 122, // 96088-96095
120, 121, 123, 122, 120, 123, 127, 130, // 96096-96103
132, 133, 132, 134, 134, 132, 130, 128, // 96104-96111
124, 123, 122, 121, 123, 127, 128, 129, // 96112-96119
130, 131, 133, 135, 132, 129, 126, 124, // 96120-96127
125, 125, 120, 119, 120, 123, 125, 128, // 96128-96135
127, 128, 130, 129, 127, 127, 126, 126, // 96136-96143
126, 123, 124, 127, 127, 128, 128, 128, // 96144-96151
128, 131, 132, 129, 127, 127, 126, 128, // 96152-96159
128, 127, 128, 130, 132, 133, 131, 128, // 96160-96167
129, 129, 126, 124, 123, 122, 123, 123, // 96168-96175
123, 124, 127, 127, 129, 130, 129, 130, // 96176-96183
130, 127, 123, 121, 120, 122, 123, 120, // 96184-96191
121, 124, 128, 131, 134, 133, 133, 135, // 96192-96199
136, 134, 131, 127, 124, 123, 123, 122, // 96200-96207
125, 127, 127, 129, 130, 132, 135, 134, // 96208-96215
130, 128, 126, 125, 126, 123, 119, 118, // 96216-96223
121, 123, 126, 126, 125, 127, 130, 128, // 96224-96231
128, 127, 126, 126, 126, 124, 125, 127, // 96232-96239
126, 127, 128, 128, 129, 131, 130, 129, // 96240-96247
128, 127, 129, 130, 128, 127, 129, 131, // 96248-96255
132, 132, 128, 127, 129, 127, 126, 124, // 96256-96263
122, 121, 123, 124, 124, 125, 126, 129, // 96264-96271
131, 131, 130, 129, 127, 124, 122, 121, // 96272-96279
122, 123, 122, 120, 123, 127, 130, 133, // 96280-96287
133, 132, 132, 134, 134, 131, 127, 123, // 96288-96295
123, 123, 123, 124, 126, 127, 129, 130, // 96296-96303
131, 132, 134, 132, 128, 127, 126, 125, // 96304-96311
125, 122, 120, 121, 122, 125, 127, 127, // 96312-96319
127, 129, 130, 128, 127, 126, 126, 127, // 96320-96327
126, 124, 125, 126, 127, 128, 128, 127, // 96328-96335
128, 131, 129, 129, 127, 126, 127, 128, // 96336-96343
127, 127, 130, 131, 131, 129, 127, 127, // 96344-96351
129, 127, 124, 123, 121, 122, 126, 125, // 96352-96359
124, 126, 127, 130, 132, 131, 130, 128, // 96360-96367
127, 123, 122, 121, 123, 123, 122, 121, // 96368-96375
126, 129, 131, 133, 131, 131, 132, 133, // 96376-96383
131, 127, 123, 122, 123, 123, 123, 125, // 96384-96391
128, 129, 131, 132, 132, 134, 133, 129, // 96392-96399
127, 126, 125, 124, 123, 121, 121, 122, // 96400-96407
125, 127, 127, 127, 129, 130, 129, 126, // 96408-96415
125, 124, 125, 125, 124, 124, 124, 127, // 96416-96423
127, 128, 128, 128, 130, 130, 130, 130, // 96424-96431
128, 128, 128, 128, 127, 129, 132, 131, // 96432-96439
130, 128, 128, 128, 128, 126, 124, 122, // 96440-96447
122, 125, 126, 125, 125, 127, 128, 131, // 96448-96455
131, 130, 128, 126, 123, 121, 121, 122, // 96456-96463
122, 122, 123, 125, 130, 132, 133, 133, // 96464-96471
131, 132, 133, 133, 128, 124, 122, 123, // 96472-96479
122, 124, 125, 127, 129, 131, 133, 132, // 96480-96487
132, 133, 131, 128, 126, 124, 123, 122, // 96488-96495
121, 121, 121, 124, 126, 127, 128, 130, // 96496-96503
131, 131, 128, 126, 125, 124, 126, 125, // 96504-96511
124, 123, 125, 127, 128, 129, 128, 128, // 96512-96519
129, 131, 130, 129, 128, 128, 127, 127, // 96520-96527
128, 130, 131, 129, 128, 128, 127, 128, // 96528-96535
128, 125, 123, 123, 126, 127, 126, 125, // 96536-96543
125, 126, 130, 131, 130, 128, 127, 126, // 96544-96551
124, 122, 122, 122, 122, 123, 125, 127, // 96552-96559
130, 132, 132, 131, 132, 133, 132, 130, // 96560-96567
126, 123, 122, 123, 123, 123, 124, 127, // 96568-96575
131, 133, 133, 132, 134, 132, 131, 128, // 96576-96583
125, 124, 123, 122, 120, 120, 122, 124, // 96584-96591
126, 127, 128, 131, 130, 131, 128, 125, // 96592-96599
125, 125, 126, 124, 123, 125, 126, 128, // 96600-96607
128, 128, 128, 130, 131, 132, 129, 127, // 96608-96615
129, 128, 126, 127, 129, 130, 130, 130, // 96616-96623
128, 127, 128, 128, 126, 123, 122, 124, // 96624-96631
126, 126, 126, 125, 125, 128, 130, 129, // 96632-96639
128, 128, 127, 124, 123, 122, 121, 122, // 96640-96647
123, 124, 127, 129, 131, 132, 132, 131, // 96648-96655
132, 132, 131, 129, 126, 123, 124, 124, // 96656-96663
123, 123, 126, 129, 132, 133, 132, 132, // 96664-96671
131, 130, 129, 126, 123, 123, 123, 121, // 96672-96679
121, 122, 124, 126, 128, 129, 130, 131, // 96680-96687
130, 128, 126, 123, 123, 124, 123, 124, // 96688-96695
124, 126, 128, 129, 130, 129, 130, 131, // 96696-96703
131, 130, 128, 126, 126, 125, 126, 127, // 96704-96711
129, 130, 130, 130, 129, 129, 129, 127, // 96712-96719
125, 123, 123, 125, 125, 124, 124, 124, // 96720-96727
126, 129, 130, 129, 128, 128, 126, 125, // 96728-96735
123, 121, 120, 122, 123, 125, 127, 129, // 96736-96743
131, 131, 132, 133, 132, 131, 129, 127, // 96744-96751
125, 123, 124, 125, 124, 126, 129, 131, // 96752-96759
134, 134, 133, 131, 130, 130, 127, 124, // 96760-96767
122, 121, 121, 121, 122, 123, 124, 127, // 96768-96775
128, 129, 131, 129, 128, 125, 124, 123, // 96776-96783
122, 122, 124, 123, 125, 127, 130, 131, // 96784-96791
130, 131, 130, 132, 131, 129, 126, 125, // 96792-96799
125, 126, 126, 127, 129, 129, 131, 132, // 96800-96807
132, 130, 128, 127, 125, 124, 124, 123, // 96808-96815
123, 123, 122, 125, 126, 128, 129, 128, // 96816-96823
128, 128, 127, 126, 123, 122, 121, 122, // 96824-96831
125, 126, 127, 129, 130, 132, 133, 131, // 96832-96839
131, 131, 129, 128, 125, 125, 124, 124, // 96840-96847
125, 126, 130, 132, 132, 132, 131, 130, // 96848-96855
130, 127, 125, 123, 121, 122, 123, 123, // 96856-96863
123, 124, 127, 128, 130, 131, 129, 130, // 96864-96871
127, 126, 126, 123, 123, 122, 123, 124, // 96872-96879
126, 129, 130, 129, 130, 130, 131, 133, // 96880-96887
130, 127, 127, 126, 126, 126, 126, 126, // 96888-96895
127, 129, 131, 131, 131, 129, 128, 128, // 96896-96903
126, 126, 125, 124, 124, 124, 124, 125, // 96904-96911
127, 127, 127, 127, 127, 128, 126, 124, // 96912-96919
123, 123, 123, 125, 126, 126, 127, 129, // 96920-96927
130, 130, 130, 130, 129, 129, 127, 127, // 96928-96935
126, 125, 125, 126, 126, 129, 131, 131, // 96936-96943
132, 132, 132, 130, 129, 126, 124, 123, // 96944-96951
123, 123, 124, 122, 124, 126, 127, 129, // 96952-96959
130, 129, 128, 128, 127, 125, 124, 123, // 96960-96967
121, 123, 124, 125, 128, 128, 129, 130, // 96968-96975
131, 132, 132, 131, 128, 128, 127, 127, // 96976-96983
126, 126, 126, 127, 128, 129, 131, 130, // 96984-96991
129, 128, 128, 127, 126, 125, 124, 124, // 96992-96999
125, 124, 125, 126, 126, 127, 127, 127, // 97000-97007
127, 126, 125, 125, 125, 125, 125, 125, // 97008-97015
126, 127, 129, 130, 129, 130, 129, 128, // 97016-97023
129, 128, 127, 127, 125, 127, 127, 128, // 97024-97031
129, 130, 130, 130, 131, 131, 129, 127, // 97032-97039
125, 123, 123, 124, 123, 124, 124, 125, // 97040-97047
127, 129, 130, 129, 128, 127, 128, 126, // 97048-97055
125, 124, 123, 121, 124, 125, 126, 127, // 97056-97063
129, 130, 131, 132, 131, 130, 130, 127, // 97064-97071
126, 126, 125, 126, 126, 125, 126, 128, // 97072-97079
130, 130, 130, 129, 129, 129, 129, 127, // 97080-97087
126, 125, 124, 125, 125, 125, 126, 126, // 97088-97095
127, 127, 128, 127, 126, 126, 125, 125, // 97096-97103
126, 125, 126, 127, 128, 129, 129, 129, // 97104-97111
129, 129, 127, 127, 127, 126, 126, 126, // 97112-97119
126, 128, 129, 129, 129, 129, 129, 130, // 97120-97127
130, 128, 127, 125, 124, 124, 124, 124, // 97128-97135
124, 125, 126, 127, 129, 129, 129, 128, // 97136-97143
127, 127, 127, 126, 125, 123, 123, 124, // 97144-97151
126, 126, 128, 128, 129, 130, 130, 131, // 97152-97159
129, 128, 127, 127, 126, 125, 126, 126, // 97160-97167
126, 127, 128, 128, 129, 129, 129, 127, // 97168-97175
127, 127, 126, 125, 124, 125, 126, 127, // 97176-97183
127, 128, 126, 129, 129, 127, 127, 126, // 97184-97191
127, 126, 126, 126, 126, 126, 127, 129, // 97192-97199
129, 128, 130, 129, 128, 128, 127, 126, // 97200-97207
126, 125, 125, 126, 127, 129, 128, 128, // 97208-97215
128, 128, 130, 128, 127, 126, 124, 125, // 97216-97223
125, 124, 125, 125, 127, 127, 128, 129, // 97224-97231
129, 130, 128, 127, 127, 126, 125, 126, // 97232-97239
124, 123, 125, 127, 127, 128, 129, 129, // 97240-97247
130, 131, 129, 128, 127, 126, 126, 126, // 97248-97255
125, 125, 126, 126, 127, 127, 128, 128, // 97256-97263
129, 128, 128, 127, 127, 127, 126, 125, // 97264-97271
126, 126, 126, 126, 127, 126, 128, 129, // 97272-97279
127, 125, 125, 126, 126, 127, 126, 126, // 97280-97287
126, 127, 128, 130, 129, 129, 128, 128, // 97288-97295
127, 127, 126, 124, 125, 126, 126, 127, // 97296-97303
129, 129, 129, 129, 129, 131, 129, 127, // 97304-97311
126, 124, 124, 124, 125, 124, 124, 126, // 97312-97319
126, 128, 130, 129, 130, 129, 128, 128, // 97320-97327
127, 125, 124, 125, 124, 124, 125, 127, // 97328-97335
126, 128, 129, 130, 131, 130, 128, 129, // 97336-97343
128, 127, 126, 125, 125, 125, 127, 126, // 97344-97351
128, 128, 127, 128, 128, 128, 128, 127, // 97352-97359
125, 126, 126, 127, 127, 127, 126, 126, // 97360-97367
128, 128, 128, 127, 125, 124, 125, 125, // 97368-97375
126, 127, 126, 127, 128, 129, 129, 130, // 97376-97383
129, 128, 128, 127, 126, 127, 125, 124, // 97384-97391
125, 125, 127, 128, 129, 129, 130, 130, // 97392-97399
130, 130, 128, 127, 126, 126, 124, 124, // 97400-97407
123, 124, 126, 127, 128, 128, 130, 130, // 97408-97415
131, 129, 128, 127, 125, 124, 124, 124, // 97416-97423
125, 125, 126, 126, 127, 129, 131, 130, // 97424-97431
129, 128, 128, 128, 127, 126, 125, 124, // 97432-97439
126, 126, 127, 127, 127, 128, 128, 128, // 97440-97447
129, 127, 127, 128, 127, 127, 127, 127, // 97448-97455
127, 126, 126, 127, 129, 128, 128, 125, // 97456-97463
126, 125, 127, 126, 125, 125, 127, 129, // 97464-97471
130, 129, 127, 128, 128, 128, 127, 125, // 97472-97479
125, 126, 125, 125, 125, 128, 129, 129, // 97480-97487
129, 129, 129, 131, 129, 127, 125, 125, // 97488-97495
127, 126, 124, 123, 125, 126, 129, 128, // 97496-97503
127, 127, 132, 131, 151, 167, 149, 113, // 97504-97511
 89,  77,  88,  66,  41,  61, 130, 218, // 97512-97519
234, 252, 209, 254, 212, 121, 132, 103, // 97520-97527
 19,   5, 248, 149, 252, 114, 188, 156, // 97528-97535
184, 237,  30,  56, 208, 153, 112,  82, // 97536-97543
105, 119, 228, 223,  16,  55,  64,  81, // 97544-97551
 84,  72, 177, 150,  99,  70,  69,  55, // 97552-97559
 87,  40,  79, 191, 167, 159, 148, 160, // 97560-97567
158, 222, 211, 131,  75, 148, 182, 232, // 97568-97575
204,  89, 203,   6,  66,  93,  31, 192, // 97576-97583
195, 166,  86,  33,  22,   5, 212,  29, // 97584-97591
 25,  88, 152, 171, 166, 159, 133, 216, // 97592-97599
247,  65, 223, 164, 182, 181, 243, 222, // 97600-97607
207,  87, 203, 254,  28,  23,  14,  56, // 97608-97615
250, 245, 181, 117,  77,  92,  41, 236, // 97616-97623
116, 196, 192, 212,  35,  20,  71,  24, // 97624-97631
185, 128,  86, 110,  92,  17, 188, 226, // 97632-97639
 23,  58,  58,  98,  24, 103, 226, 136, // 97640-97647
 93,  55,  53,  48,  61,  60, 111, 117, // 97648-97655
129, 132, 147, 156, 166, 240, 158, 100, // 97656-97663
143, 188, 190, 230, 135, 102, 197,  23, // 97664-97671
 80,   4, 210, 159, 187, 146,  72,  49, // 97672-97679
 16, 227,  37,  74,  48, 115, 143, 168, // 97680-97687
141, 163, 163, 199, 159,  24, 209, 192, // 97688-97695
198, 226,   4, 187,  40, 168, 230,   5, // 97696-97703
 12,   4,   3,  35,  13, 191, 110,  96, // 97704-97711
 70, 107,  13,  34, 152, 164, 220,  29, // 97712-97719
 41,  25,  51, 235, 156, 101, 125,  85, // 97720-97727
 29, 236, 191,   4,  47,  73,  89,  61, // 97728-97735
 49, 215, 217, 128,  78,  52,  50,  40, // 97736-97743
 97,  65,  67,  99, 125, 138, 164, 154, // 97744-97751
208, 197, 132, 162, 178, 193, 192, 201, // 97752-97759
 98, 114, 237,  44, 250, 207, 177, 156, // 97760-97767
190, 121,  89,  28, 254,  41,  95,  76, // 97768-97775
 70, 117, 150, 141, 157, 179, 118, 170, // 97776-97783
105,   3, 221, 208, 233, 249, 230,   4, // 97784-97791
128, 193, 243, 242,   5, 224,   6,  48, // 97792-97799
200, 118,  96,  79,  95,  94,  15,  85, // 97800-97807
132, 208,  20,  39,  25,   8,  25, 189, // 97808-97815
132, 130,  96,  20,  18, 218, 227,  31, // 97816-97823
 72,  91,  63,  73, 141, 249, 189, 108, // 97824-97831
 66,  54,  36,  96,  84,  12,  66,  98, // 97832-97839
135, 146, 166, 169, 183, 177, 186, 182, // 97840-97847
191, 181, 190, 166,  68, 174, 249, 228, // 97848-97855
199, 187, 158, 169, 176, 126,  59,  16, // 97856-97863
 67,  86, 112,  72,  78, 126, 134, 154, // 97864-97871
179, 110, 104, 157,  68,  12, 225, 249, // 97872-97879
236, 244,  33,  74, 157, 207, 228, 237, // 97880-97887
228, 221,  39, 228, 136, 100,  89,  88, // 97888-97895
106,  84,  29,  87, 179,   9,  22,  34, // 97896-97903
245,   5, 237, 160, 151,  95,  36,  12, // 97904-97911
 11, 229,   0,  60,  91,  62,  95, 127, // 97912-97919
190, 246, 148,  97,  56,  47,  79,  92, // 97920-97927
 20,  16,  74, 118, 142, 158, 178, 143, // 97928-97935
194, 219, 197, 185, 180, 169, 185, 115, // 97936-97943
110, 195, 190, 196, 179, 179, 154, 177, // 97944-97951
173,  88,  46,  79,  94, 104, 107,  63, // 97952-97959
 94, 116, 154, 167, 123,  75, 122, 138, // 97960-97967
 57,  10,   2, 248, 233,  61,  71, 109, // 97968-97975
173, 204, 222, 215, 224, 246, 237, 164, // 97976-97983
116,  93,  98,  92, 125,  56,  28, 152, // 97984-97991
232,  14,  17,   4, 230, 239, 204, 174, // 97992-97999
105,  48,  23,  18,  20, 241,  40,  79, // 98000-98007
 67,  99, 144, 144, 221, 206, 126,  78, // 98008-98015
 51,  85,  68,  47,   6,  35,  96, 130, // 98016-98023
151, 173, 140, 164, 241, 217, 195, 176, // 98024-98031
171, 164, 159, 119, 128, 154, 172, 176, // 98032-98039
177, 172, 155, 193, 129,  81,  97, 105, // 98040-98047
104, 110,  93,  67,  91, 140, 157, 115, // 98048-98055
 90,  77, 140, 120,  50,  32, 254, 248, // 98056-98063
 51,  97,  87, 132, 172, 203, 196, 223, // 98064-98071
229, 198, 190, 138, 108, 103,  98, 117, // 98072-98079
105,  26, 102, 199, 245,   7, 251, 240, // 98080-98087
205, 230, 204, 124,  61,  39,  17,  37, // 98088-98095
 19,  18,  61,  62, 103, 145, 151, 166, // 98096-98103
218, 174, 103,  70,  88,  62,  35,  36, // 98104-98111
  8,  66, 108, 146, 159, 147, 155, 218, // 98112-98119
242, 210, 181, 169, 157, 154, 165, 100, // 98120-98127
105, 145, 164, 173, 176, 166, 168, 158, // 98128-98135
117, 122, 112, 116, 102, 109,  83,  64, // 98136-98143
125, 142, 109,  96,  78,  98, 150, 100, // 98144-98151
 65,  13,   7,  53,  90, 107,  97, 139, // 98152-98159
175, 186, 209, 229, 174, 176, 166, 126, // 98160-98167
113, 105, 115, 110,  75,  73, 155, 213, // 98168-98175
247, 239, 240, 205, 211, 235, 146,  84, // 98176-98183
 51,  38,  35,  46,  34,  33,  50, 101, // 98184-98191
139, 153, 152, 173, 205, 135,  96,  92, // 98192-98199
 65,  28,  40,  29,  36,  87, 129, 152, // 98200-98207
136, 167, 194, 233, 233, 189, 172, 156, // 98208-98215
148, 177, 127,  66, 113, 142, 170, 171, // 98216-98223
179, 166, 147, 157, 148, 129, 120, 109, // 98224-98231
 99, 103,  65,  99, 126, 102,  95,  87, // 98232-98239
 85, 125, 144,  97,  39,  19,  65,  80, // 98240-98247
111, 103, 104, 149, 166, 200, 211, 176, // 98248-98255
151, 168, 152, 126, 114, 120, 104, 101, // 98256-98263
100, 113, 179, 217, 230, 226, 212, 200, // 98264-98271
223, 175, 107,  71,  51,  50,  46,  65, // 98272-98279
 29,  32,  98, 135, 150, 155, 147, 186, // 98280-98287
176, 124, 111,  65,  38,  29,  47,  41, // 98288-98295
 56, 112, 137, 131, 164, 197, 203, 237, // 98296-98303
207, 176, 156, 148, 170, 147,  77,  74, // 98304-98311
120, 154, 169, 175, 177, 134, 164, 180, // 98312-98319
147, 130, 114, 103,  99,  92,  89, 102, // 98320-98327
 93,  93,  91,  93, 100, 141, 139,  66, // 98328-98335
 44,  70,  85,  97, 114,  96, 115, 145, // 98336-98343
187, 197, 169, 152, 146, 169, 146, 124, // 98344-98351
126, 103, 103, 130, 112, 136, 186, 208, // 98352-98359
218, 202, 212, 200, 181, 138,  92,  67, // 98360-98367
 62,  54,  70,  54,  21,  86, 127, 145, // 98368-98375
152, 145, 155, 176, 162, 129,  76,  44, // 98376-98383
 37,  39,  63,  48,  87, 119, 123, 159, // 98384-98391
193, 197, 209, 220, 188, 158, 150, 165, // 98392-98399
144, 104,  66,  86, 137, 159, 174, 174, // 98400-98407
147, 152, 195, 174, 146, 120, 111,  96, // 98408-98415
 96, 108,  79,  79,  87,  89,  99,  99, // 98416-98423
120, 153, 105,  73,  85,  91,  98, 102, // 98424-98431
110,  93, 117, 167, 180, 156, 152, 138, // 98432-98439
152, 167, 139, 134, 108, 106, 139, 135, // 98440-98447
121, 150, 187, 204, 196, 212, 205, 162, // 98448-98455
157, 117,  87,  73,  67,  70,  65,  46, // 98456-98463
 69, 117, 138, 149, 144, 144, 151, 179, // 98464-98471
154,  88,  51,  42,  39,  57,  66,  67, // 98472-98479
 97, 113, 156, 184, 199, 195, 202, 207, // 98480-98487
166, 156, 162, 138, 113,  88,  67, 108, // 98488-98495
144, 168, 169, 152, 161, 183, 198, 169, // 98496-98503
135, 119, 104,  97, 121,  88,  56,  78, // 98504-98511
 85,  98,  99, 109, 133, 126, 105, 101, // 98512-98519
 94, 102,  97, 109, 104,  93, 145, 161, // 98520-98527
146, 142, 141, 137, 157, 162, 142, 115, // 98528-98535
112, 143, 149, 135, 126, 158, 186, 190, // 98536-98543
205, 203, 157, 144, 141, 108,  88,  76, // 98544-98551
 81,  65,  69,  81,  98, 131, 141, 145, // 98552-98559
141, 135, 164, 174, 110,  65,  45,  46, // 98560-98567
 55,  71,  79,  71,  96, 146, 179, 190, // 98568-98575
194, 180, 202, 185, 164, 165, 132, 117, // 98576-98583
103,  81,  87, 122, 157, 166, 149, 170, // 98584-98591
177, 189, 192, 151, 129, 108, 104, 118, // 98592-98599
104,  58,  60,  78,  95, 102, 105, 115, // 98600-98607
119, 132, 123, 107, 102,  99, 100, 111, // 98608-98615
 99, 119, 141, 133, 138, 136, 141, 139, // 98616-98623
165, 158, 121, 119, 142, 155, 151, 130, // 98624-98631
132, 165, 180, 204, 195, 162, 136, 141, // 98632-98639
135, 107,  90,  87,  70,  72, 103,  94, // 98640-98647
115, 132, 139, 141, 129, 150, 168, 134, // 98648-98655
 85,  58,  51,  60,  65,  89,  68,  74, // 98656-98663
133, 166, 182, 185, 178, 177, 190, 178, // 98664-98671
169, 133, 113, 110,  97,  89,  99, 141, // 98672-98679
154, 150, 170, 185, 178, 193, 172, 141, // 98680-98687
117, 111, 119, 102,  80,  52,  70,  92, // 98688-98695
104, 111, 109, 108, 138, 147, 122, 109, // 98696-98703
 99, 102, 101, 111, 112, 115, 120, 128, // 98704-98711
132, 140, 138, 147, 167, 131, 129, 143, // 98712-98719
152, 156, 139, 125, 137, 163, 193, 189, // 98720-98727
160, 144, 130, 146, 129, 106,  97,  77, // 98728-98735
 79, 108, 112, 102, 121, 131, 138, 130, // 98736-98743
145, 156, 140, 112,  76,  64,  64,  70, // 98744-98751
 84,  81,  67, 114, 151, 170, 175, 175, // 98752-98759
170, 171, 193, 175, 139, 114, 112, 107, // 98760-98767
100,  93, 119, 139, 145, 169, 183, 182, // 98768-98775
175, 181, 158, 129, 120, 124,  99,  87, // 98776-98783
 71,  59,  88,  98, 115, 107, 103, 133, // 98784-98791
157, 144, 120, 103, 101,  99, 107, 124, // 98792-98799
 99, 102, 117, 126, 135, 140, 141, 152, // 98800-98807
147, 138, 150, 148, 156, 143, 132, 124, // 98808-98815
142, 180, 180, 157, 147, 134, 135, 146, // 98816-98823
125, 110,  85,  89, 108, 121, 113, 104, // 98824-98831
122, 128, 131, 139, 146, 132, 125,  99, // 98832-98839
 79,  73,  75,  84,  80,  82, 100, 136, // 98840-98847
157, 166, 165, 169, 158, 183, 186, 142, // 98848-98855
123, 111, 116, 108, 102, 107, 119, 136, // 98856-98863
167, 179, 182, 174, 169, 173, 142, 133, // 98864-98871
128, 105,  85,  83,  68,  74,  93, 108, // 98872-98879
109,  97, 129, 152, 158, 137, 113, 104, // 98880-98887
101, 106, 123, 104,  84, 102, 114, 130, // 98888-98895
135, 146, 140, 145, 156, 159, 155, 152, // 98896-98903
151, 136, 125, 126, 159, 162, 150, 143, // 98904-98911
139, 134, 139, 145, 123,  98,  98, 115, // 98912-98919
117, 124, 106, 109, 119, 124, 140, 132, // 98920-98927
125, 121, 116,  96,  83,  80,  86,  75, // 98928-98935
 89, 106, 118, 144, 153, 162, 163, 162, // 98936-98943
169, 183, 153, 129, 118, 116, 118, 106, // 98944-98951
110, 103, 125, 158, 177, 179, 177, 165, // 98952-98959
169, 159, 144, 135, 106,  89,  81,  83, // 98960-98967
 69,  83, 102, 102, 100, 123, 151, 159, // 98968-98975
154, 128, 115, 102, 108, 114, 105,  84, // 98976-98983
 85, 106, 118, 130, 143, 143, 134, 165, // 98984-98991
170, 165, 157, 152, 146, 126, 126, 140, // 98992-98999
148, 140, 140, 137, 140, 133, 146, 138, // 99000-99007
107, 111, 120, 120, 119, 117, 103, 111, // 99008-99015
119, 138, 129, 116, 121, 118, 114,  94, // 99016-99023
 91,  87,  78,  86, 115, 116, 129, 145, // 99024-99031
153, 158, 160, 173, 169, 161, 137, 125, // 99032-99039
117, 118, 113, 107,  98, 108, 150, 167, // 99040-99047
178, 176, 173, 163, 163, 159, 141, 114, // 99048-99055
 92,  82,  81,  82,  72,  95,  95, 103, // 99056-99063
122, 143, 157, 156, 146, 125, 111, 112, // 99064-99071
117, 100,  94,  82,  95, 112, 123, 138, // 99072-99079
140, 135, 155, 179, 167, 162, 150, 150, // 99080-99087
132, 127, 136, 129, 133, 134, 137, 137, // 99088-99095
136, 137, 142, 119, 119, 125, 123, 118, // 99096-99103
116, 113,  99, 115, 130, 128, 110, 117, // 99104-99111
120, 121, 111,  98,  95,  81,  91, 110, // 99112-99119
123, 119, 133, 146, 152, 155, 173, 164, // 99120-99127
151, 151, 130, 125, 116, 122, 112,  99, // 99128-99135
106, 133, 160, 169, 170, 169, 164, 152, // 99136-99143
168, 149, 118, 100,  90,  84,  87,  83, // 99144-99151
 84,  93, 100, 124, 132, 152, 152, 150, // 99152-99159
138, 114, 117, 117, 100,  91,  92,  86, // 99160-99167
104, 117, 134, 134, 137, 151, 170, 177, // 99168-99175
162, 154, 147, 140, 128, 135, 121, 120, // 99176-99183
131, 134, 138, 138, 142, 137, 134, 131, // 99184-99191
132, 126, 124, 114, 119, 104, 104, 128, // 99192-99199
122, 113, 108, 122, 121, 121, 113,  99, // 99200-99207
 85,  95, 109, 119, 124, 118, 137, 143, // 99208-99215
149, 163, 162, 142, 146, 141, 129, 121, // 99216-99223
122, 123,  99, 110, 126, 146, 162, 165, // 99224-99231
166, 165, 156, 163, 160, 126, 108,  96, // 99232-99239
 93,  86,  92,  86,  82,  98, 123, 132, // 99240-99247
140, 154, 149, 147, 127, 122, 118, 102, // 99248-99255
 92,  92,  93,  92, 111, 127, 129, 132, // 99256-99263
154, 159, 174, 169, 155, 148, 140, 139, // 99264-99271
129, 121, 111, 122, 132, 136, 135, 144, // 99272-99279
136, 132, 144, 139, 132, 127, 120, 116, // 99280-99287
114, 106, 117, 116, 113, 108, 114, 127, // 99288-99295
118, 123, 108,  93, 101, 114, 116, 123, // 99296-99303
121, 123, 135, 145, 157, 152, 144, 135, // 99304-99311
142, 137, 127, 122, 124, 109, 107, 129, // 99312-99319
134, 151, 158, 163, 158, 159, 159, 155, // 99320-99327
138, 116, 103,  98,  93,  91,  98,  82, // 99328-99335
 96, 119, 133, 135, 145, 151, 144, 140, // 99336-99343
131, 120, 102,  96,  89,  96,  96, 101, // 99344-99351
119, 124, 131, 150, 161, 163, 170, 160, // 99352-99359
152, 140, 147, 133, 115, 112, 110, 123, // 99360-99367
131, 135, 137, 137, 130, 145, 148, 138, // 99368-99375
129, 124, 120, 115, 118, 114, 110, 107, // 99376-99383
109, 107, 118, 120, 118, 116, 107, 112, // 99384-99391
119, 123, 121, 125, 126, 128, 136, 143, // 99392-99399
139, 136, 135, 133, 136, 133, 129, 125, // 99400-99407
125, 122, 127, 133, 135, 137, 140, 141, // 99408-99415
143, 144, 137, 132, 128, 122, 117, 116, // 99416-99423
112, 110, 111, 114, 119, 125, 129, 128, // 99424-99431
133, 134, 133, 132, 128, 124, 120, 117, // 99432-99439
116, 118, 117, 117, 121, 127, 131, 136, // 99440-99447
139, 138, 137, 139, 138, 135, 132, 125, // 99448-99455
123, 123, 122, 122, 123, 123, 126, 130, // 99456-99463
130, 133, 135, 133, 129, 128, 126, 124, // 99464-99471
123, 120, 119, 119, 121, 122, 126, 125, // 99472-99479
125, 129, 132, 131, 130, 127, 125, 125, // 99480-99487
126, 124, 125, 125, 127, 130, 130, 130, // 99488-99495
130, 131, 129, 130, 129, 127, 128, 128, // 99496-99503
126, 125, 128, 130, 130, 130, 128, 128, // 99504-99511
129, 127, 124, 122, 119, 120, 123, 123, // 99512-99519
123, 125, 127, 128, 130, 131, 130, 130, // 99520-99527
130, 128, 125, 122, 123, 122, 121, 123, // 99528-99535
127, 128, 131, 134, 135, 134, 135, 135, // 99536-99543
131, 128, 126, 124, 124, 123, 122, 121, // 99544-99551
123, 127, 131, 131, 130, 132, 132, 130, // 99552-99559
128, 126, 123, 120, 121, 120, 121, 122, // 99560-99567
124, 126, 127, 128, 131, 133, 131, 130, // 99568-99575
127, 126, 126, 127, 124, 123, 125, 128, // 99576-99583
130, 132, 132, 131, 131, 130, 131, 129, // 99584-99591
128, 126, 128, 125, 124, 126, 126, 127, // 99592-99599
126, 127, 129, 129, 128, 126, 123, 123, // 99600-99607
123, 124, 124, 123, 126, 126, 128, 129, // 99608-99615
129, 127, 128, 128, 129, 126, 124, 125, // 99616-99623
124, 123, 125, 128, 129, 130, 132, 133, // 99624-99631
132, 133, 132, 128, 127, 125, 125, 124, // 99632-99639
123, 122, 122, 123, 127, 130, 129, 128, // 99640-99647
131, 133, 130, 130, 126, 124, 122, 123, // 99648-99655
123, 123, 123, 124, 126, 126, 128, 130, // 99656-99663
132, 131, 130, 128, 127, 127, 128, 123, // 99664-99671
122, 124, 125, 128, 128, 129, 129, 130, // 99672-99679
130, 131, 129, 127, 127, 128, 127, 125, // 99680-99687
126, 125, 126, 127, 127, 127, 128, 129, // 99688-99695
128, 126, 125, 126, 125, 125, 124, 126, // 99696-99703
127, 128, 128, 127, 126, 127, 129, 129, // 99704-99711
126, 124, 125, 126, 127, 127, 126, 126, // 99712-99719
126, 130, 130, 131, 130, 130, 127, 127, // 99720-99727
127, 127, 127, 125, 125, 124, 125, 127, // 99728-99735
128, 127, 126, 127, 130, 130, 130, 127, // 99736-99743
125, 124, 125, 125, 124, 124, 124, 126, // 99744-99751
127, 128, 129, 129, 130, 130, 130, 128, // 99752-99759
129, 129, 127, 125, 126, 126, 128, 127, // 99760-99767
127, 128, 128, 130, 129, 127, 125, 127, // 99768-99775
130, 129, 127, 126, 125, 126, 127, 126, // 99776-99783
126, 126, 127, 128, 127, 126, 126, 126, // 99784-99791
123, 123, 125, 128, 128, 129, 127, 125, // 99792-99799
127, 129, 129, 128, 125, 126, 129, 129, // 99800-99807
128, 127, 125, 125, 129, 130, 129, 129, // 99808-99815
129, 127, 127, 127, 126, 127, 127, 127, // 99816-99823
126, 127, 126, 129, 127, 125, 126, 129, // 99824-99831
129, 127, 126, 123, 124, 126, 126, 124, // 99832-99839
124, 126, 129, 130, 128, 126, 127, 127, // 99840-99847
128, 129, 126, 127, 128, 127, 125, 127, // 99848-99855
128, 127, 128, 127, 129, 130, 131, 129, // 99856-99863
126, 124, 125, 129, 129, 127, 125, 125, // 99864-99871
126, 129, 129, 126, 125, 127, 127, 128, // 99872-99879
127, 125, 126, 125, 123, 126, 128, 128, // 99880-99887
128, 127, 126, 125, 128, 127, 126, 125, // 99888-99895
126, 128, 129, 128, 127, 126, 126, 129, // 99896-99903
131, 129, 127, 129, 129, 127, 127, 125, // 99904-99911
124, 126, 128, 127, 129, 128, 127, 128, // 99912-99919
126, 127, 128, 129, 126, 126, 124, 124, // 99920-99927
126, 127, 124, 123, 126, 128, 130, 129, // 99928-99935
127, 125, 127, 127, 127, 126, 125, 126, // 99936-99943
126, 126, 126, 128, 127, 129, 130, 130, // 99944-99951
130, 132, 130, 127, 125, 125, 127, 128, // 99952-99959
129, 126, 126, 126, 128, 129, 127, 126, // 99960-99967
127, 127, 128, 128, 125, 125, 125, 126, // 99968-99975
125, 125, 127, 128, 128, 125, 125, 124, // 99976-99983
126, 126, 126, 126, 127, 128, 130, 128, // 99984-99991
127, 127, 127, 129, 128, 127, 126, 128, // 99992-99999
128, 127, 126, 126, 128, 129, 131, 129, // 100000-100007
129, 129, 129, 127, 126, 126, 126, 126, // 100008-100015
126, 125, 125, 126, 126, 126, 126, 126, // 100016-100023
128, 131, 130, 127, 125, 124, 125, 125, // 100024-100031
125, 124, 125, 126, 126, 127, 127, 127, // 100032-100039
130, 130, 129, 131, 130, 130, 129, 126, // 100040-100047
123, 125, 128, 128, 128, 125, 126, 128, // 100048-100055
130, 127, 127, 127, 127, 128, 129, 127, // 100056-100063
126, 125, 125, 125, 124, 125, 126, 127, // 100064-100071
125, 126, 126, 125, 127, 126, 126, 126, // 100072-100079
129, 129, 129, 128, 126, 127, 128, 128, // 100080-100087
127, 127, 126, 127, 128, 126, 125, 128, // 100088-100095
128, 129, 132, 131, 130, 130, 129, 127, // 100096-100103
126, 126, 126, 125, 124, 124, 125, 125, // 100104-100111
126, 127, 127, 127, 130, 131, 129, 127, // 100112-100119
126, 124, 125, 126, 124, 123, 124, 126, // 100120-100127
127, 128, 128, 130, 130, 129, 131, 131, // 100128-100135
129, 128, 128, 124, 124, 126, 127, 127, // 100136-100143
128, 127, 128, 130, 130, 129, 127, 126, // 100144-100151
126, 128, 127, 125, 125, 124, 123, 126, // 100152-100159
128, 126, 128, 128, 127, 126, 127, 127, // 100160-100167
127, 126, 125, 127, 128, 128, 129, 127, // 100168-100175
125, 128, 129, 129, 127, 126, 126, 127, // 100176-100183
128, 127, 127, 127, 129, 131, 132, 130, // 100184-100191
130, 130, 127, 126, 126, 125, 124, 125, // 100192-100199
123, 124, 125, 128, 129, 128, 128, 129, // 100200-100207
130, 130, 128, 125, 122, 121, 124, 123, // 100208-100215
121, 124, 125, 127, 129, 130, 130, 130, // 100216-100223
130, 131, 130, 128, 126, 125, 124, 123, // 100224-100231
125, 127, 127, 128, 129, 129, 131, 132, // 100232-100239
131, 129, 127, 126, 127, 127, 124, 124, // 100240-100247
123, 123, 126, 128, 126, 127, 128, 128, // 100248-100255
128, 128, 127, 125, 124, 125, 125, 127, // 100256-100263
127, 127, 128, 125, 127, 130, 128, 127, // 100264-100271
126, 125, 125, 127, 128, 127, 126, 128, // 100272-100279
130, 131, 131, 130, 129, 127, 125, 127, // 100280-100287
124, 123, 124, 125, 124, 126, 128, 128, // 100288-100295
129, 131, 131, 130, 131, 128, 126, 123, // 100296-100303
122, 122, 122, 120, 123, 124, 127, 129, // 100304-100311
133, 131, 131, 131, 133, 130, 130, 126, // 100312-100319
133, 168, 159, 124,  77,  76,  44,  31, // 100320-100327
 73, 100, 155, 225,  32,  64, 214, 164, // 100328-100335
180,  93,  44,  20,  45,  24,  79, 228, // 100336-100343
224, 147, 166, 153,  98, 173, 197, 225, // 100344-100351
249, 209, 187, 144, 131, 222,  76, 170, // 100352-100359
199, 232,  21, 221,  69,  90, 179, 238, // 100360-100367
164, 170, 103,  35,  19,  27, 246,  64, // 100368-100375
146, 188, 201, 213, 187,  15,  22, 147, // 100376-100383
 46,  43, 142, 113, 200, 151, 182,  48, // 100384-100391
 52, 116,  96, 211, 130, 138,  79, 235, // 100392-100399
207,  48,  12,  53,  74, 118, 200, 155, // 100400-100407
136, 106, 105,  77, 190, 166,  44, 247, // 100408-100415
202, 246,  29, 254, 169, 217, 117, 175, // 100416-100423
186,  34,  38,  90,  49,  33,  48, 142, // 100424-100431
 64,  21,  53, 205, 219, 168, 236, 248, // 100432-100439
 49,  70, 103,  74, 189, 110,  50,  51, // 100440-100447
 23,  47, 253, 252,  51,  89, 139, 109, // 100448-100455
 44, 228, 141, 149,  24,  39,  79, 101, // 100456-100463
107,  99, 160, 161,  93,  93,  78, 123, // 100464-100471
 62, 164, 234, 153, 166, 207,  14,  13, // 100472-100479
190,  56, 102, 199, 247, 246, 249, 217, // 100480-100487
215, 213, 161, 115,  24, 212, 192,  48, // 100488-100495
246,  22, 151, 200, 213, 179, 226, 227, // 100496-100503
189,  44, 182, 164, 155, 145,  11,   3, // 100504-100511
 16, 158,   1,  73,   5, 236, 196, 237, // 100512-100519
229, 159, 134, 132, 126, 132, 125,  67, // 100520-100527
120, 135, 137, 211, 255, 202,  26,  54, // 100528-100535
240, 162, 147, 197,  68, 247, 161, 184, // 100536-100543
250, 237,  56, 110,  77, 166,  23, 237, // 100544-100551
134,  33,  16, 240,  38,  17,  21, 107, // 100552-100559
152, 176, 180, 229, 207, 199, 111,  94, // 100560-100567
140, 126, 147, 231, 204, 131, 210,  82, // 100568-100575
 74, 197, 159, 101, 145,  97,  42,  79, // 100576-100583
 41,  68, 107, 162, 126,  90, 107, 105, // 100584-100591
101, 124,  77, 136, 185,  87,  16,   8, // 100592-100599
 35, 241, 218, 181,  35, 122, 158, 243, // 100600-100607
 23,  40, 255,  73,  61, 151,  71,  44, // 100608-100615
 41,  74, 240,  32, 148, 205,  39,  64, // 100616-100623
106,  17, 250, 197, 108,  90,  55,  35, // 100624-100631
 40,  43, 250,  43, 118, 115,  51,  21, // 100632-100639
 47, 170, 169, 114, 108, 100,  89,  87, // 100640-100647
180,  71,  11,  45,  70, 110,  88, 130, // 100648-100655
189, 216, 223, 219, 252, 242, 162, 169, // 100656-100663
 64,  74, 172, 193, 224, 220, 218, 180, // 100664-100671
238, 199,  83, 248, 250,  55,  52,  55, // 100672-100679
 76, 143, 180, 169, 221, 209,  70, 110, // 100680-100687
 69, 252, 196, 172,   3,   4,  63,  83, // 100688-100695
167, 254, 225, 201, 193, 178, 213, 213, // 100696-100703
162, 137, 126, 122, 132, 174,  61,  27, // 100704-100711
 93, 196, 239, 218,   4,   9,  52, 226, // 100712-100719
189, 194,  83, 252, 230, 214, 208, 224, // 100720-100727
 61, 100, 101, 154, 172,  44, 228,  93, // 100728-100735
 43,   4,  32,  34,  33,  20,  81, 131, // 100736-100743
160, 198, 208, 138, 121, 171, 180, 135, // 100744-100751
151, 191, 216, 211, 118, 220, 244, 176, // 100752-100759
153, 131, 141, 102, 140, 140,  86, 100, // 100760-100767
126, 148, 171,  79,  49,  71, 105, 124, // 100768-100775
 95,  93, 105, 182, 122,  71,  57,   5, // 100776-100783
206, 230,  52,  41,  97, 187, 243,   1, // 100784-100791
245,   9,  50, 202, 109,  59,  64,  61, // 100792-100799
 51, 102,  42, 124, 235,  38,  79,  28, // 100800-100807
218, 195, 192, 156,  89,  51,  59,  49, // 100808-100815
 61,  29,  65,  92,  54,  38,  92, 116, // 100816-100823
119, 209, 176, 134,  90,  96, 136,  89, // 100824-100831
  9, 230,  28,  89,  86, 127, 175, 161, // 100832-100839
250,   6,   2, 224, 158, 141, 129, 120, // 100840-100847
 67, 108, 173, 209, 210, 205, 202, 217, // 100848-100855
162,  64,  49,  79,  65,  63, 116, 102, // 100856-100863
115, 141, 203, 185,  97,  49,  62, 122, // 100864-100871
 32, 239,  14,  15,  53, 113, 128, 158, // 100872-100879
159, 168, 167, 172, 199, 155, 188, 183, // 100880-100887
148, 128, 130, 155, 136,  43,  12, 137, // 100888-100895
195, 206, 243,  18, 255, 246, 254, 219, // 100896-100903
102,  29, 252, 249,  13, 209,  25,  82, // 100904-100911
110, 162, 178, 202, 220, 192, 104,  44, // 100912-100919
 47,  31,   9,  55,  47,  66, 114, 172, // 100920-100927
188, 139, 117, 147, 218, 178, 159, 181, // 100928-100935
191, 184, 189, 179, 126, 122, 132, 138, // 100936-100943
152, 130, 124, 178, 156, 151, 141, 152, // 100944-100951
153,  99,  83,  28,  69, 111,  89, 105, // 100952-100959
115, 112, 155, 163, 120,  40, 227, 247, // 100960-100967
 44,  72,  49, 114, 184, 218, 220,   2, // 100968-100975
  1, 171, 160, 109,  90,  73,  56, 104, // 100976-100983
114,  92, 138, 217,  32,   7, 220, 197, // 100984-100991
167, 209, 148,  95,  84,  74,  65,  64, // 100992-100999
 90,  51,  23,  43,  99, 127, 111, 132, // 101000-101007
216, 207, 136, 114, 126,  71,  14,  14, // 101008-101015
245,  39,  63, 119, 157, 174, 214, 229, // 101016-101023
 29, 242, 164, 138, 112, 139, 128,  51, // 101024-101031
 95, 157, 192, 197, 213, 219, 145, 130, // 101032-101039
121, 118,  86,  77, 105, 130, 117,  94, // 101040-101047
157, 158,  99,  76,  54,  76, 110,  82, // 101048-101055
 69,  40,  70,  94, 119, 157,  98, 110, // 101056-101063
125, 158, 185, 155, 152, 178, 196, 159, // 101064-101071
138, 157, 121,  78,  74,  72, 120, 156, // 101072-101079
214, 253,   1, 231, 234,   4, 153,  75, // 101080-101087
 29,  21,  19,  11,  36,  37,  92, 149, // 101088-101095
165, 201, 172, 149, 169, 115,  97,  45, // 101096-101103
 20,  43,  62,  79,  58, 122, 156, 124, // 101104-101111
119, 157, 176, 179, 195, 196, 190, 173, // 101112-101119
172, 202, 145,  57,  78, 110, 149, 136, // 101120-101127
152, 163, 160, 213, 182, 171, 156, 104, // 101128-101135
 80,  66,  69,  68,  65,  97, 117, 125, // 101136-101143
117, 144, 191, 104,  27,  20,  53,  56, // 101144-101151
 66, 103, 119, 158, 183, 227, 227, 170, // 101152-101159
129, 130, 140, 105,  81, 104, 108, 142, // 101160-101167
146, 133, 208, 212, 206, 187, 186, 191, // 101168-101175
151, 150, 129, 103,  87,  74,  95,  89, // 101176-101183
 17,  23,  89, 120, 116, 133, 162, 192, // 101184-101191
201, 163, 142,  75,  27,   6,  24,  37, // 101192-101199
 18,  83, 129, 159, 206, 215, 233, 247, // 101200-101207
198, 152, 121, 138, 124,  97,  93,  89, // 101208-101215
142, 167, 200, 213, 160, 120, 148, 171, // 101216-101223
127,  99, 115, 123, 117, 127, 126, 115, // 101224-101231
 90,  78,  74,  83,  74, 101, 131,  91, // 101232-101239
100,  98, 112, 131, 115,  91,  76, 126, // 101240-101247
162, 139, 151, 165, 164, 186, 170, 168, // 101248-101255
125,  78,  93, 119, 102,  92, 158, 214, // 101256-101263
234, 230, 243, 222, 177, 134,  80,  58, // 101264-101271
 45,  25,  49,  65,  69, 119, 146, 183, // 101272-101279
171, 138, 126, 143, 162,  90,  47,  53, // 101280-101287
 58,  72,  83,  94, 104,  92, 109, 146, // 101288-101295
173, 161, 162, 214, 205, 182, 178, 184, // 101296-101303
154, 105,  59,  62, 116, 127, 146, 163, // 101304-101311
169, 190, 208, 209, 178, 121,  95,  70, // 101312-101319
 94,  92,  36,  75, 105, 125, 127, 127, // 101320-101327
154, 136,  94,  71,  71,  62,  54,  87, // 101328-101335
123, 115, 138, 185, 198, 162, 140, 121, // 101336-101343
128, 144, 112, 114, 109, 139, 165, 159, // 101344-101351
159, 150, 166, 168, 181, 199, 154, 135, // 101352-101359
164, 149, 124,  96, 110,  88,  51,  53, // 101360-101367
 56,  96, 101, 125, 153, 155, 169, 196, // 101368-101375
181, 110,  52,  23,  22,  43,  46,  48, // 101376-101383
 85, 135, 190, 199, 225, 212, 183, 184, // 101384-101391
144, 152, 121,  97, 119, 112, 105, 120, // 101392-101399
166, 197, 157, 142, 150, 158, 166, 137, // 101400-101407
135, 128, 121, 124, 141, 115,  60,  65, // 101408-101415
 68,  91,  85,  82, 114, 135, 148, 125, // 101416-101423
116, 125,  99,  93,  83,  86, 121, 112, // 101424-101431
141, 159, 167, 161, 169, 202, 145, 100, // 101432-101439
 98, 119, 127, 104, 112, 158, 192, 219, // 101440-101447
231, 222, 171, 135, 127, 100,  79,  49, // 101448-101455
 61,  67, 102, 117, 109, 155, 153, 140, // 101456-101463
119, 116, 152, 132,  94,  83,  70,  78, // 101464-101471
 73, 104, 105,  57,  85, 126, 159, 156, // 101472-101479
161, 179, 199, 208, 188, 180, 143, 115, // 101480-101487
 93,  71,  75,  96, 128, 156, 170, 202, // 101488-101495
192, 203, 212, 152, 115,  82,  99,  90, // 101496-101503
 68,  71,  75, 110, 119, 133, 142, 112, // 101504-101511
107, 123, 112,  89,  65,  90, 108, 122, // 101512-101519
131, 134, 153, 140, 133, 123, 128, 121, // 101520-101527
131, 143, 129, 148, 154, 164, 172, 139, // 101528-101535
120, 130, 160, 187, 151, 149, 152, 157, // 101536-101543
164, 128, 129,  97,  61,  68,  89,  85, // 101544-101551
 79, 110, 145, 155, 155, 171, 180, 151, // 101552-101559
 94,  55,  38,  48,  43,  65,  75,  97, // 101560-101567
153, 172, 204, 199, 174, 152, 159, 174, // 101568-101575
133, 102, 115, 124, 124, 110, 125, 158, // 101576-101583
142, 148, 156, 168, 153, 151, 172, 152, // 101584-101591
137, 131, 132, 117,  91,  54,  54,  81, // 101592-101599
 91,  93, 100, 126, 163, 165, 145, 135, // 101600-101607
102,  89,  76, 101, 100,  72, 112, 139, // 101608-101615
159, 161, 158, 172, 162, 129, 122, 121, // 101616-101623
127, 120, 123, 136, 143, 180, 203, 204, // 101624-101631
171, 142, 119, 125, 122,  89,  79,  81, // 101632-101639
106, 124, 127, 127, 128, 124, 120, 121, // 101640-101647
137, 120, 115, 125, 102,  93,  80, 100, // 101648-101655
 97,  75,  74,  95, 134, 144, 153, 178, // 101656-101663
179, 183, 206, 186, 153, 114,  99,  94, // 101664-101671
 90,  84,  92, 128, 163, 195, 193, 200, // 101672-101679
190, 174, 148, 111, 113,  94,  65,  84, // 101680-101687
 92,  85, 100, 120, 143, 109, 103, 124, // 101688-101695
136, 131,  94,  99, 106, 111, 126, 135, // 101696-101703
119, 107, 111, 119, 128, 134, 123, 129, // 101704-101711
156, 164, 160, 153, 170, 150, 125, 111, // 101712-101719
128, 159, 141, 146, 156, 156, 151, 153, // 101720-101727
158, 116,  76,  84,  89, 103,  91,  86, // 101728-101735
126, 138, 159, 158, 157, 146, 122, 100, // 101736-101743
 71,  62,  54,  57,  75, 108, 121, 138, // 101744-101751
174, 185, 168, 157, 147, 165, 151, 117, // 101752-101759
122, 117, 131, 120, 127, 130, 111, 137, // 101760-101767
158, 168, 162, 147, 160, 173, 158, 146, // 101768-101775
130, 118,  91,  84,  75,  68,  85,  90, // 101776-101783
105, 117, 149, 157, 164, 159, 118,  92, // 101784-101791
 83,  96, 100,  75,  82, 113, 139, 152, // 101792-101799
157, 175, 140, 134, 152, 138, 132, 111, // 101800-101807
129, 135, 134, 148, 162, 178, 169, 148, // 101808-101815
139, 127, 124, 121, 104, 100, 113, 125, // 101816-101823
124, 145, 129, 106, 113, 124, 138, 104, // 101824-101831
108, 125, 129, 121,  97, 105,  97,  73, // 101832-101839
 94, 103, 104, 116, 131, 161, 163, 176, // 101840-101847
175, 178, 169, 129, 110, 101, 107,  94, // 101848-101855
 90, 101, 136, 174, 184, 192, 193, 163, // 101856-101863
148, 147, 138, 106,  75,  90,  94, 111, // 101864-101871
100, 108, 132, 113, 116, 122, 135, 131, // 101872-101879
120, 121, 111, 108, 122, 119, 124, 106, // 101880-101887
 89, 106, 120, 129, 121, 126, 136, 168, // 101888-101895
174, 163, 164, 148, 134, 115, 125, 124, // 101896-101903
111, 132, 150, 154, 157, 146, 164, 147, // 101904-101911
110, 108, 102, 106,  93, 105, 110, 114, // 101912-101919
139, 149, 145, 134, 123, 113, 110,  97, // 101920-101927
 76,  65,  83, 106, 130, 129, 139, 157, // 101928-101935
152, 149, 149, 157, 127, 128, 138, 130, // 101936-101943
129, 127, 138, 128, 109, 115, 137, 155, // 101944-101951
157, 145, 162, 152, 164, 170, 143, 126, // 101952-101959
 99,  88,  85,  92,  80,  78,  96, 125, // 101960-101967
142, 148, 160, 161, 146, 115,  96, 101, // 101968-101975
 94,  72,  96, 100, 110, 130, 146, 164, // 101976-101983
142, 136, 140, 153, 148, 125, 126, 138, // 101984-101991
136, 144, 144, 141, 146, 140, 140, 134, // 101992-101999
135, 116, 121, 132, 134, 130, 127, 136, // 102000-102007
132, 119,  97, 110, 122, 105, 101, 121, // 102008-102015
128, 131, 129, 126, 107,  85,  97, 102, // 102016-102023
117, 103, 107, 139, 150, 167, 170, 161, // 102024-102031
152, 144, 127, 116, 109, 111,  94, 104, // 102032-102039
127, 142, 163, 179, 184, 165, 148, 137, // 102040-102047
152, 126,  94,  96,  99, 105, 110, 120, // 102048-102055
115, 104, 114, 126, 126, 134, 121, 132, // 102056-102063
134, 123, 125, 115, 115, 103, 101,  92, // 102064-102071
 99, 117, 119, 124, 144, 157, 163, 174, // 102072-102079
170, 153, 131, 128, 123, 120,  98, 108, // 102080-102087
134, 148, 154, 152, 161, 136, 135, 132, // 102088-102095
119, 113, 100, 102, 121, 120, 125, 133, // 102096-102103
135, 133, 114, 121, 113, 114, 104,  82, // 102104-102111
 92, 110, 123, 128, 143, 133, 131, 133, // 102112-102119
144, 149, 131, 117, 134, 144, 140, 133, // 102120-102127
137, 137, 106, 120, 121, 132, 141, 140, // 102128-102135
157, 157, 162, 160, 158, 142, 114,  97, // 102136-102143
 94,  90,  97,  82,  87, 116, 135, 145, // 102144-102151
146, 163, 143, 133, 122, 114,  99,  80, // 102152-102159
 91, 104, 115, 111, 128, 145, 136, 135, // 102160-102167
144, 138, 149, 139, 138, 141, 140, 150, // 102168-102175
131, 135, 123, 119, 130, 131, 135, 127, // 102176-102183
120, 135, 155, 148, 138, 134, 128, 113, // 102184-102191
114, 109, 107,  98, 103, 116, 123, 136, // 102192-102199
129, 137, 122, 108, 113, 111, 112, 111, // 102200-102207
111, 118, 127, 141, 146, 144, 142, 129, // 102208-102215
134, 134, 130, 124, 117, 124, 127, 136, // 102216-102223
135, 141, 141, 137, 136, 136, 133, 126, // 102224-102231
124, 125, 124, 123, 124, 126, 127, 119, // 102232-102239
121, 121, 122, 122, 119, 127, 126, 132, // 102240-102247
131, 128, 129, 123, 122, 125, 122, 118, // 102248-102255
117, 123, 129, 131, 134, 133, 136, 133, // 102256-102263
133, 132, 129, 124, 120, 123, 124, 129, // 102264-102271
130, 130, 132, 130, 129, 131, 129, 127, // 102272-102279
122, 122, 125, 127, 131, 127, 127, 124, // 102280-102287
123, 128, 127, 125, 123, 125, 128, 128, // 102288-102295
129, 131, 129, 127, 126, 127, 127, 124, // 102296-102303
124, 124, 126, 126, 132, 133, 132, 129, // 102304-102311
127, 129, 126, 124, 121, 121, 123, 125, // 102312-102319
127, 128, 128, 130, 128, 131, 132, 127, // 102320-102327
127, 125, 128, 125, 124, 126, 126, 125, // 102328-102335
124, 127, 130, 127, 126, 129, 130, 131, // 102336-102343
131, 132, 130, 127, 124, 126, 126, 122, // 102344-102351
121, 121, 125, 127, 130, 131, 130, 132, // 102352-102359
129, 127, 130, 127, 122, 120, 122, 124, // 102360-102367
124, 127, 128, 128, 127, 127, 132, 132, // 102368-102375
128, 127, 128, 126, 128, 130, 128, 127, // 102376-102383
126, 127, 129, 129, 127, 126, 126, 127, // 102384-102391
130, 131, 128, 129, 128, 125, 127, 127, // 102392-102399
125, 123, 125, 126, 126, 127, 128, 126, // 102400-102407
125, 125, 126, 127, 124, 124, 126, 127, // 102408-102415
128, 132, 132, 131, 130, 130, 130, 126, // 102416-102423
124, 121, 121, 123, 124, 127, 128, 128, // 102424-102431
132, 132, 132, 134, 131, 127, 126, 126, // 102432-102439
125, 123, 124, 122, 121, 122, 126, 129, // 102440-102447
129, 125, 128, 130, 129, 131, 132, 127, // 102448-102455
124, 125, 125, 125, 124, 123, 123, 125, // 102456-102463
128, 131, 134, 133, 133, 131, 129, 129, // 102464-102471
129, 124, 121, 123, 124, 124, 126, 130, // 102472-102479
128, 128, 129, 132, 131, 126, 124, 126, // 102480-102487
125, 123, 125, 126, 126, 125, 129, 127, // 102488-102495
127, 127, 125, 125, 125, 125, 125, 126, // 102496-102503
125, 128, 126, 127, 130, 130, 127, 127, // 102504-102511
132, 131, 128, 129, 127, 125, 127, 128, // 102512-102519
129, 125, 124, 127, 128, 130, 130, 132, // 102520-102527
130, 128, 129, 127, 124, 123, 120, 118, // 102528-102535
120, 123, 128, 129, 129, 129, 130, 131, // 102536-102543
131, 130, 125, 120, 122, 124, 122, 124, // 102544-102551
125, 125, 126, 131, 133, 134, 132, 131, // 102552-102559
130, 129, 129, 128, 128, 123, 123, 126, // 102560-102567
124, 125, 127, 127, 127, 129, 130, 132, // 102568-102575
130, 128, 125, 126, 125, 123, 122, 121, // 102576-102583
123, 126, 127, 126, 129, 128, 129, 128, // 102584-102591
130, 127, 124, 123, 124, 125, 126, 127, // 102592-102599
130, 129, 128, 133, 134, 131, 129, 126, // 102600-102607
125, 124, 127, 128, 126, 125, 125, 128, // 102608-102615
130, 131, 130, 127, 125, 128, 128, 125, // 102616-102623
125, 125, 123, 122, 126, 129, 126, 125, // 102624-102631
127, 127, 129, 130, 130, 128, 122, 122, // 102632-102639
125, 124, 123, 122, 123, 126, 129, 134, // 102640-102647
132, 133, 133, 132, 133, 129, 126, 123, // 102648-102655
122, 122, 124, 123, 125, 128, 130, 129, // 102656-102663
132, 133, 131, 128, 128, 126, 124, 125, // 102664-102671
124, 123, 120, 122, 127, 129, 127, 125, // 102672-102679
126, 128, 129, 131, 129, 124, 126, 126, // 102680-102687
128, 128, 125, 125, 125, 127, 128, 129, // 102688-102695
131, 130, 129, 128, 128, 131, 131, 125, // 102696-102703
125, 125, 125, 129, 131, 130, 128, 127, // 102704-102711
129, 131, 127, 122, 122, 123, 121, 123, // 102712-102719
125, 126, 127, 130, 130, 129, 130, 128, // 102720-102727
127, 125, 123, 121, 123, 124, 124, 124, // 102728-102735
125, 129, 134, 133, 131, 134, 134, 132, // 102736-102743
130, 128, 124, 122, 125, 125, 125, 122, // 102744-102751
123, 129, 131, 130, 132, 132, 132, 131, // 102752-102759
130, 127, 125, 123, 119, 119, 120, 121, // 102760-102767
123, 127, 127, 127, 129, 131, 133, 130, // 102768-102775
124, 124, 126, 124, 123, 124, 124, 125, // 102776-102783
128, 131, 131, 132, 130, 131, 131, 128, // 102784-102791
127, 129, 127, 126, 126, 126, 128, 129, // 102792-102799
130, 127, 128, 128, 128, 128, 125, 123, // 102800-102807
124, 124, 124, 126, 123, 125, 129, 130, // 102808-102815
127, 127, 128, 127, 126, 127, 124, 122, // 102816-102823
122, 122, 125, 124, 124, 129, 133, 133, // 102824-102831
132, 134, 134, 132, 130, 125, 122, 125, // 102832-102839
124, 122, 123, 122, 125, 130, 133, 133, // 102840-102847
133, 132, 133, 133, 128, 123, 124, 122, // 102848-102855
118, 120, 123, 124, 125, 127, 127, 129, // 102856-102863
129, 131, 133, 130, 126, 125, 126, 125, // 102864-102871
123, 122, 122, 126, 129, 129, 130, 131, // 102872-102879
130, 130, 131, 131, 128, 127, 127, 127, // 102880-102887
126, 124, 125, 128, 127, 126, 129, 130, // 102888-102895
130, 128, 126, 125, 125, 124, 124, 124, // 102896-102903
124, 125, 129, 130, 128, 129, 128, 128, // 102904-102911
130, 126, 123, 123, 123, 122, 123, 126, // 102912-102919
128, 129, 132, 134, 133, 133, 131, 130, // 102920-102927
128, 123, 124, 125, 124, 123, 123, 124, // 102928-102935
127, 130, 132, 131, 132, 132, 133, 132, // 102936-102943
128, 124, 122, 121, 120, 121, 120, 122, // 102944-102951
125, 126, 128, 132, 133, 132, 132, 130, // 102952-102959
126, 125, 123, 122, 123, 121, 122, 128, // 102960-102967
129, 128, 130, 131, 130, 131, 131, 130, // 102968-102975
128, 127, 126, 128, 126, 124, 126, 128, // 102976-102983
127, 129, 129, 129, 129, 127, 126, 126, // 102984-102991
127, 124, 124, 125, 125, 126, 127, 127, // 102992-102999
128, 127, 126, 129, 130, 126, 123, 124, // 103000-103007
124, 124, 125, 126, 126, 129, 130, 132, // 103008-103015
134, 131, 130, 129, 127, 126, 125, 124, // 103016-103023
123, 123, 124, 126, 129, 133, 131, 132, // 103024-103031
132, 131, 131, 128, 126, 123, 121, 122, // 103032-103039
123, 122, 122, 124, 126, 126, 128, 131, // 103040-103047
131, 131, 131, 129, 128, 127, 123, 122, // 103048-103055
121, 121, 123, 125, 127, 129, 131, 131, // 103056-103063
133, 134, 132, 129, 130, 127, 125, 125, // 103064-103071
124, 124, 125, 126, 129, 130, 129, 128, // 103072-103079
129, 127, 126, 126, 126, 124, 124, 126, // 103080-103087
127, 127, 126, 125, 126, 125, 126, 127, // 103088-103095
128, 126, 126, 127, 126, 127, 127, 126, // 103096-103103
127, 128, 129, 130, 130, 129, 129, 128, // 103104-103111
130, 129, 128, 124, 126, 125, 126, 127, // 103112-103119
129, 130, 129, 132, 131, 131, 129, 126, // 103120-103127
123, 122, 121, 124, 121, 145, 162, 147, // 103128-103135
112,  93,  82,  94,  73,  48,  65, 129, // 103136-103143
217, 233, 246, 203, 248, 213, 120, 122, // 103144-103151
107, 234, 190, 248, 237,  79, 151, 211, // 103152-103159
159, 166, 205, 248,  14, 173, 117,  84, // 103160-103167
 52,  88, 106, 233, 219,  36, 142, 119, // 103168-103175
 80,  71,  29,  71,  90,  91,  95, 118, // 103176-103183
121, 162, 121, 149,   2, 232, 209, 192, // 103184-103191
181, 181, 166, 148, 118,  85, 161, 206, // 103192-103199
238, 229, 158, 212, 218, 239, 254, 173, // 103200-103207
 83,  85,  74, 250, 220, 214, 247,  12, // 103208-103215
 41,  15,  58, 130, 148, 164, 157, 154, // 103216-103223
216, 222, 102,  56,  30,  60,  65, 120, // 103224-103231
 92,  58, 170, 202, 251,  56,  56,  47, // 103232-103239
 76,   6, 237, 166,  80,  38,  24,   7, // 103240-103247
221,  45,  90,  69,  71, 152, 133, 238, // 103248-103255
248, 121,  53,   1,  47,  50,   1, 193, // 103256-103263
254,  72, 122, 139, 182, 136, 166,   6, // 103264-103271
230, 205, 191, 180, 113, 143, 168, 221, // 103272-103279
223, 213, 195, 179, 163, 142, 194,  97, // 103280-103287
 20,  48,  83,  84, 108,  67,  60,  91, // 103288-103295
203,   0, 136,  67,  13,  57,  41, 245, // 103296-103303
254,   0, 240,  74, 136, 128, 206, 253, // 103304-103311
 28,  11,  10,  33, 241, 139,  98,  87, // 103312-103319
 99, 104, 125, 135,  44, 108, 207, 238, // 103320-103327
239, 213, 186, 162, 180, 147,  72, 243, // 103328-103335
220,  16,  45, 222, 219,  37,  31,  74, // 103336-103343
145, 171, 186, 236, 205, 153, 127, 170, // 103344-103351
163, 121,  97,  49, 133, 135, 130, 189, // 103352-103359
182, 182,  30,  42, 233, 189, 158, 142, // 103360-103367
111, 142,  87,  63,  71,  78,  70,  82, // 103368-103375
 58, 101, 155,  58,  48,  45,  58,  60, // 103376-103383
 82,  55,  64, 160, 217, 179, 152, 140, // 103384-103391
138, 194, 146, 132,  86,  81,  86, 131, // 103392-103399
170, 184, 253,  30,  20,  11,  29, 192, // 103400-103407
174, 120,  47,  15, 255,  10,  18, 235, // 103408-103415
250,  90, 162, 242, 193, 166, 112, 133, // 103416-103423
173,  83,  10, 247,   0,  27,  60,  47, // 103424-103431
 96, 123, 186, 253,  20,  12,  14, 243, // 103432-103439
173, 167, 199, 189, 125, 125,  73,  71, // 103440-103447
118, 143, 155, 108, 107, 143, 192, 165, // 103448-103455
103,  82,  59,  74, 156, 101, 246,  11, // 103456-103463
 35,  58,  70,  87,  98, 114, 121, 133, // 103464-103471
146, 157, 169, 173, 190, 129, 198, 249, // 103472-103479
158, 145, 170, 169, 195, 213, 169, 109, // 103480-103487
 68, 112, 131, 150, 110, 103, 150, 147, // 103488-103495
165, 174, 123,  66, 133, 100,  27, 235, // 103496-103503
245, 237, 234,  23,  59, 143, 190, 211, // 103504-103511
219, 214, 203,  23, 217, 129,  91,  85, // 103512-103519
 81,  43,  93,  90, 124, 198,  13,  17, // 103520-103527
 17, 230, 235, 217, 142, 135,  84,  29, // 103528-103535
  8,  11, 231,   7,  61, 139, 114,  99, // 103536-103543
123, 131, 173, 121,  97,  76,  80, 118, // 103544-103551
138,  70,  62, 111, 152, 168, 180, 189, // 103552-103559
158, 173, 161, 173, 184, 194, 187, 195, // 103560-103567
164, 154, 193, 161, 143, 118, 109,  87, // 103568-103575
107, 116,  36,   4,  49,  78, 141, 140, // 103576-103583
 66,  85, 100, 139, 156, 119,  85,  95, // 103584-103591
124,  93,  74,  86,  84,  76, 142, 152, // 103592-103599
168, 237, 213, 197, 218, 238,  10, 254, // 103600-103607
175, 118,  83,  79,  65,  84,  59,   7, // 103608-103615
 93, 150, 173, 170, 165, 141, 167, 191, // 103616-103623
148,  67,   2, 240, 243,   8, 241,  54, // 103624-103631
106, 109, 142, 201, 207, 242, 251, 198, // 103632-103639
167, 144, 184, 123,  87,  77, 102, 159, // 103640-103647
180, 190, 192, 145, 147, 214, 174, 146, // 103648-103655
113, 106,  88,  88,  87,  83,  72,  98, // 103656-103663
131, 100,  83,  60, 106,  58,  26,  63, // 103664-103671
 94, 114, 137, 135, 119, 155, 214, 241, // 103672-103679
192, 172, 144, 166, 127,  91, 115, 104, // 103680-103687
103, 151, 186, 158, 182, 201, 210, 181, // 103688-103695
185, 178, 137, 118,  59,  20,  20,  13, // 103696-103703
 58,  90,  10,  41, 108, 140, 156, 153, // 103704-103711
155, 144, 186, 188, 127,  85,  80,  76, // 103712-103719
100,  93,  91, 140, 134, 139, 195, 238, // 103720-103727
244,  11, 251, 188, 155, 162, 130,  86, // 103728-103735
 67,  20,  58,  85, 106, 111,  85,  91, // 103736-103743
139, 198, 170, 111,  80,  66,  57, 100, // 103744-103751
 70,  51,  87, 105, 124, 134, 140, 156, // 103752-103759
164, 134, 157, 153, 175, 154, 132, 138, // 103760-103767
140, 216, 240, 205, 174, 155, 133, 157, // 103768-103775
128,  97,  49,  35,  72, 100, 106,  86, // 103776-103783
118, 140, 181, 187, 172, 102,  92,  81, // 103784-103791
 37,  29,  26,  56,  55,  62,  83, 147, // 103792-103799
197, 230, 225, 233, 202, 223, 230, 130, // 103800-103807
106,  96, 105, 111, 124, 107, 104, 116, // 103808-103815
156, 185, 187, 181, 160, 177, 135, 100, // 103816-103823
107,  76,  43,  84,  49,  17,  49,  76, // 103824-103831
 95,  73, 105, 136, 183, 189, 153, 142, // 103832-103839
135, 134, 166, 157,  99, 113, 140, 132, // 103840-103847
125, 162, 171, 169, 188, 185, 169, 160, // 103848-103855
150, 138, 135,  93, 122, 147, 119, 107, // 103856-103863
 92,  91,  85, 121, 131,  62,  26,  58, // 103864-103871
 76, 101,  91,  89, 135, 149, 184, 193, // 103872-103879
161, 137, 156, 140, 116, 102, 111, 101, // 103880-103887
 67, 106, 135, 191, 227, 235, 229, 208, // 103888-103895
198, 219, 175, 101,  66,  44,  48,  42, // 103896-103903
 66,  28,  39,  97, 162, 197, 176, 144, // 103904-103911
138, 143, 110, 111,  75,  57,  52,  70, // 103912-103919
 67,  81, 133, 156, 146, 172, 199, 205, // 103920-103927
236, 167, 149, 147, 154, 178, 167, 124, // 103928-103935
 93, 114, 131, 135, 131, 131,  91, 120, // 103936-103943
142, 120, 109, 103,  94, 120, 127,  98, // 103944-103951
102,  87,  89,  81,  94,  91, 114, 140, // 103952-103959
 95,  88, 121, 141, 156, 168, 148, 152, // 103960-103967
179, 204, 177, 161, 156, 154, 177, 150, // 103968-103975
122, 114,  94,  79, 118, 118, 114, 144, // 103976-103983
152, 158, 142, 149, 147, 131, 126,  87, // 103984-103991
 44,  36,  30,  51,  44,  23,  94, 146, // 103992-103999
174, 185, 189, 183, 189, 203, 182, 142, // 104000-104007
105, 107,  86,  79,  80, 123, 159, 158, // 104008-104015
182, 205, 201, 202, 205, 162, 125, 105, // 104016-104023
118,  89,  72,  42,  37,  77,  95, 140, // 104024-104031
132,  91,  93, 140, 127, 112, 101, 104, // 104032-104039
105, 115, 136, 118, 126, 140, 147, 149, // 104040-104047
155, 145, 178, 131,  94, 134, 153, 171, // 104048-104055
171, 171, 144, 155, 187, 187, 146, 130, // 104056-104063
103, 107, 114,  82,  70,  47,  48,  87, // 104064-104071
137, 111, 103, 124, 134, 127, 143, 149, // 104072-104079
124, 132, 104,  86,  86,  92, 107, 110, // 104080-104087
 94, 121, 171, 203, 187, 176, 200, 190, // 104088-104095
222, 215, 152, 113,  99,  86,  91,  84, // 104096-104103
 74,  92,  96, 128, 146, 150, 149, 150, // 104104-104111
164, 141, 108, 103,  77,  53,  54,  36, // 104112-104119
 64,  99, 124, 132, 124, 141, 172, 198, // 104120-104127
177, 157, 148, 146, 141, 138, 116, 113, // 104128-104135
146, 156, 162, 159, 158, 153, 146, 132, // 104136-104143
126, 116, 115, 109, 111, 103,  83, 133, // 104144-104151
139, 139, 138, 111,  92, 101,  96,  75, // 104152-104159
 52,  55,  92, 113, 133, 124, 148, 175, // 104160-104167
182, 193, 195, 156, 155, 150,  92,  94, // 104168-104175
107, 128, 117, 121, 128, 146, 175, 184, // 104176-104183
177, 170, 149, 149, 170, 117,  78,  59, // 104184-104191
 61,  59,  90,  97,  66,  77, 111, 138, // 104192-104199
143, 154, 145, 166, 149, 132, 135, 116, // 104200-104207
102, 104, 100,  94, 119, 153, 152, 116, // 104208-104215
155, 180, 201, 207, 171, 153, 135, 130, // 104216-104223
140, 127,  84,  87, 103, 113, 112, 116, // 104224-104231
114,  98, 122, 142, 127, 108, 101,  97, // 104232-104239
103,  89, 109, 131, 126, 128, 124, 130, // 104240-104247
131, 154, 148, 111, 110, 132, 144, 139, // 104248-104255
124, 131, 166, 179, 200, 193, 166, 144, // 104256-104263
143, 133, 102,  87,  86,  74,  69, 101, // 104264-104271
 94, 121, 144, 154, 175, 156, 141, 139, // 104272-104279
120,  82,  63,  57,  71,  78, 103,  89, // 104280-104287
 96, 150, 176, 186, 187, 183, 176, 184, // 104288-104295
148, 132, 121, 118, 116, 117, 115, 105, // 104296-104303
137, 140, 131, 141, 156, 147, 164, 146, // 104304-104311
122, 101, 103, 109, 103, 107,  73,  77, // 104312-104319
 94, 103, 110, 117,  99, 126, 154, 136, // 104320-104327
133, 131, 136, 134, 141, 142, 144, 147, // 104328-104335
151, 124, 128, 141, 152, 169, 130, 121, // 104336-104343
132, 139, 138, 141, 127, 120, 133, 153, // 104344-104351
146, 120, 108,  98, 109, 111, 106,  89, // 104352-104359
 68,  66,  95, 103, 102, 129, 147, 156, // 104360-104367
151, 167, 164, 154, 147, 118, 109, 107, // 104368-104375
112, 118,  94,  85, 141, 178, 193, 194, // 104376-104383
189, 178, 167, 173, 149, 109,  85,  79, // 104384-104391
 71,  82,  70,  83, 106, 104, 144, 161, // 104392-104399
147, 137, 142, 125, 100,  99, 114, 101, // 104400-104407
 98,  95,  90, 120, 136, 152, 148, 142, // 104408-104415
146, 181, 170, 134, 135, 147, 147, 147, // 104416-104423
161, 132, 130, 136, 133, 128, 126, 121, // 104424-104431
127, 114,  99, 104, 104, 113, 107, 132, // 104432-104439
115, 106, 133, 131, 113, 109, 104, 105, // 104440-104447
123, 111, 106,  91, 103, 127, 146, 143, // 104448-104455
146, 165, 179, 162, 157, 171, 151, 160, // 104456-104463
140, 122, 114, 113, 116, 106, 102, 109, // 104464-104471
133, 150, 151, 144, 142, 128, 144, 145, // 104472-104479
121,  94,  74,  66,  69,  77,  74,  86, // 104480-104487
102, 136, 153, 163, 163, 166, 177, 150, // 104488-104495
140, 145, 125, 115, 102,  84, 110, 139, // 104496-104503
160, 159, 150, 161, 166, 177, 159, 133, // 104504-104511
120, 110, 109, 121, 103,  81, 100, 106, // 104512-104519
118, 132, 127, 109, 103, 108, 106, 103, // 104520-104527
109, 113, 122, 126, 116, 147, 157, 148, // 104528-104535
142, 138, 135, 139, 149, 116,  94, 114, // 104536-104543
141, 149, 159, 146, 150, 164, 162, 168, // 104544-104551
156, 130, 117, 121,  99,  85,  78,  90, // 104552-104559
 76,  94, 120, 113, 128, 135, 138, 135, // 104560-104567
130, 134, 150, 125, 103,  94,  99, 105, // 104568-104575
114, 122, 109, 125, 157, 172, 156, 164, // 104576-104583
165, 176, 170, 155, 148, 125, 115, 109, // 104584-104591
109,  95, 103, 123, 124, 112, 128, 133, // 104592-104599
140, 142, 133, 129, 104, 102, 108, 102, // 104600-104607
 80,  82, 103, 121, 127, 134, 135, 125, // 104608-104615
150, 154, 141, 137, 135, 138, 138, 120, // 104616-104623
134, 152, 152, 154, 147, 146, 135, 145, // 104624-104631
139, 104,  99, 113, 119, 122, 121, 111, // 104632-104639
121, 134, 146, 152, 135, 109, 105, 107, // 104640-104647
 91,  83,  85,  84,  94, 124, 125, 137, // 104648-104655
157, 165, 166, 158, 166, 159, 152, 124, // 104656-104663
 96, 102, 113, 120, 133, 121, 116, 150, // 104664-104671
165, 167, 157, 150, 140, 141, 135, 119, // 104672-104679
 93,  84,  85,  86, 107,  98, 108, 112, // 104680-104687
112, 127, 136, 133, 143, 145, 131, 119, // 104688-104695
122, 136, 125, 122, 110, 121, 136, 148, // 104696-104703
143, 131, 131, 149, 173, 158, 148, 137, // 104704-104711
137, 128, 131, 128, 115, 115, 119, 116, // 104712-104719
115, 112, 113, 121, 102, 114, 114, 109, // 104720-104727
109, 112, 112, 104, 121, 146, 148, 133, // 104728-104735
131, 125, 136, 134, 123, 119, 109, 115, // 104736-104743
140, 137, 127, 150, 167, 174, 166, 172, // 104744-104751
160, 143, 136, 112,  98,  92,  95,  99, // 104752-104759
 95,  89, 110, 134, 140, 147, 155, 140, // 104760-104767
124, 136, 123,  94,  83,  85,  90, 102, // 104768-104775
104, 112, 128, 136, 159, 166, 168, 161, // 104776-104783
166, 160, 125, 124, 136, 127, 124, 124, // 104784-104791
114, 129, 138, 145, 136, 125, 130, 140, // 104792-104799
140, 122, 114, 108, 108, 107, 128, 116, // 104800-104807
102, 108, 109, 113, 110, 113, 115, 118, // 104808-104815
118, 126, 126, 135, 136, 145, 135, 136, // 104816-104823
159, 157, 147, 128, 129, 134, 147, 142, // 104824-104831
131, 115, 120, 133, 137, 134, 123, 136, // 104832-104839
138, 137, 141, 135, 113, 117, 107, 104, // 104840-104847
102,  91,  94,  86,  94, 101, 120, 137, // 104848-104855
148, 150, 150, 142, 154, 158, 128, 115, // 104856-104863
110, 110, 116, 121, 109, 117, 138, 164, // 104864-104871
173, 172, 167, 159, 162, 138, 127, 119, // 104872-104879
102,  95,  97,  93,  92, 110, 124, 122, // 104880-104887
128, 140, 132, 138, 131, 115, 108, 102, // 104888-104895
111, 123, 114, 102, 118, 130, 139, 140, // 104896-104903
143, 138, 134, 151, 136, 125, 132, 138, // 104904-104911
143, 143, 136, 150, 151, 141, 136, 127, // 104912-104919
122, 118, 127, 110,  93,  97, 111, 115, // 104920-104927
124, 131, 126, 130, 131, 141, 130, 116, // 104928-104935
110, 118, 113, 104, 106, 111, 108, 119, // 104936-104943
134, 132, 153, 159, 167, 154, 145, 154, // 104944-104951
160, 148, 126, 116, 110, 110, 111, 117, // 104952-104959
 99, 112, 134, 144, 149, 146, 139, 139, // 104960-104967
135, 127, 128, 101,  91,  86,  92,  87, // 104968-104975
 95, 120, 124, 130, 144, 149, 151, 161, // 104976-104983
146, 135, 125, 129, 132, 129, 111, 105, // 104984-104991
128, 141, 148, 151, 145, 133, 149, 144, // 104992-104999
131, 124, 118, 117, 115, 118, 117, 120, // 105000-105007
123, 121, 123, 127, 116, 120, 118, 100, // 105008-105015
103, 108, 114, 123, 129, 128, 132, 143, // 105016-105023
150, 147, 141, 135, 129, 133, 124, 117, // 105024-105031
117, 116, 123, 132, 133, 137, 145, 145, // 105032-105039
141, 137, 136, 129, 124, 118, 110, 110, // 105040-105047
109, 114, 118, 118, 119, 128, 132, 136, // 105048-105055
135, 132, 130, 129, 132, 126, 123, 123, // 105056-105063
121, 123, 125, 125, 131, 132, 133, 136, // 105064-105071
135, 136, 135, 135, 128, 123, 124, 123, // 105072-105079
121, 121, 119, 121, 125, 127, 131, 130, // 105080-105087
127, 127, 127, 124, 123, 121, 119, 119, // 105088-105095
122, 125, 126, 132, 132, 134, 135, 135, // 105096-105103
135, 133, 128, 124, 123, 123, 124, 126, // 105104-105111
129, 128, 132, 136, 134, 135, 132, 128, // 105112-105119
127, 124, 121, 120, 116, 116, 119, 123, // 105120-105127
126, 129, 132, 130, 131, 130, 127, 127, // 105128-105135
126, 120, 118, 119, 121, 124, 125, 127, // 105136-105143
130, 136, 138, 138, 137, 133, 128, 129, // 105144-105151
126, 124, 124, 122, 122, 125, 129, 131, // 105152-105159
132, 133, 131, 131, 131, 127, 125, 122, // 105160-105167
118, 120, 121, 121, 123, 123, 122, 125, // 105168-105175
131, 132, 130, 131, 129, 127, 128, 127, // 105176-105183
125, 125, 123, 125, 126, 126, 128, 130, // 105184-105191
131, 132, 136, 136, 133, 130, 127, 123, // 105192-105199
123, 123, 121, 122, 121, 124, 128, 130, // 105200-105207
132, 132, 132, 130, 129, 127, 121, 119, // 105208-105215
119, 118, 121, 125, 127, 129, 130, 132, // 105216-105223
134, 134, 133, 130, 127, 124, 123, 124, // 105224-105231
123, 123, 126, 128, 132, 135, 134, 133, // 105232-105239
131, 130, 129, 126, 122, 120, 118, 118, // 105240-105247
120, 125, 127, 129, 132, 132, 132, 133, // 105248-105255
131, 128, 125, 122, 120, 121, 121, 121, // 105256-105263
122, 124, 129, 135, 136, 135, 134, 133, // 105264-105271
130, 128, 127, 124, 123, 123, 122, 121, // 105272-105279
125, 127, 128, 128, 129, 131, 132, 130, // 105280-105287
128, 125, 123, 124, 126, 126, 123, 124, // 105288-105295
125, 125, 127, 130, 129, 128, 129, 130, // 105296-105303
130, 129, 128, 127, 126, 125, 125, 126, // 105304-105311
126, 125, 127, 128, 130, 133, 131, 126, // 105312-105319
125, 126, 125, 124, 122, 121, 123, 126, // 105320-105327
129, 130, 129, 129, 131, 131, 129, 126, // 105328-105335
125, 121, 120, 122, 124, 126, 127, 129, // 105336-105343
131, 133, 134, 135, 134, 131, 128, 127, // 105344-105351
125, 124, 122, 120, 121, 125, 129, 131, // 105352-105359
131, 130, 131, 131, 131, 128, 126, 123, // 105360-105367
121, 120, 119, 120, 122, 124, 125, 128, // 105368-105375
131, 132, 133, 130, 128, 127, 128, 127, // 105376-105383
126, 125, 124, 126, 130, 132, 131, 131, // 105384-105391
130, 132, 132, 130, 127, 126, 126, 126, // 105392-105399
127, 126, 124, 125, 127, 125, 126, 127, // 105400-105407
127, 125, 125, 123, 123, 124, 124, 124, // 105408-105415
122, 124, 126, 128, 127, 127, 129, 130, // 105416-105423
131, 132, 131, 128, 127, 128, 128, 126, // 105424-105431
127, 127, 129, 130, 129, 132, 132, 133, // 105432-105439
132, 130, 127, 126, 124, 122, 119, 118, // 105440-105447
121, 123, 125, 126, 126, 128, 131, 132, // 105448-105455
131, 128, 127, 125, 123, 122, 120, 122, // 105456-105463
122, 124, 128, 131, 132, 134, 135, 134, // 105464-105471
132, 132, 131, 127, 125, 123, 124, 125, // 105472-105479
128, 128, 128, 129, 130, 131, 130, 127, // 105480-105487
126, 125, 123, 124, 122, 120, 121, 125, // 105488-105495
126, 127, 129, 129, 129, 126, 126, 125, // 105496-105503
126, 126, 124, 125, 125, 126, 130, 131, // 105504-105511
129, 132, 132, 133, 133, 131, 127, 125, // 105512-105519
127, 127, 126, 126, 126, 126, 129, 129, // 105520-105527
130, 130, 129, 128, 127, 125, 123, 124, // 105528-105535
122, 121, 122, 124, 124, 125, 126, 126, // 105536-105543
127, 129, 131, 130, 128, 127, 127, 128, // 105544-105551
128, 126, 124, 125, 126, 127, 127, 128, // 105552-105559
129, 130, 131, 131, 131, 129, 127, 126, // 105560-105567
124, 124, 125, 127, 126, 125, 126, 128, // 105568-105575
129, 130, 128, 127, 126, 126, 125, 124, // 105576-105583
122, 122, 124, 126, 128, 129, 130, 130, // 105584-105591
131, 130, 128, 127, 127, 126, 123, 124, // 105592-105599
124, 127, 129, 128, 129, 130, 129, 130, // 105600-105607
130, 127, 125, 126, 126, 125, 125, 125, // 105608-105615
125, 126, 129, 128, 128, 128, 128, 129, // 105616-105623
127, 126, 126, 126, 125, 125, 125, 125, // 105624-105631
127, 130, 129, 128, 130, 131, 130, 126, // 105632-105639
124, 124, 125, 124, 125, 125, 125, 125, // 105640-105647
127, 129, 128, 130, 130, 129, 128, 127, // 105648-105655
127, 126, 125, 125, 124, 126, 128, 129, // 105656-105663
128, 126, 127, 128, 129, 130, 129, 127, // 105664-105671
127, 128, 129, 128, 125, 126, 127, 126, // 105672-105679
126, 127, 127, 126, 127, 127, 127, 127, // 105680-105687
127, 126, 124, 124, 125, 126, 125, 124, // 105688-105695
125, 127, 128, 130, 129, 127, 127, 129, // 105696-105703
128, 128, 127, 126, 128, 129, 130, 130, // 105704-105711
128, 128, 129, 129, 127, 126, 127, 126, // 105712-105719
125, 125, 126, 127, 129, 127, 127, 128, // 105720-105727
128, 128, 128, 125, 125, 125, 125, 126, // 105728-105735
124, 124, 123, 127, 128, 128, 128, 129, // 105736-105743
129, 130, 129, 128, 128, 127, 128, 126, // 105744-105751
125, 126, 128, 130, 128, 127, 128, 128, // 105752-105759
130, 128, 127, 127, 127, 128, 127, 125, // 105760-105767
126, 126, 127, 126, 127, 126, 125, 126, // 105768-105775
126, 123, 125, 127, 128, 128, 127, 128, // 105776-105783
129, 128, 128, 128, 126, 126, 127, 129, // 105784-105791
127, 126, 128, 129, 131, 131, 127, 127, // 105792-105799
128, 128, 127, 126, 126, 127, 127, 127, // 105800-105807
126, 127, 125, 126, 125, 125, 125, 127, // 105808-105815
127, 126, 125, 128, 130, 130, 129, 127, // 105816-105823
126, 126, 126, 126, 127, 124, 126, 128, // 105824-105831
129, 130, 128, 129, 130, 129, 129, 126, // 105832-105839
126, 127, 126, 125, 125, 126, 126, 126, // 105840-105847
126, 125, 125, 127, 128, 128, 126, 128, // 105848-105855
128, 128, 127, 125, 127, 128, 127, 127, // 105856-105863
127, 125, 128, 129, 129, 129, 128, 128, // 105864-105871
129, 129, 128, 127, 127, 129, 128, 127, // 105872-105879
126, 127, 127, 125, 125, 125, 125, 125, // 105880-105887
127, 126, 126, 127, 129, 129, 128, 126, // 105888-105895
126, 127, 127, 126, 126, 125, 126, 128, // 105896-105903
129, 128, 128, 129, 129, 128, 128, 127, // 105904-105911
127, 128, 128, 127, 126, 127, 128, 128, // 105912-105919
126, 124, 124, 124, 125, 125, 126, 127, // 105920-105927
129, 129, 128, 128, 127, 128, 127, 125, // 105928-105935
125, 125, 124, 126, 126, 126, 128, 130, // 105936-105943
131, 131, 129, 128, 129, 128, 127, 126, // 105944-105951
126, 126, 127, 129, 128, 127, 128, 129, // 105952-105959
128, 128, 126, 126, 126, 127, 125, 126, // 105960-105967
125, 126, 127, 125, 125, 126, 128, 127, // 105968-105975
127, 127, 126, 127, 129, 127, 127, 127, // 105976-105983
128, 129, 127, 126, 126, 129, 129, 130, // 105984-105991
129, 126, 126, 128, 127, 126, 126, 127, // 105992-105999
128, 128, 128, 128, 128, 128, 127, 126, // 106000-106007
125, 125, 126, 126, 124, 126, 126, 127, // 106008-106015
130, 129, 126, 127, 127, 128, 127, 125, // 106016-106023
127, 128, 128, 127, 127, 127, 126, 129, // 106024-106031
127, 127, 127, 129, 130, 129, 129, 129, // 106032-106039
129, 129, 127, 124, 124, 124, 126, 125, // 106040-106047
125, 126, 129, 129, 129, 129, 127, 125, // 106048-106055
126, 126, 125, 124, 124, 126, 127, 127, // 106056-106063
128, 130, 129, 129, 129, 126, 125, 126, // 106064-106071
126, 125, 125, 127, 128, 129, 128, 127, // 106072-106079
127, 128, 129, 129, 126, 126, 126, 126, // 106080-106087
127, 127, 127, 127, 127, 129, 128, 127, // 106088-106095
129, 128, 128, 126, 126, 128, 126, 124, // 106096-106103
126, 125, 125, 128, 128, 127, 126, 127, // 106104-106111
129, 129, 128, 127, 126, 126, 125, 125, // 106112-106119
125, 124, 127, 128, 126, 128, 130, 128, // 106120-106127
128, 128, 128, 127, 128, 128, 126, 126, // 106128-106135
126, 128, 129, 126, 127, 128, 127, 128, // 106136-106143
129, 128, 126, 126, 128, 127, 126, 125, // 106144-106151
125, 126, 125, 126, 128, 127, 127, 128, // 106152-106159
128, 127, 128, 126, 126, 125, 126, 126, // 106160-106167
126, 127, 127, 128, 129, 130, 131, 130, // 106168-106175
127, 128, 127, 125, 125, 125, 124, 126, // 106176-106183
128, 129, 129, 129, 130, 129, 129, 126, // 106184-106191
126, 124, 123, 124, 125, 125, 126, 127, // 106192-106199
128, 128, 129, 128, 128, 127, 127, 126, // 106200-106207
127, 126, 127, 128, 126, 127, 128, 127, // 106208-106215
128, 129, 127, 127, 128, 129, 128, 127, // 106216-106223
127, 127, 127, 126, 126, 127, 126, 126, // 106224-106231
128, 128, 127, 128, 128, 127, 127, 125, // 106232-106239
125, 126, 126, 127, 126, 127, 128, 128, // 106240-106247
129, 127, 127, 126, 126, 127, 126, 124, // 106248-106255
125, 127, 128, 128, 129, 129, 129, 129, // 106256-106263
128, 128, 128, 128, 128, 128, 127, 127, // 106264-106271
128, 127, 127, 126, 127, 127, 129, 128, // 106272-106279
126, 128, 129, 128, 128, 126, 125, 126, // 106280-106287
125, 125, 125, 124, 125, 127, 128, 128, // 106288-106295
128, 128, 128, 127, 127, 126, 126, 126, // 106296-106303
125, 126, 128, 128, 129, 129, 128, 127, // 106304-106311
127, 128, 129, 128, 127, 128, 129, 127, // 106312-106319
127, 127, 127, 127, 127, 126, 126, 125, // 106320-106327
126, 127, 126, 126, 126, 127, 128, 126, // 106328-106335
125, 126, 126, 128, 126, 127, 128, 127, // 106336-106343
127, 127, 127, 128, 127, 128, 129, 128, // 106344-106351
128, 129, 129, 128, 127, 128, 128, 128, // 106352-106359
127, 126, 125, 126, 127, 127, 126, 126, // 106360-106367
127, 127, 128, 127, 127, 127, 127, 128, // 106368-106375
126, 126, 126, 127, 126, 126, 126, 127, // 106376-106383
126, 126, 127, 127, 129, 129, 129, 128, // 106384-106391
127, 128, 128, 127, 127, 127, 126, 127, // 106392-106399
127, 126, 126, 126, 128, 129, 129, 130, // 106400-106407
127, 127, 126, 126, 126, 125, 125, 126, // 106408-106415
126, 126, 125, 127, 127, 127, 128, 128, // 106416-106423
127, 128, 129, 127, 126, 127, 128, 126, // 106424-106431
126, 126, 126, 127, 127, 127, 127, 126, // 106432-106439
128, 129, 127, 127, 128, 129, 127, 127, // 106440-106447
128, 126, 125, 127, 127, 126, 126, 126, // 106448-106455
127, 126, 127, 127, 128, 127, 129, 129, // 106456-106463
127, 126, 127, 127, 125, 127, 128, 127, // 106464-106471
128, 127, 127, 127, 127, 128, 127, 127, // 106472-106479
128, 129, 128, 126, 127, 128, 126, 127, // 106480-106487
126, 124, 123, 125, 126, 126, 127, 126, // 106488-106495
127, 129, 130, 129, 128, 127, 128, 128, // 106496-106503
126, 126, 127, 124, 124, 126, 127, 128, // 106504-106511
127, 127, 128, 128, 130, 131, 129, 127, // 106512-106519
127, 128, 127, 125, 125, 124, 124, 127, // 106520-106527
127, 127, 127, 126, 127, 128, 129, 130, // 106528-106535
128, 126, 126, 126, 127, 125, 127, 126, // 106536-106543
124, 126, 127, 126, 126, 127, 129, 130, // 106544-106551
131, 131, 129, 127, 126, 127, 127, 126, // 106552-106559
126, 126, 126, 126, 128, 127, 127, 127, // 106560-106567
127, 127, 127, 127, 126, 126, 127, 128, // 106568-106575
128, 127, 127, 126, 123, 124, 125, 125, // 106576-106583
124, 124, 126, 127, 130, 130, 132, 131, // 106584-106591
130, 129, 129, 128, 127, 126, 124, 125, // 106592-106599
126, 127, 127, 127, 127, 127, 129, 131, // 106600-106607
130, 128, 127, 127, 127, 126, 126, 126, // 106608-106615
124, 123, 124, 125, 123, 125, 125, 126, // 106616-106623
128, 129, 130, 129, 128, 127, 127, 127, // 106624-106631
126, 126, 125, 124, 125, 127, 128, 129, // 106632-106639
129, 129, 130, 131, 130, 128, 127, 127, // 106640-106647
128, 128, 127, 126, 125, 124, 125, 127, // 106648-106655
127, 126, 126, 126, 125, 125, 127, 127, // 106656-106663
127, 126, 126, 127, 127, 126, 127, 126, // 106664-106671
126, 127, 127, 128, 126, 126, 126, 128, // 106672-106679
129, 130, 130, 131, 131, 130, 130, 129, // 106680-106687
127, 126, 125, 125, 124, 124, 125, 124, // 106688-106695
126, 128, 130, 130, 129, 128, 127, 126, // 106696-106703
126, 125, 122, 123, 123, 124, 125, 126, // 106704-106711
127, 127, 129, 130, 131, 129, 129, 129, // 106712-106719
128, 127, 129, 128, 126, 126, 125, 126, // 106720-106727
127, 128, 129, 128, 128, 129, 130, 129, // 106728-106735
128, 128, 126, 125, 126, 125, 123, 123, // 106736-106743
124, 125, 127, 127, 128, 127, 126, 127, // 106744-106751
129, 128, 127, 127, 126, 126, 127, 129, // 106752-106759
127, 127, 128, 129, 129, 127, 127, 126, // 106760-106767
124, 126, 128, 128, 127, 128, 129, 128, // 106768-106775
129, 131, 128, 127, 126, 125, 124, 123, // 106776-106783
123, 124, 123, 126, 128, 129, 129, 130, // 106784-106791
131, 129, 131, 130, 127, 124, 124, 125, // 106792-106799
124, 124, 126, 126, 127, 128, 130, 131, // 106800-106807
131, 131, 130, 127, 127, 127, 125, 122, // 106808-106815
123, 123, 123, 126, 127, 127, 127, 127, // 106816-106823
129, 128, 128, 129, 128, 126, 125, 126, // 106824-106831
126, 125, 126, 128, 127, 128, 129, 129, // 106832-106839
129, 128, 128, 129, 129, 129, 128, 127, // 106840-106847
126, 127, 127, 126, 127, 127, 126, 127, // 106848-106855
127, 126, 125, 125, 126, 125, 126, 125, // 106856-106863
126, 126, 127, 128, 130, 128, 128, 129, // 106864-106871
128, 126, 126, 126, 124, 124, 124, 128, // 106872-106879
128, 132, 130, 152, 171, 156, 119,  94, // 106880-106887
 78,  90,  68,  41,  57, 123, 213, 232, // 106888-106895
250, 208, 250, 218, 126, 124, 109, 234, // 106896-106903
184, 241, 226,  66, 141, 202, 153, 163, // 106904-106911
205, 250,  23, 183, 125,  90,  56,  87, // 106912-106919
107, 235, 214,  30, 137, 120,  84,  76, // 106920-106927
 32,  74,  96,  96, 101, 122, 121, 162, // 106928-106935
120, 145, 254, 230, 206, 190, 179, 180, // 106936-106943
166, 148, 118,  83, 156, 202, 234, 229, // 106944-106951
156, 207, 216, 236, 254, 177,  86,  87, // 106952-106959
 77, 255, 222, 215, 245,   8,  39,  13, // 106960-106967
 56, 131, 151, 169, 163, 160, 221, 231, // 106968-106975
109,  61,  30,  57,  59, 112,  85,  47, // 106976-106983
161, 198, 249,  59,  62,  51,  81,  13, // 106984-106991
242, 171,  80,  34,  18,   1, 212,  34, // 106992-106999
 82,  64,  66, 153, 137, 242,   4, 131, // 107000-107007
 63,   8,  49,  51,   2, 189, 245,  65, // 107008-107015
116, 135, 181, 138, 166,  11, 238, 212, // 107016-107023
196, 185, 115, 141, 165, 216, 218, 208, // 107024-107031
193, 178, 164, 141, 196, 102,  21,  47, // 107032-107039
 83,  83, 106,  65,  56,  87, 196,   0, // 107040-107047
137,  70,  15,  58,  46, 247, 254, 255, // 107048-107055
235,  68, 133, 126, 203, 252,  31,  15, // 107056-107063
 14,  38, 249, 146, 102,  90, 100, 104, // 107064-107071
121, 132,  39,  99, 203, 237, 240, 217, // 107072-107079
192, 168, 185, 154,  79, 244, 217,   9, // 107080-107087
 40, 216, 209,  28,  23,  67, 142, 173, // 107088-107095
189, 241, 214, 161, 132, 172, 165, 119, // 107096-107103
 95,  44, 126, 132, 125, 187, 183, 183, // 107104-107111
 32,  50, 243, 196, 164, 148, 114, 142, // 107112-107119
 87,  58,  66,  73,  67,  79,  57,  98, // 107120-107127
156,  63,  51,  47,  60,  60,  81,  54, // 107128-107135
 59, 154, 213, 176, 149, 140, 137, 195, // 107136-107143
149, 134,  89,  80,  85, 128, 169, 182, // 107144-107151
251,  30,  22,  13,  35, 198, 178, 128, // 107152-107159
 52,  18,   0,   9,  15, 233, 244,  85, // 107160-107167
158, 242, 196, 169, 116, 136, 178,  90, // 107168-107175
 13, 248, 253,  22,  54,  39,  87, 115, // 107176-107183
178, 247,  18,  14,  18, 249, 180, 172, // 107184-107191
204, 193, 125, 124,  71,  66, 112, 138, // 107192-107199
153, 108, 107, 144, 195, 173, 110,  89, // 107200-107207
 66,  77, 157, 103, 244,   6,  30,  54, // 107208-107215
 67,  84,  98, 113, 122, 134, 147, 158, // 107216-107223
170, 172, 190, 129, 194, 248, 157, 144, // 107224-107231
170, 168, 195, 215, 172, 111,  68, 111, // 107232-107239
130, 150, 111, 103, 150, 146, 166, 177, // 107240-107247
128,  69, 134, 105,  29, 237, 245, 236, // 107248-107255
231,  18,  53, 138, 186, 211, 218, 216, // 107256-107263
205,  26, 223, 134,  95,  84,  79,  38, // 107264-107271
 87,  85, 116, 191,   6,  12,  19, 232, // 107272-107279
240, 226, 149, 141,  90,  34,   9,  11, // 107280-107287
230,   4,  57, 135, 114,  96, 122, 129, // 107288-107295
176, 126, 101,  82,  85, 120, 140,  72, // 107296-107303
 59, 108, 146, 164, 175, 186, 154, 172, // 107304-107311
160, 172, 187, 197, 189, 196, 165, 152, // 107312-107319
192, 160, 141, 115, 109,  88, 107, 120, // 107320-107327
 39,   5,  46,  76, 138, 141,  67,  84, // 107328-107335
101, 141, 159, 124,  90,  98, 126,  96, // 107336-107343
 74,  86,  84,  71, 137, 149, 163, 234, // 107344-107351
213, 199, 219, 242,  12,   4, 180, 120, // 107352-107359
 84,  80,  65,  82,  56,   2,  85, 142, // 107360-107367
167, 165, 164, 143, 169, 196, 153,  73, // 107368-107375
  7, 244, 241,   8, 239,  50, 103, 105, // 107376-107383
138, 198, 207, 243, 255, 204, 173, 147, // 107384-107391
187, 126,  89,  76, 101, 158, 180, 189, // 107392-107399
192, 148, 144, 210, 173, 144, 111, 106, // 107400-107407
 88,  88,  88,  84,  74,  97, 131, 101, // 107408-107415
 83,  58, 105,  59,  24,  61,  93, 111, // 107416-107423
134, 138, 121, 154, 211, 242, 197, 176, // 107424-107431
148, 170, 133,  96, 120, 109, 103, 146, // 107432-107439
182, 154, 176, 196, 207, 180, 186, 182, // 107440-107447
139, 120,  63,  22,  18,   9,  54,  89, // 107448-107455
  8,  36, 105, 136, 153, 153, 156, 143, // 107456-107463
184, 189, 129,  85,  79,  78, 102, 100, // 107464-107471
 95, 144, 137, 138, 194, 236, 239,   9, // 107472-107479
251, 189, 157, 166, 133,  88,  72,  25, // 107480-107487
 56,  84, 104, 109,  82,  86, 133, 195, // 107488-107495
170, 111,  81,  66,  54, 100,  73,  50, // 107496-107503
 86, 104, 124, 136, 143, 156, 165, 135, // 107504-107511
158, 154, 172, 153, 131, 139, 140, 216, // 107512-107519
243, 206, 177, 158, 134, 156, 128,  99, // 107520-107527
 53,  34,  71, 101, 107,  84, 116, 137, // 107528-107535
175, 183, 169,  99,  86,  80,  37,  33, // 107536-107543
 31,  59,  60,  67,  86, 146, 194, 224, // 107544-107551
222, 230, 199, 220, 233, 134, 109, 102, // 107552-107559
107, 111, 126, 111, 105, 114, 153, 186, // 107560-107567
188, 182, 159, 178, 136,  99, 107,  75, // 107568-107575
 39,  81,  51,  17,  49,  78,  97,  75, // 107576-107583
104, 134, 177, 186, 151, 141, 133, 130, // 107584-107591
166, 161, 101, 116, 143, 131, 122, 161, // 107592-107599
171, 166, 185, 183, 171, 162, 150, 138, // 107600-107607
139,  96, 122, 149, 119, 107,  93,  90, // 107608-107615
 82, 121, 133,  66,  29,  59,  74,  98, // 107616-107623
 92,  88, 133, 146, 182, 195, 163, 134, // 107624-107631
155, 140, 115, 103, 113, 103,  67, 107, // 107632-107639
136, 192, 227, 232, 228, 208, 195, 213, // 107640-107647
174, 101,  68,  45,  49,  44,  71,  34, // 107648-107655
 41,  97, 159, 193, 175, 143, 135, 141, // 107656-107663
109, 112,  78,  58,  54,  72,  68,  78, // 107664-107671
130, 154, 144, 171, 202, 205, 236, 168, // 107672-107679
150, 148, 153, 175, 165, 124,  94, 114, // 107680-107687
131, 137, 134, 136,  94, 121, 144, 119, // 107688-107695
106, 100,  90, 115, 127,  99, 104,  88, // 107696-107703
 91,  84,  94,  91, 111, 139,  94,  86, // 107704-107711
119, 140, 152, 167, 149, 154, 180, 203, // 107712-107719
178, 160, 158, 154, 176, 149, 123, 116, // 107720-107727
 95,  80, 118, 119, 113, 145, 154, 160, // 107728-107735
142, 150, 148, 131, 127,  89,  45,  33, // 107736-107743
 28,  50,  48,  22,  92, 146, 174, 186, // 107744-107751
189, 184, 187, 200, 181, 142, 105, 107, // 107752-107759
 85,  79,  81, 123, 160, 156, 182, 205, // 107760-107767
201, 198, 203, 162, 124, 105, 120,  92, // 107768-107775
 74,  46,  39,  76,  93, 140, 134,  93, // 107776-107783
 91, 138, 130, 114, 102, 106, 105, 113, // 107784-107791
138, 118, 125, 136, 144, 146, 155, 146, // 107792-107799
178, 132,  95, 135, 154, 170, 169, 173, // 107800-107807
142, 150, 184, 187, 147, 130, 105, 107, // 107808-107815
115,  84,  73,  48,  44,  84, 140, 116, // 107816-107823
107, 124, 135, 130, 146, 152, 122, 131, // 107824-107831
105,  88,  86,  93, 105, 110,  96, 120, // 107832-107839
170, 199, 183, 172, 197, 184, 219, 216, // 107840-107847
154, 115, 101,  87,  92,  86,  72,  89, // 107848-107855
 93, 126, 147, 152, 148, 148, 167, 147, // 107856-107863
113, 107,  78,  52,  57,  35,  60,  94, // 107864-107871
122, 134, 125, 143, 173, 203, 183, 162, // 107872-107879
152, 147, 140, 139, 116, 108, 138, 149, // 107880-107887
158, 153, 153, 147, 143, 131, 129, 120, // 107888-107895
121, 114, 117, 107,  81, 130, 133, 134, // 107896-107903
135, 110,  89,  99, 101,  82,  58,  60, // 107904-107911
 99, 117, 137, 123, 147, 171, 177, 192, // 107912-107919
199, 159, 153, 151,  95,  94, 103, 124, // 107920-107927
112, 118, 125, 143, 175, 183, 177, 171, // 107928-107935
151, 150, 173, 121,  80,  58,  58,  54, // 107936-107943
 87,  98,  62,  72, 107, 135, 143, 155, // 107944-107951
143, 169, 154, 137, 144, 124, 105, 104, // 107952-107959
104,  96, 116, 149, 147, 110, 151, 177, // 107960-107967
203, 213, 176, 158, 140, 134, 142, 128, // 107968-107975
 78,  79,  95, 106, 105, 111, 111,  94, // 107976-107983
122, 148, 135, 115, 105,  97, 103,  90, // 107984-107991
109, 131, 122, 123, 123, 131, 129, 153, // 107992-107999
149, 113, 113, 136, 150, 146, 128, 132, // 108000-108007
166, 179, 199, 193, 162, 138, 138, 132, // 108008-108015
101,  87,  88,  73,  68, 101,  94, 119, // 108016-108023
138, 148, 171, 155, 144, 144, 126,  87, // 108024-108031
 69,  65,  75,  75, 100,  85,  87, 142, // 108032-108039
172, 185, 190, 189, 183, 193, 157, 140, // 108040-108047
126, 118, 112, 113, 110,  97, 128, 134, // 108048-108055
125, 138, 156, 150, 166, 151, 127, 104, // 108056-108063
104, 112, 103, 106,  72,  74,  89,  98, // 108064-108071
105, 114,  97, 124, 155, 144, 143, 138, // 108072-108079
145, 139, 145, 146, 145, 142, 146, 118, // 108080-108087
122, 136, 148, 170, 133, 125, 136, 143, // 108088-108095
142, 142, 127, 116, 128, 150, 145, 118, // 108096-108103
107,  97, 108, 110, 109,  92,  68,  62, // 108104-108111
 93, 104, 103, 129, 146, 156, 152, 171, // 108112-108119
169, 157, 148, 119, 112, 108, 111, 119, // 108120-108127
 93,  82, 135, 173, 191, 191, 187, 176, // 108128-108135
166, 178, 156, 114,  90,  80,  72,  81, // 108136-108143
 67,  77,  97,  93, 136, 161, 150, 141, // 108144-108151
147, 133, 108, 108, 122, 105,  97,  90, // 108152-108159
 83, 114, 129, 145, 145, 141, 147, 183, // 108160-108167
178, 141, 140, 150, 147, 148, 162, 131, // 108168-108175
123, 128, 126, 125, 122, 118, 124, 113, // 108176-108183
100, 108, 108, 116, 108, 136, 120, 108, // 108184-108191
134, 130, 112, 106, 102, 107, 123, 111, // 108192-108199
110,  94, 106, 127, 147, 148, 148, 165, // 108200-108207
177, 162, 157, 170, 149, 157, 139, 122, // 108208-108215
112, 110, 112, 102,  97, 105, 131, 148, // 108216-108223
150, 144, 144, 128, 144, 147, 126, 101, // 108224-108231
 76,  70,  71,  79,  76,  85, 100, 133, // 108232-108239
150, 164, 166, 168, 178, 153, 148, 152, // 108240-108247
131, 117, 103,  82, 102, 129, 150, 149, // 108248-108255
139, 153, 162, 177, 163, 137, 126, 116, // 108256-108263
112, 124, 105,  79,  95,  99, 112, 129, // 108264-108271
128, 112, 105, 112, 112, 114, 118, 120, // 108272-108279
123, 127, 117, 148, 155, 142, 138, 138, // 108280-108287
137, 140, 152, 118,  95, 111, 139, 147, // 108288-108295
156, 142, 146, 158, 154, 164, 153, 130, // 108296-108303
115, 119, 101,  88,  82,  92,  76,  92, // 108304-108311
123, 119, 134, 137, 141, 138, 135, 139, // 108312-108319
154, 128, 106,  99, 101, 105, 110, 122, // 108320-108327
107, 122, 153, 170, 154, 159, 165, 174, // 108328-108335
168, 154, 151, 126, 113, 103, 102,  89, // 108336-108343
 97, 117, 116, 107, 126, 135, 142, 148, // 108344-108351
142, 142, 116, 113, 115, 105,  83,  82, // 108352-108359
 99, 114, 119, 130, 133, 123, 151, 156, // 108360-108367
149, 147, 142, 144, 137, 119, 130, 146, // 108368-108375
143, 144, 138, 141, 131, 141, 136, 105, // 108376-108383
103, 114, 117, 120, 120, 110, 118, 128, // 108384-108391
143, 150, 138, 116, 109, 113,  96,  92, // 108392-108399
 95,  88,  95, 122, 124, 136, 154, 162, // 108400-108407
164, 159, 171, 164, 158, 129, 101, 105, // 108408-108415
113, 117, 127, 113, 108, 141, 152, 159, // 108416-108423
153, 149, 139, 140, 140, 126, 102,  92, // 108424-108431
 86,  88, 108,  97, 108, 106, 106, 123, // 108432-108439
135, 138, 147, 149, 135, 127, 133, 144, // 108440-108447
127, 123, 109, 118, 132, 140, 136, 123, // 108448-108455
125, 145, 169, 157, 150, 140, 140, 128, // 108456-108463
133, 130, 114, 114, 114, 113, 114, 111, // 108464-108471
114, 122, 106, 120, 121, 117, 116, 115, // 108472-108479
115, 104, 121, 144, 143, 129, 130, 125, // 108480-108487
138, 136, 126, 124, 112, 118, 137, 131, // 108488-108495
121, 142, 158, 163, 158, 170, 158, 143, // 108496-108503
139, 116, 106,  99,  98, 100,  95,  87, // 108504-108511
105, 128, 137, 144, 155, 144, 129, 144, // 108512-108519
131, 105,  94,  93,  95, 103, 104, 109, // 108520-108527
120, 128, 148, 156, 165, 159, 166, 162, // 108528-108535
127, 129, 142, 131, 125, 121, 110, 124, // 108536-108543
131, 137, 129, 122, 128, 138, 145, 129, // 108544-108551
118, 114, 113, 112, 133, 120, 106, 108, // 108552-108559
107, 112, 112, 117, 116, 120, 120, 126, // 108560-108567
129, 139, 135, 141, 133, 134, 157, 154, // 108568-108575
143, 123, 125, 132, 146, 141, 129, 115, // 108576-108583
120, 128, 133, 135, 122, 131, 135, 135, // 108584-108591
141, 137, 117, 120, 112, 112, 112, 101, // 108592-108599
 98,  87,  96, 100, 117, 136, 143, 144, // 108600-108607
149, 146, 158, 163, 135, 123, 115, 115, // 108608-108615
117, 117, 102, 106, 127, 151, 159, 165, // 108616-108623
163, 154, 161, 142, 135, 129, 111, 100, // 108624-108631
 98,  94,  92, 106, 117, 114, 124, 137, // 108632-108639
130, 139, 135, 120, 115, 113, 120, 129, // 108640-108647
121, 107, 118, 128, 136, 137, 142, 135, // 108648-108655
133, 149, 135, 126, 134, 137, 139, 142, // 108656-108663
135, 145, 146, 137, 133, 127, 123, 119, // 108664-108671
127, 111,  95,  98, 108, 110, 122, 127, // 108672-108679
123, 128, 130, 140, 132, 122, 116, 122, // 108680-108687
120, 111, 110, 115, 108, 118, 132, 130, // 108688-108695
149, 155, 160, 148, 142, 153, 159, 149, // 108696-108703
129, 120, 116, 115, 114, 118, 100, 108, // 108704-108711
128, 137, 139, 141, 133, 134, 135, 132, // 108712-108719
135, 111,  99,  92,  97,  92,  97, 116, // 108720-108727
118, 122, 137, 144, 149, 161, 149, 140, // 108728-108735
132, 137, 138, 131, 110, 103, 125, 137, // 108736-108743
142, 144, 141, 129, 144, 144, 132, 127, // 108744-108751
121, 117, 117, 120, 119, 118, 119, 118, // 108752-108759
122, 129, 120, 120, 118, 105, 107, 113, // 108760-108767
118, 123, 127, 124, 130, 140, 146, 142, // 108768-108775
138, 134, 132, 134, 128, 120, 119, 120, // 108776-108783
125, 133, 131, 135, 139, 137, 136, 136, // 108784-108791
136, 130, 128, 122, 117, 116, 117, 117, // 108792-108799
118, 118, 121, 128, 129, 130, 132, 128, // 108800-108807
127, 130, 130, 126, 124, 124, 123, 123, // 108808-108815
125, 123, 128, 128, 127, 130, 128, 129, // 108816-108823
133, 132, 128, 130, 131, 130, 128, 127, // 108824-108831
124, 125, 126, 126, 126, 126, 125, 127, // 108832-108839
129, 127, 129, 129, 127, 127, 127, 127, // 108840-108847
126, 128, 127, 125, 127, 126, 127, 128, // 108848-108855
123, 123, 125, 125, 126, 127, 125, 126, // 108856-108863
130, 132, 130, 131, 131, 128, 127, 125, // 108864-108871
123, 123, 124, 121, 123, 124, 126, 131, // 108872-108879
131, 131, 131, 133, 131, 132, 129, 125, // 108880-108887
124, 125, 124, 125, 125, 123, 125, 127, // 108888-108895
128, 128, 129, 126, 128, 128, 126, 126, // 108896-108903
127, 125, 124, 126, 125, 127, 128, 126, // 108904-108911
125, 127, 127, 129, 129, 126, 126, 130, // 108912-108919
131, 129, 131, 129, 127, 130, 130, 127, // 108920-108927
129, 126, 125, 127, 125, 125, 126, 127, // 108928-108935
125, 126, 127, 127, 129, 128, 125, 124, // 108936-108943
126, 125, 126, 126, 122, 123, 125, 126, // 108944-108951
126, 127, 125, 128, 131, 131, 131, 132, // 108952-108959
130, 130, 129, 126, 126, 126, 125, 123, // 108960-108967
125, 125, 128, 131, 131, 129, 131, 132, // 108968-108975
131, 130, 125, 123, 123, 122, 122, 122, // 108976-108983
121, 122, 124, 126, 129, 129, 131, 129, // 108984-108991
130, 130, 128, 127, 128, 126, 125, 126, // 108992-108999
127, 129, 128, 126, 126, 129, 130, 131, // 109000-109007
129, 126, 126, 128, 129, 129, 127, 126, // 109008-109015
127, 127, 127, 125, 124, 124, 123, 124, // 109016-109023
124, 125, 126, 125, 126, 129, 130, 132, // 109024-109031
132, 128, 125, 127, 127, 127, 125, 122, // 109032-109039
122, 125, 128, 128, 128, 129, 129, 132, // 109040-109047
134, 131, 130, 129, 127, 127, 127, 125, // 109048-109055
125, 124, 122, 121, 125, 127, 128, 129, // 109056-109063
127, 129, 132, 133, 130, 128, 126, 126, // 109064-109071
127, 124, 121, 120, 121, 122, 128, 130, // 109072-109079
129, 129, 131, 132, 132, 132, 130, 128, // 109080-109087
126, 125, 124, 124, 124, 124, 124, 125, // 109088-109095
128, 131, 129, 127, 127, 127, 129, 129, // 109096-109103
127, 125, 124, 126, 127, 127, 126, 126, // 109104-109111
126, 126, 124, 125, 125, 125, 126, 128, // 109112-109119
130, 131, 133, 131, 131, 130, 129, 130, // 109120-109127
128, 126, 123, 121, 122, 124, 126, 126, // 109128-109135
126, 128, 131, 131, 131, 129, 129, 128, // 109136-109143
128, 126, 124, 121, 121, 121, 121, 124, // 109144-109151
128, 129, 128, 129, 129, 132, 133, 132, // 109152-109159
131, 129, 127, 128, 127, 125, 123, 121, // 109160-109167
124, 125, 129, 128, 126, 128, 131, 132, // 109168-109175
131, 130, 127, 126, 123, 124, 124, 124, // 109176-109183
123, 123, 123, 126, 128, 130, 127, 127, // 109184-109191
129, 130, 132, 130, 127, 125, 126, 128, // 109192-109199
129, 129, 127, 125, 126, 128, 127, 128, // 109200-109207
125, 125, 127, 129, 128, 128, 129, 129, // 109208-109215
129, 130, 130, 129, 126, 122, 121, 121, // 109216-109223
123, 124, 123, 123, 126, 131, 132, 132, // 109224-109231
130, 131, 131, 132, 129, 124, 122, 120, // 109232-109239
121, 123, 125, 126, 128, 128, 130, 132, // 109240-109247
133, 132, 132, 130, 126, 125, 124, 123, // 109248-109255
122, 122, 122, 125, 128, 128, 128, 125, // 109256-109263
128, 130, 131, 129, 128, 127, 127, 127, // 109264-109271
127, 126, 126, 127, 126, 125, 125, 127, // 109272-109279
128, 127, 127, 129, 130, 131, 131, 129, // 109280-109287
128, 126, 129, 128, 126, 124, 122, 123, // 109288-109295
126, 126, 126, 126, 127, 129, 129, 128, // 109296-109303
128, 129, 129, 127, 129, 129, 128, 126, // 109304-109311
124, 121, 122, 125, 127, 126, 124, 125, // 109312-109319
129, 132, 133, 133, 132, 130, 131, 130, // 109320-109327
125, 123, 120, 119, 121, 123, 126, 125, // 109328-109335
126, 129, 131, 133, 135, 134, 132, 127, // 109336-109343
125, 125, 125, 123, 120, 119, 121, 126, // 109344-109351
129, 128, 127, 129, 133, 135, 134, 129, // 109352-109359
126, 125, 125, 126, 124, 124, 124, 124, // 109360-109367
126, 127, 128, 128, 127, 129, 128, 128, // 109368-109375
129, 128, 128, 126, 127, 129, 130, 128, // 109376-109383
125, 122, 124, 126, 126, 125, 123, 125, // 109384-109391
129, 131, 131, 130, 130, 131, 131, 131, // 109392-109399
127, 125, 124, 123, 123, 123, 125, 125, // 109400-109407
126, 126, 127, 128, 130, 131, 131, 129, // 109408-109415
128, 129, 129, 127, 125, 123, 123, 125, // 109416-109423
124, 123, 122, 125, 128, 130, 131, 132, // 109424-109431
133, 133, 131, 130, 127, 126, 127, 124, // 109432-109439
120, 120, 122, 126, 127, 127, 128, 131, // 109440-109447
134, 134, 132, 128, 125, 126, 126, 125, // 109448-109455
122, 122, 121, 123, 125, 126, 127, 129, // 109456-109463
130, 129, 129, 128, 128, 128, 126, 126, // 109464-109471
126, 128, 129, 129, 126, 126, 128, 131, // 109472-109479
128, 127, 125, 124, 128, 129, 127, 128, // 109480-109487
128, 129, 131, 130, 127, 126, 124, 124, // 109488-109495
124, 123, 123, 122, 124, 124, 126, 130, // 109496-109503
130, 132, 131, 129, 128, 130, 128, 126, // 109504-109511
123, 121, 123, 126, 126, 124, 125, 128, // 109512-109519
132, 134, 132, 130, 131, 131, 130, 129, // 109520-109527
125, 124, 123, 123, 122, 121, 123, 124, // 109528-109535
127, 127, 128, 130, 131, 131, 130, 127, // 109536-109543
126, 126, 126, 123, 121, 121, 123, 126, // 109544-109551
127, 128, 129, 132, 132, 132, 131, 129, // 109552-109559
131, 130, 127, 125, 125, 126, 127, 126, // 109560-109567
126, 126, 128, 130, 129, 127, 125, 125, // 109568-109575
126, 127, 126, 126, 124, 125, 128, 129, // 109576-109583
127, 127, 127, 126, 126, 125, 123, 124, // 109584-109591
125, 125, 127, 130, 132, 133, 132, 131, // 109592-109599
130, 132, 131, 126, 124, 121, 122, 123, // 109600-109607
123, 124, 125, 127, 130, 133, 132, 131, // 109608-109615
130, 129, 128, 126, 123, 120, 119, 120, // 109616-109623
120, 123, 125, 129, 131, 131, 132, 132, // 109624-109631
133, 132, 130, 127, 126, 126, 124, 123, // 109632-109639
123, 124, 125, 128, 129, 129, 129, 130, // 109640-109647
130, 130, 128, 128, 127, 125, 125, 123, // 109648-109655
123, 123, 124, 125, 124, 125, 126, 128, // 109656-109663
129, 128, 127, 129, 129, 129, 128, 127, // 109664-109671
126, 128, 128, 128, 128, 127, 128, 127, // 109672-109679
128, 127, 128, 127, 127, 127, 127, 127, // 109680-109687
129, 130, 128, 127, 129, 127, 126, 125, // 109688-109695
122, 121, 122, 123, 124, 125, 125, 127, // 109696-109703
129, 132, 133, 133, 131, 129, 129, 127, // 109704-109711
123, 122, 121, 121, 123, 125, 127, 130, // 109712-109719
131, 132, 134, 135, 135, 133, 130, 126, // 109720-109727
124, 123, 122, 120, 120, 121, 124, 127, // 109728-109735
129, 129, 130, 131, 131, 130, 129, 127, // 109736-109743
124, 123, 123, 124, 123, 123, 126, 125, // 109744-109751
126, 127, 128, 129, 129, 129, 129, 129, // 109752-109759
130, 130, 129, 128, 128, 128, 128, 126, // 109760-109767
125, 125, 124, 126, 127, 127, 127, 127, // 109768-109775
128, 128, 129, 129, 129, 127, 126, 126, // 109776-109783
125, 124, 124, 124, 123, 123, 125, 125, // 109784-109791
126, 127, 128, 129, 131, 133, 132, 131, // 109792-109799
129, 129, 129, 126, 125, 124, 122, 124, // 109800-109807
125, 126, 126, 128, 131, 132, 131, 133, // 109808-109815
132, 129, 128, 125, 124, 123, 122, 122, // 109816-109823
121, 121, 125, 127, 128, 129, 131, 131, // 109824-109831
131, 132, 130, 127, 125, 124, 124, 123, // 109832-109839
123, 123, 124, 127, 129, 131, 131, 131, // 109840-109847
131, 130, 128, 128, 129, 127, 125, 125, // 109848-109855
125, 126, 126, 127, 126, 126, 128, 128, // 109856-109863
127, 126, 126, 126, 127, 128, 129, 128, // 109864-109871
128, 127, 127, 127, 126, 125, 124, 124, // 109872-109879
125, 127, 127, 126, 128, 130, 130, 131, // 109880-109887
132, 131, 129, 128, 128, 126, 126, 124, // 109888-109895
123, 123, 124, 125, 126, 126, 128, 130, // 109896-109903
130, 131, 131, 130, 128, 127, 126, 124, // 109904-109911
124, 122, 122, 122, 124, 125, 127, 128, // 109912-109919
130, 131, 132, 132, 132, 130, 127, 127, // 109920-109927
125, 124, 123, 123, 122, 123, 126, 128, // 109928-109935
129, 130, 132, 131, 130, 131, 129, 128, // 109936-109943
125, 124, 124, 123, 123, 124, 124, 125, // 109944-109951
126, 128, 129, 129, 129, 129, 128, 127, // 109952-109959
128, 127, 127, 125, 127, 126, 126, 128, // 109960-109967
127, 126, 127, 127, 126, 126, 125, 127, // 109968-109975
128, 128, 130, 130, 129, 128, 129, 127, // 109976-109983
125, 125, 124, 122, 123, 124, 124, 126, // 109984-109991
127, 129, 130, 131, 131, 131, 130, 128, // 109992-109999
127, 126, 124, 124, 124, 123, 124, 126, // 110000-110007
128, 127, 129, 129, 130, 130, 130, 131, // 110008-110015
129, 127, 126, 126, 123, 123, 122, 122, // 110016-110023
122, 124, 126, 127, 129, 130, 131, 131, // 110024-110031
132, 130, 130, 126, 125, 124, 123, 122, // 110032-110039
123, 124, 125, 128, 129, 131, 130, 131, // 110040-110047
130, 130, 129, 128, 127, 126, 125, 125, // 110048-110055
125, 124, 126, 125, 126, 126, 127, 126, // 110056-110063
127, 128, 128, 128, 127, 128, 129, 128, // 110064-110071
127, 128, 127, 126, 127, 126, 126, 126, // 110072-110079
127, 127, 127, 128, 129, 130, 131, 131, // 110080-110087
131, 130, 129, 128, 126, 124, 123, 123, // 110088-110095
122, 123, 124, 126, 126, 128, 130, 130, // 110096-110103
130, 130, 130, 129, 126, 125, 125, 123, // 110104-110111
123, 123, 124, 124, 126, 128, 128, 129, // 110112-110119
131, 131, 131, 131, 131, 128, 128, 126, // 110120-110127
126, 123, 123, 124, 124, 126, 126, 128, // 110128-110135
128, 129, 131, 131, 129, 129, 128, 126, // 110136-110143
125, 124, 124, 123, 124, 124, 126, 126, // 110144-110151
128, 128, 128, 128, 129, 129, 128, 128, // 110152-110159
126, 126, 126, 127, 127, 126, 126, 127, // 110160-110167
127, 127, 127, 127, 126, 126, 127, 128, // 110168-110175
128, 128, 129, 129, 129, 129, 128, 127, // 110176-110183
125, 125, 124, 124, 124, 125, 124, 125, // 110184-110191
128, 130, 130, 129, 130, 129, 128, 128, // 110192-110199
127, 125, 123, 124, 124, 124, 125, 127, // 110200-110207
127, 128, 130, 131, 131, 130, 130, 129, // 110208-110215
127, 127, 126, 125, 124, 124, 125, 126, // 110216-110223
126, 127, 127, 129, 129, 131, 129, 127, // 110224-110231
127, 127, 126, 126, 125, 125, 125, 124, // 110232-110239
126, 127, 126, 127, 128, 128, 128, 129, // 110240-110247
128, 127, 127, 129, 128, 128, 128, 127, // 110248-110255
127, 126, 127, 128, 127, 126, 127, 127, // 110256-110263
127, 127, 127, 127, 127, 128, 129, 128, // 110264-110271
127, 126, 126, 126, 126, 126, 124, 124, // 110272-110279
126, 125, 125, 126, 128, 128, 128, 129, // 110280-110287
129, 128, 129, 128, 127, 126, 125, 126, // 110288-110295
126, 125, 126, 127, 128, 129, 130, 131, // 110296-110303
129, 128, 129, 128, 126, 126, 126, 125, // 110304-110311
125, 125, 126, 126, 127, 128, 128, 129, // 110312-110319
128, 128, 126, 126, 126, 126, 126, 126, // 110320-110327
125, 125, 125, 127, 128, 129, 128, 129, // 110328-110335
128, 129, 128, 128, 127, 127, 127, 128, // 110336-110343
128, 127, 126, 126, 126, 127, 128, 128, // 110344-110351
127, 126, 126, 127, 127, 127, 127, 126, // 110352-110359
126, 127, 128, 128, 126, 125, 126, 127, // 110360-110367
127, 127, 125, 125, 126, 127, 129, 129, // 110368-110375
129, 128, 129, 128, 129, 129, 127, 126, // 110376-110383
127, 126, 126, 126, 125, 125, 126, 128, // 110384-110391
129, 129, 128, 128, 128, 128, 128, 126, // 110392-110399
125, 124, 125, 125, 125, 125, 126, 127, // 110400-110407
128, 129, 130, 129, 128, 128, 129, 128, // 110408-110415
128, 127, 125, 124, 125, 126, 127, 128, // 110416-110423
128, 129, 129, 128, 129, 129, 126, 126, // 110424-110431
126, 126, 125, 125, 124, 124, 125, 128, // 110432-110439
128, 128, 128, 127, 127, 126, 127, 128, // 110440-110447
127, 127, 128, 127, 127, 127, 128, 127, // 110448-110455
126, 128, 128, 127, 126, 126, 126, 127, // 110456-110463
128, 129, 129, 128, 128, 128, 128, 128, // 110464-110471
127, 125, 125, 125, 124, 124, 125, 125, // 110472-110479
126, 126, 127, 129, 130, 129, 128, 128, // 110480-110487
129, 128, 128, 126, 124, 124, 124, 125, // 110488-110495
127, 127, 128, 129, 130, 131, 130, 129, // 110496-110503
129, 129, 127, 126, 126, 125, 123, 125, // 110504-110511
125, 125, 127, 128, 128, 128, 128, 129, // 110512-110519
130, 128, 127, 126, 125, 125, 126, 124, // 110520-110527
123, 126, 128, 128, 128, 128, 128, 128, // 110528-110535
129, 129, 128, 127, 127, 127, 127, 126, // 110536-110543
127, 128, 127, 127, 127, 127, 126, 128, // 110544-110551
127, 127, 127, 129, 128, 127, 126, 127, // 110552-110559
128, 128, 127, 126, 125, 125, 126, 126, // 110560-110567
124, 125, 127, 126, 128, 129, 128, 129, // 110568-110575
129, 129, 129, 127, 127, 127, 125, 124, // 110576-110583
125, 126, 125, 127, 127, 128, 128, 130, // 110584-110591
130, 129, 129, 129, 128, 128, 125, 124, // 110592-110599
124, 124, 125, 126, 125, 126, 128, 128, // 110600-110607
129, 129, 130, 129, 130, 129, 127, 125, // 110608-110615
126, 124, 124, 124, 124, 126, 127, 127, // 110616-110623
128, 129, 129, 131, 129, 128, 126, 130, // 110624-110631
125, 145, 163, 148, 113,  91,  77,  91, // 110632-110639
 72,  46,  62, 125, 216, 233, 253, 209, // 110640-110647
248, 220, 123, 121, 110, 238, 183, 242, // 110648-110655
229,  67, 143, 205, 156, 162, 205, 249, // 110656-110663
 24, 185, 124,  90,  56,  84, 108, 236, // 110664-110671
213,  27, 134, 121,  81,  75,  30,  70, // 110672-110679
 94,  96, 101, 124, 122, 163, 124, 145, // 110680-110687
  1, 234, 207, 189, 179, 179, 165, 148, // 110688-110695
118,  82, 156, 206, 236, 234, 158, 210, // 110696-110703
219, 235, 253, 177,  83,  82,  73, 251, // 110704-110711
219, 213, 245,   7,  40,  16,  56, 133, // 110712-110719
153, 168, 162, 158, 217, 230, 108,  58, // 110720-110727
 28,  58,  62, 115,  94,  51, 165, 203, // 110728-110735
251,  60,  63,  49,  79,  11, 238, 170, // 110736-110743
 80,  35,  17,   3, 215,  36,  84,  65, // 110744-110751
 63, 150, 134, 236,   3, 128,  61,   4, // 110752-110759
 47,  51,   3, 191, 245,  65, 117, 135, // 110760-110767
181, 139, 163,  11, 239, 213, 198, 188, // 110768-110775
117, 143, 168, 219, 222, 210, 193, 175, // 110776-110783
164, 139, 195, 102,  20,  46,  84,  83, // 110784-110791
108,  67,  57,  87, 193,   0, 138,  69, // 110792-110799
 11,  53,  43, 245, 253,   1, 236,  68, // 110800-110807
136, 128, 206, 255,  31,  15,  12,  35, // 110808-110815
248, 145,  99,  87,  99, 105, 121, 137, // 110816-110823
 44, 100, 205, 238, 241, 217, 191, 164, // 110824-110831
180, 151,  75, 243, 217,   5,  39, 220, // 110832-110839
212,  32,  26,  67, 142, 174, 188, 238, // 110840-110847
211, 157, 127, 169, 166, 119,  98,  46, // 110848-110855
127, 136, 127, 186, 184, 180,  28,  48, // 110856-110863
241, 196, 163, 148, 113, 144,  92,  62, // 110864-110871
 67,  73,  64,  77,  58,  95, 155,  61, // 110872-110879
 50,  47,  62,  62,  82,  57,  60, 153, // 110880-110887
212, 178, 147, 140, 133, 193, 149, 134, // 110888-110895
 89,  81,  86, 129, 171, 184, 252,  30, // 110896-110903
 22,  10,  34, 198, 175, 126,  48,  16, // 110904-110911
  1,  10,  16, 236, 245,  87, 158, 244, // 110912-110919
198, 171, 116, 130, 176,  89,  12, 245, // 110920-110927
253,  20,  56,  43,  91, 120, 181, 250, // 110928-110935
 20,  17,  16, 249, 177, 168, 199, 193, // 110936-110943
126, 124,  74,  66, 114, 141, 154, 109, // 110944-110951
107, 141, 193, 170, 108,  86,  65,  72, // 110952-110959
154, 107, 249,   7,  30,  55,  67,  86, // 110960-110967
 99, 113, 120, 132, 146, 158, 170, 172, // 110968-110975
191, 130, 192, 250, 160, 143, 169, 168, // 110976-110983
192, 213, 171, 112,  67, 110, 131, 150, // 110984-110991
115, 103, 151, 146, 164, 176, 128,  66, // 110992-110999
129, 103,  29, 238, 246, 238, 232,  22, // 111000-111007
 56, 141, 189, 212, 218, 216, 203,  23, // 111008-111015
224, 132,  93,  83,  80,  38,  88,  87, // 111016-111023
118, 192,   9,  15,  21, 234, 239, 224, // 111024-111031
145, 138,  89,  32,   4,   8, 230,   4, // 111032-111039
 57, 137, 118,  99, 126, 131, 175, 126, // 111040-111047
 99,  80,  81, 116, 138,  72,  59, 108, // 111048-111055
148, 167, 178, 191, 158, 171, 162, 171, // 111056-111063
185, 194, 187, 194, 165, 152, 192, 161, // 111064-111071
142, 117, 110,  89, 106, 120,  40,   4, // 111072-111079
 45,  76, 137, 143,  68,  84, 101, 140, // 111080-111087
160, 125,  89,  95, 123,  94,  73,  84, // 111088-111095
 85,  70, 136, 152, 166, 236, 217, 201, // 111096-111103
219, 240,  10,   1, 177, 117,  82,  77, // 111104-111111
 63,  82,  61,   6,  88, 148, 172, 169, // 111112-111119
166, 143, 165, 193, 151,  71,   3, 239, // 111120-111127
239,   8, 241,  51, 106, 108, 140, 200, // 111128-111135
208, 240, 255, 202, 172, 144, 185, 125, // 111136-111143
 86,  75,  98, 157, 179, 189, 192, 150, // 111144-111151
145, 213, 177, 146, 114, 107,  88,  87, // 111152-111159
 86,  80,  71,  93, 131, 101,  85,  60, // 111160-111167
106,  64,  27,  64,  93, 112, 133, 136, // 111168-111175
118, 150, 208, 240, 195, 175, 147, 168, // 111176-111183
133,  94, 119, 110, 105, 147, 185, 155, // 111184-111191
178, 199, 209, 181, 185, 183, 138, 119, // 111192-111199
 61,  19,  16,   9,  52,  91,  12,  35, // 111200-111207
107, 137, 155, 154, 159, 143, 183, 187, // 111208-111215
128,  82,  76,  75,  99,  99,  94, 145, // 111216-111223
141, 141, 195, 239, 244,  11, 252, 188, // 111224-111231
153, 163, 133,  86,  70,  23,  56,  85, // 111232-111239
104, 110,  84,  89, 133, 197, 172, 113, // 111240-111247
 83,  69,  55,  99,  73,  49,  85, 101, // 111248-111255
121, 131, 140, 154, 168, 138, 159, 156, // 111256-111263
176, 157, 131, 139, 136, 213, 239, 202, // 111264-111271
171, 155, 131, 155, 130,  99,  57,  39, // 111272-111279
 75, 101, 108,  85, 116, 139, 176, 182, // 111280-111287
169, 102,  85,  80,  36,  31,  30,  60, // 111288-111295
 61,  70,  86, 144, 196, 228, 224, 231, // 111296-111303
202, 217, 232, 132, 105,  97, 104, 108, // 111304-111311
122, 110, 105, 116, 155, 187, 188, 184, // 111312-111319
160, 178, 137,  95, 102,  75,  39,  80, // 111320-111327
 53,  17,  48,  79,  99,  79, 108, 137, // 111328-111335
178, 189, 154, 141, 134, 131, 163, 163, // 111336-111343
103, 113, 142, 131, 120, 157, 171, 167, // 111344-111351
187, 184, 169, 160, 152, 140, 140,  97, // 111352-111359
118, 148, 118, 103,  87,  86,  80, 119, // 111360-111367
135,  70,  32,  62,  77, 100,  97,  90, // 111368-111375
134, 147, 179, 191, 162, 132, 152, 141, // 111376-111383
116, 103, 114, 108,  69, 108, 137, 191, // 111384-111391
228, 235, 227, 205, 191, 210, 174, 100, // 111392-111399
 67,  45,  50,  44,  70,  34,  41,  97, // 111400-111407
159, 195, 176, 145, 135, 142, 108, 112, // 111408-111415
 79,  59,  52,  71,  68,  75, 129, 156, // 111416-111423
147, 172, 203, 205, 237, 170, 148, 148, // 111424-111431
151, 174, 166, 126,  91, 112, 130, 135, // 111432-111439
132, 137,  96, 121, 146, 120, 107, 102, // 111440-111447
 94, 117, 129,  99, 103,  87,  87,  81, // 111448-111455
 92,  90, 109, 141,  98,  87, 119, 141, // 111456-111463
155, 170, 152, 153, 178, 201, 176, 157, // 111464-111471
154, 149, 174, 151, 122, 117,  98,  83, // 111472-111479
121, 123, 117, 147, 154, 158, 138, 145, // 111480-111487
145, 129, 126,  89,  46,  36,  32,  53, // 111488-111495
 53,  25,  92, 147, 174, 184, 186, 180, // 111496-111503
183, 198, 180, 143, 106, 106,  85,  78, // 111504-111511
 80, 123, 161, 158, 182, 205, 201, 198, // 111512-111519
205, 164, 126, 105, 121,  93,  73,  43, // 111520-111527
 35,  76,  93, 140, 138,  97,  93, 140, // 111528-111535
133, 115, 102, 105, 103, 110, 133, 114, // 111536-111543
122, 135, 144, 149, 158, 148, 181, 137, // 111544-111551
 95, 134, 153, 171, 168, 171, 139, 146, // 111552-111559
182, 186, 145, 127, 104, 108, 118,  85, // 111560-111567
 74,  52,  50,  87, 143, 120, 108, 126, // 111568-111575
135, 127, 140, 148, 119, 127, 102,  85, // 111576-111583
 84,  92, 108, 114, 100, 124, 173, 205, // 111584-111591
186, 171, 195, 181, 212, 211, 150, 109, // 111592-111599
 94,  86,  91,  88,  78,  96, 100, 131, // 111600-111607
151, 155, 151, 148, 165, 144, 110, 102, // 111608-111615
 75,  47,  50,  32,  59,  97, 126, 137, // 111616-111623
127, 146, 176, 206, 184, 161, 150, 142, // 111624-111631
137, 137, 115, 105, 135, 149, 161, 157, // 111632-111639
158, 151, 146, 135, 130, 125, 123, 115, // 111640-111647
114, 105,  79, 126, 133, 132, 132, 107, // 111648-111655
 88,  97, 100,  80,  56,  59,  99, 118, // 111656-111663
140, 124, 145, 171, 176, 192, 199, 159, // 111664-111671
149, 149,  95,  93, 102, 125, 114, 120, // 111672-111679
132, 149, 181, 188, 181, 172, 155, 151, // 111680-111687
170, 120,  73,  51,  53,  52,  85,  98, // 111688-111695
 63,  74, 111, 139, 146, 155, 143, 164, // 111696-111703
150, 133, 136, 117, 100,  99, 102,  98, // 111704-111711
119, 155, 154, 117, 155, 182, 207, 218, // 111712-111719
178, 157, 137, 131, 139, 126,  81,  79, // 111720-111727
 95, 109, 111, 114, 113,  96, 121, 146, // 111728-111735
135, 113, 101,  93,  97,  85, 104, 128, // 111736-111743
121, 122, 120, 129, 129, 153, 150, 113, // 111744-111751
112, 135, 153, 148, 130, 132, 165, 180, // 111752-111759
202, 197, 166, 140, 137, 134, 103,  89, // 111760-111767
 88,  73,  68, 103,  97, 120, 139, 147, // 111768-111775
172, 155, 143, 142, 124,  82,  61,  57, // 111776-111783
 69,  73,  99,  85,  86, 143, 177, 190, // 111784-111791
193, 190, 180, 192, 158, 138, 123, 113, // 111792-111799
110, 113, 115, 102, 133, 140, 132, 144, // 111800-111807
162, 155, 166, 152, 125, 100,  99, 108, // 111808-111815
 99, 104,  68,  71,  90,  99, 106, 114, // 111816-111823
 97, 122, 157, 144, 140, 132, 138, 133, // 111824-111831
140, 143, 142, 141, 147, 121, 126, 140, // 111832-111839
149, 174, 138, 127, 138, 144, 143, 143, // 111840-111847
128, 117, 130, 152, 149, 121, 107,  95, // 111848-111855
106, 111, 108,  89,  66,  61,  92, 105, // 111856-111863
104, 128, 146, 156, 152, 169, 166, 153, // 111864-111871
144, 114, 107, 106, 110, 119,  96,  83, // 111872-111879
135, 177, 197, 198, 192, 180, 166, 179, // 111880-111887
157, 114,  86,  76,  68,  82,  70,  78, // 111888-111895
100,  96, 139, 165, 156, 142, 147, 131, // 111896-111903
105, 101, 115, 100,  91,  87,  79, 114, // 111904-111911
132, 149, 148, 143, 148, 185, 182, 141, // 111912-111919
137, 144, 144, 145, 162, 131, 123, 129, // 111920-111927
130, 128, 127, 121, 125, 116, 103, 109, // 111928-111935
109, 116, 106, 134, 119, 106, 133, 132, // 111936-111943
112, 105, 102, 105, 125, 113, 108,  91, // 111944-111951
102, 126, 146, 146, 145, 164, 178, 166, // 111952-111959
159, 171, 148, 156, 141, 121, 110, 109, // 111960-111967
112, 103, 100, 107, 134, 151, 155, 148, // 111968-111975
145, 129, 143, 147, 123,  93,  70,  65, // 111976-111983
 67,  77,  74,  84, 102, 137, 155, 166, // 111984-111991
165, 166, 178, 151, 143, 145, 127, 115, // 111992-111999
103,  82, 103, 133, 157, 157, 144, 157, // 112000-112007
164, 180, 165, 136, 124, 113, 111, 124, // 112008-112015
107,  76,  93,  99, 113, 130, 130, 109, // 112016-112023
101, 112, 110, 111, 116, 117, 121, 125, // 112024-112031
114, 145, 157, 148, 140, 137, 136, 141, // 112032-112039
156, 119,  91, 107, 139, 149, 162, 145, // 112040-112047
145, 158, 160, 169, 158, 131, 114, 119, // 112048-112055
102,  88,  81,  89,  73,  92, 124, 118, // 112056-112063
135, 139, 140, 136, 134, 139, 155, 130, // 112064-112071
103,  92,  97, 105, 114, 123, 104, 120, // 112072-112079
156, 175, 158, 162, 162, 174, 173, 158, // 112080-112087
150, 124, 110, 101, 103,  91,  99, 120, // 112088-112095
121, 111, 129, 134, 141, 148, 140, 133, // 112096-112103
108, 107, 111, 105,  83,  82, 102, 121, // 112104-112111
127, 134, 132, 121, 148, 154, 143, 141, // 112112-112119
139, 142, 138, 120, 130, 148, 151, 152, // 112120-112127
143, 142, 132, 143, 138, 103,  98, 111, // 112128-112135
117, 122, 123, 107, 114, 128, 145, 154, // 112136-112143
138, 114, 106, 111,  95,  88,  90,  86, // 112144-112151
 94, 124, 125, 135, 156, 166, 166, 159, // 112152-112159
170, 164, 160, 130,  97,  99, 113, 122, // 112160-112167
133, 118, 107, 141, 159, 165, 155, 149, // 112168-112175
136, 139, 140, 125,  96,  84,  83,  86, // 112176-112183
109,  99, 108, 110, 109, 123, 135, 137, // 112184-112191
147, 150, 134, 120, 123, 139, 128, 124, // 112192-112199
109, 117, 137, 151, 144, 128, 124, 145, // 112200-112207
172, 160, 147, 133, 134, 124, 132, 130, // 112208-112215
115, 116, 120, 118, 116, 112, 112, 122, // 112216-112223
104, 115, 116, 113, 113, 114, 114, 103, // 112224-112231
121, 148, 150, 133, 130, 122, 136, 139, // 112232-112239
127, 121, 110, 118, 140, 136, 122, 141, // 112240-112247
162, 170, 162, 170, 158, 140, 137, 114, // 112248-112255
100,  95,  98, 103,  98,  88, 105, 130, // 112256-112263
142, 147, 155, 141, 124, 138, 129, 100, // 112264-112271
 86,  88,  94, 106, 108, 111, 123, 133, // 112272-112279
156, 162, 167, 160, 165, 161, 123, 121, // 112280-112287
137, 130, 126, 123, 110, 124, 136, 145, // 112288-112295
134, 122, 126, 139, 145, 127, 112, 106, // 112296-112303
106, 108, 133, 120, 105, 109, 111, 115, // 112304-112311
114, 117, 117, 120, 120, 125, 126, 135, // 112312-112319
135, 144, 134, 133, 160, 161, 148, 124, // 112320-112327
124, 130, 146, 145, 130, 110, 115, 129, // 112328-112335
136, 136, 121, 132, 136, 137, 141, 135, // 112336-112343
111, 114, 109, 108, 106,  98, 100,  89, // 112344-112351
 98, 105, 122, 140, 149, 148, 147, 138, // 112352-112359
152, 161, 135, 117, 112, 116, 120, 125, // 112360-112367
109, 110, 130, 158, 167, 166, 160, 151, // 112368-112375
155, 137, 127, 122, 107,  97,  97,  93, // 112376-112383
 90, 105, 123, 121, 125, 139, 132, 139, // 112384-112391
134, 117, 110, 107, 115, 130, 123, 106, // 112392-112399
116, 131, 142, 142, 147, 140, 133, 151, // 112400-112407
140, 124, 130, 136, 143, 143, 133, 144, // 112408-112415
146, 137, 129, 123, 119, 116, 126, 113, // 112416-112423
 92,  93, 111, 116, 125, 131, 125, 126, // 112424-112431
128, 139, 131, 117, 110, 121, 120, 111, // 112432-112439
110, 116, 112, 123, 139, 137, 151, 158, // 112440-112447
164, 147, 135, 147, 157, 147, 126, 115, // 112448-112455
113, 115, 117, 124, 103, 109, 132, 142, // 112456-112463
140, 137, 128, 129, 129, 128, 133, 109, // 112464-112471
 99,  93, 100,  95,  99, 120, 124, 123, // 112472-112479
137, 144, 146, 158, 150, 140, 128, 135, // 112480-112487
140, 135, 112, 102, 124, 140, 146, 149, // 112488-112495
141, 125, 143, 146, 133, 123, 119, 117, // 112496-112503
114, 116, 117, 115, 117, 119, 122, 130, // 112504-112511
119, 121, 120, 105, 106, 115, 121, 124, // 112512-112519
129, 126, 127, 136, 149, 146, 137, 132, // 112520-112527
131, 136, 130, 121, 119, 119, 125, 137, // 112528-112535
135, 134, 136, 139, 136, 132, 133, 128, // 112536-112543
124, 119, 115, 112, 114, 118, 123, 123, // 112544-112551
124, 130, 131, 131, 129, 129, 125, 125, // 112552-112559
129, 128, 121, 121, 125, 128, 132, 131, // 112560-112567
133, 130, 131, 131, 129, 126, 127, 129, // 112568-112575
128, 123, 124, 128, 127, 128, 127, 127, // 112576-112583
128, 130, 129, 125, 121, 123, 127, 127, // 112584-112591
126, 126, 127, 125, 128, 131, 129, 128, // 112592-112599
130, 131, 129, 128, 127, 127, 125, 127, // 112600-112607
127, 125, 125, 127, 127, 123, 125, 130, // 112608-112615
133, 130, 129, 126, 127, 127, 127, 124, // 112616-112623
121, 122, 125, 125, 124, 125, 128, 130, // 112624-112631
130, 132, 130, 127, 128, 128, 127, 126, // 112632-112639
128, 128, 128, 127, 129, 129, 129, 128, // 112640-112647
128, 125, 123, 125, 125, 123, 123, 126, // 112648-112655
127, 130, 131, 130, 128, 128, 129, 127, // 112656-112663
125, 122, 123, 122, 122, 124, 126, 128, // 112664-112671
131, 134, 134, 133, 134, 134, 129, 126, // 112672-112679
125, 125, 124, 123, 123, 123, 125, 128, // 112680-112687
131, 131, 130, 131, 130, 128, 127, 125, // 112688-112695
124, 122, 122, 123, 122, 122, 126, 127, // 112696-112703
127, 128, 130, 130, 128, 127, 126, 126, // 112704-112711
127, 128, 127, 127, 127, 129, 130, 129, // 112712-112719
130, 130, 128, 127, 128, 127, 126, 127, // 112720-112727
127, 127, 128, 128, 128, 127, 126, 127, // 112728-112735
128, 126, 125, 125, 124, 123, 125, 125, // 112736-112743
124, 125, 127, 126, 129, 130, 129, 129, // 112744-112751
128, 129, 129, 127, 126, 124, 124, 124, // 112752-112759
125, 128, 128, 128, 130, 131, 131, 133, // 112760-112767
132, 129, 128, 126, 125, 123, 122, 120, // 112768-112775
121, 123, 125, 128, 129, 128, 129, 130, // 112776-112783
129, 130, 128, 125, 123, 123, 122, 122, // 112784-112791
124, 126, 128, 130, 131, 132, 133, 132, // 112792-112799
130, 129, 127, 127, 126, 124, 123, 125, // 112800-112807
127, 128, 128, 130, 129, 129, 129, 127, // 112808-112815
126, 124, 124, 123, 122, 123, 125, 126, // 112816-112823
125, 127, 129, 130, 129, 129, 127, 125, // 112824-112831
125, 125, 127, 127, 125, 127, 128, 128, // 112832-112839
132, 132, 131, 130, 130, 129, 128, 126, // 112840-112847
125, 124, 124, 124, 127, 127, 126, 127, // 112848-112855
127, 128, 130, 130, 127, 124, 125, 125, // 112856-112863
123, 124, 124, 122, 125, 125, 128, 129, // 112864-112871
129, 129, 130, 131, 131, 131, 129, 127, // 112872-112879
125, 126, 126, 127, 127, 126, 127, 129, // 112880-112887
130, 133, 132, 129, 129, 129, 128, 126, // 112888-112895
123, 120, 121, 124, 123, 125, 126, 127, // 112896-112903
128, 130, 129, 129, 129, 126, 124, 124, // 112904-112911
124, 124, 125, 126, 126, 130, 131, 132, // 112912-112919
133, 131, 129, 130, 128, 128, 126, 123, // 112920-112927
123, 125, 127, 128, 128, 130, 130, 131, // 112928-112935
130, 127, 128, 125, 124, 122, 121, 123, // 112936-112943
124, 125, 125, 127, 130, 131, 130, 130, // 112944-112951
127, 126, 127, 125, 125, 124, 124, 126, // 112952-112959
128, 128, 130, 131, 131, 130, 131, 130, // 112960-112967
129, 129, 126, 126, 124, 123, 125, 127, // 112968-112975
126, 126, 126, 127, 129, 130, 129, 125, // 112976-112983
127, 128, 126, 124, 124, 123, 124, 124, // 112984-112991
126, 126, 126, 127, 128, 130, 130, 130, // 112992-112999
130, 127, 126, 127, 125, 125, 126, 125, // 113000-113007
125, 126, 129, 130, 130, 129, 129, 129, // 113008-113015
129, 127, 126, 122, 122, 126, 126, 125, // 113016-113023
126, 127, 129, 130, 130, 129, 128, 127, // 113024-113031
126, 124, 123, 123, 124, 124, 124, 129, // 113032-113039
131, 131, 131, 131, 130, 130, 130, 128, // 113040-113047
123, 123, 122, 123, 126, 125, 127, 127, // 113048-113055
129, 133, 133, 130, 128, 128, 127, 125, // 113056-113063
124, 125, 123, 124, 125, 125, 127, 130, // 113064-113071
131, 130, 128, 129, 130, 127, 125, 124, // 113072-113079
124, 124, 126, 127, 126, 127, 130, 129, // 113080-113087
130, 129, 129, 128, 126, 127, 126, 124, // 113088-113095
125, 126, 127, 126, 125, 128, 129, 128, // 113096-113103
129, 127, 127, 128, 128, 125, 123, 124, // 113104-113111
127, 126, 126, 125, 126, 128, 129, 130, // 113112-113119
129, 128, 130, 130, 127, 126, 125, 126, // 113120-113127
125, 124, 125, 126, 127, 129, 130, 128, // 113128-113135
129, 131, 131, 128, 126, 125, 124, 125, // 113136-113143
125, 125, 124, 126, 130, 130, 129, 129, // 113144-113151
129, 129, 127, 126, 125, 122, 123, 124, // 113152-113159
125, 126, 128, 130, 130, 129, 130, 131, // 113160-113167
129, 129, 125, 123, 123, 124, 126, 125, // 113168-113175
124, 128, 130, 132, 131, 130, 129, 127, // 113176-113183
128, 127, 124, 122, 124, 124, 124, 125, // 113184-113191
127, 128, 129, 130, 129, 129, 128, 129, // 113192-113199
127, 124, 124, 126, 126, 125, 125, 126, // 113200-113207
128, 129, 131, 129, 128, 129, 129, 129, // 113208-113215
127, 126, 127, 126, 126, 127, 125, 126, // 113216-113223
127, 128, 127, 127, 127, 128, 128, 127, // 113224-113231
126, 126, 127, 126, 127, 125, 125, 127, // 113232-113239
129, 128, 127, 130, 129, 128, 129, 127, // 113240-113247
124, 126, 125, 125, 125, 125, 128, 129, // 113248-113255
130, 130, 130, 129, 129, 128, 125, 123, // 113256-113263
124, 125, 124, 125, 126, 126, 129, 130, // 113264-113271
130, 129, 129, 130, 129, 126, 124, 124, // 113272-113279
125, 123, 124, 126, 126, 128, 129, 129, // 113280-113287
129, 129, 130, 130, 127, 125, 125, 125, // 113288-113295
125, 126, 125, 125, 127, 131, 130, 128, // 113296-113303
130, 129, 129, 129, 127, 126, 124, 125, // 113304-113311
126, 125, 125, 127, 129, 128, 127, 129, // 113312-113319
129, 127, 127, 126, 125, 126, 126, 126, // 113320-113327
126, 126, 127, 129, 128, 127, 128, 127, // 113328-113335
127, 128, 127, 125, 126, 127, 127, 126, // 113336-113343
126, 127, 128, 129, 128, 128, 128, 127, // 113344-113351
128, 127, 126, 126, 126, 125, 125, 126, // 113352-113359
125, 126, 127, 128, 128, 127, 128, 128, // 113360-113367
128, 126, 126, 127, 126, 126, 125, 125, // 113368-113375
125, 128, 129, 127, 128, 130, 129, 130, // 113376-113383
128, 127, 127, 126, 126, 126, 125, 125, // 113384-113391
127, 127, 127, 129, 129, 129, 127, 128, // 113392-113399
126, 126, 125, 125, 124, 124, 124, 126, // 113400-113407
128, 127, 128, 128, 129, 129, 129, 126, // 113408-113415
124, 126, 125, 126, 126, 126, 127, 129, // 113416-113423
130, 130, 129, 129, 129, 128, 127, 126, // 113424-113431
127, 126, 125, 126, 127, 127, 128, 129, // 113432-113439
128, 127, 127, 127, 126, 126, 124, 125, // 113440-113447
125, 126, 127, 126, 126, 127, 129, 128, // 113448-113455
127, 126, 126, 127, 127, 126, 127, 127, // 113456-113463
128, 127, 127, 127, 128, 129, 128, 127, // 113464-113471
128, 128, 128, 128, 127, 127, 127, 127, // 113472-113479
127, 127, 126, 125, 127, 126, 127, 128, // 113480-113487
127, 127, 127, 127, 127, 126, 125, 126, // 113488-113495
126, 126, 126, 128, 129, 128, 127, 128, // 113496-113503
129, 130, 127, 126, 127, 125, 127, 127, // 113504-113511
126, 127, 128, 128, 129, 130, 129, 128, // 113512-113519
127, 128, 127, 127, 126, 125, 125, 125, // 113520-113527
127, 127, 128, 127, 128, 127, 128, 127, // 113528-113535
128, 125, 124, 126, 126, 127, 126, 126, // 113536-113543
127, 128, 128, 129, 128, 127, 126, 127, // 113544-113551
128, 127, 128, 127, 126, 127, 128, 129, // 113552-113559
129, 128, 128, 127, 127, 128, 125, 126, // 113560-113567
126, 126, 126, 128, 128, 127, 126, 127, // 113568-113575
128, 127, 128, 125, 126, 126, 126, 126, // 113576-113583
126, 127, 126, 127, 129, 129, 128, 129, // 113584-113591
127, 128, 128, 128, 129, 126, 126, 126, // 113592-113599
127, 127, 127, 128, 127, 127, 128, 128, // 113600-113607
128, 128, 127, 127, 128, 128, 127, 126, // 113608-113615
124, 125, 126, 126, 126, 127, 126, 126, // 113616-113623
126, 128, 129, 129, 128, 127, 129, 129, // 113624-113631
128, 127, 127, 126, 127, 127, 128, 127, // 113632-113639
127, 127, 128, 129, 129, 129, 128, 126, // 113640-113647
127, 128, 127, 127, 126, 125, 126, 126, // 113648-113655
127, 125, 125, 125, 126, 127, 128, 128, // 113656-113663
127, 127, 127, 129, 129, 128, 128, 126, // 113664-113671
126, 126, 126, 126, 126, 126, 127, 128, // 113672-113679
130, 130, 129, 128, 128, 130, 129, 127, // 113680-113687
125, 124, 124, 126, 125, 125, 125, 126, // 113688-113695
126, 127, 127, 128, 127, 127, 127, 128, // 113696-113703
128, 127, 127, 126, 126, 127, 128, 127, // 113704-113711
126, 125, 126, 126, 129, 130, 128, 128, // 113712-113719
127, 130, 130, 127, 127, 127, 127, 127, // 113720-113727
126, 125, 125, 124, 126, 125, 127, 128, // 113728-113735
128, 128, 128, 127, 128, 128, 127, 127, // 113736-113743
125, 125, 125, 125, 126, 125, 126, 127, // 113744-113751
128, 129, 128, 128, 128, 128, 130, 128, // 113752-113759
129, 127, 126, 127, 126, 126, 126, 126, // 113760-113767
127, 126, 127, 128, 129, 128, 128, 127, // 113768-113775
128, 128, 126, 124, 124, 124, 126, 126, // 113776-113783
127, 127, 126, 128, 127, 129, 128, 128, // 113784-113791
127, 127, 127, 127, 127, 127, 128, 128, // 113792-113799
128, 129, 129, 127, 127, 126, 126, 128, // 113800-113807
128, 126, 126, 127, 128, 129, 129, 128, // 113808-113815
127, 127, 127, 126, 124, 124, 124, 125, // 113816-113823
126, 126, 127, 128, 128, 128, 130, 129, // 113824-113831
129, 128, 127, 126, 125, 126, 125, 126, // 113832-113839
127, 128, 128, 128, 130, 129, 129, 129, // 113840-113847
130, 129, 129, 127, 126, 125, 125, 125, // 113848-113855
125, 125, 126, 127, 126, 126, 126, 127, // 113856-113863
127, 128, 127, 127, 126, 126, 126, 125, // 113864-113871
126, 126, 128, 128, 127, 127, 127, 128, // 113872-113879
130, 130, 129, 128, 128, 128, 128, 127, // 113880-113887
128, 128, 128, 128, 128, 127, 127, 126, // 113888-113895
126, 126, 126, 127, 126, 125, 126, 126, // 113896-113903
127, 129, 128, 127, 126, 126, 126, 126, // 113904-113911
124, 124, 125, 126, 127, 126, 127, 127, // 113912-113919
129, 131, 131, 130, 130, 129, 128, 127, // 113920-113927
126, 127, 125, 126, 126, 125, 127, 128, // 113928-113935
129, 128, 129, 130, 130, 128, 125, 124, // 113936-113943
124, 123, 125, 126, 124, 124, 125, 127, // 113944-113951
128, 128, 128, 127, 128, 128, 128, 127, // 113952-113959
125, 126, 128, 127, 127, 129, 128, 128, // 113960-113967
128, 129, 129, 129, 129, 128, 127, 127, // 113968-113975
127, 128, 127, 125, 127, 127, 126, 127, // 113976-113983
126, 124, 125, 127, 126, 125, 124, 125, // 113984-113991
125, 126, 126, 127, 127, 127, 129, 128, // 113992-113999
127, 127, 128, 127, 126, 127, 128, 126, // 114000-114007
127, 127, 128, 129, 131, 131, 130, 128, // 114008-114015
128, 128, 127, 126, 126, 125, 124, 125, // 114016-114023
125, 125, 125, 127, 128, 127, 127, 127, // 114024-114031
126, 126, 125, 125, 125, 125, 126, 126, // 114032-114039
125, 126, 129, 129, 129, 130, 130, 129, // 114040-114047
130, 129, 128, 126, 127, 127, 127, 126, // 114048-114055
127, 127, 127, 128, 130, 129, 128, 129, // 114056-114063
127, 126, 125, 124, 125, 125, 125, 124, // 114064-114071
124, 126, 126, 126, 127, 127, 128, 129, // 114072-114079
128, 127, 127, 127, 128, 129, 128, 127, // 114080-114087
128, 128, 128, 129, 128, 128, 127, 128, // 114088-114095
128, 128, 127, 126, 128, 128, 128, 128, // 114096-114103
128, 127, 126, 126, 126, 126, 126, 124, // 114104-114111
124, 124, 126, 125, 126, 126, 127, 129, // 114112-114119
129, 129, 128, 127, 128, 128, 127, 128, // 114120-114127
128, 127, 125, 126, 127, 129, 129, 129, // 114128-114135
130, 130, 130, 129, 128, 127, 126, 126, // 114136-114143
125, 125, 125, 124, 124, 125, 127, 127, // 114144-114151
127, 126, 126, 126, 126, 127, 126, 126, // 114152-114159
125, 126, 126, 126, 127, 126, 126, 128, // 114160-114167
129, 129, 129, 128, 127, 128, 130, 128, // 114168-114175
129, 129, 128, 127, 127, 127, 128, 127, // 114176-114183
126, 127, 127, 126, 126, 125, 125, 125, // 114184-114191
127, 127, 126, 126, 126, 126, 127, 126, // 114192-114199
127, 126, 126, 126, 127, 127, 126, 128, // 114200-114207
128, 129, 129, 129, 128, 128, 128, 128, // 114208-114215
128, 128, 128, 127, 127, 127, 128, 128, // 114216-114223
127, 127, 126, 126, 128, 128, 126, 125, // 114224-114231
126, 126, 126, 126, 125, 125, 125, 125, // 114232-114239
126, 126, 125, 127, 128, 128, 129, 129, // 114240-114247
128, 129, 128, 128, 127, 126, 128, 127, // 114248-114255
125, 127, 129, 130, 129, 128, 127, 128, // 114256-114263
128, 129, 127, 125, 126, 126, 126, 126, // 114264-114271
125, 125, 126, 127, 127, 127, 126, 126, // 114272-114279
126, 126, 126, 127, 127, 127, 126, 126, // 114280-114287
127, 128, 130, 129, 127, 126, 127, 129, // 114288-114295
128, 128, 127, 128, 129, 129, 128, 127, // 114296-114303
128, 128, 128, 127, 126, 126, 125, 125, // 114304-114311
126, 125, 125, 126, 126, 126, 124, 127, // 114312-114319
128, 128, 127, 126, 126, 128, 129, 127, // 114320-114327
125, 125, 127, 129, 128, 127, 127, 128, // 114328-114335
128, 129, 130, 129, 129, 128, 128, 127, // 114336-114343
126, 127, 126, 125, 125, 126, 127, 127, // 114344-114351
128, 126, 126, 127, 130, 129, 126, 124, // 114352-114359
125, 126, 127, 126, 125, 125, 126, 127, // 114360-114367
129, 128, 128, 129, 129, 128, 129, 128, // 114368-114375
127, 127, 126, 128, 127, 131, 126, 147, // 114376-114383
164, 151, 118,  94,  77,  89,  71,  44, // 114384-114391
 61, 121, 214, 231, 250, 209, 248, 221, // 114392-114399
122, 119, 110, 240, 182, 243, 227,  65, // 114400-114407
142, 205, 160, 163, 206, 247,  24, 184, // 114408-114415
125,  90,  54,  80, 109, 238, 214,  28, // 114416-114423
135, 123,  83,  78,  34,  71,  93,  94, // 114424-114431
 97, 120, 119, 160, 122, 138, 253, 233, // 114432-114439
207, 192, 180, 180, 167, 150, 121,  84, // 114440-114447
154, 204, 234, 233, 158, 207, 217, 231, // 114448-114455
254, 180,  87,  85,  80,   0, 223, 215, // 114456-114463
246,   9,  40,  15,  51, 129, 150, 167, // 114464-114471
161, 155, 215, 233, 112,  61,  30,  56, // 114472-114479
 60, 111,  94,  49, 162, 200, 247,  58, // 114480-114487
 64,  50,  81,  14, 238, 173,  81,  36, // 114488-114495
 18,   5, 214,  34,  85,  69,  67, 152, // 114496-114503
136, 234,   6, 131,  62,   1,  42,  48, // 114504-114511
  4, 190, 243,  65, 117, 136, 183, 143, // 114512-114519
163,  11, 237, 210, 194, 187, 115, 138, // 114520-114527
164, 215, 223, 212, 198, 179, 167, 140, // 114528-114535
197, 109,  23,  45,  80,  80, 106,  68, // 114536-114543
 56,  86, 190,   1, 142,  72,  14,  53, // 114544-114551
 44, 246, 252,   1, 237,  65, 134, 125, // 114552-114559
201, 254,  30,  15,  10,  33, 250, 148, // 114560-114567
101,  89,  99, 106, 122, 139,  47,  98, // 114568-114575
202, 236, 243, 218, 192, 164, 181, 154, // 114576-114583
 80, 248, 218,   6,  40, 222, 209,  29, // 114584-114591
 26,  66, 140, 172, 187, 238, 214, 158, // 114592-114599
127, 165, 164, 118,  97,  44, 122, 134, // 114600-114607
126, 188, 187, 182,  28,  52, 244, 198, // 114608-114615
162, 147, 111, 142,  92,  59,  67,  74, // 114616-114623
 69,  80,  62,  96, 159,  67,  50,  45, // 114624-114631
 58,  60,  80,  56,  54, 148, 211, 179, // 114632-114639
149, 142, 133, 193, 151, 136,  91,  79, // 114640-114647
 85, 125, 170, 181, 250,  29,  23,  10, // 114648-114655
 35, 200, 175, 130,  51,  17, 255,  10, // 114656-114663
 18, 239, 245,  84, 155, 244, 201, 169, // 114664-114671
117, 127, 177,  91,  13, 244, 252,  20, // 114672-114679
 57,  44,  90, 118, 177, 248,  19,  15, // 114680-114687
 15, 249, 178, 169, 198, 193, 127, 124, // 114688-114695
 76,  64, 113, 139, 157, 111, 107, 141, // 114696-114703
193, 174, 112,  87,  65,  70, 152, 109, // 114704-114711
247,   4,  28,  54,  68,  86,  99, 114, // 114712-114719
122, 134, 148, 157, 170, 170, 190, 130, // 114720-114727
187, 249, 160, 142, 168, 167, 192, 216, // 114728-114735
175, 116,  69, 110, 131, 151, 116, 101, // 114736-114743
148, 145, 163, 176, 130,  66, 128, 106, // 114744-114751
 32, 239, 245, 239, 233,  20,  54, 137, // 114752-114759
187, 211, 217, 215, 201,  20, 226, 134, // 114760-114767
 93,  80,  81,  40,  89,  89, 117, 191, // 114768-114775
  9,  18,  21, 235, 235, 226, 146, 137, // 114776-114783
 88,  33,   4,   9, 230,   3,  56, 136, // 114784-114791
121,  98, 124, 129, 176, 128,  98,  79, // 114792-114799
 80, 114, 140,  74,  57, 106, 146, 166, // 114800-114807
178, 191, 156, 171, 162, 172, 188, 196, // 114808-114815
188, 195, 168, 152, 191, 161, 140, 114, // 114816-114823
106,  87, 105, 121,  44,   4,  46,  77, // 114824-114831
139, 147,  69,  81,  99, 136, 158, 123, // 114832-114839
 86,  92, 123,  97,  77,  88,  87,  73, // 114840-114847
137, 154, 165, 236, 216, 198, 218, 238, // 114848-114855
  8,   3, 180, 119,  83,  78,  66,  83, // 114856-114863
 63,   3,  83, 146, 171, 169, 164, 140, // 114864-114871
164, 194, 153,  74,   4, 240, 240,   8, // 114872-114879
240,  47, 105, 107, 138, 200, 208, 240, // 114880-114887
  1, 203, 173, 146, 186, 129,  88,  75, // 114888-114895
 95, 155, 178, 189, 193, 149, 141, 211, // 114896-114903
178, 146, 116, 107,  89,  88,  88,  80, // 114904-114911
 71,  91, 129, 101,  83,  57, 105,  64, // 114912-114919
 25,  62,  94, 115, 135, 138, 120, 151, // 114920-114927
208, 242, 196, 173, 145, 168, 136,  94, // 114928-114935
121, 110, 105, 147, 188, 158, 177, 197, // 114936-114943
206, 180, 182, 180, 138, 119,  63,  19, // 114944-114951
 16,   9,  51,  91,  11,  32, 104, 138, // 114952-114959
155, 152, 158, 143, 184, 191, 133,  85, // 114960-114967
 77,  74,  99, 100,  94, 143, 138, 136, // 114968-114975
192, 237, 243,  10, 255, 192, 158, 165, // 114976-114983
138,  88,  70,  21,  53,  82, 101, 108, // 114984-114991
 79,  84, 131, 197, 174, 114,  83,  69, // 114992-114999
 57,  99,  74,  49,  83, 101, 121, 131, // 115000-115007
139, 155, 168, 137, 158, 158, 176, 158, // 115008-115015
132, 139, 137, 213, 243, 207, 174, 157, // 115016-115023
133, 156, 131, 100,  57,  35,  71,  98, // 115024-115031
106,  81, 114, 136, 175, 185, 172, 106, // 115032-115039
 87,  83,  38,  31,  29,  58,  59,  64, // 115040-115047
 81, 141, 192, 225, 224, 232, 203, 220, // 115048-115055
239, 139, 110, 101, 109, 112, 125, 111, // 115056-115063
102, 111, 149, 184, 185, 181, 160, 179, // 115064-115071
140, 100, 106,  80,  41,  80,  54,  15, // 115072-115079
 44,  73,  95,  73, 101, 133, 177, 189, // 115080-115087
154, 143, 135, 134, 166, 165, 105, 114, // 115088-115095
142, 133, 121, 158, 172, 167, 186, 186, // 115096-115103
172, 161, 151, 140, 139,  99, 118, 148, // 115104-115111
119, 105,  88,  88,  81, 118, 134,  69, // 115112-115119
 28,  58,  74,  96,  92,  85, 130, 145, // 115120-115127
180, 193, 164, 136, 156, 146, 120, 107, // 115128-115135
113, 108,  68, 104, 133, 186, 224, 233, // 115136-115143
229, 209, 195, 215, 180, 106,  72,  48, // 115144-115151
 51,  44,  66,  31,  35,  91, 153, 191, // 115152-115159
172, 143, 135, 142, 110, 114,  81,  60, // 115160-115167
 55,  72,  67,  74, 127, 152, 144, 168, // 115168-115175
201, 204, 237, 174, 151, 151, 154, 179, // 115176-115183
170, 128,  93, 112, 128, 134, 131, 134, // 115184-115191
 93, 119, 145, 120, 107, 101,  93, 116, // 115192-115199
128,  98, 103,  86,  87,  81,  92,  90, // 115200-115207
110, 141,  98,  85, 118, 140, 153, 168, // 115208-115215
151, 152, 178, 203, 180, 160, 157, 154, // 115216-115223
178, 154, 125, 118,  98,  81, 117, 120, // 115224-115231
111, 142, 152, 156, 138, 146, 147, 131, // 115232-115239
128,  93,  48,  37,  31,  50,  48,  19, // 115240-115247
 86, 143, 170, 181, 186, 183, 186, 203, // 115248-115255
186, 148, 110, 110,  89,  80,  79, 119, // 115256-115263
157, 156, 179, 204, 201, 197, 206, 167, // 115264-115271
129, 107, 122,  95,  74,  45,  34,  74, // 115272-115279
 89, 135, 133,  94,  88, 137, 132, 113, // 115280-115287
104, 108, 108, 115, 138, 117, 122, 134, // 115288-115295
144, 145, 153, 144, 178, 139,  96, 137, // 115296-115303
156, 172, 171, 176, 143, 146, 180, 185, // 115304-115311
145, 126, 104, 105, 117,  87,  75,  50, // 115312-115319
 48,  83, 140, 116, 103, 123, 134, 128, // 115320-115327
142, 151, 122, 132, 108,  89,  85,  92, // 115328-115335
108, 113,  98, 118, 167, 199, 184, 171, // 115336-115343
196, 182, 215, 219, 160, 118, 101,  91, // 115344-115351
 93,  88,  73,  87,  90, 120, 143, 147, // 115352-115359
145, 146, 166, 150, 116, 110,  84,  56, // 115360-115367
 59,  37,  57,  92, 119, 130, 120, 138, // 115368-115375
170, 203, 186, 165, 155, 151, 147, 145, // 115376-115383
123, 108, 135, 147, 157, 152, 152, 145, // 115384-115391
141, 132, 130, 124, 122, 114, 115, 109, // 115392-115399
 80, 125, 131, 129, 132, 108,  88,  98, // 115400-115407
103,  85,  60,  59,  99, 119, 140, 123, // 115408-115415
142, 169, 176, 191, 198, 159, 150, 155, // 115416-115423
103,  99, 107, 127, 116, 120, 131, 143, // 115424-115431
172, 179, 173, 165, 150, 146, 170, 122, // 115432-115439
 79,  58,  59,  56,  87, 100,  62,  69, // 115440-115447
105, 137, 140, 151, 140, 164, 156, 140, // 115448-115455
145, 126, 107, 106, 109,  99, 114, 148, // 115456-115463
149, 109, 147, 176, 199, 212, 179, 162, // 115464-115471
143, 137, 145, 132,  84,  78,  93, 105, // 115472-115479
104, 108, 107,  90, 115, 146, 136, 114, // 115480-115487
104,  98, 105,  91, 106, 129, 121, 124, // 115488-115495
122, 129, 127, 151, 151, 115, 112, 135, // 115496-115503
152, 148, 131, 131, 164, 179, 199, 196, // 115504-115511
166, 140, 138, 135, 105,  90,  88,  74, // 115512-115519
 67, 103,  96, 116, 136, 143, 169, 153, // 115520-115527
140, 139, 124,  86,  66,  62,  73,  77, // 115528-115535
102,  88,  85, 141, 172, 186, 189, 188, // 115536-115543
177, 192, 160, 142, 128, 118, 115, 117, // 115544-115551
118, 102, 130, 135, 125, 137, 158, 148, // 115552-115559
161, 150, 126, 105, 103, 113, 104, 108, // 115560-115567
 72,  72,  87,  97, 103, 111,  93, 118, // 115568-115575
156, 144, 141, 136, 141, 138, 147, 147, // 115576-115583
144, 141, 147, 122, 125, 139, 147, 171, // 115584-115591
135, 126, 137, 144, 139, 142, 128, 116, // 115592-115599
128, 150, 149, 120, 108,  96, 107, 112, // 115600-115607
110,  91,  66,  60,  92, 106, 102, 125, // 115608-115615
143, 155, 152, 170, 168, 155, 149, 121, // 115616-115623
113, 110, 112, 119,  96,  81, 131, 171, // 115624-115631
189, 190, 186, 177, 165, 178, 160, 120, // 115632-115639
 92,  82,  74,  84,  72,  76,  97,  92, // 115640-115647
133, 159, 148, 136, 143, 132, 109, 107, // 115648-115655
120, 107,  98,  95,  85, 115, 130, 147, // 115656-115663
146, 139, 143, 180, 178, 140, 139, 147, // 115664-115671
148, 148, 164, 134, 124, 129, 128, 126, // 115672-115679
125, 117, 121, 114,  99, 109, 107, 115, // 115680-115687
107, 134, 120, 106, 131, 132, 114, 108, // 115688-115695
104, 105, 127, 116, 112,  95, 103, 126, // 115696-115703
147, 146, 142, 159, 173, 163, 156, 171, // 115704-115711
150, 160, 146, 127, 116, 111, 112, 103, // 115712-115719
 97, 101, 125, 140, 148, 143, 143, 126, // 115720-115727
143, 151, 131, 105,  79,  71,  73,  82, // 115728-115735
 76,  83,  97, 130, 150, 161, 162, 164, // 115736-115743
178, 156, 147, 152, 132, 119, 109,  85, // 115744-115751
102, 130, 150, 152, 141, 149, 157, 172, // 115752-115759
162, 138, 126, 115, 112, 127, 110,  79, // 115760-115767
 93,  98, 112, 129, 125, 108, 104, 113, // 115768-115775
115, 116, 118, 121, 126, 129, 115, 141, // 115776-115783
151, 142, 138, 136, 135, 140, 155, 124, // 115784-115791
 99, 111, 140, 150, 159, 142, 139, 153, // 115792-115799
151, 163, 154, 128, 114, 122, 106,  92, // 115800-115807
 83,  91,  78,  92, 120, 111, 127, 132, // 115808-115815
136, 136, 134, 138, 158, 137, 113, 103, // 115816-115823
102, 109, 113, 122, 104, 116, 148, 168, // 115824-115831
154, 159, 163, 178, 178, 162, 154, 128, // 115832-115839
113, 103, 102,  85,  90, 111, 117, 109, // 115840-115847
125, 131, 141, 153, 144, 141, 115, 108, // 115848-115855
110, 103,  80,  77,  96, 114, 122, 131, // 115856-115863
133, 124, 153, 161, 151, 150, 145, 146, // 115864-115871
143, 119, 124, 142, 144, 146, 138, 137, // 115872-115879
130, 141, 141, 109, 104, 116, 120, 126, // 115880-115887
124, 107, 114, 126, 139, 149, 137, 112, // 115888-115895
107, 113,  96,  90,  95,  88,  96, 123, // 115896-115903
122, 132, 154, 162, 164, 159, 167, 164, // 115904-115911
161, 134, 100, 102, 113, 118, 131, 115, // 115912-115919
104, 138, 153, 160, 156, 150, 143, 147, // 115920-115927
145, 130, 103,  90,  85,  85, 104,  90, // 115928-115935
101, 104, 103, 120, 136, 137, 152, 159, // 115936-115943
143, 131, 130, 141, 127, 121, 103, 110, // 115944-115951
128, 138, 135, 125, 124, 148, 178, 166, // 115952-115959
154, 143, 142, 130, 132, 125, 110, 110, // 115960-115967
112, 110, 112, 108, 111, 126, 109, 120, // 115968-115975
124, 118, 115, 116, 114, 103, 118, 142, // 115976-115983
143, 130, 129, 122, 138, 138, 127, 124, // 115984-115991
115, 119, 140, 135, 120, 141, 162, 171, // 115992-115999
162, 169, 157, 143, 140, 116, 102,  97, // 116000-116007
 95, 100,  97,  85, 103, 128, 137, 143, // 116008-116015
156, 145, 129, 142, 131, 104,  94,  93, // 116016-116023
 96, 106, 102, 106, 120, 128, 148, 158, // 116024-116031
162, 159, 170, 169, 131, 127, 142, 133, // 116032-116039
129, 122, 107, 118, 125, 132, 127, 118, // 116040-116047
125, 141, 149, 132, 122, 119, 115, 112, // 116048-116055
132, 118, 101, 104, 104, 107, 108, 113, // 116056-116063
118, 126, 125, 131, 134, 139, 139, 148, // 116064-116071
134, 130, 154, 154, 142, 122, 121, 129, // 116072-116079
145, 143, 132, 115, 119, 129, 135, 133, // 116080-116087
118, 132, 136, 135, 140, 136, 115, 119, // 116088-116095
112, 110, 109,  98,  99,  90,  95, 100, // 116096-116103
118, 138, 146, 148, 150, 141, 156, 165, // 116104-116111
137, 122, 115, 116, 118, 120, 104, 105, // 116112-116119
125, 151, 160, 162, 159, 154, 162, 142, // 116120-116127
133, 129, 113, 102, 102,  95,  89, 102, // 116128-116135
117, 114, 121, 136, 130, 140, 136, 121, // 116136-116143
119, 114, 120, 132, 123, 106, 114, 126, // 116144-116151
133, 132, 138, 136, 132, 151, 141, 128, // 116152-116159
135, 142, 147, 146, 133, 143, 144, 134, // 116160-116167
128, 122, 119, 115, 127, 117,  99,  99, // 116168-116175
113, 118, 125, 130, 126, 127, 126, 135, // 116176-116183
129, 117, 112, 122, 120, 110, 110, 117, // 116184-116191
113, 120, 132, 130, 148, 153, 163, 150, // 116192-116199
137, 149, 160, 150, 130, 120, 116, 114, // 116200-116207
114, 123, 102, 106, 128, 137, 139, 139, // 116208-116215
133, 134, 134, 128, 135, 114, 102,  96, // 116216-116223
 99,  92,  94, 117, 122, 121, 134, 142, // 116224-116231
145, 159, 150, 141, 132, 135, 140, 137, // 116232-116239
114, 102, 122, 135, 138, 142, 139, 127, // 116240-116247
141, 147, 134, 131, 124, 126, 120, 122, // 116248-116255
122, 120, 151, 184, 154, 103,  50,  42, // 116256-116263
 62,  11,  44,  73, 136, 226, 245, 246, // 116264-116271
 27, 242, 137, 178, 118,  76, 245, 160, // 116272-116279
 27, 123, 183, 157, 152, 244,  35, 212, // 116280-116287
151, 128,  82, 129,  83, 240,  36,  45, // 116288-116295
 70,  62,  78, 159, 110,  64,  50,  52, // 116296-116303
 57,  82,  24, 102, 215, 171, 164, 136, // 116304-116311
162, 205, 183, 108,  75, 122, 210, 159, // 116312-116319
106, 234,  35,  64, 105,  10, 226, 201, // 116320-116327
103,  49,  32,  25, 239, 254,  51, 150, // 116328-116335
165, 188, 155, 153,  45, 170, 254, 191, // 116336-116343
167, 190, 217, 208, 225,  99, 193, 251, // 116344-116351
  0,  15,  51, 225, 225, 183, 103, 106, // 116352-116359
255, 255, 130, 216, 197, 218,   6,  55, // 116360-116367
 55, 201, 157,  99, 126, 119, 253, 232, // 116368-116375
 33,  52,  72,  73,  79, 150, 131,  69, // 116376-116383
 57,  34,  60,  37,  43, 141, 137, 133, // 116384-116391
136, 135, 161, 216, 133,  72, 128, 166, // 116392-116399
204, 105, 130, 230,  33,  92,  22, 206, // 116400-116407
208, 177,  86,  61,  26, 238,  36,  37, // 116408-116415
 88, 151, 157, 171, 134, 236, 241,  83, // 116416-116423
233, 197, 189, 222, 238, 178,  45, 162, // 116424-116431
214, 244, 236,  15,  13, 244, 196, 118, // 116432-116439
101,  86, 254,  48, 175, 174, 211,  13, // 116440-116447
 15,  60,   6, 178, 125, 133, 129,  48, // 116448-116455
229, 253,  57,  58, 101,  41, 107, 200, // 116456-116463
127,  82,  51,  48,  51,  65,  82, 101, // 116464-116471
113, 120, 137, 132, 194, 182,  92, 143, // 116472-116479
158, 199, 176, 100, 149, 249,  65,  14, // 116480-116487
210, 174, 199, 139,  82,  53, 248,  52, // 116488-116495
 83,  69, 118, 158, 160, 162, 179, 210, // 116496-116503
156,  28, 220, 201, 207, 251, 194, 249, // 116504-116511
136, 195, 234, 242, 237,   4,  34, 196, // 116512-116519
127,  83,  94,  55, 250, 102, 149, 194, // 116520-116527
 17,  24,  32,  46, 233, 147, 150, 121, // 116528-116535
 62,   8, 215,  23,  51,  91,  62,  56, // 116536-116543
201, 202, 125,  75,  62,  38,  82,  76, // 116544-116551
 39,  85,  99, 129, 133, 157, 185, 143, // 116552-116559
149, 176, 180, 197, 141,  90, 183,  28, // 116560-116567
248, 216, 175, 178, 189, 133,  81,  21, // 116568-116575
 56, 104,  93,  74, 131, 139, 151, 177, // 116576-116583
145, 169, 103,  14, 232, 226, 248, 232, // 116584-116591
246,  82, 170, 203, 223, 219, 212,  31, // 116592-116599
222, 125, 100,  81, 103,  40,  52, 109, // 116600-116607
184,   4,  31,  15,  16,  16, 171, 154, // 116608-116615
124,  55,  37, 244, 246,  52,  89,  84, // 116616-116623
 67, 151, 232, 184,  98,  70,  33,  64, // 116624-116631
 91,  12,  35,  85, 116, 137, 156, 157, // 116632-116639
171, 181, 179, 183, 176, 181,  97, 116, // 116640-116647
228, 227, 206, 189, 169, 183, 184, 113, // 116648-116655
 45,  69,  99, 119,  82,  88, 130, 137, // 116656-116663
187, 130, 131, 148,  79,   9, 245, 246, // 116664-116671
226,  15,  47, 119, 178, 199, 217, 200, // 116672-116679
  1,   1, 156, 115,  95, 100,  93,  48, // 116680-116687
 43, 139, 231,   8,  18, 244,   9, 223, // 116688-116695
181, 148,  76,  51,  33, 255,  17,  82, // 116696-116703
 67,  76, 112, 185, 218, 141,  88,  50, // 116704-116711
 63,  97,  45,  10,  59, 110, 125, 156, // 116712-116719
138, 143, 206, 185, 183, 165, 175, 144, // 116720-116727
102, 168, 196, 197, 189, 184, 165, 197, // 116728-116735
160,  67,  85, 102, 116, 112,  76,  96, // 116736-116743
129, 173, 143,  98, 131, 130,  60,  12, // 116744-116751
  7, 224,  25,  62,  80, 147, 183, 201, // 116752-116759
202, 227, 229, 188, 122, 103,  91, 102, // 116760-116767
 87,  21,  91, 208, 255,  17, 254, 243, // 116768-116775
244, 225, 160,  85,  45,  33,  31, 251, // 116776-116783
 53,  62,  76, 128, 153, 220, 201, 134, // 116784-116791
 69,  76,  81,  52,  13,   7,  72, 104, // 116792-116799
140, 139, 123, 202, 224, 194, 182, 173, // 116800-116807
168, 135, 130, 140, 170, 172, 180, 164, // 116808-116815
168, 181, 110, 105, 117, 119, 124, 108, // 116816-116823
 77, 116, 165, 142, 100,  93, 136, 110, // 116824-116831
 50,  21, 234,  14,  78,  83, 105, 159, // 116832-116839
183, 190, 226, 200, 188, 153, 108, 101, // 116840-116847
 95, 115,  45,  55, 159, 231, 255,   1, // 116848-116855
237, 217, 252, 189,  98,  64,  37,  51, // 116856-116863
 28,  30,  56,  75, 134, 147, 179, 207, // 116864-116871
173,  93,  84,  81,  39,  35,   4,  40, // 116872-116879
 95, 134, 141, 129, 174, 232, 217, 180, // 116880-116887
169, 150, 154, 133,  98, 130, 161, 173, // 116888-116895
178, 171, 176, 153, 138, 132, 129, 117, // 116896-116903
122,  87,  78, 145, 125, 104,  84, 112, // 116904-116911
136, 103,  51,   2,  26,  74, 101,  89, // 116912-116919
118, 162, 170, 215, 191, 156, 166, 130, // 116920-116927
110, 103, 116,  82,  61, 119, 195, 242, // 116928-116935
242, 243, 204, 239, 222, 124,  79,  51, // 116936-116943
 48,  54,  44,  29,  70, 126, 150, 158, // 116944-116951
186, 198, 136, 100,  91,  40,  33,  28, // 116952-116959
 20,  62, 118, 124, 128, 166, 200, 234, // 116960-116967
195, 173, 152, 162, 163,  94,  93, 136, // 116968-116975
166, 171, 181, 158, 149, 169, 147, 137, // 116976-116983
121, 117, 112,  83, 121, 124, 106,  94, // 116984-116991
 93, 126, 132,  89,  16,  33,  61,  93, // 116992-116999
100,  92, 131, 160, 203, 194, 151, 154, // 117000-117007
161, 127, 111, 112,  91,  82, 100, 146, // 117008-117015
208, 226, 234, 215, 222, 228, 164, 101, // 117016-117023
 71,  59,  57,  71,  21,  45, 116, 143, // 117024-117031
154, 159, 190, 167, 135, 102,  55,  28, // 117032-117039
 37,  37,  35,  94, 115, 119, 169, 182, // 117040-117047
218, 218, 182, 157, 158, 172, 109,  75, // 117048-117055
 97, 147, 162, 179, 167, 137, 184, 182, // 117056-117063
152, 134, 120, 113, 105, 104, 100,  95, // 117064-117071
 91,  90, 105, 134, 125,  55,  49,  75, // 117072-117079
 87, 109,  99, 101, 136, 186, 177, 152, // 117080-117087
134, 151, 147, 119, 118,  92, 105, 115, // 117088-117095
125, 170, 214, 224, 216, 224, 206, 178, // 117096-117103
128,  81,  71,  57,  75,  46,  35, 103, // 117104-117111
140, 159, 153, 171, 175, 168, 124,  60, // 117112-117119
 36,  26,  47,  36,  63,  98, 111, 161, // 117120-117127
188, 196, 216, 206, 163, 156, 168, 126, // 117128-117135
 81,  73, 114, 151, 169, 172, 140, 172, // 117136-117143
201, 175, 142, 131, 109, 114, 118,  78, // 117144-117151
 84,  91,  95,  95, 123, 138,  94,  73, // 117152-117159
 83,  90,  98, 108,  93, 104, 166, 166, // 117160-117167
150, 138, 133, 160, 144, 127,  96, 110, // 117168-117175
128, 122, 137, 174, 207, 200, 226, 201, // 117176-117183
171, 157, 111,  85,  73,  77,  66,  48, // 117184-117191
 80, 126, 148, 148, 152, 161, 180, 156, // 117192-117199
 78,  50,  34,  48,  58,  59,  74, 105, // 117200-117207
153, 182, 188, 191, 210, 174, 158, 161, // 117208-117215
132,  99,  74,  90, 131, 169, 168, 152, // 117216-117223
163, 193, 198, 155, 130, 112, 105, 130, // 117224-117231
 85,  66,  84,  98,  99, 114, 137, 115, // 117232-117239
107,  92,  96,  95, 106, 106,  89, 141, // 117240-117247
158, 141, 139, 130, 141, 158, 142, 102, // 117248-117255
109, 138, 134, 131, 144, 184, 194, 217, // 117256-117263
205, 158, 154, 135, 101,  82,  81,  61, // 117264-117271
 68,  80, 106, 142, 148, 148, 148, 178, // 117272-117279
175, 111,  60,  45,  46,  61,  72,  56, // 117280-117287
 83, 143, 169, 189, 178, 194, 193, 171, // 117288-117295
164, 135, 113,  85,  82,  98, 149, 158, // 117296-117303
146, 166, 174, 196, 178, 144, 124, 114, // 117304-117311
132, 108,  64,  69,  93, 100, 104, 120, // 117312-117319
112, 126, 116, 102, 103, 101, 113, 105, // 117320-117327
123, 140, 137, 131, 134, 128, 148, 159, // 117328-117335
113, 108, 138, 145, 135, 133, 153, 181, // 117336-117343
206, 201, 163, 139, 144, 126,  92,  93, // 117344-117351
 68,  76, 102,  97, 123, 141, 147, 138, // 117352-117359
166, 172, 133,  82,  54,  56,  55,  82, // 117360-117367
 65,  62, 126, 163, 179, 180, 174, 185, // 117368-117375
189, 171, 133, 115,  95,  86,  89, 121, // 117376-117383
152, 144, 171, 178, 183, 192, 169, 130, // 117384-117391
121, 126, 111,  82,  56,  79,  98, 106, // 117392-117399
115, 113, 133, 144, 120, 106, 104, 103, // 117400-117407
110, 116, 108, 118, 121, 127, 132, 133, // 117408-117415
161, 137, 124, 141, 154, 143, 132, 133, // 117416-117423
149, 194, 189, 163, 136, 132, 144, 119, // 117424-117431
104,  84,  79, 113, 116, 110, 128, 143, // 117432-117439
132, 151, 163, 135, 108,  67,  62,  61, // 117440-117447
 79,  82,  67, 106, 151, 167, 174, 173, // 117448-117455
162, 187, 182, 135, 115, 107,  96,  92, // 117456-117463
105, 130, 143, 167, 183, 177, 177, 180, // 117464-117471
146, 125, 131, 106,  94,  71,  68,  91, // 117472-117479
110, 111, 106, 132, 148, 142, 111, 106, // 117480-117487
100, 102, 127, 106, 100, 119, 125, 135, // 117488-117495
135, 146, 145, 138, 139, 148, 147, 131, // 117496-117503
130, 128, 174, 186, 163, 152, 134, 141, // 117504-117511
141, 121,  89,  84, 104, 120, 109, 107, // 117512-117519
131, 131, 142, 159, 139, 123,  99,  76, // 117520-117527
 72,  77,  79,  78,  94, 126, 158, 159, // 117528-117535
168, 156, 171, 192, 151, 119, 114, 110, // 117536-117543
 97, 109, 112, 130, 162, 178, 181, 166, // 117544-117551
174, 163, 133, 135, 110,  91,  89,  73, // 117552-117559
 79, 105, 113, 100, 132, 147, 151, 131, // 117560-117567
107, 104,  98, 124, 112,  88, 102, 123, // 117568-117575
129, 138, 138, 132, 151, 152, 146, 151, // 117576-117583
138, 131, 128, 152, 175, 160, 149, 138, // 117584-117591
131, 138, 138,  97,  90, 105, 119, 126, // 117592-117599
110, 119, 132, 145, 151, 140, 124, 114, // 117600-117607
 91,  70,  79,  69,  77, 101, 110, 141, // 117608-117615
159, 167, 165, 165, 185, 166, 131, 112, // 117616-117623
115,  99, 101, 101, 104, 152, 172, 181, // 117624-117631
173, 165, 169, 158, 143, 118,  93,  90, // 117632-117639
 86,  73,  90, 111,  97, 121, 150, 150, // 117640-117647
145, 122, 105,  99, 115, 116,  95,  90, // 117648-117655
114, 128, 136, 145, 125, 147, 165, 150, // 117656-117663
144, 142, 127, 124, 142, 151, 153, 149, // 117664-117671
148, 138, 133, 147, 117,  99, 114, 114, // 117672-117679
124, 117, 108, 114, 140, 140, 129, 125, // 117680-117687
113, 110,  86,  85,  76,  76, 111, 117, // 117688-117695
127, 150, 161, 159, 163, 167, 155, 141, // 117696-117703
116, 112, 110, 106, 110, 105, 141, 174, // 117704-117711
180, 181, 168, 157, 162, 153, 116,  96, // 117712-117719
 84,  88,  83,  83, 102, 104, 118, 147, // 117720-117727
156, 149, 139, 111, 101, 111, 104,  96, // 117728-117735
 86,  93, 119, 130, 144, 132, 139, 168, // 117736-117743
166, 149, 146, 138, 118, 139, 137, 136, // 117744-117751
145, 143, 146, 138, 143, 133, 114, 120, // 117752-117759
120, 118, 121, 113, 103, 132, 142, 121, // 117760-117767
129, 122, 117, 107,  93,  81,  75, 101, // 117768-117775
116, 117, 127, 148, 150, 162, 168, 150, // 117776-117783
148, 133, 117, 118, 114, 103, 102, 126, // 117784-117791
156, 171, 172, 172, 156, 157, 169, 130, // 117792-117799
105,  95,  91,  95,  92,  94, 100, 118, // 117800-117807
134, 153, 148, 141, 125, 105, 116, 102, // 117808-117815
 96,  97,  90, 106, 128, 137, 132, 137, // 117816-117823
156, 167, 156, 141, 142, 123, 131, 136, // 117824-117831
125, 138, 143, 147, 145, 140, 134, 132, // 117832-117839
128, 124, 121, 115, 119, 104, 117, 136, // 117840-117847
119, 118, 127, 120, 115, 109,  86,  81, // 117848-117855
 99, 117, 123, 119, 134, 143, 154, 167, // 117856-117863
144, 139, 140, 126, 116, 124, 107, 101, // 117864-117871
128, 143, 165, 170, 171, 162, 153, 163, // 117872-117879
142, 111, 101,  93,  92,  98,  94,  90, // 117880-117887
121, 132, 146, 155, 142, 137, 117, 116, // 117888-117895
105,  89,  94,  95,  94, 114, 132, 126, // 117896-117903
140, 151, 162, 166, 150, 141, 135, 130, // 117904-117911
132, 122, 125, 137, 140, 142, 144, 127, // 117912-117919
133, 141, 129, 128, 119, 121, 115, 116, // 117920-117927
125, 122, 113, 121, 129, 116, 117,  95, // 117928-117935
 85, 102, 110, 123, 121, 121, 136, 151, // 117936-117943
162, 148, 136, 137, 139, 122, 123, 116, // 117944-117951
 94, 121, 136, 150, 162, 164, 163, 157, // 117952-117959
160, 150, 128, 107, 103,  95,  99,  99, // 117960-117967
 85, 109, 129, 132, 148, 149, 136, 129, // 117968-117975
123, 108,  95,  93, 100,  99, 102, 124, // 117976-117983
123, 137, 152, 153, 161, 156, 142, 137, // 117984-117991
140, 123, 121, 120, 126, 140, 140, 147, // 117992-117999
133, 129, 148, 141, 132, 126, 118, 116, // 118000-118007
121, 117, 114, 114, 110, 127, 123, 120, // 118008-118015
110,  93, 106, 112, 119, 125, 122, 121, // 118016-118023
143, 152, 143, 136, 129, 136, 131, 121, // 118024-118031
121, 105, 115, 137, 143, 152, 161, 160, // 118032-118039
161, 161, 142, 135, 116, 106, 103,  98, // 118040-118047
103,  94, 104, 129, 137, 138, 152, 142, // 118048-118055
131, 134, 111,  97,  91,  94, 102,  99, // 118056-118063
111, 121, 132, 150, 154, 153, 158, 151, // 118064-118071
134, 143, 126, 111, 121, 120, 132, 138, // 118072-118079
144, 138, 133, 145, 149, 136, 128, 124, // 118080-118087
114, 124, 121, 107, 114, 111, 118, 130, // 118088-118095
123, 114, 105, 108, 113, 117, 119, 123, // 118096-118103
116, 128, 147, 136, 135, 130, 131, 137, // 118104-118111
134, 124, 119, 118, 129, 142, 141, 153, // 118112-118119
154, 154, 159, 140, 132, 128, 116, 112, // 118120-118127
109, 107, 105, 113, 121, 130, 128, 132, // 118128-118135
138, 127, 129, 116, 103, 104, 106, 112, // 118136-118143
116, 117, 119, 131, 139, 143, 140, 137, // 118144-118151
140, 134, 133, 130, 119, 123, 131, 132, // 118152-118159
136, 137, 136, 136, 134, 133, 131, 125, // 118160-118167
125, 121, 119, 124, 120, 121, 125, 124, // 118168-118175
126, 130, 123, 119, 121, 122, 122, 120, // 118176-118183
125, 127, 127, 131, 130, 131, 133, 130, // 118184-118191
129, 130, 128, 126, 127, 125, 128, 133, // 118192-118199
133, 131, 131, 132, 130, 127, 126, 127, // 118200-118207
126, 125, 123, 122, 125, 126, 125, 123, // 118208-118215
122, 127, 129, 124, 122, 124, 127, 130, // 118216-118223
129, 128, 129, 126, 127, 128, 127, 125, // 118224-118231
124, 126, 128, 130, 130, 128, 127, 133, // 118232-118239
136, 132, 127, 126, 128, 127, 123, 121, // 118240-118247
123, 125, 126, 125, 124, 127, 131, 131, // 118248-118255
128, 126, 128, 127, 124, 123, 124, 125, // 118256-118263
125, 127, 130, 130, 128, 128, 130, 131, // 118264-118271
132, 128, 124, 126, 129, 128, 125, 123, // 118272-118279
126, 131, 129, 126, 127, 127, 127, 126, // 118280-118287
126, 126, 126, 125, 124, 124, 128, 129, // 118288-118295
126, 125, 128, 129, 128, 125, 124, 127, // 118296-118303
129, 128, 128, 128, 128, 129, 128, 129, // 118304-118311
130, 129, 128, 127, 129, 129, 127, 125, // 118312-118319
126, 129, 129, 125, 124, 125, 126, 126, // 118320-118327
124, 123, 126, 129, 127, 126, 126, 128, // 118328-118335
130, 128, 126, 125, 126, 127, 124, 125, // 118336-118343
128, 128, 129, 130, 131, 130, 128, 127, // 118344-118351
130, 131, 128, 125, 125, 127, 129, 126, // 118352-118359
124, 125, 129, 131, 127, 123, 124, 126, // 118360-118367
126, 125, 124, 126, 127, 127, 127, 127, // 118368-118375
129, 128, 126, 126, 126, 126, 125, 123, // 118376-118383
124, 130, 131, 130, 131, 132, 132, 130, // 118384-118391
130, 129, 127, 126, 124, 123, 125, 127, // 118392-118399
125, 125, 128, 131, 133, 129, 127, 127, // 118400-118407
128, 125, 122, 123, 123, 123, 122, 123, // 118408-118415
126, 130, 131, 128, 128, 131, 131, 130, // 118416-118423
126, 124, 126, 126, 127, 126, 125, 127, // 118424-118431
126, 129, 133, 131, 128, 128, 127, 129, // 118432-118439
129, 126, 123, 126, 129, 129, 125, 124, // 118440-118447
126, 128, 129, 127, 126, 127, 128, 126, // 118448-118455
125, 125, 126, 127, 125, 124, 126, 128, // 118456-118463
127, 127, 129, 131, 130, 129, 129, 128, // 118464-118471
127, 126, 126, 127, 127, 127, 126, 125, // 118472-118479
129, 131, 130, 129, 129, 131, 130, 126, // 118480-118487
124, 123, 122, 122, 123, 124, 125, 126, // 118488-118495
127, 128, 130, 134, 132, 128, 127, 127, // 118496-118503
126, 123, 120, 120, 124, 126, 127, 128, // 118504-118511
131, 132, 133, 135, 134, 130, 128, 126, // 118512-118519
124, 123, 123, 121, 123, 127, 130, 129, // 118520-118527
127, 130, 132, 131, 129, 125, 125, 125, // 118528-118535
123, 122, 123, 123, 126, 127, 127, 127, // 118536-118543
128, 130, 128, 128, 129, 128, 127, 128, // 118544-118551
128, 127, 127, 126, 128, 129, 127, 126, // 118552-118559
126, 126, 128, 129, 128, 126, 129, 131, // 118560-118567
129, 124, 126, 126, 125, 125, 124, 124, // 118568-118575
124, 125, 126, 127, 129, 130, 127, 125, // 118576-118583
127, 128, 127, 125, 123, 127, 128, 128, // 118584-118591
129, 130, 130, 129, 129, 128, 127, 125, // 118592-118599
125, 124, 125, 128, 128, 128, 130, 132, // 118600-118607
132, 129, 126, 126, 126, 124, 122, 121, // 118608-118615
124, 125, 125, 127, 127, 130, 132, 130, // 118616-118623
127, 127, 126, 126, 125, 124, 126, 126, // 118624-118631
128, 129, 129, 131, 129, 128, 129, 128, // 118632-118639
126, 125, 125, 125, 128, 128, 128, 129, // 118640-118647
131, 131, 127, 127, 126, 125, 125, 123, // 118648-118655
122, 123, 125, 126, 128, 129, 130, 130, // 118656-118663
129, 129, 129, 128, 126, 122, 123, 126, // 118664-118671
125, 125, 126, 127, 129, 132, 131, 131, // 118672-118679
130, 130, 128, 127, 127, 125, 124, 124, // 118680-118687
125, 126, 128, 126, 126, 128, 128, 128, // 118688-118695
127, 129, 128, 127, 127, 125, 125, 126, // 118696-118703
126, 123, 123, 125, 126, 126, 127, 127, // 118704-118711
130, 131, 131, 131, 131, 130, 126, 127, // 118712-118719
126, 123, 123, 123, 123, 127, 130, 130, // 118720-118727
130, 132, 134, 131, 129, 126, 124, 122, // 118728-118735
122, 120, 121, 124, 125, 128, 130, 131, // 118736-118743
131, 131, 129, 128, 128, 124, 121, 120, // 118744-118751
124, 125, 125, 128, 130, 132, 134, 132, // 118752-118759
130, 129, 128, 126, 124, 123, 124, 124, // 118760-118767
125, 128, 128, 132, 131, 129, 131, 130, // 118768-118775
127, 125, 124, 122, 123, 124, 123, 123, // 118776-118783
126, 128, 127, 128, 129, 129, 130, 128, // 118784-118791
126, 128, 129, 127, 127, 126, 126, 126, // 118792-118799
126, 126, 126, 127, 128, 128, 129, 131, // 118800-118807
131, 128, 129, 129, 129, 127, 122, 122, // 118808-118815
122, 123, 123, 124, 126, 128, 130, 131, // 118816-118823
131, 130, 130, 128, 125, 126, 124, 121, // 118824-118831
120, 123, 126, 127, 130, 131, 132, 136, // 118832-118839
134, 131, 130, 128, 125, 125, 123, 122, // 118840-118847
124, 125, 125, 126, 129, 130, 130, 129, // 118848-118855
129, 127, 127, 126, 124, 125, 124, 123, // 118856-118863
124, 125, 126, 127, 128, 128, 129, 129, // 118864-118871
129, 127, 126, 129, 127, 128, 129, 128, // 118872-118879
128, 129, 129, 128, 128, 126, 126, 126, // 118880-118887
127, 126, 125, 128, 127, 130, 131, 127, // 118888-118895
125, 126, 126, 124, 123, 123, 123, 126, // 118896-118903
127, 128, 127, 128, 129, 128, 129, 127, // 118904-118911
126, 125, 125, 125, 126, 127, 127, 129, // 118912-118919
131, 131, 130, 130, 131, 128, 127, 127, // 118920-118927
124, 125, 126, 125, 124, 126, 128, 129, // 118928-118935
129, 128, 127, 126, 127, 124, 125, 125, // 118936-118943
123, 124, 127, 126, 126, 127, 126, 128, // 118944-118951
129, 129, 128, 126, 129, 128, 128, 128, // 118952-118959
127, 128, 129, 127, 127, 127, 127, 127, // 118960-118967
127, 127, 128, 127, 127, 128, 129, 129, // 118968-118975
126, 124, 126, 126, 123, 122, 122, 123, // 118976-118983
127, 127, 128, 129, 130, 132, 130, 130, // 118984-118991
129, 126, 124, 124, 123, 124, 125, 126, // 118992-118999
129, 132, 133, 134, 133, 132, 132, 129, // 119000-119007
126, 124, 123, 123, 122, 121, 123, 126, // 119008-119015
128, 130, 129, 129, 129, 129, 127, 125, // 119016-119023
124, 123, 123, 123, 125, 124, 124, 125, // 119024-119031
129, 131, 132, 130, 131, 131, 130, 130, // 119032-119039
127, 126, 126, 128, 126, 126, 126, 127, // 119040-119047
126, 129, 129, 128, 128, 128, 128, 128, // 119048-119055
127, 126, 125, 124, 124, 123, 123, 122, // 119056-119063
123, 125, 126, 127, 128, 130, 130, 130, // 119064-119071
131, 129, 128, 127, 127, 125, 124, 125, // 119072-119079
125, 128, 131, 131, 132, 133, 132, 133, // 119080-119087
130, 127, 124, 124, 123, 123, 121, 122, // 119088-119095
123, 127, 130, 129, 129, 129, 128, 127, // 119096-119103
126, 123, 122, 122, 123, 123, 124, 126, // 119104-119111
127, 129, 131, 132, 132, 131, 131, 129, // 119112-119119
129, 127, 125, 127, 127, 127, 127, 128, // 119120-119127
128, 129, 130, 130, 129, 128, 127, 126, // 119128-119135
124, 126, 124, 124, 124, 125, 125, 125, // 119136-119143
124, 125, 126, 127, 129, 127, 128, 127, // 119144-119151
128, 129, 127, 126, 127, 127, 127, 126, // 119152-119159
126, 126, 127, 129, 131, 131, 131, 131, // 119160-119167
131, 130, 128, 126, 126, 125, 124, 123, // 119168-119175
123, 123, 126, 127, 128, 128, 128, 129, // 119176-119183
128, 126, 124, 123, 123, 124, 124, 124, // 119184-119191
125, 126, 129, 129, 130, 132, 130, 129, // 119192-119199
128, 128, 127, 126, 126, 127, 128, 128, // 119200-119207
130, 129, 129, 129, 128, 128, 127, 128, // 119208-119215
126, 125, 125, 125, 126, 126, 126, 126, // 119216-119223
127, 126, 124, 124, 123, 125, 126, 126, // 119224-119231
126, 129, 129, 129, 129, 129, 128, 128, // 119232-119239
127, 126, 124, 126, 126, 128, 130, 130, // 119240-119247
131, 131, 132, 130, 128, 126, 127, 126, // 119248-119255
124, 123, 122, 124, 125, 127, 127, 128, // 119256-119263
129, 129, 129, 127, 124, 123, 124, 124, // 119264-119271
124, 124, 125, 126, 129, 129, 130, 131, // 119272-119279
130, 130, 129, 127, 125, 127, 126, 127, // 119280-119287
128, 129, 128, 128, 129, 129, 129, 129, // 119288-119295
128, 127, 127, 126, 125, 125, 125, 125, // 119296-119303
125, 127, 126, 125, 125, 125, 126, 126, // 119304-119311
127, 127, 127, 128, 128, 128, 127, 127, // 119312-119319
127, 128, 127, 125, 126, 126, 128, 130, // 119320-119327
130, 131, 132, 132, 129, 128, 127, 125, // 119328-119335
125, 124, 123, 122, 124, 126, 127, 129, // 119336-119343
129, 130, 131, 131, 127, 125, 122, 122, // 119344-119351
122, 122, 123, 123, 125, 128, 130, 131, // 119352-119359
131, 132, 131, 131, 128, 125, 124, 124, // 119360-119367
125, 126, 128, 127, 128, 130, 129, 130, // 119368-119375
129, 129, 127, 127, 126, 124, 125, 126, // 119376-119383
125, 125, 127, 126, 126, 126, 124, 125, // 119384-119391
126, 127, 127, 127, 127, 127, 127, 128, // 119392-119399
128, 129, 129, 128, 126, 126, 127, 127, // 119400-119407
128, 128, 128, 130, 131, 130, 129, 128, // 119408-119415
129, 128, 127, 126, 123, 124, 125, 125, // 119416-119423
127, 128, 126, 127, 129, 127, 126, 125, // 119424-119431
124, 124, 125, 125, 124, 126, 128, 129, // 119432-119439
129, 130, 130, 130, 130, 127, 126, 125, // 119440-119447
125, 126, 127, 128, 128, 129, 131, 130, // 119448-119455
131, 130, 128, 127, 127, 125, 124, 123, // 119456-119463
123, 125, 125, 125, 126, 127, 128, 127, // 119464-119471
126, 126, 127, 128, 127, 125, 125, 127, // 119472-119479
127, 127, 127, 128, 128, 127, 127, 128, // 119480-119487
128, 130, 130, 129, 132, 132, 130, 129, // 119488-119495
128, 127, 127, 125, 123, 122, 122, 123, // 119496-119503
125, 127, 128, 129, 129, 131, 130, 129, // 119504-119511
126, 122, 122, 123, 123, 121, 121, 124, // 119512-119519
128, 129, 131, 132, 132, 134, 130, 128, // 119520-119527
128, 127, 126, 124, 125, 127, 128, 129, // 119528-119535
129, 129, 131, 130, 129, 128, 127, 125, // 119536-119543
125, 123, 124, 126, 126, 125, 127, 127, // 119544-119551
128, 126, 125, 125, 126, 126, 126, 125, // 119552-119559
126, 127, 127, 128, 129, 129, 130, 127, // 119560-119567
126, 128, 127, 128, 127, 127, 130, 129, // 119568-119575
129, 128, 127, 128, 128, 126, 126, 126, // 119576-119583
126, 126, 125, 127, 129, 128, 127, 127, // 119584-119591
126, 125, 123, 122, 124, 125, 125, 125, // 119592-119599
126, 129, 131, 131, 129, 130, 130, 128, // 119600-119607
125, 124, 123, 125, 126, 126, 128, 130, // 119608-119615
131, 130, 132, 132, 131, 130, 127, 126, // 119616-119623
124, 123, 122, 122, 124, 125, 126, 127, // 119624-119631
128, 129, 129, 127, 126, 128, 128, 126, // 119632-119639
124, 124, 126, 126, 126, 126, 126, 127, // 119640-119647
128, 126, 127, 129, 130, 129, 129, 130, // 119648-119655
131, 130, 128, 126, 127, 128, 125, 124, // 119656-119663
125, 125, 126, 127, 127, 129, 130, 128, // 119664-119671
127, 129, 128, 125, 123, 123, 125, 125, // 119672-119679
124, 123, 125, 128, 129, 128, 129, 130, // 119680-119687
130, 128, 126, 127, 127, 127, 127, 125, // 119688-119695
127, 128, 128, 128, 128, 128, 128, 128, // 119696-119703
127, 127, 126, 126, 125, 127, 128, 127, // 119704-119711
126, 126, 126, 128, 127, 125, 125, 126, // 119712-119719
127, 125, 125, 125, 127, 127, 128, 127, // 119720-119727
129, 130, 128, 127, 128, 128, 128, 127, // 119728-119735
126, 127, 127, 126, 125, 126, 128, 128, // 119736-119743
127, 128, 128, 128, 128, 127, 128, 129, // 119744-119751
127, 125, 125, 125, 125, 123, 124, 125, // 119752-119759
126, 127, 127, 127, 129, 131, 129, 128, // 119760-119767
128, 128, 128, 125, 124, 124, 126, 127, // 119768-119775
125, 126, 128, 130, 130, 130, 130, 130, // 119776-119783
131, 128, 127, 126, 125, 125, 123, 125, // 119784-119791
126, 124, 125, 127, 128, 130, 128, 127, // 119792-119799
129, 131, 129, 126, 123, 125, 126, 124, // 119800-119807
123, 124, 127, 128, 127, 128, 130, 130, // 119808-119815
131, 128, 129, 129, 127, 126, 125, 125, // 119816-119823
127, 127, 125, 127, 127, 127, 128, 127, // 119824-119831
128, 129, 127, 127, 126, 128, 127, 126, // 119832-119839
126, 127, 127, 127, 125, 124, 127, 127, // 119840-119847
126, 127, 127, 128, 129, 127, 127, 129, // 119848-119855
130, 129, 126, 127, 128, 125, 125, 125, // 119856-119863
125, 128, 127, 127, 128, 127, 127, 127, // 119864-119871
126, 128, 128, 127, 127, 127, 128, 127, // 119872-119879
126, 126, 128, 127, 125, 124, 124, 127, // 119880-119887
128, 127, 127, 130, 132, 131, 129, 129, // 119888-119895
129, 128, 126, 123, 123, 125, 123, 123, // 119896-119903
125, 126, 130, 130, 130, 131, 130, 129, // 119904-119911
128, 126, 125, 125, 123, 123, 125, 125, // 119912-119919
125, 125, 128, 129, 129, 130, 128, 129, // 119920-119927
129, 128, 125, 126, 126, 127, 127, 125, // 119928-119935
126, 128, 128, 127, 126, 127, 127, 128, // 119936-119943
129, 128, 127, 129, 128, 127, 127, 126, // 119944-119951
124, 124, 125, 125, 124, 125, 126, 128, // 119952-119959
129, 129, 128, 129, 129, 129, 127, 125, // 119960-119967
125, 127, 126, 126, 126, 128, 128, 128, // 119968-119975
128, 129, 128, 129, 128, 126, 127, 127, // 119976-119983
126, 126, 126, 128, 128, 127, 127, 127, // 119984-119991
127, 126, 126, 125, 125, 125, 127, 127};// 119992-119999
