#ifndef PLAYER_H
#define PLAYER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"
#include "Sprite.h"
#include "Level.h"
#include "PlayerMap.h"

#define GRAVITY 2
#define PLAYER_HEIGHT 6
#define PLAYER_WIDTH 6
#define SPEED 2
/** Player Class

@brief Player Class handles the updating,location and collision detection of the
player as well as rendering the player on screen depending on the current
orientation.
@version 1.0

@author Joshua Davy el17jd

@date April 2019

*/



class Player : public Sprite{

public:
    Player();
    ~Player();
    void update(Gamepad &pad, Block blocks [],int number_of_blocks);
    void init(Vector2D pos);
    bool check_goal_reached(Vector2D goal);
    

    
private:
    void check_out_of_range();
   
    void update_sprite(int orientation,int direction);
    void process_inputs(Gamepad &pad,
                        Block blocks [], int number_of_blocks);
    void gravity(Block blocks [], int number_of_blocks);
    
    bool can_move_up(Block blocks [],int number_of_blocks);
    bool can_move_down(Block blocks [],int number_of_blocks);
    bool can_move_left(Block blocks [],int number_of_blocks);
    bool can_move_right(Block blocks [],int number_of_blocks);
    
    
    int _orientation;
    int _direction;
    Vector2D _initial_pos;
};

#endif