/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Joshua Davy
Username: el17jd
Student ID Number: 201148379
Date: 12/03/2019
*/


///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Sprite.h"
#include "Game.h"
#include "Music.h"
#include "SoundData.h"
#include "SplashScreen.h"
#include "MenuScreen.h"
#include "WinScreen.h"


////// Constants //////

// The tick times for both timers
const int MUSIC_TICK_TIME = 100; //100 microseconds
const int GAME_TICK_TIME = 100; // 100 millieconds

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Game game;
Music music;
Timer game_timer;
Timer music_timer;

///////////// prototypes ///////////////
void init();
void welcome();
void menu();
void how_to_play();
void you_win();
int main();

/**
* @brief initialies all classes and libraries
*/ 
void init()
{
    // need to initialise LCD and Gamepad
    lcd.init();
    lcd.setContrast(0.4);
    pad.init();
    // Initalises Music with data from SoundData.h and game
    music.init(sound_data,NUM_ELEMENTS);
    game.init();

}

/**
* @brief simple splash screen displayed on start-up
*/ 
void welcome()
{

    // Draws Splash Screen
    lcd.drawSprite(0,0,48,84, (int *) splashScreen);
    lcd.refresh();

    // wait flashing LEDs until start button is pressed
    while (!pad.check_event(Gamepad::START_PRESSED)) {
        lcd.setContrast(pad.read_pot());

        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}
/**
* @brief You Win! Screen
*/ 
void you_win()
{
    // Draws Win Screen
    lcd.drawSprite(0,0,48,84, (int *) winScreen);
    lcd.refresh();

    // wait flashing LEDs until START button is pressed
    while (!pad.check_event(Gamepad::START_PRESSED)) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

    main();

}
/**
* @brief Displays instructions on how to play.
*/ 
void how_to_play()
{
    // Gives instructions on how to play
    lcd.clear();
    lcd.printString("Use the joy -",0,0);
    lcd.printString("stick to move.",0,1);
    lcd.printString("Press A to ",0,2);
    lcd.printString("flip gravity.",0,3);
    lcd.printString("Get the flags",0,4);
    lcd.printString("to win!",0,5);
    lcd.refresh();

    // Loop until A button pressed
    while ( !pad.check_event(Gamepad::A_PRESSED) ) {}

    // Return to menu
    menu(); 
}
/**
* @brief Displays main menu
*/
void menu()
{
    // Main Menu
    int menu_option = 0;
    while ( !pad.check_event(Gamepad::A_PRESSED) ) {
        //Allow adjusting of the contrast
        lcd.setContrast(pad.read_pot());

        // Read the joystick value and relate it to a menu option
        if (pad.get_coord().y > 0.7f) {
            menu_option = 0;
        }
        if (pad.get_coord().y < -0.7f) {
            menu_option = 1;
        }
        // Draws main menu background image
        lcd.drawSprite(0,0,48,84, (int *) menuScreen);

        // Draws the arrow on the menu
        if (menu_option == 0) {
            lcd.drawSprite(40,10,7,4, (int *)  arrow);
        } else {
            lcd.drawSprite(40,25,7,4, (int *)  arrow);
        }

        lcd.refresh();

    }
    // If the "how to play" option is selected run its display function
    if (menu_option == 1) {
        how_to_play();
    }
}


/**
* @brief Main Loop
*/
int main()
{

    init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start
    menu();     // main menu

    // Resets and starts the timers responsible for the game and music loops
    game_timer.reset();
    music_timer.reset();
    game_timer.start();
    music_timer.start();


    while (true) {

        // If the game timer is above the game tick time then main game process
        // is ran
        if (game_timer.read_ms() > GAME_TICK_TIME) {
            // Allows adjusting on the contrast
            lcd.setContrast(pad.read_pot());
            // Main update states
            game.update(pad);
            game.draw(lcd);

            // If the games won goes to the you_win screen.
            if (game.game_won()) {
                you_win();

            }
            game_timer.reset();
        }
        // If the music timer is above the music tick time update the music object
        if (music_timer.read_us() > MUSIC_TICK_TIME) {
            music.play_next();
            music_timer.reset();
        }
    }
}