
#include "Music.h"
PwmOut speaker(PTC10);
/**
* @brief Constructor (no paramateters)
*/
Music::Music()
{

}
/**
* @brief Deconstructor
*/
Music::~Music()
{
    
    

}

/**
* @brief Initialiser. Takes the sound data and initialises the buzzer
* @param const int* data @details The audio data. A array of the amplitude of 
* the waveform over time
* @param length @details Length of above sound array 
*/
void Music::init(const int* data,int length)
{
    
    _data = data;
    _length = length;
    speaker.period(0.00003); // Has to << then 1/sample rate
    speaker.write(0); // until music played stay silent
    _index = 0;
}
/**
* @brief Plays the next sound sample. Must be called at the sample rate
*/
void Music::play_next()
{
    double duty_cycle;
    duty_cycle = ((128-_data[_index]*1.7)+128)/256.0;
    //printf("%i = %f\n",_index,duty_cycle);

    if (_index < _length) {      
        speaker.write(duty_cycle);
        
        _index++;
    } else {
        _index = 0;    
    }
        
}


