#include "Game.h"



/**
* @brief Constructor (no paramateters)
*/
Game::Game()
{

}
/**
* @brief Deconstructor
*/
Game::~Game()
{

}

/**
* @brief Loads the specified level.
* @param level_number @details The level number to load.
*/
void Game::load_level(int level_number)
{
    // I would of done this large switch statement with a an array
    // of LevelDefiniton as it would be a lot neater. However this causes 
    // issue with the infamous "empty execution error" bug 
    LevelDefinition level_def;
    switch(level_number) {
        case 1 :
            level_def = level_1;
            break;
        case 2:
            level_def = level_2;
            break;
        case 3:
            level_def = level_3;
            break;
        case 4:
            level_def = level_4;
            break;
        case 5:
            level_def = level_5;
            break;
        case 6:
            level_def = level_6;
            break;
        case 7:
            level_def = level_7;
            break;
        case 8:
            level_def = level_8;
            break;
        case 9:
            // Then the game is complete
            _game_won = true;
            return;


    }
    
    // Initialises the player position
    _player.init(level_def.initial_pos);
    // Initalises level
    _level.init(level_def.blocks,
                level_def.number_of_blocks,
                level_def.goal,
                level_def.moving_blocks,
                level_def.number_of_moving_blocks);
}
/**
* @brief Initalises the game and loads the first level.
*/
void Game::init()
{
    // Loads the first level
    load_level(1);
    _current_level = 1;
    
    _game_won = false;
}

/**
* @brief Updates the game this should be called every frame.  Updates player
* and block positions and loads the next level if the goal is reached.
* @param pad @details the Gamepad object.
*/
void Game::update(Gamepad &pad)
{
    // Update player position based on gamepad presses/ collisions
    _player.update(pad, _level.get_blocks(),_level.get_number_of_blocks());
    // Update location of any moving blocks
    _level.update_moving_blocks();
    
    // If the player has reached the goal
    if (_player.check_goal_reached(_level.get_goal())) {
        // Load next level
        _current_level += 1;
        load_level(_current_level);
    }
}

/**
* @brief Draws the current state on the screen. Should be called every frame.
* @param lcd @details The N5110 lcd object.
*/
void Game::draw(N5110 &lcd)
{
    // Clear screen buffer
    lcd.clear();
    
    // Render Level And Player
    _level.render(lcd);
    _player.render(lcd);
    
    // refresh screen
    lcd.refresh();

}
/**
* @brief Returns if the game has been won.
* @returns True if game won.
*/
bool Game::game_won()
{
    return _game_won;
}
