#ifndef LEVEL_H
#define LEVEL_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"
#include "LevelDefinitions.h"
#include "GoalSprite.h"

/**
* @brief Struct for storing the current location/state of any moving blocks
*/
struct MovingBlock {
    int index;  /**< index of the block that moves in the block array.*/
    int distance; /**< Distance the block moves*/
    
    int initial_pos;  /**< Inital x coord of the block*/
    bool extending; /**< True if the block is currently in its extending phase
                         false if retracting.*/

};

/** Level Class

@brief Class responsible for the handling of levels loading them updating
their state and rendering them.
Levels represent each stage of the game including the player initial location
the goal location and the location of blocks and moving blocks.
@version 1.0

@author Joshua Davy el17jd

@date April 2019

*/

class Level {

public:
    Level();
    ~Level();
    void init(Block blocks [],
              int number_of_blocks,
              Vector2D goal,
              MovingBlockDefinition moving_blocks[],
              int number_of_moving_blocks);
    void update_moving_blocks();
    void render(N5110 &lcd);
    
    Block * get_blocks();
    int get_number_of_blocks();
    Vector2D get_goal();


    
private:  
    void declare_moving_block(int index,bool extending,int distance);
    
    Block _blocks [20] ;
    int _number_of_blocks;
    int _number_of_moving_blocks;
    Vector2D _goal;
    MovingBlock _moving_blocks [10];
};

#endif