#ifndef SPRITE_H
#define SPRITE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"

#define GRAVITY 2


/** Sprite Class

@brief Sprite Class. Handles Sprites, their location,rendering and bitmaps.
@version 1.0

@author Joshua Davy el17jd

@date April 2019

*/

class Sprite {

public:
    Sprite();
    ~Sprite();
    void init(int height,int width, int * bitmap,Vector2D pos);
    void render(N5110 &lcd);
    Vector2D get_pos();
    void set_pos(Vector2D pos);
    void setBitmap(int * bitmap);
    
protected:  //Protected as will need to be accesible by child classes.
    Vector2D _pos;
    int _height;
    int _width;
    int * _bitmap;
};

#endif