 #ifndef GAME_H
#define GAME_H

/*Game Class*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Sprite.h"
#include "Player.h"
#include "Level.h"


/** Game Class

@brief Class for the main game. Responsible for level loading, updating and
drawing the game screen.

@version 1.0

@author Joshua Davy el17jd

@date April 2019

*/

class Game {

public:
    Game();
    ~Game();
    void init();
    void update(Gamepad &pad);
    void draw(N5110 &lcd);   
    bool game_won();
    
private:
    void load_level(int level_number);

    Player _player;
    Level _level;
    int _current_level;
    bool _game_won;
};
#endif