#include "mbed.h"
#include "WakeUp.h"

InterruptIn event(USER_BUTTON);
DigitalOut myled(LED1);

int go_to_sleep = 0;
 
void pressed()
{
    printf("Button pressed\n");
    go_to_sleep = !go_to_sleep;
}

void gotoSleep(int seconds)
{
    //Set wakeup time for seconds
    int s=seconds*1000;
    WakeUp::set_ms(s);
    
    printf("==> Entering deepsleep until %d seconds\n", seconds);
    //Enter deepsleep, the program won't go beyond this point until it is woken up
    deepsleep();
    wait(0.1);
}

void sleepUtilPressed()
{
    printf("==> Entering deepsleep (press user button to resume)\n");
    //sleep();
    deepsleep();
    wait(0.1);
}
 
int main()
{
    int i = 0;
    
    wait(5);
    //The low-power oscillator can be quite inaccurate on some targets
    //this function calibrates it against the main clock
    WakeUp::calibrate();
    
    event.fall(&pressed);
 
    while (1) {
        if (go_to_sleep) {
            myled = 0;
            gotoSleep(2);
            //sleepUtilPressed();
            go_to_sleep=0;
        } else {
            printf("%d: Running\n", i);
            myled = !myled;
            wait(1.0);
        }
        i++;
    }
}
